% !Mode:: "TeX:UTF-8"
%% udesoftec.cls
% Copyright 2013 J. Peter M. Schuler
% 2013-07-09 v1.1 udesoftec
%
% This work may be distributed and/or modified under the
% conditions of the LaTeX Project Public License, either version 1.3
% of this license or (at your option) any later version.
% The latest version of this license is in
%   http://www.latex-project.org/lppl.txt
% and version 1.3 or later is part of all distributions of LaTeX
% version 2005/12/01 or later.
%
% This work has the LPPL maintenance status `maintained'.
% 
% The current Maintainer of this work is J. Peter M. Schuler
% j.peter.m.schuler@uni-due.de
%
% This work consists of the files udesoftec.cls and udesoftec.bst.
%
% As this work is based on years of mostly undocumented improvement, 
% it includes parts, for which sources can't be identified anymore. Public postings
% in the LaTeX community were used as an input and if source is known, it is
% mentioned below. If anybody identifies parts of his/her own code,
% feel free to contact the maintainer in order to get listed. 
%
% Special thanks to all contributors and for the help of the tex-live team,
% e.g. Axel K.; Norbert P.; Rainer S.; Reinhard K.; Robin F.
%
% For further information refer to:
% http://mirrors.ctan.org/macros/latex/contrib/udesoftec/README
% and
% http://mirrors.ctan.org/macros/latex/contrib/udesoftec/udesoftec.doc.pdf
\NeedsTeXFormat{LaTeX2e}%
\ProvidesClass{udesoftec}[2013/06/28 University of Duisburg-Essen, Research Group for Business Informatics and Software Engineering Thesis documentclass and bibstyle]%
\LoadClass[%
	%titlepage=true,
	twoside=true,
	headings=openright,															% same as documentclassoption openany/openright
	numbers=noenddot,                 							% section numbering without dot
	bibliography=totoc,index=totoc,listof=totoc,		% put everything relevant in toc
%	headinclude=false,                							% changes auto-margin-calc to exclude headers. makes sense
%	footinclude=false,                							% 	if the header or footer uses a sepline
	]{scrbook}
\KOMAoptions{
	headlines=1.5                                   % the size of the header in lines (1.5 because of pagemark and sepline); 1.25 is default; 1 would be appropriate if only text and no sepline)
}
\pdfminorversion=6
\newif\ifdebugThisClass
\debugThisClasstrue
\debugThisClassfalse
\newcommand{\classdebug}[1]{\ifdebugThisClass\ClassWarning{udesoftec}{#1}\fi}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% all template conditions %%%%%%
\newif\ifdocumentIsFinal
\newif\iftemplateUseSansSerifFont
\newif\iftemplateUseBookLayout
\newif\iftemplateFakeBookLayout
\newif\iftemplateAddChapterToFigureNumbering
\newif\iftemplateUseCustomMaketitle
\newif\ifdocumentHasConfidentialityClause
\newif\ifprimaryDocumentLanguageGerman
\newif\iftemplateUseColorfulLinks

\newif\iftemplateVawi
\newif\iftemplateVawiEssen
\newif\iftemplateVawiBamberg

\newif\ifdocumentOmitLOT
\newif\ifdocumentOmitLOF

\newif\iftemplateDocumentLayoutChoosen
\templateDocumentLayoutChoosenfalse

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% all default values and the options %%%%%
\documentIsFinalfalse
\DeclareOption{draft}{\documentIsFinalfalse}
\DeclareOption{final}{\documentIsFinaltrue}
\documentOmitLOTfalse
\documentOmitLOFfalse
\DeclareOption{omit-lot}{\documentOmitLOTtrue}
\DeclareOption{omit-lof}{\documentOmitLOFtrue}

\templateUseColorfulLinksfalse
\templateUseSansSerifFontfalse	
\templateFakeBookLayoutfalse			
\templateUseBookLayouttrue							
\DeclareOption{printlayout}{
	\templateUseColorfulLinksfalse
	\templateUseSansSerifFontfalse	
	\templateFakeBookLayoutfalse			
	\templateUseBookLayouttrue				
	\templateDocumentLayoutChoosentrue
}
\DeclareOption{screenlayout}{
	\templateUseBookLayoutfalse
	\templateUseSansSerifFonttrue
	\templateUseColorfulLinkstrue
	\templateDocumentLayoutChoosentrue
}
\DeclareOption{screenwithprintpaginglayout}{
	\templateUseBookLayoutfalse
	\templateUseSansSerifFonttrue
	\templateUseColorfulLinkstrue
	\templateFakeBookLayouttrue
	\templateDocumentLayoutChoosentrue
}
\templateVawifalse
\templateVawiEssenfalse
\templateVawiBambergfalse
\DeclareOption{vawiessen}{
  \templateVawitrue
  \templateVawiEssentrue
}
\DeclareOption{vawibamberg}{
  \templateVawitrue
  \templateVawiBambergtrue
}
\DeclareOption*{\ClassWarning{udesoftec}{Unknown option \CurrentOption}}

\templateAddChapterToFigureNumberingfalse
\templateUseCustomMaketitletrue    
\documentHasConfidentialityClausefalse   
\bibliographystyle{udesoftec}

\primaryDocumentLanguageGermantrue
\DeclareOption{de}{\primaryDocumentLanguageGermantrue}
\DeclareOption{en}{\primaryDocumentLanguageGermanfalse}

%%%% labels %%%%

\title{Komplexer Titel einer Abschlussarbeit f\"ur ein Dokument}
\author{Max Mustermann}
\def \city{Essen}
\def \typeofdoc{Masterarbeit}
\def \labelPreTopic{zum Thema}
\def \labelRespectConfidentiality{(Sperrvermerk beachten)}
\def \academicfield{Wirtschaftsinformatik}
\def \institution{Vorgelegt der Fakult\"at f\"ur Wirtschaftswissenschaften\par der Universit\"at Duisburg-Essen}
\def \semester{Wintersemester 2011/2012, 8. Fachsemester \academicfield}                               
\def \entitle{Englischer Titel der Arbeit}                                                                
\def \confidentialitySource{Name der Firma, die auf die Vertraulichkeitserkl\"arung besteht}
\date{Version: \today}
\def \authorbox{
\begin{tabularx}{.7\linewidth}{ll}
  von:&Max Mustermann\\
	    &Musterstrasse 123\\
			&12345 Musterstadt\\
	\\
  Gutacher:&Prof. Dr. Stefan Eicker\\
	         &Prof. Dr. John Doe\\
	\\
	Betreuer:&Dipl.-Wirt.-Inf Some Body\\
	\\
\end{tabularx}	
}
\def \templatePageMarkPrefix {} 	              % might be something like "S. "


\ProcessOptions\relax


\ifprimaryDocumentLanguageGerman
  \def \templateTitlePageBackground{udesoftec-cover-ude-de}
\else
  \def \templateTitlePageBackground{udesoftec-cover-ude-en}
\fi

\iftemplateVawiBamberg
	\def \templateTitlePageBackground{udesoftec-cover-uba}
\fi

\iftemplateVawiEssen
	\def \institutionDefault{Im Virtuellen Weiterbildungsstudiengang Wirtschaftsinformatik\par der Universit\"at Duisburg-Essen}
	\def \institution{\institutionDefault}
  \def \labelPreTopic{}
\fi
\iftemplateVawiBamberg
	\def \institutionDefault{Im Virtuellen Weiterbildungsstudiengang Wirtschaftsinformatik}
  \def \institution{\institutionDefault}
  \def \labelPreTopic{}
\fi
	
\iftemplateDocumentLayoutChoosen
\else
\ClassWarning{udesoftec}{No layout choosen. Use printlayout, screenlayout or screenwithprintpaginglayout.}
\ClassWarning{udesoftec}{Falling back to printlayout}
\fi

%%%% xcolor %%%%%%%%%%
% purpose: define some color names
\usepackage[svgnames]{xcolor}
%%%%%%%%%%%%%%%%%%%%%%
%%%% customcolors %%%%
% purpose: have every color defined in one place
% special: color1!percent!color2 mixes two colors (easier as pseudo-names or rgb)
%          percent * color1 + (100-percent) * color2
\definecolor{UDEblue}{RGB/cmyk}{0,76,147/1,.68,0,.12}
\definecolor{UDEbeige}{RGB/cmyk}{239,228,191/0,.03,.19,.06}
\definecolor{UDEbrightblue}{RGB/cmyk}{223,228,242/.15,.09,0,0}
\colorlet{allchaptercolor}{black}

		
\colorlet{listingBackground}{white!50!UDEbeige}
\colorlet{documentTitle}{black}
\colorlet{parExample}{UDEbrightblue} 	

\colorlet{chapter}{allchaptercolor} 				% for all chapters, toc etc 
\colorlet{section}{allchaptercolor} 				% for all chapters, toc etc 
\colorlet{subsection}{allchaptercolor} 				% for all chapters, toc etc 

\colorlet{ChapterHeadingBigChapterNumber}{allchaptercolor}		% for the special chapter title page design
\colorlet{ChapterHeadingSmallChapterNumer}{allchaptercolor}		% for the special chapter title page design
\colorlet{ChapterHeadingSeperatorLine}{allchaptercolor}		% for the special chapter title page design
\colorlet{Todo}{orange!30!white}									%default color for todo notes
\colorlet{Headsepline}{UDEblue} 						% seperator between header and text body
\colorlet{PagemarkBackground}{UDEblue}
\colorlet{PagemarkText}{white}										% page number color
\colorlet{HeadmarkText}{black}				% textcolor of header text (chapters, sections)
\colorlet{Good}{DarkGreen}										% page number color
\colorlet{Bad}{DarkRed}				% textcolor of header text (chapters, sections)

\iftemplateUseColorfulLinks
	\colorlet{LinkExternal} {black!75!green}				% URLs in text and bibliography
	\colorlet{LinkDoi} {black!75!green}										% links to doi in bibliography
	\colorlet{LinkInternal} {black!30!UDEblue} 			% internal links are from TOC or references in text
	\colorlet{LinkBibliography} {black!30!UDEblue} 	% links in citation
	\colorlet{LinkAnchor} {black} 								% not used
\else
	\colorlet{LinkExternal}{black}				% URLs in text and bibliography
	\colorlet{LinkDoi}{black}										% links to doi in bibliography
	\colorlet{LinkInternal}{black} 			% internal links are from TOC or references in text
	\colorlet{LinkBibliography}{black!30!UDEblue} 	% links in citation
	\colorlet{LinkAnchor}{black} 								% not used
\fi


\ifprimaryDocumentLanguageGerman
\else
\def \templateTitlePageBackground{udesoftec-cover-en}
\def \typeofdoc{Master Thesis}
\def \labelPreTopic{about the topic}
\def \labelRespectConfidentiality{(Sperrvermerk beachten)}
\def \academicfield{Business Information Systems}
\def \institution{Presented to the Faculty of Economics and Business Administration\par of  University of Duisburg-Essen}
\def \semester{Winter semester 2011/2012, 8th Semester  in \academicfield}                                                                
\def \confidentialitySource{Name der Firma, die auf die Vertraulichkeitserkl\"arung besteht}
\date{Version: \today}
\def \authorbox{
\begin{tabularx}{.7\linewidth}{ll}
  Author:&Max Mustermann\\
	    &Musterstrasse 123\\
			&12345 Musterstadt\\
	\\
  Examiner:&Prof. Dr. Stefan Eicker\\
	         &Prof. Dr. John Doe\\
	\\
	Supervisor:&Dipl.-Wirt.-Inf Some Body\\
	\\
\end{tabularx}	
}
\fi

\ifprimaryDocumentLanguageGerman
	\def \@documentLanguage{english,ngerman}         % all used languages, primary LAST
\else
	\def\@documentLanguage{ngerman,english}
\fi

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\iftemplateUseBookLayout
	\KOMAoptions{twoside=true} 
\else
	\KOMAoptions{twoside=false}
\fi
\iftemplateFakeBookLayout
	\KOMAoptions{twoside=semi} 
\fi
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55
% http://www.golatex.de/nummerierung-der-fussnoten-durchgehend-im-gesamten-dokument-t2042.html
% change counters for figures, footnotes, etc
\usepackage{chngcntr} 
\counterwithout{footnote}{chapter} % count footnotes for whole document, not per chapter

%%%% l18n %%%%%%%%%%%%% 
% purpose: localization and utf-8 config
% babel has primary language last
\usepackage[\@documentLanguage]{babel}
\usepackage[utf8]{inputenc}
\usepackage[T1]{fontenc}
\usepackage{hyphenat}  % helps with \nohyphens command, which allows to remove hypens from quotes.
%%%%%%%%%%%%%%%%%%%%%%

%%%% helvet %%%%%%%%%%
% purpose: use helvetica
% special load font before fontenc!
\iftemplateUseSansSerifFont
	\usepackage[scaled]{helvet}
	\renewcommand*\familydefault{\sfdefault}
\else
	\usepackage{lmodern} 
	\renewcommand*\familydefault{\rmdefault}
% KOMAfont Definitionen: caption captionlabel chapter chapterentry chapterentrypagenumber chapterentry chapterprefix dictum dictumauthor dictumtext  disposition footnote footnotelabel footnotereference footnoterule labelinglabel labelingseparator  minisec pagefoot pagehead pageheadfoot pagenumber pagination paragraph  part partentry partentrypagenumber partentry partnumber section sectionentry sectionentrypagenumber sectionentry sectioning subject subparagraph subsection subsubsection subtitle title
\fi
	\setkomafont{descriptionlabel}{\normalfont\bfseries}
	\setkomafont{dictumtext}{\normalfont\normalcolor\small}
	\setkomafont{disposition}{\normalfont\normalcolor\bfseries}
	\setkomafont{caption}{\normalfont\normalcolor\scriptsize}
%%%%%%%%%%%%%%%%%%%%%%

%%%% page layout %%%%%
% purpose: set page margins, textbody size etc
% usage:   typearea[BCOR]{DIV}
%          DIV is auto-calculation of all margins in depencedy of font size
% 				 10pt = DIV 8;11pt = DIV 10;12pt = DIV 12
%	         BCOR is additional inner margin (binding correction)
% special: BCOR adds inner margin and reduces text space. As the default margin sum seems fine we use geometry instead
%          to adjust for regular printing (e.g. use in a folder), see below "geometry"
\iftemplateUseSansSerifFont
	\typearea[0mm]{10} % for helvetica	
\else
	\typearea[0mm]{8} % for default latex font
\fi
%%%%%%%%%%%%%%%%%%%%%%
%%%% setspacing %%%%%%
% purpose: give options for changing line spacing \doublespacing, \singlespacing, 
%          \onehalfspacing
\usepackage[onehalfspacing]{setspace}
%%%%%%%%%%%%%%%%%%%%%%
%
%%%% setspacing %%%%%%
 %special: novbox in order for tabularx to get correct width
%\ifdocumentIsFinal
%\else
%\usepackage[novbox]{pdfsync}
%\fi
%%%%%%%%%%%%%%%%%%%%%%

%%%% nag %%%%%%%%%%%%% 
% purpose: identifies depricated code and suggests better pckgs
% source:  http://www.tug.org/texlive/Contents/live/texmf-dist/doc/latex/nag/nag.pdf
\RequirePackage[l2tabu, orthodox]{nag}
%%%%%%%%%%%%%%%%%%%%%%

%%%% microtype %%%%%%
% purpose: character protrusion (also known as margin kerning) and font expansion 
% purpose-de: optischen Randausgleich verwenden. Beispiele siehe Doku http://kambing.ui.ac.id/ctan/macros/latex/contrib/microtype/microtype.pdf Seite 4 Randnotiz
% source: http://kambing.ui.ac.id/ctan/macros/latex/contrib/microtype/microtype.pdf
\usepackage{microtype} 
%%%%%%%%%%%%%%%%%%%%%%

%%%% fixltx2e %%%%%%%%
% purpose: removes some Bugs in LaTeX2e (removes some stupid backwards compatibility)
% source:  http://www.ctan.org/tex-archive/help/Catalogue/entries/fixltx2e.html#Dist
\usepackage{fixltx2e}          
%%%%%%%%%%%%%%%%%%%%%%

%%%% graphicx %%%%%%%%
% purpose: allows better graphics import
% special: if we just dont use DeclareGraphicsExtensions and have folders for eps and pdf
%          Latex2dvi will always use eps and Latex2pdf always pdf
\usepackage[pdftex]{graphicx}%
\graphicspath{{Images/pdf/}}
%%%%%%%%%%%%%%%%%%%%%%


%%%% footmisc %%%%%%%%
% purpose: repair footnote indent - first line and second line should start with same space
\usepackage[marginal]{footmisc}
%%%%%%%%%%%%%%%%%%%%%%

%%%% floatbarrier %%%%
% purpose: keep images, tables and other floating stuff in the same section
%
\usepackage[section]{placeins}
%%%%%%%%%%%%%%%%%%%%%%

%%%% tabularx %%%%%%%%
% purpose: Tabularx berechnet in dem Fall drei gleich breite Spalten so, dass die Tabelle insgesamt
%          die Breite textwidth einnimmt. RaggedRight setzt das ganze dann im Flattersatz mit
%          Silbentrennung. Definiert man neue Spaltentypen, so benötigt man den Befehl arraybackslash
%          damit der \\-Befehl zum Beenden der Zeile funktioniert (ganz genau weiß ich's aber auch
%          nicht).
% source:  http://mrunix.de/forums/showthread.php?t=56679
\usepackage{ragged2e, tabularx}
%\usepackage{tabularx}
%\newcolumntype{Y}{>{\RaggedRight\arraybackslash}X}
%%%%%%%%%%%%%%%%%%%%%%



%%%% expdlist %%%%%%%%
%% purpose: give description environment some optional parameters for better layout
%% http://www.cs.brown.edu/system/software/latex/doc/expdlist.pdf
\usepackage{expdlist}
%%%%%%%%%%%%%%%%%%%%%%

% !Mode:: "TeX:UTF-8"
%%% natbib %%%%%%%%%%
% purpose: real cite options (in parentheses, out of parentheses, suppressing author etc)
\usepackage[elide]{natbib}	
%%%%%%%%%%%%%%%%%%%%%

%%% bibstyleconf %%%%
% based on: natbib plainnat
% purpose:  plainnat-peet changes natbib plainnat for using \bbland with cite instead of 
%           fixed string and changes authors in bibliography to "ll, f; ll, f; ll, f"'
\bibpunct{(}{)}{;}{a}{}{}{} 
\newcommand*{\doi}[1]{\href{http://dx.doi.org/#1}{\color{LinkDoi}doi:\detokenize{#1}}} %use real doi links with doi:<num> as label
\newcommand{\bblisbn}[1]{\small{ISBN:\mbox{#1}}}
\newcommand{\bblissn}[1]{\small{ISSN:\mbox{#1}}}
\newcommand{\bbland}{\& }
\newcommand{\bblAuthorYearSep}{ } % possible to add \newline 
\newcommand{\bblAuthorTitleSep}{: } % possible to add \newline 
\newcommand{\bblAuthorTitleSepInEd}{: }
\providecaptionname{ngerman}{\bblin}{In: }%
\providecaptionname{english}{\bblin}{In: }%
\providecaptionname{ngerman}{\bbled}{~(Hrsg.)}%
\providecaptionname{english}{\bbled}{~(Ed.)}%
\providecaptionname{ngerman}{\bbleds}{~(Hrsg.)}%
\providecaptionname{english}{\bbleds}{~(Eds.)}%
\providecaptionname{ngerman}{\bbledn}{~Aufl.}%
\providecaptionname{english}{\bbledn}{~edn}%
\providecaptionname{ngerman}{\bbletal}{et~al.}%
\providecaptionname{english}{\bbletal}{et~al.}%
\providecaptionname{ngerman}{\bblpp}{S.~}%
\providecaptionname{english}{\bblpp}{pp.}%
\providecaptionname{ngerman}{\bblp}{S.~}%
\providecaptionname{english}{\bblp}{p.~}%
\providecaptionname{ngerman}{\bblvol}{Nr.}%
\providecaptionname{english}{\bblvol}{No}%
\providecaptionname{ngerman}{\bblof}{von}%
\providecaptionname{english}{\bblof}{of}%
\providecaptionname{ngerman}{\bblnoyear}{o.J.}%
\providecaptionname{english}{\bblnoyear}{n.d.}%
\providecaptionname{ngerman}{\bblnoyearlong}{ohne Jahresangabe}%
\providecaptionname{english}{\bblnoyearlong}{no date}%
\providecaptionname{ngerman}{\bbllastaccesswas}{Zuletzt geprüft }%
\providecaptionname{english}{\bbllastaccesswas}{Last checked }%

\renewcommand*{\bibfont}{\raggedright}
\newcommand{\bblurldate}[1]{ (\bbllastaccesswas #1)}
\newcommand{\bblVolumeOfSeries}[2]{ (#2~#1)}
\newcommand{\bblSeries}[1]{ (#1)}
\newcommand{\bblFontAuthorInText}[1]{\nohyphens{\textsc{#1}}}
\newcommand{\bblFontAuthorInList}[1]{\textbf{#1}}
\newcommand{\bblFontYearInList}[1]{\textbf{(#1)}}
\newcommand{\bblFontBookTitle}[1]{\emph{#1}}
\newcommand{\bblFontInBookTitle}[1]{#1}
\newcommand{\bblFontJournalTitle}[1]{#1}
\newcommand{\bblWarning}[2]{
	\message{LaTeX Warning: Error with citation of #2 -- #1 }%
	\textbf{\emph{\color{red}{BibError: #2 -- #1}}}%
}
%\renewcommand{\bblWarning}[1]{} %for production
\newcommand{\bblyear}[1]{\ifnumber{#1}{#1}{\bblnoyear}}

\newcommand{\bbledGenerateEdition}[1]{\ifnumber{#1}{\bbledOrdinal{#1}~\bbledn}{#1}}

\newcommand*{\englishordinal}[1]{\ifcase #1\or 1\textsuperscript{st}\or 2\textsuperscript{nd}\or 3\textsuperscript{rd}\else #1\textsuperscript{th}\fi}
\newcommand*{\germanordinal}[1]{#1.}
\iflanguage{ngerman}{%
	\newcommand*{\bbledOrdinal}[1]{\germanordinal{#1}}
}{%
	\newcommand*{\bbledOrdinal}[1]{\englishordinal{#1}}
}

%http://www.tug.org/applications/hyperref/manual.html#TBL-23
%evtl mit \addto\extrasngerman{%  
  %\def\subsectionautorefname{Unterkapitel}%  
%}

\setlength{\bibhang} {2em} %hanging indentation for list of references
\setlength{\bibsep} {.5em} %vertical sep between bibitems in list of references
%\renewcommand{\bibfont}{\small}
%\renewcommand{\bibfont}{\sc}
%%%%%%%%%%%%%%%%%%%%%

%http://tex.stackexchange.com/questions/9325/bump-right-aligned-text-to-next-line-if-no-room
\newcommand\putRightIfRoom[1]{{%
  \leftskip=0ptplus1fil\rightskip=-\leftskip\parfillskip=\leftskip%
  \hfill \phantom{ } \mbox{#1}\par}}

\newcommand{\citequotepar}[3][]
{
\begin{addmargin}{2em}%
\vspace*{1em}
\sloppy{\small\nohyphens{\glqq#3\grqq}}\putRightIfRoom{\small\cite[#1]{#2}}%
\vspace*{1em}
\end{addmargin}%
}



\newcommand{\blockquote}[3][]{
\message{LaTeX Warning: \noexpand\blockquote is deprecated, use \noexpand\citequotepar on input line \the\inputlineno }
\citequotepar[#1]{#2}{#3}
}

\newcommand{\intextquote}[3][]{
\message{LaTeX Warning: \noexpand\intextquote is deprecated, use \noexpand\citequote on input line \the\inputlineno }
\citequote[#1]{#2}{#3}}
\newcommand{\inlinequote}[3][]{
\message{LaTeX Warning: \noexpand\intextquote is deprecated, use \noexpand\citequote on input line \the\inputlineno }
\citequote[#1]{#2}{#3}}
\newcommand{\citequote}[3][]{\glqq#3\grqq \ \cite[#1]{#2}}

% !Mode:: "TeX:UTF-8"
%%%% todonotes %%%%%%%
% purpose: get (orange) todo comments in text or in margin
% use option "disable" to disable the complete packages (leaving all commands intact, just removing output)
\usepackage[
ngerman,
textsize=footnotesize,
backgroundcolor=Todo,
colorinlistoftodos
]{todonotes}%
%% alternative for deactivation:
%\newcommand*{\todo}[2][]{}
%\newcommand*{\listoftodos}[1][]{}
%\newcommand*{\missingfigure}[2][]{}

\let\defaultTodo\todo
\renewcommand{\todo}[1]{%
\defaultTodo[fancyline]{#1}%
}
\newcommand*{\todoDesign}[1]{%
\defaultTodo[fancyline,backgroundcolor=LightGreen]{#1}%
}
\newcommand*{\todoText}[1]{%
\defaultTodo[fancyline,backgroundcolor=LightBlue]{#1}%
}
\newcommand*{\todoFigure}[1]{%
\defaultTodo[fancyline,backgroundcolor=LightYellow]{#1}%
}
\newcommand{\inlinetodo}[1]{\defaultTodo[inline]{#1}}
\newcommand{\todoinline}[1]{\defaultTodo[inline]{#1}}

\let\defaultListoftodos\listoftodos
\renewcommand{\listoftodos}{
	\let\originalHbadness\hbadness
	\hbadness 100000
	\defaultListoftodos
	\hbadness \originalHbadness
}

% !Mode:: "TeX:UTF-8"

%%%% chapterdseign %%%
% purpose: have some nice chapter headings (big number, lines and so on)
% we need type1cm and cm-super for the bigger fonts - else there would be warnings
\usepackage{type1cm}
\usepackage{fix-cm}
\addtokomafont{chapter}{\color{chapter}}
\addtokomafont{sectioning}{\color{section}}
\addtokomafont{subsubsection}{\color{subsection}}
\makeatletter% siehe De-TeX-FAQ
\renewcommand*{\chapterformat}{%
\begingroup% damit \unitlength-Änderung lokal bleibt
\setlength{\unitlength}{1mm}%
\begin{picture}(20,40)(0,5)%
\setlength{\fboxsep}{0pt}%
%\put(0,0){\framebox(20,30){}}%
%\put(0,20){\makebox(20,20){\rule{20\unitlength}{20\unitlength}}}%
\put(20,15){\color{ChapterHeadingSeperatorLine}\line(1,0){\dimexpr
\textwidth-20\unitlength\relax\@gobble}}%
\put(-6,2.5){\makebox(20,20)[r]{%
\fontsize{23\unitlength}{28\unitlength}\selectfont\color{ChapterHeadingBigChapterNumber}\thechapter
%\kern-.04em% Ziffer in der Zeichenzelle nach rechts schieben
}}%
\put(20,15){\makebox(\dimexpr
\textwidth-20\unitlength\relax\@gobble,\ht\strutbox\@gobble)[l]{%
\ifdefined\chapterAuthor
\ \normalsize\color{ChapterHeadingSmallChapterNumer}\chapterAuthor\autodot
\else
%\ \normalsize\color{ChapterHeadingSmallChapterNumer}\chapapp~\thechapter\autodot
\ \normalsize\color{ChapterHeadingSmallChapterNumer}\chapapp~\autodot
\fi
}}%
\end{picture} % <-- Leerzeichen ist hier beabsichtigt!
\endgroup
}
%%%%%%%%%%%%%%%%%%%%%%

% !Mode:: "TeX:UTF-8"
	\renewcommand{\headfont}{\normalfont\small\color{HeadmarkText}} % header text should be small
	\renewcommand{\pnumfont}{\normalfont\small\color{PagemarkText}} % pagenumber is in header and should be small too

%%%% scrpage2 %%%%%%%%
% purpose: customize page styles (header, footer)
\usepackage{scrpage2}% 
% default page behaviour: header has line, chap.section left; page right
\pagestyle{scrheadings}
\clearscrheadings
\clearscrplain
\clearscrheadfoot
% change color of headsepline
\addtokomafont{headsepline}{\color{Headsepline}}
\setheadsepline{.4pt}%{\color{Headsepline}}

% create headermarks so the chapter is shown on left page and section on right


% new pagestyle "chapter": pagenumber top outer, no line no headmark
\iftemplateUseBookLayout
		\ihead[\headmark]{\headmark}
		% clear outer head (where the normale pagemark is in)
		\ohead[]{}
		% add pageMark boxes to leftpage lefthead and rightpage righthead (pagemark box needs to know "r" or "l"
		\rohead[]{\pagemarkBox{\pagemark}{r}}
		\lehead[]{\pagemarkBox{\pagemark}{l}}

		\classdebug{using headline for booklayout}
		\automark[section]{chapter}
		\defpagestyle{chapter}{
		(0pt,0pt)
			{\pagemarkBox{\pagemark}{l}\hfill}
		{\hfill\pagemarkBox{\pagemark}{r}}
			{\pagemarkBox{\pagemark}{r}\hfill}
		(0pt,0pt)
		}{{}{}{}}
\else
		\ihead[]{}
		\ohead[]{}
		\lehead[\headmark]{\headmark}
		\rehead[]{\pagemarkBox{\pagemark}{r}}
		\lohead[\headmark]{\headmark}
		\rohead[]{\pagemarkBox{\pagemark}{r}}
		\classdebug{using headline for screenlayout}
		\automark[chapter]{chapter}
		\defpagestyle{chapter}{
		(0pt,0pt)
			{\hfill\pagemarkBox{\pagemark}{r}}
		{\hfill\pagemarkBox{\pagemark}{r}}
			{\hfill\pagemarkBox{\pagemark}{r}}
		(0pt,0pt)
		}{{}{}{}}
\fi
% custom page behavior for title, part and chapter
\renewcommand*{\titlepagestyle}{empty}
\renewcommand*{\partpagestyle}{empty}
\renewcommand*{\chapterpagestyle}{chapter}
%%%%%%%%%%%%%%%%%%%%%%

%%%% custom pagemark %%%%%%%%%%%%%%%%%%%%%%%
%\newcommand{\pagemarkBox}[2] {	
  %% the picture has height 0 to change clipping behavior, else the clipping box might be higher than the text line
	%\begin{picture}(50,0) 
	%\put(.38,-5.4) {
		%\put(-2.8,.3){\color{PagemarkBackground}\rule{56pt}{16pt}}%
		%\put(5,1){\makebox(40,16)[#2]{\textcolor{PagemarkText}\templatePageMarkPrefix\fontseries{b}\fontshape{n}\selectfont #1}}%
		%}
	%\end{picture}
%}
\newcommand{\pagemarkBox}[2] {	
  % the picture has height 0 to change clipping behavior, else the clipping box might be higher than the text line
	\begin{picture}(50,0) 
	\put(-.55,-5.05) {
		\put(-2.8,.3){%these relate box to text
		\color{PagemarkBackground}\rule{56.7pt}{16pt}}%
		\put(5,1){%these relate box to text
		\makebox(40,16)[#2]{\textcolor{PagemarkText}\templatePageMarkPrefix\fontseries{b}\fontshape{n}\selectfont #1}}%
		}
	\end{picture}
}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% !Mode:: "TeX:UTF-8"
\iftemplateUseCustomMaketitle
%\fi
	\usepackage{wallpaper}
	% 8pt lmodern 
	%   top=37.13mm,bottom=69.27mm
	%   left=26.25mm,right=52.5mm
	%   inner=26.25mm,outer=52.5mm
	% 10pt helvetica
	%   top=37.13mm,bottom=69.27mm,
	%   left=30.00mm,right=52mm
	%   inner=30.00mm,outer=52mm
	%
% for print  \linewidth is 373.44249pt which is also 5.16833in and 131.24847mm.
% for screen  \linewidth is 362.7727pt which is also 5.02066in and 127.49852mm
\newlength{\imagewidth}
\setlength\imagewidth{373.44249pt}
\def\imageSizeAdjust{0mm}

\iftemplateUseBookLayout
	\iftemplateUseSansSerifFont \ClassWarning{udesoftec}{BookLayout with sans serif font makes no sense}
	\else	
		\classdebug{print - book layout with serif font}
		\usepackage[includehead=false,includefoot=false,top=37.13mm,bottom=69.27mm,inner=26.25mm,outer=52.5mm]{geometry}
	\fi
\else
	\iftemplateUseSansSerifFont 
		\iftemplateFakeBookLayout 
			\classdebug{screenfakebook - oneside layout with sans serif font and book paging}
			\usepackage[includemp=false,includehead=false,includefoot=false,asymmetric,top=37.13mm,bottom=69.29mm,left=30.00mm,right=52.50mm]{geometry}
		\def\imageSizeAdjust{3.74995mm}
		\else 
			\classdebug{screen - oneside layout with sans serif font}
			\usepackage[includemp=false,includehead=false,includefoot=false,top=37.13mm,bottom=69.27mm,left=29.50mm,right=52.50mm]{geometry}
		\fi
	\else	
		\classdebug{deprecated - screen layout with serif font}
		\ClassWarning{udesoftec}{screen layout with serif font makes no sense}
		\usepackage[includemp=false,includehead=false,includefoot=false,top=37.13mm,bottom=69.27mm,left=26.25mm,right=52.5mm]{geometry}
	\fi	
\fi


	\renewcommand{\maketitle}{

		\newgeometry{bottom=1cm, inner=0cm,outer=0cm,top=4cm}
		
  \begin{titlepage}
			\begin{center}
				\ThisCenterWallPaper{1}{\templateTitlePageBackground}
				\vspace*{50pt}
					\begin{minipage}[30em]{.7\linewidth}
						\begin{center}
							\Large\typeofdoc\normalsize

							\labelPreTopic
							
							{\color{documentTitle}\Huge\singlespacing\textbf{\@title}\par}
							{\color{documentTitle}\huge\singlespacing\textbf{\@subtitle}\par}			
							\vspace*{20pt}				
							{\color{documentTitle}\large\singlespacing\textbf{\entitle}\par}
							
							\vspace*{50pt}
								
							\large\institution
						\end{center}
					\end{minipage}
								\vfill
				
							
				\begin{minipage}{.7\linewidth}
					\begin{center}
					\ifdocumentHasConfidentialityClause
				 \labelRespectConfidentiality
				
					\fi				
						\vspace*{20pt}\Large\@date
					\end{center}
					\vspace*{40pt}
				\end{minipage}
				\authorbox
				\begin{minipage}{.7\linewidth}
					\begin{center}
								
					\vspace*{50pt}
					\large\semester 
					\end{center}
				\end{minipage}
			\end{center}

		
  \end{titlepage}
		\restoregeometry
	}
\iftemplateVawiBamberg

	\renewcommand{\maketitle}{

		\newgeometry{bottom=1cm, left=2cm,right=1cm,top=4cm}
		
  \begin{titlepage}
			\begin{center}
				\ThisCenterWallPaper{1}{\templateTitlePageBackground}
				\vspace*{0pt}
					\begin{minipage}[30em]{.7\linewidth}
						\begin{center}

							
							{\color{documentTitle}\Huge\singlespacing\textbf{\@title}\par}
							{\color{documentTitle}\huge\singlespacing\textbf{\@subtitle}\par}			
							\vspace*{20pt}				
							{\color{documentTitle}\large\singlespacing\textbf{\entitle}\par}
							
							\vspace*{50pt}
							\hrule
							\vspace*{20pt}
								\Large\textbf{\typeofdoc}\normalsize
							
							\large\institutionDefault
						
							\vspace*{20pt}
							\hrule
							\vspace*{20pt}
							\end{center}
					\end{minipage}
								\vfill
				
							
				\begin{minipage}{.7\linewidth}
					\begin{center}
					\ifdocumentHasConfidentialityClause
				 \labelRespectConfidentiality
				
					\fi				
						\vspace*{20pt}\Large\@date
					\end{center}
					\vspace*{40pt}
				\end{minipage}
				\authorbox
				\begin{minipage}{.7\linewidth}
					\begin{center}
								
					\vspace*{50pt}
					\large\semester 
					\end{center}
				\end{minipage}
			\end{center}

		
  \end{titlepage}
		\restoregeometry
	}
\fi

\let\oldmaketitle\maketitle

\renewcommand{\maketitle}{
	\let\oldhbadness\hbadness
	\let\oldvbadness\vbadness
	\hbadness=10000
	\vbadness=10000
	\oldmaketitle
	\let\hbadness\oldhbadness
	\let\vbadness\oldvbadness
}

\fi

% !Mode:: "TeX:UTF-8"
% special: don't change marginpar, else it will create overfuls with package todonotes
\usepackage{marginnote}
\ifx\marginfont\undefined
	\newcommand{\marginfont}[1]{}
	\newcommand{\marginnote}[2][]{\marginpar[#1]{#2}}
\fi
\iftemplateFakeBookLayout
%redefine marginnote command to obey komas "twoside=semi"
\makeatletter
\long\def\@mn@@@marginnote[#1]#2[#3]{%
  \begingroup
    \ifmmode\mn@strut\let\@tempa\mn@vadjust\else
      \if@inlabel\leavevmode\fi
      \ifhmode\mn@strut\let\@tempa\mn@vadjust\else\let\@tempa\mn@vlap\fi
    \fi
    \@tempa{%
      \vbox to\z@{%
        \vss
        \@mn@margintest
        \if@reversemargin\if@tempswa
            \@tempswafalse
          \else
            \@tempswatrue
        \fi\fi
          \rlap{%
            \ifx\@mn@currxpos\relax
              \kern\marginnoterightadjust
              \if@mn@verbose
                \PackageInfo{marginnote}{%
                  xpos not known,\MessageBreak
                  using \string\marginnoterightadjust}%
              \fi
            \else\ifx\@mn@currxpos\@empty
                \kern\marginnoterightadjust
                \if@mn@verbose
                  \PackageInfo{marginnote}{%
                    xpos not known,\MessageBreak
                    using \string\marginnoterightadjust}%
                \fi
              \else
                \if@mn@verbose
                  \PackageInfo{marginnote}{%
                    xpos seems to be \@mn@currxpos,\MessageBreak
                    \string\marginnoterightadjust
                    \space ignored}%
                \fi
                \begingroup
                  \setlength{\@tempdima}{\@mn@currxpos}%
                  \kern-\@tempdima
                  \if@twoside\ifodd\@mn@currpage\relax
                      \kern\oddsidemargin
                    \else
                      \kern\evensidemargin
                    \fi
                  \else
                    \kern\oddsidemargin
                  \fi
                  \kern 1in
                \endgroup
              \fi
            \fi
            \kern\marginnotetextwidth\kern\marginparsep
            \vbox to\z@{\kern\marginnotevadjust\kern #3
              \vbox to\z@{%
                \hsize\marginparwidth
                \linewidth\hsize
                \kern-\parskip
                \marginfont\raggedrightmarginnote\strut\hspace{\z@}%
                \ignorespaces#2\endgraf
                \vss}%
              \vss}%
          }%
      }%
    }%
  \endgroup
}
\makeatother
\fi

\renewcommand*{\marginfont}[1]{\scriptsize#1}

\newcommand*{\marginalText}[2][]{
\message{LaTeX Warning: \noexpand\marginalText is deprecated, use \noexpand\marginnote on input line \the\inputlineno }
\marginnote[#1]{#2}
}
\renewcommand*{\marginline}[2][]{
\message{LaTeX Warning: \noexpand\marginline is deprecated, use \noexpand\marginnote on input line \the\inputlineno }
\marginnote[#1]{#2}
}


%%%% hyperref %%%%%%%%
%% special: hyperref needs to be loaded last! (exception hycap)
%% purpose: make internal and external links working and colored
\usepackage[colorlinks=true,
						linkcolor=LinkInternal,
						anchorcolor=LinkAnchor,
						citecolor=LinkBibliography,
						filecolor=LinkExternal,
						urlcolor=LinkExternal,
						hyperindex,linktoc=section,pdfstartview=FitV,plainpages=false,pdfpagelabels
						]{hyperref}%
\AtBeginDocument{\def\subsectionautorefname{\sectionautorefname}}
\AtBeginDocument{\def\subsubsectionautorefname{\sectionautorefname}}
						
%%%%%%%%%%%%%%%%%%%%%%

%%%% hycap %%%%%%%%%%%
%% special: directly AFTER hyperref: 
%% purpose: links to figures and tables should link to top of figure and not to top of caption
%%					(which is below figure, so figure wouldn't show but only caption); no other change necessary
\usepackage[all]{hypcap}
%%%%%%%%%%%%%%%%%%%%%%

% !Mode:: "TeX:UTF-8"

%%%% glossary %%%%%%%%%
% for glossary and acronyms; instead of package acronym
% special: glossary after hyperref
%\usepackage[footnote,printonlyused]{acronym}
\usepackage[acronym,nonumberlist,section=chapter,toc]{glossaries}
\deftranslation[to=ngerman]{Acronyms}{Abkürzungsverzeichnis}
\deftranslation[to=ngerman]{Glossary}{Glossar}
\makeglossaries


\newcommand{\printacronyms}{%
\printglossary[type=\acronymtype,style=myAcronymStyle]%
}
\newcommand{\acr}[1]{\gls{#1}}

\newglossarystyle{myAcronymStyle}{%
% put the glossary in the itemize environment:
\renewenvironment{theglossary}{\begin{description}[\setleftmargin{2cm}]}{\end{description}}%
% have nothing after \begin{theglossary}:
\renewcommand*{\glossaryheader}{}%
% have nothing between glossary groups:
\renewcommand*{\glsgroupheading}[1]{}%
\renewcommand*{\glsgroupskip}{}%
% set how each entry should appear:
\renewcommand*{\glossaryentryfield}[5]{%
\item[\glstarget{##1}{##2}]{##3}
}%
% set how sub-entries appear:
\renewcommand*{\glossarysubentryfield}[6]{%
\glossaryentryfield{##2}{##3}{##4}{##5}{##6}}%
}

%usage:
% \newacronym[key-val list]{label}{abbrv}{long}
% \acr 	{auto short/long}
% \acrshort
% \acrlong
% !Mode:: "TeX:UTF-8"



%\let\defaultTodo\todo
%\renewcommand{\todo}[1]{
%%\defaultTodo[inline]{#1}%
%\defaultTodo{\sloppy #1}
%}
%\ifpdf
%\else
%%didn't fix todo for dvi, so disabled here:
%\renewcommand{\todo}[1]{}
%\fi
\newcommand{\chapterWithoutPageBreack}{\global\@topnum\z@\@afterindentfalse\secdef\@chapter\@schapter}
\let\chapterDefaultCommand\chapter



\newcommand{\ignoreHbadness}[1]{%
  \let\originalHbadness\hbadness%
	\hbadness 100000%
	#1
	\hbadness \originalHbadness%
}

\renewcommand{\figurename}{Abb.}
\newcommand{\figref}[1]{\autoref{fig:#1}}



\newcommand{\eng}[1]{engl.: \emph{\english{#1}}}
\newcommand{\entode}[1]{engl. für \emph{\english{#1}}}
\newcommand{\english}[1]{\foreignlanguage{english}{#1}}

\newcommand{\good}[1]{\textcolor{Good}{#1}}
\newcommand{\bad}[1]{\textcolor{Bad}{#1}}

%%%%%%%%%%%%%%%%
% from http://stackoverflow.com/questions/3126082/store-a-text-string-in-latex-and-then-add-other-text-to-it-concatenate
% by David Underhill
\newcounter{footnotesinthisminipage}
\stepcounter{footnotesinthisminipage}\addtocounter{footnotesinthisminipage}{-1} % initialize counter to avoid errors
\newcommand{\footnoteNumberInMinipage}{\stepcounter{footnotesinthisminipage}\stepcounter{footnote}\footnotemark[\value{footnote}]}
\newcommand{\footnoteTextAfterMinipage}[1]{%
\addtocounter{footnotesinthisminipage}{-1}%decrease 
\addtocounter{footnote}{-\value{footnotesinthisminipage}}%set footnote counter backwards for the number of footnotes
\footnotetext[\value{footnote}]{#1}%output footnotetext
\addtocounter{footnote}{\value{footnotesinthisminipage}}%reset footnote counter to real value
}%
\newcommand{\footnoteCmdForInsideMinipage}[1]{%
\ClassError{udesoftec}{Warning: \protect\footnote\space in minipages not implemented, use \protect\footnoteNumberInMinipage and \protect\footnoteTextAfterMinipage instead}%
%\footnoteNumberInMinipage
%\let\executeThisAfterEndOfMinipage aloa
}%

%%%%%%%%%%%%%%%%
\usepackage{verbatim}
\usepackage{multicol}
\usepackage{listings}
\usepackage[listings]{scrhack} 
\lstset{%
frame=single,%
basicstyle=\scriptsize,%
breaklines=true,%
backgroundcolor=\color{listingBackground}%
}

\usepackage{varwidth}
\newcommand{\parExample}[2][!]{%
\ifx!#1{
\parExampleWithHeading{Beispiel:}{#2}
}\else{
\parExampleWithHeading{Beispiel für #1:}{#2}
}\fi
}
\newcommand{\parExampleWithHeading}[2]{%
	\let\defaultCmdFootnote\footnote%
	\let\footnote\footnoteCmdForInsideMinipage%
  \begin{addmargin}{0em}\vspace*{1em}\colorbox{parExample}{\begin{varwidth}{\linewidth-.7em}%
	\small\textbf{#1}\par%
	\small{#2}%
	\end{varwidth}}\vspace*{1em}\end{addmargin}%
	\let\footnote\defaultCmdFootnote%
}


\AtBeginDocument{
        \pagenumbering{alph}    % title page is "a" - internal trick to prevent two pages with same name
        \maketitle                                                      % Komplett automatisch generiert anhand von Metadaten
        \cleardoublepage
        %\extratitle             % empty sheet after title
        %%%%%%%%%%%%%%%%%%%%%%%% VORGEPLÄNKEL %%%%%%%%%%%%%%%%%%%%%%%
        \pagenumbering{Roman}   % I,II,III,IV... - all pre-content pages are roman upper
			%	\input{chapters/02_Foreword}
        \tableofcontents
				\ifdocumentOmitLOF\else\listoffigures\fi
				\ifdocumentOmitLOT\else\listoftables\fi
}
\AtEndDocument{
}

\setlength\marginparsep{5mm}
\setlength\marginparwidth{40mm}

\endinput%