/*
 * Fast index for tag data, using a read-only database
 *
 * Copyright (C) 2005  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <tagcoll/TDBReadonlyDiskIndex.h>


#ifndef INSTANTIATING_TEMPLATES
#include <string>

namespace Tagcoll {
	template class TDBReadonlyDiskIndex<std::string, std::string>;
}
#endif


#ifdef COMPILE_TESTSUITE

#include <tests/test-utils.h>

namespace tut {
using namespace tut_tagcoll;

struct tagcoll_tdbreadonlydiskindex_shar {
};
TESTGRP(tagcoll_tdbreadonlydiskindex);

template<> template<>
void to::test<1>()
{
	Converter<string, string> a;
	TDBReadonlyDiskIndex<string, string> coll("pkgidx.test", "tagidx.test", a, a, a, a);

	test_tagged_collection(coll);

	unlink("pkgidx.test");
	unlink("tagidx.test");
}

}

#endif
// vim:set ts=4 sw=4:
