/*
 * Copyright (C) 2022 Tobias Brunner, codelabs GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include <crypto/crypto_tester.h>

/**
 * The following test vectors are from CAVP/SP 800-135 for IKEv2.
 *
 * key = g^ir, salt = Ni | Nr (one vector with min. and one with max. size for
 * nonces)
 */
kdf_test_vector_t prf_sha256_1 = {
	.alg = KDF_PRF, .arg.prf = PRF_HMAC_SHA2_256,
	.key = chunk_from_chars(
		0x42,0x96,0x8e,0x5d,0x0c,0xcc,0x3c,0xfc,0x5a,0x3e,0x4b,0xc1,0xbb,0xa3,0x70,0xce,
		0xa1,0xfa,0xe0,0xd5,0x4c,0x49,0xcc,0xba,0x34,0xb2,0xbe,0xe8,0x04,0xbe,0xeb,0x2e,
		0x9e,0x8c,0x57,0xa4,0xe0,0x1b,0xd4,0x51,0x02,0xcf,0x24,0x33,0xaa,0xcc,0x6c,0xfe,
		0xc0,0x67,0x92,0xf3,0x63,0xe5,0x17,0x0e,0x6a,0xa6,0x65,0x02,0x74,0xe9,0x06,0x64,
		0x8e,0x44,0x9d,0x27,0xa8,0xf0,0x0b,0x5b,0x44,0x26,0x19,0x82,0xc9,0x83,0x5c,0x74,
		0x8a,0x75,0x1e,0xc5,0x13,0x8e,0xaa,0xcc,0x5e,0x02,0x56,0x61,0x33,0x95,0x38,0xa6,
		0x1b,0xf4,0x18,0xe4,0x54,0x69,0x9e,0x19,0xc3,0x2d,0xb8,0xd9,0xce,0x5d,0xd8,0x6b,
		0x22,0x0f,0x1e,0x89,0xaf,0xc5,0x87,0x2e,0x68,0xbe,0x36,0xcb,0x1a,0x0c,0x88,0x66),
	.salt = chunk_from_chars(
		0xed,0x80,0xdc,0x79,0x91,0x2c,0x32,0xa9,0x35,0xfb,0x6d,0x1a,0x3f,0xea,0xc0,0x78),
	.out = chunk_from_chars(
		0x37,0xfd,0xe9,0x0b,0x81,0xd6,0x36,0x92,0x62,0x0f,0x67,0x36,0x7b,0x62,0x09,0x2e,
		0x3e,0xfd,0xc6,0xa0,0x35,0x09,0x13,0x7d,0x73,0x10,0x04,0x76,0x7f,0xf3,0x50,0x10),
};

kdf_test_vector_t prf_sha256_2 = {
	.alg = KDF_PRF, .arg.prf = PRF_HMAC_SHA2_256,
	.key = chunk_from_chars(
		0xb0,0x70,0x20,0x8f,0x89,0x47,0xdf,0x4f,0x7d,0x12,0x76,0x16,0x1f,0x40,0x7f,0x7b,
		0x7f,0x5c,0x4a,0x49,0xac,0x79,0xf0,0xcc,0x0c,0x7d,0x4e,0x28,0x48,0x4c,0x6f,0x85,
		0x84,0xf0,0x00,0x7b,0x9b,0xf0,0xe0,0x5f,0xdb,0x59,0x61,0xa1,0x7d,0x3a,0xa8,0x5c,
		0x6e,0x3f,0x55,0x71,0x29,0x6a,0x43,0xba,0x89,0x6c,0xdc,0x88,0xc1,0xa4,0x45,0x7f,
		0xb1,0x2c,0xbe,0x56,0xca,0x4a,0x20,0xc9,0xa7,0xe1,0x9a,0xdc,0x67,0x45,0x3c,0x4a,
		0xde,0x53,0x9e,0x25,0x9f,0x82,0x5f,0xf9,0x4c,0x9a,0x83,0xf8,0x39,0x60,0x2f,0x86,
		0x51,0xc9,0x27,0x6d,0x8e,0x44,0x4e,0xcb,0x95,0xa0,0x54,0x0e,0xe7,0xea,0x32,0x20,
		0xa9,0x22,0x34,0x5e,0xd9,0x9e,0xf7,0xe7,0xad,0x32,0xb1,0x9d,0x46,0x10,0xe9,0xef),
	.salt = chunk_from_chars(
		0xef,0xa7,0x29,0x13,0x18,0x22,0x78,0xff,0xbd,0x14,0xe7,0x89,0x20,0xc0,0x62,0x51,
		0x9a,0xba,0xb8,0xc1,0x6e,0x5e,0xd7,0x0c,0x08,0x41,0xa4,0x8c,0xdb,0x98,0x23,0x7e,
		0xe9,0x3f,0x73,0x5f,0xb2,0xdf,0x18,0x43,0x58,0xaa,0xdc,0x13,0xd8,0x3f,0x43,0xfe,
		0x8d,0x87,0x05,0x17,0x6c,0x8c,0xa3,0x13,0x82,0x5a,0x1b,0xcd,0xf7,0x79,0x11,0xc5,
		0x98,0x00,0x16,0x71,0xff,0xbf,0x01,0x4e,0x37,0xa8,0xc0,0x4d,0x49,0xa7,0x83,0x9d,
		0xfe,0xa6,0xcd,0xc5,0x87,0x68,0x8d,0x45,0x88,0xfe,0x43,0x23,0x5b,0x71,0x69,0x3f,
		0xfd,0x07,0x29,0x33,0x86,0xb6,0xbf,0x4c,0x19,0x9e,0x33,0x61,0x65,0xb2,0x60,0x78,
		0x77,0x36,0xf5,0x4b,0xe9,0x5d,0xb6,0x91,0x16,0x38,0x8b,0xc2,0xec,0xa2,0xb3,0xb2,
		0x94,0x84,0x71,0x74,0x17,0xbb,0x3c,0x71,0x81,0x4c,0xe1,0x3b,0x84,0x44,0x6d,0xc3,
		0x96,0x4c,0x30,0x29,0x84,0xf9,0x77,0x81,0xf6,0x31,0x66,0x24,0x08,0x90,0x10,0x7c,
		0x2e,0x75,0x1a,0x00,0x43,0x6f,0x7c,0x3c,0x9f,0xf1,0x27,0x60,0xe4,0x9d,0x91,0x56,
		0x3b,0xe6,0x03,0xfd,0x96,0x41,0xa0,0xa6,0x49,0x18,0xa9,0x32,0x91,0xed,0x11,0x3d,
		0xb1,0x2f,0x97,0x07,0x60,0x9d,0x17,0x20,0x96,0xeb,0x58,0xf9,0x15,0x44,0x74,0xda,
		0x40,0xc1,0xf5,0xc0,0x90,0x3e,0x9c,0xa2,0xf9,0x1b,0xa6,0x60,0x07,0x75,0xdf,0x71,
		0x66,0xca,0xf8,0xe3,0x27,0x85,0x9e,0x67,0x62,0x32,0xd3,0x40,0x46,0x04,0x4c,0xee,
		0x43,0xf9,0x01,0x9f,0x04,0x68,0x56,0x12,0x63,0x5b,0x99,0xcb,0xeb,0xcb,0x36,0x3d,
		0x56,0x5e,0xaf,0x0e,0x54,0x7e,0xec,0xb9,0x41,0xc9,0x94,0xdf,0xd4,0x71,0xed,0x56,
		0x43,0xc0,0x87,0x74,0x4f,0x77,0x09,0xcc,0x3e,0x25,0x10,0xf2,0x74,0x26,0xc6,0x2c,
		0x0f,0xf3,0xac,0xb3,0xc2,0x76,0x61,0xd2,0x6a,0x6d,0x83,0xc2,0xa2,0x5e,0x13,0xa6,
		0xd4,0x65,0xbd,0x04,0x7f,0x90,0x55,0x00,0xe5,0xeb,0xbe,0x42,0x66,0x43,0x0d,0x56,
		0x67,0x14,0x0f,0x77,0xe7,0x97,0x71,0x2a,0x8c,0x8f,0x63,0xc5,0x83,0xf4,0xb4,0x64,
		0x9b,0x72,0x89,0x9e,0xa3,0x4a,0xbf,0xdb,0x17,0x61,0x7c,0x46,0x0c,0x35,0xf2,0x50,
		0x64,0x94,0x49,0x4f,0x22,0x3e,0x25,0x1a,0xc7,0x1a,0x5b,0x9b,0x7e,0xea,0x87,0xf4,
		0xf5,0xe3,0x33,0xa3,0xc1,0xbb,0xb4,0xbb,0x09,0x25,0x8b,0x6a,0x4b,0x5f,0x8c,0x9f,
		0xb8,0x2b,0xf4,0x2d,0xa9,0xd4,0xa4,0x65,0x43,0xc6,0xa9,0xeb,0x9a,0xa3,0x0e,0xa9,
		0xda,0x80,0x19,0x15,0xab,0xcc,0x17,0x12,0xd0,0x82,0xf2,0x92,0xa6,0x3f,0xd9,0xaf,
		0x71,0x54,0xa9,0x7c,0xc7,0x38,0x59,0xa4,0xbe,0x3c,0xba,0x35,0x9d,0x32,0x18,0x00,
		0x4e,0x14,0xdf,0x02,0xd0,0x9e,0xdf,0x0a,0xd5,0x79,0x6b,0xb0,0x10,0x99,0x52,0x93,
		0xab,0x5d,0x04,0x2c,0x31,0x05,0x53,0x80,0xcc,0x9c,0xb2,0xe3,0x61,0x79,0x82,0xc4,
		0x5f,0x6b,0xce,0x1f,0xb8,0xa4,0x0e,0xf9,0xea,0xc4,0x8a,0xe1,0x77,0x20,0xdf,0xec,
		0xc7,0x1e,0xc8,0x57,0xea,0x33,0xf3,0x2e,0xb3,0x46,0xba,0x60,0x36,0xe8,0xf9,0xcc,
		0xd7,0xbc,0xad,0xc6,0xc1,0xab,0x92,0xa8,0x0c,0x57,0xe7,0x89,0x59,0xd8,0xb8,0x28),
	.out = chunk_from_chars(
		0x29,0xbd,0x11,0x55,0x68,0xae,0x09,0x88,0x27,0x0f,0xc3,0x86,0xd3,0x95,0xfe,0x37,
		0x07,0xa4,0xd0,0x62,0x89,0xf3,0x52,0xbb,0xa4,0xc0,0x0a,0x9a,0xd8,0x55,0xa0,0x8d),
};

kdf_test_vector_t prf_sha384_1 = {
	.alg = KDF_PRF, .arg.prf = PRF_HMAC_SHA2_384,
	.key = chunk_from_chars(
		0x4d,0xf0,0x40,0xb7,0x09,0x78,0x62,0x9c,0x49,0x43,0x7c,0xff,0x41,0xa0,0xd4,0x6c,
		0xbe,0xa6,0x8c,0x8d,0x75,0xb3,0x70,0xff,0xc1,0x1d,0x7b,0x38,0x71,0x44,0xea,0x83,
		0xbb,0x59,0x03,0xfb,0xb9,0x2e,0x47,0x3d,0xf5,0x0a,0x9b,0x19,0xea,0x43,0xe9,0xc2,
		0xf3,0xda,0x9a,0x84,0x9c,0x03,0x86,0x42,0x76,0xc6,0xf2,0x64,0xec,0xf0,0x2a,0x60,
		0xd4,0x0b,0xa6,0x5c,0x06,0x65,0x6b,0x63,0x3f,0x02,0xa8,0x74,0x27,0xe9,0x28,0xeb,
		0x66,0xa2,0xda,0xbd,0x9d,0xc0,0x57,0x44,0x71,0x7b,0xca,0xf7,0xae,0x78,0xc2,0x96,
		0x87,0x2f,0x5c,0x48,0xd1,0xa8,0x12,0x0c,0x21,0x55,0xb7,0x0c,0x56,0x5c,0xe2,0x71,
		0x99,0x8e,0x3e,0x44,0xaf,0x26,0x3d,0x48,0x7e,0xa3,0xba,0x7f,0x56,0x13,0x2d,0x7d),
	.salt = chunk_from_chars(
		0xd6,0x72,0xb0,0xbc,0x85,0x28,0x29,0xb9,0x35,0x09,0xf3,0xb7,0x24,0x70,0x63,0x64),
	.out = chunk_from_chars(
		0x54,0x43,0x6a,0x9e,0xa9,0x5d,0x6f,0xf7,0x9b,0x96,0x7f,0x4b,0x07,0xf6,0xde,0x97,
		0x6a,0x37,0x6e,0x8e,0xa2,0x6a,0xa9,0x57,0x47,0x09,0xaf,0xc6,0x02,0x43,0xc9,0xc1,
		0x41,0xda,0x4c,0xa0,0xe1,0x58,0xe6,0x27,0xa7,0x5e,0xa8,0x7f,0x6f,0xeb,0x07,0xef),
};

kdf_test_vector_t prf_sha384_2 = {
	.alg = KDF_PRF, .arg.prf = PRF_HMAC_SHA2_384,
	.key = chunk_from_chars(
		0xae,0x50,0x50,0x82,0xac,0x47,0xff,0x9a,0xa3,0x54,0xb7,0xaf,0x2b,0x07,0x2c,0xb4,
		0x9c,0xec,0x83,0x8d,0x00,0xee,0x36,0x13,0x88,0x1a,0x99,0x77,0xb2,0x15,0x95,0x99,
		0xa0,0x24,0x95,0xf0,0xe5,0x2d,0x96,0x1a,0x51,0x6c,0x6b,0xb6,0x1e,0xd0,0x3a,0x86,
		0x37,0xbb,0x50,0x7c,0x5c,0x27,0xba,0xb5,0x8d,0xf1,0x54,0xe8,0xe5,0x01,0x48,0x21,
		0x84,0x0c,0xfc,0x50,0xb3,0xa4,0x78,0xb4,0x5d,0xd1,0x68,0xeb,0x18,0x0d,0x69,0xcb,
		0xa6,0x1a,0x1b,0x42,0x59,0x19,0x3a,0x51,0xa7,0xa4,0x95,0xc9,0x58,0x05,0x38,0x2e,
		0x3a,0xbf,0x55,0x87,0x68,0x8f,0x34,0xb6,0x3f,0x71,0x16,0x39,0x82,0xde,0x3d,0xdf,
		0x7f,0x26,0x3b,0xb6,0x9f,0x65,0xc3,0xec,0xae,0x61,0x65,0xbf,0x7f,0xdd,0x53,0x17),
	.salt = chunk_from_chars(
		0x9e,0x2a,0x62,0xf9,0x36,0x28,0x93,0xdd,0xf8,0x47,0x16,0xfe,0xc2,0xf2,0x3f,0x9d,
		0xcb,0xd9,0x01,0x0d,0xf6,0xfe,0x9e,0x0e,0xb4,0x6d,0x03,0xd9,0x14,0xf3,0x04,0xd8,
		0xfe,0x4d,0x3e,0xe2,0xd6,0xa0,0x3b,0x40,0xe5,0x6a,0x32,0x5e,0x82,0x2a,0x17,0x36,
		0x19,0x29,0x18,0x4a,0xde,0x09,0xea,0xa4,0x45,0x27,0x8d,0x38,0x70,0x41,0x7a,0x7c,
		0xf5,0x65,0x58,0x4f,0x57,0x2a,0xd3,0x4f,0xf7,0x2b,0xc7,0x78,0x1a,0x39,0xa4,0x8b,
		0x54,0xb5,0x5d,0x6e,0xb0,0xed,0x68,0x55,0x1b,0x22,0x2c,0x7a,0xfa,0xda,0x0b,0xc8,
		0x22,0x36,0xec,0x31,0xce,0x6c,0x04,0x6b,0x3b,0x2e,0xdb,0x2d,0xef,0x61,0xf4,0xd2,
		0xd8,0x57,0xb2,0xd1,0xcb,0x36,0x96,0xc0,0x23,0xe0,0x8c,0x08,0xd6,0xab,0xd0,0x4d,
		0x4f,0x69,0x09,0x2b,0x14,0x58,0x37,0x35,0xb9,0xe9,0x18,0xae,0xe5,0xa3,0x99,0x9d,
		0xcb,0xf5,0x8f,0xda,0xd6,0xfc,0xd4,0x7c,0x95,0x92,0x98,0x77,0x03,0x0e,0x54,0xb7,
		0x08,0x23,0x5f,0x2a,0x2e,0x11,0xe7,0xc5,0x85,0x84,0x61,0x9a,0xa2,0xfa,0x69,0x31,
		0x53,0x44,0xd3,0x65,0x7b,0x55,0x72,0x0a,0x25,0xeb,0xe8,0x8e,0xa0,0x77,0x69,0x72,
		0xc9,0xe2,0x24,0x69,0xb7,0xed,0x5d,0xa9,0x6b,0x3c,0x76,0x85,0xf7,0xb0,0x56,0x99,
		0x60,0xbd,0x64,0x4f,0x13,0x0b,0x44,0xa0,0xd5,0x51,0xbb,0x0e,0x90,0x2e,0xd6,0x8a,
		0xb3,0x84,0xfd,0xc2,0xfa,0xca,0xf7,0x9b,0xbf,0x8d,0x6d,0x37,0x36,0xdf,0xa9,0x52,
		0xcd,0x70,0xf4,0x74,0x6f,0x1a,0x4a,0xea,0xc2,0xbd,0xbe,0xca,0x97,0xb7,0x8f,0xc1,
		0x77,0x78,0x78,0xc1,0x28,0x59,0x43,0x35,0x52,0xa7,0x7d,0x7f,0x94,0x2e,0x5b,0x60,
		0x47,0x69,0x91,0xa1,0xe3,0xd0,0x42,0x7c,0xd6,0x77,0x34,0x5a,0x1c,0xe2,0x06,0x3a,
		0x2e,0x0e,0xc5,0x47,0xa9,0xd8,0x21,0xda,0x75,0x9f,0x1a,0x91,0xb5,0x88,0x17,0xbd,
		0x0d,0xc4,0xef,0xfc,0x12,0x6f,0x6f,0x4e,0xb0,0xb9,0x11,0xe9,0x04,0xed,0x21,0xdc,
		0x43,0x9d,0x65,0x8a,0x77,0x3f,0x97,0xe1,0x79,0xad,0x20,0xbc,0x3c,0x63,0x60,0x9f,
		0x28,0x74,0x06,0x2e,0x83,0x5f,0x6a,0xe0,0x8d,0x59,0x65,0x4f,0x9c,0x88,0x61,0xe5,
		0x27,0x03,0x9e,0xea,0xc3,0x2b,0x9e,0xed,0x29,0x3b,0xd8,0xb1,0xe0,0xe7,0xc6,0x7b,
		0xf1,0xd7,0x55,0x24,0x6a,0x1b,0x06,0x3f,0xf0,0x06,0x32,0xa4,0x6d,0xd5,0xcf,0x69,
		0x48,0xf0,0xee,0xd9,0xb6,0x5c,0x59,0x39,0xdf,0xd2,0x14,0x80,0xa6,0x3d,0xf0,0xca,
		0xb0,0xa7,0x50,0x9c,0x42,0x45,0xa1,0xbe,0x75,0x47,0xcc,0xc6,0xf7,0x3c,0x72,0x4b,
		0x48,0xb7,0x86,0x70,0x12,0xe0,0xca,0x3e,0x47,0x2e,0x0d,0x55,0x06,0x49,0xa7,0x34,
		0x44,0x0f,0xef,0xfc,0x8e,0x73,0x68,0x2c,0xb6,0x04,0x53,0xe7,0xa4,0x7e,0x72,0xfe,
		0x08,0x74,0xeb,0x40,0xac,0xd0,0xd4,0x8e,0x4e,0x57,0x19,0x74,0x16,0x11,0x2b,0xcd,
		0xc8,0xbb,0x7a,0x58,0xbe,0xa7,0x45,0xfd,0xd6,0x4c,0x16,0xf6,0x66,0xc8,0x8d,0x9e,
		0x3b,0xd2,0x35,0xb1,0x37,0x20,0x6f,0x6c,0xdb,0xa1,0x90,0xbe,0x65,0xec,0x03,0x3c,
		0x19,0x1f,0x67,0x6b,0x42,0x8e,0xc1,0x20,0x5d,0xc5,0xe9,0x45,0x82,0x85,0x08,0xd8),
	.out = chunk_from_chars(
		0xff,0x66,0xe9,0xd0,0x92,0xdc,0x01,0xe0,0xb8,0x1f,0x93,0x9f,0x52,0xf5,0xc0,0x7d,
		0x38,0xd8,0x05,0xb9,0x86,0x28,0xce,0x1a,0xc5,0xfe,0x94,0xc0,0x98,0x57,0x76,0x47,
		0x33,0x9f,0xad,0x68,0x94,0x1f,0xfe,0x21,0xe0,0x1e,0xfb,0x4e,0x70,0x50,0x21,0x3b),
};

kdf_test_vector_t prf_sha512_1 = {
	.alg = KDF_PRF, .arg.prf = PRF_HMAC_SHA2_512,
	.key = chunk_from_chars(
		0x1e,0x3b,0x00,0x7d,0x2d,0xa9,0x13,0xca,0x60,0xec,0xc9,0x8c,0x25,0xa2,0x2d,0xb0,
		0x80,0x73,0xd5,0xc3,0x5c,0x11,0xb2,0x52,0x4b,0x29,0x8a,0x92,0x2b,0x6a,0xbf,0xe6,
		0xac,0xf7,0x35,0x9d,0xb6,0x6a,0xe5,0xf8,0x5d,0x67,0xaa,0xcf,0xf6,0x86,0x41,0x9c,
		0xd8,0x66,0x6d,0x05,0xae,0x79,0x77,0xce,0xfa,0xd7,0xf5,0x4d,0xd8,0xe3,0x12,0xa8,
		0xe8,0xe5,0xe0,0x37,0x0f,0x88,0x14,0x2f,0xbd,0xd6,0x59,0xdd,0x6f,0xde,0x22,0xbd,
		0xd5,0x31,0xf5,0x40,0x28,0x81,0xa8,0xde,0x85,0xc1,0x02,0x4e,0x59,0x5e,0xc9,0x3c,
		0x57,0x56,0x18,0xaf,0x7f,0xd3,0xdb,0xac,0x79,0x82,0x91,0x90,0x78,0xd7,0x1c,0xc1,
		0x3e,0xff,0x19,0x10,0xa0,0x32,0x75,0x0e,0x1f,0xf4,0x28,0x67,0x5d,0xe1,0x89,0xee),
	.salt = chunk_from_chars(
		0xdf,0x79,0x31,0xdb,0x9b,0x42,0x9e,0x10,0xb8,0xaa,0x8e,0x4d,0x46,0x04,0x23,0x93),
	.out = chunk_from_chars(
		0xda,0xf9,0xbd,0x6f,0x2f,0x91,0x2d,0xa5,0x53,0x86,0x79,0x66,0xaf,0x38,0x6e,0x67,
		0x90,0x9a,0x8d,0xf0,0xca,0x7e,0x84,0xb8,0x3b,0x35,0x5c,0xb7,0xd7,0xf1,0x02,0x6f,
		0x17,0xd8,0xea,0x34,0xb5,0xd5,0x7f,0xd0,0xd1,0xba,0x38,0x95,0x28,0xfc,0xa1,0xe8,
		0x1d,0x1c,0x8c,0xe5,0x11,0xb2,0x8a,0x24,0x58,0x24,0x11,0x43,0xfe,0xe3,0x0c,0xcc),
};

kdf_test_vector_t prf_sha512_2 = {
	.alg = KDF_PRF, .arg.prf = PRF_HMAC_SHA2_512,
	.key = chunk_from_chars(
		0x9c,0xb4,0xbf,0x24,0x46,0x17,0x0a,0xc3,0x81,0x02,0x52,0x66,0xa1,0xa4,0xb8,0x65,
		0x13,0xdf,0x60,0xea,0x7d,0x07,0xb1,0xb2,0x13,0x9d,0x78,0xf3,0x31,0xef,0x7e,0xb7,
		0xbe,0x8b,0x15,0xd8,0x6c,0xd8,0x5e,0x2a,0x6a,0x34,0xa5,0x58,0x69,0xf8,0xdc,0xc9,
		0x75,0x4f,0x49,0x69,0x73,0x31,0xb9,0xb6,0x50,0xce,0x25,0x6e,0xdb,0x33,0x71,0xa9,
		0x4b,0x7c,0x2a,0x13,0x2f,0x2f,0xc9,0x9d,0x22,0x30,0x37,0x17,0xc3,0x67,0x39,0xd1,
		0x7c,0x0e,0x97,0x18,0xd7,0xc0,0x52,0xe7,0xab,0x4d,0x48,0x58,0xad,0xeb,0x9b,0x8b,
		0x4d,0x33,0x03,0xa9,0xe1,0xb6,0xbe,0xf2,0x9f,0x03,0x03,0x5b,0xee,0xd0,0x71,0xd3,
		0xbb,0x81,0x0d,0x85,0x39,0x71,0xa7,0x48,0xc5,0x6c,0x59,0xe0,0xba,0xfb,0x9b,0x5a),
	.salt = chunk_from_chars(
		0xd8,0x96,0x84,0xe3,0xcb,0x17,0xf3,0xaa,0xbd,0x85,0x3a,0x78,0xdb,0x3e,0xcd,0x5a,
		0xac,0xc1,0xed,0x71,0xc7,0x0b,0x88,0xa2,0x97,0x56,0xf4,0x6f,0xc7,0x19,0x7c,0x80,
		0x4e,0xc0,0x01,0x54,0x40,0x02,0xa8,0xae,0xa3,0x60,0x68,0x4b,0x18,0x00,0x6d,0xef,
		0x0d,0xbd,0x86,0x33,0xb1,0x01,0x9f,0xbc,0xfa,0x85,0xb9,0x4c,0xac,0x2b,0xb8,0x21,
		0x25,0x84,0xbe,0x62,0xad,0xab,0x0e,0xe4,0xbb,0x8a,0x36,0xae,0xe2,0x52,0x75,0xef,
		0x07,0x13,0x90,0x48,0x0e,0xef,0xa2,0x09,0x2e,0xb3,0x08,0xaa,0x73,0x37,0xc5,0xce,
		0xb6,0x06,0x9a,0xb6,0x90,0xe8,0x96,0x2f,0xbf,0xe0,0x98,0x6e,0x4f,0x5c,0x18,0xf4,
		0x86,0x86,0x1e,0xd3,0xf1,0xdc,0xbe,0xe4,0xc9,0xe4,0xa7,0x66,0x9d,0x74,0x0c,0xa2,
		0xb0,0xe8,0xed,0x40,0x31,0xb0,0xa4,0x99,0xdc,0x31,0x5c,0xed,0xe7,0xef,0x03,0x39,
		0x9c,0xbc,0x33,0xdc,0xd6,0x29,0x70,0x34,0x9f,0x12,0x20,0x88,0x1b,0x55,0x45,0x2e,
		0x0c,0x6c,0x9b,0x52,0xa8,0x8b,0x67,0xf5,0x97,0x58,0x67,0x95,0xb2,0x25,0x70,0x73,
		0x3f,0xd4,0xff,0x2c,0xc2,0xad,0x93,0x1d,0x83,0x30,0x16,0x5a,0x9e,0x45,0x0e,0x38,
		0x88,0x59,0xce,0x62,0x4f,0x01,0xdb,0x17,0xc2,0x50,0x2b,0x4e,0x66,0xad,0xf9,0x65,
		0x27,0x36,0x3d,0x6f,0x90,0x6b,0x20,0x23,0xe8,0xed,0x74,0xd5,0xaf,0x0a,0xa6,0x02,
		0x46,0xb0,0xb9,0x2f,0x49,0xc4,0x93,0x3e,0xf3,0x12,0xf8,0xa2,0x54,0x34,0xee,0x96,
		0x98,0xd6,0xd9,0x20,0x43,0x45,0xbd,0x10,0xbb,0x11,0xaa,0x39,0x86,0x56,0x16,0xd5,
		0xad,0x1b,0x57,0x44,0x70,0x6c,0xfd,0x4e,0xa1,0x40,0x8e,0x20,0xc8,0xfd,0xcf,0x85,
		0x51,0xee,0xe8,0x81,0x4b,0x7b,0x37,0x33,0x0b,0x05,0x26,0xf0,0xbc,0x5e,0xe1,0x5d,
		0x4e,0xcd,0xa7,0xa1,0xbd,0x25,0xaa,0x97,0xf2,0x45,0x84,0xd8,0x5d,0x3f,0x52,0x49,
		0x69,0x4b,0x9f,0x43,0x53,0x9e,0x69,0xea,0x35,0xbf,0xe7,0xfd,0x44,0x07,0xbc,0x8e,
		0x9d,0xca,0x8a,0x9f,0xae,0x4b,0xdc,0x6b,0x7b,0xb3,0x8c,0x6d,0x68,0xf8,0x99,0xe1,
		0xd3,0x2c,0x85,0xbc,0xd6,0x17,0xa5,0x67,0x67,0x8c,0xf8,0x5d,0x22,0x17,0xa4,0xe8,
		0x6a,0x75,0x56,0x24,0xb6,0x40,0x02,0x35,0x4c,0x02,0x68,0x42,0xbc,0x95,0x42,0x49,
		0x1a,0xf1,0xc3,0xd6,0x29,0x09,0x70,0x55,0x9a,0xf1,0x1b,0xdc,0x2c,0x83,0xb5,0x4c,
		0x74,0x14,0x49,0x05,0xc0,0xa3,0x58,0xf3,0x15,0x3d,0xb7,0x67,0xa5,0xda,0x2a,0x86,
		0x27,0xf6,0x96,0x27,0xe1,0xd4,0x1e,0xde,0x9c,0x90,0x7c,0x79,0xb5,0x1f,0xf8,0x15,
		0xe4,0x64,0x5c,0x33,0x75,0xe0,0xf6,0x3f,0x84,0xfc,0xf5,0xd7,0xc3,0x40,0x7a,0x1d,
		0xd6,0x83,0x9e,0x19,0x06,0xa1,0xe3,0x80,0x2c,0xcf,0x5e,0x82,0x30,0xd9,0x5c,0xf4,
		0xb8,0x27,0xb4,0x1c,0x48,0x34,0x25,0xa8,0xa6,0x0b,0xfa,0x51,0x89,0xda,0xc4,0x38,
		0x06,0x0f,0x2f,0x5c,0xd5,0x26,0x66,0x2f,0x29,0x06,0xc1,0xdd,0x64,0xf4,0x84,0x4e,
		0x94,0x2c,0xa8,0x4d,0xae,0xce,0x6d,0xd7,0xbb,0xf7,0x19,0x4d,0x8c,0xe5,0x6b,0xc2,
		0x83,0x10,0x85,0xa7,0xd3,0x10,0xe4,0x94,0x4c,0xfa,0xe7,0x62,0x60,0xaa,0xbf,0x6b),
	.out = chunk_from_chars(
		0xe5,0x70,0xe7,0x48,0x46,0x34,0x30,0x0d,0x7a,0xdd,0xf5,0xa8,0x52,0x7c,0x13,0x8b,
		0x76,0x96,0xdb,0xc3,0xd8,0xbe,0x09,0x69,0xb7,0x52,0x15,0x31,0x8a,0x11,0xad,0xa2,
		0x13,0x53,0x8f,0x62,0x93,0xb0,0xee,0xe5,0xb3,0x09,0xad,0x8f,0x5d,0x8d,0x94,0xdb,
		0xe5,0x73,0x61,0x27,0xe0,0xd2,0x56,0x0f,0x28,0x1c,0x9c,0x58,0x6b,0xf7,0xc8,0x6f),
};
