#!/usr/bin/env python3

from distutils.core import setup
import glob
from DistUtilsExtra.command import *

setup(name='software-properties',
      version='0.60',
      packages=[
                'softwareproperties',
                'softwareproperties.dbus',
                'softwareproperties.gtk',
                'softwareproperties.kde',
                ],
      scripts=[
               'software-properties-gtk',
               'software-properties-kde',
               'add-apt-repository',
               ],
      data_files=[
                  ("../etc/dbus-1/system.d/",
                   ["data/com.ubuntu.SoftwareProperties.conf"]
                  ),
                  ("share/dbus-1/system-services/",
                   ["data/com.ubuntu.SoftwareProperties.service"]
                  ),
                  ('share/software-properties/designer',
                   glob.glob("data/designer/*.ui")
                  ),
                  ('share/software-properties/gtkbuilder',
                   glob.glob("data/gtkbuilder/*.ui")
                  ),
                  ('lib/software-properties/',
                   ['software-properties-dbus', ]
                  ),
                  ],
      cmdclass = { "build" : build_extra.build_extra,
                   "build_i18n" :  build_i18n.build_i18n,
#                   "build_help" :  build_help.build_help,
                   "build_icons" :  build_icons.build_icons }
     )
