#!/bin/sh
set -e

if [ -z "$GOPACKAGE" ]; then
    # not being run from 'go generate'
    cd "$(dirname "$0")"/cmd
fi

if which git >/dev/null; then
    v="$( git describe --dirty --always | sed -e 's/-/+git/;y/-/./' )"
    o=git
fi

if [ -z "$v" ]; then
    v="$(cd "$(dirname $0)"; dpkg-parsechangelog --show-field Version)"
    o=debian/changelog
fi

if [ -z "$v" ]; then
    exit 1
fi

echo "*** Setting version to '$v' from $o." >&2

cat <<EOF > version_generated.go
package cmd

// generated by mkversion.sh; do not edit

func init() {
	Version = "$v"
}
EOF
