/* ui.c generated by valac 0.20.1, the Vala compiler
 * generated from ui.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <gobject/gvaluecollector.h>


#define TYPE_USER_INTERFACE (user_interface_get_type ())
#define USER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_INTERFACE, UserInterface))
#define USER_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_INTERFACE, UserInterfaceClass))
#define IS_USER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_INTERFACE))
#define IS_USER_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_INTERFACE))
#define USER_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_INTERFACE, UserInterfaceClass))

typedef struct _UserInterface UserInterface;
typedef struct _UserInterfaceClass UserInterfaceClass;
typedef struct _UserInterfacePrivate UserInterfacePrivate;

#define TYPE_PROGRESS_BAR_DIALOG (progress_bar_dialog_get_type ())
#define PROGRESS_BAR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROGRESS_BAR_DIALOG, ProgressBarDialog))
#define PROGRESS_BAR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROGRESS_BAR_DIALOG, ProgressBarDialogClass))
#define IS_PROGRESS_BAR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROGRESS_BAR_DIALOG))
#define IS_PROGRESS_BAR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROGRESS_BAR_DIALOG))
#define PROGRESS_BAR_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROGRESS_BAR_DIALOG, ProgressBarDialogClass))

typedef struct _ProgressBarDialog ProgressBarDialog;
typedef struct _ProgressBarDialogClass ProgressBarDialogClass;

#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;

#define TYPE_AUTOSAVE_MANAGER (autosave_manager_get_type ())
#define AUTOSAVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AUTOSAVE_MANAGER, AutosaveManager))
#define AUTOSAVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AUTOSAVE_MANAGER, AutosaveManagerClass))
#define IS_AUTOSAVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AUTOSAVE_MANAGER))
#define IS_AUTOSAVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AUTOSAVE_MANAGER))
#define AUTOSAVE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AUTOSAVE_MANAGER, AutosaveManagerClass))

typedef struct _AutosaveManager AutosaveManager;
typedef struct _AutosaveManagerClass AutosaveManagerClass;

#define TYPE_BOOK_VIEW (book_view_get_type ())
#define BOOK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK_VIEW, BookView))
#define BOOK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK_VIEW, BookViewClass))
#define IS_BOOK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK_VIEW))
#define IS_BOOK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK_VIEW))
#define BOOK_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK_VIEW, BookViewClass))

typedef struct _BookView BookView;
typedef struct _BookViewClass BookViewClass;

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _book_unref0(var) ((var == NULL) ? NULL : (var = (book_unref (var), NULL)))
#define _autosave_manager_unref0(var) ((var == NULL) ? NULL : (var = (autosave_manager_unref (var), NULL)))
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))

#define TYPE_SCAN_DEVICE (scan_device_get_type ())
#define SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_DEVICE, ScanDevice))
#define SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_DEVICE, ScanDeviceClass))
#define IS_SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_DEVICE))
#define IS_SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_DEVICE))
#define SCAN_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_DEVICE, ScanDeviceClass))

typedef struct _ScanDevice ScanDevice;
typedef struct _ScanDeviceClass ScanDeviceClass;
typedef struct _ScanDevicePrivate ScanDevicePrivate;
#define _scan_device_unref0(var) ((var == NULL) ? NULL : (var = (scan_device_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_SCAN_TYPE (scan_type_get_type ())

#define TYPE_SCAN_OPTIONS (scan_options_get_type ())
#define SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_OPTIONS, ScanOptions))
#define SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_OPTIONS, ScanOptionsClass))
#define IS_SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_OPTIONS))
#define IS_SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_OPTIONS))
#define SCAN_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_OPTIONS, ScanOptionsClass))

typedef struct _ScanOptions ScanOptions;
typedef struct _ScanOptionsClass ScanOptionsClass;

#define TYPE_SCAN_MODE (scan_mode_get_type ())
typedef struct _ScanOptionsPrivate ScanOptionsPrivate;
#define _scan_options_unref0(var) ((var == NULL) ? NULL : (var = (scan_options_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _ParamSpecUserInterface ParamSpecUserInterface;
typedef struct _ProgressBarDialogPrivate ProgressBarDialogPrivate;

struct _UserInterface {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UserInterfacePrivate * priv;
};

struct _UserInterfaceClass {
	GTypeClass parent_class;
	void (*finalize) (UserInterface *self);
};

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _UserInterfacePrivate {
	GSettings* settings;
	GtkBuilder* builder;
	GtkWindow* window;
	GtkVBox* main_vbox;
	GtkInfoBar* info_bar;
	GtkImage* info_bar_image;
	GtkLabel* info_bar_label;
	GtkButton* info_bar_close_button;
	GtkButton* info_bar_change_scanner_button;
	GtkMenuItem* page_move_left_menuitem;
	GtkMenuItem* page_move_right_menuitem;
	GtkMenuItem* page_delete_menuitem;
	GtkMenuItem* crop_rotate_menuitem;
	GtkMenuItem* save_menuitem;
	GtkMenuItem* save_as_menuitem;
	GtkMenuItem* copy_to_clipboard_menuitem;
	GtkToolButton* save_toolbutton;
	GtkMenuItem* stop_menuitem;
	GtkToolButton* stop_toolbutton;
	GtkRadioMenuItem* text_toolbar_menuitem;
	GtkRadioMenuItem* text_menu_menuitem;
	GtkRadioMenuItem* photo_toolbar_menuitem;
	GtkRadioMenuItem* photo_menu_menuitem;
	GtkDialog* authorize_dialog;
	GtkLabel* authorize_label;
	GtkEntry* username_entry;
	GtkEntry* password_entry;
	GtkDialog* preferences_dialog;
	GtkComboBox* device_combo;
	GtkComboBox* text_dpi_combo;
	GtkComboBox* photo_dpi_combo;
	GtkComboBox* page_side_combo;
	GtkComboBox* paper_size_combo;
	GtkScale* brightness_scale;
	GtkScale* contrast_scale;
	GtkScale* quality_scale;
	GtkListStore* device_model;
	GtkListStore* text_dpi_model;
	GtkListStore* photo_dpi_model;
	GtkListStore* page_side_model;
	GtkListStore* paper_size_model;
	GtkAdjustment* brightness_adjustment;
	GtkAdjustment* contrast_adjustment;
	GtkAdjustment* quality_adjustment;
	gboolean setting_devices;
	gboolean user_selected_device;
	GtkFileChooserDialog* save_dialog;
	ProgressBarDialog* progress_dialog;
	gboolean have_error;
	gchar* error_title;
	gchar* error_text;
	gboolean error_change_scanner_hint;
	Book* book;
	gchar* book_uri;
	AutosaveManager* autosave_manager;
	BookView* book_view;
	gboolean updating_page_menu;
	gint default_page_width;
	gint default_page_height;
	gint default_page_dpi;
	ScanDirection default_page_scan_direction;
	gchar* document_hint;
	gchar* default_file_name;
	gboolean scanning;
	gint window_width;
	gint window_height;
	gboolean window_is_maximized;
};

struct _ScanDevice {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanDevicePrivate * priv;
	gchar* name;
	gchar* label;
};

struct _ScanDeviceClass {
	GTypeClass parent_class;
	void (*finalize) (ScanDevice *self);
};

typedef enum  {
	SCAN_TYPE_SINGLE,
	SCAN_TYPE_ADF_FRONT,
	SCAN_TYPE_ADF_BACK,
	SCAN_TYPE_ADF_BOTH
} ScanType;

typedef enum  {
	SCAN_MODE_DEFAULT,
	SCAN_MODE_COLOR,
	SCAN_MODE_GRAY,
	SCAN_MODE_LINEART
} ScanMode;

struct _ScanOptions {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanOptionsPrivate * priv;
	gint dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	gint paper_width;
	gint paper_height;
	gint brightness;
	gint contrast;
};

struct _ScanOptionsClass {
	GTypeClass parent_class;
	void (*finalize) (ScanOptions *self);
};

struct _ParamSpecUserInterface {
	GParamSpec parent_instance;
};

struct _ProgressBarDialog {
	GtkWindow parent_instance;
	ProgressBarDialogPrivate * priv;
};

struct _ProgressBarDialogClass {
	GtkWindowClass parent_class;
};

struct _ProgressBarDialogPrivate {
	GtkProgressBar* bar;
};


static gpointer user_interface_parent_class = NULL;
static gpointer progress_bar_dialog_parent_class = NULL;

gpointer user_interface_ref (gpointer instance);
void user_interface_unref (gpointer instance);
GParamSpec* param_spec_user_interface (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_user_interface (GValue* value, gpointer v_object);
void value_take_user_interface (GValue* value, gpointer v_object);
gpointer value_get_user_interface (const GValue* value);
GType user_interface_get_type (void) G_GNUC_CONST;
GType progress_bar_dialog_get_type (void) G_GNUC_CONST;
gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_book (GValue* value, gpointer v_object);
void value_take_book (GValue* value, gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
gpointer autosave_manager_ref (gpointer instance);
void autosave_manager_unref (gpointer instance);
GParamSpec* param_spec_autosave_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_autosave_manager (GValue* value, gpointer v_object);
void value_take_autosave_manager (GValue* value, gpointer v_object);
gpointer value_get_autosave_manager (const GValue* value);
GType autosave_manager_get_type (void) G_GNUC_CONST;
GType book_view_get_type (void) G_GNUC_CONST;
GType scan_direction_get_type (void) G_GNUC_CONST;
#define USER_INTERFACE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_USER_INTERFACE, UserInterfacePrivate))
enum  {
	USER_INTERFACE_DUMMY_PROPERTY
};
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
static void user_interface_page_removed_cb (UserInterface* self, Book* book, Page* page);
static void _user_interface_page_removed_cb_book_page_removed (Book* _sender, Page* page, gpointer self);
static void user_interface_page_added_cb (UserInterface* self, Book* book, Page* page);
static void _user_interface_page_added_cb_book_page_added (Book* _sender, Page* page, gpointer self);
#define USER_INTERFACE_DEFAULT_TEXT_DPI 150
#define USER_INTERFACE_DEFAULT_PHOTO_DPI 300
UserInterface* user_interface_new (void);
UserInterface* user_interface_construct (GType object_type);
Book* book_new (void);
Book* book_construct (GType object_type);
static void user_interface_load (UserInterface* self);
AutosaveManager* autosave_manager_new (void);
AutosaveManager* autosave_manager_construct (GType object_type);
void autosave_manager_set_book (AutosaveManager* self, Book* value);
void autosave_manager_load (AutosaveManager* self);
guint book_get_n_pages (Book* self);
static void user_interface_add_default_page (UserInterface* self);
void book_set_needs_saving (Book* self, gboolean needs_saving);
void book_view_select_page (BookView* self, Page* page);
Page* book_get_page (Book* self, gint page_number);
static void user_interface_needs_saving_cb (UserInterface* self, Book* book);
static void _user_interface_needs_saving_cb_book_needs_saving_changed (Book* _sender, gpointer self);
static gboolean user_interface_find_scan_device (UserInterface* self, const gchar* device, GtkTreeIter* iter);
static void user_interface_show_error_dialog (UserInterface* self, const gchar* error_title, const gchar* error_text);
void user_interface_set_default_file_name (UserInterface* self, const gchar* default_file_name);
void user_interface_authorize (UserInterface* self, const gchar* resource, gchar** username, gchar** password);
void G_MODULE_EXPORT device_combo_changed_cb (GtkWidget* widget, UserInterface* self);
static void user_interface_update_info_bar (UserInterface* self);
gpointer scan_device_ref (gpointer instance);
void scan_device_unref (gpointer instance);
GParamSpec* param_spec_scan_device (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_device (GValue* value, gpointer v_object);
void value_take_scan_device (GValue* value, gpointer v_object);
gpointer value_get_scan_device (const GValue* value);
GType scan_device_get_type (void) G_GNUC_CONST;
void user_interface_set_scan_devices (UserInterface* self, GList* devices);
static gchar* user_interface_get_selected_device (UserInterface* self);
void user_interface_set_selected_device (UserInterface* self, const gchar* device);
Page* page_new (gint width, gint height, gint dpi, ScanDirection scan_direction);
Page* page_construct (GType object_type, gint width, gint height, gint dpi, ScanDirection scan_direction);
void book_append_page (Book* self, Page* page);
static void user_interface_on_file_type_changed (UserInterface* self, GtkTreeSelection* selection);
static gchar* user_interface_get_selected_extension (UserInterface* self, GtkTreeSelection* selection);
static gchar* user_interface_choose_file_location (UserInterface* self);
static void _user_interface_on_file_type_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static gboolean user_interface_save_document (UserInterface* self, gboolean force_choose_location);
void user_interface_show_progress_dialog (UserInterface* self);
void book_save (Book* self, const gchar* type, gint quality, GFile* file, GError** error);
static gint user_interface_get_quality (UserInterface* self);
void user_interface_hide_progress_dialog (UserInterface* self);
void user_interface_show_error (UserInterface* self, const gchar* error_title, const gchar* error_text, gboolean change_scanner_hint);
static gboolean user_interface_prompt_to_save (UserInterface* self, const gchar* title, const gchar* discard_label);
gboolean book_get_needs_saving (Book* self);
static void user_interface_clear_document (UserInterface* self);
void book_clear (Book* self);
void G_MODULE_EXPORT new_button_clicked_cb (GtkWidget* widget, UserInterface* self);
static void user_interface_set_document_hint (UserInterface* self, const gchar* document_hint);
void G_MODULE_EXPORT text_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT photo_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
GType scan_type_get_type (void) G_GNUC_CONST;
static void user_interface_set_page_side (UserInterface* self, ScanType page_side);
static void user_interface_set_paper_size (UserInterface* self, gint width, gint height);
static void user_interface_set_brightness (UserInterface* self, gint brightness);
static void user_interface_set_contrast (UserInterface* self, gint contrast);
static void user_interface_set_quality (UserInterface* self, gint quality);
static gint user_interface_get_text_dpi (UserInterface* self);
static gint user_interface_get_photo_dpi (UserInterface* self);
static ScanType user_interface_get_page_side (UserInterface* self);
static gboolean user_interface_get_paper_size (UserInterface* self, gint* width, gint* height);
static gint user_interface_get_brightness (UserInterface* self);
static gint user_interface_get_contrast (UserInterface* self);
gpointer scan_options_ref (gpointer instance);
void scan_options_unref (gpointer instance);
GParamSpec* param_spec_scan_options (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_options (GValue* value, gpointer v_object);
void value_take_scan_options (GValue* value, gpointer v_object);
gpointer value_get_scan_options (const GValue* value);
GType scan_options_get_type (void) G_GNUC_CONST;
static ScanOptions* user_interface_get_scan_options (UserInterface* self);
ScanOptions* scan_options_new (void);
ScanOptions* scan_options_construct (GType object_type);
GType scan_mode_get_type (void) G_GNUC_CONST;
void G_MODULE_EXPORT scan_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT stop_scan_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT continuous_scan_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT preferences_button_clicked_cb (GtkWidget* widget, UserInterface* self);
gboolean G_MODULE_EXPORT preferences_dialog_delete_event_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT preferences_dialog_response_cb (GtkWidget* widget, gint response_id, UserInterface* self);
static void user_interface_update_page_menu (UserInterface* self);
Page* book_view_get_selected (BookView* self);
guint book_get_page_index (Book* self, Page* page);
static void user_interface_page_selected_cb (UserInterface* self, BookView* view, Page* page);
gboolean page_has_crop (Page* self);
gchar* page_get_named_crop (Page* self);
static void user_interface_show_page_cb (UserInterface* self, BookView* view, Page* page);
gchar* get_temporary_filename (const gchar* prefix, const gchar* extension);
void page_save (Page* self, const gchar* type, gint quality, GFile* file, GError** error);
static void user_interface_show_page_menu_cb (UserInterface* self, BookView* view);
void G_MODULE_EXPORT rotate_left_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void page_rotate_left (Page* self);
void G_MODULE_EXPORT rotate_right_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void page_rotate_right (Page* self);
static void user_interface_set_crop (UserInterface* self, const gchar* crop_name);
void page_set_no_crop (Page* self);
gint page_get_width (Page* self);
gint page_get_height (Page* self);
void page_set_custom_crop (Page* self, gint width, gint height);
void page_move_crop (Page* self, gint x, gint y);
void page_set_named_crop (Page* self, const gchar* name);
void G_MODULE_EXPORT no_crop_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT custom_crop_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT crop_toolbutton_toggled_cb (GtkToggleToolButton* widget, UserInterface* self);
void G_MODULE_EXPORT four_by_six_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT legal_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT letter_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT a6_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT a5_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT a4_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT crop_rotate_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
void page_rotate_crop (Page* self);
void G_MODULE_EXPORT page_move_left_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
void book_move_page (Book* self, Page* page, guint location);
void G_MODULE_EXPORT page_move_right_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT page_delete_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
Book* book_view_get_book (BookView* self);
void book_delete_page (Book* self, Page* page);
void G_MODULE_EXPORT save_file_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT copy_to_clipboard_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void page_copy_to_clipboard (Page* self, GtkWindow* window);
void G_MODULE_EXPORT save_as_file_button_clicked_cb (GtkWidget* widget, UserInterface* self);
static void user_interface_draw_page (UserInterface* self, GtkPrintOperation* operation, GtkPrintContext* print_context, gint page_number);
gboolean page_is_landscape (Page* self);
gint page_get_dpi (Page* self);
GdkPixbuf* page_get_image (Page* self, gboolean apply_crop);
void G_MODULE_EXPORT email_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT print_button_clicked_cb (GtkWidget* widget, UserInterface* self);
static void _user_interface_draw_page_gtk_print_operation_draw_page (GtkPrintOperation* _sender, GtkPrintContext* context, gint page_nr, gpointer self);
void G_MODULE_EXPORT help_contents_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT about_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
static gboolean user_interface_on_quit (UserInterface* self);
void autosave_manager_cleanup (AutosaveManager* self);
void G_MODULE_EXPORT quit_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
gboolean G_MODULE_EXPORT simple_scan_window_configure_event_cb (GtkWidget* widget, GdkEventConfigure* event, UserInterface* self);
static void user_interface_info_bar_response_cb (UserInterface* self, GtkInfoBar* widget, gint response_id);
gboolean G_MODULE_EXPORT simple_scan_window_window_state_event_cb (GtkWidget* widget, GdkEventWindowState* event, UserInterface* self);
gboolean G_MODULE_EXPORT window_delete_event_cb (GtkWidget* widget, GdkEvent* event, UserInterface* self);
static void user_interface_page_size_changed_cb (UserInterface* self, Page* page);
static void user_interface_page_scan_direction_changed_cb (UserInterface* self, Page* page);
ScanDirection page_get_scan_direction (Page* self);
static void _user_interface_page_size_changed_cb_page_size_changed (Page* _sender, gpointer self);
static void _user_interface_page_scan_direction_changed_cb_page_scan_direction_changed (Page* _sender, gpointer self);
static void user_interface_set_dpi_combo (UserInterface* self, GtkComboBox* combo, gint default_dpi, gint current_dpi);
static void _user_interface_info_bar_response_cb_gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self);
BookView* book_view_new (Book* book);
BookView* book_view_construct (GType object_type, Book* book);
static void _user_interface_page_selected_cb_book_view_page_selected (BookView* _sender, Page* page, gpointer self);
static void _user_interface_show_page_cb_book_view_show_page (BookView* _sender, Page* page, gpointer self);
static void _user_interface_show_page_menu_cb_book_view_show_menu (BookView* _sender, gpointer self);
ProgressBarDialog* progress_bar_dialog_new (GtkWindow* parent, const gchar* title);
ProgressBarDialog* progress_bar_dialog_construct (GType object_type, GtkWindow* parent, const gchar* title);
static void user_interface_book_saving_cb (UserInterface* self, gint page_number);
static void _user_interface_book_saving_cb_book_saving (Book* _sender, gint i, gpointer self);
static gboolean ___lambda3_ (UserInterface* self);
static gboolean ____lambda3__gsource_func (gpointer self);
void progress_bar_dialog_set_fraction (ProgressBarDialog* self, gdouble percent);
void progress_bar_dialog_set_message (ProgressBarDialog* self, const gchar* message);
Book* user_interface_get_book (UserInterface* self);
void user_interface_set_selected_page (UserInterface* self, Page* page);
Page* user_interface_get_selected_page (UserInterface* self);
void user_interface_set_scanning (UserInterface* self, gboolean scanning);
void user_interface_start (UserInterface* self);
static void g_cclosure_user_marshal_VOID__STRING_SCAN_OPTIONS (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void user_interface_finalize (UserInterface* obj);
#define PROGRESS_BAR_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PROGRESS_BAR_DIALOG, ProgressBarDialogPrivate))
enum  {
	PROGRESS_BAR_DIALOG_DUMMY_PROPERTY
};
static void progress_bar_dialog_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _user_interface_page_removed_cb_book_page_removed (Book* _sender, Page* page, gpointer self) {
#line 128 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_page_removed_cb (self, _sender, page);
#line 509 "ui.c"
}


static void _user_interface_page_added_cb_book_page_added (Book* _sender, Page* page, gpointer self) {
#line 129 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_page_added_cb (self, _sender, page);
#line 516 "ui.c"
}


static void _user_interface_needs_saving_cb_book_needs_saving_changed (Book* _sender, gpointer self) {
#line 123 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_needs_saving_cb (self, _sender);
#line 523 "ui.c"
}


UserInterface* user_interface_construct (GType object_type) {
	UserInterface* self = NULL;
	GSettings* _tmp0_;
	Book* _tmp1_;
	Book* _tmp2_;
	Book* _tmp3_;
	AutosaveManager* _tmp4_;
	AutosaveManager* _tmp5_;
	Book* _tmp6_;
	AutosaveManager* _tmp7_;
	Book* _tmp8_;
	guint _tmp9_ = 0U;
	Book* _tmp15_;
#line 102 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self = (UserInterface*) g_type_create_instance (object_type);
#line 104 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = g_settings_new ("org.gnome.SimpleScan");
#line 104 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->settings);
#line 104 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->settings = _tmp0_;
#line 106 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = book_new ();
#line 106 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_book_unref0 (self->priv->book);
#line 106 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->book = _tmp1_;
#line 107 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = self->priv->book;
#line 107 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_signal_connect (_tmp2_, "page-removed", (GCallback) _user_interface_page_removed_cb_book_page_removed, self);
#line 108 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = self->priv->book;
#line 108 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_signal_connect (_tmp3_, "page-added", (GCallback) _user_interface_page_added_cb_book_page_added, self);
#line 110 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_load (self);
#line 112 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp4_ = autosave_manager_new ();
#line 112 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_autosave_manager_unref0 (self->priv->autosave_manager);
#line 112 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->autosave_manager = _tmp4_;
#line 113 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp5_ = self->priv->autosave_manager;
#line 113 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp6_ = self->priv->book;
#line 113 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	autosave_manager_set_book (_tmp5_, _tmp6_);
#line 114 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp7_ = self->priv->autosave_manager;
#line 114 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	autosave_manager_load (_tmp7_);
#line 116 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp8_ = self->priv->book;
#line 116 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp9_ = book_get_n_pages (_tmp8_);
#line 116 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp9_ == ((guint) 0)) {
#line 586 "ui.c"
		Book* _tmp10_;
#line 118 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		user_interface_add_default_page (self);
#line 119 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp10_ = self->priv->book;
#line 119 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		book_set_needs_saving (_tmp10_, FALSE);
#line 594 "ui.c"
	} else {
		BookView* _tmp11_;
		Book* _tmp12_;
		Page* _tmp13_ = NULL;
		Page* _tmp14_;
#line 122 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp11_ = self->priv->book_view;
#line 122 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp12_ = self->priv->book;
#line 122 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp13_ = book_get_page (_tmp12_, 0);
#line 122 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp14_ = _tmp13_;
#line 122 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		book_view_select_page (_tmp11_, _tmp14_);
#line 122 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_page_unref0 (_tmp14_);
#line 612 "ui.c"
	}
#line 123 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp15_ = self->priv->book;
#line 123 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_signal_connect (_tmp15_, "needs-saving-changed", (GCallback) _user_interface_needs_saving_cb_book_needs_saving_changed, self);
#line 102 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return self;
#line 620 "ui.c"
}


UserInterface* user_interface_new (void) {
#line 102 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return user_interface_construct (TYPE_USER_INTERFACE);
#line 627 "ui.c"
}


static gboolean user_interface_find_scan_device (UserInterface* self, const gchar* device, GtkTreeIter* iter) {
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	gboolean have_iter;
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 132 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 132 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (device != NULL, FALSE);
#line 134 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	have_iter = FALSE;
#line 136 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->device_model;
#line 136 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
#line 136 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_vala_iter = _tmp1_;
#line 136 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp2_) {
#line 652 "ui.c"
		{
			gboolean _tmp3_;
#line 138 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp3_ = TRUE;
#line 138 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			while (TRUE) {
#line 659 "ui.c"
				gboolean _tmp4_;
				gchar* d = NULL;
				GtkListStore* _tmp10_;
				GtkTreeIter _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
#line 138 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp4_ = _tmp3_;
#line 138 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				if (!_tmp4_) {
#line 670 "ui.c"
					gboolean _tmp5_ = FALSE;
					gboolean _tmp6_;
					gboolean _tmp9_;
#line 144 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp6_ = have_iter;
#line 144 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					if (!_tmp6_) {
#line 678 "ui.c"
						GtkListStore* _tmp7_;
						gboolean _tmp8_ = FALSE;
#line 144 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
						_tmp7_ = self->priv->device_model;
#line 144 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
						_tmp8_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp7_, &_vala_iter);
#line 144 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
						_tmp5_ = _tmp8_;
#line 687 "ui.c"
					} else {
#line 144 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
						_tmp5_ = FALSE;
#line 691 "ui.c"
					}
#line 144 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp9_ = _tmp5_;
#line 144 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					if (!_tmp9_) {
#line 144 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
						break;
#line 699 "ui.c"
					}
				}
#line 138 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp3_ = FALSE;
#line 141 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp10_ = self->priv->device_model;
#line 141 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp11_ = _vala_iter;
#line 141 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				gtk_tree_model_get ((GtkTreeModel*) _tmp10_, &_tmp11_, 0, &d, -1, -1);
#line 142 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp12_ = d;
#line 142 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp13_ = device;
#line 142 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				if (g_strcmp0 (_tmp12_, _tmp13_) == 0) {
#line 143 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					have_iter = TRUE;
#line 718 "ui.c"
				}
#line 138 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_g_free0 (d);
#line 722 "ui.c"
			}
		}
	}
#line 147 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	result = have_iter;
#line 147 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (iter) {
#line 147 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		*iter = _vala_iter;
#line 732 "ui.c"
	}
#line 147 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return result;
#line 736 "ui.c"
}


static void user_interface_show_error_dialog (UserInterface* self, const gchar* error_title, const gchar* error_text) {
	GtkWindow* _tmp0_;
	const gchar* _tmp1_;
	GtkMessageDialog* _tmp2_;
	GtkMessageDialog* dialog;
	const gchar* _tmp3_;
#line 150 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 150 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (error_title != NULL);
#line 150 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (error_text != NULL);
#line 152 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->window;
#line 152 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = error_title;
#line 152 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, "%s", _tmp1_);
#line 152 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_object_ref_sink (_tmp2_);
#line 152 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	dialog = _tmp2_;
#line 157 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_dialog_add_button ((GtkDialog*) dialog, GTK_STOCK_CLOSE, 0);
#line 158 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = error_text;
#line 158 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_message_dialog_format_secondary_text (dialog, "%s", _tmp3_);
#line 159 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_destroy ((GtkWidget*) dialog);
#line 150 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (dialog);
#line 772 "ui.c"
}


void user_interface_set_default_file_name (UserInterface* self, const gchar* default_file_name) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 162 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 162 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (default_file_name != NULL);
#line 164 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = default_file_name;
#line 164 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 164 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (self->priv->default_file_name);
#line 164 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->default_file_name = _tmp1_;
#line 791 "ui.c"
}


void user_interface_authorize (UserInterface* self, const gchar* resource, gchar** username, gchar** password) {
	gchar* _vala_username = NULL;
	gchar* _vala_password = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* description;
	GtkEntry* _tmp3_;
	GtkEntry* _tmp4_;
	GtkLabel* _tmp5_;
	GtkDialog* _tmp6_;
	GtkDialog* _tmp7_;
	GtkDialog* _tmp8_;
	GtkEntry* _tmp9_;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	GtkEntry* _tmp12_;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
#line 167 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 167 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (resource != NULL);
#line 170 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = _ ("Username and password required to access '%s'");
#line 170 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = resource;
#line 170 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = g_strdup_printf (_tmp0_, _tmp1_);
#line 170 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	description = _tmp2_;
#line 172 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = self->priv->username_entry;
#line 172 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_entry_set_text (_tmp3_, "");
#line 173 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp4_ = self->priv->password_entry;
#line 173 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_entry_set_text (_tmp4_, "");
#line 174 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp5_ = self->priv->authorize_label;
#line 174 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_label_set_text (_tmp5_, description);
#line 176 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp6_ = self->priv->authorize_dialog;
#line 176 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp6_);
#line 177 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp7_ = self->priv->authorize_dialog;
#line 177 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_dialog_run (_tmp7_);
#line 178 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp8_ = self->priv->authorize_dialog;
#line 178 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_hide ((GtkWidget*) _tmp8_);
#line 180 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp9_ = self->priv->username_entry;
#line 180 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp10_ = gtk_entry_get_text (_tmp9_);
#line 180 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp11_ = g_strdup (_tmp10_);
#line 180 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (_vala_username);
#line 180 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_vala_username = _tmp11_;
#line 181 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp12_ = self->priv->password_entry;
#line 181 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp13_ = gtk_entry_get_text (_tmp12_);
#line 181 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp14_ = g_strdup (_tmp13_);
#line 181 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (_vala_password);
#line 181 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_vala_password = _tmp14_;
#line 167 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (description);
#line 167 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (username) {
#line 167 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		*username = _vala_username;
#line 876 "ui.c"
	} else {
#line 167 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (_vala_username);
#line 880 "ui.c"
	}
#line 167 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (password) {
#line 167 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		*password = _vala_password;
#line 886 "ui.c"
	} else {
#line 167 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (_vala_password);
#line 890 "ui.c"
	}
}


void G_MODULE_EXPORT device_combo_changed_cb (GtkWidget* widget, UserInterface* self) {
	gboolean _tmp0_;
#line 185 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 185 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 187 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->setting_devices;
#line 187 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp0_) {
#line 188 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		return;
#line 907 "ui.c"
	}
#line 189 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->user_selected_device = TRUE;
#line 911 "ui.c"
}


static void user_interface_update_info_bar (UserInterface* self) {
	GtkMessageType type = 0;
	gchar* title = NULL;
	gchar* text = NULL;
	gchar* image_id = NULL;
	gboolean show_close_button;
	gboolean show_change_scanner_button;
	gboolean _tmp0_;
	GtkInfoBar* _tmp15_;
	GtkMessageType _tmp16_;
	GtkImage* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_ = NULL;
	gchar* message;
	GtkLabel* _tmp22_;
	const gchar* _tmp23_;
	GtkButton* _tmp24_;
	gboolean _tmp25_;
	GtkButton* _tmp26_;
	gboolean _tmp27_;
	GtkInfoBar* _tmp28_;
#line 192 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 196 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	show_close_button = FALSE;
#line 197 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	show_change_scanner_button = FALSE;
#line 199 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->have_error;
#line 199 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp0_) {
#line 948 "ui.c"
		gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gboolean _tmp6_;
#line 201 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		type = GTK_MESSAGE_ERROR;
#line 202 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp1_ = g_strdup (GTK_STOCK_DIALOG_ERROR);
#line 202 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (image_id);
#line 202 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		image_id = _tmp1_;
#line 203 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp2_ = self->priv->error_title;
#line 203 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp3_ = g_strdup (_tmp2_);
#line 203 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (title);
#line 203 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		title = _tmp3_;
#line 204 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp4_ = self->priv->error_text;
#line 204 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 204 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (text);
#line 204 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		text = _tmp5_;
#line 205 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		show_close_button = TRUE;
#line 206 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp6_ = self->priv->error_change_scanner_hint;
#line 206 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		show_change_scanner_button = _tmp6_;
#line 985 "ui.c"
	} else {
		GtkListStore* _tmp7_;
		gint _tmp8_ = 0;
#line 208 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp7_ = self->priv->device_model;
#line 208 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp8_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp7_, NULL);
#line 208 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		if (_tmp8_ == 0) {
#line 995 "ui.c"
			gchar* _tmp9_;
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
#line 210 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			type = GTK_MESSAGE_WARNING;
#line 211 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp9_ = g_strdup (GTK_STOCK_DIALOG_WARNING);
#line 211 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_g_free0 (image_id);
#line 211 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			image_id = _tmp9_;
#line 213 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp10_ = _ ("No scanners detected");
#line 213 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp11_ = g_strdup (_tmp10_);
#line 213 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_g_free0 (title);
#line 213 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			title = _tmp11_;
#line 215 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp12_ = _ ("Please check your scanner is connected and powered on");
#line 215 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp13_ = g_strdup (_tmp12_);
#line 215 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_g_free0 (text);
#line 215 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			text = _tmp13_;
#line 1025 "ui.c"
		} else {
			GtkInfoBar* _tmp14_;
#line 219 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp14_ = self->priv->info_bar;
#line 219 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			gtk_widget_hide ((GtkWidget*) _tmp14_);
#line 220 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_g_free0 (image_id);
#line 220 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_g_free0 (text);
#line 220 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_g_free0 (title);
#line 220 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			return;
#line 1040 "ui.c"
		}
	}
#line 223 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp15_ = self->priv->info_bar;
#line 223 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp16_ = type;
#line 223 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_info_bar_set_message_type (_tmp15_, _tmp16_);
#line 224 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp17_ = self->priv->info_bar_image;
#line 224 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp18_ = image_id;
#line 224 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_image_set_from_stock (_tmp17_, _tmp18_, GTK_ICON_SIZE_DIALOG);
#line 225 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp19_ = title;
#line 225 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp20_ = text;
#line 225 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp21_ = g_strdup_printf ("<big><b>%s</b></big>\n\n%s", _tmp19_, _tmp20_);
#line 225 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	message = _tmp21_;
#line 226 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp22_ = self->priv->info_bar_label;
#line 226 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp23_ = message;
#line 226 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_label_set_markup (_tmp22_, _tmp23_);
#line 227 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp24_ = self->priv->info_bar_close_button;
#line 227 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp25_ = show_close_button;
#line 227 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp24_, _tmp25_);
#line 228 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp26_ = self->priv->info_bar_change_scanner_button;
#line 228 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp27_ = show_change_scanner_button;
#line 228 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp26_, _tmp27_);
#line 229 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp28_ = self->priv->info_bar;
#line 229 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp28_);
#line 192 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (message);
#line 192 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (image_id);
#line 192 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (text);
#line 192 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (title);
#line 1093 "ui.c"
}


static gpointer _scan_device_ref0 (gpointer self) {
#line 246 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return self ? scan_device_ref (self) : NULL;
#line 1100 "ui.c"
}


void user_interface_set_scan_devices (UserInterface* self, GList* devices) {
	gboolean have_selection;
	gint index = 0;
	GtkTreeIter iter = {0};
	gboolean _tmp0_;
	GList* _tmp3_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_;
	gboolean _tmp55_;
#line 232 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 234 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	have_selection = FALSE;
#line 238 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->setting_devices = TRUE;
#line 241 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->user_selected_device;
#line 241 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp0_) {
#line 1123 "ui.c"
		GtkComboBox* _tmp1_;
		gint _tmp2_ = 0;
#line 242 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp1_ = self->priv->device_combo;
#line 242 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp2_ = gtk_combo_box_get_active (_tmp1_);
#line 242 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		have_selection = _tmp2_ >= 0;
#line 1132 "ui.c"
	}
#line 245 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	index = 0;
#line 246 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = devices;
#line 1138 "ui.c"
	{
		GList* device_collection = NULL;
		GList* device_it = NULL;
#line 246 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		device_collection = _tmp3_;
#line 246 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
#line 1146 "ui.c"
			ScanDevice* _tmp4_;
			ScanDevice* device = NULL;
#line 246 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp4_ = _scan_device_ref0 ((ScanDevice*) device_it->data);
#line 246 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			device = _tmp4_;
#line 1153 "ui.c"
			{
				gint n_delete;
				GtkListStore* _tmp5_;
				gint _tmp6_;
				GtkTreeIter _tmp7_ = {0};
				gboolean _tmp8_ = FALSE;
				gint _tmp21_;
				gint _tmp45_;
#line 248 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				n_delete = -1;
#line 251 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp5_ = self->priv->device_model;
#line 251 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp6_ = index;
#line 251 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp8_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp5_, &_tmp7_, NULL, _tmp6_);
#line 251 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				iter = _tmp7_;
#line 251 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				if (_tmp8_) {
#line 1174 "ui.c"
					gint i;
#line 253 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					i = 0;
#line 1178 "ui.c"
					{
						gboolean _tmp9_;
#line 254 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
						_tmp9_ = TRUE;
#line 254 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
						while (TRUE) {
#line 1185 "ui.c"
							gboolean _tmp10_;
							gchar* name = NULL;
							gboolean matched = FALSE;
							GtkListStore* _tmp13_;
							GtkTreeIter _tmp14_;
							const gchar* _tmp15_;
							ScanDevice* _tmp16_;
							const gchar* _tmp17_;
							gboolean _tmp18_;
							gint _tmp20_;
#line 254 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							_tmp10_ = _tmp9_;
#line 254 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							if (!_tmp10_) {
#line 1200 "ui.c"
								GtkListStore* _tmp11_;
								gboolean _tmp12_ = FALSE;
#line 268 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
								_tmp11_ = self->priv->device_model;
#line 268 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
								_tmp12_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp11_, &iter);
#line 268 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
								if (!_tmp12_) {
#line 268 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
									break;
#line 1211 "ui.c"
								}
							}
#line 254 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							_tmp9_ = FALSE;
#line 259 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							_tmp13_ = self->priv->device_model;
#line 259 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							_tmp14_ = iter;
#line 259 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							gtk_tree_model_get ((GtkTreeModel*) _tmp13_, &_tmp14_, 0, &name, -1, -1);
#line 260 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							_tmp15_ = name;
#line 260 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							_tmp16_ = device;
#line 260 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							_tmp17_ = _tmp16_->name;
#line 260 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							matched = g_strcmp0 (_tmp15_, _tmp17_) == 0;
#line 262 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							_tmp18_ = matched;
#line 262 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							if (_tmp18_) {
#line 1234 "ui.c"
								gint _tmp19_;
#line 264 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
								_tmp19_ = i;
#line 264 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
								n_delete = _tmp19_;
#line 265 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
								_g_free0 (name);
#line 265 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
								break;
#line 1244 "ui.c"
							}
#line 267 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							_tmp20_ = i;
#line 267 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							i = _tmp20_ + 1;
#line 254 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							_g_free0 (name);
#line 1252 "ui.c"
						}
					}
				}
#line 272 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp21_ = n_delete;
#line 272 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				if (_tmp21_ >= 0) {
#line 1260 "ui.c"
					gint i = 0;
					GtkListStore* _tmp22_;
					GtkTreeIter _tmp23_;
					ScanDevice* _tmp24_;
					const gchar* _tmp25_;
#line 277 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp22_ = self->priv->device_model;
#line 277 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp23_ = iter;
#line 277 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp24_ = device;
#line 277 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp25_ = _tmp24_->label;
#line 277 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					gtk_list_store_set (_tmp22_, &_tmp23_, 1, _tmp25_, -1, -1);
#line 1276 "ui.c"
					{
						gboolean _tmp26_;
#line 279 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
						i = 0;
#line 279 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
						_tmp26_ = TRUE;
#line 279 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
						while (TRUE) {
#line 1285 "ui.c"
							gboolean _tmp27_;
							gint _tmp29_;
							gint _tmp30_;
							GtkListStore* _tmp31_;
							gint _tmp32_;
							GtkTreeIter _tmp33_ = {0};
							GtkListStore* _tmp34_;
							GtkTreeIter _tmp35_;
#line 279 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							_tmp27_ = _tmp26_;
#line 279 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							if (!_tmp27_) {
#line 1298 "ui.c"
								gint _tmp28_;
#line 279 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
								_tmp28_ = i;
#line 279 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
								i = _tmp28_ + 1;
#line 1304 "ui.c"
							}
#line 279 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							_tmp26_ = FALSE;
#line 279 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							_tmp29_ = i;
#line 279 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							_tmp30_ = n_delete;
#line 279 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							if (!(_tmp29_ < _tmp30_)) {
#line 279 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
								break;
#line 1316 "ui.c"
							}
#line 281 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							_tmp31_ = self->priv->device_model;
#line 281 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							_tmp32_ = index;
#line 281 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp31_, &_tmp33_, NULL, _tmp32_);
#line 281 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							iter = _tmp33_;
#line 282 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							_tmp34_ = self->priv->device_model;
#line 282 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							_tmp35_ = iter;
#line 282 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							gtk_list_store_remove (_tmp34_, &_tmp35_);
#line 1332 "ui.c"
						}
					}
				} else {
					GtkListStore* _tmp36_;
					gint _tmp37_;
					GtkTreeIter _tmp38_ = {0};
					GtkListStore* _tmp39_;
					GtkTreeIter _tmp40_;
					ScanDevice* _tmp41_;
					const gchar* _tmp42_;
					ScanDevice* _tmp43_;
					const gchar* _tmp44_;
#line 287 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp36_ = self->priv->device_model;
#line 287 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp37_ = index;
#line 287 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					gtk_list_store_insert (_tmp36_, &_tmp38_, _tmp37_);
#line 287 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					iter = _tmp38_;
#line 288 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp39_ = self->priv->device_model;
#line 288 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp40_ = iter;
#line 288 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp41_ = device;
#line 288 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp42_ = _tmp41_->name;
#line 288 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp43_ = device;
#line 288 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp44_ = _tmp43_->label;
#line 288 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					gtk_list_store_set (_tmp39_, &_tmp40_, 0, _tmp42_, 1, _tmp44_, -1, -1);
#line 1367 "ui.c"
				}
#line 290 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp45_ = index;
#line 290 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				index = _tmp45_ + 1;
#line 246 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_scan_device_unref0 (device);
#line 1375 "ui.c"
			}
		}
	}
#line 294 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	while (TRUE) {
#line 1381 "ui.c"
		GtkListStore* _tmp46_;
		gint _tmp47_;
		GtkTreeIter _tmp48_ = {0};
		gboolean _tmp49_ = FALSE;
		GtkListStore* _tmp50_;
		GtkTreeIter _tmp51_;
#line 294 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp46_ = self->priv->device_model;
#line 294 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp47_ = index;
#line 294 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp49_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp46_, &_tmp48_, NULL, _tmp47_);
#line 294 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		iter = _tmp48_;
#line 294 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		if (!_tmp49_) {
#line 294 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			break;
#line 1400 "ui.c"
		}
#line 295 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp50_ = self->priv->device_model;
#line 295 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp51_ = iter;
#line 295 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		gtk_list_store_remove (_tmp50_, &_tmp51_);
#line 1408 "ui.c"
	}
#line 298 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp53_ = have_selection;
#line 298 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (!_tmp53_) {
#line 1414 "ui.c"
		GList* _tmp54_;
#line 298 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp54_ = devices;
#line 298 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp52_ = _tmp54_ != NULL;
#line 1420 "ui.c"
	} else {
#line 298 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp52_ = FALSE;
#line 1424 "ui.c"
	}
#line 298 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp55_ = _tmp52_;
#line 298 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp55_) {
#line 1430 "ui.c"
		GtkComboBox* _tmp56_;
#line 299 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp56_ = self->priv->device_combo;
#line 299 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		gtk_combo_box_set_active (_tmp56_, 0);
#line 1436 "ui.c"
	}
#line 301 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->setting_devices = FALSE;
#line 303 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_update_info_bar (self);
#line 1442 "ui.c"
}


static gchar* user_interface_get_selected_device (UserInterface* self) {
	gchar* result = NULL;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 306 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 310 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->device_combo;
#line 310 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 310 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	iter = _tmp1_;
#line 310 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp2_) {
#line 1462 "ui.c"
		gchar* device = NULL;
		GtkListStore* _tmp3_;
		GtkTreeIter _tmp4_;
#line 313 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp3_ = self->priv->device_model;
#line 313 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp4_ = iter;
#line 313 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &device, -1, -1);
#line 314 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		result = device;
#line 314 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		return result;
#line 1476 "ui.c"
	}
#line 317 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	result = NULL;
#line 317 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return result;
#line 1482 "ui.c"
}


void user_interface_set_selected_device (UserInterface* self, const gchar* device) {
	GtkTreeIter iter = {0};
	const gchar* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GtkComboBox* _tmp3_;
	GtkTreeIter _tmp4_;
#line 320 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 320 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (device != NULL);
#line 323 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = device;
#line 323 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = user_interface_find_scan_device (self, _tmp0_, &_tmp1_);
#line 323 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	iter = _tmp1_;
#line 323 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (!_tmp2_) {
#line 324 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		return;
#line 1507 "ui.c"
	}
#line 326 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = self->priv->device_combo;
#line 326 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp4_ = iter;
#line 326 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_combo_box_set_active_iter (_tmp3_, &_tmp4_);
#line 327 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->user_selected_device = TRUE;
#line 1517 "ui.c"
}


static void user_interface_add_default_page (UserInterface* self) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	ScanDirection _tmp3_;
	Page* _tmp4_;
	Page* page;
	Book* _tmp5_;
	BookView* _tmp6_;
#line 330 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 332 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->default_page_width;
#line 332 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = self->priv->default_page_height;
#line 332 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = self->priv->default_page_dpi;
#line 332 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = self->priv->default_page_scan_direction;
#line 332 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp4_ = page_new (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 332 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	page = _tmp4_;
#line 336 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp5_ = self->priv->book;
#line 336 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	book_append_page (_tmp5_, page);
#line 337 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp6_ = self->priv->book_view;
#line 337 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	book_view_select_page (_tmp6_, page);
#line 330 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_page_unref0 (page);
#line 1554 "ui.c"
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
#line 928 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 929 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 929 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 929 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
#line 929 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 931 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 931 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 1579 "ui.c"
		gchar* _tmp4_;
#line 932 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 932 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 932 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 1587 "ui.c"
	} else {
#line 934 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = -1;
#line 934 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 1593 "ui.c"
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1190 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1191 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1191 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1191 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1192 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1192 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 1629 "ui.c"
		glong _tmp3_;
		glong _tmp4_;
#line 1193 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1193 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1193 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 1638 "ui.c"
	}
#line 1195 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1195 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 1644 "ui.c"
		glong _tmp6_;
		glong _tmp7_;
#line 1196 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1196 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1196 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 1653 "ui.c"
	}
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 1659 "ui.c"
		glong _tmp10_;
		glong _tmp11_;
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 1668 "ui.c"
	} else {
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 1672 "ui.c"
	}
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp12_ = _tmp8_;
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp14_ = end;
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp14_ >= ((glong) 0)) {
#line 1682 "ui.c"
		glong _tmp15_;
		glong _tmp16_;
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp15_ = end;
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp13_ = _tmp15_ <= _tmp16_;
#line 1691 "ui.c"
	} else {
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp13_ = FALSE;
#line 1695 "ui.c"
	}
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp17_ = _tmp13_;
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp17_, NULL);
#line 1200 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1200 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1200 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
#line 1201 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1201 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp21_ = end;
#line 1201 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp22_ = start;
#line 1201 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
#line 1201 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1201 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 1719 "ui.c"
}


static void user_interface_on_file_type_changed (UserInterface* self, GtkTreeSelection* selection) {
	GtkTreeSelection* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* extension;
	GtkFileChooserDialog* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* path;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* filename;
	const gchar* _tmp6_;
	gint _tmp7_ = 0;
	gint extension_index;
	gint _tmp8_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	GtkFileChooserDialog* _tmp15_;
	const gchar* _tmp16_;
#line 340 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 340 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (selection != NULL);
#line 342 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = selection;
#line 342 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = user_interface_get_selected_extension (self, _tmp0_);
#line 342 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	extension = _tmp1_;
#line 343 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = self->priv->save_dialog;
#line 343 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp2_);
#line 343 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	path = _tmp3_;
#line 344 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp4_ = path;
#line 344 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp5_ = g_path_get_basename (_tmp4_);
#line 344 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	filename = _tmp5_;
#line 347 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp6_ = filename;
#line 347 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp7_ = string_last_index_of_char (_tmp6_, (gunichar) '.', 0);
#line 347 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	extension_index = _tmp7_;
#line 348 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp8_ = extension_index;
#line 348 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp8_ >= 0) {
#line 1774 "ui.c"
		const gchar* _tmp9_;
		gint _tmp10_;
		gchar* _tmp11_ = NULL;
#line 349 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp9_ = filename;
#line 349 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp10_ = extension_index;
#line 349 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp11_ = string_slice (_tmp9_, (glong) 0, (glong) _tmp10_);
#line 349 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (filename);
#line 349 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		filename = _tmp11_;
#line 1788 "ui.c"
	}
#line 350 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp12_ = filename;
#line 350 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp13_ = extension;
#line 350 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp14_ = g_strconcat (_tmp12_, _tmp13_, NULL);
#line 350 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (filename);
#line 350 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	filename = _tmp14_;
#line 351 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp15_ = self->priv->save_dialog;
#line 351 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp16_ = filename;
#line 351 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp15_, _tmp16_);
#line 340 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (filename);
#line 340 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (path);
#line 340 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (extension);
#line 1812 "ui.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 360 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return self ? g_object_ref (self) : NULL;
#line 1819 "ui.c"
}


static gchar* user_interface_get_selected_extension (UserInterface* self, GtkTreeSelection* selection) {
	gchar* result = NULL;
	GtkTreeModel* model = NULL;
	GtkTreeIter iter = {0};
	gchar* _tmp0_;
	gchar* extension;
	GtkTreeSelection* _tmp1_;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_ = FALSE;
	GtkTreeModel* _tmp5_;
#line 354 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 354 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (selection != NULL, NULL);
#line 358 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = g_strdup ("");
#line 358 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	extension = _tmp0_;
#line 360 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = selection;
#line 360 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp4_ = gtk_tree_selection_get_selected (_tmp1_, &_tmp2_, &_tmp3_);
#line 360 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (model);
#line 360 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp5_ = _g_object_ref0 (_tmp2_);
#line 360 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	model = _tmp5_;
#line 360 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	iter = _tmp3_;
#line 360 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp4_) {
#line 1856 "ui.c"
		GtkTreeModel* _tmp6_;
		GtkTreeIter _tmp7_;
#line 361 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp6_ = model;
#line 361 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp7_ = iter;
#line 361 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		gtk_tree_model_get (_tmp6_, &_tmp7_, 1, &extension, -1, -1);
#line 1865 "ui.c"
	}
#line 362 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	result = extension;
#line 362 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (model);
#line 362 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return result;
#line 1873 "ui.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
#line 1157 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1157 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1157 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1157 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1158 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1158 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 1896 "ui.c"
		glong _tmp4_;
#line 1159 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1159 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1159 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 1904 "ui.c"
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 1161 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1161 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1161 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1161 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 1916 "ui.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1168 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 1941 "ui.c"
		glong _tmp2_;
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 1947 "ui.c"
	} else {
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1951 "ui.c"
	}
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = _tmp0_;
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp3_) {
#line 1957 "ui.c"
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
#line 1172 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = offset;
#line 1172 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp5_ = len;
#line 1172 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
#line 1172 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		string_length = _tmp6_;
#line 1969 "ui.c"
	} else {
		gint _tmp7_;
		gint _tmp8_;
#line 1174 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp7_ = strlen (self);
#line 1174 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1174 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp8_;
#line 1979 "ui.c"
	}
#line 1177 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp9_ = offset;
#line 1177 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp9_ < ((glong) 0)) {
#line 1985 "ui.c"
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
#line 1178 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp10_ = string_length;
#line 1178 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1178 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		offset = _tmp10_ + _tmp11_;
#line 1179 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1179 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
#line 1999 "ui.c"
	} else {
		glong _tmp13_;
		glong _tmp14_;
#line 1181 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp13_ = offset;
#line 1181 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp14_ = string_length;
#line 1181 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
#line 2009 "ui.c"
	}
#line 1183 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp15_ = len;
#line 1183 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp15_ < ((glong) 0)) {
#line 2015 "ui.c"
		glong _tmp16_;
		glong _tmp17_;
#line 1184 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1184 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp17_ = offset;
#line 1184 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		len = _tmp16_ - _tmp17_;
#line 2024 "ui.c"
	}
#line 1186 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp18_ = offset;
#line 1186 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp19_ = len;
#line 1186 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp20_ = string_length;
#line 1186 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp21_ = offset;
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp22_ = len;
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 2044 "ui.c"
}


static void _user_interface_on_file_type_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
#line 449 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_on_file_type_changed (self, _sender);
#line 2051 "ui.c"
}


static gchar* user_interface_choose_file_location (UserInterface* self) {
	gchar* result = NULL;
	gchar* directory;
	GSettings* _tmp0_;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp5_;
	const gchar* _tmp8_ = NULL;
	GtkWindow* _tmp9_;
	GtkFileChooserDialog* _tmp10_;
	GtkFileChooserDialog* _tmp11_;
	GtkFileChooserDialog* _tmp12_;
	GtkFileChooserDialog* _tmp13_;
	const gchar* _tmp14_;
	GtkFileChooserDialog* _tmp15_;
	const gchar* _tmp16_;
	GtkFileFilter* _tmp17_;
	GtkFileFilter* filter;
	GtkFileFilter* _tmp18_;
	const gchar* _tmp19_ = NULL;
	GtkFileFilter* _tmp20_;
	GtkFileFilter* _tmp21_;
	GtkFileChooserDialog* _tmp22_;
	GtkFileFilter* _tmp23_;
	GtkFileFilter* _tmp24_;
	GtkFileFilter* _tmp25_;
	const gchar* _tmp26_ = NULL;
	GtkFileFilter* _tmp27_;
	GtkFileChooserDialog* _tmp28_;
	GtkFileFilter* _tmp29_;
	const gchar* _tmp30_ = NULL;
	GtkExpander* _tmp31_;
	GtkExpander* expander;
	GtkExpander* _tmp32_;
	GtkFileChooserDialog* _tmp33_;
	GtkExpander* _tmp34_;
	gchar* _tmp35_;
	gchar* default_extension;
	const gchar* _tmp36_;
	gint _tmp37_ = 0;
	gint index;
	gint _tmp38_;
	GtkListStore* _tmp42_;
	GtkListStore* file_type_store;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp43_;
	GtkTreeIter _tmp44_ = {0};
	GtkListStore* _tmp45_;
	GtkTreeIter _tmp46_;
	const gchar* _tmp47_ = NULL;
	GtkListStore* _tmp48_;
	GtkTreeIter _tmp49_ = {0};
	GtkListStore* _tmp50_;
	GtkTreeIter _tmp51_;
	const gchar* _tmp52_ = NULL;
	GtkListStore* _tmp53_;
	GtkTreeIter _tmp54_ = {0};
	GtkListStore* _tmp55_;
	GtkTreeIter _tmp56_;
	const gchar* _tmp57_ = NULL;
	GtkListStore* _tmp58_;
	GtkTreeView* _tmp59_;
	GtkTreeView* file_type_view;
	GtkTreeView* _tmp60_;
	GtkTreeView* _tmp61_;
	GtkCellRendererText* _tmp62_;
	GtkCellRendererText* _tmp63_;
	GtkTreeViewColumn* _tmp64_;
	GtkTreeViewColumn* _tmp65_;
	GtkTreeViewColumn* column;
	GtkTreeView* _tmp66_;
	GtkTreeViewColumn* _tmp67_;
	GtkExpander* _tmp68_;
	GtkTreeView* _tmp69_;
	GtkListStore* _tmp70_;
	GtkTreeIter _tmp71_ = {0};
	gboolean _tmp72_ = FALSE;
	GtkTreeView* _tmp84_;
	GtkTreeSelection* _tmp85_ = NULL;
	GtkExpander* _tmp86_;
	GtkFileChooserDialog* _tmp87_;
	gint _tmp88_ = 0;
	gint response;
	gchar* uri;
	gint _tmp89_;
	GSettings* _tmp109_;
	GtkFileChooserDialog* _tmp110_;
	gchar* _tmp111_ = NULL;
	gchar* _tmp112_;
	GtkTreeView* _tmp113_;
	GtkTreeSelection* _tmp114_ = NULL;
	guint _tmp115_ = 0U;
	GtkFileChooserDialog* _tmp116_;
#line 365 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 368 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	directory = NULL;
#line 369 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->settings;
#line 369 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = g_settings_get_string (_tmp0_, "save-directory");
#line 369 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (directory);
#line 369 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	directory = _tmp1_;
#line 371 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = directory;
#line 371 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp3_ == NULL) {
#line 371 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp2_ = TRUE;
#line 2167 "ui.c"
	} else {
		const gchar* _tmp4_;
#line 371 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp4_ = directory;
#line 371 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
#line 2174 "ui.c"
	}
#line 371 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp5_ = _tmp2_;
#line 371 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp5_) {
#line 2180 "ui.c"
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
#line 372 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp6_ = g_get_user_special_dir (G_USER_DIRECTORY_DOCUMENTS);
#line 372 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp7_ = g_strdup (_tmp6_);
#line 372 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (directory);
#line 372 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		directory = _tmp7_;
#line 2191 "ui.c"
	}
#line 374 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp8_ = _ ("Save As...");
#line 374 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp9_ = self->priv->window;
#line 374 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp10_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp8_, _tmp9_, GTK_FILE_CHOOSER_ACTION_SAVE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL, NULL);
#line 374 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_object_ref_sink (_tmp10_);
#line 374 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->save_dialog);
#line 374 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->save_dialog = _tmp10_;
#line 381 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp11_ = self->priv->save_dialog;
#line 381 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp11_, TRUE);
#line 382 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp12_ = self->priv->save_dialog;
#line 382 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp12_, FALSE);
#line 383 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp13_ = self->priv->save_dialog;
#line 383 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp14_ = directory;
#line 383 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp13_, _tmp14_);
#line 384 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp15_ = self->priv->save_dialog;
#line 384 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp16_ = self->priv->default_file_name;
#line 384 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp15_, _tmp16_);
#line 387 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp17_ = gtk_file_filter_new ();
#line 387 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_object_ref_sink (_tmp17_);
#line 387 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	filter = _tmp17_;
#line 388 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp18_ = filter;
#line 388 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp19_ = _ ("Image Files");
#line 388 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_file_filter_set_name (_tmp18_, _tmp19_);
#line 390 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp20_ = filter;
#line 390 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_file_filter_add_pixbuf_formats (_tmp20_);
#line 391 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp21_ = filter;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_file_filter_add_mime_type (_tmp21_, "application/pdf");
#line 392 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp22_ = self->priv->save_dialog;
#line 392 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp23_ = filter;
#line 392 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp22_, _tmp23_);
#line 393 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp24_ = gtk_file_filter_new ();
#line 393 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_object_ref_sink (_tmp24_);
#line 393 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (filter);
#line 393 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	filter = _tmp24_;
#line 394 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp25_ = filter;
#line 394 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp26_ = _ ("All Files");
#line 394 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_file_filter_set_name (_tmp25_, _tmp26_);
#line 396 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp27_ = filter;
#line 396 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_file_filter_add_pattern (_tmp27_, "*");
#line 397 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp28_ = self->priv->save_dialog;
#line 397 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp29_ = filter;
#line 397 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp28_, _tmp29_);
#line 399 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp30_ = _ ("Select File _Type");
#line 399 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp31_ = (GtkExpander*) gtk_expander_new_with_mnemonic (_tmp30_);
#line 399 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_object_ref_sink (_tmp31_);
#line 399 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	expander = _tmp31_;
#line 401 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp32_ = expander;
#line 401 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_expander_set_spacing (_tmp32_, 5);
#line 402 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp33_ = self->priv->save_dialog;
#line 402 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp34_ = expander;
#line 402 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_file_chooser_set_extra_widget ((GtkFileChooser*) _tmp33_, (GtkWidget*) _tmp34_);
#line 404 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp35_ = g_strdup ("");
#line 404 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	default_extension = _tmp35_;
#line 405 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp36_ = self->priv->default_file_name;
#line 405 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp37_ = string_last_index_of_char (_tmp36_, (gunichar) '.', 0);
#line 405 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	index = _tmp37_;
#line 406 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp38_ = index;
#line 406 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp38_ >= 0) {
#line 2307 "ui.c"
		const gchar* _tmp39_;
		gint _tmp40_;
		gchar* _tmp41_ = NULL;
#line 407 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp39_ = self->priv->default_file_name;
#line 407 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp40_ = index;
#line 407 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp41_ = string_substring (_tmp39_, (glong) _tmp40_, (glong) (-1));
#line 407 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (default_extension);
#line 407 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		default_extension = _tmp41_;
#line 2321 "ui.c"
	}
#line 409 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp42_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
#line 409 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	file_type_store = _tmp42_;
#line 411 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp43_ = file_type_store;
#line 411 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_list_store_append (_tmp43_, &_tmp44_);
#line 411 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	iter = _tmp44_;
#line 412 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp45_ = file_type_store;
#line 412 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp46_ = iter;
#line 412 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp47_ = _ ("PDF (multi-page document)");
#line 412 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_list_store_set (_tmp45_, &_tmp46_, 0, _tmp47_, 1, ".pdf", -1, -1);
#line 417 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp48_ = file_type_store;
#line 417 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_list_store_append (_tmp48_, &_tmp49_);
#line 417 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	iter = _tmp49_;
#line 418 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp50_ = file_type_store;
#line 418 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp51_ = iter;
#line 418 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp52_ = _ ("JPEG (compressed)");
#line 418 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_list_store_set (_tmp50_, &_tmp51_, 0, _tmp52_, 1, ".jpg", -1, -1);
#line 423 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp53_ = file_type_store;
#line 423 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_list_store_append (_tmp53_, &_tmp54_);
#line 423 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	iter = _tmp54_;
#line 424 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp55_ = file_type_store;
#line 424 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp56_ = iter;
#line 424 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp57_ = _ ("PNG (lossless)");
#line 424 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_list_store_set (_tmp55_, &_tmp56_, 0, _tmp57_, 1, ".png", -1, -1);
#line 430 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp58_ = file_type_store;
#line 430 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp59_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _tmp58_);
#line 430 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_object_ref_sink (_tmp59_);
#line 430 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	file_type_view = _tmp59_;
#line 431 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp60_ = file_type_view;
#line 431 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_tree_view_set_headers_visible (_tmp60_, FALSE);
#line 432 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp61_ = file_type_view;
#line 432 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_tree_view_set_rules_hint (_tmp61_, TRUE);
#line 433 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp62_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 433 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_object_ref_sink (_tmp62_);
#line 433 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp63_ = _tmp62_;
#line 433 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp64_ = gtk_tree_view_column_new_with_attributes ("", (GtkCellRenderer*) _tmp63_, "text", 0, NULL, NULL);
#line 433 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_object_ref_sink (_tmp64_);
#line 433 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp65_ = _tmp64_;
#line 433 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (_tmp63_);
#line 433 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	column = _tmp65_;
#line 436 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp66_ = file_type_view;
#line 436 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp67_ = column;
#line 436 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_tree_view_append_column (_tmp66_, _tmp67_);
#line 437 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp68_ = expander;
#line 437 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp69_ = file_type_view;
#line 437 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_container_add ((GtkContainer*) _tmp68_, (GtkWidget*) _tmp69_);
#line 439 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp70_ = file_type_store;
#line 439 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp72_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp70_, &_tmp71_);
#line 439 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	iter = _tmp71_;
#line 439 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp72_) {
#line 2421 "ui.c"
		{
			gboolean _tmp73_;
#line 441 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp73_ = TRUE;
#line 441 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			while (TRUE) {
#line 2428 "ui.c"
				gboolean _tmp74_;
				gchar* e = NULL;
				GtkListStore* _tmp77_;
				GtkTreeIter _tmp78_;
				const gchar* _tmp79_;
				const gchar* _tmp80_;
#line 441 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp74_ = _tmp73_;
#line 441 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				if (!_tmp74_) {
#line 2439 "ui.c"
					GtkListStore* _tmp75_;
					gboolean _tmp76_ = FALSE;
#line 447 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp75_ = file_type_store;
#line 447 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp76_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp75_, &iter);
#line 447 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					if (!_tmp76_) {
#line 447 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
						break;
#line 2450 "ui.c"
					}
				}
#line 441 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp73_ = FALSE;
#line 444 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp77_ = file_type_store;
#line 444 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp78_ = iter;
#line 444 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				gtk_tree_model_get ((GtkTreeModel*) _tmp77_, &_tmp78_, 1, &e, -1, -1);
#line 445 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp79_ = default_extension;
#line 445 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp80_ = e;
#line 445 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				if (g_strcmp0 (_tmp79_, _tmp80_) == 0) {
#line 2467 "ui.c"
					GtkTreeView* _tmp81_;
					GtkTreeSelection* _tmp82_ = NULL;
					GtkTreeIter _tmp83_;
#line 446 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp81_ = file_type_view;
#line 446 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp82_ = gtk_tree_view_get_selection (_tmp81_);
#line 446 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp83_ = iter;
#line 446 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					gtk_tree_selection_select_iter (_tmp82_, &_tmp83_);
#line 2479 "ui.c"
				}
#line 441 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_g_free0 (e);
#line 2483 "ui.c"
			}
		}
	}
#line 449 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp84_ = file_type_view;
#line 449 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp85_ = gtk_tree_view_get_selection (_tmp84_);
#line 449 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_signal_connect (_tmp85_, "changed", (GCallback) _user_interface_on_file_type_changed_gtk_tree_selection_changed, self);
#line 451 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp86_ = expander;
#line 451 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp86_);
#line 453 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp87_ = self->priv->save_dialog;
#line 453 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp88_ = gtk_dialog_run ((GtkDialog*) _tmp87_);
#line 453 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	response = _tmp88_;
#line 455 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	uri = NULL;
#line 456 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp89_ = response;
#line 456 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp89_ == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 2509 "ui.c"
		GtkTreeView* _tmp90_;
		GtkTreeSelection* _tmp91_ = NULL;
		GtkTreeSelection* _tmp92_;
		GtkTreeSelection* selection;
		GtkTreeSelection* _tmp93_;
		gchar* _tmp94_ = NULL;
		gchar* extension;
		GtkFileChooserDialog* _tmp95_;
		gchar* _tmp96_ = NULL;
		gchar* path;
		const gchar* _tmp97_;
		gchar* _tmp98_ = NULL;
		gchar* filename;
		const gchar* _tmp99_;
		gint _tmp100_ = 0;
		gint extension_index;
		gint _tmp101_;
		const gchar* _tmp105_;
		GFile* _tmp106_ = NULL;
		GFile* _tmp107_;
		gchar* _tmp108_ = NULL;
#line 458 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp90_ = file_type_view;
#line 458 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp91_ = gtk_tree_view_get_selection (_tmp90_);
#line 458 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp92_ = _g_object_ref0 (_tmp91_);
#line 458 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		selection = _tmp92_;
#line 459 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp93_ = selection;
#line 459 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp94_ = user_interface_get_selected_extension (self, _tmp93_);
#line 459 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		extension = _tmp94_;
#line 461 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp95_ = self->priv->save_dialog;
#line 461 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp96_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp95_);
#line 461 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		path = _tmp96_;
#line 462 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp97_ = path;
#line 462 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp98_ = g_path_get_basename (_tmp97_);
#line 462 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		filename = _tmp98_;
#line 464 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp99_ = filename;
#line 464 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp100_ = string_last_index_of_char (_tmp99_, (gunichar) '.', 0);
#line 464 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		extension_index = _tmp100_;
#line 465 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp101_ = extension_index;
#line 465 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		if (_tmp101_ < 0) {
#line 2567 "ui.c"
			const gchar* _tmp102_;
			const gchar* _tmp103_;
			gchar* _tmp104_;
#line 466 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp102_ = path;
#line 466 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp103_ = extension;
#line 466 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp104_ = g_strconcat (_tmp102_, _tmp103_, NULL);
#line 466 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_g_free0 (path);
#line 466 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			path = _tmp104_;
#line 2581 "ui.c"
		}
#line 468 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp105_ = path;
#line 468 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp106_ = g_file_new_for_path (_tmp105_);
#line 468 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp107_ = _tmp106_;
#line 468 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp108_ = g_file_get_uri (_tmp107_);
#line 468 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (uri);
#line 468 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		uri = _tmp108_;
#line 468 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_object_unref0 (_tmp107_);
#line 456 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (filename);
#line 456 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (path);
#line 456 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (extension);
#line 456 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_object_unref0 (selection);
#line 2605 "ui.c"
	}
#line 471 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp109_ = self->priv->settings;
#line 471 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp110_ = self->priv->save_dialog;
#line 471 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp111_ = gtk_file_chooser_get_current_folder ((GtkFileChooser*) _tmp110_);
#line 471 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp112_ = _tmp111_;
#line 471 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_settings_set_string (_tmp109_, "save-directory", _tmp112_);
#line 471 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (_tmp112_);
#line 473 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp113_ = file_type_view;
#line 473 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp114_ = gtk_tree_view_get_selection (_tmp113_);
#line 473 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_signal_parse_name ("changed", GTK_TYPE_TREE_SELECTION, &_tmp115_, NULL, FALSE);
#line 473 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_signal_handlers_disconnect_matched (_tmp114_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp115_, 0, NULL, (GCallback) _user_interface_on_file_type_changed_gtk_tree_selection_changed, self);
#line 474 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp116_ = self->priv->save_dialog;
#line 474 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp116_);
#line 475 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->save_dialog);
#line 475 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->save_dialog = NULL;
#line 477 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	result = uri;
#line 477 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (column);
#line 477 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (file_type_view);
#line 477 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (file_type_store);
#line 477 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (default_extension);
#line 477 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (expander);
#line 477 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (filter);
#line 477 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (directory);
#line 477 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return result;
#line 2653 "ui.c"
}


static gboolean user_interface_save_document (UserInterface* self, gboolean force_choose_location) {
	gboolean result = FALSE;
	gchar* uri = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp3_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GFile* _tmp9_ = NULL;
	GFile* file;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* uri_lower;
	gchar* _tmp13_;
	gchar* format;
	const gchar* _tmp14_;
	gboolean _tmp15_ = FALSE;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	Book* _tmp41_;
	GError * _inner_error_ = NULL;
#line 480 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 483 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = self->priv->book_uri;
#line 483 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp1_ != NULL) {
#line 2685 "ui.c"
		gboolean _tmp2_;
#line 483 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp2_ = force_choose_location;
#line 483 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp0_ = !_tmp2_;
#line 2691 "ui.c"
	} else {
#line 483 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp0_ = FALSE;
#line 2695 "ui.c"
	}
#line 483 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = _tmp0_;
#line 483 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp3_) {
#line 2701 "ui.c"
		const gchar* _tmp4_;
		gchar* _tmp5_;
#line 484 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp4_ = self->priv->book_uri;
#line 484 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 484 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (uri);
#line 484 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		uri = _tmp5_;
#line 2712 "ui.c"
	} else {
		gchar* _tmp6_ = NULL;
#line 486 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp6_ = user_interface_choose_file_location (self);
#line 486 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (uri);
#line 486 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		uri = _tmp6_;
#line 2721 "ui.c"
	}
#line 487 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp7_ = uri;
#line 487 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp7_ == NULL) {
#line 488 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		result = FALSE;
#line 488 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (uri);
#line 488 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		return result;
#line 2733 "ui.c"
	}
#line 490 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp8_ = uri;
#line 490 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp9_ = g_file_new_for_uri (_tmp8_);
#line 490 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	file = _tmp9_;
#line 492 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp10_ = uri;
#line 492 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_debug ("ui.vala:492: Saving to '%s'", _tmp10_);
#line 494 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp11_ = uri;
#line 494 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp12_ = g_utf8_strdown (_tmp11_, (gssize) (-1));
#line 494 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	uri_lower = _tmp12_;
#line 495 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp13_ = g_strdup ("jpeg");
#line 495 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	format = _tmp13_;
#line 496 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp14_ = uri_lower;
#line 496 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp15_ = g_str_has_suffix (_tmp14_, ".pdf");
#line 496 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp15_) {
#line 2761 "ui.c"
		gchar* _tmp16_;
#line 497 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp16_ = g_strdup ("pdf");
#line 497 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (format);
#line 497 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		format = _tmp16_;
#line 2769 "ui.c"
	} else {
		const gchar* _tmp17_;
		gboolean _tmp18_ = FALSE;
#line 498 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp17_ = uri_lower;
#line 498 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp18_ = g_str_has_suffix (_tmp17_, ".ps");
#line 498 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		if (_tmp18_) {
#line 2779 "ui.c"
			gchar* _tmp19_;
#line 499 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp19_ = g_strdup ("ps");
#line 499 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_g_free0 (format);
#line 499 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			format = _tmp19_;
#line 2787 "ui.c"
		} else {
			const gchar* _tmp20_;
			gboolean _tmp21_ = FALSE;
#line 500 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp20_ = uri_lower;
#line 500 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp21_ = g_str_has_suffix (_tmp20_, ".png");
#line 500 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			if (_tmp21_) {
#line 2797 "ui.c"
				gchar* _tmp22_;
#line 501 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp22_ = g_strdup ("png");
#line 501 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_g_free0 (format);
#line 501 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				format = _tmp22_;
#line 2805 "ui.c"
			} else {
				gboolean _tmp23_ = FALSE;
				const gchar* _tmp24_;
				gboolean _tmp25_ = FALSE;
				gboolean _tmp28_;
#line 502 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp24_ = uri_lower;
#line 502 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp25_ = g_str_has_suffix (_tmp24_, ".tif");
#line 502 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				if (_tmp25_) {
#line 502 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp23_ = TRUE;
#line 2819 "ui.c"
				} else {
					const gchar* _tmp26_;
					gboolean _tmp27_ = FALSE;
#line 502 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp26_ = uri_lower;
#line 502 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp27_ = g_str_has_suffix (_tmp26_, ".tiff");
#line 502 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp23_ = _tmp27_;
#line 2829 "ui.c"
				}
#line 502 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp28_ = _tmp23_;
#line 502 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				if (_tmp28_) {
#line 2835 "ui.c"
					gchar* _tmp29_;
#line 503 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp29_ = g_strdup ("tiff");
#line 503 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_g_free0 (format);
#line 503 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					format = _tmp29_;
#line 2843 "ui.c"
				}
			}
		}
	}
#line 505 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_show_progress_dialog (self);
#line 2850 "ui.c"
	{
		Book* _tmp30_;
		const gchar* _tmp31_;
		gint _tmp32_ = 0;
		GFile* _tmp33_;
#line 508 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp30_ = self->priv->book;
#line 508 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp31_ = format;
#line 508 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp32_ = user_interface_get_quality (self);
#line 508 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp33_ = file;
#line 508 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		book_save (_tmp30_, _tmp31_, _tmp32_, _tmp33_, &_inner_error_);
#line 508 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 2868 "ui.c"
			goto __catch16_g_error;
		}
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError* e = NULL;
		GError* _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_ = NULL;
		GError* _tmp37_;
		const gchar* _tmp38_;
#line 506 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		e = _inner_error_;
#line 506 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_inner_error_ = NULL;
#line 512 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		user_interface_hide_progress_dialog (self);
#line 513 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp34_ = e;
#line 513 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp35_ = _tmp34_->message;
#line 513 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		g_warning ("ui.vala:513: Error saving file: %s", _tmp35_);
#line 514 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp36_ = _ ("Failed to save file");
#line 514 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp37_ = e;
#line 514 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp38_ = _tmp37_->message;
#line 514 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		user_interface_show_error (self, _tmp36_, _tmp38_, FALSE);
#line 518 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		result = FALSE;
#line 518 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_error_free0 (e);
#line 518 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (format);
#line 518 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (uri_lower);
#line 518 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_object_unref0 (file);
#line 518 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (uri);
#line 518 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		return result;
#line 2915 "ui.c"
	}
	__finally16:
#line 506 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 506 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (format);
#line 506 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (uri_lower);
#line 506 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_object_unref0 (file);
#line 506 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (uri);
#line 506 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 506 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 506 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		return FALSE;
#line 2934 "ui.c"
	}
#line 521 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp39_ = uri;
#line 521 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp40_ = g_strdup (_tmp39_);
#line 521 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (self->priv->book_uri);
#line 521 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->book_uri = _tmp40_;
#line 522 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp41_ = self->priv->book;
#line 522 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	book_set_needs_saving (_tmp41_, FALSE);
#line 523 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	result = TRUE;
#line 523 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (format);
#line 523 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (uri_lower);
#line 523 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (file);
#line 523 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (uri);
#line 523 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return result;
#line 2960 "ui.c"
}


static gboolean user_interface_prompt_to_save (UserInterface* self, const gchar* title, const gchar* discard_label) {
	gboolean result = FALSE;
	Book* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GtkWindow* _tmp2_;
	const gchar* _tmp3_;
	GtkMessageDialog* _tmp4_;
	GtkMessageDialog* dialog;
	GtkMessageDialog* _tmp5_;
	const gchar* _tmp6_ = NULL;
	GtkMessageDialog* _tmp7_;
	const gchar* _tmp8_;
	GtkMessageDialog* _tmp9_;
	GtkMessageDialog* _tmp10_;
	GtkMessageDialog* _tmp11_;
	gint _tmp12_ = 0;
	gint response;
	GtkMessageDialog* _tmp13_;
	gint _tmp14_;
#line 526 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 526 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (title != NULL, FALSE);
#line 526 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (discard_label != NULL, FALSE);
#line 528 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->book;
#line 528 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = book_get_needs_saving (_tmp0_);
#line 528 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (!_tmp1_) {
#line 529 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		result = TRUE;
#line 529 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		return result;
#line 2999 "ui.c"
	}
#line 531 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = self->priv->window;
#line 531 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = title;
#line 531 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp4_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp2_, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, "%s", _tmp3_);
#line 531 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_object_ref_sink (_tmp4_);
#line 531 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	dialog = _tmp4_;
#line 536 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp5_ = dialog;
#line 536 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp6_ = _ ("If you don't save, changes will be permanently lost.");
#line 536 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_message_dialog_format_secondary_text (_tmp5_, "%s", _tmp6_);
#line 539 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp7_ = dialog;
#line 539 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp8_ = discard_label;
#line 539 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_dialog_add_button ((GtkDialog*) _tmp7_, _tmp8_, (gint) GTK_RESPONSE_NO);
#line 540 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp9_ = dialog;
#line 540 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_dialog_add_button ((GtkDialog*) _tmp9_, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
#line 541 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp10_ = dialog;
#line 541 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_dialog_add_button ((GtkDialog*) _tmp10_, GTK_STOCK_SAVE, (gint) GTK_RESPONSE_YES);
#line 543 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp11_ = dialog;
#line 543 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp12_ = gtk_dialog_run ((GtkDialog*) _tmp11_);
#line 543 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	response = _tmp12_;
#line 544 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp13_ = dialog;
#line 544 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp13_);
#line 546 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp14_ = response;
#line 546 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	switch (_tmp14_) {
#line 546 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		case GTK_RESPONSE_YES:
#line 3047 "ui.c"
		{
			gboolean _tmp15_ = FALSE;
#line 549 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp15_ = user_interface_save_document (self, FALSE);
#line 549 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			if (_tmp15_) {
#line 550 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				result = TRUE;
#line 550 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_g_object_unref0 (dialog);
#line 550 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				return result;
#line 3060 "ui.c"
			} else {
#line 552 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				result = FALSE;
#line 552 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_g_object_unref0 (dialog);
#line 552 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				return result;
#line 3068 "ui.c"
			}
		}
#line 546 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		case GTK_RESPONSE_CANCEL:
#line 3073 "ui.c"
		{
#line 554 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			result = FALSE;
#line 554 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_g_object_unref0 (dialog);
#line 554 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			return result;
#line 3081 "ui.c"
		}
		default:
#line 546 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		case GTK_RESPONSE_NO:
#line 3086 "ui.c"
		{
#line 557 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			result = TRUE;
#line 557 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_g_object_unref0 (dialog);
#line 557 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			return result;
#line 3094 "ui.c"
		}
	}
#line 526 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (dialog);
#line 3099 "ui.c"
}


static void user_interface_clear_document (UserInterface* self) {
	Book* _tmp0_;
	Book* _tmp1_;
	GtkMenuItem* _tmp2_;
	GtkMenuItem* _tmp3_;
#line 561 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 563 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->book;
#line 563 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	book_clear (_tmp0_);
#line 564 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_add_default_page (self);
#line 565 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (self->priv->book_uri);
#line 565 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->book_uri = NULL;
#line 566 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = self->priv->book;
#line 566 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	book_set_needs_saving (_tmp1_, FALSE);
#line 567 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = self->priv->save_as_menuitem;
#line 567 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
#line 568 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = self->priv->copy_to_clipboard_menuitem;
#line 568 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
#line 3132 "ui.c"
}


void G_MODULE_EXPORT new_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
#line 572 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 572 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 574 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = _ ("Save current document?");
#line 574 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = _ ("Discard Changes");
#line 574 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = user_interface_prompt_to_save (self, _tmp0_, _tmp1_);
#line 574 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (!_tmp2_) {
#line 578 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		return;
#line 3155 "ui.c"
	}
#line 580 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = self->priv->scanning;
#line 580 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp3_) {
#line 581 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		g_signal_emit_by_name (self, "stop-scan");
#line 3163 "ui.c"
	}
#line 582 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_clear_document (self);
#line 3167 "ui.c"
}


static void user_interface_set_document_hint (UserInterface* self, const gchar* document_hint) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
#line 585 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 585 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (document_hint != NULL);
#line 587 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = document_hint;
#line 587 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 587 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (self->priv->document_hint);
#line 587 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->document_hint = _tmp1_;
#line 589 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = document_hint;
#line 589 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (g_strcmp0 (_tmp2_, "text") == 0) {
#line 3191 "ui.c"
		GtkRadioMenuItem* _tmp3_;
		GtkRadioMenuItem* _tmp4_;
#line 591 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp3_ = self->priv->text_toolbar_menuitem;
#line 591 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp3_, TRUE);
#line 592 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp4_ = self->priv->text_menu_menuitem;
#line 592 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp4_, TRUE);
#line 3202 "ui.c"
	} else {
		const gchar* _tmp5_;
#line 594 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp5_ = document_hint;
#line 594 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		if (g_strcmp0 (_tmp5_, "photo") == 0) {
#line 3209 "ui.c"
			GtkRadioMenuItem* _tmp6_;
			GtkRadioMenuItem* _tmp7_;
#line 596 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp6_ = self->priv->photo_toolbar_menuitem;
#line 596 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp6_, TRUE);
#line 597 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp7_ = self->priv->photo_menu_menuitem;
#line 597 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp7_, TRUE);
#line 3220 "ui.c"
		}
	}
}


void G_MODULE_EXPORT text_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
#line 602 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 602 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 604 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = widget;
#line 604 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 604 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp1_) {
#line 605 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		user_interface_set_document_hint (self, "text");
#line 3241 "ui.c"
	}
}


void G_MODULE_EXPORT photo_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
#line 609 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 609 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 611 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = widget;
#line 611 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 611 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp1_) {
#line 612 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		user_interface_set_document_hint (self, "photo");
#line 3261 "ui.c"
	}
}


static void user_interface_set_page_side (UserInterface* self, ScanType page_side) {
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 615 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 619 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->page_side_model;
#line 619 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
#line 619 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	iter = _tmp1_;
#line 619 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp2_) {
#line 3281 "ui.c"
		{
			gboolean _tmp3_;
#line 621 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp3_ = TRUE;
#line 621 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			while (TRUE) {
#line 3288 "ui.c"
				gboolean _tmp4_;
				gint s = 0;
				GtkListStore* _tmp7_;
				GtkTreeIter _tmp8_;
				gint _tmp9_;
				ScanType _tmp10_;
#line 621 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp4_ = _tmp3_;
#line 621 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				if (!_tmp4_) {
#line 3299 "ui.c"
					GtkListStore* _tmp5_;
					gboolean _tmp6_ = FALSE;
#line 630 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp5_ = self->priv->page_side_model;
#line 630 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp6_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp5_, &iter);
#line 630 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					if (!_tmp6_) {
#line 630 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
						break;
#line 3310 "ui.c"
					}
				}
#line 621 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp3_ = FALSE;
#line 624 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp7_ = self->priv->page_side_model;
#line 624 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp8_ = iter;
#line 624 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				gtk_tree_model_get ((GtkTreeModel*) _tmp7_, &_tmp8_, 0, &s, -1, -1);
#line 625 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp9_ = s;
#line 625 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp10_ = page_side;
#line 625 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				if (_tmp9_ == ((gint) _tmp10_)) {
#line 3327 "ui.c"
					GtkComboBox* _tmp11_;
					GtkTreeIter _tmp12_;
#line 627 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp11_ = self->priv->page_side_combo;
#line 627 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp12_ = iter;
#line 627 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					gtk_combo_box_set_active_iter (_tmp11_, &_tmp12_);
#line 628 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					return;
#line 3338 "ui.c"
				}
			}
		}
	}
}


static void user_interface_set_paper_size (UserInterface* self, gint width, gint height) {
	GtkTreeIter iter = {0};
	gboolean have_iter = FALSE;
	gboolean _tmp16_;
	gboolean _tmp20_;
#line 634 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 3353 "ui.c"
	{
		GtkListStore* _tmp0_;
		GtkTreeIter _tmp1_ = {0};
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
#line 639 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp0_ = self->priv->paper_size_model;
#line 639 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
#line 639 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		iter = _tmp1_;
#line 639 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		have_iter = _tmp2_;
#line 639 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp3_ = TRUE;
#line 639 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		while (TRUE) {
#line 3371 "ui.c"
			gboolean _tmp4_;
			gboolean _tmp7_;
			gint w = 0;
			gint h = 0;
			GtkListStore* _tmp8_;
			GtkTreeIter _tmp9_;
			gboolean _tmp10_ = FALSE;
			gint _tmp11_;
			gint _tmp12_;
			gboolean _tmp15_;
#line 639 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp4_ = _tmp3_;
#line 639 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			if (!_tmp4_) {
#line 3386 "ui.c"
				GtkListStore* _tmp5_;
				gboolean _tmp6_ = FALSE;
#line 641 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp5_ = self->priv->paper_size_model;
#line 641 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp6_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp5_, &iter);
#line 641 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				have_iter = _tmp6_;
#line 3395 "ui.c"
			}
#line 639 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp3_ = FALSE;
#line 640 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp7_ = have_iter;
#line 640 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			if (!_tmp7_) {
#line 640 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				break;
#line 3405 "ui.c"
			}
#line 644 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp8_ = self->priv->paper_size_model;
#line 644 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp9_ = iter;
#line 644 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			gtk_tree_model_get ((GtkTreeModel*) _tmp8_, &_tmp9_, 0, &w, 1, &h, -1, -1);
#line 645 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp11_ = w;
#line 645 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp12_ = width;
#line 645 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			if (_tmp11_ == _tmp12_) {
#line 3419 "ui.c"
				gint _tmp13_;
				gint _tmp14_;
#line 645 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp13_ = h;
#line 645 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp14_ = height;
#line 645 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp10_ = _tmp13_ == _tmp14_;
#line 3428 "ui.c"
			} else {
#line 645 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp10_ = FALSE;
#line 3432 "ui.c"
			}
#line 645 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp15_ = _tmp10_;
#line 645 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			if (_tmp15_) {
#line 646 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				break;
#line 3440 "ui.c"
			}
		}
	}
#line 649 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp16_ = have_iter;
#line 649 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (!_tmp16_) {
#line 3448 "ui.c"
		GtkListStore* _tmp17_;
		GtkTreeIter _tmp18_ = {0};
		gboolean _tmp19_ = FALSE;
#line 650 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp17_ = self->priv->paper_size_model;
#line 650 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp19_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp17_, &_tmp18_);
#line 650 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		iter = _tmp18_;
#line 650 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		have_iter = _tmp19_;
#line 3460 "ui.c"
	}
#line 651 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp20_ = have_iter;
#line 651 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp20_) {
#line 3466 "ui.c"
		GtkComboBox* _tmp21_;
		GtkTreeIter _tmp22_;
#line 652 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp21_ = self->priv->paper_size_combo;
#line 652 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp22_ = iter;
#line 652 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		gtk_combo_box_set_active_iter (_tmp21_, &_tmp22_);
#line 3475 "ui.c"
	}
}


static void user_interface_set_brightness (UserInterface* self, gint brightness) {
	GtkAdjustment* _tmp0_;
	gint _tmp1_;
#line 655 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 657 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->brightness_adjustment;
#line 657 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = brightness;
#line 657 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_adjustment_set_value (_tmp0_, (gdouble) _tmp1_);
#line 3491 "ui.c"
}


static void user_interface_set_contrast (UserInterface* self, gint contrast) {
	GtkAdjustment* _tmp0_;
	gint _tmp1_;
#line 660 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 662 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->contrast_adjustment;
#line 662 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = contrast;
#line 662 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_adjustment_set_value (_tmp0_, (gdouble) _tmp1_);
#line 3506 "ui.c"
}


static void user_interface_set_quality (UserInterface* self, gint quality) {
	GtkAdjustment* _tmp0_;
	gint _tmp1_;
#line 665 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 667 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->quality_adjustment;
#line 667 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = quality;
#line 667 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_adjustment_set_value (_tmp0_, (gdouble) _tmp1_);
#line 3521 "ui.c"
}


static gint user_interface_get_text_dpi (UserInterface* self) {
	gint result = 0;
	GtkTreeIter iter = {0};
	gint dpi;
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 670 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 673 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	dpi = USER_INTERFACE_DEFAULT_TEXT_DPI;
#line 675 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->text_dpi_combo;
#line 675 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 675 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	iter = _tmp1_;
#line 675 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp2_) {
#line 3544 "ui.c"
		GtkListStore* _tmp3_;
		GtkTreeIter _tmp4_;
#line 676 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp3_ = self->priv->text_dpi_model;
#line 676 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp4_ = iter;
#line 676 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &dpi, -1, -1);
#line 3553 "ui.c"
	}
#line 678 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	result = dpi;
#line 678 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return result;
#line 3559 "ui.c"
}


static gint user_interface_get_photo_dpi (UserInterface* self) {
	gint result = 0;
	GtkTreeIter iter = {0};
	gint dpi;
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 681 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 684 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	dpi = USER_INTERFACE_DEFAULT_PHOTO_DPI;
#line 686 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->photo_dpi_combo;
#line 686 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 686 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	iter = _tmp1_;
#line 686 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp2_) {
#line 3582 "ui.c"
		GtkListStore* _tmp3_;
		GtkTreeIter _tmp4_;
#line 687 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp3_ = self->priv->photo_dpi_model;
#line 687 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp4_ = iter;
#line 687 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &dpi, -1, -1);
#line 3591 "ui.c"
	}
#line 689 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	result = dpi;
#line 689 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return result;
#line 3597 "ui.c"
}


static ScanType user_interface_get_page_side (UserInterface* self) {
	ScanType result = 0;
	GtkTreeIter iter = {0};
	gint page_side;
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gint _tmp5_;
#line 692 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 695 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	page_side = (gint) SCAN_TYPE_ADF_BOTH;
#line 697 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->page_side_combo;
#line 697 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 697 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	iter = _tmp1_;
#line 697 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp2_) {
#line 3621 "ui.c"
		GtkListStore* _tmp3_;
		GtkTreeIter _tmp4_;
#line 698 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp3_ = self->priv->page_side_model;
#line 698 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp4_ = iter;
#line 698 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &page_side, -1, -1);
#line 3630 "ui.c"
	}
#line 700 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp5_ = page_side;
#line 700 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	result = (ScanType) _tmp5_;
#line 700 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return result;
#line 3638 "ui.c"
}


static gboolean user_interface_get_paper_size (UserInterface* self, gint* width, gint* height) {
	gint _vala_width = 0;
	gint _vala_height = 0;
	gboolean result = FALSE;
	GtkTreeIter iter = {0};
	gint _tmp0_;
	GtkComboBox* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
#line 703 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 707 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_vala_height = 0;
#line 707 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = _vala_height;
#line 707 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_vala_width = _tmp0_;
#line 708 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = self->priv->paper_size_combo;
#line 708 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = gtk_combo_box_get_active_iter (_tmp1_, &_tmp2_);
#line 708 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	iter = _tmp2_;
#line 708 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp3_) {
#line 3667 "ui.c"
		GtkListStore* _tmp4_;
		GtkTreeIter _tmp5_;
#line 710 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp4_ = self->priv->paper_size_model;
#line 710 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp5_ = iter;
#line 710 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp4_, &_tmp5_, 0, &_vala_width, 1, &_vala_height, -1, -1);
#line 711 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		result = TRUE;
#line 711 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		if (width) {
#line 711 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			*width = _vala_width;
#line 3682 "ui.c"
		}
#line 711 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		if (height) {
#line 711 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			*height = _vala_height;
#line 3688 "ui.c"
		}
#line 711 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		return result;
#line 3692 "ui.c"
	}
#line 714 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	result = FALSE;
#line 714 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (width) {
#line 714 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		*width = _vala_width;
#line 3700 "ui.c"
	}
#line 714 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (height) {
#line 714 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		*height = _vala_height;
#line 3706 "ui.c"
	}
#line 714 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return result;
#line 3710 "ui.c"
}


static gint user_interface_get_brightness (UserInterface* self) {
	gint result = 0;
	GtkAdjustment* _tmp0_;
	gdouble _tmp1_ = 0.0;
#line 717 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 719 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->brightness_adjustment;
#line 719 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = gtk_adjustment_get_value (_tmp0_);
#line 719 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	result = (gint) _tmp1_;
#line 719 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return result;
#line 3728 "ui.c"
}


static gint user_interface_get_contrast (UserInterface* self) {
	gint result = 0;
	GtkAdjustment* _tmp0_;
	gdouble _tmp1_ = 0.0;
#line 722 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 724 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->contrast_adjustment;
#line 724 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = gtk_adjustment_get_value (_tmp0_);
#line 724 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	result = (gint) _tmp1_;
#line 724 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return result;
#line 3746 "ui.c"
}


static gint user_interface_get_quality (UserInterface* self) {
	gint result = 0;
	GtkAdjustment* _tmp0_;
	gdouble _tmp1_ = 0.0;
#line 727 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 729 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->quality_adjustment;
#line 729 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = gtk_adjustment_get_value (_tmp0_);
#line 729 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	result = (gint) _tmp1_;
#line 729 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return result;
#line 3764 "ui.c"
}


static ScanOptions* user_interface_get_scan_options (UserInterface* self) {
	ScanOptions* result = NULL;
	ScanOptions* _tmp0_;
	ScanOptions* options;
	const gchar* _tmp1_;
	ScanOptions* _tmp10_;
	ScanOptions* _tmp11_;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	ScanOptions* _tmp14_;
	gint _tmp15_ = 0;
	ScanOptions* _tmp16_;
	gint _tmp17_ = 0;
#line 732 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 734 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = scan_options_new ();
#line 734 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	options = _tmp0_;
#line 735 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = self->priv->document_hint;
#line 735 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (g_strcmp0 (_tmp1_, "text") == 0) {
#line 3791 "ui.c"
		ScanOptions* _tmp2_;
		ScanOptions* _tmp3_;
		gint _tmp4_ = 0;
		ScanOptions* _tmp5_;
#line 737 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp2_ = options;
#line 737 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp2_->scan_mode = SCAN_MODE_GRAY;
#line 738 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp3_ = options;
#line 738 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp4_ = user_interface_get_text_dpi (self);
#line 738 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp3_->dpi = _tmp4_;
#line 739 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp5_ = options;
#line 739 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp5_->depth = 2;
#line 3810 "ui.c"
	} else {
		ScanOptions* _tmp6_;
		ScanOptions* _tmp7_;
		gint _tmp8_ = 0;
		ScanOptions* _tmp9_;
#line 743 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp6_ = options;
#line 743 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp6_->scan_mode = SCAN_MODE_COLOR;
#line 744 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp7_ = options;
#line 744 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp8_ = user_interface_get_photo_dpi (self);
#line 744 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp7_->dpi = _tmp8_;
#line 745 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp9_ = options;
#line 745 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp9_->depth = 8;
#line 3830 "ui.c"
	}
#line 747 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp10_ = options;
#line 747 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp11_ = options;
#line 747 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_get_paper_size (self, &_tmp12_, &_tmp13_);
#line 747 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp10_->paper_width = _tmp12_;
#line 747 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp11_->paper_height = _tmp13_;
#line 748 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp14_ = options;
#line 748 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp15_ = user_interface_get_brightness (self);
#line 748 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp14_->brightness = _tmp15_;
#line 749 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp16_ = options;
#line 749 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp17_ = user_interface_get_contrast (self);
#line 749 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp16_->contrast = _tmp17_;
#line 751 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	result = options;
#line 751 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return result;
#line 3858 "ui.c"
}


void G_MODULE_EXPORT scan_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	ScanOptions* _tmp0_ = NULL;
	ScanOptions* options;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
#line 755 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 755 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 757 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = user_interface_get_scan_options (self);
#line 757 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	options = _tmp0_;
#line 758 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	options->type = SCAN_TYPE_SINGLE;
#line 759 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = user_interface_get_selected_device (self);
#line 759 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 759 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_signal_emit_by_name (self, "start-scan", _tmp2_, options);
#line 759 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (_tmp2_);
#line 755 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_scan_options_unref0 (options);
#line 3887 "ui.c"
}


void G_MODULE_EXPORT stop_scan_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
#line 763 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 763 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 765 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_signal_emit_by_name (self, "stop-scan");
#line 3898 "ui.c"
}


void G_MODULE_EXPORT continuous_scan_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	gboolean _tmp0_;
#line 769 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 769 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 771 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->scanning;
#line 771 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp0_) {
#line 772 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		g_signal_emit_by_name (self, "stop-scan");
#line 3914 "ui.c"
	} else {
		ScanOptions* _tmp1_ = NULL;
		ScanOptions* options;
		ScanOptions* _tmp2_;
		ScanType _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		ScanOptions* _tmp6_;
#line 775 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp1_ = user_interface_get_scan_options (self);
#line 775 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		options = _tmp1_;
#line 776 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp2_ = options;
#line 776 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp3_ = user_interface_get_page_side (self);
#line 776 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp2_->type = _tmp3_;
#line 777 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp4_ = user_interface_get_selected_device (self);
#line 777 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp5_ = _tmp4_;
#line 777 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp6_ = options;
#line 777 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		g_signal_emit_by_name (self, "start-scan", _tmp5_, _tmp6_);
#line 777 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (_tmp5_);
#line 771 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_scan_options_unref0 (options);
#line 3945 "ui.c"
	}
}


void G_MODULE_EXPORT preferences_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	GtkDialog* _tmp0_;
#line 782 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 782 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 784 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->preferences_dialog;
#line 784 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_window_present ((GtkWindow*) _tmp0_);
#line 3960 "ui.c"
}


gboolean G_MODULE_EXPORT preferences_dialog_delete_event_cb (GtkWidget* widget, UserInterface* self) {
	gboolean result = FALSE;
#line 788 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 788 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 790 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	result = TRUE;
#line 790 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return result;
#line 3974 "ui.c"
}


void G_MODULE_EXPORT preferences_dialog_response_cb (GtkWidget* widget, gint response_id, UserInterface* self) {
	GtkDialog* _tmp0_;
#line 794 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 794 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 796 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->preferences_dialog;
#line 796 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 3988 "ui.c"
}


static void user_interface_update_page_menu (UserInterface* self) {
	BookView* _tmp0_;
	Page* _tmp1_ = NULL;
	Page* page;
	Page* _tmp2_;
#line 799 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 801 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 801 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = book_view_get_selected (_tmp0_);
#line 801 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	page = _tmp1_;
#line 802 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = page;
#line 802 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp2_ == NULL) {
#line 4009 "ui.c"
		GtkMenuItem* _tmp3_;
		GtkMenuItem* _tmp4_;
#line 804 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp3_ = self->priv->page_move_left_menuitem;
#line 804 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
#line 805 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp4_ = self->priv->page_move_right_menuitem;
#line 805 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, FALSE);
#line 4020 "ui.c"
	} else {
		Book* _tmp5_;
		Page* _tmp6_;
		guint _tmp7_ = 0U;
		guint index;
		GtkMenuItem* _tmp8_;
		guint _tmp9_;
		GtkMenuItem* _tmp10_;
		guint _tmp11_;
		Book* _tmp12_;
		guint _tmp13_ = 0U;
#line 809 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp5_ = self->priv->book;
#line 809 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp6_ = page;
#line 809 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp7_ = book_get_page_index (_tmp5_, _tmp6_);
#line 809 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		index = _tmp7_;
#line 810 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp8_ = self->priv->page_move_left_menuitem;
#line 810 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp9_ = index;
#line 810 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, _tmp9_ > ((guint) 0));
#line 811 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp10_ = self->priv->page_move_right_menuitem;
#line 811 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp11_ = index;
#line 811 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp12_ = self->priv->book;
#line 811 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp13_ = book_get_n_pages (_tmp12_);
#line 811 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, _tmp11_ < (_tmp13_ - 1));
#line 4056 "ui.c"
	}
#line 799 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_page_unref0 (page);
#line 4060 "ui.c"
}


static void user_interface_page_selected_cb (UserInterface* self, BookView* view, Page* page) {
	Page* _tmp0_;
	gchar* name;
	Page* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkBuilder* _tmp20_;
	const gchar* _tmp21_;
	GObject* _tmp22_ = NULL;
	GtkRadioMenuItem* _tmp23_;
	GtkRadioMenuItem* menuitem;
	GtkRadioMenuItem* _tmp24_;
	GtkBuilder* _tmp25_;
	GObject* _tmp26_ = NULL;
	GtkToggleToolButton* _tmp27_;
	GtkToggleToolButton* toolbutton;
	GtkToggleToolButton* _tmp28_;
	Page* _tmp29_;
	gboolean _tmp30_ = FALSE;
#line 815 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 815 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (view != NULL);
#line 817 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = page;
#line 817 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp0_ == NULL) {
#line 818 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		return;
#line 4092 "ui.c"
	}
#line 820 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->updating_page_menu = TRUE;
#line 822 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_update_page_menu (self);
#line 824 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	name = NULL;
#line 825 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = page;
#line 825 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = page_has_crop (_tmp1_);
#line 825 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp2_) {
#line 4106 "ui.c"
		Page* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* crop_name;
		const gchar* _tmp5_;
#line 828 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp3_ = page;
#line 828 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp4_ = page_get_named_crop (_tmp3_);
#line 828 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		crop_name = _tmp4_;
#line 829 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp5_ = crop_name;
#line 829 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		if (_tmp5_ != NULL) {
#line 4121 "ui.c"
			const gchar* _tmp6_;
#line 831 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp6_ = crop_name;
#line 831 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			if (g_strcmp0 (_tmp6_, "A4") == 0) {
#line 4127 "ui.c"
				gchar* _tmp7_;
#line 832 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp7_ = g_strdup ("a4_menuitem");
#line 832 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_g_free0 (name);
#line 832 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				name = _tmp7_;
#line 4135 "ui.c"
			} else {
				const gchar* _tmp8_;
#line 833 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp8_ = crop_name;
#line 833 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				if (g_strcmp0 (_tmp8_, "A5") == 0) {
#line 4142 "ui.c"
					gchar* _tmp9_;
#line 834 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp9_ = g_strdup ("a5_menuitem");
#line 834 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_g_free0 (name);
#line 834 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					name = _tmp9_;
#line 4150 "ui.c"
				} else {
					const gchar* _tmp10_;
#line 835 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp10_ = crop_name;
#line 835 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					if (g_strcmp0 (_tmp10_, "A6") == 0) {
#line 4157 "ui.c"
						gchar* _tmp11_;
#line 836 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
						_tmp11_ = g_strdup ("a6_menuitem");
#line 836 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
						_g_free0 (name);
#line 836 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
						name = _tmp11_;
#line 4165 "ui.c"
					} else {
						const gchar* _tmp12_;
#line 837 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
						_tmp12_ = crop_name;
#line 837 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
						if (g_strcmp0 (_tmp12_, "letter") == 0) {
#line 4172 "ui.c"
							gchar* _tmp13_;
#line 838 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							_tmp13_ = g_strdup ("letter_menuitem");
#line 838 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							_g_free0 (name);
#line 838 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							name = _tmp13_;
#line 4180 "ui.c"
						} else {
							const gchar* _tmp14_;
#line 839 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							_tmp14_ = crop_name;
#line 839 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							if (g_strcmp0 (_tmp14_, "legal") == 0) {
#line 4187 "ui.c"
								gchar* _tmp15_;
#line 840 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
								_tmp15_ = g_strdup ("legal_menuitem");
#line 840 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
								_g_free0 (name);
#line 840 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
								name = _tmp15_;
#line 4195 "ui.c"
							} else {
								const gchar* _tmp16_;
#line 841 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
								_tmp16_ = crop_name;
#line 841 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
								if (g_strcmp0 (_tmp16_, "4x6") == 0) {
#line 4202 "ui.c"
									gchar* _tmp17_;
#line 842 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
									_tmp17_ = g_strdup ("4x6_menuitem");
#line 842 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
									_g_free0 (name);
#line 842 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
									name = _tmp17_;
#line 4210 "ui.c"
								}
							}
						}
					}
				}
			}
		} else {
			gchar* _tmp18_;
#line 845 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp18_ = g_strdup ("custom_crop_menuitem");
#line 845 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_g_free0 (name);
#line 845 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			name = _tmp18_;
#line 4225 "ui.c"
		}
#line 825 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (crop_name);
#line 4229 "ui.c"
	} else {
		gchar* _tmp19_;
#line 848 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp19_ = g_strdup ("no_crop_menuitem");
#line 848 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (name);
#line 848 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		name = _tmp19_;
#line 4238 "ui.c"
	}
#line 850 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp20_ = self->priv->builder;
#line 850 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp21_ = name;
#line 850 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp22_ = gtk_builder_get_object (_tmp20_, _tmp21_);
#line 850 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
#line 850 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	menuitem = _tmp23_;
#line 851 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp24_ = menuitem;
#line 851 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp24_, TRUE);
#line 852 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp25_ = self->priv->builder;
#line 852 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp26_ = gtk_builder_get_object (_tmp25_, "crop_toolbutton");
#line 852 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp27_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GTK_TYPE_TOGGLE_TOOL_BUTTON, GtkToggleToolButton));
#line 852 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	toolbutton = _tmp27_;
#line 853 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp28_ = toolbutton;
#line 853 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp29_ = page;
#line 853 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp30_ = page_has_crop (_tmp29_);
#line 853 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_toggle_tool_button_set_active (_tmp28_, _tmp30_);
#line 855 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->updating_page_menu = FALSE;
#line 815 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (toolbutton);
#line 815 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (menuitem);
#line 815 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (name);
#line 4278 "ui.c"
}


static void user_interface_show_page_cb (UserInterface* self, BookView* view, Page* page) {
	gchar* _tmp0_ = NULL;
	gchar* path;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GFile* _tmp3_ = NULL;
	GFile* file;
	GError * _inner_error_ = NULL;
#line 858 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 858 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (view != NULL);
#line 858 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 860 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = get_temporary_filename ("scanned-page", "tiff");
#line 860 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	path = _tmp0_;
#line 861 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = path;
#line 861 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp1_ == NULL) {
#line 862 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (path);
#line 862 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		return;
#line 4308 "ui.c"
	}
#line 863 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = path;
#line 863 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = g_file_new_for_path (_tmp2_);
#line 863 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	file = _tmp3_;
#line 4316 "ui.c"
	{
		Page* _tmp4_;
		gint _tmp5_ = 0;
		GFile* _tmp6_;
#line 867 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp4_ = page;
#line 867 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp5_ = user_interface_get_quality (self);
#line 867 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp6_ = file;
#line 867 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		page_save (_tmp4_, "tiff", _tmp5_, _tmp6_, &_inner_error_);
#line 867 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 4331 "ui.c"
			goto __catch17_g_error;
		}
	}
	goto __finally17;
	__catch17_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp7_ = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
#line 865 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		e = _inner_error_;
#line 865 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_inner_error_ = NULL;
#line 871 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp7_ = _ ("Unable to save image for preview");
#line 871 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp8_ = e;
#line 871 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp9_ = _tmp8_->message;
#line 871 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		user_interface_show_error_dialog (self, _tmp7_, _tmp9_);
#line 874 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_error_free0 (e);
#line 874 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_object_unref0 (file);
#line 874 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (path);
#line 874 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		return;
#line 4362 "ui.c"
	}
	__finally17:
#line 865 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 865 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_object_unref0 (file);
#line 865 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (path);
#line 865 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 865 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 865 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		return;
#line 4377 "ui.c"
	}
	{
		GtkWindow* _tmp10_;
		GdkScreen* _tmp11_ = NULL;
		GFile* _tmp12_;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		guint32 _tmp15_ = 0U;
#line 879 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp10_ = self->priv->window;
#line 879 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp11_ = gtk_window_get_screen (_tmp10_);
#line 879 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp12_ = file;
#line 879 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp13_ = g_file_get_uri (_tmp12_);
#line 879 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp14_ = _tmp13_;
#line 879 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp15_ = gtk_get_current_event_time ();
#line 879 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		gtk_show_uri (_tmp11_, _tmp14_, _tmp15_, &_inner_error_);
#line 879 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (_tmp14_);
#line 879 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 4404 "ui.c"
			goto __catch18_g_error;
		}
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp16_ = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
#line 877 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		e = _inner_error_;
#line 877 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_inner_error_ = NULL;
#line 883 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp16_ = _ ("Unable to open image preview application");
#line 883 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp17_ = e;
#line 883 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp18_ = _tmp17_->message;
#line 883 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		user_interface_show_error_dialog (self, _tmp16_, _tmp18_);
#line 877 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_error_free0 (e);
#line 4429 "ui.c"
	}
	__finally18:
#line 877 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 877 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_object_unref0 (file);
#line 877 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (path);
#line 877 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 877 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 877 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		return;
#line 4444 "ui.c"
	}
#line 858 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (file);
#line 858 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (path);
#line 4450 "ui.c"
}


static void user_interface_show_page_menu_cb (UserInterface* self, BookView* view) {
	GtkBuilder* _tmp0_;
	GObject* _tmp1_ = NULL;
	GtkMenu* _tmp2_;
	GtkMenu* menu;
	guint32 _tmp3_ = 0U;
#line 889 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 889 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (view != NULL);
#line 891 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->builder;
#line 891 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = gtk_builder_get_object (_tmp0_, "page_menu");
#line 891 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GTK_TYPE_MENU, GtkMenu));
#line 891 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	menu = _tmp2_;
#line 892 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = gtk_get_current_event_time ();
#line 892 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_menu_popup (menu, NULL, NULL, NULL, NULL, (guint) 3, _tmp3_);
#line 889 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (menu);
#line 4478 "ui.c"
}


void G_MODULE_EXPORT rotate_left_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	gboolean _tmp0_;
	BookView* _tmp1_;
	Page* _tmp2_ = NULL;
	Page* page;
	Page* _tmp3_;
#line 896 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 896 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 898 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->updating_page_menu;
#line 898 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp0_) {
#line 899 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		return;
#line 4498 "ui.c"
	}
#line 900 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = self->priv->book_view;
#line 900 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = book_view_get_selected (_tmp1_);
#line 900 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	page = _tmp2_;
#line 901 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = page;
#line 901 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp3_ != NULL) {
#line 4510 "ui.c"
		Page* _tmp4_;
#line 902 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp4_ = page;
#line 902 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		page_rotate_left (_tmp4_);
#line 4516 "ui.c"
	}
#line 896 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_page_unref0 (page);
#line 4520 "ui.c"
}


void G_MODULE_EXPORT rotate_right_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	gboolean _tmp0_;
	BookView* _tmp1_;
	Page* _tmp2_ = NULL;
	Page* page;
	Page* _tmp3_;
#line 906 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 906 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 908 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->updating_page_menu;
#line 908 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp0_) {
#line 909 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		return;
#line 4540 "ui.c"
	}
#line 910 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = self->priv->book_view;
#line 910 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = book_view_get_selected (_tmp1_);
#line 910 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	page = _tmp2_;
#line 911 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = page;
#line 911 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp3_ != NULL) {
#line 4552 "ui.c"
		Page* _tmp4_;
#line 912 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp4_ = page;
#line 912 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		page_rotate_right (_tmp4_);
#line 4558 "ui.c"
	}
#line 906 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_page_unref0 (page);
#line 4562 "ui.c"
}


static void user_interface_set_crop (UserInterface* self, const gchar* crop_name) {
	GtkMenuItem* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	BookView* _tmp3_;
	Page* _tmp4_ = NULL;
	Page* page;
	Page* _tmp5_;
	const gchar* _tmp6_;
#line 915 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 917 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->crop_rotate_menuitem;
#line 917 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = crop_name;
#line 917 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp1_ != NULL);
#line 919 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = self->priv->updating_page_menu;
#line 919 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp2_) {
#line 920 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		return;
#line 4589 "ui.c"
	}
#line 922 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = self->priv->book_view;
#line 922 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp4_ = book_view_get_selected (_tmp3_);
#line 922 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	page = _tmp4_;
#line 923 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp5_ = page;
#line 923 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp5_ == NULL) {
#line 924 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_page_unref0 (page);
#line 924 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		return;
#line 4605 "ui.c"
	}
#line 926 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp6_ = crop_name;
#line 926 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp6_ == NULL) {
#line 4611 "ui.c"
		Page* _tmp7_;
#line 928 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp7_ = page;
#line 928 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		page_set_no_crop (_tmp7_);
#line 929 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_page_unref0 (page);
#line 929 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		return;
#line 4621 "ui.c"
	} else {
		const gchar* _tmp8_;
#line 931 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp8_ = crop_name;
#line 931 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		if (g_strcmp0 (_tmp8_, "custom") == 0) {
#line 4628 "ui.c"
			Page* _tmp9_;
			gint _tmp10_ = 0;
			gint width;
			Page* _tmp11_;
			gint _tmp12_ = 0;
			gint height;
			gint _tmp13_;
			gint crop_width;
			gint _tmp14_;
			gint crop_height;
			Page* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			Page* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
#line 933 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp9_ = page;
#line 933 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp10_ = page_get_width (_tmp9_);
#line 933 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			width = _tmp10_;
#line 934 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp11_ = page;
#line 934 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp12_ = page_get_height (_tmp11_);
#line 934 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			height = _tmp12_;
#line 935 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp13_ = width;
#line 935 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			crop_width = (gint) ((_tmp13_ * 0.8) + 0.5);
#line 936 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp14_ = height;
#line 936 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			crop_height = (gint) ((_tmp14_ * 0.8) + 0.5);
#line 937 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp15_ = page;
#line 937 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp16_ = crop_width;
#line 937 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp17_ = crop_height;
#line 937 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			page_set_custom_crop (_tmp15_, _tmp16_, _tmp17_);
#line 938 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp18_ = page;
#line 938 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp19_ = width;
#line 938 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp20_ = crop_width;
#line 938 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp21_ = height;
#line 938 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp22_ = crop_height;
#line 938 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			page_move_crop (_tmp18_, (_tmp19_ - _tmp20_) / 2, (_tmp21_ - _tmp22_) / 2);
#line 4687 "ui.c"
		} else {
			Page* _tmp23_;
			const gchar* _tmp24_;
#line 941 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp23_ = page;
#line 941 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp24_ = crop_name;
#line 941 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			page_set_named_crop (_tmp23_, _tmp24_);
#line 4697 "ui.c"
		}
	}
#line 915 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_page_unref0 (page);
#line 4702 "ui.c"
}


void G_MODULE_EXPORT no_crop_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
#line 945 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 945 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 947 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = widget;
#line 947 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 947 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp1_) {
#line 948 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		user_interface_set_crop (self, NULL);
#line 4721 "ui.c"
	}
}


void G_MODULE_EXPORT custom_crop_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
#line 952 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 952 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 954 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = widget;
#line 954 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 954 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp1_) {
#line 955 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		user_interface_set_crop (self, "custom");
#line 4741 "ui.c"
	}
}


void G_MODULE_EXPORT crop_toolbutton_toggled_cb (GtkToggleToolButton* widget, UserInterface* self) {
	gboolean _tmp0_;
	GtkRadioMenuItem* menuitem = NULL;
	GtkToggleToolButton* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkRadioMenuItem* _tmp9_;
#line 959 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 959 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 961 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->updating_page_menu;
#line 961 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp0_) {
#line 962 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		return;
#line 4762 "ui.c"
	}
#line 965 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = widget;
#line 965 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = gtk_toggle_tool_button_get_active (_tmp1_);
#line 965 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp2_) {
#line 4770 "ui.c"
		GtkBuilder* _tmp3_;
		GObject* _tmp4_ = NULL;
		GtkRadioMenuItem* _tmp5_;
#line 966 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp3_ = self->priv->builder;
#line 966 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp4_ = gtk_builder_get_object (_tmp3_, "custom_crop_menuitem");
#line 966 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
#line 966 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_object_unref0 (menuitem);
#line 966 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		menuitem = _tmp5_;
#line 4784 "ui.c"
	} else {
		GtkBuilder* _tmp6_;
		GObject* _tmp7_ = NULL;
		GtkRadioMenuItem* _tmp8_;
#line 968 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp6_ = self->priv->builder;
#line 968 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp7_ = gtk_builder_get_object (_tmp6_, "no_crop_menuitem");
#line 968 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
#line 968 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_object_unref0 (menuitem);
#line 968 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		menuitem = _tmp8_;
#line 4799 "ui.c"
	}
#line 969 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp9_ = menuitem;
#line 969 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp9_, TRUE);
#line 959 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (menuitem);
#line 4807 "ui.c"
}


void G_MODULE_EXPORT four_by_six_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
#line 973 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 973 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 975 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = widget;
#line 975 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 975 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp1_) {
#line 976 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		user_interface_set_crop (self, "4x6");
#line 4826 "ui.c"
	}
}


void G_MODULE_EXPORT legal_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
#line 980 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 980 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 982 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = widget;
#line 982 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 982 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp1_) {
#line 983 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		user_interface_set_crop (self, "legal");
#line 4846 "ui.c"
	}
}


void G_MODULE_EXPORT letter_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
#line 987 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 987 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 989 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = widget;
#line 989 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 989 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp1_) {
#line 990 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		user_interface_set_crop (self, "letter");
#line 4866 "ui.c"
	}
}


void G_MODULE_EXPORT a6_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
#line 994 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 994 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 996 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = widget;
#line 996 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 996 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp1_) {
#line 997 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		user_interface_set_crop (self, "A6");
#line 4886 "ui.c"
	}
}


void G_MODULE_EXPORT a5_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
#line 1001 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1001 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1003 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = widget;
#line 1003 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 1003 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp1_) {
#line 1004 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		user_interface_set_crop (self, "A5");
#line 4906 "ui.c"
	}
}


void G_MODULE_EXPORT a4_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
#line 1008 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1008 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1010 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = widget;
#line 1010 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 1010 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp1_) {
#line 1011 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		user_interface_set_crop (self, "A4");
#line 4926 "ui.c"
	}
}


void G_MODULE_EXPORT crop_rotate_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
	BookView* _tmp0_;
	Page* _tmp1_ = NULL;
	Page* page;
	Page* _tmp2_;
	Page* _tmp3_;
#line 1015 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1015 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1017 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 1017 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = book_view_get_selected (_tmp0_);
#line 1017 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	page = _tmp1_;
#line 1018 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = page;
#line 1018 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp2_ == NULL) {
#line 1019 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_page_unref0 (page);
#line 1019 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		return;
#line 4955 "ui.c"
	}
#line 1020 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = page;
#line 1020 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	page_rotate_crop (_tmp3_);
#line 1015 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_page_unref0 (page);
#line 4963 "ui.c"
}


void G_MODULE_EXPORT page_move_left_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
	BookView* _tmp0_;
	Page* _tmp1_ = NULL;
	Page* page;
	Book* _tmp2_;
	Page* _tmp3_;
	guint _tmp4_ = 0U;
	guint index;
	guint _tmp5_;
#line 1024 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1024 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1026 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 1026 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = book_view_get_selected (_tmp0_);
#line 1026 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	page = _tmp1_;
#line 1027 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = self->priv->book;
#line 1027 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = page;
#line 1027 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp4_ = book_get_page_index (_tmp2_, _tmp3_);
#line 1027 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	index = _tmp4_;
#line 1028 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp5_ = index;
#line 1028 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp5_ > ((guint) 0)) {
#line 4998 "ui.c"
		Book* _tmp6_;
		Page* _tmp7_;
		guint _tmp8_;
#line 1029 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp6_ = self->priv->book;
#line 1029 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp7_ = page;
#line 1029 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp8_ = index;
#line 1029 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		book_move_page (_tmp6_, _tmp7_, _tmp8_ - 1);
#line 5010 "ui.c"
	}
#line 1031 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_update_page_menu (self);
#line 1024 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_page_unref0 (page);
#line 5016 "ui.c"
}


void G_MODULE_EXPORT page_move_right_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
	BookView* _tmp0_;
	Page* _tmp1_ = NULL;
	Page* page;
	Book* _tmp2_;
	Page* _tmp3_;
	guint _tmp4_ = 0U;
	guint index;
	guint _tmp5_;
	Book* _tmp6_;
	guint _tmp7_ = 0U;
#line 1035 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1035 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1037 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 1037 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = book_view_get_selected (_tmp0_);
#line 1037 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	page = _tmp1_;
#line 1038 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = self->priv->book;
#line 1038 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = page;
#line 1038 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp4_ = book_get_page_index (_tmp2_, _tmp3_);
#line 1038 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	index = _tmp4_;
#line 1039 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp5_ = index;
#line 1039 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp6_ = self->priv->book;
#line 1039 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp7_ = book_get_n_pages (_tmp6_);
#line 1039 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp5_ < (_tmp7_ - 1)) {
#line 5057 "ui.c"
		Book* _tmp8_;
		Page* _tmp9_;
		Book* _tmp10_;
		Page* _tmp11_;
		guint _tmp12_ = 0U;
#line 1040 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp8_ = self->priv->book;
#line 1040 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp9_ = page;
#line 1040 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp10_ = self->priv->book;
#line 1040 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp11_ = page;
#line 1040 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp12_ = book_get_page_index (_tmp10_, _tmp11_);
#line 1040 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		book_move_page (_tmp8_, _tmp9_, _tmp12_ + 1);
#line 5075 "ui.c"
	}
#line 1042 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_update_page_menu (self);
#line 1035 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_page_unref0 (page);
#line 5081 "ui.c"
}


void G_MODULE_EXPORT page_delete_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
	BookView* _tmp0_;
	Book* _tmp1_ = NULL;
	Book* _tmp2_;
	BookView* _tmp3_;
	Page* _tmp4_ = NULL;
	Page* _tmp5_;
#line 1046 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1046 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1048 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 1048 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = book_view_get_book (_tmp0_);
#line 1048 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1048 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = self->priv->book_view;
#line 1048 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp4_ = book_view_get_selected (_tmp3_);
#line 1048 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp5_ = _tmp4_;
#line 1048 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	book_delete_page (_tmp2_, _tmp5_);
#line 1048 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_page_unref0 (_tmp5_);
#line 1048 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_book_unref0 (_tmp2_);
#line 5114 "ui.c"
}


void G_MODULE_EXPORT save_file_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
#line 1052 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1052 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1054 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_save_document (self, FALSE);
#line 5125 "ui.c"
}


void G_MODULE_EXPORT copy_to_clipboard_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	BookView* _tmp0_;
	Page* _tmp1_ = NULL;
	Page* page;
	Page* _tmp2_;
#line 1058 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1058 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1060 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 1060 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = book_view_get_selected (_tmp0_);
#line 1060 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	page = _tmp1_;
#line 1061 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = page;
#line 1061 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp2_ != NULL) {
#line 5148 "ui.c"
		Page* _tmp3_;
		GtkWindow* _tmp4_;
#line 1062 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp3_ = page;
#line 1062 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp4_ = self->priv->window;
#line 1062 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		page_copy_to_clipboard (_tmp3_, _tmp4_);
#line 5157 "ui.c"
	}
#line 1058 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_page_unref0 (page);
#line 5161 "ui.c"
}


void G_MODULE_EXPORT save_as_file_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
#line 1066 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1066 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1068 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_save_document (self, TRUE);
#line 5172 "ui.c"
}


static gpointer _cairo_reference0 (gpointer self) {
#line 1075 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return self ? cairo_reference (self) : NULL;
#line 5179 "ui.c"
}


static void user_interface_draw_page (UserInterface* self, GtkPrintOperation* operation, GtkPrintContext* print_context, gint page_number) {
	GtkPrintContext* _tmp0_;
	cairo_t* _tmp1_ = NULL;
	cairo_t* _tmp2_;
	cairo_t* context;
	Book* _tmp3_;
	gint _tmp4_;
	Page* _tmp5_ = NULL;
	Page* page;
	gboolean is_landscape;
	GtkPrintContext* _tmp6_;
	gdouble _tmp7_ = 0.0;
	GtkPrintContext* _tmp8_;
	gdouble _tmp9_ = 0.0;
	Page* _tmp10_;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_;
	cairo_t* _tmp17_;
	GtkPrintContext* _tmp18_;
	gdouble _tmp19_ = 0.0;
	Page* _tmp20_;
	gint _tmp21_ = 0;
	GtkPrintContext* _tmp22_;
	gdouble _tmp23_ = 0.0;
	Page* _tmp24_;
	gint _tmp25_ = 0;
	Page* _tmp26_;
	GdkPixbuf* _tmp27_ = NULL;
	GdkPixbuf* image;
	cairo_t* _tmp28_;
	cairo_t* _tmp29_;
#line 1071 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1071 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (operation != NULL);
#line 1071 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (print_context != NULL);
#line 1075 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = print_context;
#line 1075 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = gtk_print_context_get_cairo_context (_tmp0_);
#line 1075 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = _cairo_reference0 (_tmp1_);
#line 1075 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	context = _tmp2_;
#line 1076 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = self->priv->book;
#line 1076 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp4_ = page_number;
#line 1076 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp5_ = book_get_page (_tmp3_, _tmp4_);
#line 1076 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	page = _tmp5_;
#line 1079 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	is_landscape = FALSE;
#line 1080 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp6_ = print_context;
#line 1080 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp7_ = gtk_print_context_get_width (_tmp6_);
#line 1080 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp8_ = print_context;
#line 1080 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp9_ = gtk_print_context_get_height (_tmp8_);
#line 1080 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp7_ > _tmp9_) {
#line 1081 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		is_landscape = TRUE;
#line 5250 "ui.c"
	}
#line 1082 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp10_ = page;
#line 1082 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp11_ = page_is_landscape (_tmp10_);
#line 1082 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp12_ = is_landscape;
#line 1082 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp11_ != _tmp12_) {
#line 5260 "ui.c"
		cairo_t* _tmp13_;
		GtkPrintContext* _tmp14_;
		gdouble _tmp15_ = 0.0;
		cairo_t* _tmp16_;
#line 1084 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp13_ = context;
#line 1084 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp14_ = print_context;
#line 1084 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp15_ = gtk_print_context_get_width (_tmp14_);
#line 1084 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		cairo_translate (_tmp13_, _tmp15_, (gdouble) 0);
#line 1085 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp16_ = context;
#line 1085 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		cairo_rotate (_tmp16_, G_PI_2);
#line 5277 "ui.c"
	}
#line 1088 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp17_ = context;
#line 1088 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp18_ = print_context;
#line 1088 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp19_ = gtk_print_context_get_dpi_x (_tmp18_);
#line 1088 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp20_ = page;
#line 1088 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp21_ = page_get_dpi (_tmp20_);
#line 1088 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp22_ = print_context;
#line 1088 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp23_ = gtk_print_context_get_dpi_y (_tmp22_);
#line 1088 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp24_ = page;
#line 1088 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp25_ = page_get_dpi (_tmp24_);
#line 1088 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	cairo_scale (_tmp17_, _tmp19_ / _tmp21_, _tmp23_ / _tmp25_);
#line 1091 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp26_ = page;
#line 1091 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp27_ = page_get_image (_tmp26_, TRUE);
#line 1091 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	image = _tmp27_;
#line 1092 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp28_ = context;
#line 1092 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gdk_cairo_set_source_pixbuf (_tmp28_, image, (gdouble) 0, (gdouble) 0);
#line 1093 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp29_ = context;
#line 1093 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	cairo_paint (_tmp29_);
#line 1071 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (image);
#line 1071 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_page_unref0 (page);
#line 1071 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_cairo_destroy0 (context);
#line 5319 "ui.c"
}


void G_MODULE_EXPORT email_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
#line 1097 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1097 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1099 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->document_hint;
#line 1099 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = user_interface_get_quality (self);
#line 1099 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_signal_emit_by_name (self, "email", _tmp0_, _tmp1_);
#line 5336 "ui.c"
}


static void _user_interface_draw_page_gtk_print_operation_draw_page (GtkPrintOperation* _sender, GtkPrintContext* context, gint page_nr, gpointer self) {
#line 1107 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_draw_page (self, _sender, context, page_nr);
#line 5343 "ui.c"
}


void G_MODULE_EXPORT print_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	GtkPrintOperation* _tmp0_;
	GtkPrintOperation* print;
	Book* _tmp1_;
	guint _tmp2_ = 0U;
	guint _tmp6_ = 0U;
	GError * _inner_error_ = NULL;
#line 1103 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1103 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1105 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = gtk_print_operation_new ();
#line 1105 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	print = _tmp0_;
#line 1106 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = self->priv->book;
#line 1106 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = book_get_n_pages (_tmp1_);
#line 1106 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_print_operation_set_n_pages (print, (gint) _tmp2_);
#line 1107 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_signal_connect (print, "draw-page", (GCallback) _user_interface_draw_page_gtk_print_operation_draw_page, self);
#line 5370 "ui.c"
	{
		GtkWindow* _tmp3_;
#line 1111 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp3_ = self->priv->window;
#line 1111 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		gtk_print_operation_run (print, GTK_PRINT_OPERATION_ACTION_PRINT_DIALOG, _tmp3_, &_inner_error_);
#line 1111 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 5379 "ui.c"
			goto __catch19_g_error;
		}
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 1109 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		e = _inner_error_;
#line 1109 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_inner_error_ = NULL;
#line 1115 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp4_ = e;
#line 1115 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp5_ = _tmp4_->message;
#line 1115 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		g_warning ("ui.vala:1115: Error printing: %s", _tmp5_);
#line 1109 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_error_free0 (e);
#line 5401 "ui.c"
	}
	__finally19:
#line 1109 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 1109 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_object_unref0 (print);
#line 1109 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1109 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1109 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		return;
#line 5414 "ui.c"
	}
#line 1118 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_signal_parse_name ("draw-page", GTK_TYPE_PRINT_OPERATION, &_tmp6_, NULL, FALSE);
#line 1118 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_signal_handlers_disconnect_matched (print, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _user_interface_draw_page_gtk_print_operation_draw_page, self);
#line 1103 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (print);
#line 5422 "ui.c"
}


void G_MODULE_EXPORT help_contents_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
	GError * _inner_error_ = NULL;
#line 1122 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1122 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 5432 "ui.c"
	{
		GtkWindow* _tmp0_;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
#line 1126 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp0_ = self->priv->window;
#line 1126 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp1_ = gtk_window_get_screen (_tmp0_);
#line 1126 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp2_ = gtk_get_current_event_time ();
#line 1126 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		gtk_show_uri (_tmp1_, "help:simple-scan", _tmp2_, &_inner_error_);
#line 1126 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 5447 "ui.c"
			goto __catch20_g_error;
		}
	}
	goto __finally20;
	__catch20_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 1124 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		e = _inner_error_;
#line 1124 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_inner_error_ = NULL;
#line 1130 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp3_ = _ ("Unable to open help file");
#line 1130 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp4_ = e;
#line 1130 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp5_ = _tmp4_->message;
#line 1130 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		user_interface_show_error_dialog (self, _tmp3_, _tmp5_);
#line 1124 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_error_free0 (e);
#line 5472 "ui.c"
	}
	__finally20:
#line 1124 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 1124 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1124 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1124 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		return;
#line 5483 "ui.c"
	}
}


void G_MODULE_EXPORT about_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
	gchar* _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** authors;
	gint authors_length1;
	gint _authors_size_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* license;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* title;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* description;
	GtkWindow* _tmp8_;
	const gchar* _tmp9_ = NULL;
#line 1137 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1137 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1139 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = g_strdup ("Robert Ancell <robert.ancell@canonical.com>");
#line 1139 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = g_new0 (gchar*, 1 + 1);
#line 1139 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_[0] = _tmp0_;
#line 1139 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	authors = _tmp1_;
#line 1139 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	authors_length1 = 1;
#line 1139 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_authors_size_ = authors_length1;
#line 1142 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = _ ("This program is free software: you can redistribute it and/or modify\n" \
"it under the terms of the GNU General Public License as published by\n" \
"the Free Software Foundation, either version 3 of the License, or\n" \
"(at your option) any later version.\n" \
"\n" \
"This program is distributed in the hope that it will be useful,\n" \
"but WITHOUT ANY WARRANTY; without even the implied warranty of\n" \
"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n" \
"GNU General Public License for more details.\n" \
"\n" \
"You should have received a copy of the GNU General Public License\n" \
"along with this program.  If not, see <http://www.gnu.org/licenses/>.");
#line 1142 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 1142 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	license = _tmp3_;
#line 1145 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp4_ = _ ("About Simple Scan");
#line 1145 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 1145 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	title = _tmp5_;
#line 1148 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp6_ = _ ("Simple document scanning tool");
#line 1148 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 1148 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	description = _tmp7_;
#line 1150 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp8_ = self->priv->window;
#line 1150 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp9_ = _ ("translator-credits");
#line 1150 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_show_about_dialog (_tmp8_, "title", title, "program-name", "Simple Scan", "version", VERSION, "comments", description, "logo-icon-name", "scanner", "authors", authors, "translator-credits", _tmp9_, "website", "https://launchpad.net/simple-scan", "copyright", "Copyright © 2009-2011 Canonical Ltd.", "license", license, "wrap-license", TRUE, NULL, NULL);
#line 1137 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (description);
#line 1137 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (title);
#line 1137 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (license);
#line 1137 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
#line 5553 "ui.c"
}


static gboolean user_interface_on_quit (UserInterface* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_ = NULL;
	gchar* device;
	gint paper_width;
	gint paper_height;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	const gchar* _tmp6_;
	GSettings* _tmp9_;
	const gchar* _tmp10_;
	GSettings* _tmp11_;
	gint _tmp12_ = 0;
	GSettings* _tmp13_;
	gint _tmp14_ = 0;
	GSettings* _tmp15_;
	ScanType _tmp16_ = 0;
	GSettings* _tmp17_;
	gint _tmp18_;
	GSettings* _tmp19_;
	gint _tmp20_;
	GSettings* _tmp21_;
	gint _tmp22_ = 0;
	GSettings* _tmp23_;
	gint _tmp24_ = 0;
	GSettings* _tmp25_;
	gint _tmp26_ = 0;
	GSettings* _tmp27_;
	gint _tmp28_;
	GSettings* _tmp29_;
	gint _tmp30_;
	GSettings* _tmp31_;
	gboolean _tmp32_;
	GSettings* _tmp33_;
	ScanDirection _tmp34_;
	GSettings* _tmp35_;
	gint _tmp36_;
	GSettings* _tmp37_;
	gint _tmp38_;
	GSettings* _tmp39_;
	gint _tmp40_;
	GtkWindow* _tmp41_;
	AutosaveManager* _tmp42_;
#line 1165 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1167 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = _ ("Save document before quitting?");
#line 1167 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = _ ("Quit without Saving");
#line 1167 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = user_interface_prompt_to_save (self, _tmp0_, _tmp1_);
#line 1167 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (!_tmp2_) {
#line 1171 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		result = FALSE;
#line 1171 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		return result;
#line 5617 "ui.c"
	}
#line 1173 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = user_interface_get_selected_device (self);
#line 1173 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	device = _tmp3_;
#line 1174 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	paper_width = 0;
#line 1174 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	paper_height = 0;
#line 1175 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_get_paper_size (self, &_tmp4_, &_tmp5_);
#line 1175 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	paper_width = _tmp4_;
#line 1175 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	paper_height = _tmp5_;
#line 1177 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp6_ = device;
#line 1177 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp6_ != NULL) {
#line 5637 "ui.c"
		GSettings* _tmp7_;
		const gchar* _tmp8_;
#line 1178 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp7_ = self->priv->settings;
#line 1178 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp8_ = device;
#line 1178 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		g_settings_set_string (_tmp7_, "selected-device", _tmp8_);
#line 5646 "ui.c"
	}
#line 1179 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp9_ = self->priv->settings;
#line 1179 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp10_ = self->priv->document_hint;
#line 1179 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_settings_set_string (_tmp9_, "document-type", _tmp10_);
#line 1180 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp11_ = self->priv->settings;
#line 1180 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp12_ = user_interface_get_text_dpi (self);
#line 1180 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_settings_set_int (_tmp11_, "text-dpi", _tmp12_);
#line 1181 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp13_ = self->priv->settings;
#line 1181 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp14_ = user_interface_get_photo_dpi (self);
#line 1181 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_settings_set_int (_tmp13_, "photo-dpi", _tmp14_);
#line 1182 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp15_ = self->priv->settings;
#line 1182 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp16_ = user_interface_get_page_side (self);
#line 1182 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_settings_set_enum (_tmp15_, "page-side", (gint) _tmp16_);
#line 1183 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp17_ = self->priv->settings;
#line 1183 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp18_ = paper_width;
#line 1183 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_settings_set_int (_tmp17_, "paper-width", _tmp18_);
#line 1184 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp19_ = self->priv->settings;
#line 1184 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp20_ = paper_height;
#line 1184 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_settings_set_int (_tmp19_, "paper-height", _tmp20_);
#line 1185 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp21_ = self->priv->settings;
#line 1185 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp22_ = user_interface_get_brightness (self);
#line 1185 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_settings_set_int (_tmp21_, "brightness", _tmp22_);
#line 1186 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp23_ = self->priv->settings;
#line 1186 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp24_ = user_interface_get_contrast (self);
#line 1186 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_settings_set_int (_tmp23_, "contrast", _tmp24_);
#line 1187 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp25_ = self->priv->settings;
#line 1187 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp26_ = user_interface_get_quality (self);
#line 1187 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_settings_set_int (_tmp25_, "jpeg-quality", _tmp26_);
#line 1188 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp27_ = self->priv->settings;
#line 1188 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp28_ = self->priv->window_width;
#line 1188 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_settings_set_int (_tmp27_, "window-width", _tmp28_);
#line 1189 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp29_ = self->priv->settings;
#line 1189 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp30_ = self->priv->window_height;
#line 1189 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_settings_set_int (_tmp29_, "window-height", _tmp30_);
#line 1190 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp31_ = self->priv->settings;
#line 1190 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp32_ = self->priv->window_is_maximized;
#line 1190 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_settings_set_boolean (_tmp31_, "window-is-maximized", _tmp32_);
#line 1191 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp33_ = self->priv->settings;
#line 1191 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp34_ = self->priv->default_page_scan_direction;
#line 1191 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_settings_set_enum (_tmp33_, "scan-direction", (gint) _tmp34_);
#line 1192 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp35_ = self->priv->settings;
#line 1192 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp36_ = self->priv->default_page_width;
#line 1192 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_settings_set_int (_tmp35_, "page-width", _tmp36_);
#line 1193 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp37_ = self->priv->settings;
#line 1193 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp38_ = self->priv->default_page_height;
#line 1193 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_settings_set_int (_tmp37_, "page-height", _tmp38_);
#line 1194 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp39_ = self->priv->settings;
#line 1194 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp40_ = self->priv->default_page_dpi;
#line 1194 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_settings_set_int (_tmp39_, "page-dpi", _tmp40_);
#line 1196 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp41_ = self->priv->window;
#line 1196 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp41_);
#line 1198 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp42_ = self->priv->autosave_manager;
#line 1198 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	autosave_manager_cleanup (_tmp42_);
#line 1200 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	result = TRUE;
#line 1200 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (device);
#line 1200 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return result;
#line 5758 "ui.c"
}


void G_MODULE_EXPORT quit_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
#line 1204 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1204 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1206 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_on_quit (self);
#line 5769 "ui.c"
}


gboolean G_MODULE_EXPORT simple_scan_window_configure_event_cb (GtkWidget* widget, GdkEventConfigure* event, UserInterface* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 1210 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1210 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1210 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 1212 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->window_is_maximized;
#line 1212 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (!_tmp0_) {
#line 5786 "ui.c"
		GdkEventConfigure _tmp1_;
		gint _tmp2_;
		GdkEventConfigure _tmp3_;
		gint _tmp4_;
#line 1214 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp1_ = *event;
#line 1214 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp2_ = _tmp1_.width;
#line 1214 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		self->priv->window_width = _tmp2_;
#line 1215 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp3_ = *event;
#line 1215 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp4_ = _tmp3_.height;
#line 1215 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		self->priv->window_height = _tmp4_;
#line 5803 "ui.c"
	}
#line 1218 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	result = FALSE;
#line 1218 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return result;
#line 5809 "ui.c"
}


static void user_interface_info_bar_response_cb (UserInterface* self, GtkInfoBar* widget, gint response_id) {
	gint _tmp0_;
#line 1221 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1221 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1223 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = response_id;
#line 1223 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp0_ == 1) {
#line 5823 "ui.c"
		GtkComboBox* _tmp1_;
		GtkDialog* _tmp2_;
#line 1225 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp1_ = self->priv->device_combo;
#line 1225 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
#line 1226 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp2_ = self->priv->preferences_dialog;
#line 1226 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		gtk_window_present ((GtkWindow*) _tmp2_);
#line 5834 "ui.c"
	} else {
#line 1230 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		self->priv->have_error = FALSE;
#line 1231 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (self->priv->error_title);
#line 1231 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		self->priv->error_title = NULL;
#line 1232 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (self->priv->error_text);
#line 1232 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		self->priv->error_text = NULL;
#line 1233 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		user_interface_update_info_bar (self);
#line 5848 "ui.c"
	}
}


gboolean G_MODULE_EXPORT simple_scan_window_window_state_event_cb (GtkWidget* widget, GdkEventWindowState* event, UserInterface* self) {
	gboolean result = FALSE;
	GdkEventWindowState _tmp0_;
	GdkWindowState _tmp1_;
#line 1238 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1238 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1238 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 1240 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = *event;
#line 1240 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = _tmp0_.changed_mask;
#line 1240 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 5869 "ui.c"
		GdkEventWindowState _tmp2_;
		GdkWindowState _tmp3_;
#line 1241 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp2_ = *event;
#line 1241 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp3_ = _tmp2_.new_window_state;
#line 1241 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		self->priv->window_is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 5878 "ui.c"
	}
#line 1242 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	result = FALSE;
#line 1242 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return result;
#line 5884 "ui.c"
}


gboolean G_MODULE_EXPORT window_delete_event_cb (GtkWidget* widget, GdkEvent* event, UserInterface* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 1246 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1246 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1246 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 1248 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = user_interface_on_quit (self);
#line 1248 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	result = !_tmp0_;
#line 1248 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return result;
#line 5903 "ui.c"
}


static void user_interface_page_size_changed_cb (UserInterface* self, Page* page) {
	Page* _tmp0_;
	gint _tmp1_ = 0;
	Page* _tmp2_;
	gint _tmp3_ = 0;
	Page* _tmp4_;
	gint _tmp5_ = 0;
#line 1251 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1251 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 1253 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = page;
#line 1253 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = page_get_width (_tmp0_);
#line 1253 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->default_page_width = _tmp1_;
#line 1254 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = page;
#line 1254 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = page_get_height (_tmp2_);
#line 1254 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->default_page_height = _tmp3_;
#line 1255 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp4_ = page;
#line 1255 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp5_ = page_get_dpi (_tmp4_);
#line 1255 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->default_page_dpi = _tmp5_;
#line 5936 "ui.c"
}


static void user_interface_page_scan_direction_changed_cb (UserInterface* self, Page* page) {
	Page* _tmp0_;
	ScanDirection _tmp1_ = 0;
#line 1258 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1258 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 1260 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = page;
#line 1260 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = page_get_scan_direction (_tmp0_);
#line 1260 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->default_page_scan_direction = _tmp1_;
#line 5953 "ui.c"
}


static void _user_interface_page_size_changed_cb_page_size_changed (Page* _sender, gpointer self) {
#line 1269 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_page_size_changed_cb (self, _sender);
#line 5960 "ui.c"
}


static void _user_interface_page_scan_direction_changed_cb_page_scan_direction_changed (Page* _sender, gpointer self) {
#line 1270 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_page_scan_direction_changed_cb (self, _sender);
#line 5967 "ui.c"
}


static void user_interface_page_added_cb (UserInterface* self, Book* book, Page* page) {
	Page* _tmp0_;
	gint _tmp1_ = 0;
	Page* _tmp2_;
	gint _tmp3_ = 0;
	Page* _tmp4_;
	gint _tmp5_ = 0;
	Page* _tmp6_;
	ScanDirection _tmp7_ = 0;
	Page* _tmp8_;
	Page* _tmp9_;
#line 1263 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1263 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (book != NULL);
#line 1263 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 1265 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = page;
#line 1265 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = page_get_width (_tmp0_);
#line 1265 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->default_page_width = _tmp1_;
#line 1266 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = page;
#line 1266 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = page_get_height (_tmp2_);
#line 1266 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->default_page_height = _tmp3_;
#line 1267 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp4_ = page;
#line 1267 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp5_ = page_get_dpi (_tmp4_);
#line 1267 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->default_page_dpi = _tmp5_;
#line 1268 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp6_ = page;
#line 1268 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp7_ = page_get_scan_direction (_tmp6_);
#line 1268 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->default_page_scan_direction = _tmp7_;
#line 1269 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp8_ = page;
#line 1269 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_signal_connect (_tmp8_, "size-changed", (GCallback) _user_interface_page_size_changed_cb_page_size_changed, self);
#line 1270 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp9_ = page;
#line 1270 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_signal_connect (_tmp9_, "scan-direction-changed", (GCallback) _user_interface_page_scan_direction_changed_cb_page_scan_direction_changed, self);
#line 1272 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_update_page_menu (self);
#line 6022 "ui.c"
}


static void user_interface_page_removed_cb (UserInterface* self, Book* book, Page* page) {
	Page* _tmp0_;
	guint _tmp1_ = 0U;
	Page* _tmp2_;
	guint _tmp3_ = 0U;
	Book* _tmp4_;
	guint _tmp5_ = 0U;
#line 1275 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1275 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (book != NULL);
#line 1275 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 1277 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = page;
#line 1277 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_signal_parse_name ("size-changed", TYPE_PAGE, &_tmp1_, NULL, FALSE);
#line 1277 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _user_interface_page_size_changed_cb_page_size_changed, self);
#line 1278 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = page;
#line 1278 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_signal_parse_name ("scan-direction-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 1278 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _user_interface_page_scan_direction_changed_cb_page_scan_direction_changed, self);
#line 1281 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp4_ = book;
#line 1281 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp5_ = book_get_n_pages (_tmp4_);
#line 1281 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp5_ == ((guint) 1)) {
#line 1282 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		user_interface_add_default_page (self);
#line 6059 "ui.c"
	}
#line 1284 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_update_page_menu (self);
#line 6063 "ui.c"
}


static void user_interface_set_dpi_combo (UserInterface* self, GtkComboBox* combo, gint default_dpi, gint current_dpi) {
	GtkCellRendererText* _tmp0_;
	GtkCellRendererText* renderer;
	GtkComboBox* _tmp1_;
	GtkCellRendererText* _tmp2_;
	GtkComboBox* _tmp3_;
	GtkCellRendererText* _tmp4_;
	GtkComboBox* _tmp5_;
	GtkTreeModel* _tmp6_ = NULL;
	GtkListStore* _tmp7_;
	GtkListStore* model;
	gint* _tmp8_ = NULL;
	gint* scan_resolutions;
	gint scan_resolutions_length1;
	gint _scan_resolutions_size_;
	gint* _tmp9_;
	gint _tmp9__length1;
#line 1287 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1287 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (combo != NULL);
#line 1289 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 1289 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_object_ref_sink (_tmp0_);
#line 1289 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	renderer = _tmp0_;
#line 1290 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = combo;
#line 1290 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = renderer;
#line 1290 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp1_, (GtkCellRenderer*) _tmp2_, TRUE);
#line 1291 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = combo;
#line 1291 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp4_ = renderer;
#line 1291 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp3_, (GtkCellRenderer*) _tmp4_, "text", 1);
#line 1293 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp5_ = combo;
#line 1293 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp6_ = gtk_combo_box_get_model (_tmp5_);
#line 1293 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GTK_TYPE_LIST_STORE, GtkListStore));
#line 1293 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	model = _tmp7_;
#line 1294 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp8_ = g_new0 (gint, 6);
#line 1294 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp8_[0] = 75;
#line 1294 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp8_[1] = 150;
#line 1294 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp8_[2] = 300;
#line 1294 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp8_[3] = 600;
#line 1294 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp8_[4] = 1200;
#line 1294 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp8_[5] = 2400;
#line 1294 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	scan_resolutions = _tmp8_;
#line 1294 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	scan_resolutions_length1 = 6;
#line 1294 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_scan_resolutions_size_ = scan_resolutions_length1;
#line 1295 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp9_ = scan_resolutions;
#line 1295 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp9__length1 = scan_resolutions_length1;
#line 6138 "ui.c"
	{
		gint* dpi_collection = NULL;
		gint dpi_collection_length1 = 0;
		gint _dpi_collection_size_ = 0;
		gint dpi_it = 0;
#line 1295 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		dpi_collection = _tmp9_;
#line 1295 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		dpi_collection_length1 = _tmp9__length1;
#line 1295 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		for (dpi_it = 0; dpi_it < _tmp9__length1; dpi_it = dpi_it + 1) {
#line 6150 "ui.c"
			gint dpi = 0;
#line 1295 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			dpi = dpi_collection[dpi_it];
#line 6154 "ui.c"
			{
				gchar* label = NULL;
				gint _tmp10_;
				gint _tmp11_;
				GtkTreeIter iter = {0};
				GtkListStore* _tmp26_;
				GtkTreeIter _tmp27_ = {0};
				GtkListStore* _tmp28_;
				GtkTreeIter _tmp29_;
				gint _tmp30_;
				const gchar* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
#line 1298 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp10_ = dpi;
#line 1298 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp11_ = default_dpi;
#line 1298 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				if (_tmp10_ == _tmp11_) {
#line 6174 "ui.c"
					const gchar* _tmp12_ = NULL;
					gint _tmp13_;
					gchar* _tmp14_ = NULL;
#line 1300 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp12_ = _ ("%d dpi (default)");
#line 1300 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp13_ = dpi;
#line 1300 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp14_ = g_strdup_printf (_tmp12_, _tmp13_);
#line 1300 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_g_free0 (label);
#line 1300 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					label = _tmp14_;
#line 6188 "ui.c"
				} else {
					gint _tmp15_;
#line 1301 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp15_ = dpi;
#line 1301 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					if (_tmp15_ == 75) {
#line 6195 "ui.c"
						const gchar* _tmp16_ = NULL;
						gint _tmp17_;
						gchar* _tmp18_ = NULL;
#line 1303 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
						_tmp16_ = _ ("%d dpi (draft)");
#line 1303 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
						_tmp17_ = dpi;
#line 1303 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
						_tmp18_ = g_strdup_printf (_tmp16_, _tmp17_);
#line 1303 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
						_g_free0 (label);
#line 1303 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
						label = _tmp18_;
#line 6209 "ui.c"
					} else {
						gint _tmp19_;
#line 1304 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
						_tmp19_ = dpi;
#line 1304 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
						if (_tmp19_ == 1200) {
#line 6216 "ui.c"
							const gchar* _tmp20_ = NULL;
							gint _tmp21_;
							gchar* _tmp22_ = NULL;
#line 1306 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							_tmp20_ = _ ("%d dpi (high resolution)");
#line 1306 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							_tmp21_ = dpi;
#line 1306 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							_tmp22_ = g_strdup_printf (_tmp20_, _tmp21_);
#line 1306 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							_g_free0 (label);
#line 1306 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							label = _tmp22_;
#line 6230 "ui.c"
						} else {
							const gchar* _tmp23_ = NULL;
							gint _tmp24_;
							gchar* _tmp25_ = NULL;
#line 1309 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							_tmp23_ = _ ("%d dpi");
#line 1309 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							_tmp24_ = dpi;
#line 1309 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							_tmp25_ = g_strdup_printf (_tmp23_, _tmp24_);
#line 1309 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							_g_free0 (label);
#line 1309 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
							label = _tmp25_;
#line 6245 "ui.c"
						}
					}
				}
#line 1312 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp26_ = model;
#line 1312 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				gtk_list_store_append (_tmp26_, &_tmp27_);
#line 1312 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				iter = _tmp27_;
#line 1313 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp28_ = model;
#line 1313 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp29_ = iter;
#line 1313 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp30_ = dpi;
#line 1313 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp31_ = label;
#line 1313 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				gtk_list_store_set (_tmp28_, &_tmp29_, 0, _tmp30_, 1, _tmp31_, -1, -1);
#line 1315 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp32_ = dpi;
#line 1315 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_tmp33_ = current_dpi;
#line 1315 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				if (_tmp32_ == _tmp33_) {
#line 6271 "ui.c"
					GtkComboBox* _tmp34_;
					GtkTreeIter _tmp35_;
#line 1316 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp34_ = combo;
#line 1316 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					_tmp35_ = iter;
#line 1316 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
					gtk_combo_box_set_active_iter (_tmp34_, &_tmp35_);
#line 6280 "ui.c"
				}
#line 1295 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
				_g_free0 (label);
#line 6284 "ui.c"
			}
		}
	}
#line 1287 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	scan_resolutions = (g_free (scan_resolutions), NULL);
#line 1287 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (model);
#line 1287 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (renderer);
#line 6294 "ui.c"
}


static void user_interface_needs_saving_cb (UserInterface* self, Book* book) {
	GtkMenuItem* _tmp0_;
	Book* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkToolButton* _tmp3_;
	Book* _tmp4_;
	gboolean _tmp5_ = FALSE;
	Book* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GtkMenuItem* _tmp9_;
#line 1320 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1320 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (book != NULL);
#line 1322 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->save_menuitem;
#line 1322 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = book;
#line 1322 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = book_get_needs_saving (_tmp1_);
#line 1322 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp2_);
#line 1323 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = self->priv->save_toolbutton;
#line 1323 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp4_ = book;
#line 1323 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp5_ = book_get_needs_saving (_tmp4_);
#line 1323 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, _tmp5_);
#line 1324 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp6_ = book;
#line 1324 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp7_ = book_get_needs_saving (_tmp6_);
#line 1324 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp7_) {
#line 6334 "ui.c"
		GtkMenuItem* _tmp8_;
#line 1325 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp8_ = self->priv->save_as_menuitem;
#line 1325 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, TRUE);
#line 6340 "ui.c"
	}
#line 1326 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp9_ = self->priv->copy_to_clipboard_menuitem;
#line 1326 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, TRUE);
#line 6346 "ui.c"
}


static void _user_interface_info_bar_response_cb_gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self) {
#line 1396 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_info_bar_response_cb (self, _sender, response_id);
#line 6353 "ui.c"
}


static void _user_interface_page_selected_cb_book_view_page_selected (BookView* _sender, Page* page, gpointer self) {
#line 1500 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_page_selected_cb (self, _sender, page);
#line 6360 "ui.c"
}


static void _user_interface_show_page_cb_book_view_show_page (BookView* _sender, Page* page, gpointer self) {
#line 1501 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_show_page_cb (self, _sender, page);
#line 6367 "ui.c"
}


static void _user_interface_show_page_menu_cb_book_view_show_menu (BookView* _sender, gpointer self) {
#line 1502 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_show_page_menu_cb (self, _sender);
#line 6374 "ui.c"
}


static void _user_interface_book_saving_cb_book_saving (Book* _sender, gint i, gpointer self) {
#line 1534 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_book_saving_cb (self, i);
#line 6381 "ui.c"
}


static void user_interface_load (UserInterface* self) {
	GtkIconTheme* _tmp0_ = NULL;
	GtkBuilder* _tmp1_;
	GtkBuilder* _tmp7_;
	GtkBuilder* _tmp8_;
	GObject* _tmp9_ = NULL;
	GtkWindow* _tmp10_;
	GApplication* _tmp11_ = NULL;
	GtkApplication* _tmp12_;
	GtkApplication* app;
	GtkApplication* _tmp13_;
	GtkWindow* _tmp14_;
	GtkBuilder* _tmp15_;
	GObject* _tmp16_ = NULL;
	GtkVBox* _tmp17_;
	GtkBuilder* _tmp18_;
	GObject* _tmp19_ = NULL;
	GtkMenuItem* _tmp20_;
	GtkBuilder* _tmp21_;
	GObject* _tmp22_ = NULL;
	GtkMenuItem* _tmp23_;
	GtkBuilder* _tmp24_;
	GObject* _tmp25_ = NULL;
	GtkMenuItem* _tmp26_;
	GtkBuilder* _tmp27_;
	GObject* _tmp28_ = NULL;
	GtkMenuItem* _tmp29_;
	GtkBuilder* _tmp30_;
	GObject* _tmp31_ = NULL;
	GtkMenuItem* _tmp32_;
	GtkBuilder* _tmp33_;
	GObject* _tmp34_ = NULL;
	GtkMenuItem* _tmp35_;
	GtkBuilder* _tmp36_;
	GObject* _tmp37_ = NULL;
	GtkMenuItem* _tmp38_;
	GtkBuilder* _tmp39_;
	GObject* _tmp40_ = NULL;
	GtkToolButton* _tmp41_;
	GtkBuilder* _tmp42_;
	GObject* _tmp43_ = NULL;
	GtkMenuItem* _tmp44_;
	GtkBuilder* _tmp45_;
	GObject* _tmp46_ = NULL;
	GtkToolButton* _tmp47_;
	GtkBuilder* _tmp48_;
	GObject* _tmp49_ = NULL;
	GtkRadioMenuItem* _tmp50_;
	GtkBuilder* _tmp51_;
	GObject* _tmp52_ = NULL;
	GtkRadioMenuItem* _tmp53_;
	GtkBuilder* _tmp54_;
	GObject* _tmp55_ = NULL;
	GtkRadioMenuItem* _tmp56_;
	GtkBuilder* _tmp57_;
	GObject* _tmp58_ = NULL;
	GtkRadioMenuItem* _tmp59_;
	GtkBuilder* _tmp60_;
	GObject* _tmp61_ = NULL;
	GtkDialog* _tmp62_;
	GtkBuilder* _tmp63_;
	GObject* _tmp64_ = NULL;
	GtkLabel* _tmp65_;
	GtkBuilder* _tmp66_;
	GObject* _tmp67_ = NULL;
	GtkEntry* _tmp68_;
	GtkBuilder* _tmp69_;
	GObject* _tmp70_ = NULL;
	GtkEntry* _tmp71_;
	GtkBuilder* _tmp72_;
	GObject* _tmp73_ = NULL;
	GtkDialog* _tmp74_;
	GtkBuilder* _tmp75_;
	GObject* _tmp76_ = NULL;
	GtkComboBox* _tmp77_;
	GtkComboBox* _tmp78_;
	GtkTreeModel* _tmp79_ = NULL;
	GtkListStore* _tmp80_;
	GtkBuilder* _tmp81_;
	GObject* _tmp82_ = NULL;
	GtkComboBox* _tmp83_;
	GtkComboBox* _tmp84_;
	GtkTreeModel* _tmp85_ = NULL;
	GtkListStore* _tmp86_;
	GtkBuilder* _tmp87_;
	GObject* _tmp88_ = NULL;
	GtkComboBox* _tmp89_;
	GtkComboBox* _tmp90_;
	GtkTreeModel* _tmp91_ = NULL;
	GtkListStore* _tmp92_;
	GtkBuilder* _tmp93_;
	GObject* _tmp94_ = NULL;
	GtkComboBox* _tmp95_;
	GtkComboBox* _tmp96_;
	GtkTreeModel* _tmp97_ = NULL;
	GtkListStore* _tmp98_;
	GtkBuilder* _tmp99_;
	GObject* _tmp100_ = NULL;
	GtkComboBox* _tmp101_;
	GtkComboBox* _tmp102_;
	GtkTreeModel* _tmp103_ = NULL;
	GtkListStore* _tmp104_;
	GtkBuilder* _tmp105_;
	GObject* _tmp106_ = NULL;
	GtkScale* _tmp107_;
	GtkScale* _tmp108_;
	GtkAdjustment* _tmp109_ = NULL;
	GtkAdjustment* _tmp110_;
	GtkBuilder* _tmp111_;
	GObject* _tmp112_ = NULL;
	GtkScale* _tmp113_;
	GtkScale* _tmp114_;
	GtkAdjustment* _tmp115_ = NULL;
	GtkAdjustment* _tmp116_;
	GtkBuilder* _tmp117_;
	GObject* _tmp118_ = NULL;
	GtkScale* _tmp119_;
	GtkScale* _tmp120_;
	GtkAdjustment* _tmp121_ = NULL;
	GtkAdjustment* _tmp122_;
	GtkInfoBar* _tmp123_;
	GtkInfoBar* _tmp124_;
	GtkVBox* _tmp125_;
	GtkInfoBar* _tmp126_;
	GtkBox* _tmp127_;
	GtkBox* hbox;
	GtkInfoBar* _tmp128_;
	GtkContainer* _tmp129_ = NULL;
	GtkContainer* _tmp130_;
	GtkContainer* content_area;
	GtkContainer* _tmp131_;
	GtkBox* _tmp132_;
	GtkBox* _tmp133_;
	GtkImage* _tmp134_;
	GtkBox* _tmp135_;
	GtkImage* _tmp136_;
	GtkImage* _tmp137_;
	GtkLabel* _tmp138_;
	GtkLabel* _tmp139_;
	GtkBox* _tmp140_;
	GtkLabel* _tmp141_;
	GtkLabel* _tmp142_;
	GtkInfoBar* _tmp143_;
	GtkButton* _tmp144_ = NULL;
	GtkButton* _tmp145_;
	GtkInfoBar* _tmp146_;
	const gchar* _tmp147_ = NULL;
	GtkButton* _tmp148_ = NULL;
	GtkButton* _tmp149_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp150_;
	GtkTreeIter _tmp151_ = {0};
	GtkListStore* _tmp152_;
	GtkTreeIter _tmp153_;
	const gchar* _tmp154_ = NULL;
	GtkListStore* _tmp155_;
	GtkTreeIter _tmp156_ = {0};
	GtkListStore* _tmp157_;
	GtkTreeIter _tmp158_;
	GtkListStore* _tmp159_;
	GtkTreeIter _tmp160_ = {0};
	GtkListStore* _tmp161_;
	GtkTreeIter _tmp162_;
	GtkListStore* _tmp163_;
	GtkTreeIter _tmp164_ = {0};
	GtkListStore* _tmp165_;
	GtkTreeIter _tmp166_;
	GtkListStore* _tmp167_;
	GtkTreeIter _tmp168_ = {0};
	GtkListStore* _tmp169_;
	GtkTreeIter _tmp170_;
	GtkListStore* _tmp171_;
	GtkTreeIter _tmp172_ = {0};
	GtkListStore* _tmp173_;
	GtkTreeIter _tmp174_;
	GtkListStore* _tmp175_;
	GtkTreeIter _tmp176_ = {0};
	GtkListStore* _tmp177_;
	GtkTreeIter _tmp178_;
	GSettings* _tmp179_;
	gint _tmp180_ = 0;
	gint dpi;
	gint _tmp181_;
	GtkComboBox* _tmp182_;
	gint _tmp183_;
	GSettings* _tmp184_;
	gint _tmp185_ = 0;
	gint _tmp186_;
	GtkComboBox* _tmp187_;
	gint _tmp188_;
	GtkCellRendererText* _tmp189_;
	GtkCellRendererText* renderer;
	GtkComboBox* _tmp190_;
	GtkCellRendererText* _tmp191_;
	GtkComboBox* _tmp192_;
	GtkCellRendererText* _tmp193_;
	GtkCellRendererText* _tmp194_;
	GtkComboBox* _tmp195_;
	GtkCellRendererText* _tmp196_;
	GtkComboBox* _tmp197_;
	GtkCellRendererText* _tmp198_;
	GSettings* _tmp199_;
	gint _tmp200_ = 0;
	GtkCellRendererText* _tmp201_;
	GtkComboBox* _tmp202_;
	GtkCellRendererText* _tmp203_;
	GtkComboBox* _tmp204_;
	GtkCellRendererText* _tmp205_;
	GSettings* _tmp206_;
	gint _tmp207_ = 0;
	gint paper_width;
	GSettings* _tmp208_;
	gint _tmp209_ = 0;
	gint paper_height;
	gint _tmp210_;
	gint _tmp211_;
	GtkAdjustment* _tmp212_;
	gdouble _tmp213_ = 0.0;
	gdouble lower;
	const gchar* _tmp214_ = NULL;
	gchar* _tmp215_ = NULL;
	gchar* darker_label;
	GtkAdjustment* _tmp216_;
	gdouble _tmp217_ = 0.0;
	gdouble upper;
	const gchar* _tmp218_ = NULL;
	gchar* _tmp219_ = NULL;
	gchar* lighter_label;
	GtkScale* _tmp220_;
	gdouble _tmp221_;
	const gchar* _tmp222_;
	GtkScale* _tmp223_;
	GtkScale* _tmp224_;
	gdouble _tmp225_;
	const gchar* _tmp226_;
	GSettings* _tmp227_;
	gint _tmp228_ = 0;
	GtkAdjustment* _tmp229_;
	gdouble _tmp230_ = 0.0;
	const gchar* _tmp231_ = NULL;
	gchar* _tmp232_ = NULL;
	gchar* less_label;
	GtkAdjustment* _tmp233_;
	gdouble _tmp234_ = 0.0;
	const gchar* _tmp235_ = NULL;
	gchar* _tmp236_ = NULL;
	gchar* more_label;
	GtkScale* _tmp237_;
	gdouble _tmp238_;
	const gchar* _tmp239_;
	GtkScale* _tmp240_;
	GtkScale* _tmp241_;
	gdouble _tmp242_;
	const gchar* _tmp243_;
	GSettings* _tmp244_;
	gint _tmp245_ = 0;
	GtkAdjustment* _tmp246_;
	gdouble _tmp247_ = 0.0;
	const gchar* _tmp248_ = NULL;
	gchar* _tmp249_ = NULL;
	gchar* minimum_label;
	GtkAdjustment* _tmp250_;
	gdouble _tmp251_ = 0.0;
	const gchar* _tmp252_ = NULL;
	gchar* _tmp253_ = NULL;
	gchar* maximum_label;
	GtkScale* _tmp254_;
	gdouble _tmp255_;
	const gchar* _tmp256_;
	GtkScale* _tmp257_;
	GtkScale* _tmp258_;
	gdouble _tmp259_;
	const gchar* _tmp260_;
	GSettings* _tmp261_;
	gint _tmp262_ = 0;
	GSettings* _tmp263_;
	gchar* _tmp264_ = NULL;
	gchar* device;
	const gchar* _tmp265_;
	GSettings* _tmp271_;
	gchar* _tmp272_ = NULL;
	gchar* document_type;
	const gchar* _tmp273_;
	Book* _tmp275_;
	BookView* _tmp276_;
	BookView* _tmp277_;
	GtkVBox* _tmp278_;
	BookView* _tmp279_;
	BookView* _tmp280_;
	BookView* _tmp281_;
	BookView* _tmp282_;
	BookView* _tmp283_;
	GSettings* _tmp284_;
	gint _tmp285_ = 0;
	GSettings* _tmp286_;
	gint _tmp287_ = 0;
	gint _tmp288_;
	GSettings* _tmp289_;
	gint _tmp290_ = 0;
	gint _tmp291_;
	GSettings* _tmp292_;
	gint _tmp293_ = 0;
	gint _tmp294_;
	GSettings* _tmp295_;
	gint _tmp296_ = 0;
	gint _tmp297_;
	GSettings* _tmp298_;
	gint _tmp299_ = 0;
	gint _tmp300_;
	gint _tmp301_;
	gint _tmp302_;
	GtkWindow* _tmp303_;
	gint _tmp304_;
	gint _tmp305_;
	GSettings* _tmp306_;
	gboolean _tmp307_ = FALSE;
	gboolean _tmp308_;
	GtkWindow* _tmp310_;
	const gchar* _tmp311_ = NULL;
	ProgressBarDialog* _tmp312_;
	Book* _tmp313_;
	GError * _inner_error_ = NULL;
#line 1329 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1331 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = gtk_icon_theme_get_default ();
#line 1331 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_icon_theme_append_search_path (_tmp0_, ICON_DIR);
#line 1333 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_window_set_default_icon_name ("scanner");
#line 1335 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = gtk_builder_new ();
#line 1335 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->builder);
#line 1335 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->builder = _tmp1_;
#line 6721 "ui.c"
	{
		GtkBuilder* _tmp2_;
#line 1338 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp2_ = self->priv->builder;
#line 1338 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		gtk_builder_add_from_resource (_tmp2_, "/org/gnome/SimpleScan/simple-scan.ui", &_inner_error_);
#line 1338 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 6730 "ui.c"
			goto __catch21_g_error;
		}
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 1336 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		e = _inner_error_;
#line 1336 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_inner_error_ = NULL;
#line 1342 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp3_ = e;
#line 1342 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp4_ = _tmp3_->message;
#line 1342 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		g_critical ("ui.vala:1342: Unable to load UI: %s\n", _tmp4_);
#line 1343 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp5_ = _ ("Files missing");
#line 1343 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp6_ = _ ("Please check your installation");
#line 1343 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		user_interface_show_error_dialog (self, _tmp5_, _tmp6_);
#line 1347 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		exit (EXIT_FAILURE);
#line 1336 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_error_free0 (e);
#line 6762 "ui.c"
	}
	__finally21:
#line 1336 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 1336 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1336 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1336 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		return;
#line 6773 "ui.c"
	}
#line 1349 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp7_ = self->priv->builder;
#line 1349 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_builder_connect_signals (_tmp7_, self);
#line 1351 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp8_ = self->priv->builder;
#line 1351 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp9_ = gtk_builder_get_object (_tmp8_, "simple_scan_window");
#line 1351 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GTK_TYPE_WINDOW, GtkWindow));
#line 1351 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->window);
#line 1351 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->window = _tmp10_;
#line 1352 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp11_ = g_application_get_default ();
#line 1352 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, GTK_TYPE_APPLICATION) ? ((GtkApplication*) _tmp11_) : NULL);
#line 1352 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	app = _tmp12_;
#line 1353 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp13_ = app;
#line 1353 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp14_ = self->priv->window;
#line 1353 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_application_add_window (_tmp13_, _tmp14_);
#line 1354 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp15_ = self->priv->builder;
#line 1354 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp16_ = gtk_builder_get_object (_tmp15_, "main_vbox");
#line 1354 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GTK_TYPE_VBOX, GtkVBox));
#line 1354 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->main_vbox);
#line 1354 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->main_vbox = _tmp17_;
#line 1355 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp18_ = self->priv->builder;
#line 1355 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp19_ = gtk_builder_get_object (_tmp18_, "page_move_left_menuitem");
#line 1355 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
#line 1355 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->page_move_left_menuitem);
#line 1355 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->page_move_left_menuitem = _tmp20_;
#line 1356 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp21_ = self->priv->builder;
#line 1356 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp22_ = gtk_builder_get_object (_tmp21_, "page_move_right_menuitem");
#line 1356 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
#line 1356 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->page_move_right_menuitem);
#line 1356 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->page_move_right_menuitem = _tmp23_;
#line 1357 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp24_ = self->priv->builder;
#line 1357 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp25_ = gtk_builder_get_object (_tmp24_, "page_delete_menuitem");
#line 1357 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
#line 1357 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->page_delete_menuitem);
#line 1357 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->page_delete_menuitem = _tmp26_;
#line 1358 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp27_ = self->priv->builder;
#line 1358 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp28_ = gtk_builder_get_object (_tmp27_, "crop_rotate_menuitem");
#line 1358 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
#line 1358 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->crop_rotate_menuitem);
#line 1358 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->crop_rotate_menuitem = _tmp29_;
#line 1359 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp30_ = self->priv->builder;
#line 1359 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp31_ = gtk_builder_get_object (_tmp30_, "save_menuitem");
#line 1359 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
#line 1359 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->save_menuitem);
#line 1359 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->save_menuitem = _tmp32_;
#line 1360 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp33_ = self->priv->builder;
#line 1360 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp34_ = gtk_builder_get_object (_tmp33_, "save_as_menuitem");
#line 1360 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
#line 1360 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->save_as_menuitem);
#line 1360 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->save_as_menuitem = _tmp35_;
#line 1361 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp36_ = self->priv->builder;
#line 1361 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp37_ = gtk_builder_get_object (_tmp36_, "copy_to_clipboard_menuitem");
#line 1361 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
#line 1361 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->copy_to_clipboard_menuitem);
#line 1361 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->copy_to_clipboard_menuitem = _tmp38_;
#line 1362 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp39_ = self->priv->builder;
#line 1362 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp40_ = gtk_builder_get_object (_tmp39_, "save_toolbutton");
#line 1362 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp41_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, GTK_TYPE_TOOL_BUTTON, GtkToolButton));
#line 1362 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->save_toolbutton);
#line 1362 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->save_toolbutton = _tmp41_;
#line 1363 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp42_ = self->priv->builder;
#line 1363 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp43_ = gtk_builder_get_object (_tmp42_, "stop_scan_menuitem");
#line 1363 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp44_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
#line 1363 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->stop_menuitem);
#line 1363 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->stop_menuitem = _tmp44_;
#line 1364 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp45_ = self->priv->builder;
#line 1364 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp46_ = gtk_builder_get_object (_tmp45_, "stop_toolbutton");
#line 1364 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp47_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, GTK_TYPE_TOOL_BUTTON, GtkToolButton));
#line 1364 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->stop_toolbutton);
#line 1364 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->stop_toolbutton = _tmp47_;
#line 1366 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp48_ = self->priv->builder;
#line 1366 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp49_ = gtk_builder_get_object (_tmp48_, "text_toolbutton_menuitem");
#line 1366 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp50_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
#line 1366 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->text_toolbar_menuitem);
#line 1366 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->text_toolbar_menuitem = _tmp50_;
#line 1367 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp51_ = self->priv->builder;
#line 1367 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp52_ = gtk_builder_get_object (_tmp51_, "text_menuitem");
#line 1367 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp53_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
#line 1367 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->text_menu_menuitem);
#line 1367 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->text_menu_menuitem = _tmp53_;
#line 1368 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp54_ = self->priv->builder;
#line 1368 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp55_ = gtk_builder_get_object (_tmp54_, "photo_toolbutton_menuitem");
#line 1368 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp56_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
#line 1368 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->photo_toolbar_menuitem);
#line 1368 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->photo_toolbar_menuitem = _tmp56_;
#line 1369 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp57_ = self->priv->builder;
#line 1369 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp58_ = gtk_builder_get_object (_tmp57_, "photo_menuitem");
#line 1369 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp59_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
#line 1369 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->photo_menu_menuitem);
#line 1369 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->photo_menu_menuitem = _tmp59_;
#line 1371 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp60_ = self->priv->builder;
#line 1371 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp61_ = gtk_builder_get_object (_tmp60_, "authorize_dialog");
#line 1371 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp62_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, GTK_TYPE_DIALOG, GtkDialog));
#line 1371 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->authorize_dialog);
#line 1371 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->authorize_dialog = _tmp62_;
#line 1372 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp63_ = self->priv->builder;
#line 1372 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp64_ = gtk_builder_get_object (_tmp63_, "authorize_label");
#line 1372 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp65_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, GTK_TYPE_LABEL, GtkLabel));
#line 1372 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->authorize_label);
#line 1372 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->authorize_label = _tmp65_;
#line 1373 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp66_ = self->priv->builder;
#line 1373 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp67_ = gtk_builder_get_object (_tmp66_, "username_entry");
#line 1373 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp68_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, GTK_TYPE_ENTRY, GtkEntry));
#line 1373 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->username_entry);
#line 1373 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->username_entry = _tmp68_;
#line 1374 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp69_ = self->priv->builder;
#line 1374 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp70_ = gtk_builder_get_object (_tmp69_, "password_entry");
#line 1374 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp71_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, GTK_TYPE_ENTRY, GtkEntry));
#line 1374 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->password_entry);
#line 1374 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->password_entry = _tmp71_;
#line 1376 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp72_ = self->priv->builder;
#line 1376 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp73_ = gtk_builder_get_object (_tmp72_, "preferences_dialog");
#line 1376 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp74_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, GTK_TYPE_DIALOG, GtkDialog));
#line 1376 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->preferences_dialog);
#line 1376 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->preferences_dialog = _tmp74_;
#line 1377 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp75_ = self->priv->builder;
#line 1377 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp76_ = gtk_builder_get_object (_tmp75_, "device_combo");
#line 1377 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp77_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, GTK_TYPE_COMBO_BOX, GtkComboBox));
#line 1377 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->device_combo);
#line 1377 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->device_combo = _tmp77_;
#line 1378 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp78_ = self->priv->device_combo;
#line 1378 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp79_ = gtk_combo_box_get_model (_tmp78_);
#line 1378 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp80_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, GTK_TYPE_LIST_STORE, GtkListStore));
#line 1378 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->device_model);
#line 1378 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->device_model = _tmp80_;
#line 1379 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp81_ = self->priv->builder;
#line 1379 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp82_ = gtk_builder_get_object (_tmp81_, "text_dpi_combo");
#line 1379 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp83_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp82_, GTK_TYPE_COMBO_BOX, GtkComboBox));
#line 1379 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->text_dpi_combo);
#line 1379 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->text_dpi_combo = _tmp83_;
#line 1380 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp84_ = self->priv->text_dpi_combo;
#line 1380 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp85_ = gtk_combo_box_get_model (_tmp84_);
#line 1380 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp86_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, GTK_TYPE_LIST_STORE, GtkListStore));
#line 1380 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->text_dpi_model);
#line 1380 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->text_dpi_model = _tmp86_;
#line 1381 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp87_ = self->priv->builder;
#line 1381 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp88_ = gtk_builder_get_object (_tmp87_, "photo_dpi_combo");
#line 1381 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp89_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, GTK_TYPE_COMBO_BOX, GtkComboBox));
#line 1381 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->photo_dpi_combo);
#line 1381 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->photo_dpi_combo = _tmp89_;
#line 1382 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp90_ = self->priv->photo_dpi_combo;
#line 1382 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp91_ = gtk_combo_box_get_model (_tmp90_);
#line 1382 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp92_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, GTK_TYPE_LIST_STORE, GtkListStore));
#line 1382 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->photo_dpi_model);
#line 1382 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->photo_dpi_model = _tmp92_;
#line 1383 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp93_ = self->priv->builder;
#line 1383 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp94_ = gtk_builder_get_object (_tmp93_, "page_side_combo");
#line 1383 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp95_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, GTK_TYPE_COMBO_BOX, GtkComboBox));
#line 1383 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->page_side_combo);
#line 1383 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->page_side_combo = _tmp95_;
#line 1384 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp96_ = self->priv->page_side_combo;
#line 1384 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp97_ = gtk_combo_box_get_model (_tmp96_);
#line 1384 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp98_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, GTK_TYPE_LIST_STORE, GtkListStore));
#line 1384 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->page_side_model);
#line 1384 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->page_side_model = _tmp98_;
#line 1385 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp99_ = self->priv->builder;
#line 1385 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp100_ = gtk_builder_get_object (_tmp99_, "paper_size_combo");
#line 1385 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp101_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, GTK_TYPE_COMBO_BOX, GtkComboBox));
#line 1385 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->paper_size_combo);
#line 1385 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->paper_size_combo = _tmp101_;
#line 1386 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp102_ = self->priv->paper_size_combo;
#line 1386 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp103_ = gtk_combo_box_get_model (_tmp102_);
#line 1386 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp104_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp103_, GTK_TYPE_LIST_STORE, GtkListStore));
#line 1386 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->paper_size_model);
#line 1386 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->paper_size_model = _tmp104_;
#line 1387 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp105_ = self->priv->builder;
#line 1387 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp106_ = gtk_builder_get_object (_tmp105_, "brightness_scale");
#line 1387 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp107_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp106_, GTK_TYPE_SCALE, GtkScale));
#line 1387 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->brightness_scale);
#line 1387 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->brightness_scale = _tmp107_;
#line 1388 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp108_ = self->priv->brightness_scale;
#line 1388 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp109_ = gtk_range_get_adjustment ((GtkRange*) _tmp108_);
#line 1388 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp110_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp109_, GTK_TYPE_ADJUSTMENT, GtkAdjustment));
#line 1388 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->brightness_adjustment);
#line 1388 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->brightness_adjustment = _tmp110_;
#line 1389 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp111_ = self->priv->builder;
#line 1389 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp112_ = gtk_builder_get_object (_tmp111_, "contrast_scale");
#line 1389 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp113_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp112_, GTK_TYPE_SCALE, GtkScale));
#line 1389 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->contrast_scale);
#line 1389 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->contrast_scale = _tmp113_;
#line 1390 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp114_ = self->priv->contrast_scale;
#line 1390 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp115_ = gtk_range_get_adjustment ((GtkRange*) _tmp114_);
#line 1390 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp116_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp115_, GTK_TYPE_ADJUSTMENT, GtkAdjustment));
#line 1390 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->contrast_adjustment);
#line 1390 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->contrast_adjustment = _tmp116_;
#line 1391 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp117_ = self->priv->builder;
#line 1391 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp118_ = gtk_builder_get_object (_tmp117_, "quality_scale");
#line 1391 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp119_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp118_, GTK_TYPE_SCALE, GtkScale));
#line 1391 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->quality_scale);
#line 1391 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->quality_scale = _tmp119_;
#line 1392 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp120_ = self->priv->quality_scale;
#line 1392 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp121_ = gtk_range_get_adjustment ((GtkRange*) _tmp120_);
#line 1392 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp122_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp121_, GTK_TYPE_ADJUSTMENT, GtkAdjustment));
#line 1392 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->quality_adjustment);
#line 1392 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->quality_adjustment = _tmp122_;
#line 1395 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp123_ = (GtkInfoBar*) gtk_info_bar_new ();
#line 1395 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_object_ref_sink (_tmp123_);
#line 1395 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar);
#line 1395 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->info_bar = _tmp123_;
#line 1396 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp124_ = self->priv->info_bar;
#line 1396 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_signal_connect (_tmp124_, "response", (GCallback) _user_interface_info_bar_response_cb_gtk_info_bar_response, self);
#line 1397 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp125_ = self->priv->main_vbox;
#line 1397 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp126_ = self->priv->info_bar;
#line 1397 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_box_pack_start ((GtkBox*) _tmp125_, (GtkWidget*) _tmp126_, FALSE, TRUE, (guint) 0);
#line 1398 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp127_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
#line 1398 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_object_ref_sink (_tmp127_);
#line 1398 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	hbox = _tmp127_;
#line 1399 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp128_ = self->priv->info_bar;
#line 1399 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp129_ = gtk_info_bar_get_content_area (_tmp128_);
#line 1399 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp130_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp129_, GTK_TYPE_CONTAINER, GtkContainer));
#line 1399 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	content_area = _tmp130_;
#line 1400 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp131_ = content_area;
#line 1400 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp132_ = hbox;
#line 1400 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_container_add (_tmp131_, (GtkWidget*) _tmp132_);
#line 1401 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp133_ = hbox;
#line 1401 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp133_);
#line 1403 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp134_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_DIALOG_WARNING, GTK_ICON_SIZE_DIALOG);
#line 1403 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_object_ref_sink (_tmp134_);
#line 1403 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_image);
#line 1403 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->info_bar_image = _tmp134_;
#line 1404 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp135_ = hbox;
#line 1404 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp136_ = self->priv->info_bar_image;
#line 1404 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_box_pack_start (_tmp135_, (GtkWidget*) _tmp136_, FALSE, TRUE, (guint) 0);
#line 1405 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp137_ = self->priv->info_bar_image;
#line 1405 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp137_);
#line 1407 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp138_ = (GtkLabel*) gtk_label_new (NULL);
#line 1407 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_object_ref_sink (_tmp138_);
#line 1407 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_label);
#line 1407 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->info_bar_label = _tmp138_;
#line 1408 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp139_ = self->priv->info_bar_label;
#line 1408 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_misc_set_alignment ((GtkMisc*) _tmp139_, 0.0f, 0.5f);
#line 1409 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp140_ = hbox;
#line 1409 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp141_ = self->priv->info_bar_label;
#line 1409 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_box_pack_start (_tmp140_, (GtkWidget*) _tmp141_, TRUE, TRUE, (guint) 0);
#line 1410 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp142_ = self->priv->info_bar_label;
#line 1410 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp142_);
#line 1412 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp143_ = self->priv->info_bar;
#line 1412 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp144_ = gtk_info_bar_add_button (_tmp143_, GTK_STOCK_CLOSE, (gint) GTK_RESPONSE_CLOSE);
#line 1412 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp145_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp144_, GTK_TYPE_BUTTON, GtkButton));
#line 1412 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_close_button);
#line 1412 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->info_bar_close_button = _tmp145_;
#line 1413 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp146_ = self->priv->info_bar;
#line 1413 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp147_ = _ ("Change _Scanner");
#line 1413 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp148_ = gtk_info_bar_add_button (_tmp146_, _tmp147_, 1);
#line 1413 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp149_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp148_, GTK_TYPE_BUTTON, GtkButton));
#line 1413 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_change_scanner_button);
#line 1413 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->info_bar_change_scanner_button = _tmp149_;
#line 1417 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp150_ = self->priv->paper_size_model;
#line 1417 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_list_store_append (_tmp150_, &_tmp151_);
#line 1417 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	iter = _tmp151_;
#line 1418 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp152_ = self->priv->paper_size_model;
#line 1418 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp153_ = iter;
#line 1418 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp154_ = _ ("Automatic");
#line 1418 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_list_store_set (_tmp152_, &_tmp153_, 0, 0, 1, 0, 2, _tmp154_, -1, -1);
#line 1421 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp155_ = self->priv->paper_size_model;
#line 1421 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_list_store_append (_tmp155_, &_tmp156_);
#line 1421 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	iter = _tmp156_;
#line 1422 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp157_ = self->priv->paper_size_model;
#line 1422 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp158_ = iter;
#line 1422 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_list_store_set (_tmp157_, &_tmp158_, 0, 1050, 1, 1480, 2, "A6", -1, -1);
#line 1423 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp159_ = self->priv->paper_size_model;
#line 1423 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_list_store_append (_tmp159_, &_tmp160_);
#line 1423 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	iter = _tmp160_;
#line 1424 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp161_ = self->priv->paper_size_model;
#line 1424 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp162_ = iter;
#line 1424 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_list_store_set (_tmp161_, &_tmp162_, 0, 1480, 1, 2100, 2, "A5", -1, -1);
#line 1425 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp163_ = self->priv->paper_size_model;
#line 1425 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_list_store_append (_tmp163_, &_tmp164_);
#line 1425 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	iter = _tmp164_;
#line 1426 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp165_ = self->priv->paper_size_model;
#line 1426 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp166_ = iter;
#line 1426 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_list_store_set (_tmp165_, &_tmp166_, 0, 2100, 1, 2970, 2, "A4", -1, -1);
#line 1427 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp167_ = self->priv->paper_size_model;
#line 1427 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_list_store_append (_tmp167_, &_tmp168_);
#line 1427 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	iter = _tmp168_;
#line 1428 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp169_ = self->priv->paper_size_model;
#line 1428 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp170_ = iter;
#line 1428 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_list_store_set (_tmp169_, &_tmp170_, 0, 2159, 1, 2794, 2, "Letter", -1, -1);
#line 1429 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp171_ = self->priv->paper_size_model;
#line 1429 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_list_store_append (_tmp171_, &_tmp172_);
#line 1429 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	iter = _tmp172_;
#line 1430 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp173_ = self->priv->paper_size_model;
#line 1430 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp174_ = iter;
#line 1430 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_list_store_set (_tmp173_, &_tmp174_, 0, 2159, 1, 3556, 2, "Legal", -1, -1);
#line 1431 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp175_ = self->priv->paper_size_model;
#line 1431 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_list_store_append (_tmp175_, &_tmp176_);
#line 1431 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	iter = _tmp176_;
#line 1432 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp177_ = self->priv->paper_size_model;
#line 1432 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp178_ = iter;
#line 1432 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_list_store_set (_tmp177_, &_tmp178_, 0, 1016, 1, 1524, 2, "4×6", -1, -1);
#line 1434 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp179_ = self->priv->settings;
#line 1434 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp180_ = g_settings_get_int (_tmp179_, "text-dpi");
#line 1434 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	dpi = _tmp180_;
#line 1435 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp181_ = dpi;
#line 1435 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp181_ <= 0) {
#line 1436 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		dpi = USER_INTERFACE_DEFAULT_TEXT_DPI;
#line 7363 "ui.c"
	}
#line 1437 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp182_ = self->priv->text_dpi_combo;
#line 1437 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp183_ = dpi;
#line 1437 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_set_dpi_combo (self, _tmp182_, USER_INTERFACE_DEFAULT_TEXT_DPI, _tmp183_);
#line 1438 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp184_ = self->priv->settings;
#line 1438 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp185_ = g_settings_get_int (_tmp184_, "photo-dpi");
#line 1438 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	dpi = _tmp185_;
#line 1439 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp186_ = dpi;
#line 1439 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp186_ <= 0) {
#line 1440 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		dpi = USER_INTERFACE_DEFAULT_PHOTO_DPI;
#line 7383 "ui.c"
	}
#line 1441 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp187_ = self->priv->photo_dpi_combo;
#line 1441 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp188_ = dpi;
#line 1441 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_set_dpi_combo (self, _tmp187_, USER_INTERFACE_DEFAULT_PHOTO_DPI, _tmp188_);
#line 1443 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp189_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 1443 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_object_ref_sink (_tmp189_);
#line 1443 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	renderer = _tmp189_;
#line 1444 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp190_ = self->priv->device_combo;
#line 1444 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp191_ = renderer;
#line 1444 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp190_, (GtkCellRenderer*) _tmp191_, TRUE);
#line 1445 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp192_ = self->priv->device_combo;
#line 1445 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp193_ = renderer;
#line 1445 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp192_, (GtkCellRenderer*) _tmp193_, "text", 1);
#line 1447 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp194_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 1447 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_object_ref_sink (_tmp194_);
#line 1447 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (renderer);
#line 1447 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	renderer = _tmp194_;
#line 1448 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp195_ = self->priv->page_side_combo;
#line 1448 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp196_ = renderer;
#line 1448 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp195_, (GtkCellRenderer*) _tmp196_, TRUE);
#line 1449 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp197_ = self->priv->page_side_combo;
#line 1449 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp198_ = renderer;
#line 1449 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp197_, (GtkCellRenderer*) _tmp198_, "text", 1);
#line 1450 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp199_ = self->priv->settings;
#line 1450 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp200_ = g_settings_get_enum (_tmp199_, "page-side");
#line 1450 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_set_page_side (self, (ScanType) _tmp200_);
#line 1452 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp201_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 1452 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_object_ref_sink (_tmp201_);
#line 1452 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (renderer);
#line 1452 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	renderer = _tmp201_;
#line 1453 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp202_ = self->priv->paper_size_combo;
#line 1453 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp203_ = renderer;
#line 1453 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp202_, (GtkCellRenderer*) _tmp203_, TRUE);
#line 1454 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp204_ = self->priv->paper_size_combo;
#line 1454 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp205_ = renderer;
#line 1454 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp204_, (GtkCellRenderer*) _tmp205_, "text", 2);
#line 1455 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp206_ = self->priv->settings;
#line 1455 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp207_ = g_settings_get_int (_tmp206_, "paper-width");
#line 1455 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	paper_width = _tmp207_;
#line 1456 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp208_ = self->priv->settings;
#line 1456 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp209_ = g_settings_get_int (_tmp208_, "paper-height");
#line 1456 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	paper_height = _tmp209_;
#line 1457 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp210_ = paper_width;
#line 1457 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp211_ = paper_height;
#line 1457 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_set_paper_size (self, _tmp210_, _tmp211_);
#line 1459 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp212_ = self->priv->brightness_adjustment;
#line 1459 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp213_ = gtk_adjustment_get_lower (_tmp212_);
#line 1459 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	lower = _tmp213_;
#line 1460 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp214_ = _ ("Darker");
#line 1460 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp215_ = g_strdup_printf ("<small>%s</small>", _tmp214_);
#line 1460 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	darker_label = _tmp215_;
#line 1461 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp216_ = self->priv->brightness_adjustment;
#line 1461 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp217_ = gtk_adjustment_get_upper (_tmp216_);
#line 1461 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	upper = _tmp217_;
#line 1462 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp218_ = _ ("Lighter");
#line 1462 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp219_ = g_strdup_printf ("<small>%s</small>", _tmp218_);
#line 1462 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	lighter_label = _tmp219_;
#line 1463 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp220_ = self->priv->brightness_scale;
#line 1463 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp221_ = lower;
#line 1463 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp222_ = darker_label;
#line 1463 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_scale_add_mark (_tmp220_, _tmp221_, GTK_POS_BOTTOM, _tmp222_);
#line 1464 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp223_ = self->priv->brightness_scale;
#line 1464 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_scale_add_mark (_tmp223_, (gdouble) 0, GTK_POS_BOTTOM, NULL);
#line 1465 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp224_ = self->priv->brightness_scale;
#line 1465 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp225_ = upper;
#line 1465 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp226_ = lighter_label;
#line 1465 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_scale_add_mark (_tmp224_, _tmp225_, GTK_POS_BOTTOM, _tmp226_);
#line 1466 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp227_ = self->priv->settings;
#line 1466 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp228_ = g_settings_get_int (_tmp227_, "brightness");
#line 1466 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_set_brightness (self, _tmp228_);
#line 1468 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp229_ = self->priv->contrast_adjustment;
#line 1468 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp230_ = gtk_adjustment_get_lower (_tmp229_);
#line 1468 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	lower = _tmp230_;
#line 1469 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp231_ = _ ("Less");
#line 1469 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp232_ = g_strdup_printf ("<small>%s</small>", _tmp231_);
#line 1469 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	less_label = _tmp232_;
#line 1470 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp233_ = self->priv->contrast_adjustment;
#line 1470 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp234_ = gtk_adjustment_get_upper (_tmp233_);
#line 1470 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	upper = _tmp234_;
#line 1471 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp235_ = _ ("More");
#line 1471 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp236_ = g_strdup_printf ("<small>%s</small>", _tmp235_);
#line 1471 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	more_label = _tmp236_;
#line 1472 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp237_ = self->priv->contrast_scale;
#line 1472 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp238_ = lower;
#line 1472 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp239_ = less_label;
#line 1472 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_scale_add_mark (_tmp237_, _tmp238_, GTK_POS_BOTTOM, _tmp239_);
#line 1473 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp240_ = self->priv->contrast_scale;
#line 1473 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_scale_add_mark (_tmp240_, (gdouble) 0, GTK_POS_BOTTOM, NULL);
#line 1474 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp241_ = self->priv->contrast_scale;
#line 1474 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp242_ = upper;
#line 1474 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp243_ = more_label;
#line 1474 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_scale_add_mark (_tmp241_, _tmp242_, GTK_POS_BOTTOM, _tmp243_);
#line 1475 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp244_ = self->priv->settings;
#line 1475 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp245_ = g_settings_get_int (_tmp244_, "contrast");
#line 1475 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_set_contrast (self, _tmp245_);
#line 1477 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp246_ = self->priv->quality_adjustment;
#line 1477 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp247_ = gtk_adjustment_get_lower (_tmp246_);
#line 1477 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	lower = _tmp247_;
#line 1478 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp248_ = _ ("Minimum");
#line 1478 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp249_ = g_strdup_printf ("<small>%s</small>", _tmp248_);
#line 1478 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	minimum_label = _tmp249_;
#line 1479 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp250_ = self->priv->quality_adjustment;
#line 1479 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp251_ = gtk_adjustment_get_upper (_tmp250_);
#line 1479 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	upper = _tmp251_;
#line 1480 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp252_ = _ ("Maximum");
#line 1480 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp253_ = g_strdup_printf ("<small>%s</small>", _tmp252_);
#line 1480 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	maximum_label = _tmp253_;
#line 1481 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp254_ = self->priv->quality_scale;
#line 1481 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp255_ = lower;
#line 1481 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp256_ = minimum_label;
#line 1481 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_scale_add_mark (_tmp254_, _tmp255_, GTK_POS_BOTTOM, _tmp256_);
#line 1482 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp257_ = self->priv->quality_scale;
#line 1482 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_scale_add_mark (_tmp257_, (gdouble) 75, GTK_POS_BOTTOM, NULL);
#line 1483 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp258_ = self->priv->quality_scale;
#line 1483 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp259_ = upper;
#line 1483 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp260_ = maximum_label;
#line 1483 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_scale_add_mark (_tmp258_, _tmp259_, GTK_POS_BOTTOM, _tmp260_);
#line 1484 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp261_ = self->priv->settings;
#line 1484 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp262_ = g_settings_get_int (_tmp261_, "jpeg-quality");
#line 1484 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_set_quality (self, _tmp262_);
#line 1486 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp263_ = self->priv->settings;
#line 1486 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp264_ = g_settings_get_string (_tmp263_, "selected-device");
#line 1486 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	device = _tmp264_;
#line 1487 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp265_ = device;
#line 1487 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp265_ != NULL) {
#line 7633 "ui.c"
		const gchar* _tmp266_;
		GtkTreeIter _tmp267_ = {0};
		gboolean _tmp268_ = FALSE;
#line 1489 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp266_ = device;
#line 1489 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp268_ = user_interface_find_scan_device (self, _tmp266_, &_tmp267_);
#line 1489 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		iter = _tmp267_;
#line 1489 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		if (_tmp268_) {
#line 7645 "ui.c"
			GtkComboBox* _tmp269_;
			GtkTreeIter _tmp270_;
#line 1490 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp269_ = self->priv->device_combo;
#line 1490 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			_tmp270_ = iter;
#line 1490 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			gtk_combo_box_set_active_iter (_tmp269_, &_tmp270_);
#line 7654 "ui.c"
		}
	}
#line 1493 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp271_ = self->priv->settings;
#line 1493 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp272_ = g_settings_get_string (_tmp271_, "document-type");
#line 1493 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	document_type = _tmp272_;
#line 1494 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp273_ = document_type;
#line 1494 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp273_ != NULL) {
#line 7667 "ui.c"
		const gchar* _tmp274_;
#line 1495 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp274_ = document_type;
#line 1495 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		user_interface_set_document_hint (self, _tmp274_);
#line 7673 "ui.c"
	}
#line 1497 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp275_ = self->priv->book;
#line 1497 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp276_ = book_view_new (_tmp275_);
#line 1497 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_object_ref_sink (_tmp276_);
#line 1497 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->book_view);
#line 1497 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->book_view = _tmp276_;
#line 1498 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp277_ = self->priv->book_view;
#line 1498 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp277_, (guint) 18);
#line 1499 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp278_ = self->priv->main_vbox;
#line 1499 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp279_ = self->priv->book_view;
#line 1499 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_box_pack_end ((GtkBox*) _tmp278_, (GtkWidget*) _tmp279_, TRUE, TRUE, (guint) 0);
#line 1500 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp280_ = self->priv->book_view;
#line 1500 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_signal_connect (_tmp280_, "page-selected", (GCallback) _user_interface_page_selected_cb_book_view_page_selected, self);
#line 1501 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp281_ = self->priv->book_view;
#line 1501 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_signal_connect (_tmp281_, "show-page", (GCallback) _user_interface_show_page_cb_book_view_show_page, self);
#line 1502 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp282_ = self->priv->book_view;
#line 1502 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_signal_connect (_tmp282_, "show-menu", (GCallback) _user_interface_show_page_menu_cb_book_view_show_menu, self);
#line 1503 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp283_ = self->priv->book_view;
#line 1503 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp283_);
#line 1506 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp284_ = self->priv->settings;
#line 1506 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp285_ = g_settings_get_enum (_tmp284_, "scan-direction");
#line 1506 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->default_page_scan_direction = (ScanDirection) _tmp285_;
#line 1507 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp286_ = self->priv->settings;
#line 1507 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp287_ = g_settings_get_int (_tmp286_, "page-width");
#line 1507 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->default_page_width = _tmp287_;
#line 1508 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp288_ = self->priv->default_page_width;
#line 1508 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp288_ <= 0) {
#line 1509 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		self->priv->default_page_width = 595;
#line 7729 "ui.c"
	}
#line 1510 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp289_ = self->priv->settings;
#line 1510 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp290_ = g_settings_get_int (_tmp289_, "page-height");
#line 1510 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->default_page_height = _tmp290_;
#line 1511 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp291_ = self->priv->default_page_height;
#line 1511 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp291_ <= 0) {
#line 1512 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		self->priv->default_page_height = 842;
#line 7743 "ui.c"
	}
#line 1513 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp292_ = self->priv->settings;
#line 1513 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp293_ = g_settings_get_int (_tmp292_, "page-dpi");
#line 1513 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->default_page_dpi = _tmp293_;
#line 1514 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp294_ = self->priv->default_page_dpi;
#line 1514 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp294_ <= 0) {
#line 1515 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		self->priv->default_page_dpi = 72;
#line 7757 "ui.c"
	}
#line 1518 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp295_ = self->priv->settings;
#line 1518 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp296_ = g_settings_get_int (_tmp295_, "window-width");
#line 1518 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->window_width = _tmp296_;
#line 1519 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp297_ = self->priv->window_width;
#line 1519 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp297_ <= 0) {
#line 1520 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		self->priv->window_width = 600;
#line 7771 "ui.c"
	}
#line 1521 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp298_ = self->priv->settings;
#line 1521 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp299_ = g_settings_get_int (_tmp298_, "window-height");
#line 1521 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->window_height = _tmp299_;
#line 1522 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp300_ = self->priv->window_height;
#line 1522 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp300_ <= 0) {
#line 1523 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		self->priv->window_height = 400;
#line 7785 "ui.c"
	}
#line 1524 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp301_ = self->priv->window_width;
#line 1524 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp302_ = self->priv->window_height;
#line 1524 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_debug ("ui.vala:1524: Restoring window to %dx%d pixels", _tmp301_, _tmp302_);
#line 1525 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp303_ = self->priv->window;
#line 1525 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp304_ = self->priv->window_width;
#line 1525 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp305_ = self->priv->window_height;
#line 1525 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_window_set_default_size (_tmp303_, _tmp304_, _tmp305_);
#line 1526 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp306_ = self->priv->settings;
#line 1526 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp307_ = g_settings_get_boolean (_tmp306_, "window-is-maximized");
#line 1526 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->window_is_maximized = _tmp307_;
#line 1527 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp308_ = self->priv->window_is_maximized;
#line 1527 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp308_) {
#line 7811 "ui.c"
		GtkWindow* _tmp309_;
#line 1529 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		g_debug ("ui.vala:1529: Restoring window to maximized");
#line 1530 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp309_ = self->priv->window;
#line 1530 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		gtk_window_maximize (_tmp309_);
#line 7819 "ui.c"
	}
#line 1533 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp310_ = self->priv->window;
#line 1533 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp311_ = _ ("Saving document...");
#line 1533 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp312_ = progress_bar_dialog_new (_tmp310_, _tmp311_);
#line 1533 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_object_ref_sink (_tmp312_);
#line 1533 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->progress_dialog);
#line 1533 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->progress_dialog = _tmp312_;
#line 1534 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp313_ = self->priv->book;
#line 1534 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_signal_connect (_tmp313_, "saving", (GCallback) _user_interface_book_saving_cb_book_saving, self);
#line 1329 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (document_type);
#line 1329 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (device);
#line 1329 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (maximum_label);
#line 1329 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (minimum_label);
#line 1329 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (more_label);
#line 1329 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (less_label);
#line 1329 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (lighter_label);
#line 1329 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (darker_label);
#line 1329 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (renderer);
#line 1329 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (content_area);
#line 1329 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (hbox);
#line 1329 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (app);
#line 7861 "ui.c"
}


static gboolean ___lambda3_ (UserInterface* self) {
	gboolean result = FALSE;
	ProgressBarDialog* _tmp0_;
#line 1548 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->progress_dialog;
#line 1548 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 1549 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	result = FALSE;
#line 1549 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return result;
#line 7876 "ui.c"
}


static gboolean ____lambda3__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda3_ (self);
#line 1547 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return result;
#line 7885 "ui.c"
}


static void user_interface_book_saving_cb (UserInterface* self, gint page_number) {
	Book* _tmp1_;
	guint _tmp2_ = 0U;
	gint total;
	gint _tmp3_;
	gint _tmp4_;
	gdouble fraction;
	gdouble _tmp5_;
	gboolean complete;
	gboolean _tmp6_;
	const gchar* _tmp7_ = NULL;
	gint _tmp8_;
	gint _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* message;
	ProgressBarDialog* _tmp11_;
	gdouble _tmp12_;
	ProgressBarDialog* _tmp13_;
#line 1537 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1540 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	while (TRUE) {
#line 7911 "ui.c"
		gboolean _tmp0_ = FALSE;
#line 1540 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp0_ = gtk_events_pending ();
#line 1540 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		if (!_tmp0_) {
#line 1540 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			break;
#line 7919 "ui.c"
		}
#line 1541 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		gtk_main_iteration ();
#line 7923 "ui.c"
	}
#line 1543 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = self->priv->book;
#line 1543 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = book_get_n_pages (_tmp1_);
#line 1543 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	total = (gint) _tmp2_;
#line 1544 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = page_number;
#line 1544 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp4_ = total;
#line 1544 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	fraction = (_tmp3_ + 1.0) / _tmp4_;
#line 1545 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp5_ = fraction;
#line 1545 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	complete = _tmp5_ == 1.0;
#line 1546 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp6_ = complete;
#line 1546 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_tmp6_) {
#line 1547 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ____lambda3__gsource_func, user_interface_ref (self), user_interface_unref);
#line 7947 "ui.c"
	}
#line 1551 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp7_ = _ ("Saving page %d out of %d");
#line 1551 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp8_ = page_number;
#line 1551 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp9_ = total;
#line 1551 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp10_ = g_strdup_printf (_tmp7_, _tmp8_ + 1, _tmp9_);
#line 1551 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	message = _tmp10_;
#line 1553 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp11_ = self->priv->progress_dialog;
#line 1553 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp12_ = fraction;
#line 1553 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	progress_bar_dialog_set_fraction (_tmp11_, _tmp12_);
#line 1554 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp13_ = self->priv->progress_dialog;
#line 1554 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	progress_bar_dialog_set_message (_tmp13_, message);
#line 1537 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (message);
#line 7971 "ui.c"
}


void user_interface_show_progress_dialog (UserInterface* self) {
	ProgressBarDialog* _tmp0_;
#line 1557 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1559 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->progress_dialog;
#line 1559 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp0_);
#line 7983 "ui.c"
}


void user_interface_hide_progress_dialog (UserInterface* self) {
	ProgressBarDialog* _tmp0_;
#line 1562 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1564 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->progress_dialog;
#line 1564 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 7995 "ui.c"
}


static gpointer _book_ref0 (gpointer self) {
#line 1569 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return self ? book_ref (self) : NULL;
#line 8002 "ui.c"
}


Book* user_interface_get_book (UserInterface* self) {
	Book* result = NULL;
	Book* _tmp0_;
	Book* _tmp1_;
#line 1567 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1569 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->book;
#line 1569 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = _book_ref0 (_tmp0_);
#line 1569 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	result = _tmp1_;
#line 1569 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return result;
#line 8020 "ui.c"
}


void user_interface_set_selected_page (UserInterface* self, Page* page) {
	BookView* _tmp0_;
	Page* _tmp1_;
#line 1572 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1572 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 1574 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 1574 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = page;
#line 1574 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	book_view_select_page (_tmp0_, _tmp1_);
#line 8037 "ui.c"
}


Page* user_interface_get_selected_page (UserInterface* self) {
	Page* result = NULL;
	BookView* _tmp0_;
	Page* _tmp1_ = NULL;
#line 1577 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1579 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 1579 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = book_view_get_selected (_tmp0_);
#line 1579 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	result = _tmp1_;
#line 1579 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return result;
#line 8055 "ui.c"
}


void user_interface_set_scanning (UserInterface* self, gboolean scanning) {
	gboolean _tmp0_;
	GtkMenuItem* _tmp1_;
	gboolean _tmp2_;
	GtkMenuItem* _tmp3_;
	gboolean _tmp4_;
	GtkToolButton* _tmp5_;
	gboolean _tmp6_;
#line 1582 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1584 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = scanning;
#line 1584 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->scanning = _tmp0_;
#line 1585 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = self->priv->page_delete_menuitem;
#line 1585 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = scanning;
#line 1585 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, !_tmp2_);
#line 1586 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = self->priv->stop_menuitem;
#line 1586 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp4_ = scanning;
#line 1586 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, _tmp4_);
#line 1587 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp5_ = self->priv->stop_toolbutton;
#line 1587 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp6_ = scanning;
#line 1587 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, _tmp6_);
#line 8091 "ui.c"
}


void user_interface_show_error (UserInterface* self, const gchar* error_title, const gchar* error_text, gboolean change_scanner_hint) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
#line 1590 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1590 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (error_title != NULL);
#line 1590 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (error_text != NULL);
#line 1592 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->have_error = TRUE;
#line 1593 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = error_title;
#line 1593 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 1593 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (self->priv->error_title);
#line 1593 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->error_title = _tmp1_;
#line 1594 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = error_text;
#line 1594 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 1594 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (self->priv->error_text);
#line 1594 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->error_text = _tmp3_;
#line 1595 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp4_ = change_scanner_hint;
#line 1595 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->error_change_scanner_hint = _tmp4_;
#line 1596 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_update_info_bar (self);
#line 8131 "ui.c"
}


void user_interface_start (UserInterface* self) {
	GtkWindow* _tmp0_;
#line 1599 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1601 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->window;
#line 1601 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp0_);
#line 8143 "ui.c"
}


static void g_cclosure_user_marshal_VOID__STRING_SCAN_OPTIONS (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_SCAN_OPTIONS) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_SCAN_OPTIONS callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (n_param_values == 3);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		data1 = closure->data;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		data2 = param_values->data[0].v_pointer;
#line 8162 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		data1 = param_values->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		data2 = closure->data;
#line 8168 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	callback = (GMarshalFunc_VOID__STRING_SCAN_OPTIONS) (marshal_data ? marshal_data : cc->callback);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	callback (data1, g_value_get_string (param_values + 1), value_get_scan_options (param_values + 2), data2);
#line 8174 "ui.c"
}


static void g_cclosure_user_marshal_VOID__STRING_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_INT) (gpointer data1, const char* arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (n_param_values == 3);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		data1 = closure->data;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		data2 = param_values->data[0].v_pointer;
#line 8193 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		data1 = param_values->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		data2 = closure->data;
#line 8199 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	callback = (GMarshalFunc_VOID__STRING_INT) (marshal_data ? marshal_data : cc->callback);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	callback (data1, g_value_get_string (param_values + 1), g_value_get_int (param_values + 2), data2);
#line 8205 "ui.c"
}


static void value_user_interface_init (GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	value->data[0].v_pointer = NULL;
#line 8212 "ui.c"
}


static void value_user_interface_free_value (GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		user_interface_unref (value->data[0].v_pointer);
#line 8221 "ui.c"
	}
}


static void value_user_interface_copy_value (const GValue* src_value, GValue* dest_value) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (src_value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		dest_value->data[0].v_pointer = user_interface_ref (src_value->data[0].v_pointer);
#line 8231 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		dest_value->data[0].v_pointer = NULL;
#line 8235 "ui.c"
	}
}


static gpointer value_user_interface_peek_pointer (const GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return value->data[0].v_pointer;
#line 8243 "ui.c"
}


static gchar* value_user_interface_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (collect_values[0].v_pointer) {
#line 8250 "ui.c"
		UserInterface* object;
		object = collect_values[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		if (object->parent_instance.g_class == NULL) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 8257 "ui.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 8261 "ui.c"
		}
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		value->data[0].v_pointer = user_interface_ref (object);
#line 8265 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		value->data[0].v_pointer = NULL;
#line 8269 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return NULL;
#line 8273 "ui.c"
}


static gchar* value_user_interface_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	UserInterface** object_p;
	object_p = collect_values[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (!object_p) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 8284 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (!value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		*object_p = NULL;
#line 8290 "ui.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		*object_p = value->data[0].v_pointer;
#line 8294 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		*object_p = user_interface_ref (value->data[0].v_pointer);
#line 8298 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return NULL;
#line 8302 "ui.c"
}


GParamSpec* param_spec_user_interface (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecUserInterface* spec;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_USER_INTERFACE), NULL);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return G_PARAM_SPEC (spec);
#line 8316 "ui.c"
}


gpointer value_get_user_interface (const GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_USER_INTERFACE), NULL);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return value->data[0].v_pointer;
#line 8325 "ui.c"
}


void value_set_user_interface (GValue* value, gpointer v_object) {
	UserInterface* old;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_USER_INTERFACE));
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	old = value->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (v_object) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_USER_INTERFACE));
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		value->data[0].v_pointer = v_object;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		user_interface_ref (value->data[0].v_pointer);
#line 8345 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		value->data[0].v_pointer = NULL;
#line 8349 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (old) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		user_interface_unref (old);
#line 8355 "ui.c"
	}
}


void value_take_user_interface (GValue* value, gpointer v_object) {
	UserInterface* old;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_USER_INTERFACE));
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	old = value->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (v_object) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_USER_INTERFACE));
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		value->data[0].v_pointer = v_object;
#line 8374 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		value->data[0].v_pointer = NULL;
#line 8378 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (old) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		user_interface_unref (old);
#line 8384 "ui.c"
	}
}


static void user_interface_class_init (UserInterfaceClass * klass) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	user_interface_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	USER_INTERFACE_CLASS (klass)->finalize = user_interface_finalize;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_type_class_add_private (klass, sizeof (UserInterfacePrivate));
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_signal_new ("start_scan", TYPE_USER_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_SCAN_OPTIONS, G_TYPE_NONE, 2, G_TYPE_STRING, TYPE_SCAN_OPTIONS);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_signal_new ("stop_scan", TYPE_USER_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_signal_new ("email", TYPE_USER_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_INT, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_INT);
#line 8402 "ui.c"
}


static void user_interface_instance_init (UserInterface * self) {
	gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv = USER_INTERFACE_GET_PRIVATE (self);
#line 78 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->book_uri = NULL;
#line 89 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = g_strdup ("photo");
#line 89 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->document_hint = _tmp0_;
#line 91 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = _ ("Scanned Document.pdf");
#line 91 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 91 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->default_file_name = _tmp2_;
#line 92 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->scanning = FALSE;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->ref_count = 1;
#line 8428 "ui.c"
}


static void user_interface_finalize (UserInterface* obj) {
	UserInterface * self;
	Book* _tmp0_;
	guint _tmp1_ = 0U;
	Book* _tmp2_;
	guint _tmp3_ = 0U;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USER_INTERFACE, UserInterface);
#line 128 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->book;
#line 128 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_signal_parse_name ("page-removed", TYPE_BOOK, &_tmp1_, NULL, FALSE);
#line 128 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _user_interface_page_removed_cb_book_page_removed, self);
#line 129 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = self->priv->book;
#line 129 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_signal_parse_name ("page-added", TYPE_BOOK, &_tmp3_, NULL, FALSE);
#line 129 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _user_interface_page_added_cb_book_page_added, self);
#line 17 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->settings);
#line 19 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->builder);
#line 21 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->window);
#line 22 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->main_vbox);
#line 23 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar);
#line 24 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_image);
#line 25 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_label);
#line 26 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_close_button);
#line 27 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_change_scanner_button);
#line 28 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->page_move_left_menuitem);
#line 29 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->page_move_right_menuitem);
#line 30 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->page_delete_menuitem);
#line 31 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->crop_rotate_menuitem);
#line 32 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->save_menuitem);
#line 33 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->save_as_menuitem);
#line 34 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->copy_to_clipboard_menuitem);
#line 35 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->save_toolbutton);
#line 36 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->stop_menuitem);
#line 37 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->stop_toolbutton);
#line 39 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->text_toolbar_menuitem);
#line 40 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->text_menu_menuitem);
#line 41 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->photo_toolbar_menuitem);
#line 42 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->photo_menu_menuitem);
#line 44 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->authorize_dialog);
#line 45 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->authorize_label);
#line 46 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->username_entry);
#line 47 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->password_entry);
#line 49 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->preferences_dialog);
#line 50 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->device_combo);
#line 51 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->text_dpi_combo);
#line 52 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->photo_dpi_combo);
#line 53 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->page_side_combo);
#line 54 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->paper_size_combo);
#line 55 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->brightness_scale);
#line 56 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->contrast_scale);
#line 57 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->quality_scale);
#line 58 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->device_model);
#line 59 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->text_dpi_model);
#line 60 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->photo_dpi_model);
#line 61 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->page_side_model);
#line 62 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->paper_size_model);
#line 63 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->brightness_adjustment);
#line 64 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->contrast_adjustment);
#line 65 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->quality_adjustment);
#line 69 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->save_dialog);
#line 70 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->progress_dialog);
#line 73 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (self->priv->error_title);
#line 74 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (self->priv->error_text);
#line 77 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_book_unref0 (self->priv->book);
#line 78 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (self->priv->book_uri);
#line 80 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_autosave_manager_unref0 (self->priv->autosave_manager);
#line 82 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->book_view);
#line 89 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (self->priv->document_hint);
#line 91 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (self->priv->default_file_name);
#line 8560 "ui.c"
}


GType user_interface_get_type (void) {
	static volatile gsize user_interface_type_id__volatile = 0;
	if (g_once_init_enter (&user_interface_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_user_interface_init, value_user_interface_free_value, value_user_interface_copy_value, value_user_interface_peek_pointer, "p", value_user_interface_collect_value, "p", value_user_interface_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UserInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) user_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UserInterface), 0, (GInstanceInitFunc) user_interface_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType user_interface_type_id;
		user_interface_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UserInterface", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&user_interface_type_id__volatile, user_interface_type_id);
	}
	return user_interface_type_id__volatile;
}


gpointer user_interface_ref (gpointer instance) {
	UserInterface* self;
	self = instance;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_atomic_int_inc (&self->ref_count);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return instance;
#line 8585 "ui.c"
}


void user_interface_unref (gpointer instance) {
	UserInterface* self;
	self = instance;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		USER_INTERFACE_GET_CLASS (self)->finalize (self);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 8598 "ui.c"
	}
}


ProgressBarDialog* progress_bar_dialog_construct (GType object_type, GtkWindow* parent, const gchar* title) {
	ProgressBarDialog * self = NULL;
	GtkProgressBar* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* hbox;
	GtkBox* _tmp2_;
	GtkBox* vbox;
	GtkProgressBar* _tmp3_;
	GtkProgressBar* _tmp4_;
	GtkProgressBar* _tmp5_;
	GtkProgressBar* _tmp6_;
	const gchar* _tmp7_;
	GtkWindow* _tmp8_;
	GtkProgressBar* _tmp9_;
#line 1609 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 1609 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 1609 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self = (ProgressBarDialog*) g_object_new (object_type, NULL);
#line 1611 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = (GtkProgressBar*) gtk_progress_bar_new ();
#line 1611 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_object_ref_sink (_tmp0_);
#line 1611 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->bar);
#line 1611 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv->bar = _tmp0_;
#line 1612 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 5);
#line 1612 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_object_ref_sink (_tmp1_);
#line 1612 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	hbox = _tmp1_;
#line 1613 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 5);
#line 1613 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_object_ref_sink (_tmp2_);
#line 1613 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	vbox = _tmp2_;
#line 1614 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_set_hexpand ((GtkWidget*) hbox, TRUE);
#line 1616 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp3_ = self->priv->bar;
#line 1616 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_progress_bar_set_text (_tmp3_, "");
#line 1617 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp4_ = self->priv->bar;
#line 1617 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_progress_bar_set_show_text (_tmp4_, TRUE);
#line 1618 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp5_ = self->priv->bar;
#line 1618 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp5_, 225, 25);
#line 1619 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_set_size_request ((GtkWidget*) self, 250, 50);
#line 1621 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp6_ = self->priv->bar;
#line 1621 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_box_pack_start (vbox, (GtkWidget*) _tmp6_, TRUE, FALSE, (guint) 0);
#line 1622 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_box_pack_start (hbox, (GtkWidget*) vbox, TRUE, FALSE, (guint) 0);
#line 1623 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) hbox);
#line 1624 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp7_ = title;
#line 1624 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_window_set_title ((GtkWindow*) self, _tmp7_);
#line 1626 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp8_ = parent;
#line 1626 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_window_set_transient_for ((GtkWindow*) self, _tmp8_);
#line 1627 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_window_set_position ((GtkWindow*) self, GTK_WIN_POS_CENTER_ON_PARENT);
#line 1628 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_window_set_modal ((GtkWindow*) self, TRUE);
#line 1629 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
#line 1631 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_show ((GtkWidget*) hbox);
#line 1632 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_show ((GtkWidget*) vbox);
#line 1633 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp9_ = self->priv->bar;
#line 1633 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp9_);
#line 1609 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (vbox);
#line 1609 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (hbox);
#line 1609 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return self;
#line 8695 "ui.c"
}


ProgressBarDialog* progress_bar_dialog_new (GtkWindow* parent, const gchar* title) {
#line 1609 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return progress_bar_dialog_construct (TYPE_PROGRESS_BAR_DIALOG, parent, title);
#line 8702 "ui.c"
}


void progress_bar_dialog_set_fraction (ProgressBarDialog* self, gdouble percent) {
	GtkProgressBar* _tmp0_;
	gdouble _tmp1_;
#line 1636 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1638 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->bar;
#line 1638 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = percent;
#line 1638 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_progress_bar_set_fraction (_tmp0_, _tmp1_);
#line 8717 "ui.c"
}


void progress_bar_dialog_set_message (ProgressBarDialog* self, const gchar* message) {
	GtkProgressBar* _tmp0_;
	const gchar* _tmp1_;
#line 1641 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1641 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_if_fail (message != NULL);
#line 1643 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = self->priv->bar;
#line 1643 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = message;
#line 1643 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	gtk_progress_bar_set_text (_tmp0_, _tmp1_);
#line 8734 "ui.c"
}


static void progress_bar_dialog_class_init (ProgressBarDialogClass * klass) {
#line 1605 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	progress_bar_dialog_parent_class = g_type_class_peek_parent (klass);
#line 1605 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_type_class_add_private (klass, sizeof (ProgressBarDialogPrivate));
#line 1605 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	G_OBJECT_CLASS (klass)->finalize = progress_bar_dialog_finalize;
#line 8745 "ui.c"
}


static void progress_bar_dialog_instance_init (ProgressBarDialog * self) {
#line 1605 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self->priv = PROGRESS_BAR_DIALOG_GET_PRIVATE (self);
#line 8752 "ui.c"
}


static void progress_bar_dialog_finalize (GObject* obj) {
	ProgressBarDialog * self;
#line 1605 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROGRESS_BAR_DIALOG, ProgressBarDialog);
#line 1607 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_object_unref0 (self->priv->bar);
#line 1605 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	G_OBJECT_CLASS (progress_bar_dialog_parent_class)->finalize (obj);
#line 8764 "ui.c"
}


GType progress_bar_dialog_get_type (void) {
	static volatile gsize progress_bar_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&progress_bar_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ProgressBarDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) progress_bar_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ProgressBarDialog), 0, (GInstanceInitFunc) progress_bar_dialog_instance_init, NULL };
		GType progress_bar_dialog_type_id;
		progress_bar_dialog_type_id = g_type_register_static (GTK_TYPE_WINDOW, "ProgressBarDialog", &g_define_type_info, 0);
		g_once_init_leave (&progress_bar_dialog_type_id__volatile, progress_bar_dialog_type_id);
	}
	return progress_bar_dialog_type_id__volatile;
}


gchar* get_temporary_filename (const gchar* prefix, const gchar* extension) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* filename;
	gchar* path = NULL;
	GError * _inner_error_ = NULL;
#line 1648 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (prefix != NULL, NULL);
#line 1648 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	g_return_val_if_fail (extension != NULL, NULL);
#line 1653 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp0_ = prefix;
#line 1653 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp1_ = extension;
#line 1653 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_tmp2_ = g_strdup_printf ("%sXXXXXX.%s", _tmp0_, _tmp1_);
#line 1653 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	filename = _tmp2_;
#line 8800 "ui.c"
	{
		const gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint fd;
		gint _tmp6_;
#line 1657 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp3_ = filename;
#line 1657 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp5_ = g_file_open_tmp (_tmp3_, &_tmp4_, &_inner_error_);
#line 1657 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (path);
#line 1657 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		path = _tmp4_;
#line 1657 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		fd = _tmp5_;
#line 1657 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 8819 "ui.c"
			goto __catch22_g_error;
		}
#line 1658 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp6_ = fd;
#line 1658 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		close (_tmp6_);
#line 8826 "ui.c"
	}
	goto __finally22;
	__catch22_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
#line 1655 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		e = _inner_error_;
#line 1655 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_inner_error_ = NULL;
#line 1662 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp7_ = e;
#line 1662 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_tmp8_ = _tmp7_->message;
#line 1662 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		g_warning ("ui.vala:1662: Error saving email attachment: %s", _tmp8_);
#line 1663 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		result = NULL;
#line 1663 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_error_free0 (e);
#line 1663 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (path);
#line 1663 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (filename);
#line 1663 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		return result;
#line 8854 "ui.c"
	}
	__finally22:
#line 1655 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 1655 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (path);
#line 1655 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		_g_free0 (filename);
#line 1655 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1655 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1655 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
		return NULL;
#line 8869 "ui.c"
	}
#line 1666 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	result = path;
#line 1666 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	_g_free0 (filename);
#line 1666 "/home/bob/bzr/simple-scan/3.10/src/ui.vala"
	return result;
#line 8877 "ui.c"
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



