/* StraightenTool.c generated by valac 0.34.7, the Vala compiler
 * generated from StraightenTool.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>


#define EDITING_TOOLS_TYPE_EDITING_TOOL (editing_tools_editing_tool_get_type ())
#define EDITING_TOOLS_EDITING_TOOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool))
#define EDITING_TOOLS_EDITING_TOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingToolClass))
#define EDITING_TOOLS_IS_EDITING_TOOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDITING_TOOLS_TYPE_EDITING_TOOL))
#define EDITING_TOOLS_IS_EDITING_TOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDITING_TOOLS_TYPE_EDITING_TOOL))
#define EDITING_TOOLS_EDITING_TOOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingToolClass))

typedef struct _EditingToolsEditingTool EditingToolsEditingTool;
typedef struct _EditingToolsEditingToolClass EditingToolsEditingToolClass;
typedef struct _EditingToolsEditingToolPrivate EditingToolsEditingToolPrivate;

#define EDITING_TOOLS_TYPE_PHOTO_CANVAS (editing_tools_photo_canvas_get_type ())
#define EDITING_TOOLS_PHOTO_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDITING_TOOLS_TYPE_PHOTO_CANVAS, EditingToolsPhotoCanvas))
#define EDITING_TOOLS_PHOTO_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDITING_TOOLS_TYPE_PHOTO_CANVAS, EditingToolsPhotoCanvasClass))
#define EDITING_TOOLS_IS_PHOTO_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDITING_TOOLS_TYPE_PHOTO_CANVAS))
#define EDITING_TOOLS_IS_PHOTO_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDITING_TOOLS_TYPE_PHOTO_CANVAS))
#define EDITING_TOOLS_PHOTO_CANVAS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDITING_TOOLS_TYPE_PHOTO_CANVAS, EditingToolsPhotoCanvasClass))

typedef struct _EditingToolsPhotoCanvas EditingToolsPhotoCanvas;
typedef struct _EditingToolsPhotoCanvasClass EditingToolsPhotoCanvasClass;

#define EDITING_TOOLS_TYPE_EDITING_TOOL_WINDOW (editing_tools_editing_tool_window_get_type ())
#define EDITING_TOOLS_EDITING_TOOL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDITING_TOOLS_TYPE_EDITING_TOOL_WINDOW, EditingToolsEditingToolWindow))
#define EDITING_TOOLS_EDITING_TOOL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDITING_TOOLS_TYPE_EDITING_TOOL_WINDOW, EditingToolsEditingToolWindowClass))
#define EDITING_TOOLS_IS_EDITING_TOOL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDITING_TOOLS_TYPE_EDITING_TOOL_WINDOW))
#define EDITING_TOOLS_IS_EDITING_TOOL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDITING_TOOLS_TYPE_EDITING_TOOL_WINDOW))
#define EDITING_TOOLS_EDITING_TOOL_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDITING_TOOLS_TYPE_EDITING_TOOL_WINDOW, EditingToolsEditingToolWindowClass))

typedef struct _EditingToolsEditingToolWindow EditingToolsEditingToolWindow;
typedef struct _EditingToolsEditingToolWindowClass EditingToolsEditingToolWindowClass;

#define TYPE_SCALING (scaling_get_type ())

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
typedef struct _Scaling Scaling;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define EDITING_TOOLS_TYPE_STRAIGHTEN_TOOL (editing_tools_straighten_tool_get_type ())
#define EDITING_TOOLS_STRAIGHTEN_TOOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDITING_TOOLS_TYPE_STRAIGHTEN_TOOL, EditingToolsStraightenTool))
#define EDITING_TOOLS_STRAIGHTEN_TOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDITING_TOOLS_TYPE_STRAIGHTEN_TOOL, EditingToolsStraightenToolClass))
#define EDITING_TOOLS_IS_STRAIGHTEN_TOOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDITING_TOOLS_TYPE_STRAIGHTEN_TOOL))
#define EDITING_TOOLS_IS_STRAIGHTEN_TOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDITING_TOOLS_TYPE_STRAIGHTEN_TOOL))
#define EDITING_TOOLS_STRAIGHTEN_TOOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDITING_TOOLS_TYPE_STRAIGHTEN_TOOL, EditingToolsStraightenToolClass))

typedef struct _EditingToolsStraightenTool EditingToolsStraightenTool;
typedef struct _EditingToolsStraightenToolClass EditingToolsStraightenToolClass;
typedef struct _EditingToolsStraightenToolPrivate EditingToolsStraightenToolPrivate;

#define EDITING_TOOLS_STRAIGHTEN_TOOL_TYPE_STRAIGHTEN_TOOL_WINDOW (editing_tools_straighten_tool_straighten_tool_window_get_type ())
#define EDITING_TOOLS_STRAIGHTEN_TOOL_STRAIGHTEN_TOOL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDITING_TOOLS_STRAIGHTEN_TOOL_TYPE_STRAIGHTEN_TOOL_WINDOW, EditingToolsStraightenToolStraightenToolWindow))
#define EDITING_TOOLS_STRAIGHTEN_TOOL_STRAIGHTEN_TOOL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDITING_TOOLS_STRAIGHTEN_TOOL_TYPE_STRAIGHTEN_TOOL_WINDOW, EditingToolsStraightenToolStraightenToolWindowClass))
#define EDITING_TOOLS_STRAIGHTEN_TOOL_IS_STRAIGHTEN_TOOL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDITING_TOOLS_STRAIGHTEN_TOOL_TYPE_STRAIGHTEN_TOOL_WINDOW))
#define EDITING_TOOLS_STRAIGHTEN_TOOL_IS_STRAIGHTEN_TOOL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDITING_TOOLS_STRAIGHTEN_TOOL_TYPE_STRAIGHTEN_TOOL_WINDOW))
#define EDITING_TOOLS_STRAIGHTEN_TOOL_STRAIGHTEN_TOOL_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDITING_TOOLS_STRAIGHTEN_TOOL_TYPE_STRAIGHTEN_TOOL_WINDOW, EditingToolsStraightenToolStraightenToolWindowClass))

typedef struct _EditingToolsStraightenToolStraightenToolWindow EditingToolsStraightenToolStraightenToolWindow;
typedef struct _EditingToolsStraightenToolStraightenToolWindowClass EditingToolsStraightenToolStraightenToolWindowClass;

#define TYPE_ONE_SHOT_SCHEDULER (one_shot_scheduler_get_type ())
#define ONE_SHOT_SCHEDULER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ONE_SHOT_SCHEDULER, OneShotScheduler))
#define ONE_SHOT_SCHEDULER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ONE_SHOT_SCHEDULER, OneShotSchedulerClass))
#define IS_ONE_SHOT_SCHEDULER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ONE_SHOT_SCHEDULER))
#define IS_ONE_SHOT_SCHEDULER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ONE_SHOT_SCHEDULER))
#define ONE_SHOT_SCHEDULER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ONE_SHOT_SCHEDULER, OneShotSchedulerClass))

typedef struct _OneShotScheduler OneShotScheduler;
typedef struct _OneShotSchedulerClass OneShotSchedulerClass;

#define EDITING_TOOLS_STRAIGHTEN_TOOL_TYPE_STRAIGHTEN_GUIDE (editing_tools_straighten_tool_straighten_guide_get_type ())
#define EDITING_TOOLS_STRAIGHTEN_TOOL_STRAIGHTEN_GUIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDITING_TOOLS_STRAIGHTEN_TOOL_TYPE_STRAIGHTEN_GUIDE, EditingToolsStraightenToolStraightenGuide))
#define EDITING_TOOLS_STRAIGHTEN_TOOL_STRAIGHTEN_GUIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDITING_TOOLS_STRAIGHTEN_TOOL_TYPE_STRAIGHTEN_GUIDE, EditingToolsStraightenToolStraightenGuideClass))
#define EDITING_TOOLS_STRAIGHTEN_TOOL_IS_STRAIGHTEN_GUIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDITING_TOOLS_STRAIGHTEN_TOOL_TYPE_STRAIGHTEN_GUIDE))
#define EDITING_TOOLS_STRAIGHTEN_TOOL_IS_STRAIGHTEN_GUIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDITING_TOOLS_STRAIGHTEN_TOOL_TYPE_STRAIGHTEN_GUIDE))
#define EDITING_TOOLS_STRAIGHTEN_TOOL_STRAIGHTEN_GUIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDITING_TOOLS_STRAIGHTEN_TOOL_TYPE_STRAIGHTEN_GUIDE, EditingToolsStraightenToolStraightenGuideClass))

typedef struct _EditingToolsStraightenToolStraightenGuide EditingToolsStraightenToolStraightenGuide;
typedef struct _EditingToolsStraightenToolStraightenGuideClass EditingToolsStraightenToolStraightenGuideClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _one_shot_scheduler_unref0(var) ((var == NULL) ? NULL : (var = (one_shot_scheduler_unref (var), NULL)))
#define _editing_tools_straighten_tool_straighten_guide_unref0(var) ((var == NULL) ? NULL : (var = (editing_tools_straighten_tool_straighten_guide_unref (var), NULL)))
typedef struct _EditingToolsEditingToolWindowPrivate EditingToolsEditingToolWindowPrivate;
typedef struct _EditingToolsStraightenToolStraightenToolWindowPrivate EditingToolsStraightenToolStraightenToolWindowPrivate;

#define TYPE_COMMAND (command_get_type ())
#define COMMAND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMMAND, Command))
#define COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMMAND, CommandClass))
#define IS_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMMAND))
#define IS_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMMAND))
#define COMMAND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMMAND, CommandClass))

typedef struct _Command Command;
typedef struct _CommandClass CommandClass;

#define TYPE_PAGE_COMMAND (page_command_get_type ())
#define PAGE_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_COMMAND, PageCommand))
#define PAGE_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_COMMAND, PageCommandClass))
#define IS_PAGE_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_COMMAND))
#define IS_PAGE_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_COMMAND))
#define PAGE_COMMAND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_COMMAND, PageCommandClass))

typedef struct _PageCommand PageCommand;
typedef struct _PageCommandClass PageCommandClass;

#define TYPE_SINGLE_DATA_SOURCE_COMMAND (single_data_source_command_get_type ())
#define SINGLE_DATA_SOURCE_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SINGLE_DATA_SOURCE_COMMAND, SingleDataSourceCommand))
#define SINGLE_DATA_SOURCE_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SINGLE_DATA_SOURCE_COMMAND, SingleDataSourceCommandClass))
#define IS_SINGLE_DATA_SOURCE_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SINGLE_DATA_SOURCE_COMMAND))
#define IS_SINGLE_DATA_SOURCE_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SINGLE_DATA_SOURCE_COMMAND))
#define SINGLE_DATA_SOURCE_COMMAND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SINGLE_DATA_SOURCE_COMMAND, SingleDataSourceCommandClass))

typedef struct _SingleDataSourceCommand SingleDataSourceCommand;
typedef struct _SingleDataSourceCommandClass SingleDataSourceCommandClass;

#define TYPE_GENERIC_PHOTO_TRANSFORMATION_COMMAND (generic_photo_transformation_command_get_type ())
#define GENERIC_PHOTO_TRANSFORMATION_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GENERIC_PHOTO_TRANSFORMATION_COMMAND, GenericPhotoTransformationCommand))
#define GENERIC_PHOTO_TRANSFORMATION_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GENERIC_PHOTO_TRANSFORMATION_COMMAND, GenericPhotoTransformationCommandClass))
#define IS_GENERIC_PHOTO_TRANSFORMATION_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GENERIC_PHOTO_TRANSFORMATION_COMMAND))
#define IS_GENERIC_PHOTO_TRANSFORMATION_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GENERIC_PHOTO_TRANSFORMATION_COMMAND))
#define GENERIC_PHOTO_TRANSFORMATION_COMMAND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GENERIC_PHOTO_TRANSFORMATION_COMMAND, GenericPhotoTransformationCommandClass))

typedef struct _GenericPhotoTransformationCommand GenericPhotoTransformationCommand;
typedef struct _GenericPhotoTransformationCommandClass GenericPhotoTransformationCommandClass;

#define TYPE_STRAIGHTEN_COMMAND (straighten_command_get_type ())
#define STRAIGHTEN_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STRAIGHTEN_COMMAND, StraightenCommand))
#define STRAIGHTEN_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STRAIGHTEN_COMMAND, StraightenCommandClass))
#define IS_STRAIGHTEN_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STRAIGHTEN_COMMAND))
#define IS_STRAIGHTEN_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STRAIGHTEN_COMMAND))
#define STRAIGHTEN_COMMAND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STRAIGHTEN_COMMAND, StraightenCommandClass))

typedef struct _StraightenCommand StraightenCommand;
typedef struct _StraightenCommandClass StraightenCommandClass;

#define TYPE_BOX (box_get_type ())
typedef struct _Box Box;
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))

#define PHOTO_TYPE_EXCEPTION (photo_exception_get_type ())

#define TYPE_BACKING_FETCH_MODE (backing_fetch_mode_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _editing_tools_photo_canvas_unref0(var) ((var == NULL) ? NULL : (var = (editing_tools_photo_canvas_unref (var), NULL)))
typedef struct _EditingToolsStraightenToolStraightenGuidePrivate EditingToolsStraightenToolStraightenGuidePrivate;
typedef struct _EditingToolsStraightenToolParamSpecStraightenGuide EditingToolsStraightenToolParamSpecStraightenGuide;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

struct _Dimensions {
	gint width;
	gint height;
};

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

struct _EditingToolsEditingTool {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EditingToolsEditingToolPrivate * priv;
	EditingToolsPhotoCanvas* canvas;
	cairo_surface_t* surface;
	gchar* name;
};

struct _EditingToolsEditingToolClass {
	GTypeClass parent_class;
	void (*finalize) (EditingToolsEditingTool *self);
	void (*activate) (EditingToolsEditingTool* self, EditingToolsPhotoCanvas* canvas);
	void (*deactivate) (EditingToolsEditingTool* self);
	EditingToolsEditingToolWindow* (*get_tool_window) (EditingToolsEditingTool* self);
	GdkPixbuf* (*get_display_pixbuf) (EditingToolsEditingTool* self, Scaling* scaling, Photo* photo, Dimensions* max_dim, GError** error);
	void (*on_left_click) (EditingToolsEditingTool* self, gint x, gint y);
	void (*on_left_released) (EditingToolsEditingTool* self, gint x, gint y);
	void (*on_motion) (EditingToolsEditingTool* self, gint x, gint y, GdkModifierType mask);
	gboolean (*on_leave_notify_event) (EditingToolsEditingTool* self);
	gboolean (*on_keypress) (EditingToolsEditingTool* self, GdkEventKey* event);
	void (*paint) (EditingToolsEditingTool* self, cairo_t* ctx);
};

struct _EditingToolsStraightenTool {
	EditingToolsEditingTool parent_instance;
	EditingToolsStraightenToolPrivate * priv;
};

struct _EditingToolsStraightenToolClass {
	EditingToolsEditingToolClass parent_class;
};

struct _EditingToolsStraightenToolPrivate {
	EditingToolsStraightenToolStraightenToolWindow* window;
	cairo_surface_t* photo_surf;
	Dimensions image_dims;
	cairo_surface_t* rotate_surf;
	cairo_t* rotate_ctx;
	Dimensions last_viewport;
	gint view_width;
	gint view_height;
	gdouble photo_angle;
	gboolean use_high_qual;
	OneShotScheduler* slider_sched;
	GdkPoint crop_center;
	gint crop_width;
	gint crop_height;
	EditingToolsStraightenToolStraightenGuide* guide;
	GdkPoint rotated_center;
	gdouble rotate_scale;
	gdouble preview_scale;
};

struct _EditingToolsEditingToolWindow {
	GtkWindow parent_instance;
	EditingToolsEditingToolWindowPrivate * priv;
};

struct _EditingToolsEditingToolWindowClass {
	GtkWindowClass parent_class;
};

struct _EditingToolsStraightenToolStraightenToolWindow {
	EditingToolsEditingToolWindow parent_instance;
	EditingToolsStraightenToolStraightenToolWindowPrivate * priv;
	GtkScale* angle_slider;
	GtkLabel* angle_label;
	GtkLabel* description_label;
	GtkButton* ok_button;
	GtkButton* cancel_button;
	GtkButton* reset_button;
};

struct _EditingToolsStraightenToolStraightenToolWindowClass {
	EditingToolsEditingToolWindowClass parent_class;
};

struct _Box {
	gint left;
	gint top;
	gint right;
	gint bottom;
};

typedef enum  {
	PHOTO_EXCEPTION_NONE = 0,
	PHOTO_EXCEPTION_ORIENTATION = 1 << 0,
	PHOTO_EXCEPTION_CROP = 1 << 1,
	PHOTO_EXCEPTION_REDEYE = 1 << 2,
	PHOTO_EXCEPTION_ADJUST = 1 << 3,
	PHOTO_EXCEPTION_STRAIGHTEN = 1 << 4,
	PHOTO_EXCEPTION_ALL = 0xFFFFFFFFLL
} PhotoException;

typedef enum  {
	BACKING_FETCH_MODE_SOURCE,
	BACKING_FETCH_MODE_BASELINE,
	BACKING_FETCH_MODE_MASTER,
	BACKING_FETCH_MODE_UNMODIFIED
} BackingFetchMode;

typedef void (*OneShotCallback) (void* user_data);
struct _EditingToolsStraightenToolStraightenGuide {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EditingToolsStraightenToolStraightenGuidePrivate * priv;
};

struct _EditingToolsStraightenToolStraightenGuideClass {
	GTypeClass parent_class;
	void (*finalize) (EditingToolsStraightenToolStraightenGuide *self);
};

struct _EditingToolsStraightenToolStraightenGuidePrivate {
	gboolean is_active;
	gint x[2];
	gint y[2];
	gdouble angle0;
};

struct _EditingToolsStraightenToolParamSpecStraightenGuide {
	GParamSpec parent_instance;
};


static gpointer editing_tools_straighten_tool_parent_class = NULL;
static gpointer editing_tools_straighten_tool_straighten_guide_parent_class = NULL;
static gpointer editing_tools_straighten_tool_straighten_tool_window_parent_class = NULL;

gpointer editing_tools_editing_tool_ref (gpointer instance);
void editing_tools_editing_tool_unref (gpointer instance);
GParamSpec* editing_tools_param_spec_editing_tool (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void editing_tools_value_set_editing_tool (GValue* value, gpointer v_object);
void editing_tools_value_take_editing_tool (GValue* value, gpointer v_object);
gpointer editing_tools_value_get_editing_tool (const GValue* value);
GType editing_tools_editing_tool_get_type (void) G_GNUC_CONST;
gpointer editing_tools_photo_canvas_ref (gpointer instance);
void editing_tools_photo_canvas_unref (gpointer instance);
GParamSpec* editing_tools_param_spec_photo_canvas (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void editing_tools_value_set_photo_canvas (GValue* value, gpointer v_object);
void editing_tools_value_take_photo_canvas (GValue* value, gpointer v_object);
gpointer editing_tools_value_get_photo_canvas (const GValue* value);
GType editing_tools_photo_canvas_get_type (void) G_GNUC_CONST;
GType editing_tools_editing_tool_window_get_type (void) G_GNUC_CONST;
GType scaling_get_type (void) G_GNUC_CONST;
GType scale_constraint_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
Scaling* scaling_dup (const Scaling* self);
void scaling_free (Scaling* self);
GType data_object_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
GType photo_source_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
GType editing_tools_straighten_tool_get_type (void) G_GNUC_CONST;
static GType editing_tools_straighten_tool_straighten_tool_window_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
gpointer one_shot_scheduler_ref (gpointer instance);
void one_shot_scheduler_unref (gpointer instance);
GParamSpec* param_spec_one_shot_scheduler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_one_shot_scheduler (GValue* value, gpointer v_object);
void value_take_one_shot_scheduler (GValue* value, gpointer v_object);
gpointer value_get_one_shot_scheduler (const GValue* value);
GType one_shot_scheduler_get_type (void) G_GNUC_CONST;
static gpointer editing_tools_straighten_tool_straighten_guide_ref (gpointer instance);
static void editing_tools_straighten_tool_straighten_guide_unref (gpointer instance);
static GParamSpec* editing_tools_straighten_tool_param_spec_straighten_guide (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void editing_tools_straighten_tool_value_set_straighten_guide (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void editing_tools_straighten_tool_value_take_straighten_guide (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer editing_tools_straighten_tool_value_get_straighten_guide (const GValue* value) G_GNUC_UNUSED;
static GType editing_tools_straighten_tool_straighten_guide_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define EDITING_TOOLS_STRAIGHTEN_TOOL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EDITING_TOOLS_TYPE_STRAIGHTEN_TOOL, EditingToolsStraightenToolPrivate))
enum  {
	EDITING_TOOLS_STRAIGHTEN_TOOL_DUMMY_PROPERTY
};
static EditingToolsStraightenToolStraightenGuide* editing_tools_straighten_tool_straighten_guide_new (void);
static EditingToolsStraightenToolStraightenGuide* editing_tools_straighten_tool_straighten_guide_construct (GType object_type);
#define EDITING_TOOLS_STRAIGHTEN_TOOL_MIN_ANGLE (-15.0)
#define EDITING_TOOLS_STRAIGHTEN_TOOL_MAX_ANGLE 15.0
#define EDITING_TOOLS_STRAIGHTEN_TOOL_INCREMENT 0.1
#define EDITING_TOOLS_STRAIGHTEN_TOOL_MIN_SLIDER_SIZE 160
#define EDITING_TOOLS_STRAIGHTEN_TOOL_MIN_LABEL_SIZE 100
#define EDITING_TOOLS_STRAIGHTEN_TOOL_MIN_BUTTON_SIZE 84
#define EDITING_TOOLS_STRAIGHTEN_TOOL_TEMP_PIXBUF_SIZE 768
#define EDITING_TOOLS_STRAIGHTEN_TOOL_REPAINT_ON_STOP_DELAY_MSEC 100
static EditingToolsStraightenTool* editing_tools_straighten_tool_new (void);
static EditingToolsStraightenTool* editing_tools_straighten_tool_construct (GType object_type);
EditingToolsEditingTool* editing_tools_editing_tool_construct (GType object_type, const gchar* name);
EditingToolsStraightenTool* editing_tools_straighten_tool_factory (void);
gboolean editing_tools_straighten_tool_is_available (Photo* photo, Scaling* scaling);
static void editing_tools_straighten_tool_on_ok_clicked (EditingToolsStraightenTool* self);
Photo* editing_tools_photo_canvas_get_photo (EditingToolsPhotoCanvas* self);
void rotate_point_arb (GdkPoint* source_point, gint img_w, gint img_h, gdouble angle, gboolean invert, GdkPoint* result);
GType command_get_type (void) G_GNUC_CONST;
GType page_command_get_type (void) G_GNUC_CONST;
GType single_data_source_command_get_type (void) G_GNUC_CONST;
GType generic_photo_transformation_command_get_type (void) G_GNUC_CONST;
GType straighten_command_get_type (void) G_GNUC_CONST;
GType box_get_type (void) G_GNUC_CONST;
Box* box_dup (const Box* self);
void box_free (Box* self);
void box_from_center (GdkPoint* center, gint width, gint height, Box* result);
#define RESOURCES_STRAIGHTEN_LABEL _ ("Straighten")
#define RESOURCES_STRAIGHTEN_TOOLTIP _ ("Straighten the photo")
StraightenCommand* straighten_command_new (Photo* photo, gdouble theta, Box* crop, const gchar* name, const gchar* explanation);
StraightenCommand* straighten_command_construct (GType object_type, Photo* photo, gdouble theta, Box* crop, const gchar* name, const gchar* explanation);
static void editing_tools_straighten_tool_high_qual_repaint (EditingToolsStraightenTool* self);
static void editing_tools_straighten_tool_update_rotated_surface (EditingToolsStraightenTool* self);
void editing_tools_photo_canvas_repaint (EditingToolsPhotoCanvas* self);
static void editing_tools_straighten_tool_on_slider_stopped_delayed (EditingToolsStraightenTool* self);
static void editing_tools_straighten_tool_real_on_left_click (EditingToolsEditingTool* base, gint x, gint y);
static void editing_tools_straighten_tool_straighten_guide_reset (EditingToolsStraightenToolStraightenGuide* self, gint x, gint y, gdouble angle);
static void editing_tools_straighten_tool_real_on_left_released (EditingToolsEditingTool* base, gint x, gint y);
static gboolean editing_tools_straighten_tool_straighten_guide_update (EditingToolsStraightenToolStraightenGuide* self, gint x, gint y);
static gdouble* editing_tools_straighten_tool_straighten_guide_get_angle (EditingToolsStraightenToolStraightenGuide* self);
static void editing_tools_straighten_tool_straighten_guide_clear (EditingToolsStraightenToolStraightenGuide* self);
static void editing_tools_straighten_tool_real_on_motion (EditingToolsEditingTool* base, gint x, gint y, GdkModifierType mask);
static gboolean editing_tools_straighten_tool_real_on_keypress (EditingToolsEditingTool* base, GdkEventKey* event);
void editing_tools_editing_tool_notify_cancel (EditingToolsEditingTool* self);
gboolean editing_tools_editing_tool_on_keypress (EditingToolsEditingTool* self, GdkEventKey* event);
static void editing_tools_straighten_tool_prepare_image (EditingToolsStraightenTool* self);
void editing_tools_photo_canvas_get_surface_dim (EditingToolsPhotoCanvas* self, Dimensions* result);
void dimensions_with_max (Dimensions *self, gint max_width, gint max_height, Dimensions* result);
static gboolean _dimensions_equal (const Dimensions* s1, const Dimensions* s2);
GType photo_exception_get_type (void) G_GNUC_CONST;
GType backing_fetch_mode_get_type (void) G_GNUC_CONST;
GdkPixbuf* photo_get_pixbuf_with_options (Photo* self, Scaling* scaling, PhotoException exceptions, BackingFetchMode fetch_mode, GError** error);
void scaling_for_viewport (Dimensions* viewport, gboolean scale_up, Scaling* result);
gchar* data_object_to_string (DataObject* self);
static void editing_tools_straighten_tool_adjust_for_rotation (EditingToolsStraightenTool* self);
void compute_arb_rotated_size (gdouble src_width, gdouble src_height, gdouble angle, gdouble* dest_width, gdouble* dest_height);
static void editing_tools_straighten_tool_real_activate (EditingToolsEditingTool* base, EditingToolsPhotoCanvas* canvas);
void editing_tools_editing_tool_activate (EditingToolsEditingTool* self, EditingToolsPhotoCanvas* canvas);
static void editing_tools_straighten_tool_bind_canvas_handlers (EditingToolsStraightenTool* self, EditingToolsPhotoCanvas* canvas);
void media_source_get_dimensions (MediaSource* self, PhotoException disallowed_steps, Dimensions* result);
gboolean photo_get_crop (Photo* self, Box* crop, PhotoException exceptions);
gboolean photo_get_straighten (Photo* self, gdouble* theta);
void derotate_point_arb (GdkPoint* source_point, gint img_w, gint img_h, gdouble angle, GdkPoint* result);
void box_get_center (Box *self, GdkPoint* result);
gint box_get_width (Box *self);
gint box_get_height (Box *self);
GdkWindow* editing_tools_photo_canvas_get_drawing_window (EditingToolsPhotoCanvas* self);
GtkWindow* editing_tools_photo_canvas_get_container (EditingToolsPhotoCanvas* self);
static EditingToolsStraightenToolStraightenToolWindow* editing_tools_straighten_tool_straighten_tool_window_new (GtkWindow* container);
static EditingToolsStraightenToolStraightenToolWindow* editing_tools_straighten_tool_straighten_tool_window_construct (GType object_type, GtkWindow* container);
static void editing_tools_straighten_tool_bind_window_handlers (EditingToolsStraightenTool* self);
static void editing_tools_straighten_tool_real_deactivate (EditingToolsEditingTool* base);
static void editing_tools_straighten_tool_unbind_window_handlers (EditingToolsStraightenTool* self);
static void editing_tools_straighten_tool_unbind_canvas_handlers (EditingToolsStraightenTool* self, EditingToolsPhotoCanvas* canvas);
void editing_tools_editing_tool_deactivate (EditingToolsEditingTool* self);
static void editing_tools_straighten_tool_on_resized_pixbuf (EditingToolsStraightenTool* self, Dimensions* old_dim, GdkPixbuf* scaled, GdkRectangle* scaled_position);
static void _editing_tools_straighten_tool_on_resized_pixbuf_editing_tools_photo_canvas_resized_scaled_pixbuf (EditingToolsPhotoCanvas* _sender, Dimensions* old_dim, GdkPixbuf* scaled, GdkRectangle* scaled_position, gpointer self);
static gboolean _editing_tools_editing_tool_on_keypress_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void _editing_tools_straighten_tool_on_ok_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _editing_tools_editing_tool_notify_cancel_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void editing_tools_straighten_tool_on_angle_changed (EditingToolsStraightenTool* self);
static void _editing_tools_straighten_tool_on_angle_changed_gtk_range_value_changed (GtkRange* _sender, gpointer self);
static void _editing_tools_straighten_tool_on_slider_stopped_delayed_one_shot_callback (gpointer self);
OneShotScheduler* one_shot_scheduler_new (const gchar* name, OneShotCallback callback, void* callback_target);
OneShotScheduler* one_shot_scheduler_construct (GType object_type, const gchar* name, OneShotCallback callback, void* callback_target);
void one_shot_scheduler_after_timeout (OneShotScheduler* self, guint msec, gboolean reschedule);
static EditingToolsEditingToolWindow* editing_tools_straighten_tool_real_get_tool_window (EditingToolsEditingTool* base);
static void editing_tools_straighten_tool_draw_rotated_source (EditingToolsStraightenTool* self, cairo_surface_t* src_surf, cairo_t* dest_ctx, gint src_width, gint src_height, gdouble angle);
static void editing_tools_straighten_tool_draw_superimposed_grid (EditingToolsStraightenTool* self, cairo_t* dest_ctx, gint width, gint height);
static void editing_tools_straighten_tool_real_paint (EditingToolsEditingTool* base, cairo_t* ctx);
cairo_t* editing_tools_photo_canvas_get_default_ctx (EditingToolsPhotoCanvas* self);
static void editing_tools_straighten_tool_straighten_guide_draw (EditingToolsStraightenToolStraightenGuide* self, cairo_t* ctx);
gdouble degrees_to_radians (gdouble theta);
void editing_tools_photo_canvas_draw_horizontal_line (EditingToolsPhotoCanvas* self, cairo_t* ctx, gint x, gint y, gint width, gboolean use_scaled_pos);
void editing_tools_photo_canvas_draw_vertical_line (EditingToolsPhotoCanvas* self, cairo_t* ctx, gint x, gint y, gint height, gboolean use_scaled_pos);
#define EDITING_TOOLS_STRAIGHTEN_TOOL_STRAIGHTEN_GUIDE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EDITING_TOOLS_STRAIGHTEN_TOOL_TYPE_STRAIGHTEN_GUIDE, EditingToolsStraightenToolStraightenGuidePrivate))
enum  {
	EDITING_TOOLS_STRAIGHTEN_TOOL_STRAIGHTEN_GUIDE_DUMMY_PROPERTY
};
static gdouble* _double_dup (gdouble* self);
static void editing_tools_straighten_tool_straighten_guide_finalize (EditingToolsStraightenToolStraightenGuide* obj);
enum  {
	EDITING_TOOLS_STRAIGHTEN_TOOL_STRAIGHTEN_TOOL_WINDOW_DUMMY_PROPERTY
};
#define RESOURCES_CANCEL_LABEL _ ("_Cancel")
#define EDITING_TOOLS_STRAIGHTEN_TOOL_STRAIGHTEN_TOOL_WINDOW_CONTROL_SPACING 8
EditingToolsEditingToolWindow* editing_tools_editing_tool_window_construct (GType object_type, GtkWindow* container);
static void editing_tools_straighten_tool_straighten_tool_window_on_reset_clicked (EditingToolsStraightenToolStraightenToolWindow* self);
static void _editing_tools_straighten_tool_straighten_tool_window_on_reset_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void editing_tools_straighten_tool_straighten_tool_window_finalize (GObject* obj);
static void editing_tools_straighten_tool_finalize (EditingToolsEditingTool* obj);

static const gdouble EDITING_TOOLS_STRAIGHTEN_TOOL_GUIDE_DASH[2] = {(gdouble) 10, (gdouble) 10};

static EditingToolsStraightenTool* editing_tools_straighten_tool_construct (GType object_type) {
	EditingToolsStraightenTool* self = NULL;
#line 190 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self = (EditingToolsStraightenTool*) editing_tools_editing_tool_construct (object_type, "StraightenTool");
#line 189 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	return self;
#line 556 "StraightenTool.c"
}


static EditingToolsStraightenTool* editing_tools_straighten_tool_new (void) {
#line 189 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	return editing_tools_straighten_tool_construct (EDITING_TOOLS_TYPE_STRAIGHTEN_TOOL);
#line 563 "StraightenTool.c"
}


EditingToolsStraightenTool* editing_tools_straighten_tool_factory (void) {
	EditingToolsStraightenTool* result = NULL;
	EditingToolsStraightenTool* _tmp0_ = NULL;
#line 194 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp0_ = editing_tools_straighten_tool_new ();
#line 194 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	result = _tmp0_;
#line 194 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	return result;
#line 576 "StraightenTool.c"
}


gboolean editing_tools_straighten_tool_is_available (Photo* photo, Scaling* scaling) {
	gboolean result = FALSE;
#line 197 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_val_if_fail (IS_PHOTO (photo), FALSE);
#line 197 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_val_if_fail (scaling != NULL, FALSE);
#line 198 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	result = TRUE;
#line 198 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	return result;
#line 590 "StraightenTool.c"
}


/**
     * @brief Signal handler for when the 'OK' button has been clicked.  Computes where a previously-
     * set crop region should have rotated to (to match the Photo's straightening angle).
     *
     * @note After this has been called against a Photo, it will always have a crop region; in the
     * case of a previously-uncropped Photo, the crop region will be set to the original dimensions
     * of the photo and centered at the Photo's center.
     */
static void editing_tools_straighten_tool_on_ok_clicked (EditingToolsStraightenTool* self) {
	EditingToolsPhotoCanvas* _tmp0_ = NULL;
	Photo* _tmp1_ = NULL;
	Photo* _tmp2_ = NULL;
	gdouble slider_val = 0.0;
	EditingToolsStraightenToolStraightenToolWindow* _tmp3_ = NULL;
	GtkScale* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
	GdkPoint new_crop_center = {0};
	GdkPoint _tmp6_ = {0};
	Dimensions _tmp7_ = {0};
	gint _tmp8_ = 0;
	Dimensions _tmp9_ = {0};
	gint _tmp10_ = 0;
	GdkPoint _tmp11_ = {0};
	StraightenCommand* command = NULL;
	EditingToolsPhotoCanvas* _tmp12_ = NULL;
	Photo* _tmp13_ = NULL;
	Photo* _tmp14_ = NULL;
	GdkPoint _tmp15_ = {0};
	gdouble _tmp16_ = 0.0;
	gint _tmp17_ = 0;
	gdouble _tmp18_ = 0.0;
	gint _tmp19_ = 0;
	Box _tmp20_ = {0};
	StraightenCommand* _tmp21_ = NULL;
	StraightenCommand* _tmp22_ = NULL;
	Dimensions _tmp23_ = {0};
#line 209 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_if_fail (EDITING_TOOLS_IS_STRAIGHTEN_TOOL (self));
#line 210 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 210 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp1_ = editing_tools_photo_canvas_get_photo (_tmp0_);
#line 210 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp2_ = _tmp1_;
#line 210 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_vala_assert (_tmp2_ != NULL, "canvas.get_photo() != null");
#line 210 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_g_object_unref0 (_tmp2_);
#line 214 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp3_ = self->priv->window;
#line 214 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp4_ = _tmp3_->angle_slider;
#line 214 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp5_ = gtk_range_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_range_get_type (), GtkRange));
#line 214 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	slider_val = _tmp5_;
#line 216 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp6_ = self->priv->rotated_center;
#line 216 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp7_ = self->priv->image_dims;
#line 216 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp8_ = _tmp7_.width;
#line 216 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp9_ = self->priv->image_dims;
#line 216 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp10_ = _tmp9_.height;
#line 216 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	rotate_point_arb (&_tmp6_, _tmp8_, _tmp10_, slider_val, FALSE, &_tmp11_);
#line 216 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	new_crop_center = _tmp11_;
#line 219 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp12_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 219 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp13_ = editing_tools_photo_canvas_get_photo (_tmp12_);
#line 219 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp14_ = _tmp13_;
#line 219 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp15_ = new_crop_center;
#line 219 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp16_ = self->priv->rotate_scale;
#line 219 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp17_ = self->priv->crop_width;
#line 219 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp18_ = self->priv->rotate_scale;
#line 219 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp19_ = self->priv->crop_height;
#line 219 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	box_from_center (&_tmp15_, (gint) (_tmp16_ * _tmp17_), (gint) (_tmp18_ * _tmp19_), &_tmp20_);
#line 219 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp21_ = straighten_command_new (_tmp14_, slider_val, &_tmp20_, RESOURCES_STRAIGHTEN_LABEL, RESOURCES_STRAIGHTEN_TOOLTIP);
#line 219 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp22_ = _tmp21_;
#line 219 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_g_object_unref0 (_tmp14_);
#line 219 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	command = _tmp22_;
#line 224 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp23_ = self->priv->image_dims;
#line 224 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool), "applied", G_TYPE_CHECK_INSTANCE_CAST (command, TYPE_COMMAND, Command), NULL, &_tmp23_, TRUE);
#line 209 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_g_object_unref0 (command);
#line 696 "StraightenTool.c"
}


static void editing_tools_straighten_tool_high_qual_repaint (EditingToolsStraightenTool* self) {
	EditingToolsPhotoCanvas* _tmp0_ = NULL;
#line 227 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_if_fail (EDITING_TOOLS_IS_STRAIGHTEN_TOOL (self));
#line 228 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->priv->use_high_qual = TRUE;
#line 229 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_straighten_tool_update_rotated_surface (self);
#line 230 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 230 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_photo_canvas_repaint (_tmp0_);
#line 712 "StraightenTool.c"
}


static void editing_tools_straighten_tool_on_slider_stopped_delayed (EditingToolsStraightenTool* self) {
#line 233 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_if_fail (EDITING_TOOLS_IS_STRAIGHTEN_TOOL (self));
#line 234 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_straighten_tool_high_qual_repaint (self);
#line 721 "StraightenTool.c"
}


static void editing_tools_straighten_tool_real_on_left_click (EditingToolsEditingTool* base, gint x, gint y) {
	EditingToolsStraightenTool * self;
	EditingToolsStraightenToolStraightenGuide* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gdouble _tmp3_ = 0.0;
#line 237 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, EDITING_TOOLS_TYPE_STRAIGHTEN_TOOL, EditingToolsStraightenTool);
#line 238 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp0_ = self->priv->guide;
#line 238 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp1_ = x;
#line 238 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp2_ = y;
#line 238 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp3_ = self->priv->photo_angle;
#line 238 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_straighten_tool_straighten_guide_reset (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 743 "StraightenTool.c"
}


static void editing_tools_straighten_tool_real_on_left_released (EditingToolsEditingTool* base, gint x, gint y) {
	EditingToolsStraightenTool * self;
	EditingToolsStraightenToolStraightenGuide* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gdouble* a = NULL;
	EditingToolsStraightenToolStraightenGuide* _tmp3_ = NULL;
	gdouble* _tmp4_ = NULL;
	EditingToolsStraightenToolStraightenGuide* _tmp5_ = NULL;
	gdouble* _tmp6_ = NULL;
#line 241 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, EDITING_TOOLS_TYPE_STRAIGHTEN_TOOL, EditingToolsStraightenTool);
#line 242 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp0_ = self->priv->guide;
#line 242 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp1_ = x;
#line 242 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp2_ = y;
#line 242 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_straighten_tool_straighten_guide_update (_tmp0_, _tmp1_, _tmp2_);
#line 243 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp3_ = self->priv->guide;
#line 243 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp4_ = editing_tools_straighten_tool_straighten_guide_get_angle (_tmp3_);
#line 243 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	a = _tmp4_;
#line 244 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp5_ = self->priv->guide;
#line 244 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_straighten_tool_straighten_guide_clear (_tmp5_);
#line 245 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp6_ = a;
#line 245 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (_tmp6_ != NULL) {
#line 781 "StraightenTool.c"
		EditingToolsStraightenToolStraightenToolWindow* _tmp7_ = NULL;
		GtkScale* _tmp8_ = NULL;
		gdouble* _tmp9_ = NULL;
#line 246 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp7_ = self->priv->window;
#line 246 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp8_ = _tmp7_->angle_slider;
#line 246 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp9_ = a;
#line 246 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		gtk_range_set_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_range_get_type (), GtkRange), *_tmp9_);
#line 247 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		editing_tools_straighten_tool_high_qual_repaint (self);
#line 795 "StraightenTool.c"
	}
#line 241 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_g_free0 (a);
#line 799 "StraightenTool.c"
}


static void editing_tools_straighten_tool_real_on_motion (EditingToolsEditingTool* base, gint x, gint y, GdkModifierType mask) {
	EditingToolsStraightenTool * self;
	EditingToolsStraightenToolStraightenGuide* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
#line 251 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, EDITING_TOOLS_TYPE_STRAIGHTEN_TOOL, EditingToolsStraightenTool);
#line 252 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp0_ = self->priv->guide;
#line 252 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp1_ = x;
#line 252 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp2_ = y;
#line 252 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp3_ = editing_tools_straighten_tool_straighten_guide_update (_tmp0_, _tmp1_, _tmp2_);
#line 252 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (_tmp3_) {
#line 821 "StraightenTool.c"
		EditingToolsPhotoCanvas* _tmp4_ = NULL;
#line 253 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 253 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		editing_tools_photo_canvas_repaint (_tmp4_);
#line 827 "StraightenTool.c"
	}
}


static gboolean editing_tools_straighten_tool_real_on_keypress (EditingToolsEditingTool* base, GdkEventKey* event) {
	EditingToolsStraightenTool * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GdkEventKey* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	const gchar* _tmp4_ = NULL;
	GdkEventKey* _tmp11_ = NULL;
	guint _tmp12_ = 0U;
	const gchar* _tmp13_ = NULL;
	GdkEventKey* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
#line 256 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, EDITING_TOOLS_TYPE_STRAIGHTEN_TOOL, EditingToolsStraightenTool);
#line 256 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 257 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp2_ = event;
#line 257 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp3_ = _tmp2_->keyval;
#line 257 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp4_ = gdk_keyval_name (_tmp3_);
#line 257 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (g_strcmp0 (_tmp4_, "KP_Enter") == 0) {
#line 257 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp1_ = TRUE;
#line 859 "StraightenTool.c"
	} else {
		GdkEventKey* _tmp5_ = NULL;
		guint _tmp6_ = 0U;
		const gchar* _tmp7_ = NULL;
#line 258 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp5_ = event;
#line 258 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp6_ = _tmp5_->keyval;
#line 258 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp7_ = gdk_keyval_name (_tmp6_);
#line 258 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp1_ = g_strcmp0 (_tmp7_, "Enter") == 0;
#line 872 "StraightenTool.c"
	}
#line 257 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (_tmp1_) {
#line 257 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp0_ = TRUE;
#line 878 "StraightenTool.c"
	} else {
		GdkEventKey* _tmp8_ = NULL;
		guint _tmp9_ = 0U;
		const gchar* _tmp10_ = NULL;
#line 259 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp8_ = event;
#line 259 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp9_ = _tmp8_->keyval;
#line 259 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp10_ = gdk_keyval_name (_tmp9_);
#line 259 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp0_ = g_strcmp0 (_tmp10_, "Return") == 0;
#line 891 "StraightenTool.c"
	}
#line 257 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (_tmp0_) {
#line 260 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		editing_tools_straighten_tool_on_ok_clicked (self);
#line 261 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		result = TRUE;
#line 261 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		return result;
#line 901 "StraightenTool.c"
	}
#line 264 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp11_ = event;
#line 264 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp12_ = _tmp11_->keyval;
#line 264 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp13_ = gdk_keyval_name (_tmp12_);
#line 264 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (g_strcmp0 (_tmp13_, "Escape") == 0) {
#line 265 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		editing_tools_editing_tool_notify_cancel (G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool));
#line 266 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		result = TRUE;
#line 266 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		return result;
#line 917 "StraightenTool.c"
	}
#line 269 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp14_ = event;
#line 269 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp15_ = EDITING_TOOLS_EDITING_TOOL_CLASS (editing_tools_straighten_tool_parent_class)->on_keypress (G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool), _tmp14_);
#line 269 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	result = _tmp15_;
#line 269 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	return result;
#line 927 "StraightenTool.c"
}


static gboolean _dimensions_equal (const Dimensions* s1, const Dimensions* s2) {
#line 275 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (s1 == s2) {
#line 275 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		return TRUE;
#line 936 "StraightenTool.c"
	}
#line 275 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (s1 == NULL) {
#line 275 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		return FALSE;
#line 942 "StraightenTool.c"
	}
#line 275 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (s2 == NULL) {
#line 275 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		return FALSE;
#line 948 "StraightenTool.c"
	}
#line 275 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (s1->width != s2->width) {
#line 275 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		return FALSE;
#line 954 "StraightenTool.c"
	}
#line 275 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (s1->height != s2->height) {
#line 275 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		return FALSE;
#line 960 "StraightenTool.c"
	}
#line 275 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	return TRUE;
#line 964 "StraightenTool.c"
}


static void editing_tools_straighten_tool_prepare_image (EditingToolsStraightenTool* self) {
	Dimensions canvas_dims = {0};
	EditingToolsPhotoCanvas* _tmp0_ = NULL;
	Dimensions _tmp1_ = {0};
	Dimensions viewport = {0};
	Dimensions _tmp2_ = {0};
	Dimensions _tmp3_ = {0};
	Dimensions _tmp4_ = {0};
	Dimensions _tmp5_ = {0};
	GdkPixbuf* low_res_tmp = NULL;
	GdkPixbuf* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	Dimensions _tmp24_ = {0};
	gint _tmp25_ = 0;
	GdkPixbuf* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	GdkPixbuf* _tmp29_ = NULL;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	cairo_surface_t* _tmp32_ = NULL;
	cairo_t* ctx = NULL;
	cairo_surface_t* _tmp33_ = NULL;
	cairo_t* _tmp34_ = NULL;
	cairo_t* _tmp35_ = NULL;
	GdkPixbuf* _tmp36_ = NULL;
	cairo_t* _tmp37_ = NULL;
	GdkPixbuf* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
	GdkPixbuf* _tmp41_ = NULL;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	cairo_t* _tmp44_ = NULL;
	cairo_t* _tmp45_ = NULL;
	gint _tmp46_ = 0;
	gdouble _tmp47_ = 0.0;
	gint _tmp48_ = 0;
	gdouble _tmp49_ = 0.0;
	gint _tmp50_ = 0;
	gint _tmp51_ = 0;
	cairo_surface_t* _tmp52_ = NULL;
	cairo_surface_t* _tmp53_ = NULL;
	cairo_t* _tmp54_ = NULL;
	GError * _inner_error_ = NULL;
#line 272 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_if_fail (EDITING_TOOLS_IS_STRAIGHTEN_TOOL (self));
#line 273 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 273 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_photo_canvas_get_surface_dim (_tmp0_, &_tmp1_);
#line 273 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	canvas_dims = _tmp1_;
#line 274 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	dimensions_with_max (&canvas_dims, EDITING_TOOLS_STRAIGHTEN_TOOL_TEMP_PIXBUF_SIZE, EDITING_TOOLS_STRAIGHTEN_TOOL_TEMP_PIXBUF_SIZE, &_tmp2_);
#line 274 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	viewport = _tmp2_;
#line 275 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp3_ = viewport;
#line 275 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp4_ = self->priv->last_viewport;
#line 275 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (_dimensions_equal (&_tmp3_, &_tmp4_) == TRUE) {
#line 276 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		return;
#line 1034 "StraightenTool.c"
	}
#line 278 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp5_ = viewport;
#line 278 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->priv->last_viewport = _tmp5_;
#line 280 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	low_res_tmp = NULL;
#line 1042 "StraightenTool.c"
	{
		GdkPixbuf* _tmp6_ = NULL;
		EditingToolsPhotoCanvas* _tmp7_ = NULL;
		Photo* _tmp8_ = NULL;
		Photo* _tmp9_ = NULL;
		Dimensions _tmp10_ = {0};
		Scaling _tmp11_ = {0};
		GdkPixbuf* _tmp12_ = NULL;
		GdkPixbuf* _tmp13_ = NULL;
		GdkPixbuf* _tmp14_ = NULL;
#line 283 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp7_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 283 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp8_ = editing_tools_photo_canvas_get_photo (_tmp7_);
#line 283 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp9_ = _tmp8_;
#line 283 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp10_ = viewport;
#line 283 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		scaling_for_viewport (&_tmp10_, FALSE, &_tmp11_);
#line 283 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp12_ = photo_get_pixbuf_with_options (_tmp9_, &_tmp11_, PHOTO_EXCEPTION_STRAIGHTEN | PHOTO_EXCEPTION_CROP, BACKING_FETCH_MODE_BASELINE, &_inner_error_);
#line 283 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp13_ = _tmp12_;
#line 283 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_g_object_unref0 (_tmp9_);
#line 283 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp6_ = _tmp13_;
#line 283 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1073 "StraightenTool.c"
			goto __catch23_g_error;
		}
#line 282 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp14_ = _tmp6_;
#line 282 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp6_ = NULL;
#line 282 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_g_object_unref0 (low_res_tmp);
#line 282 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		low_res_tmp = _tmp14_;
#line 281 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_g_object_unref0 (_tmp6_);
#line 1086 "StraightenTool.c"
	}
	goto __finally23;
	__catch23_g_error:
	{
		GError* e = NULL;
		EditingToolsPhotoCanvas* _tmp15_ = NULL;
		Photo* _tmp16_ = NULL;
		Photo* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		GdkPixbuf* _tmp20_ = NULL;
#line 281 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		e = _inner_error_;
#line 281 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_inner_error_ = NULL;
#line 286 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp15_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 286 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp16_ = editing_tools_photo_canvas_get_photo (_tmp15_);
#line 286 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp17_ = _tmp16_;
#line 286 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp18_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_DATA_OBJECT, DataObject));
#line 286 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp19_ = _tmp18_;
#line 286 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		g_warning ("StraightenTool.vala:286: A pixbuf for %s couldn't be fetched.", _tmp19_);
#line 286 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_g_free0 (_tmp19_);
#line 286 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_g_object_unref0 (_tmp17_);
#line 287 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp20_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, 1, 1);
#line 287 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_g_object_unref0 (low_res_tmp);
#line 287 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		low_res_tmp = _tmp20_;
#line 281 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_g_error_free0 (e);
#line 1126 "StraightenTool.c"
	}
	__finally23:
#line 281 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 281 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_g_object_unref0 (low_res_tmp);
#line 281 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 281 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		g_clear_error (&_inner_error_);
#line 281 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		return;
#line 1139 "StraightenTool.c"
	}
#line 290 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp21_ = low_res_tmp;
#line 290 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp22_ = gdk_pixbuf_get_width (_tmp21_);
#line 290 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp23_ = _tmp22_;
#line 290 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp24_ = self->priv->image_dims;
#line 290 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp25_ = _tmp24_.width;
#line 290 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->priv->preview_scale = _tmp23_ / ((gdouble) _tmp25_);
#line 293 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp26_ = low_res_tmp;
#line 293 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp27_ = gdk_pixbuf_get_width (_tmp26_);
#line 293 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp28_ = _tmp27_;
#line 293 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp29_ = low_res_tmp;
#line 293 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp30_ = gdk_pixbuf_get_height (_tmp29_);
#line 293 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp31_ = _tmp30_;
#line 293 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp32_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, _tmp28_, _tmp31_);
#line 293 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_cairo_surface_destroy0 (self->priv->photo_surf);
#line 293 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->priv->photo_surf = _tmp32_;
#line 294 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp33_ = self->priv->photo_surf;
#line 294 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp34_ = cairo_create (_tmp33_);
#line 294 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	ctx = _tmp34_;
#line 295 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp35_ = ctx;
#line 295 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp36_ = low_res_tmp;
#line 295 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gdk_cairo_set_source_pixbuf (_tmp35_, _tmp36_, (gdouble) 0, (gdouble) 0);
#line 296 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp37_ = ctx;
#line 296 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp38_ = low_res_tmp;
#line 296 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp39_ = gdk_pixbuf_get_width (_tmp38_);
#line 296 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp40_ = _tmp39_;
#line 296 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp41_ = low_res_tmp;
#line 296 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp42_ = gdk_pixbuf_get_height (_tmp41_);
#line 296 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp43_ = _tmp42_;
#line 296 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_rectangle (_tmp37_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp40_, (gdouble) _tmp43_);
#line 297 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp44_ = ctx;
#line 297 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_fill (_tmp44_);
#line 298 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp45_ = ctx;
#line 298 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_paint (_tmp45_);
#line 302 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp46_ = self->priv->crop_width;
#line 302 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp47_ = self->priv->preview_scale;
#line 302 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->priv->view_width = (gint) (_tmp46_ * _tmp47_);
#line 303 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp48_ = self->priv->crop_height;
#line 303 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp49_ = self->priv->preview_scale;
#line 303 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->priv->view_height = (gint) (_tmp48_ * _tmp49_);
#line 304 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp50_ = self->priv->view_width;
#line 304 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp51_ = self->priv->view_height;
#line 304 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp52_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, _tmp50_, _tmp51_);
#line 304 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_cairo_surface_destroy0 (self->priv->rotate_surf);
#line 304 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->priv->rotate_surf = _tmp52_;
#line 305 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp53_ = self->priv->rotate_surf;
#line 305 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp54_ = cairo_create (_tmp53_);
#line 305 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_cairo_destroy0 (self->priv->rotate_ctx);
#line 305 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->priv->rotate_ctx = _tmp54_;
#line 272 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_cairo_destroy0 (ctx);
#line 272 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_g_object_unref0 (low_res_tmp);
#line 1241 "StraightenTool.c"
}


static void editing_tools_straighten_tool_adjust_for_rotation (EditingToolsStraightenTool* self) {
	gdouble width = 0.0;
	gdouble height = 0.0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	Dimensions _tmp5_ = {0};
	gint _tmp6_ = 0;
	Dimensions _tmp7_ = {0};
	gint _tmp8_ = 0;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	GdkPoint _tmp12_ = {0};
	gint radius_x = 0;
	gdouble _tmp13_ = 0.0;
	gint radius_y = 0;
	gdouble _tmp14_ = 0.0;
	GdkPoint _tmp15_ = {0};
	gint _tmp16_ = 0;
	Dimensions _tmp17_ = {0};
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	GdkPoint _tmp20_ = {0};
	gint _tmp21_ = 0;
	Dimensions _tmp22_ = {0};
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
#line 309 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_if_fail (EDITING_TOOLS_IS_STRAIGHTEN_TOOL (self));
#line 311 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp0_ = self->priv->crop_width;
#line 311 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp1_ = self->priv->crop_height;
#line 311 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp2_ = self->priv->photo_angle;
#line 311 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	compute_arb_rotated_size ((gdouble) _tmp0_, (gdouble) _tmp1_, _tmp2_, &_tmp3_, &_tmp4_);
#line 311 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	width = _tmp3_;
#line 311 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	height = _tmp4_;
#line 314 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp5_ = self->priv->image_dims;
#line 314 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp6_ = _tmp5_.width;
#line 314 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp7_ = self->priv->image_dims;
#line 314 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp8_ = _tmp7_.height;
#line 314 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp9_ = MIN (_tmp6_ / width, _tmp8_ / height);
#line 314 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->priv->rotate_scale = _tmp9_;
#line 315 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp10_ = self->priv->rotate_scale;
#line 315 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp11_ = MIN (_tmp10_, 1.0);
#line 315 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->priv->rotate_scale = _tmp11_;
#line 318 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp12_ = self->priv->crop_center;
#line 318 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->priv->rotated_center = _tmp12_;
#line 319 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp13_ = self->priv->rotate_scale;
#line 319 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	radius_x = (gint) ((_tmp13_ * width) / 2);
#line 320 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp14_ = self->priv->rotate_scale;
#line 320 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	radius_y = (gint) ((_tmp14_ * height) / 2);
#line 321 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp15_ = self->priv->rotated_center;
#line 321 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp16_ = _tmp15_.x;
#line 321 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp17_ = self->priv->image_dims;
#line 321 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp18_ = _tmp17_.width;
#line 321 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp19_ = CLAMP (_tmp16_, radius_x, _tmp18_ - radius_x);
#line 321 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->priv->rotated_center.x = _tmp19_;
#line 322 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp20_ = self->priv->rotated_center;
#line 322 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp21_ = _tmp20_.y;
#line 322 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp22_ = self->priv->image_dims;
#line 322 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp23_ = _tmp22_.height;
#line 322 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp24_ = CLAMP (_tmp21_, radius_y, _tmp23_ - radius_y);
#line 322 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->priv->rotated_center.y = _tmp24_;
#line 1343 "StraightenTool.c"
}


/**
     * @brief Spawn the tool window, set up the scratch surfaces and prepare the straightening
     * tool for use.  If a valid pixbuf of the incoming Photo can't be loaded for any
     * reason, the tool will use a 1x1 temporary image instead to avoid crashing.
     *
     * @param canvas The PhotoCanvas the tool's output should be painted to.
     */
static gpointer _editing_tools_photo_canvas_ref0 (gpointer self) {
#line 334 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	return self ? editing_tools_photo_canvas_ref (self) : NULL;
#line 1357 "StraightenTool.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 366 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	return self ? g_object_ref (self) : NULL;
#line 1364 "StraightenTool.c"
}


static void editing_tools_straighten_tool_real_activate (EditingToolsEditingTool* base, EditingToolsPhotoCanvas* canvas) {
	EditingToolsStraightenTool * self;
	EditingToolsPhotoCanvas* _tmp0_ = NULL;
	EditingToolsPhotoCanvas* _tmp1_ = NULL;
	EditingToolsPhotoCanvas* _tmp2_ = NULL;
	EditingToolsPhotoCanvas* _tmp3_ = NULL;
	EditingToolsPhotoCanvas* _tmp4_ = NULL;
	Photo* _tmp5_ = NULL;
	Photo* _tmp6_ = NULL;
	Dimensions _tmp7_ = {0};
	Box crop_region = {0};
	EditingToolsPhotoCanvas* _tmp8_ = NULL;
	Photo* _tmp9_ = NULL;
	Photo* _tmp10_ = NULL;
	Box _tmp11_ = {0};
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gdouble incoming_angle = 0.0;
	EditingToolsPhotoCanvas* _tmp18_ = NULL;
	Photo* _tmp19_ = NULL;
	Photo* _tmp20_ = NULL;
	gdouble _tmp21_ = 0.0;
	GdkPoint _tmp22_ = {0};
	Dimensions _tmp23_ = {0};
	gint _tmp24_ = 0;
	Dimensions _tmp25_ = {0};
	gint _tmp26_ = 0;
	gdouble _tmp27_ = 0.0;
	GdkPoint _tmp28_ = {0};
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	GdkWindow* drawing_window = NULL;
	EditingToolsPhotoCanvas* _tmp31_ = NULL;
	GdkWindow* _tmp32_ = NULL;
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp33_ = NULL;
	GdkDisplay* _tmp34_ = NULL;
	GdkCursor* cursor = NULL;
	GdkCursor* _tmp35_ = NULL;
	EditingToolsPhotoCanvas* _tmp36_ = NULL;
	GtkWindow* _tmp37_ = NULL;
	GtkWindow* _tmp38_ = NULL;
	EditingToolsStraightenToolStraightenToolWindow* _tmp39_ = NULL;
	EditingToolsStraightenToolStraightenToolWindow* _tmp40_ = NULL;
	GtkScale* _tmp41_ = NULL;
	gdouble _tmp42_ = 0.0;
	gdouble _tmp43_ = 0.0;
	gchar* tmp = NULL;
	gdouble _tmp44_ = 0.0;
	gchar* _tmp45_ = NULL;
	EditingToolsStraightenToolStraightenToolWindow* _tmp46_ = NULL;
	GtkLabel* _tmp47_ = NULL;
	EditingToolsStraightenToolStraightenToolWindow* _tmp48_ = NULL;
#line 332 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, EDITING_TOOLS_TYPE_STRAIGHTEN_TOOL, EditingToolsStraightenTool);
#line 332 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_if_fail (EDITING_TOOLS_IS_PHOTO_CANVAS (canvas));
#line 333 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp0_ = canvas;
#line 333 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	EDITING_TOOLS_EDITING_TOOL_CLASS (editing_tools_straighten_tool_parent_class)->activate (G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool), _tmp0_);
#line 334 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp1_ = canvas;
#line 334 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp2_ = _editing_tools_photo_canvas_ref0 (_tmp1_);
#line 334 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_editing_tools_photo_canvas_unref0 (G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas);
#line 334 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas = _tmp2_;
#line 335 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 335 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_straighten_tool_bind_canvas_handlers (self, _tmp3_);
#line 337 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp4_ = canvas;
#line 337 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp5_ = editing_tools_photo_canvas_get_photo (_tmp4_);
#line 337 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp6_ = _tmp5_;
#line 337 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_MEDIA_SOURCE, MediaSource), PHOTO_EXCEPTION_STRAIGHTEN | PHOTO_EXCEPTION_CROP, &_tmp7_);
#line 337 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->priv->image_dims = _tmp7_;
#line 337 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_g_object_unref0 (_tmp6_);
#line 341 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp8_ = canvas;
#line 341 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp9_ = editing_tools_photo_canvas_get_photo (_tmp8_);
#line 341 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp10_ = _tmp9_;
#line 341 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp12_ = photo_get_crop (_tmp10_, &_tmp11_, PHOTO_EXCEPTION_NONE);
#line 341 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	crop_region = _tmp11_;
#line 341 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp13_ = !_tmp12_;
#line 341 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_g_object_unref0 (_tmp10_);
#line 341 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (_tmp13_) {
#line 1469 "StraightenTool.c"
		Dimensions _tmp14_ = {0};
		gint _tmp15_ = 0;
		Dimensions _tmp16_ = {0};
		gint _tmp17_ = 0;
#line 342 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		crop_region.left = 0;
#line 343 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp14_ = self->priv->image_dims;
#line 343 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp15_ = _tmp14_.width;
#line 343 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		crop_region.right = _tmp15_;
#line 345 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		crop_region.top = 0;
#line 346 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp16_ = self->priv->image_dims;
#line 346 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp17_ = _tmp16_.height;
#line 346 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		crop_region.bottom = _tmp17_;
#line 1490 "StraightenTool.c"
	}
#line 351 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	incoming_angle = 0.0;
#line 352 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp18_ = canvas;
#line 352 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp19_ = editing_tools_photo_canvas_get_photo (_tmp18_);
#line 352 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp20_ = _tmp19_;
#line 352 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	photo_get_straighten (_tmp20_, &_tmp21_);
#line 352 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	incoming_angle = _tmp21_;
#line 352 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_g_object_unref0 (_tmp20_);
#line 355 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	box_get_center (&crop_region, &_tmp22_);
#line 355 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp23_ = self->priv->image_dims;
#line 355 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp24_ = _tmp23_.width;
#line 355 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp25_ = self->priv->image_dims;
#line 355 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp26_ = _tmp25_.height;
#line 355 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp27_ = incoming_angle;
#line 355 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	derotate_point_arb (&_tmp22_, _tmp24_, _tmp26_, _tmp27_, &_tmp28_);
#line 355 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->priv->crop_center = _tmp28_;
#line 357 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp29_ = box_get_width (&crop_region);
#line 357 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->priv->crop_width = _tmp29_;
#line 358 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp30_ = box_get_height (&crop_region);
#line 358 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->priv->crop_height = _tmp30_;
#line 360 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_straighten_tool_adjust_for_rotation (self);
#line 362 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_straighten_tool_prepare_image (self);
#line 365 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp31_ = canvas;
#line 365 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp32_ = editing_tools_photo_canvas_get_drawing_window (_tmp31_);
#line 365 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	drawing_window = _tmp32_;
#line 366 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp33_ = gdk_window_get_display (drawing_window);
#line 366 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp34_ = _g_object_ref0 (_tmp33_);
#line 366 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	display = _tmp34_;
#line 367 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp35_ = gdk_cursor_new_for_display (display, GDK_CROSSHAIR);
#line 367 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cursor = _tmp35_;
#line 369 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gdk_window_set_cursor (drawing_window, cursor);
#line 371 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp36_ = canvas;
#line 371 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp37_ = editing_tools_photo_canvas_get_container (_tmp36_);
#line 371 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp38_ = _tmp37_;
#line 371 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp39_ = editing_tools_straighten_tool_straighten_tool_window_new (_tmp38_);
#line 371 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_object_ref_sink (_tmp39_);
#line 371 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_g_object_unref0 (self->priv->window);
#line 371 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->priv->window = _tmp39_;
#line 371 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_g_object_unref0 (_tmp38_);
#line 372 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_straighten_tool_bind_window_handlers (self);
#line 375 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp40_ = self->priv->window;
#line 375 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp41_ = _tmp40_->angle_slider;
#line 375 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp42_ = incoming_angle;
#line 375 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gtk_range_set_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, gtk_range_get_type (), GtkRange), _tmp42_);
#line 376 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp43_ = incoming_angle;
#line 376 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->priv->photo_angle = _tmp43_;
#line 378 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp44_ = incoming_angle;
#line 378 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp45_ = g_strdup_printf ("%2.1f°", _tmp44_);
#line 378 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	tmp = _tmp45_;
#line 379 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp46_ = self->priv->window;
#line 379 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp47_ = _tmp46_->angle_label;
#line 379 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gtk_label_set_text (_tmp47_, tmp);
#line 381 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_straighten_tool_high_qual_repaint (self);
#line 382 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp48_ = self->priv->window;
#line 382 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, gtk_widget_get_type (), GtkWidget));
#line 332 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_g_free0 (tmp);
#line 332 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_g_object_unref0 (cursor);
#line 332 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_g_object_unref0 (display);
#line 332 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_g_object_unref0 (drawing_window);
#line 1608 "StraightenTool.c"
}


/**
     * Tears down the tool window and frees resources.
     */
static void editing_tools_straighten_tool_real_deactivate (EditingToolsEditingTool* base) {
	EditingToolsStraightenTool * self;
	EditingToolsStraightenToolStraightenToolWindow* _tmp0_ = NULL;
	EditingToolsPhotoCanvas* _tmp2_ = NULL;
#line 388 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, EDITING_TOOLS_TYPE_STRAIGHTEN_TOOL, EditingToolsStraightenTool);
#line 389 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp0_ = self->priv->window;
#line 389 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (_tmp0_ != NULL) {
#line 1625 "StraightenTool.c"
		EditingToolsStraightenToolStraightenToolWindow* _tmp1_ = NULL;
#line 391 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		editing_tools_straighten_tool_unbind_window_handlers (self);
#line 393 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp1_ = self->priv->window;
#line 393 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
#line 394 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_g_object_unref0 (self->priv->window);
#line 394 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		self->priv->window = NULL;
#line 1637 "StraightenTool.c"
	}
#line 397 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 397 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (_tmp2_ != NULL) {
#line 1643 "StraightenTool.c"
		EditingToolsPhotoCanvas* _tmp3_ = NULL;
		EditingToolsPhotoCanvas* _tmp4_ = NULL;
		GdkWindow* _tmp5_ = NULL;
		GdkWindow* _tmp6_ = NULL;
#line 398 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 398 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		editing_tools_straighten_tool_unbind_canvas_handlers (self, _tmp3_);
#line 399 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 399 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp5_ = editing_tools_photo_canvas_get_drawing_window (_tmp4_);
#line 399 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp6_ = _tmp5_;
#line 399 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		gdk_window_set_cursor (_tmp6_, NULL);
#line 399 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_g_object_unref0 (_tmp6_);
#line 1662 "StraightenTool.c"
	}
#line 402 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	EDITING_TOOLS_EDITING_TOOL_CLASS (editing_tools_straighten_tool_parent_class)->deactivate (G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool));
#line 1666 "StraightenTool.c"
}


static void _editing_tools_straighten_tool_on_resized_pixbuf_editing_tools_photo_canvas_resized_scaled_pixbuf (EditingToolsPhotoCanvas* _sender, Dimensions* old_dim, GdkPixbuf* scaled, GdkRectangle* scaled_position, gpointer self) {
#line 406 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_straighten_tool_on_resized_pixbuf ((EditingToolsStraightenTool*) self, old_dim, scaled, scaled_position);
#line 1673 "StraightenTool.c"
}


static void editing_tools_straighten_tool_bind_canvas_handlers (EditingToolsStraightenTool* self, EditingToolsPhotoCanvas* canvas) {
	EditingToolsPhotoCanvas* _tmp0_ = NULL;
#line 405 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_if_fail (EDITING_TOOLS_IS_STRAIGHTEN_TOOL (self));
#line 405 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_if_fail (EDITING_TOOLS_IS_PHOTO_CANVAS (canvas));
#line 406 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp0_ = canvas;
#line 406 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_signal_connect (_tmp0_, "resized-scaled-pixbuf", (GCallback) _editing_tools_straighten_tool_on_resized_pixbuf_editing_tools_photo_canvas_resized_scaled_pixbuf, self);
#line 1687 "StraightenTool.c"
}


static void editing_tools_straighten_tool_unbind_canvas_handlers (EditingToolsStraightenTool* self, EditingToolsPhotoCanvas* canvas) {
	EditingToolsPhotoCanvas* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
#line 409 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_if_fail (EDITING_TOOLS_IS_STRAIGHTEN_TOOL (self));
#line 409 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_if_fail (EDITING_TOOLS_IS_PHOTO_CANVAS (canvas));
#line 410 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp0_ = canvas;
#line 410 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_signal_parse_name ("resized-scaled-pixbuf", EDITING_TOOLS_TYPE_PHOTO_CANVAS, &_tmp1_, NULL, FALSE);
#line 410 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _editing_tools_straighten_tool_on_resized_pixbuf_editing_tools_photo_canvas_resized_scaled_pixbuf, self);
#line 1704 "StraightenTool.c"
}


static gboolean _editing_tools_editing_tool_on_keypress_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = editing_tools_editing_tool_on_keypress ((EditingToolsEditingTool*) self, event);
#line 414 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	return result;
#line 1713 "StraightenTool.c"
}


static void _editing_tools_straighten_tool_on_ok_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 415 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_straighten_tool_on_ok_clicked ((EditingToolsStraightenTool*) self);
#line 1720 "StraightenTool.c"
}


static void _editing_tools_editing_tool_notify_cancel_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 416 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_editing_tool_notify_cancel ((EditingToolsEditingTool*) self);
#line 1727 "StraightenTool.c"
}


static void _editing_tools_straighten_tool_on_angle_changed_gtk_range_value_changed (GtkRange* _sender, gpointer self) {
#line 417 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_straighten_tool_on_angle_changed ((EditingToolsStraightenTool*) self);
#line 1734 "StraightenTool.c"
}


static void editing_tools_straighten_tool_bind_window_handlers (EditingToolsStraightenTool* self) {
	EditingToolsStraightenToolStraightenToolWindow* _tmp0_ = NULL;
	EditingToolsStraightenToolStraightenToolWindow* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	EditingToolsStraightenToolStraightenToolWindow* _tmp3_ = NULL;
	GtkButton* _tmp4_ = NULL;
	EditingToolsStraightenToolStraightenToolWindow* _tmp5_ = NULL;
	GtkScale* _tmp6_ = NULL;
#line 413 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_if_fail (EDITING_TOOLS_IS_STRAIGHTEN_TOOL (self));
#line 414 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp0_ = self->priv->window;
#line 414 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), "key-press-event", (GCallback) _editing_tools_editing_tool_on_keypress_gtk_widget_key_press_event, G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool));
#line 415 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp1_ = self->priv->window;
#line 415 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp2_ = _tmp1_->ok_button;
#line 415 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_signal_connect (_tmp2_, "clicked", (GCallback) _editing_tools_straighten_tool_on_ok_clicked_gtk_button_clicked, self);
#line 416 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp3_ = self->priv->window;
#line 416 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp4_ = _tmp3_->cancel_button;
#line 416 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_signal_connect (_tmp4_, "clicked", (GCallback) _editing_tools_editing_tool_notify_cancel_gtk_button_clicked, G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool));
#line 417 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp5_ = self->priv->window;
#line 417 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp6_ = _tmp5_->angle_slider;
#line 417 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_range_get_type (), GtkRange), "value-changed", (GCallback) _editing_tools_straighten_tool_on_angle_changed_gtk_range_value_changed, self);
#line 1770 "StraightenTool.c"
}


static void editing_tools_straighten_tool_unbind_window_handlers (EditingToolsStraightenTool* self) {
	EditingToolsStraightenToolStraightenToolWindow* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	EditingToolsStraightenToolStraightenToolWindow* _tmp2_ = NULL;
	GtkButton* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	EditingToolsStraightenToolStraightenToolWindow* _tmp5_ = NULL;
	GtkButton* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	EditingToolsStraightenToolStraightenToolWindow* _tmp8_ = NULL;
	GtkScale* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
#line 420 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_if_fail (EDITING_TOOLS_IS_STRAIGHTEN_TOOL (self));
#line 421 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp0_ = self->priv->window;
#line 421 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_signal_parse_name ("key-press-event", gtk_widget_get_type (), &_tmp1_, NULL, FALSE);
#line 421 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _editing_tools_editing_tool_on_keypress_gtk_widget_key_press_event, G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool));
#line 422 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp2_ = self->priv->window;
#line 422 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp3_ = _tmp2_->ok_button;
#line 422 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_signal_parse_name ("clicked", gtk_button_get_type (), &_tmp4_, NULL, FALSE);
#line 422 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _editing_tools_straighten_tool_on_ok_clicked_gtk_button_clicked, self);
#line 423 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp5_ = self->priv->window;
#line 423 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp6_ = _tmp5_->cancel_button;
#line 423 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_signal_parse_name ("clicked", gtk_button_get_type (), &_tmp7_, NULL, FALSE);
#line 423 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _editing_tools_editing_tool_notify_cancel_gtk_button_clicked, G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool));
#line 424 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp8_ = self->priv->window;
#line 424 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp9_ = _tmp8_->angle_slider;
#line 424 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_signal_parse_name ("value-changed", gtk_range_get_type (), &_tmp10_, NULL, FALSE);
#line 424 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_range_get_type (), GtkRange), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _editing_tools_straighten_tool_on_angle_changed_gtk_range_value_changed, self);
#line 1818 "StraightenTool.c"
}


static void _editing_tools_straighten_tool_on_slider_stopped_delayed_one_shot_callback (gpointer self) {
#line 433 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_straighten_tool_on_slider_stopped_delayed ((EditingToolsStraightenTool*) self);
#line 1825 "StraightenTool.c"
}


static void editing_tools_straighten_tool_on_angle_changed (EditingToolsStraightenTool* self) {
	EditingToolsStraightenToolStraightenToolWindow* _tmp0_ = NULL;
	GtkScale* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gchar* tmp = NULL;
	EditingToolsStraightenToolStraightenToolWindow* _tmp3_ = NULL;
	GtkScale* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
	gchar* _tmp6_ = NULL;
	EditingToolsStraightenToolStraightenToolWindow* _tmp7_ = NULL;
	GtkLabel* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	OneShotScheduler* _tmp10_ = NULL;
	OneShotScheduler* _tmp12_ = NULL;
	EditingToolsPhotoCanvas* _tmp13_ = NULL;
#line 427 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_if_fail (EDITING_TOOLS_IS_STRAIGHTEN_TOOL (self));
#line 428 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp0_ = self->priv->window;
#line 428 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp1_ = _tmp0_->angle_slider;
#line 428 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp2_ = gtk_range_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_range_get_type (), GtkRange));
#line 428 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->priv->photo_angle = _tmp2_;
#line 429 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp3_ = self->priv->window;
#line 429 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp4_ = _tmp3_->angle_slider;
#line 429 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp5_ = gtk_range_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_range_get_type (), GtkRange));
#line 429 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp6_ = g_strdup_printf ("%2.1f°", _tmp5_);
#line 429 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	tmp = _tmp6_;
#line 430 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp7_ = self->priv->window;
#line 430 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp8_ = _tmp7_->angle_label;
#line 430 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp9_ = tmp;
#line 430 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gtk_label_set_text (_tmp8_, _tmp9_);
#line 432 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp10_ = self->priv->slider_sched;
#line 432 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (_tmp10_ == NULL) {
#line 1876 "StraightenTool.c"
		OneShotScheduler* _tmp11_ = NULL;
#line 433 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp11_ = one_shot_scheduler_new ("straighten", _editing_tools_straighten_tool_on_slider_stopped_delayed_one_shot_callback, self);
#line 433 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_one_shot_scheduler_unref0 (self->priv->slider_sched);
#line 433 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		self->priv->slider_sched = _tmp11_;
#line 1884 "StraightenTool.c"
	}
#line 434 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp12_ = self->priv->slider_sched;
#line 434 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	one_shot_scheduler_after_timeout (_tmp12_, (guint) EDITING_TOOLS_STRAIGHTEN_TOOL_REPAINT_ON_STOP_DELAY_MSEC, TRUE);
#line 436 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->priv->use_high_qual = FALSE;
#line 438 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_straighten_tool_adjust_for_rotation (self);
#line 439 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_straighten_tool_update_rotated_surface (self);
#line 440 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp13_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 440 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_photo_canvas_repaint (_tmp13_);
#line 427 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_g_free0 (tmp);
#line 1902 "StraightenTool.c"
}


/**
     * @brief Called by the EditingHostPage when a resize event occurs.
     */
static void editing_tools_straighten_tool_on_resized_pixbuf (EditingToolsStraightenTool* self, Dimensions* old_dim, GdkPixbuf* scaled, GdkRectangle* scaled_position) {
#line 446 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_if_fail (EDITING_TOOLS_IS_STRAIGHTEN_TOOL (self));
#line 446 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_if_fail (old_dim != NULL);
#line 446 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_if_fail (GDK_IS_PIXBUF (scaled));
#line 446 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_if_fail (scaled_position != NULL);
#line 447 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_straighten_tool_prepare_image (self);
#line 1920 "StraightenTool.c"
}


/**
     * Returns a reference to the current StraightenTool instance's tool window;
     * the PhotoPage uses this to control the tool window's positioning, etc.
     */
static EditingToolsEditingToolWindow* editing_tools_straighten_tool_real_get_tool_window (EditingToolsEditingTool* base) {
	EditingToolsStraightenTool * self;
	EditingToolsEditingToolWindow* result = NULL;
	EditingToolsStraightenToolStraightenToolWindow* _tmp0_ = NULL;
	EditingToolsEditingToolWindow* _tmp1_ = NULL;
#line 454 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, EDITING_TOOLS_TYPE_STRAIGHTEN_TOOL, EditingToolsStraightenTool);
#line 455 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp0_ = self->priv->window;
#line 455 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, EDITING_TOOLS_TYPE_EDITING_TOOL_WINDOW, EditingToolsEditingToolWindow));
#line 455 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	result = _tmp1_;
#line 455 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	return result;
#line 1943 "StraightenTool.c"
}


/**
     * Draw the rotated photo and grid.
     */
static void editing_tools_straighten_tool_update_rotated_surface (EditingToolsStraightenTool* self) {
	cairo_surface_t* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gdouble _tmp4_ = 0.0;
	cairo_t* _tmp5_ = NULL;
	cairo_t* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
#line 461 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_if_fail (EDITING_TOOLS_IS_STRAIGHTEN_TOOL (self));
#line 462 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp0_ = self->priv->photo_surf;
#line 462 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp1_ = self->priv->rotate_ctx;
#line 462 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp2_ = self->priv->view_width;
#line 462 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp3_ = self->priv->view_height;
#line 462 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp4_ = self->priv->photo_angle;
#line 462 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_straighten_tool_draw_rotated_source (self, _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
#line 463 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp5_ = self->priv->rotate_ctx;
#line 463 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_set_line_width (_tmp5_, 1.0);
#line 464 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp6_ = self->priv->rotate_ctx;
#line 464 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp7_ = self->priv->view_width;
#line 464 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp8_ = self->priv->view_height;
#line 464 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_straighten_tool_draw_superimposed_grid (self, _tmp6_, _tmp7_, _tmp8_);
#line 1986 "StraightenTool.c"
}


/**
     * Render a smaller, rotated version of the image, with a grid superimposed over it.
     *
     * @param ctx The rendering context of a 'scratch' Cairo surface.  The tool makes its own
     *      surfaces and contexts so it can have things set up exactly like it wants them, so
     *      it's not used.
     */
static void editing_tools_straighten_tool_real_paint (EditingToolsEditingTool* base, cairo_t* ctx) {
	EditingToolsStraightenTool * self;
	gint w = 0;
	EditingToolsPhotoCanvas* _tmp0_ = NULL;
	GdkWindow* _tmp1_ = NULL;
	GdkWindow* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint h = 0;
	EditingToolsPhotoCanvas* _tmp5_ = NULL;
	GdkWindow* _tmp6_ = NULL;
	GdkWindow* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	EditingToolsPhotoCanvas* _tmp10_ = NULL;
	cairo_t* _tmp11_ = NULL;
	cairo_t* _tmp12_ = NULL;
	EditingToolsPhotoCanvas* _tmp13_ = NULL;
	cairo_t* _tmp14_ = NULL;
	cairo_t* _tmp15_ = NULL;
	EditingToolsPhotoCanvas* _tmp16_ = NULL;
	cairo_t* _tmp17_ = NULL;
	cairo_t* _tmp18_ = NULL;
	EditingToolsPhotoCanvas* _tmp19_ = NULL;
	cairo_t* _tmp20_ = NULL;
	cairo_t* _tmp21_ = NULL;
	EditingToolsPhotoCanvas* _tmp22_ = NULL;
	cairo_t* _tmp23_ = NULL;
	cairo_t* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	EditingToolsPhotoCanvas* _tmp27_ = NULL;
	cairo_t* _tmp28_ = NULL;
	cairo_t* _tmp29_ = NULL;
	cairo_surface_t* _tmp30_ = NULL;
	EditingToolsPhotoCanvas* _tmp31_ = NULL;
	cairo_t* _tmp32_ = NULL;
	cairo_t* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	EditingToolsPhotoCanvas* _tmp36_ = NULL;
	cairo_t* _tmp37_ = NULL;
	cairo_t* _tmp38_ = NULL;
	EditingToolsPhotoCanvas* _tmp39_ = NULL;
	cairo_t* _tmp40_ = NULL;
	cairo_t* _tmp41_ = NULL;
	EditingToolsPhotoCanvas* _tmp42_ = NULL;
	cairo_t* _tmp43_ = NULL;
	cairo_t* _tmp44_ = NULL;
	EditingToolsStraightenToolStraightenGuide* _tmp45_ = NULL;
	EditingToolsPhotoCanvas* _tmp46_ = NULL;
	cairo_t* _tmp47_ = NULL;
	cairo_t* _tmp48_ = NULL;
#line 474 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, EDITING_TOOLS_TYPE_STRAIGHTEN_TOOL, EditingToolsStraightenTool);
#line 474 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_if_fail (ctx != NULL);
#line 475 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 475 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp1_ = editing_tools_photo_canvas_get_drawing_window (_tmp0_);
#line 475 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp2_ = _tmp1_;
#line 475 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp3_ = gdk_window_get_width (_tmp2_);
#line 475 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp4_ = _tmp3_;
#line 475 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_g_object_unref0 (_tmp2_);
#line 475 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	w = _tmp4_;
#line 476 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 476 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp6_ = editing_tools_photo_canvas_get_drawing_window (_tmp5_);
#line 476 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp7_ = _tmp6_;
#line 476 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp8_ = gdk_window_get_height (_tmp7_);
#line 476 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp9_ = _tmp8_;
#line 476 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_g_object_unref0 (_tmp7_);
#line 476 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	h = _tmp9_;
#line 479 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp10_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 479 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp11_ = editing_tools_photo_canvas_get_default_ctx (_tmp10_);
#line 479 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp12_ = _tmp11_;
#line 479 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_identity_matrix (_tmp12_);
#line 479 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_cairo_destroy0 (_tmp12_);
#line 480 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp13_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 480 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp14_ = editing_tools_photo_canvas_get_default_ctx (_tmp13_);
#line 480 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp15_ = _tmp14_;
#line 480 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_set_source_rgba (_tmp15_, 0.0, 0.0, 0.0, 1.0);
#line 480 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_cairo_destroy0 (_tmp15_);
#line 481 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp16_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 481 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp17_ = editing_tools_photo_canvas_get_default_ctx (_tmp16_);
#line 481 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp18_ = _tmp17_;
#line 481 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_rectangle (_tmp18_, (gdouble) 0, (gdouble) 0, (gdouble) w, (gdouble) h);
#line 481 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_cairo_destroy0 (_tmp18_);
#line 482 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp19_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 482 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp20_ = editing_tools_photo_canvas_get_default_ctx (_tmp19_);
#line 482 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp21_ = _tmp20_;
#line 482 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_fill (_tmp21_);
#line 482 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_cairo_destroy0 (_tmp21_);
#line 485 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp22_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 485 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp23_ = editing_tools_photo_canvas_get_default_ctx (_tmp22_);
#line 485 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp24_ = _tmp23_;
#line 485 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp25_ = self->priv->view_width;
#line 485 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp26_ = self->priv->view_height;
#line 485 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_translate (_tmp24_, (w - _tmp25_) / 2.0, (h - _tmp26_) / 2.0);
#line 485 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_cairo_destroy0 (_tmp24_);
#line 486 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp27_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 486 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp28_ = editing_tools_photo_canvas_get_default_ctx (_tmp27_);
#line 486 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp29_ = _tmp28_;
#line 486 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp30_ = self->priv->rotate_surf;
#line 486 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_set_source_surface (_tmp29_, _tmp30_, (gdouble) 0, (gdouble) 0);
#line 486 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_cairo_destroy0 (_tmp29_);
#line 487 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp31_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 487 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp32_ = editing_tools_photo_canvas_get_default_ctx (_tmp31_);
#line 487 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp33_ = _tmp32_;
#line 487 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp34_ = self->priv->view_width;
#line 487 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp35_ = self->priv->view_height;
#line 487 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_rectangle (_tmp33_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp34_, (gdouble) _tmp35_);
#line 487 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_cairo_destroy0 (_tmp33_);
#line 488 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp36_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 488 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp37_ = editing_tools_photo_canvas_get_default_ctx (_tmp36_);
#line 488 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp38_ = _tmp37_;
#line 488 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_fill (_tmp38_);
#line 488 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_cairo_destroy0 (_tmp38_);
#line 489 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp39_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 489 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp40_ = editing_tools_photo_canvas_get_default_ctx (_tmp39_);
#line 489 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp41_ = _tmp40_;
#line 489 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_paint (_tmp41_);
#line 489 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_cairo_destroy0 (_tmp41_);
#line 493 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp42_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 493 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp43_ = editing_tools_photo_canvas_get_default_ctx (_tmp42_);
#line 493 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp44_ = _tmp43_;
#line 493 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_identity_matrix (_tmp44_);
#line 493 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_cairo_destroy0 (_tmp44_);
#line 495 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp45_ = self->priv->guide;
#line 495 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp46_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 495 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp47_ = editing_tools_photo_canvas_get_default_ctx (_tmp46_);
#line 495 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp48_ = _tmp47_;
#line 495 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_straighten_tool_straighten_guide_draw (_tmp45_, _tmp48_);
#line 495 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_cairo_destroy0 (_tmp48_);
#line 2204 "StraightenTool.c"
}


/**
     * Copy a rotated version of the source image onto the destination
     * context.
     *
     * @param src_surf A Cairo surface containing the source image.
     * @param dest_ctx The rendering context of the destination image.
     * @param src_width The width of the image data in src_surf in pixels.
     * @param src_height The height of the image data in src_surf in pixels.
     * @param angle The angle the source image should be rotated by, in degrees.
     */
static void editing_tools_straighten_tool_draw_rotated_source (EditingToolsStraightenTool* self, cairo_surface_t* src_surf, cairo_t* dest_ctx, gint src_width, gint src_height, gdouble angle) {
	gdouble angle_internal = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	cairo_t* _tmp2_ = NULL;
	cairo_t* _tmp3_ = NULL;
	cairo_t* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	cairo_t* _tmp7_ = NULL;
	cairo_t* _tmp8_ = NULL;
	cairo_t* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	cairo_t* _tmp12_ = NULL;
	gdouble _tmp13_ = 0.0;
	gdouble _tmp14_ = 0.0;
	cairo_t* _tmp15_ = NULL;
	gdouble _tmp16_ = 0.0;
	cairo_t* _tmp17_ = NULL;
	GdkPoint _tmp18_ = {0};
	gint _tmp19_ = 0;
	gdouble _tmp20_ = 0.0;
	GdkPoint _tmp21_ = {0};
	gint _tmp22_ = 0;
	gdouble _tmp23_ = 0.0;
	cairo_t* _tmp24_ = NULL;
	cairo_surface_t* _tmp25_ = NULL;
	cairo_filter_t _tmp26_ = 0;
	gboolean _tmp27_ = FALSE;
	cairo_t* _tmp28_ = NULL;
	cairo_pattern_t* _tmp29_ = NULL;
	cairo_t* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	cairo_t* _tmp33_ = NULL;
	cairo_t* _tmp34_ = NULL;
#line 508 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_if_fail (EDITING_TOOLS_IS_STRAIGHTEN_TOOL (self));
#line 508 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_if_fail (src_surf != NULL);
#line 508 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_if_fail (dest_ctx != NULL);
#line 510 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp0_ = angle;
#line 510 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp1_ = degrees_to_radians (_tmp0_);
#line 510 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	angle_internal = _tmp1_;
#line 514 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp2_ = dest_ctx;
#line 514 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_identity_matrix (_tmp2_);
#line 515 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp3_ = dest_ctx;
#line 515 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_set_source_rgba (_tmp3_, 0.0, 0.0, 0.0, 1.0);
#line 516 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp4_ = dest_ctx;
#line 516 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp5_ = self->priv->view_width;
#line 516 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp6_ = self->priv->view_height;
#line 516 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_rectangle (_tmp4_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp5_, (gdouble) _tmp6_);
#line 517 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp7_ = dest_ctx;
#line 517 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_fill (_tmp7_);
#line 522 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp8_ = dest_ctx;
#line 522 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_identity_matrix (_tmp8_);
#line 524 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp9_ = dest_ctx;
#line 524 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp10_ = self->priv->view_width;
#line 524 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp11_ = self->priv->view_height;
#line 524 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_translate (_tmp9_, (gdouble) (_tmp10_ / 2), (gdouble) (_tmp11_ / 2));
#line 525 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp12_ = dest_ctx;
#line 525 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp13_ = self->priv->rotate_scale;
#line 525 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp14_ = self->priv->rotate_scale;
#line 525 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_scale (_tmp12_, 1.0 / _tmp13_, 1.0 / _tmp14_);
#line 526 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp15_ = dest_ctx;
#line 526 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp16_ = angle_internal;
#line 526 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_rotate (_tmp15_, _tmp16_);
#line 527 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp17_ = dest_ctx;
#line 527 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp18_ = self->priv->rotated_center;
#line 527 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp19_ = _tmp18_.x;
#line 527 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp20_ = self->priv->preview_scale;
#line 527 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp21_ = self->priv->rotated_center;
#line 527 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp22_ = _tmp21_.y;
#line 527 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp23_ = self->priv->preview_scale;
#line 527 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_translate (_tmp17_, (-_tmp19_) * _tmp20_, (-_tmp22_) * _tmp23_);
#line 529 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp24_ = dest_ctx;
#line 529 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp25_ = src_surf;
#line 529 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_set_source_surface (_tmp24_, _tmp25_, (gdouble) 0, (gdouble) 0);
#line 530 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp27_ = self->priv->use_high_qual;
#line 530 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (_tmp27_) {
#line 530 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp26_ = CAIRO_FILTER_BEST;
#line 2341 "StraightenTool.c"
	} else {
#line 530 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp26_ = CAIRO_FILTER_NEAREST;
#line 2345 "StraightenTool.c"
	}
#line 530 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp28_ = dest_ctx;
#line 530 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp29_ = cairo_get_source (_tmp28_);
#line 530 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_pattern_set_filter (_tmp29_, _tmp26_);
#line 531 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp30_ = dest_ctx;
#line 531 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp31_ = src_width;
#line 531 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp32_ = src_height;
#line 531 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_rectangle (_tmp30_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp31_, (gdouble) _tmp32_);
#line 532 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp33_ = dest_ctx;
#line 532 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_fill (_tmp33_);
#line 533 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp34_ = dest_ctx;
#line 533 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_paint (_tmp34_);
#line 2369 "StraightenTool.c"
}


/**
     * Superimpose a faint grid over the supplied image.
     *
     * @param width The total width the grid should be drawn to.
     * @param height The total height the grid should be drawn to.
     * @param dest_ctx The rendering context of the destination image.
     */
static void editing_tools_straighten_tool_draw_superimposed_grid (EditingToolsStraightenTool* self, cairo_t* dest_ctx, gint width, gint height) {
	gint half_width = 0;
	gint _tmp0_ = 0;
	gint quarter_width = 0;
	gint _tmp1_ = 0;
	gint half_height = 0;
	gint _tmp2_ = 0;
	gint quarter_height = 0;
	gint _tmp3_ = 0;
	cairo_t* _tmp4_ = NULL;
	cairo_t* _tmp5_ = NULL;
	EditingToolsPhotoCanvas* _tmp6_ = NULL;
	cairo_t* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	EditingToolsPhotoCanvas* _tmp9_ = NULL;
	cairo_t* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	EditingToolsPhotoCanvas* _tmp12_ = NULL;
	cairo_t* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	EditingToolsPhotoCanvas* _tmp16_ = NULL;
	cairo_t* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	EditingToolsPhotoCanvas* _tmp19_ = NULL;
	cairo_t* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	EditingToolsPhotoCanvas* _tmp22_ = NULL;
	cairo_t* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	cairo_t* _tmp26_ = NULL;
	EditingToolsPhotoCanvas* _tmp27_ = NULL;
	cairo_t* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	EditingToolsPhotoCanvas* _tmp30_ = NULL;
	cairo_t* _tmp31_ = NULL;
	gint _tmp32_ = 0;
	EditingToolsPhotoCanvas* _tmp33_ = NULL;
	cairo_t* _tmp34_ = NULL;
	gint _tmp35_ = 0;
	EditingToolsPhotoCanvas* _tmp36_ = NULL;
	cairo_t* _tmp37_ = NULL;
	gint _tmp38_ = 0;
#line 543 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_if_fail (EDITING_TOOLS_IS_STRAIGHTEN_TOOL (self));
#line 543 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_if_fail (dest_ctx != NULL);
#line 544 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp0_ = width;
#line 544 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	half_width = _tmp0_ / 2;
#line 545 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp1_ = width;
#line 545 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	quarter_width = _tmp1_ / 4;
#line 547 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp2_ = height;
#line 547 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	half_height = _tmp2_ / 2;
#line 548 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp3_ = height;
#line 548 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	quarter_height = _tmp3_ / 4;
#line 550 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp4_ = dest_ctx;
#line 550 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_identity_matrix (_tmp4_);
#line 551 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp5_ = dest_ctx;
#line 551 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_set_source_rgba (_tmp5_, 1.0, 1.0, 1.0, 1.0);
#line 553 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 553 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp7_ = dest_ctx;
#line 553 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp8_ = width;
#line 553 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_photo_canvas_draw_horizontal_line (_tmp6_, _tmp7_, 0, 0, _tmp8_, FALSE);
#line 554 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp9_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 554 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp10_ = dest_ctx;
#line 554 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp11_ = width;
#line 554 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_photo_canvas_draw_horizontal_line (_tmp9_, _tmp10_, 0, half_height, _tmp11_, FALSE);
#line 555 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp12_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 555 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp13_ = dest_ctx;
#line 555 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp14_ = self->priv->view_height;
#line 555 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp15_ = width;
#line 555 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_photo_canvas_draw_horizontal_line (_tmp12_, _tmp13_, 0, _tmp14_ - 1, _tmp15_, FALSE);
#line 557 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp16_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 557 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp17_ = dest_ctx;
#line 557 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp18_ = height;
#line 557 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_photo_canvas_draw_vertical_line (_tmp16_, _tmp17_, 0, 0, _tmp18_ + 1, FALSE);
#line 558 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp19_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 558 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp20_ = dest_ctx;
#line 558 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp21_ = height;
#line 558 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_photo_canvas_draw_vertical_line (_tmp19_, _tmp20_, half_width, 0, _tmp21_ + 1, FALSE);
#line 559 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp22_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 559 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp23_ = dest_ctx;
#line 559 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp24_ = width;
#line 559 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp25_ = height;
#line 559 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_photo_canvas_draw_vertical_line (_tmp22_, _tmp23_, _tmp24_ - 1, 0, _tmp25_ + 1, FALSE);
#line 561 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp26_ = dest_ctx;
#line 561 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_set_source_rgba (_tmp26_, 1.0, 1.0, 1.0, 0.33);
#line 563 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp27_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 563 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp28_ = dest_ctx;
#line 563 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp29_ = width;
#line 563 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_photo_canvas_draw_horizontal_line (_tmp27_, _tmp28_, 0, quarter_height, _tmp29_, FALSE);
#line 564 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp30_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 564 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp31_ = dest_ctx;
#line 564 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp32_ = width;
#line 564 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_photo_canvas_draw_horizontal_line (_tmp30_, _tmp31_, 0, half_height + quarter_height, _tmp32_, FALSE);
#line 565 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp33_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 565 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp34_ = dest_ctx;
#line 565 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp35_ = height;
#line 565 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_photo_canvas_draw_vertical_line (_tmp33_, _tmp34_, quarter_width, 0, _tmp35_, FALSE);
#line 566 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp36_ = G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool)->canvas;
#line 566 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp37_ = dest_ctx;
#line 566 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp38_ = height;
#line 566 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_photo_canvas_draw_vertical_line (_tmp36_, _tmp37_, half_width + quarter_width, 0, _tmp38_, FALSE);
#line 2540 "StraightenTool.c"
}


static void editing_tools_straighten_tool_straighten_guide_reset (EditingToolsStraightenToolStraightenGuide* self, gint x, gint y, gdouble angle) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_[2] = {0};
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_[2] = {0};
	gdouble _tmp6_ = 0.0;
#line 31 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_if_fail (EDITING_TOOLS_STRAIGHTEN_TOOL_IS_STRAIGHTEN_GUIDE (self));
#line 32 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp0_ = x;
#line 32 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp1_ = x;
#line 32 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp2_[0] = _tmp0_;
#line 32 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp2_[1] = _tmp1_;
#line 32 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	memcpy (self->priv->x, _tmp2_, 2 * sizeof (gint));
#line 33 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp3_ = y;
#line 33 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp4_ = y;
#line 33 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp5_[0] = _tmp3_;
#line 33 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp5_[1] = _tmp4_;
#line 33 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	memcpy (self->priv->y, _tmp5_, 2 * sizeof (gint));
#line 34 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->priv->is_active = TRUE;
#line 35 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp6_ = angle;
#line 35 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->priv->angle0 = _tmp6_;
#line 2580 "StraightenTool.c"
}


static gboolean editing_tools_straighten_tool_straighten_guide_update (EditingToolsStraightenToolStraightenGuide* self, gint x, gint y) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 38 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_val_if_fail (EDITING_TOOLS_STRAIGHTEN_TOOL_IS_STRAIGHTEN_GUIDE (self), FALSE);
#line 39 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp0_ = self->priv->is_active;
#line 39 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (_tmp0_) {
#line 2593 "StraightenTool.c"
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 40 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp1_ = x;
#line 40 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		self->priv->x[1] = _tmp1_;
#line 40 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp2_ = self->priv->x[1];
#line 41 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp3_ = y;
#line 41 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		self->priv->y[1] = _tmp3_;
#line 41 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp4_ = self->priv->y[1];
#line 42 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		result = TRUE;
#line 42 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		return result;
#line 2614 "StraightenTool.c"
	}
#line 45 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	result = FALSE;
#line 45 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	return result;
#line 2620 "StraightenTool.c"
}


static void editing_tools_straighten_tool_straighten_guide_clear (EditingToolsStraightenToolStraightenGuide* self) {
#line 48 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_if_fail (EDITING_TOOLS_STRAIGHTEN_TOOL_IS_STRAIGHTEN_GUIDE (self));
#line 49 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->priv->is_active = FALSE;
#line 2629 "StraightenTool.c"
}


static gdouble* _double_dup (gdouble* self) {
	gdouble* dup;
#line 62 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	dup = g_new0 (gdouble, 1);
#line 62 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	memcpy (dup, self, sizeof (gdouble));
#line 62 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	return dup;
#line 2641 "StraightenTool.c"
}


static gpointer __double_dup0 (gpointer self) {
#line 62 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	return self ? _double_dup (self) : NULL;
#line 2648 "StraightenTool.c"
}


static gdouble* editing_tools_straighten_tool_straighten_guide_get_angle (EditingToolsStraightenToolStraightenGuide* self) {
	gdouble* result = NULL;
	gdouble dx = 0.0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gdouble dy = 0.0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
#line 52 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_val_if_fail (EDITING_TOOLS_STRAIGHTEN_TOOL_IS_STRAIGHTEN_GUIDE (self), NULL);
#line 53 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp0_ = self->priv->x[1];
#line 53 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp1_ = self->priv->x[0];
#line 53 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	dx = (gdouble) (_tmp0_ - _tmp1_);
#line 54 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp2_ = self->priv->y[1];
#line 54 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp3_ = self->priv->y[0];
#line 54 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	dy = (gdouble) (_tmp2_ - _tmp3_);
#line 57 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp4_ = dy;
#line 57 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp5_ = dy;
#line 57 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp6_ = dx;
#line 57 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp7_ = dx;
#line 57 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (((_tmp4_ * _tmp5_) + (_tmp6_ * _tmp7_)) < ((gdouble) 40)) {
#line 58 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		result = NULL;
#line 58 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		return result;
#line 2696 "StraightenTool.c"
	}
#line 61 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp8_ = dy;
#line 61 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp9_ = fabs (_tmp8_);
#line 61 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp10_ = dx;
#line 61 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp11_ = fabs (_tmp10_);
#line 61 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (_tmp9_ > _tmp11_) {
#line 2708 "StraightenTool.c"
		gdouble _tmp12_ = 0.0;
		gdouble _tmp13_ = 0.0;
		gdouble _tmp14_ = 0.0;
		gdouble _tmp15_ = 0.0;
		gdouble _tmp16_ = 0.0;
		gdouble* _tmp17_ = NULL;
#line 62 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp12_ = self->priv->angle0;
#line 62 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp13_ = dx;
#line 62 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp14_ = dy;
#line 62 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp15_ = atan (_tmp13_ / _tmp14_);
#line 62 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp16_ = _tmp12_ + ((_tmp15_ / G_PI) * 180);
#line 62 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp17_ = __double_dup0 (&_tmp16_);
#line 62 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		result = _tmp17_;
#line 62 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		return result;
#line 2731 "StraightenTool.c"
	} else {
		gdouble _tmp18_ = 0.0;
		gdouble _tmp19_ = 0.0;
		gdouble _tmp20_ = 0.0;
		gdouble _tmp21_ = 0.0;
		gdouble _tmp22_ = 0.0;
		gdouble* _tmp23_ = NULL;
#line 64 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp18_ = self->priv->angle0;
#line 64 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp19_ = dy;
#line 64 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp20_ = dx;
#line 64 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp21_ = atan (_tmp19_ / _tmp20_);
#line 64 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp22_ = _tmp18_ - ((_tmp21_ / G_PI) * 180);
#line 64 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp23_ = __double_dup0 (&_tmp22_);
#line 64 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		result = _tmp23_;
#line 64 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		return result;
#line 2755 "StraightenTool.c"
	}
}


static void editing_tools_straighten_tool_straighten_guide_draw (EditingToolsStraightenToolStraightenGuide* self, cairo_t* ctx) {
	gboolean _tmp0_ = FALSE;
	gdouble* _tmp1_ = NULL;
	gdouble* _tmp2_ = NULL;
	gdouble angle = 0.0;
	gdouble* _tmp5_ = NULL;
	gdouble* _tmp6_ = NULL;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	gdouble alpha = 0.0;
	gboolean _tmp9_ = FALSE;
	gdouble _tmp10_ = 0.0;
	cairo_t* _tmp12_ = NULL;
	gdouble _tmp13_ = 0.0;
	cairo_t* _tmp14_ = NULL;
	gdouble _tmp15_ = 0.0;
	cairo_t* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	cairo_t* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	cairo_t* _tmp22_ = NULL;
	cairo_t* _tmp23_ = NULL;
	gdouble _tmp24_ = 0.0;
	cairo_t* _tmp25_ = NULL;
	gdouble _tmp26_ = 0.0;
	cairo_t* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	cairo_t* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	cairo_t* _tmp33_ = NULL;
#line 67 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_if_fail (EDITING_TOOLS_STRAIGHTEN_TOOL_IS_STRAIGHTEN_GUIDE (self));
#line 67 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_if_fail (ctx != NULL);
#line 68 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp0_ = self->priv->is_active;
#line 68 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (!_tmp0_) {
#line 69 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		return;
#line 2804 "StraightenTool.c"
	}
#line 71 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp2_ = editing_tools_straighten_tool_straighten_guide_get_angle (self);
#line 71 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp1_ = _tmp2_;
#line 71 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (_tmp1_ == NULL) {
#line 2812 "StraightenTool.c"
		gdouble _tmp3_ = 0.0;
		gdouble* _tmp4_ = NULL;
#line 71 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp3_ = 0.0;
#line 71 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp4_ = __double_dup0 (&_tmp3_);
#line 71 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_g_free0 (_tmp1_);
#line 71 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp1_ = _tmp4_;
#line 2823 "StraightenTool.c"
	}
#line 71 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp5_ = _tmp1_;
#line 71 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp1_ = NULL;
#line 71 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp6_ = _tmp5_;
#line 71 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp7_ = *_tmp6_;
#line 71 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_g_free0 (_tmp6_);
#line 71 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	angle = _tmp7_;
#line 72 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp8_ = angle;
#line 72 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (_tmp8_ == 0.0) {
#line 73 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_g_free0 (_tmp1_);
#line 73 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		return;
#line 2845 "StraightenTool.c"
	}
#line 75 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	alpha = 1.0;
#line 76 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp10_ = angle;
#line 76 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (_tmp10_ < EDITING_TOOLS_STRAIGHTEN_TOOL_MIN_ANGLE) {
#line 76 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp9_ = TRUE;
#line 2855 "StraightenTool.c"
	} else {
		gdouble _tmp11_ = 0.0;
#line 76 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp11_ = angle;
#line 76 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		_tmp9_ = _tmp11_ > EDITING_TOOLS_STRAIGHTEN_TOOL_MAX_ANGLE;
#line 2862 "StraightenTool.c"
	}
#line 76 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (_tmp9_) {
#line 77 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		alpha = 0.35;
#line 2868 "StraightenTool.c"
	}
#line 81 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp12_ = ctx;
#line 81 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp13_ = alpha;
#line 81 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_set_source_rgba (_tmp12_, 0.0, 0.0, 0.0, _tmp13_);
#line 82 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp14_ = ctx;
#line 82 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp15_ = EDITING_TOOLS_STRAIGHTEN_TOOL_GUIDE_DASH[0];
#line 82 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_set_dash (_tmp14_, EDITING_TOOLS_STRAIGHTEN_TOOL_GUIDE_DASH, G_N_ELEMENTS (EDITING_TOOLS_STRAIGHTEN_TOOL_GUIDE_DASH), _tmp15_ / 2);
#line 83 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp16_ = ctx;
#line 83 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp17_ = self->priv->x[0];
#line 83 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp18_ = self->priv->y[0];
#line 83 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_move_to (_tmp16_, _tmp17_ + 0.5, _tmp18_ + 0.5);
#line 84 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp19_ = ctx;
#line 84 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp20_ = self->priv->x[1];
#line 84 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp21_ = self->priv->y[1];
#line 84 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_line_to (_tmp19_, _tmp20_ + 0.5, _tmp21_ + 0.5);
#line 85 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp22_ = ctx;
#line 85 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_stroke (_tmp22_);
#line 86 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp23_ = ctx;
#line 86 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp24_ = EDITING_TOOLS_STRAIGHTEN_TOOL_GUIDE_DASH[0];
#line 86 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_set_dash (_tmp23_, EDITING_TOOLS_STRAIGHTEN_TOOL_GUIDE_DASH, G_N_ELEMENTS (EDITING_TOOLS_STRAIGHTEN_TOOL_GUIDE_DASH), (-_tmp24_) / 2);
#line 87 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp25_ = ctx;
#line 87 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp26_ = alpha;
#line 87 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_set_source_rgba (_tmp25_, 1.0, 1.0, 1.0, _tmp26_);
#line 88 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp27_ = ctx;
#line 88 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp28_ = self->priv->x[0];
#line 88 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp29_ = self->priv->y[0];
#line 88 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_move_to (_tmp27_, _tmp28_ + 0.5, _tmp29_ + 0.5);
#line 89 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp30_ = ctx;
#line 89 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp31_ = self->priv->x[1];
#line 89 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp32_ = self->priv->y[1];
#line 89 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_line_to (_tmp30_, _tmp31_ + 0.5, _tmp32_ + 0.5);
#line 90 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp33_ = ctx;
#line 90 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	cairo_stroke (_tmp33_);
#line 67 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_g_free0 (_tmp1_);
#line 2936 "StraightenTool.c"
}


static EditingToolsStraightenToolStraightenGuide* editing_tools_straighten_tool_straighten_guide_construct (GType object_type) {
	EditingToolsStraightenToolStraightenGuide* self = NULL;
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self = (EditingToolsStraightenToolStraightenGuide*) g_type_create_instance (object_type);
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	return self;
#line 2946 "StraightenTool.c"
}


static EditingToolsStraightenToolStraightenGuide* editing_tools_straighten_tool_straighten_guide_new (void) {
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	return editing_tools_straighten_tool_straighten_guide_construct (EDITING_TOOLS_STRAIGHTEN_TOOL_TYPE_STRAIGHTEN_GUIDE);
#line 2953 "StraightenTool.c"
}


static void editing_tools_straighten_tool_value_straighten_guide_init (GValue* value) {
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	value->data[0].v_pointer = NULL;
#line 2960 "StraightenTool.c"
}


static void editing_tools_straighten_tool_value_straighten_guide_free_value (GValue* value) {
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (value->data[0].v_pointer) {
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		editing_tools_straighten_tool_straighten_guide_unref (value->data[0].v_pointer);
#line 2969 "StraightenTool.c"
	}
}


static void editing_tools_straighten_tool_value_straighten_guide_copy_value (const GValue* src_value, GValue* dest_value) {
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (src_value->data[0].v_pointer) {
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		dest_value->data[0].v_pointer = editing_tools_straighten_tool_straighten_guide_ref (src_value->data[0].v_pointer);
#line 2979 "StraightenTool.c"
	} else {
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2983 "StraightenTool.c"
	}
}


static gpointer editing_tools_straighten_tool_value_straighten_guide_peek_pointer (const GValue* value) {
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	return value->data[0].v_pointer;
#line 2991 "StraightenTool.c"
}


static gchar* editing_tools_straighten_tool_value_straighten_guide_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (collect_values[0].v_pointer) {
#line 2998 "StraightenTool.c"
		EditingToolsStraightenToolStraightenGuide* object;
		object = collect_values[0].v_pointer;
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		if (object->parent_instance.g_class == NULL) {
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3005 "StraightenTool.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3009 "StraightenTool.c"
		}
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		value->data[0].v_pointer = editing_tools_straighten_tool_straighten_guide_ref (object);
#line 3013 "StraightenTool.c"
	} else {
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		value->data[0].v_pointer = NULL;
#line 3017 "StraightenTool.c"
	}
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	return NULL;
#line 3021 "StraightenTool.c"
}


static gchar* editing_tools_straighten_tool_value_straighten_guide_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	EditingToolsStraightenToolStraightenGuide** object_p;
	object_p = collect_values[0].v_pointer;
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (!object_p) {
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3032 "StraightenTool.c"
	}
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (!value->data[0].v_pointer) {
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		*object_p = NULL;
#line 3038 "StraightenTool.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		*object_p = value->data[0].v_pointer;
#line 3042 "StraightenTool.c"
	} else {
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		*object_p = editing_tools_straighten_tool_straighten_guide_ref (value->data[0].v_pointer);
#line 3046 "StraightenTool.c"
	}
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	return NULL;
#line 3050 "StraightenTool.c"
}


static GParamSpec* editing_tools_straighten_tool_param_spec_straighten_guide (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	EditingToolsStraightenToolParamSpecStraightenGuide* spec;
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_val_if_fail (g_type_is_a (object_type, EDITING_TOOLS_STRAIGHTEN_TOOL_TYPE_STRAIGHTEN_GUIDE), NULL);
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	return G_PARAM_SPEC (spec);
#line 3064 "StraightenTool.c"
}


static gpointer editing_tools_straighten_tool_value_get_straighten_guide (const GValue* value) {
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EDITING_TOOLS_STRAIGHTEN_TOOL_TYPE_STRAIGHTEN_GUIDE), NULL);
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	return value->data[0].v_pointer;
#line 3073 "StraightenTool.c"
}


static void editing_tools_straighten_tool_value_set_straighten_guide (GValue* value, gpointer v_object) {
	EditingToolsStraightenToolStraightenGuide* old;
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EDITING_TOOLS_STRAIGHTEN_TOOL_TYPE_STRAIGHTEN_GUIDE));
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	old = value->data[0].v_pointer;
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (v_object) {
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, EDITING_TOOLS_STRAIGHTEN_TOOL_TYPE_STRAIGHTEN_GUIDE));
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		value->data[0].v_pointer = v_object;
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		editing_tools_straighten_tool_straighten_guide_ref (value->data[0].v_pointer);
#line 3093 "StraightenTool.c"
	} else {
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		value->data[0].v_pointer = NULL;
#line 3097 "StraightenTool.c"
	}
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (old) {
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		editing_tools_straighten_tool_straighten_guide_unref (old);
#line 3103 "StraightenTool.c"
	}
}


static void editing_tools_straighten_tool_value_take_straighten_guide (GValue* value, gpointer v_object) {
	EditingToolsStraightenToolStraightenGuide* old;
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EDITING_TOOLS_STRAIGHTEN_TOOL_TYPE_STRAIGHTEN_GUIDE));
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	old = value->data[0].v_pointer;
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (v_object) {
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, EDITING_TOOLS_STRAIGHTEN_TOOL_TYPE_STRAIGHTEN_GUIDE));
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		value->data[0].v_pointer = v_object;
#line 3122 "StraightenTool.c"
	} else {
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		value->data[0].v_pointer = NULL;
#line 3126 "StraightenTool.c"
	}
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (old) {
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		editing_tools_straighten_tool_straighten_guide_unref (old);
#line 3132 "StraightenTool.c"
	}
}


static void editing_tools_straighten_tool_straighten_guide_class_init (EditingToolsStraightenToolStraightenGuideClass * klass) {
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_straighten_tool_straighten_guide_parent_class = g_type_class_peek_parent (klass);
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	((EditingToolsStraightenToolStraightenGuideClass *) klass)->finalize = editing_tools_straighten_tool_straighten_guide_finalize;
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_type_class_add_private (klass, sizeof (EditingToolsStraightenToolStraightenGuidePrivate));
#line 3144 "StraightenTool.c"
}


static void editing_tools_straighten_tool_straighten_guide_instance_init (EditingToolsStraightenToolStraightenGuide * self) {
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->priv = EDITING_TOOLS_STRAIGHTEN_TOOL_STRAIGHTEN_GUIDE_GET_PRIVATE (self);
#line 26 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->priv->is_active = FALSE;
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->ref_count = 1;
#line 3155 "StraightenTool.c"
}


static void editing_tools_straighten_tool_straighten_guide_finalize (EditingToolsStraightenToolStraightenGuide* obj) {
	EditingToolsStraightenToolStraightenGuide * self;
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EDITING_TOOLS_STRAIGHTEN_TOOL_TYPE_STRAIGHTEN_GUIDE, EditingToolsStraightenToolStraightenGuide);
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_signal_handlers_destroy (self);
#line 3165 "StraightenTool.c"
}


static GType editing_tools_straighten_tool_straighten_guide_get_type (void) {
	static volatile gsize editing_tools_straighten_tool_straighten_guide_type_id__volatile = 0;
	if (g_once_init_enter (&editing_tools_straighten_tool_straighten_guide_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { editing_tools_straighten_tool_value_straighten_guide_init, editing_tools_straighten_tool_value_straighten_guide_free_value, editing_tools_straighten_tool_value_straighten_guide_copy_value, editing_tools_straighten_tool_value_straighten_guide_peek_pointer, "p", editing_tools_straighten_tool_value_straighten_guide_collect_value, "p", editing_tools_straighten_tool_value_straighten_guide_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (EditingToolsStraightenToolStraightenGuideClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) editing_tools_straighten_tool_straighten_guide_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EditingToolsStraightenToolStraightenGuide), 0, (GInstanceInitFunc) editing_tools_straighten_tool_straighten_guide_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType editing_tools_straighten_tool_straighten_guide_type_id;
		editing_tools_straighten_tool_straighten_guide_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EditingToolsStraightenToolStraightenGuide", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&editing_tools_straighten_tool_straighten_guide_type_id__volatile, editing_tools_straighten_tool_straighten_guide_type_id);
	}
	return editing_tools_straighten_tool_straighten_guide_type_id__volatile;
}


static gpointer editing_tools_straighten_tool_straighten_guide_ref (gpointer instance) {
	EditingToolsStraightenToolStraightenGuide* self;
	self = instance;
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_atomic_int_inc (&self->ref_count);
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	return instance;
#line 3190 "StraightenTool.c"
}


static void editing_tools_straighten_tool_straighten_guide_unref (gpointer instance) {
	EditingToolsStraightenToolStraightenGuide* self;
	self = instance;
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		EDITING_TOOLS_STRAIGHTEN_TOOL_STRAIGHTEN_GUIDE_GET_CLASS (self)->finalize (self);
#line 25 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3203 "StraightenTool.c"
	}
}


/**
         * Prepare straighten tool's window for use and initialize all its controls.
         *
         * @param container The application's main window.
         */
static void _editing_tools_straighten_tool_straighten_tool_window_on_reset_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 147 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_straighten_tool_straighten_tool_window_on_reset_clicked ((EditingToolsStraightenToolStraightenToolWindow*) self);
#line 3216 "StraightenTool.c"
}


static EditingToolsStraightenToolStraightenToolWindow* editing_tools_straighten_tool_straighten_tool_window_construct (GType object_type, GtkWindow* container) {
	EditingToolsStraightenToolStraightenToolWindow * self = NULL;
	GtkWindow* _tmp0_ = NULL;
	GtkScale* _tmp1_ = NULL;
	GtkScale* _tmp2_ = NULL;
	GtkScale* _tmp3_ = NULL;
	GtkScale* _tmp4_ = NULL;
	GtkLabel* _tmp5_ = NULL;
	GtkLabel* _tmp6_ = NULL;
	GtkLabel* _tmp7_ = NULL;
	GtkLabel* _tmp8_ = NULL;
	GtkLabel* _tmp9_ = NULL;
	GtkLabel* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	GtkBox* slider_layout = NULL;
	GtkBox* _tmp14_ = NULL;
	GtkScale* _tmp15_ = NULL;
	GtkBox* button_layout = NULL;
	GtkBox* _tmp16_ = NULL;
	GtkButton* _tmp17_ = NULL;
	GtkButton* _tmp18_ = NULL;
	GtkButton* _tmp19_ = NULL;
	GtkButton* _tmp20_ = NULL;
	GtkButton* _tmp21_ = NULL;
	GtkButton* _tmp22_ = NULL;
	GtkBox* main_layout = NULL;
	GtkBox* _tmp23_ = NULL;
	GtkLabel* _tmp24_ = NULL;
	GtkLabel* _tmp25_ = NULL;
	GtkButton* _tmp26_ = NULL;
#line 109 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_val_if_fail (GTK_IS_WINDOW (container), NULL);
#line 110 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp0_ = container;
#line 110 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self = (EditingToolsStraightenToolStraightenToolWindow*) editing_tools_editing_tool_window_construct (object_type, _tmp0_);
#line 112 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp1_ = self->angle_slider;
#line 112 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gtk_range_set_min_slider_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_range_get_type (), GtkRange), EDITING_TOOLS_STRAIGHTEN_TOOL_MIN_SLIDER_SIZE);
#line 113 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp2_ = self->angle_slider;
#line 113 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), EDITING_TOOLS_STRAIGHTEN_TOOL_MIN_SLIDER_SIZE, -1);
#line 114 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp3_ = self->angle_slider;
#line 114 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gtk_range_set_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_range_get_type (), GtkRange), 0.0);
#line 115 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp4_ = self->angle_slider;
#line 115 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gtk_scale_set_draw_value (_tmp4_, FALSE);
#line 117 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp5_ = self->description_label;
#line 117 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gtk_widget_set_margin_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget), EDITING_TOOLS_STRAIGHTEN_TOOL_STRAIGHTEN_TOOL_WINDOW_CONTROL_SPACING);
#line 118 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp6_ = self->description_label;
#line 118 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gtk_widget_set_margin_end (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget), EDITING_TOOLS_STRAIGHTEN_TOOL_STRAIGHTEN_TOOL_WINDOW_CONTROL_SPACING);
#line 119 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp7_ = self->description_label;
#line 119 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gtk_widget_set_margin_top (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), 0);
#line 120 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp8_ = self->description_label;
#line 120 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gtk_widget_set_margin_bottom (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget), 0);
#line 122 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp9_ = self->angle_label;
#line 122 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gtk_widget_set_margin_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), 0);
#line 123 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp10_ = self->angle_label;
#line 123 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gtk_widget_set_margin_end (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), 0);
#line 124 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp11_ = self->angle_label;
#line 124 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gtk_widget_set_margin_top (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget), 0);
#line 125 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp12_ = self->angle_label;
#line 125 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gtk_widget_set_margin_bottom (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget), 0);
#line 126 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp13_ = self->angle_label;
#line 126 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget), EDITING_TOOLS_STRAIGHTEN_TOOL_MIN_LABEL_SIZE, -1);
#line 128 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp14_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, EDITING_TOOLS_STRAIGHTEN_TOOL_STRAIGHTEN_TOOL_WINDOW_CONTROL_SPACING);
#line 128 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_object_ref_sink (_tmp14_);
#line 128 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	slider_layout = _tmp14_;
#line 129 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp15_ = self->angle_slider;
#line 129 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gtk_box_pack_start (slider_layout, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget), TRUE, TRUE, (guint) 0);
#line 131 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp16_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, EDITING_TOOLS_STRAIGHTEN_TOOL_STRAIGHTEN_TOOL_WINDOW_CONTROL_SPACING);
#line 131 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_object_ref_sink (_tmp16_);
#line 131 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	button_layout = _tmp16_;
#line 132 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp17_ = self->cancel_button;
#line 132 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget), EDITING_TOOLS_STRAIGHTEN_TOOL_MIN_BUTTON_SIZE, -1);
#line 133 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp18_ = self->reset_button;
#line 133 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget), EDITING_TOOLS_STRAIGHTEN_TOOL_MIN_BUTTON_SIZE, -1);
#line 134 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp19_ = self->ok_button;
#line 134 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget), EDITING_TOOLS_STRAIGHTEN_TOOL_MIN_BUTTON_SIZE, -1);
#line 135 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp20_ = self->cancel_button;
#line 135 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gtk_box_pack_start (button_layout, G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget), TRUE, TRUE, (guint) 0);
#line 136 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp21_ = self->reset_button;
#line 136 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gtk_box_pack_start (button_layout, G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget), TRUE, TRUE, (guint) 0);
#line 137 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp22_ = self->ok_button;
#line 137 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gtk_box_pack_start (button_layout, G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget), TRUE, TRUE, (guint) 0);
#line 139 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp23_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
#line 139 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_object_ref_sink (_tmp23_);
#line 139 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	main_layout = _tmp23_;
#line 140 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp24_ = self->description_label;
#line 140 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gtk_box_pack_start (main_layout, G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_widget_get_type (), GtkWidget), TRUE, TRUE, (guint) 0);
#line 141 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gtk_box_pack_start (main_layout, G_TYPE_CHECK_INSTANCE_CAST (slider_layout, gtk_widget_get_type (), GtkWidget), TRUE, TRUE, (guint) 0);
#line 142 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp25_ = self->angle_label;
#line 142 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gtk_box_pack_start (main_layout, G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_widget_get_type (), GtkWidget), TRUE, TRUE, (guint) 0);
#line 143 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gtk_box_pack_start (main_layout, G_TYPE_CHECK_INSTANCE_CAST (button_layout, gtk_widget_get_type (), GtkWidget), TRUE, TRUE, (guint) 0);
#line 145 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (main_layout, gtk_widget_get_type (), GtkWidget));
#line 147 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp26_ = self->reset_button;
#line 147 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_signal_connect_object (_tmp26_, "clicked", (GCallback) _editing_tools_straighten_tool_straighten_tool_window_on_reset_clicked_gtk_button_clicked, self, 0);
#line 149 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gtk_window_set_position (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), GTK_WIN_POS_CENTER_ON_PARENT);
#line 109 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_g_object_unref0 (main_layout);
#line 109 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_g_object_unref0 (button_layout);
#line 109 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_g_object_unref0 (slider_layout);
#line 109 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	return self;
#line 3384 "StraightenTool.c"
}


static EditingToolsStraightenToolStraightenToolWindow* editing_tools_straighten_tool_straighten_tool_window_new (GtkWindow* container) {
#line 109 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	return editing_tools_straighten_tool_straighten_tool_window_construct (EDITING_TOOLS_STRAIGHTEN_TOOL_TYPE_STRAIGHTEN_TOOL_WINDOW, container);
#line 3391 "StraightenTool.c"
}


static void editing_tools_straighten_tool_straighten_tool_window_on_reset_clicked (EditingToolsStraightenToolStraightenToolWindow* self) {
	GtkScale* _tmp0_ = NULL;
#line 152 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_return_if_fail (EDITING_TOOLS_STRAIGHTEN_TOOL_IS_STRAIGHTEN_TOOL_WINDOW (self));
#line 153 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp0_ = self->angle_slider;
#line 153 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	gtk_range_set_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_range_get_type (), GtkRange), 0.0);
#line 3403 "StraightenTool.c"
}


static void editing_tools_straighten_tool_straighten_tool_window_class_init (EditingToolsStraightenToolStraightenToolWindowClass * klass) {
#line 94 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_straighten_tool_straighten_tool_window_parent_class = g_type_class_peek_parent (klass);
#line 94 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	G_OBJECT_CLASS (klass)->finalize = editing_tools_straighten_tool_straighten_tool_window_finalize;
#line 3412 "StraightenTool.c"
}


static void editing_tools_straighten_tool_straighten_tool_window_instance_init (EditingToolsStraightenToolStraightenToolWindow * self) {
	GtkScale* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GtkButton* _tmp5_ = NULL;
	GtkButton* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkButton* _tmp8_ = NULL;
#line 97 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp0_ = (GtkScale*) gtk_scale_new_with_range (GTK_ORIENTATION_HORIZONTAL, EDITING_TOOLS_STRAIGHTEN_TOOL_MIN_ANGLE, EDITING_TOOLS_STRAIGHTEN_TOOL_MAX_ANGLE, EDITING_TOOLS_STRAIGHTEN_TOOL_INCREMENT);
#line 97 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_object_ref_sink (_tmp0_);
#line 97 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->angle_slider = _tmp0_;
#line 98 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp1_ = (GtkLabel*) gtk_label_new ("");
#line 98 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_object_ref_sink (_tmp1_);
#line 98 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->angle_label = _tmp1_;
#line 99 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp2_ = _ ("Angle:");
#line 99 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp3_ = (GtkLabel*) gtk_label_new (_tmp2_);
#line 99 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_object_ref_sink (_tmp3_);
#line 99 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->description_label = _tmp3_;
#line 100 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp4_ = _ ("_Straighten");
#line 100 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp5_ = (GtkButton*) gtk_button_new_with_mnemonic (_tmp4_);
#line 100 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_object_ref_sink (_tmp5_);
#line 100 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->ok_button = _tmp5_;
#line 101 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp6_ = (GtkButton*) gtk_button_new_with_mnemonic (RESOURCES_CANCEL_LABEL);
#line 101 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_object_ref_sink (_tmp6_);
#line 101 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->cancel_button = _tmp6_;
#line 102 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp7_ = _ ("_Reset");
#line 102 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp8_ = (GtkButton*) gtk_button_new_with_mnemonic (_tmp7_);
#line 102 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_object_ref_sink (_tmp8_);
#line 102 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->reset_button = _tmp8_;
#line 3468 "StraightenTool.c"
}


static void editing_tools_straighten_tool_straighten_tool_window_finalize (GObject* obj) {
	EditingToolsStraightenToolStraightenToolWindow * self;
#line 94 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EDITING_TOOLS_STRAIGHTEN_TOOL_TYPE_STRAIGHTEN_TOOL_WINDOW, EditingToolsStraightenToolStraightenToolWindow);
#line 97 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_g_object_unref0 (self->angle_slider);
#line 98 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_g_object_unref0 (self->angle_label);
#line 99 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_g_object_unref0 (self->description_label);
#line 100 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_g_object_unref0 (self->ok_button);
#line 101 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_g_object_unref0 (self->cancel_button);
#line 102 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_g_object_unref0 (self->reset_button);
#line 94 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	G_OBJECT_CLASS (editing_tools_straighten_tool_straighten_tool_window_parent_class)->finalize (obj);
#line 3490 "StraightenTool.c"
}


static GType editing_tools_straighten_tool_straighten_tool_window_get_type (void) {
	static volatile gsize editing_tools_straighten_tool_straighten_tool_window_type_id__volatile = 0;
	if (g_once_init_enter (&editing_tools_straighten_tool_straighten_tool_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EditingToolsStraightenToolStraightenToolWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) editing_tools_straighten_tool_straighten_tool_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EditingToolsStraightenToolStraightenToolWindow), 0, (GInstanceInitFunc) editing_tools_straighten_tool_straighten_tool_window_instance_init, NULL };
		GType editing_tools_straighten_tool_straighten_tool_window_type_id;
		editing_tools_straighten_tool_straighten_tool_window_type_id = g_type_register_static (EDITING_TOOLS_TYPE_EDITING_TOOL_WINDOW, "EditingToolsStraightenToolStraightenToolWindow", &g_define_type_info, 0);
		g_once_init_leave (&editing_tools_straighten_tool_straighten_tool_window_type_id__volatile, editing_tools_straighten_tool_straighten_tool_window_type_id);
	}
	return editing_tools_straighten_tool_straighten_tool_window_type_id__volatile;
}


static void editing_tools_straighten_tool_class_init (EditingToolsStraightenToolClass * klass) {
#line 14 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	editing_tools_straighten_tool_parent_class = g_type_class_peek_parent (klass);
#line 14 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	((EditingToolsEditingToolClass *) klass)->finalize = editing_tools_straighten_tool_finalize;
#line 14 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	g_type_class_add_private (klass, sizeof (EditingToolsStraightenToolPrivate));
#line 14 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	((EditingToolsEditingToolClass *) klass)->on_left_click = (void (*)(EditingToolsEditingTool*, gint, gint)) editing_tools_straighten_tool_real_on_left_click;
#line 14 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	((EditingToolsEditingToolClass *) klass)->on_left_released = (void (*)(EditingToolsEditingTool*, gint, gint)) editing_tools_straighten_tool_real_on_left_released;
#line 14 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	((EditingToolsEditingToolClass *) klass)->on_motion = (void (*)(EditingToolsEditingTool*, gint, gint, GdkModifierType)) editing_tools_straighten_tool_real_on_motion;
#line 14 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	((EditingToolsEditingToolClass *) klass)->on_keypress = (gboolean (*)(EditingToolsEditingTool*, GdkEventKey*)) editing_tools_straighten_tool_real_on_keypress;
#line 14 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	((EditingToolsEditingToolClass *) klass)->activate = (void (*)(EditingToolsEditingTool*, EditingToolsPhotoCanvas*)) editing_tools_straighten_tool_real_activate;
#line 14 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	((EditingToolsEditingToolClass *) klass)->deactivate = (void (*)(EditingToolsEditingTool*)) editing_tools_straighten_tool_real_deactivate;
#line 14 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	((EditingToolsEditingToolClass *) klass)->get_tool_window = (EditingToolsEditingToolWindow* (*)(EditingToolsEditingTool*)) editing_tools_straighten_tool_real_get_tool_window;
#line 14 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	((EditingToolsEditingToolClass *) klass)->paint = (void (*)(EditingToolsEditingTool*, cairo_t*)) editing_tools_straighten_tool_real_paint;
#line 3529 "StraightenTool.c"
}


static void editing_tools_straighten_tool_instance_init (EditingToolsStraightenTool * self) {
	EditingToolsStraightenToolStraightenGuide* _tmp0_ = NULL;
#line 14 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->priv = EDITING_TOOLS_STRAIGHTEN_TOOL_GET_PRIVATE (self);
#line 170 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->priv->photo_angle = 0.0;
#line 174 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->priv->use_high_qual = TRUE;
#line 175 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->priv->slider_sched = NULL;
#line 181 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_tmp0_ = editing_tools_straighten_tool_straighten_guide_new ();
#line 181 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self->priv->guide = _tmp0_;
#line 3547 "StraightenTool.c"
}


static void editing_tools_straighten_tool_finalize (EditingToolsEditingTool* obj) {
	EditingToolsStraightenTool * self;
#line 14 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EDITING_TOOLS_TYPE_STRAIGHTEN_TOOL, EditingToolsStraightenTool);
#line 157 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_g_object_unref0 (self->priv->window);
#line 160 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_cairo_surface_destroy0 (self->priv->photo_surf);
#line 164 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_cairo_surface_destroy0 (self->priv->rotate_surf);
#line 165 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_cairo_destroy0 (self->priv->rotate_ctx);
#line 175 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_one_shot_scheduler_unref0 (self->priv->slider_sched);
#line 181 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	_editing_tools_straighten_tool_straighten_guide_unref0 (self->priv->guide);
#line 14 "/home/jens/Source/shotwell/src/editing_tools/StraightenTool.vala"
	EDITING_TOOLS_EDITING_TOOL_CLASS (editing_tools_straighten_tool_parent_class)->finalize (obj);
#line 3569 "StraightenTool.c"
}


/**
 * An editing tool that allows one to introduce or remove a Dutch angle from
 * a photograph.
 */
GType editing_tools_straighten_tool_get_type (void) {
	static volatile gsize editing_tools_straighten_tool_type_id__volatile = 0;
	if (g_once_init_enter (&editing_tools_straighten_tool_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EditingToolsStraightenToolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) editing_tools_straighten_tool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EditingToolsStraightenTool), 0, (GInstanceInitFunc) editing_tools_straighten_tool_instance_init, NULL };
		GType editing_tools_straighten_tool_type_id;
		editing_tools_straighten_tool_type_id = g_type_register_static (EDITING_TOOLS_TYPE_EDITING_TOOL, "EditingToolsStraightenTool", &g_define_type_info, 0);
		g_once_init_leave (&editing_tools_straighten_tool_type_id__volatile, editing_tools_straighten_tool_type_id);
	}
	return editing_tools_straighten_tool_type_id__volatile;
}



