/* ViewCollection.c generated by valac 0.34.7, the Vala compiler
 * generated from ViewCollection.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/* A ViewCollection holds DataView objects, which are view instances wrapping DataSource objects.*/
/* Thus, multiple views can exist of a single SourceCollection, each view displaying all or some*/
/* of that SourceCollection.  A view collection also has a notion of order*/
/* (first/last/next/previous) that can be overridden by child classes.  It also understands hidden*/
/* objects, which are withheld entirely from the collection until they're made visible.  Currently*/
/* the only way to hide objects is with a ViewFilter.*/
/**/
/* A ViewCollection may also be locked.  When locked, it will not (a) remove hidden items from the*/
/* collection and (b) remove DataViews representing unlinked DataSources.  This allows for the*/
/* ViewCollection to be "frozen" while manipulating items within it.  When the collection is*/
/* unlocked, all changes are applied at once.*/
/**/
/* The default implementation provides a browser which orders the view in the order they're*/
/* stored in DataCollection, which is not specified.*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;
typedef struct _DataCollectionPrivate DataCollectionPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define MARKER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MARKER, MarkerIface))

typedef struct _Marker Marker;
typedef struct _MarkerIface MarkerIface;

#define TYPE_VIEW_COLLECTION (view_collection_get_type ())
#define VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIEW_COLLECTION, ViewCollection))
#define VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIEW_COLLECTION, ViewCollectionClass))
#define IS_VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIEW_COLLECTION))
#define IS_VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIEW_COLLECTION))
#define VIEW_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIEW_COLLECTION, ViewCollectionClass))

typedef struct _ViewCollection ViewCollection;
typedef struct _ViewCollectionClass ViewCollectionClass;
typedef struct _ViewCollectionPrivate ViewCollectionPrivate;

#define TYPE_DATA_VIEW (data_view_get_type ())
#define DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_VIEW, DataView))
#define DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_VIEW, DataViewClass))
#define IS_DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_VIEW))
#define IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_VIEW))
#define DATA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_VIEW, DataViewClass))

typedef struct _DataView DataView;
typedef struct _DataViewClass DataViewClass;

#define TYPE_VIEW_FILTER (view_filter_get_type ())
#define VIEW_FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIEW_FILTER, ViewFilter))
#define VIEW_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIEW_FILTER, ViewFilterClass))
#define IS_VIEW_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIEW_FILTER))
#define IS_VIEW_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIEW_FILTER))
#define VIEW_FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIEW_FILTER, ViewFilterClass))

typedef struct _ViewFilter ViewFilter;
typedef struct _ViewFilterClass ViewFilterClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define VIEW_COLLECTION_TYPE_MONITOR (view_collection_monitor_get_type ())
#define VIEW_COLLECTION_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VIEW_COLLECTION_TYPE_MONITOR, ViewCollectionMonitor))
#define VIEW_COLLECTION_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VIEW_COLLECTION_TYPE_MONITOR, ViewCollectionMonitorClass))
#define VIEW_COLLECTION_IS_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VIEW_COLLECTION_TYPE_MONITOR))
#define VIEW_COLLECTION_IS_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VIEW_COLLECTION_TYPE_MONITOR))
#define VIEW_COLLECTION_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VIEW_COLLECTION_TYPE_MONITOR, ViewCollectionMonitorClass))

typedef struct _ViewCollectionMonitor ViewCollectionMonitor;
typedef struct _ViewCollectionMonitorClass ViewCollectionMonitorClass;

#define VIEW_COLLECTION_TYPE_MONITOR_IMPL (view_collection_monitor_impl_get_type ())
#define VIEW_COLLECTION_MONITOR_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VIEW_COLLECTION_TYPE_MONITOR_IMPL, ViewCollectionMonitorImpl))
#define VIEW_COLLECTION_MONITOR_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VIEW_COLLECTION_TYPE_MONITOR_IMPL, ViewCollectionMonitorImplClass))
#define VIEW_COLLECTION_IS_MONITOR_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VIEW_COLLECTION_TYPE_MONITOR_IMPL))
#define VIEW_COLLECTION_IS_MONITOR_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VIEW_COLLECTION_TYPE_MONITOR_IMPL))
#define VIEW_COLLECTION_MONITOR_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VIEW_COLLECTION_TYPE_MONITOR_IMPL, ViewCollectionMonitorImplClass))

typedef struct _ViewCollectionMonitorImpl ViewCollectionMonitorImpl;
typedef struct _ViewCollectionMonitorImplClass ViewCollectionMonitorImplClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_DATA_SET (data_set_get_type ())
#define DATA_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SET, DataSet))
#define DATA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SET, DataSetClass))
#define IS_DATA_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SET))
#define IS_DATA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SET))
#define DATA_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SET, DataSetClass))

typedef struct _DataSet DataSet;
typedef struct _DataSetClass DataSetClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _data_set_unref0(var) ((var == NULL) ? NULL : (var = (data_set_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _view_filter_unref0(var) ((var == NULL) ? NULL : (var = (view_filter_unref (var), NULL)))

#define TYPE_VIEW_MANAGER (view_manager_get_type ())
#define VIEW_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIEW_MANAGER, ViewManager))
#define VIEW_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIEW_MANAGER, ViewManagerClass))
#define IS_VIEW_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIEW_MANAGER))
#define IS_VIEW_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIEW_MANAGER))
#define VIEW_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIEW_MANAGER, ViewManagerClass))

typedef struct _ViewManager ViewManager;
typedef struct _ViewManagerClass ViewManagerClass;
#define _view_collection_monitor_unref0(var) ((var == NULL) ? NULL : (var = (view_collection_monitor_unref (var), NULL)))
typedef struct _ViewCollectionMonitorPrivate ViewCollectionMonitorPrivate;
typedef struct _ViewCollectionMonitorImplPrivate ViewCollectionMonitorImplPrivate;
#define _alteration_unref0(var) ((var == NULL) ? NULL : (var = (alteration_unref (var), NULL)))

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_RATING (rating_get_type ())

#define VIEW_COLLECTION_TYPE_TOGGLE_LISTS (view_collection_toggle_lists_get_type ())
#define VIEW_COLLECTION_TOGGLE_LISTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VIEW_COLLECTION_TYPE_TOGGLE_LISTS, ViewCollectionToggleLists))
#define VIEW_COLLECTION_TOGGLE_LISTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VIEW_COLLECTION_TYPE_TOGGLE_LISTS, ViewCollectionToggleListsClass))
#define VIEW_COLLECTION_IS_TOGGLE_LISTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VIEW_COLLECTION_TYPE_TOGGLE_LISTS))
#define VIEW_COLLECTION_IS_TOGGLE_LISTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VIEW_COLLECTION_TYPE_TOGGLE_LISTS))
#define VIEW_COLLECTION_TOGGLE_LISTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VIEW_COLLECTION_TYPE_TOGGLE_LISTS, ViewCollectionToggleListsClass))

typedef struct _ViewCollectionToggleLists ViewCollectionToggleLists;
typedef struct _ViewCollectionToggleListsClass ViewCollectionToggleListsClass;
typedef struct _ViewCollectionToggleListsPrivate ViewCollectionToggleListsPrivate;
typedef struct _ViewCollectionParamSpecMonitor ViewCollectionParamSpecMonitor;
#define _view_manager_unref0(var) ((var == NULL) ? NULL : (var = (view_manager_unref (var), NULL)))
typedef struct _ViewManagerPrivate ViewManagerPrivate;
typedef struct _ParamSpecViewManager ParamSpecViewManager;
typedef struct _ViewFilterPrivate ViewFilterPrivate;
typedef struct _ParamSpecViewFilter ParamSpecViewFilter;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef gint64 (*Comparator) (void* a, void* b, void* user_data);
typedef gboolean (*ComparatorPredicate) (DataObject* object, Alteration* alteration, void* user_data);
typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, void* user_data);
struct _MarkerIface {
	GTypeInterface parent_iface;
	void (*mark) (Marker* self, DataObject* object);
	void (*unmark) (Marker* self, DataObject* object);
	gboolean (*toggle) (Marker* self, DataObject* object);
	void (*mark_many) (Marker* self, GeeCollection* list);
	void (*unmark_many) (Marker* self, GeeCollection* list);
	void (*mark_all) (Marker* self);
	gint (*get_count) (Marker* self);
	GeeCollection* (*get_all) (Marker* self);
};

struct _DataCollection {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DataCollectionPrivate * priv;
};

struct _DataCollectionClass {
	GTypeClass parent_class;
	void (*finalize) (DataCollection *self);
	gchar* (*to_string) (DataCollection* self);
	void (*notify_items_added) (DataCollection* self, GeeIterable* added);
	void (*notify_items_removed) (DataCollection* self, GeeIterable* removed);
	void (*notify_contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*notify_items_altered) (DataCollection* self, GeeMap* items);
	void (*notify_ordering_changed) (DataCollection* self);
	void (*notify_property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_property_cleared) (DataCollection* self, const gchar* name);
	gboolean (*valid_type) (DataCollection* self, DataObject* object);
	void (*set_comparator) (DataCollection* self, Comparator comparator, void* comparator_target, ComparatorPredicate predicate, void* predicate_target);
	void (*reset_comparator) (DataCollection* self);
	GeeCollection* (*get_all) (DataCollection* self);
	gint (*get_count) (DataCollection* self);
	DataObject* (*get_at) (DataCollection* self, gint index);
	gint (*index_of) (DataCollection* self, DataObject* object);
	gboolean (*contains) (DataCollection* self, DataObject* object);
	gboolean (*add) (DataCollection* self, DataObject* object);
	GeeCollection* (*add_many) (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, void* monitor_target);
	void (*remove_marked) (DataCollection* self, Marker* m);
	void (*clear) (DataCollection* self);
	void (*close) (DataCollection* self);
	void (*notify_frozen) (DataCollection* self);
	void (*notify_thawed) (DataCollection* self);
	void (*items_added) (DataCollection* self, GeeIterable* added);
	void (*items_removed) (DataCollection* self, GeeIterable* removed);
	void (*contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*items_altered) (DataCollection* self, GeeMap* items);
	void (*ordering_changed) (DataCollection* self);
	void (*property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*property_cleared) (DataCollection* self, const gchar* name);
	void (*frozen) (DataCollection* self);
	void (*thawed) (DataCollection* self);
};

struct _ViewCollection {
	DataCollection parent_instance;
	ViewCollectionPrivate * priv;
};

struct _ViewCollectionClass {
	DataCollectionClass parent_class;
	void (*notify_items_selected_unselected) (ViewCollection* self, GeeCollection* selected, GeeCollection* unselected);
	void (*notify_selection_group_altered) (ViewCollection* self);
	void (*notify_item_view_altered) (ViewCollection* self, DataView* view);
	void (*notify_views_altered) (ViewCollection* self, GeeCollection* views);
	void (*notify_item_geometry_altered) (ViewCollection* self, DataView* view);
	void (*notify_geometries_altered) (ViewCollection* self, GeeCollection* views);
	void (*notify_items_shown) (ViewCollection* self, GeeCollection* shown);
	void (*notify_items_hidden) (ViewCollection* self, GeeCollection* hidden);
	void (*notify_items_visibility_changed) (ViewCollection* self, GeeCollection* changed);
	void (*notify_view_filter_installed) (ViewCollection* self, ViewFilter* filter);
	void (*notify_view_filter_removed) (ViewCollection* self, ViewFilter* filter);
	DataView* (*get_first) (ViewCollection* self);
	DataView* (*get_first_unrejected) (ViewCollection* self);
	DataView* (*get_last) (ViewCollection* self);
	DataView* (*get_next) (ViewCollection* self, DataView* view);
	DataView* (*get_previous) (ViewCollection* self, DataView* view);
	void (*items_selected) (ViewCollection* self, GeeIterable* selected);
	void (*items_unselected) (ViewCollection* self, GeeIterable* unselected);
	void (*items_state_changed) (ViewCollection* self, GeeIterable* changed);
	void (*selection_group_altered) (ViewCollection* self);
	void (*items_shown) (ViewCollection* self, GeeCollection* visible);
	void (*items_hidden) (ViewCollection* self, GeeCollection* hidden);
	void (*items_visibility_changed) (ViewCollection* self, GeeCollection* changed);
	void (*item_view_altered) (ViewCollection* self, DataView* view);
	void (*item_geometry_altered) (ViewCollection* self, DataView* view);
	void (*views_altered) (ViewCollection* self, GeeCollection* views);
	void (*geometries_altered) (ViewCollection* self, GeeCollection* views);
	void (*view_filter_installed) (ViewCollection* self, ViewFilter* filer);
	void (*view_filter_removed) (ViewCollection* self, ViewFilter* filer);
};

typedef DataView* (*CreateView) (DataSource* source, void* user_data);
typedef gboolean (*CreateViewPredicate) (DataSource* source, void* user_data);
struct _ViewCollectionPrivate {
	GeeHashMultiMap* monitors;
	ViewCollection* mirroring;
	CreateView mirroring_ctor;
	gpointer mirroring_ctor_target;
	CreateViewPredicate should_mirror;
	gpointer should_mirror_target;
	GeeSet* filters;
	DataSet* selected;
	DataSet* visible;
	GeeHashSet* frozen_views_altered;
	GeeHashSet* frozen_geometries_altered;
	GeeHashMap* source_map;
};

struct _ViewCollectionMonitor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ViewCollectionMonitorPrivate * priv;
};

struct _ViewCollectionMonitorClass {
	GTypeClass parent_class;
	void (*finalize) (ViewCollectionMonitor *self);
};

struct _ViewCollectionMonitorImpl {
	ViewCollectionMonitor parent_instance;
	ViewCollectionMonitorImplPrivate * priv;
	ViewCollection* owner;
	SourceCollection* sources;
	ViewManager* manager;
	Alteration* prereq;
};

struct _ViewCollectionMonitorImplClass {
	ViewCollectionMonitorClass parent_class;
};

typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

typedef gboolean (*MarkedAction) (DataObject* object, GObject* user, void* user_data);
struct _ViewCollectionToggleLists {
	GObject parent_instance;
	ViewCollectionToggleListsPrivate * priv;
	GeeArrayList* selected;
	GeeArrayList* unselected;
};

struct _ViewCollectionToggleListsClass {
	GObjectClass parent_class;
};

struct _ViewCollectionParamSpecMonitor {
	GParamSpec parent_instance;
};

struct _ViewManager {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ViewManagerPrivate * priv;
};

struct _ViewManagerClass {
	GTypeClass parent_class;
	void (*finalize) (ViewManager *self);
	gboolean (*include_in_view) (ViewManager* self, DataSource* source);
	DataView* (*create_view) (ViewManager* self, DataSource* source);
};

struct _ParamSpecViewManager {
	GParamSpec parent_instance;
};

struct _ViewFilter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ViewFilterPrivate * priv;
};

struct _ViewFilterClass {
	GTypeClass parent_class;
	void (*finalize) (ViewFilter *self);
	gboolean (*predicate) (ViewFilter* self, DataView* view);
	void (*refresh) (ViewFilter* self);
};

struct _ParamSpecViewFilter {
	GParamSpec parent_instance;
};


static gpointer view_collection_parent_class = NULL;
static gpointer view_collection_monitor_parent_class = NULL;
static gpointer view_collection_monitor_impl_parent_class = NULL;
static gpointer view_collection_toggle_lists_parent_class = NULL;
static gpointer view_manager_parent_class = NULL;
static gpointer view_filter_parent_class = NULL;

gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_collection (GValue* value, gpointer v_object);
void value_take_data_collection (GValue* value, gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType data_object_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_alteration (GValue* value, gpointer v_object);
void value_take_alteration (GValue* value, gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
GType marker_get_type (void) G_GNUC_CONST;
GType view_collection_get_type (void) G_GNUC_CONST;
GType data_view_get_type (void) G_GNUC_CONST;
gpointer view_filter_ref (gpointer instance);
void view_filter_unref (gpointer instance);
GParamSpec* param_spec_view_filter (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_view_filter (GValue* value, gpointer v_object);
void value_take_view_filter (GValue* value, gpointer v_object);
gpointer value_get_view_filter (const GValue* value);
GType view_filter_get_type (void) G_GNUC_CONST;
GType source_collection_get_type (void) G_GNUC_CONST;
gpointer view_collection_monitor_ref (gpointer instance);
void view_collection_monitor_unref (gpointer instance);
GParamSpec* view_collection_param_spec_monitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void view_collection_value_set_monitor (GValue* value, gpointer v_object);
void view_collection_value_take_monitor (GValue* value, gpointer v_object);
gpointer view_collection_value_get_monitor (const GValue* value);
GType view_collection_monitor_get_type (void) G_GNUC_CONST;
static GType view_collection_monitor_impl_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType data_source_get_type (void) G_GNUC_CONST;
gpointer data_set_ref (gpointer instance);
void data_set_unref (gpointer instance);
GParamSpec* param_spec_data_set (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_set (GValue* value, gpointer v_object);
void value_take_data_set (GValue* value, gpointer v_object);
gpointer value_get_data_set (const GValue* value);
GType data_set_get_type (void) G_GNUC_CONST;
#define VIEW_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_VIEW_COLLECTION, ViewCollectionPrivate))
enum  {
	VIEW_COLLECTION_DUMMY_PROPERTY
};
DataSet* data_set_new (void);
DataSet* data_set_construct (GType object_type);
ViewCollection* view_collection_new (const gchar* name);
ViewCollection* view_collection_construct (GType object_type, const gchar* name);
DataCollection* data_collection_new (const gchar* name);
DataCollection* data_collection_construct (GType object_type, const gchar* name);
void view_collection_notify_items_selected_unselected (ViewCollection* self, GeeCollection* selected, GeeCollection* unselected);
static void view_collection_real_notify_items_selected_unselected (ViewCollection* self, GeeCollection* selected, GeeCollection* unselected);
void view_collection_notify_selection_group_altered (ViewCollection* self);
static void view_collection_real_notify_selection_group_altered (ViewCollection* self);
void view_collection_notify_item_view_altered (ViewCollection* self, DataView* view);
static void view_collection_real_notify_item_view_altered (ViewCollection* self, DataView* view);
void view_collection_notify_views_altered (ViewCollection* self, GeeCollection* views);
static void view_collection_real_notify_views_altered (ViewCollection* self, GeeCollection* views);
void view_collection_notify_item_geometry_altered (ViewCollection* self, DataView* view);
static void view_collection_real_notify_item_geometry_altered (ViewCollection* self, DataView* view);
void view_collection_notify_geometries_altered (ViewCollection* self, GeeCollection* views);
static void view_collection_real_notify_geometries_altered (ViewCollection* self, GeeCollection* views);
void view_collection_notify_items_shown (ViewCollection* self, GeeCollection* shown);
static void view_collection_real_notify_items_shown (ViewCollection* self, GeeCollection* shown);
void view_collection_notify_items_hidden (ViewCollection* self, GeeCollection* hidden);
static void view_collection_real_notify_items_hidden (ViewCollection* self, GeeCollection* hidden);
void view_collection_notify_items_visibility_changed (ViewCollection* self, GeeCollection* changed);
static void view_collection_real_notify_items_visibility_changed (ViewCollection* self, GeeCollection* changed);
void view_collection_notify_view_filter_installed (ViewCollection* self, ViewFilter* filter);
static void view_collection_real_notify_view_filter_installed (ViewCollection* self, ViewFilter* filter);
void view_collection_notify_view_filter_removed (ViewCollection* self, ViewFilter* filter);
static void view_collection_real_notify_view_filter_removed (ViewCollection* self, ViewFilter* filter);
static void view_collection_real_clear (DataCollection* base);
gchar* data_collection_to_string (DataCollection* self);
void data_collection_clear (DataCollection* self);
static void view_collection_real_close (DataCollection* base);
void view_collection_halt_all_monitoring (ViewCollection* self);
void view_collection_halt_mirroring (ViewCollection* self);
static void view_collection_on_view_filter_refresh (ViewCollection* self);
static void _view_collection_on_view_filter_refresh_view_filter_refresh (ViewFilter* _sender, gpointer self);
void data_collection_close (DataCollection* self);
gpointer view_manager_ref (gpointer instance);
void view_manager_unref (gpointer instance);
GParamSpec* param_spec_view_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_view_manager (GValue* value, gpointer v_object);
void value_take_view_manager (GValue* value, gpointer v_object);
gpointer value_get_view_manager (const GValue* value);
GType view_manager_get_type (void) G_GNUC_CONST;
ViewCollectionMonitor* view_collection_monitor_source_collection (ViewCollection* self, SourceCollection* sources, ViewManager* manager, Alteration* prereq, GeeCollection* initial, ProgressMonitor progress_monitor, void* progress_monitor_target);
void data_collection_freeze_notifications (DataCollection* self);
static ViewCollectionMonitorImpl* view_collection_monitor_impl_new (ViewCollection* owner, SourceCollection* sources, ViewManager* manager, Alteration* prereq);
static ViewCollectionMonitorImpl* view_collection_monitor_impl_construct (GType object_type, ViewCollection* owner, SourceCollection* sources, ViewManager* manager, Alteration* prereq);
DataView* view_manager_create_view (ViewManager* self, DataSource* source);
GeeCollection* data_collection_add_many (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, void* monitor_target);
static void view_collection_add_sources (ViewCollection* self, SourceCollection* sources, GeeIterable* added, ProgressMonitor progress_monitor, void* progress_monitor_target);
GeeCollection* data_collection_get_all (DataCollection* self);
void data_collection_thaw_notifications (DataCollection* self);
void view_collection_halt_monitoring (ViewCollection* self, ViewCollectionMonitor* m);
void view_collection_mirror (ViewCollection* self, ViewCollection* to_mirror, CreateView mirroring_ctor, void* mirroring_ctor_target, CreateViewPredicate should_mirror, void* should_mirror_target);
void data_collection_set_comparator (DataCollection* self, Comparator comparator, void* comparator_target, ComparatorPredicate predicate, void* predicate_target);
Comparator data_collection_get_comparator (DataCollection* self, void** result_target);
ComparatorPredicate data_collection_get_comparator_predicate (DataCollection* self, void** result_target);
static void view_collection_on_mirror_contents_added (ViewCollection* self, GeeIterable* added);
static void _view_collection_on_mirror_contents_added_data_collection_items_added (DataCollection* _sender, GeeIterable* added, gpointer self);
static void view_collection_on_mirror_contents_removed (ViewCollection* self, GeeIterable* removed);
static void _view_collection_on_mirror_contents_removed_data_collection_items_removed (DataCollection* _sender, GeeIterable* removed, gpointer self);
void view_collection_copy_into (ViewCollection* self, ViewCollection* to_copy, CreateView copying_ctor, void* copying_ctor_target, CreateViewPredicate should_copy, void* should_copy_target);
DataSource* data_view_get_source (DataView* self);
gboolean view_collection_is_view_filter_installed (ViewCollection* self, ViewFilter* f);
void view_collection_install_view_filter (ViewCollection* self, ViewFilter* f);
void view_collection_remove_view_filter (ViewCollection* self, ViewFilter* f);
static void view_collection_filter_altered_items (ViewCollection* self, GeeCollection* views);
static gboolean view_collection_is_in_filter (ViewCollection* self, DataView* view);
gboolean view_filter_predicate (ViewFilter* self, DataView* view);
static gboolean view_collection_real_valid_type (DataCollection* base, DataObject* object);
static void view_collection_on_sources_added (ViewCollection* self, DataCollection* sources, GeeIterable* added);
gboolean view_manager_include_in_view (ViewManager* self, DataSource* source);
static DataView* _view_manager_create_view_create_view (DataSource* source, gpointer self);
gboolean data_collection_add (DataCollection* self, DataObject* object);
static gboolean view_collection_real_add (DataCollection* base, DataObject* object);
void data_view_internal_set_visible (DataView* self, gboolean visible);
GeeCollection* data_collection_get_singleton (DataObject* object);
static GeeCollection* view_collection_real_add_many (DataCollection* base, GeeCollection* objects, ProgressMonitor monitor, void* monitor_target);
static void view_collection_on_sources_removed (ViewCollection* self, GeeIterable* removed);
Marker* data_collection_start_marking (DataCollection* self);
void marker_mark (Marker* self, DataObject* object);
gint marker_get_count (Marker* self);
void data_collection_remove_marked (DataCollection* self, Marker* m);
static void view_collection_on_sources_altered (ViewCollection* self, DataCollection* collection, GeeMap* items);
gboolean alteration_contains_any (Alteration* self, Alteration* other);
gboolean view_collection_has_view_for_source (ViewCollection* self, DataSource* source);
DataView* view_collection_get_view_for_source (ViewCollection* self, DataSource* source);
gboolean data_set_contains (DataSet* self, DataObject* object);
gboolean data_set_resort_object (DataSet* self, DataObject* object, Alteration* alteration);
static gboolean view_collection_is_visible (ViewCollection* self, DataView* view);
Marker* data_collection_mark_many (DataCollection* self, GeeCollection* objects);
void data_collection_notify_ordering_changed (DataCollection* self);
static void view_collection_real_notify_items_added (DataCollection* base, GeeIterable* added);
gboolean data_view_is_selected (DataView* self);
gboolean data_view_is_visible (DataView* self);
static gboolean view_collection_add_many_visible (ViewCollection* self, GeeCollection* many);
static void view_collection_add_many_selected (ViewCollection* self, GeeCollection* views);
void data_collection_notify_items_added (DataCollection* self, GeeIterable* added);
static void view_collection_real_notify_items_removed (DataCollection* base, GeeIterable* removed);
gboolean data_set_remove (DataSet* self, DataObject* object);
static void view_collection_remove_many_selected (ViewCollection* self, GeeCollection* views);
void data_collection_notify_items_removed (DataCollection* self, GeeIterable* removed);
static void view_collection_show_items (ViewCollection* self, GeeList* to_show);
static void view_collection_hide_items (ViewCollection* self, GeeList* to_hide);
static void view_collection_real_items_altered (DataCollection* base, GeeMap* map);
static void view_collection_real_set_comparator (DataCollection* base, Comparator comparator, void* comparator_target, ComparatorPredicate predicate, void* predicate_target);
void data_set_set_comparator (DataSet* self, Comparator user_comparator, void* user_comparator_target, ComparatorPredicate comparator_predicate, void* comparator_predicate_target);
static void view_collection_real_reset_comparator (DataCollection* base);
void data_set_reset_comparator (DataSet* self);
void data_collection_reset_comparator (DataCollection* self);
static GeeCollection* view_collection_real_get_all (DataCollection* base);
GeeList* data_set_get_all (DataSet* self);
GeeCollection* view_collection_get_all_unfiltered (ViewCollection* self);
static gint view_collection_real_get_count (DataCollection* base);
gint data_set_get_count (DataSet* self);
gint data_collection_get_count (DataCollection* self);
gint view_collection_get_unfiltered_count (ViewCollection* self);
static DataObject* view_collection_real_get_at (DataCollection* base, gint index);
DataObject* data_set_get_at (DataSet* self, gint index);
DataObject* data_collection_get_at (DataCollection* self, gint index);
static gint view_collection_real_index_of (DataCollection* base, DataObject* object);
gint data_set_index_of (DataSet* self, DataObject* object);
gint data_collection_index_of (DataCollection* self, DataObject* object);
static gboolean view_collection_real_contains (DataCollection* base, DataObject* object);
gboolean data_collection_contains (DataCollection* self, DataObject* object);
DataView* view_collection_get_first (ViewCollection* self);
static DataView* view_collection_real_get_first (ViewCollection* self);
DataView* view_collection_get_first_unrejected (ViewCollection* self);
static DataView* view_collection_real_get_first_unrejected (ViewCollection* self);
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
GType rating_get_type (void) G_GNUC_CONST;
Rating media_source_get_rating (MediaSource* self);
DataView* view_collection_get_next (ViewCollection* self, DataView* view);
DataView* view_collection_get_last (ViewCollection* self);
static DataView* view_collection_real_get_last (ViewCollection* self);
static DataView* view_collection_real_get_next (ViewCollection* self, DataView* view);
DataView* view_collection_get_previous (ViewCollection* self, DataView* view);
static DataView* view_collection_real_get_previous (ViewCollection* self, DataView* view);
gboolean view_collection_get_immediate_neighbors (ViewCollection* self, DataSource* home, DataSource** next, DataSource** prev, const gchar* type_selector);
gchar* data_source_get_typename (DataSource* self);
GeeSet* view_collection_get_extended_neighbors (ViewCollection* self, DataSource* home, const gchar* typename);
gboolean data_set_add_many (DataSet* self, GeeCollection* objects);
gboolean data_set_remove_many (DataSet* self, GeeCollection* objects);
void view_collection_select_marked (ViewCollection* self, Marker* marker);
void data_collection_act_on_marked (DataCollection* self, Marker* m, MarkedAction action, void* action_target, ProgressMonitor monitor, void* monitor_target, GObject* user);
static gboolean view_collection_select_item (ViewCollection* self, DataObject* object, GObject* user);
static gboolean _view_collection_select_item_marked_action (DataObject* object, GObject* user, gpointer self);
void view_collection_select_all (ViewCollection* self);
void marker_mark_all (Marker* self);
void data_view_internal_set_selected (DataView* self, gboolean selected);
void view_collection_unselect_marked (ViewCollection* self, Marker* marker);
static gboolean view_collection_unselect_item (ViewCollection* self, DataObject* object, GObject* user);
static gboolean _view_collection_unselect_item_marked_action (DataObject* object, GObject* user, gpointer self);
void view_collection_unselect_all (ViewCollection* self);
void marker_mark_many (Marker* self, GeeCollection* list);
GeeList* view_collection_get_selected (ViewCollection* self);
void view_collection_unselect_all_but (ViewCollection* self, DataView* exception);
void view_collection_unselect_and_select_marked (ViewCollection* self, Marker* unselect, Marker* select);
void view_collection_toggle_marked (ViewCollection* self, Marker* marker);
static GType view_collection_toggle_lists_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ViewCollectionToggleLists* view_collection_toggle_lists_new (void);
static ViewCollectionToggleLists* view_collection_toggle_lists_construct (GType object_type);
static gboolean view_collection_toggle_item (ViewCollection* self, DataObject* object, GObject* user);
static gboolean _view_collection_toggle_item_marked_action (DataObject* object, GObject* user, gpointer self);
gboolean data_view_internal_toggle (DataView* self);
gint view_collection_get_selected_count (ViewCollection* self);
DataView* view_collection_get_selected_at (ViewCollection* self, gint index);
DataSet* data_collection_get_dataset_copy (DataCollection* self);
gboolean view_collection_has_view_for_source_with_filtered (ViewCollection* self, DataSource* source);
DataView* view_collection_get_view_for_source_filtered (ViewCollection* self, DataSource* source);
GeeCollection* view_collection_get_sources (ViewCollection* self);
gboolean view_collection_has_source_of_type (ViewCollection* self, GType t);
gint view_collection_get_sources_of_type_count (ViewCollection* self, GType t);
GeeList* view_collection_get_sources_of_type (ViewCollection* self, GType t);
GeeList* view_collection_get_selected_sources (ViewCollection* self);
DataSource* view_collection_get_selected_source_at (ViewCollection* self, gint index);
GeeList* view_collection_get_selected_sources_of_type (ViewCollection* self, GType t);
gint view_collection_index_of_source (ViewCollection* self, DataSource* source);
void view_collection_internal_notify_view_altered (ViewCollection* self, DataView* view);
gboolean data_collection_are_notifications_frozen (DataCollection* self);
void view_collection_internal_notify_geometry_altered (ViewCollection* self, DataView* view);
static void view_collection_real_notify_thawed (DataCollection* base);
void data_collection_notify_thawed (DataCollection* self);
gboolean view_collection_are_items_filtered_out (ViewCollection* self);
static void view_collection_real_items_selected (ViewCollection* self, GeeIterable* selected);
static void view_collection_real_items_unselected (ViewCollection* self, GeeIterable* unselected);
static void view_collection_real_items_state_changed (ViewCollection* self, GeeIterable* changed);
static void view_collection_real_selection_group_altered (ViewCollection* self);
static void view_collection_real_items_shown (ViewCollection* self, GeeCollection* visible);
static void view_collection_real_items_hidden (ViewCollection* self, GeeCollection* hidden);
static void view_collection_real_items_visibility_changed (ViewCollection* self, GeeCollection* changed);
static void view_collection_real_item_view_altered (ViewCollection* self, DataView* view);
static void view_collection_real_item_geometry_altered (ViewCollection* self, DataView* view);
static void view_collection_real_views_altered (ViewCollection* self, GeeCollection* views);
static void view_collection_real_geometries_altered (ViewCollection* self, GeeCollection* views);
static void view_collection_real_view_filter_installed (ViewCollection* self, ViewFilter* filer);
static void g_cclosure_user_marshal_VOID__VIEW_FILTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void view_collection_real_view_filter_removed (ViewCollection* self, ViewFilter* filer);
enum  {
	VIEW_COLLECTION_MONITOR_DUMMY_PROPERTY
};
ViewCollectionMonitor* view_collection_monitor_new (void);
ViewCollectionMonitor* view_collection_monitor_construct (GType object_type);
static void view_collection_monitor_finalize (ViewCollectionMonitor* obj);
enum  {
	VIEW_COLLECTION_MONITOR_IMPL_DUMMY_PROPERTY
};
static void _view_collection_on_sources_added_data_collection_items_added (DataCollection* _sender, GeeIterable* added, gpointer self);
static void _view_collection_on_sources_removed_data_collection_items_removed (DataCollection* _sender, GeeIterable* removed, gpointer self);
static void _view_collection_on_sources_altered_data_collection_items_altered (DataCollection* _sender, GeeMap* items, gpointer self);
static void view_collection_monitor_impl_finalize (ViewCollectionMonitor* obj);
enum  {
	VIEW_COLLECTION_TOGGLE_LISTS_DUMMY_PROPERTY
};
static void view_collection_toggle_lists_finalize (GObject* obj);
static void view_collection_finalize (DataCollection* obj);
enum  {
	VIEW_MANAGER_DUMMY_PROPERTY
};
static gboolean view_manager_real_include_in_view (ViewManager* self, DataSource* source);
static DataView* view_manager_real_create_view (ViewManager* self, DataSource* source);
ViewManager* view_manager_construct (GType object_type);
static void view_manager_finalize (ViewManager* obj);
enum  {
	VIEW_FILTER_DUMMY_PROPERTY
};
static gboolean view_filter_real_predicate (ViewFilter* self, DataView* view);
ViewFilter* view_filter_construct (GType object_type);
static void view_filter_real_refresh (ViewFilter* self);
static void view_filter_finalize (ViewFilter* obj);


ViewCollection* view_collection_construct (GType object_type, const gchar* name) {
	ViewCollection* self = NULL;
	const gchar* _tmp0_ = NULL;
#line 125 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 126 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = name;
#line 126 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self = (ViewCollection*) data_collection_construct (object_type, _tmp0_);
#line 125 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return self;
#line 711 "ViewCollection.c"
}


ViewCollection* view_collection_new (const gchar* name) {
#line 125 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return view_collection_construct (TYPE_VIEW_COLLECTION, name);
#line 718 "ViewCollection.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 142 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return self ? g_object_ref (self) : NULL;
#line 725 "ViewCollection.c"
}


static void view_collection_real_notify_items_selected_unselected (ViewCollection* self, GeeCollection* selected, GeeCollection* unselected) {
	gboolean _tmp0_ = FALSE;
	GeeCollection* _tmp1_ = NULL;
	gboolean has_selected = FALSE;
	gboolean _tmp5_ = FALSE;
	GeeCollection* _tmp6_ = NULL;
	gboolean has_unselected = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp12_ = FALSE;
	GeeCollection* sum = NULL;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	GeeCollection* _tmp32_ = NULL;
#line 129 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail ((selected == NULL) || GEE_IS_COLLECTION (selected));
#line 129 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail ((unselected == NULL) || GEE_IS_COLLECTION (unselected));
#line 131 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = selected;
#line 131 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp1_ != NULL) {
#line 750 "ViewCollection.c"
		GeeCollection* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 131 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp2_ = selected;
#line 131 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp3_ = gee_collection_get_size (_tmp2_);
#line 131 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp4_ = _tmp3_;
#line 131 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp0_ = _tmp4_ > 0;
#line 762 "ViewCollection.c"
	} else {
#line 131 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp0_ = FALSE;
#line 766 "ViewCollection.c"
	}
#line 131 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	has_selected = _tmp0_;
#line 132 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp6_ = unselected;
#line 132 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp6_ != NULL) {
#line 774 "ViewCollection.c"
		GeeCollection* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
#line 132 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp7_ = unselected;
#line 132 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp8_ = gee_collection_get_size (_tmp7_);
#line 132 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp9_ = _tmp8_;
#line 132 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp5_ = _tmp9_ > 0;
#line 786 "ViewCollection.c"
	} else {
#line 132 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp5_ = FALSE;
#line 790 "ViewCollection.c"
	}
#line 132 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	has_unselected = _tmp5_;
#line 134 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp10_ = has_selected;
#line 134 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp10_) {
#line 798 "ViewCollection.c"
		GeeCollection* _tmp11_ = NULL;
#line 135 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp11_ = selected;
#line 135 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		g_signal_emit_by_name (self, "items-selected", G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ITERABLE, GeeIterable));
#line 804 "ViewCollection.c"
	}
#line 137 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp12_ = has_unselected;
#line 137 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp12_) {
#line 810 "ViewCollection.c"
		GeeCollection* _tmp13_ = NULL;
#line 138 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp13_ = unselected;
#line 138 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		g_signal_emit_by_name (self, "items-unselected", G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ITERABLE, GeeIterable));
#line 816 "ViewCollection.c"
	}
#line 141 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp15_ = has_selected;
#line 141 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp15_) {
#line 822 "ViewCollection.c"
		gboolean _tmp16_ = FALSE;
#line 141 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp16_ = has_unselected;
#line 141 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp14_ = !_tmp16_;
#line 828 "ViewCollection.c"
	} else {
#line 141 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp14_ = FALSE;
#line 832 "ViewCollection.c"
	}
#line 141 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp14_) {
#line 836 "ViewCollection.c"
		GeeCollection* _tmp17_ = NULL;
		GeeCollection* _tmp18_ = NULL;
#line 142 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp17_ = selected;
#line 142 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp18_ = _g_object_ref0 (_tmp17_);
#line 142 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (sum);
#line 142 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		sum = _tmp18_;
#line 847 "ViewCollection.c"
	} else {
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
#line 143 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp20_ = has_selected;
#line 143 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		if (!_tmp20_) {
#line 855 "ViewCollection.c"
			gboolean _tmp21_ = FALSE;
#line 143 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp21_ = has_unselected;
#line 143 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp19_ = _tmp21_;
#line 861 "ViewCollection.c"
		} else {
#line 143 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp19_ = FALSE;
#line 865 "ViewCollection.c"
		}
#line 143 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		if (_tmp19_) {
#line 869 "ViewCollection.c"
			GeeCollection* _tmp22_ = NULL;
			GeeCollection* _tmp23_ = NULL;
#line 144 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp22_ = unselected;
#line 144 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp23_ = _g_object_ref0 (_tmp22_);
#line 144 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (sum);
#line 144 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			sum = _tmp23_;
#line 880 "ViewCollection.c"
		} else {
			gboolean _tmp24_ = FALSE;
			gboolean _tmp25_ = FALSE;
#line 145 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp25_ = has_selected;
#line 145 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (!_tmp25_) {
#line 888 "ViewCollection.c"
				gboolean _tmp26_ = FALSE;
#line 145 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp26_ = has_unselected;
#line 145 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp24_ = !_tmp26_;
#line 894 "ViewCollection.c"
			} else {
#line 145 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp24_ = FALSE;
#line 898 "ViewCollection.c"
			}
#line 145 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (_tmp24_) {
#line 146 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_g_object_unref0 (sum);
#line 146 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				sum = NULL;
#line 906 "ViewCollection.c"
			} else {
				GeeHashSet* _tmp27_ = NULL;
				GeeCollection* _tmp28_ = NULL;
				GeeCollection* _tmp29_ = NULL;
				GeeCollection* _tmp30_ = NULL;
				GeeCollection* _tmp31_ = NULL;
#line 148 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp27_ = gee_hash_set_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 148 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_g_object_unref0 (sum);
#line 148 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				sum = G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_COLLECTION, GeeCollection);
#line 149 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp28_ = sum;
#line 149 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp29_ = selected;
#line 149 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				gee_collection_add_all (_tmp28_, _tmp29_);
#line 150 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp30_ = sum;
#line 150 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp31_ = unselected;
#line 150 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				gee_collection_add_all (_tmp30_, _tmp31_);
#line 931 "ViewCollection.c"
			}
		}
	}
#line 153 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp32_ = sum;
#line 153 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp32_ != NULL) {
#line 939 "ViewCollection.c"
		GeeCollection* _tmp33_ = NULL;
#line 154 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp33_ = sum;
#line 154 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		g_signal_emit_by_name (self, "items-state-changed", G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, GEE_TYPE_ITERABLE, GeeIterable));
#line 155 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_collection_notify_selection_group_altered (self);
#line 947 "ViewCollection.c"
	}
#line 129 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (sum);
#line 951 "ViewCollection.c"
}


void view_collection_notify_items_selected_unselected (ViewCollection* self, GeeCollection* selected, GeeCollection* unselected) {
#line 129 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 129 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	VIEW_COLLECTION_GET_CLASS (self)->notify_items_selected_unselected (self, selected, unselected);
#line 960 "ViewCollection.c"
}


static void view_collection_real_notify_selection_group_altered (ViewCollection* self) {
#line 160 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_emit_by_name (self, "selection-group-altered");
#line 967 "ViewCollection.c"
}


void view_collection_notify_selection_group_altered (ViewCollection* self) {
#line 159 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 159 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	VIEW_COLLECTION_GET_CLASS (self)->notify_selection_group_altered (self);
#line 976 "ViewCollection.c"
}


static void view_collection_real_notify_item_view_altered (ViewCollection* self, DataView* view) {
	DataView* _tmp0_ = NULL;
#line 163 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_DATA_VIEW (view));
#line 164 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = view;
#line 164 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_emit_by_name (self, "item-view-altered", _tmp0_);
#line 988 "ViewCollection.c"
}


void view_collection_notify_item_view_altered (ViewCollection* self, DataView* view) {
#line 163 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 163 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	VIEW_COLLECTION_GET_CLASS (self)->notify_item_view_altered (self, view);
#line 997 "ViewCollection.c"
}


static void view_collection_real_notify_views_altered (ViewCollection* self, GeeCollection* views) {
	GeeCollection* _tmp0_ = NULL;
#line 167 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (views));
#line 168 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = views;
#line 168 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_emit_by_name (self, "views-altered", _tmp0_);
#line 1009 "ViewCollection.c"
}


void view_collection_notify_views_altered (ViewCollection* self, GeeCollection* views) {
#line 167 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 167 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	VIEW_COLLECTION_GET_CLASS (self)->notify_views_altered (self, views);
#line 1018 "ViewCollection.c"
}


static void view_collection_real_notify_item_geometry_altered (ViewCollection* self, DataView* view) {
	DataView* _tmp0_ = NULL;
#line 171 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_DATA_VIEW (view));
#line 172 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = view;
#line 172 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_emit_by_name (self, "item-geometry-altered", _tmp0_);
#line 1030 "ViewCollection.c"
}


void view_collection_notify_item_geometry_altered (ViewCollection* self, DataView* view) {
#line 171 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 171 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	VIEW_COLLECTION_GET_CLASS (self)->notify_item_geometry_altered (self, view);
#line 1039 "ViewCollection.c"
}


static void view_collection_real_notify_geometries_altered (ViewCollection* self, GeeCollection* views) {
	GeeCollection* _tmp0_ = NULL;
#line 175 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (views));
#line 176 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = views;
#line 176 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_emit_by_name (self, "geometries-altered", _tmp0_);
#line 1051 "ViewCollection.c"
}


void view_collection_notify_geometries_altered (ViewCollection* self, GeeCollection* views) {
#line 175 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 175 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	VIEW_COLLECTION_GET_CLASS (self)->notify_geometries_altered (self, views);
#line 1060 "ViewCollection.c"
}


static void view_collection_real_notify_items_shown (ViewCollection* self, GeeCollection* shown) {
	GeeCollection* _tmp0_ = NULL;
#line 179 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (shown));
#line 180 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = shown;
#line 180 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_emit_by_name (self, "items-shown", _tmp0_);
#line 1072 "ViewCollection.c"
}


void view_collection_notify_items_shown (ViewCollection* self, GeeCollection* shown) {
#line 179 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 179 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	VIEW_COLLECTION_GET_CLASS (self)->notify_items_shown (self, shown);
#line 1081 "ViewCollection.c"
}


static void view_collection_real_notify_items_hidden (ViewCollection* self, GeeCollection* hidden) {
	GeeCollection* _tmp0_ = NULL;
#line 183 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (hidden));
#line 184 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = hidden;
#line 184 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_emit_by_name (self, "items-hidden", _tmp0_);
#line 1093 "ViewCollection.c"
}


void view_collection_notify_items_hidden (ViewCollection* self, GeeCollection* hidden) {
#line 183 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 183 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	VIEW_COLLECTION_GET_CLASS (self)->notify_items_hidden (self, hidden);
#line 1102 "ViewCollection.c"
}


static void view_collection_real_notify_items_visibility_changed (ViewCollection* self, GeeCollection* changed) {
	GeeCollection* _tmp0_ = NULL;
#line 187 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (changed));
#line 188 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = changed;
#line 188 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_emit_by_name (self, "items-visibility-changed", _tmp0_);
#line 1114 "ViewCollection.c"
}


void view_collection_notify_items_visibility_changed (ViewCollection* self, GeeCollection* changed) {
#line 187 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 187 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	VIEW_COLLECTION_GET_CLASS (self)->notify_items_visibility_changed (self, changed);
#line 1123 "ViewCollection.c"
}


static void view_collection_real_notify_view_filter_installed (ViewCollection* self, ViewFilter* filter) {
	ViewFilter* _tmp0_ = NULL;
#line 191 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_FILTER (filter));
#line 192 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = filter;
#line 192 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_emit_by_name (self, "view-filter-installed", _tmp0_);
#line 1135 "ViewCollection.c"
}


void view_collection_notify_view_filter_installed (ViewCollection* self, ViewFilter* filter) {
#line 191 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 191 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	VIEW_COLLECTION_GET_CLASS (self)->notify_view_filter_installed (self, filter);
#line 1144 "ViewCollection.c"
}


static void view_collection_real_notify_view_filter_removed (ViewCollection* self, ViewFilter* filter) {
	ViewFilter* _tmp0_ = NULL;
#line 195 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_FILTER (filter));
#line 196 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = filter;
#line 196 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_emit_by_name (self, "view-filter-removed", _tmp0_);
#line 1156 "ViewCollection.c"
}


void view_collection_notify_view_filter_removed (ViewCollection* self, ViewFilter* filter) {
#line 195 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 195 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	VIEW_COLLECTION_GET_CLASS (self)->notify_view_filter_removed (self, filter);
#line 1165 "ViewCollection.c"
}


static void view_collection_real_clear (DataCollection* base) {
	ViewCollection * self;
	gboolean _tmp0_ = FALSE;
	GeeHashMultiMap* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 199 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIEW_COLLECTION, ViewCollection);
#line 202 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = self->priv->monitors;
#line 202 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = gee_multi_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_MULTI_MAP, GeeMultiMap));
#line 202 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3_ = _tmp2_;
#line 202 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp3_ > 0) {
#line 202 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp0_ = TRUE;
#line 1187 "ViewCollection.c"
	} else {
		ViewCollection* _tmp4_ = NULL;
#line 202 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp4_ = self->priv->mirroring;
#line 202 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp0_ = _tmp4_ != NULL;
#line 1194 "ViewCollection.c"
	}
#line 202 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp0_) {
#line 1198 "ViewCollection.c"
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 203 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp5_ = data_collection_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 203 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp6_ = _tmp5_;
#line 203 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		g_warning ("ViewCollection.vala:203: Cannot clear %s: monitoring or mirroring in e" \
"ffect", _tmp6_);
#line 203 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_free0 (_tmp6_);
#line 205 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		return;
#line 1211 "ViewCollection.c"
	}
#line 208 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	DATA_COLLECTION_CLASS (view_collection_parent_class)->clear (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 1215 "ViewCollection.c"
}


static void _view_collection_on_view_filter_refresh_view_filter_refresh (ViewFilter* _sender, gpointer self) {
#line 215 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_on_view_filter_refresh ((ViewCollection*) self);
#line 1222 "ViewCollection.c"
}


static void view_collection_real_close (DataCollection* base) {
	ViewCollection * self;
	GeeSet* _tmp8_ = NULL;
#line 211 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIEW_COLLECTION, ViewCollection);
#line 212 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_halt_all_monitoring (self);
#line 213 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_halt_mirroring (self);
#line 1235 "ViewCollection.c"
	{
		GeeIterator* _f_it = NULL;
		GeeSet* _tmp0_ = NULL;
		GeeIterator* _tmp1_ = NULL;
#line 214 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp0_ = self->priv->filters;
#line 214 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERABLE, GeeIterable));
#line 214 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_f_it = _tmp1_;
#line 214 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		while (TRUE) {
#line 1248 "ViewCollection.c"
			GeeIterator* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
			ViewFilter* f = NULL;
			GeeIterator* _tmp4_ = NULL;
			gpointer _tmp5_ = NULL;
			ViewFilter* _tmp6_ = NULL;
			guint _tmp7_ = 0U;
#line 214 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp2_ = _f_it;
#line 214 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 214 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (!_tmp3_) {
#line 214 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				break;
#line 1264 "ViewCollection.c"
			}
#line 214 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp4_ = _f_it;
#line 214 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 214 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			f = (ViewFilter*) _tmp5_;
#line 215 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp6_ = f;
#line 215 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			g_signal_parse_name ("refresh", TYPE_VIEW_FILTER, &_tmp7_, NULL, FALSE);
#line 215 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _view_collection_on_view_filter_refresh_view_filter_refresh, self);
#line 214 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_view_filter_unref0 (f);
#line 1280 "ViewCollection.c"
		}
#line 214 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_f_it);
#line 1284 "ViewCollection.c"
	}
#line 216 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp8_ = self->priv->filters;
#line 216 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	gee_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_COLLECTION, GeeCollection));
#line 218 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	DATA_COLLECTION_CLASS (view_collection_parent_class)->close (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 1292 "ViewCollection.c"
}


ViewCollectionMonitor* view_collection_monitor_source_collection (ViewCollection* self, SourceCollection* sources, ViewManager* manager, Alteration* prereq, GeeCollection* initial, ProgressMonitor progress_monitor, void* progress_monitor_target) {
	ViewCollectionMonitor* result = NULL;
	ViewCollectionMonitorImpl* monitor = NULL;
	SourceCollection* _tmp0_ = NULL;
	ViewManager* _tmp1_ = NULL;
	Alteration* _tmp2_ = NULL;
	ViewCollectionMonitorImpl* _tmp3_ = NULL;
	GeeHashMultiMap* _tmp4_ = NULL;
	SourceCollection* _tmp5_ = NULL;
	ViewCollectionMonitorImpl* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GeeCollection* _tmp8_ = NULL;
#line 221 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
#line 221 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_SOURCE_COLLECTION (sources), NULL);
#line 221 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_MANAGER (manager), NULL);
#line 221 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail ((prereq == NULL) || IS_ALTERATION (prereq), NULL);
#line 221 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail ((initial == NULL) || GEE_IS_COLLECTION (initial), NULL);
#line 225 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_halt_mirroring (self);
#line 227 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	data_collection_freeze_notifications (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 230 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = sources;
#line 230 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = manager;
#line 230 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = prereq;
#line 230 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3_ = view_collection_monitor_impl_new (self, _tmp0_, _tmp1_, _tmp2_);
#line 230 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	monitor = _tmp3_;
#line 231 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp4_ = self->priv->monitors;
#line 231 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp5_ = sources;
#line 231 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp6_ = monitor;
#line 231 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	gee_multi_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_MULTI_MAP, GeeMultiMap), _tmp5_, _tmp6_);
#line 233 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp8_ = initial;
#line 233 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp8_ != NULL) {
#line 1344 "ViewCollection.c"
		GeeCollection* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
#line 233 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp9_ = initial;
#line 233 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp10_ = gee_collection_get_size (_tmp9_);
#line 233 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp11_ = _tmp10_;
#line 233 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp7_ = _tmp11_ > 0;
#line 1356 "ViewCollection.c"
	} else {
#line 233 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp7_ = FALSE;
#line 1360 "ViewCollection.c"
	}
#line 233 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp7_) {
#line 1364 "ViewCollection.c"
		GeeArrayList* created_views = NULL;
		GeeArrayList* _tmp12_ = NULL;
		GeeArrayList* _tmp24_ = NULL;
		ProgressMonitor _tmp25_ = NULL;
		void* _tmp25__target = NULL;
		GeeCollection* _tmp26_ = NULL;
		GeeCollection* _tmp27_ = NULL;
#line 235 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp12_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 235 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		created_views = _tmp12_;
#line 1376 "ViewCollection.c"
		{
			GeeIterator* _source_it = NULL;
			GeeCollection* _tmp13_ = NULL;
			GeeIterator* _tmp14_ = NULL;
#line 236 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp13_ = initial;
#line 236 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp14_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ITERABLE, GeeIterable));
#line 236 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_source_it = _tmp14_;
#line 236 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			while (TRUE) {
#line 1389 "ViewCollection.c"
				GeeIterator* _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
				DataSource* source = NULL;
				GeeIterator* _tmp17_ = NULL;
				gpointer _tmp18_ = NULL;
				GeeArrayList* _tmp19_ = NULL;
				ViewManager* _tmp20_ = NULL;
				DataSource* _tmp21_ = NULL;
				DataView* _tmp22_ = NULL;
				DataView* _tmp23_ = NULL;
#line 236 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp15_ = _source_it;
#line 236 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp16_ = gee_iterator_next (_tmp15_);
#line 236 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				if (!_tmp16_) {
#line 236 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					break;
#line 1408 "ViewCollection.c"
				}
#line 236 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp17_ = _source_it;
#line 236 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp18_ = gee_iterator_get (_tmp17_);
#line 236 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				source = (DataSource*) _tmp18_;
#line 237 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp19_ = created_views;
#line 237 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp20_ = manager;
#line 237 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp21_ = source;
#line 237 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp22_ = view_manager_create_view (_tmp20_, _tmp21_);
#line 237 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp23_ = _tmp22_;
#line 237 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp23_);
#line 237 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_g_object_unref0 (_tmp23_);
#line 236 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_g_object_unref0 (source);
#line 1432 "ViewCollection.c"
			}
#line 236 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (_source_it);
#line 1436 "ViewCollection.c"
		}
#line 239 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp24_ = created_views;
#line 239 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp25_ = progress_monitor;
#line 239 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp25__target = progress_monitor_target;
#line 239 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp26_ = data_collection_add_many (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_COLLECTION, GeeCollection), _tmp25_, _tmp25__target);
#line 239 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp27_ = _tmp26_;
#line 239 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_tmp27_);
#line 233 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (created_views);
#line 1452 "ViewCollection.c"
	} else {
		SourceCollection* _tmp28_ = NULL;
		SourceCollection* _tmp29_ = NULL;
		GeeCollection* _tmp30_ = NULL;
		GeeIterable* _tmp31_ = NULL;
		ProgressMonitor _tmp32_ = NULL;
		void* _tmp32__target = NULL;
#line 242 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp28_ = sources;
#line 242 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp29_ = sources;
#line 242 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp30_ = data_collection_get_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, TYPE_DATA_COLLECTION, DataCollection));
#line 242 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp31_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEE_TYPE_ITERABLE, GeeIterable);
#line 242 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp32_ = progress_monitor;
#line 242 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp32__target = progress_monitor_target;
#line 242 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_collection_add_sources (self, _tmp28_, _tmp31_, _tmp32_, _tmp32__target);
#line 242 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_tmp31_);
#line 1476 "ViewCollection.c"
	}
#line 245 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	data_collection_thaw_notifications (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 247 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (monitor, VIEW_COLLECTION_TYPE_MONITOR, ViewCollectionMonitor);
#line 247 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 1484 "ViewCollection.c"
}


static gpointer _view_collection_monitor_ref0 (gpointer self) {
#line 251 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return self ? view_collection_monitor_ref (self) : NULL;
#line 1491 "ViewCollection.c"
}


void view_collection_halt_monitoring (ViewCollection* self, ViewCollectionMonitor* m) {
	ViewCollectionMonitorImpl* monitor = NULL;
	ViewCollectionMonitor* _tmp0_ = NULL;
	ViewCollectionMonitorImpl* _tmp1_ = NULL;
	gboolean removed = FALSE;
	GeeHashMultiMap* _tmp2_ = NULL;
	SourceCollection* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 250 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 250 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (VIEW_COLLECTION_IS_MONITOR (m));
#line 251 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = m;
#line 251 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = _view_collection_monitor_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VIEW_COLLECTION_TYPE_MONITOR_IMPL, ViewCollectionMonitorImpl));
#line 251 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	monitor = _tmp1_;
#line 253 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = self->priv->monitors;
#line 253 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3_ = monitor->sources;
#line 253 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp4_ = gee_multi_map_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_MULTI_MAP, GeeMultiMap), _tmp3_, monitor);
#line 253 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	removed = _tmp4_;
#line 254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_vala_assert (removed, "removed");
#line 250 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_view_collection_monitor_unref0 (monitor);
#line 1525 "ViewCollection.c"
}


void view_collection_halt_all_monitoring (ViewCollection* self) {
	GeeHashMultiMap* _tmp0_ = NULL;
#line 257 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 258 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = self->priv->monitors;
#line 258 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	gee_multi_map_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MULTI_MAP, GeeMultiMap));
#line 1537 "ViewCollection.c"
}


static gpointer _data_collection_ref0 (gpointer self) {
#line 267 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return self ? data_collection_ref (self) : NULL;
#line 1544 "ViewCollection.c"
}


static void _view_collection_on_mirror_contents_added_data_collection_items_added (DataCollection* _sender, GeeIterable* added, gpointer self) {
#line 275 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_on_mirror_contents_added ((ViewCollection*) self, added);
#line 1551 "ViewCollection.c"
}


static void _view_collection_on_mirror_contents_removed_data_collection_items_removed (DataCollection* _sender, GeeIterable* removed, gpointer self) {
#line 276 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_on_mirror_contents_removed ((ViewCollection*) self, removed);
#line 1558 "ViewCollection.c"
}


void view_collection_mirror (ViewCollection* self, ViewCollection* to_mirror, CreateView mirroring_ctor, void* mirroring_ctor_target, CreateViewPredicate should_mirror, void* should_mirror_target) {
	ViewCollection* _tmp0_ = NULL;
	ViewCollection* _tmp1_ = NULL;
	CreateView _tmp2_ = NULL;
	void* _tmp2__target = NULL;
	CreateViewPredicate _tmp3_ = NULL;
	void* _tmp3__target = NULL;
	ViewCollection* _tmp4_ = NULL;
	void* _tmp5_ = NULL;
	Comparator _tmp6_ = NULL;
	ViewCollection* _tmp7_ = NULL;
	void* _tmp8_ = NULL;
	ComparatorPredicate _tmp9_ = NULL;
	ViewCollection* _tmp10_ = NULL;
	GeeCollection* _tmp11_ = NULL;
	GeeCollection* _tmp12_ = NULL;
	ViewCollection* _tmp13_ = NULL;
	ViewCollection* _tmp14_ = NULL;
#line 261 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 261 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (to_mirror));
#line 263 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_halt_mirroring (self);
#line 264 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_halt_all_monitoring (self);
#line 265 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	data_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 267 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = to_mirror;
#line 267 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = _data_collection_ref0 (_tmp0_);
#line 267 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_data_collection_unref0 (self->priv->mirroring);
#line 267 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self->priv->mirroring = _tmp1_;
#line 268 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = mirroring_ctor;
#line 268 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2__target = mirroring_ctor_target;
#line 268 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self->priv->mirroring_ctor = _tmp2_;
#line 268 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self->priv->mirroring_ctor_target = _tmp2__target;
#line 269 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3_ = should_mirror;
#line 269 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3__target = should_mirror_target;
#line 269 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self->priv->should_mirror = _tmp3_;
#line 269 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self->priv->should_mirror_target = _tmp3__target;
#line 270 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp4_ = to_mirror;
#line 270 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp6_ = data_collection_get_comparator (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_COLLECTION, DataCollection), &_tmp5_);
#line 270 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp7_ = to_mirror;
#line 270 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp9_ = data_collection_get_comparator_predicate (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_COLLECTION, DataCollection), &_tmp8_);
#line 270 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	data_collection_set_comparator (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp6_, _tmp5_, _tmp9_, _tmp8_);
#line 273 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp10_ = self->priv->mirroring;
#line 273 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp11_ = data_collection_get_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_COLLECTION, DataCollection));
#line 273 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp12_ = _tmp11_;
#line 273 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_on_mirror_contents_added (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ITERABLE, GeeIterable));
#line 273 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (_tmp12_);
#line 275 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp13_ = self->priv->mirroring;
#line 275 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_DATA_COLLECTION, DataCollection), "items-added", (GCallback) _view_collection_on_mirror_contents_added_data_collection_items_added, self);
#line 276 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp14_ = self->priv->mirroring;
#line 276 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_DATA_COLLECTION, DataCollection), "items-removed", (GCallback) _view_collection_on_mirror_contents_removed_data_collection_items_removed, self);
#line 1642 "ViewCollection.c"
}


void view_collection_halt_mirroring (ViewCollection* self) {
	ViewCollection* _tmp0_ = NULL;
#line 279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 280 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = self->priv->mirroring;
#line 280 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp0_ != NULL) {
#line 1654 "ViewCollection.c"
		ViewCollection* _tmp1_ = NULL;
		guint _tmp2_ = 0U;
		ViewCollection* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
#line 281 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp1_ = self->priv->mirroring;
#line 281 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		g_signal_parse_name ("items-added", TYPE_DATA_COLLECTION, &_tmp2_, NULL, FALSE);
#line 281 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _view_collection_on_mirror_contents_added_data_collection_items_added, self);
#line 282 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp3_ = self->priv->mirroring;
#line 282 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		g_signal_parse_name ("items-removed", TYPE_DATA_COLLECTION, &_tmp4_, NULL, FALSE);
#line 282 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _view_collection_on_mirror_contents_removed_data_collection_items_removed, self);
#line 1671 "ViewCollection.c"
	}
#line 285 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_data_collection_unref0 (self->priv->mirroring);
#line 285 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self->priv->mirroring = NULL;
#line 1677 "ViewCollection.c"
}


void view_collection_copy_into (ViewCollection* self, ViewCollection* to_copy, CreateView copying_ctor, void* copying_ctor_target, CreateViewPredicate should_copy, void* should_copy_target) {
	GeeArrayList* copy_view = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp25_ = NULL;
	GeeCollection* _tmp26_ = NULL;
	GeeCollection* _tmp27_ = NULL;
#line 288 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 288 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (to_copy));
#line 291 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = gee_array_list_new (TYPE_DATA_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 291 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	copy_view = _tmp0_;
#line 1695 "ViewCollection.c"
	{
		GeeIterator* _object_it = NULL;
		ViewCollection* _tmp1_ = NULL;
		GeeCollection* _tmp2_ = NULL;
		GeeCollection* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 292 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp1_ = to_copy;
#line 292 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp2_ = data_collection_get_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_COLLECTION, DataCollection));
#line 292 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp3_ = _tmp2_;
#line 292 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 292 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp5_ = _tmp4_;
#line 292 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_tmp3_);
#line 292 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_object_it = _tmp5_;
#line 292 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		while (TRUE) {
#line 1719 "ViewCollection.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			DataObject* object = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			DataView* view = NULL;
			DataObject* _tmp10_ = NULL;
			DataView* _tmp11_ = NULL;
			CreateViewPredicate _tmp12_ = NULL;
			void* _tmp12__target = NULL;
			DataView* _tmp13_ = NULL;
			DataSource* _tmp14_ = NULL;
			DataSource* _tmp15_ = NULL;
			gboolean _tmp16_ = FALSE;
			gboolean _tmp17_ = FALSE;
#line 292 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp6_ = _object_it;
#line 292 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 292 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (!_tmp7_) {
#line 292 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				break;
#line 1743 "ViewCollection.c"
			}
#line 292 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp8_ = _object_it;
#line 292 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 292 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			object = (DataObject*) _tmp9_;
#line 293 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp10_ = object;
#line 293 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_VIEW, DataView));
#line 293 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			view = _tmp11_;
#line 294 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp12_ = should_copy;
#line 294 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp12__target = should_copy_target;
#line 294 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp13_ = view;
#line 294 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp14_ = data_view_get_source (_tmp13_);
#line 294 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp15_ = _tmp14_;
#line 294 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp16_ = _tmp12_ (_tmp15_, _tmp12__target);
#line 294 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp17_ = _tmp16_;
#line 294 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (_tmp15_);
#line 294 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (_tmp17_) {
#line 1775 "ViewCollection.c"
				GeeArrayList* _tmp18_ = NULL;
				CreateView _tmp19_ = NULL;
				void* _tmp19__target = NULL;
				DataView* _tmp20_ = NULL;
				DataSource* _tmp21_ = NULL;
				DataSource* _tmp22_ = NULL;
				DataView* _tmp23_ = NULL;
				DataView* _tmp24_ = NULL;
#line 295 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp18_ = copy_view;
#line 295 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp19_ = copying_ctor;
#line 295 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp19__target = copying_ctor_target;
#line 295 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp20_ = view;
#line 295 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp21_ = data_view_get_source (_tmp20_);
#line 295 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp22_ = _tmp21_;
#line 295 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp23_ = _tmp19_ (_tmp22_, _tmp19__target);
#line 295 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp24_ = _tmp23_;
#line 295 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, TYPE_DATA_OBJECT, DataObject));
#line 295 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_g_object_unref0 (_tmp24_);
#line 295 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_g_object_unref0 (_tmp22_);
#line 1806 "ViewCollection.c"
			}
#line 292 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (view);
#line 292 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (object);
#line 1812 "ViewCollection.c"
		}
#line 292 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_object_it);
#line 1816 "ViewCollection.c"
	}
#line 298 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp25_ = copy_view;
#line 298 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp26_ = data_collection_add_many (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_COLLECTION, GeeCollection), NULL, NULL);
#line 298 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp27_ = _tmp26_;
#line 298 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (_tmp27_);
#line 288 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (copy_view);
#line 1828 "ViewCollection.c"
}


gboolean view_collection_is_view_filter_installed (ViewCollection* self, ViewFilter* f) {
	gboolean result = FALSE;
	GeeSet* _tmp0_ = NULL;
	ViewFilter* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 301 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), FALSE);
#line 301 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_FILTER (f), FALSE);
#line 302 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = self->priv->filters;
#line 302 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = f;
#line 302 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), _tmp1_);
#line 302 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = _tmp2_;
#line 302 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 1851 "ViewCollection.c"
}


void view_collection_install_view_filter (ViewCollection* self, ViewFilter* f) {
	ViewFilter* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GeeSet* _tmp2_ = NULL;
	ViewFilter* _tmp3_ = NULL;
	ViewFilter* _tmp4_ = NULL;
	ViewFilter* _tmp5_ = NULL;
#line 305 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 305 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_FILTER (f));
#line 306 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = f;
#line 306 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = view_collection_is_view_filter_installed (self, _tmp0_);
#line 306 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp1_) {
#line 307 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		return;
#line 1874 "ViewCollection.c"
	}
#line 309 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = self->priv->filters;
#line 309 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3_ = f;
#line 309 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection), _tmp3_);
#line 310 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp4_ = f;
#line 310 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_connect (_tmp4_, "refresh", (GCallback) _view_collection_on_view_filter_refresh_view_filter_refresh, self);
#line 313 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_on_view_filter_refresh (self);
#line 316 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp5_ = f;
#line 316 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_notify_view_filter_installed (self, _tmp5_);
#line 1892 "ViewCollection.c"
}


void view_collection_remove_view_filter (ViewCollection* self, ViewFilter* f) {
	ViewFilter* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GeeSet* _tmp2_ = NULL;
	ViewFilter* _tmp3_ = NULL;
	ViewFilter* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	ViewFilter* _tmp6_ = NULL;
#line 319 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 319 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_FILTER (f));
#line 320 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = f;
#line 320 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = view_collection_is_view_filter_installed (self, _tmp0_);
#line 320 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (!_tmp1_) {
#line 321 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		return;
#line 1916 "ViewCollection.c"
	}
#line 323 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = self->priv->filters;
#line 323 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3_ = f;
#line 323 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection), _tmp3_);
#line 324 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp4_ = f;
#line 324 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_parse_name ("refresh", TYPE_VIEW_FILTER, &_tmp5_, NULL, FALSE);
#line 324 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _view_collection_on_view_filter_refresh_view_filter_refresh, self);
#line 327 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_on_view_filter_refresh (self);
#line 330 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp6_ = f;
#line 330 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_notify_view_filter_removed (self, _tmp6_);
#line 1936 "ViewCollection.c"
}


static void view_collection_on_view_filter_refresh (ViewCollection* self) {
	GeeCollection* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
#line 333 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 334 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = DATA_COLLECTION_CLASS (view_collection_parent_class)->get_all (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 334 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
#line 334 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_filter_altered_items (self, _tmp1_);
#line 334 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (_tmp1_);
#line 1953 "ViewCollection.c"
}


static gboolean view_collection_is_in_filter (ViewCollection* self, DataView* view) {
	gboolean result = FALSE;
#line 338 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), FALSE);
#line 338 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_DATA_VIEW (view), FALSE);
#line 1963 "ViewCollection.c"
	{
		GeeIterator* _f_it = NULL;
		GeeSet* _tmp0_ = NULL;
		GeeIterator* _tmp1_ = NULL;
#line 339 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp0_ = self->priv->filters;
#line 339 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERABLE, GeeIterable));
#line 339 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_f_it = _tmp1_;
#line 339 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		while (TRUE) {
#line 1976 "ViewCollection.c"
			GeeIterator* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
			ViewFilter* f = NULL;
			GeeIterator* _tmp4_ = NULL;
			gpointer _tmp5_ = NULL;
			ViewFilter* _tmp6_ = NULL;
			DataView* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
#line 339 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp2_ = _f_it;
#line 339 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 339 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (!_tmp3_) {
#line 339 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				break;
#line 1993 "ViewCollection.c"
			}
#line 339 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp4_ = _f_it;
#line 339 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 339 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			f = (ViewFilter*) _tmp5_;
#line 340 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp6_ = f;
#line 340 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp7_ = view;
#line 340 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp8_ = view_filter_predicate (_tmp6_, _tmp7_);
#line 340 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (!_tmp8_) {
#line 341 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				result = FALSE;
#line 341 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_view_filter_unref0 (f);
#line 341 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_g_object_unref0 (_f_it);
#line 341 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				return result;
#line 2017 "ViewCollection.c"
			}
#line 339 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_view_filter_unref0 (f);
#line 2021 "ViewCollection.c"
		}
#line 339 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_f_it);
#line 2025 "ViewCollection.c"
	}
#line 343 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = TRUE;
#line 343 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 2031 "ViewCollection.c"
}


static gboolean view_collection_real_valid_type (DataCollection* base, DataObject* object) {
	ViewCollection * self;
	gboolean result = FALSE;
	DataObject* _tmp0_ = NULL;
#line 346 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIEW_COLLECTION, ViewCollection);
#line 346 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 347 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = object;
#line 347 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_DATA_VIEW);
#line 347 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 2049 "ViewCollection.c"
}


static void view_collection_on_sources_added (ViewCollection* self, DataCollection* sources, GeeIterable* added) {
	DataCollection* _tmp0_ = NULL;
	GeeIterable* _tmp1_ = NULL;
#line 350 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 350 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_DATA_COLLECTION (sources));
#line 350 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (GEE_IS_ITERABLE (added));
#line 351 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = sources;
#line 351 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = added;
#line 351 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_add_sources (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_SOURCE_COLLECTION, SourceCollection), _tmp1_, NULL, NULL);
#line 2068 "ViewCollection.c"
}


static DataView* _view_manager_create_view_create_view (DataSource* source, gpointer self) {
	DataView* result;
	result = view_manager_create_view ((ViewManager*) self, source);
#line 364 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 2077 "ViewCollection.c"
}


static void view_collection_add_sources (ViewCollection* self, SourceCollection* sources, GeeIterable* added, ProgressMonitor progress_monitor, void* progress_monitor_target) {
	DataView* created_view = NULL;
	GeeArrayList* created_views = NULL;
	DataView* _tmp37_ = NULL;
#line 354 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 354 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (sources));
#line 354 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (GEE_IS_ITERABLE (added));
#line 358 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	created_view = NULL;
#line 359 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	created_views = NULL;
#line 2095 "ViewCollection.c"
	{
		GeeIterator* _source_it = NULL;
		GeeIterable* _tmp0_ = NULL;
		GeeIterator* _tmp1_ = NULL;
#line 360 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp0_ = added;
#line 360 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp1_ = gee_iterable_iterator (_tmp0_);
#line 360 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_source_it = _tmp1_;
#line 360 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		while (TRUE) {
#line 2108 "ViewCollection.c"
			GeeIterator* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
			DataSource* source = NULL;
			GeeIterator* _tmp4_ = NULL;
			gpointer _tmp5_ = NULL;
			CreateView factory = NULL;
			void* factory_target = NULL;
			GDestroyNotify factory_target_destroy_notify = NULL;
			CreateView _tmp22_ = NULL;
			void* _tmp22__target = NULL;
#line 360 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp2_ = _source_it;
#line 360 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 360 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (!_tmp3_) {
#line 360 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				break;
#line 2127 "ViewCollection.c"
			}
#line 360 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp4_ = _source_it;
#line 360 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 360 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			source = (DataSource*) _tmp5_;
#line 361 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			factory = NULL;
#line 361 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			factory_target = NULL;
#line 361 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			factory_target_destroy_notify = NULL;
#line 2141 "ViewCollection.c"
			{
				GeeIterator* _monitor_it = NULL;
				GeeHashMultiMap* _tmp6_ = NULL;
				SourceCollection* _tmp7_ = NULL;
				GeeCollection* _tmp8_ = NULL;
				GeeCollection* _tmp9_ = NULL;
				GeeIterator* _tmp10_ = NULL;
				GeeIterator* _tmp11_ = NULL;
#line 362 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp6_ = self->priv->monitors;
#line 362 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp7_ = sources;
#line 362 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp8_ = gee_multi_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_MULTI_MAP, GeeMultiMap), _tmp7_);
#line 362 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp9_ = _tmp8_;
#line 362 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp10_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ITERABLE, GeeIterable));
#line 362 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp11_ = _tmp10_;
#line 362 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_g_object_unref0 (_tmp9_);
#line 362 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_monitor_it = _tmp11_;
#line 362 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				while (TRUE) {
#line 2168 "ViewCollection.c"
					GeeIterator* _tmp12_ = NULL;
					gboolean _tmp13_ = FALSE;
					ViewCollectionMonitorImpl* monitor = NULL;
					GeeIterator* _tmp14_ = NULL;
					gpointer _tmp15_ = NULL;
					ViewCollectionMonitorImpl* _tmp16_ = NULL;
					ViewManager* _tmp17_ = NULL;
					DataSource* _tmp18_ = NULL;
					gboolean _tmp19_ = FALSE;
#line 362 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp12_ = _monitor_it;
#line 362 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp13_ = gee_iterator_next (_tmp12_);
#line 362 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					if (!_tmp13_) {
#line 362 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						break;
#line 2186 "ViewCollection.c"
					}
#line 362 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp14_ = _monitor_it;
#line 362 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp15_ = gee_iterator_get (_tmp14_);
#line 362 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					monitor = (ViewCollectionMonitorImpl*) _tmp15_;
#line 363 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp16_ = monitor;
#line 363 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp17_ = _tmp16_->manager;
#line 363 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp18_ = source;
#line 363 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp19_ = view_manager_include_in_view (_tmp17_, _tmp18_);
#line 363 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					if (_tmp19_) {
#line 2204 "ViewCollection.c"
						ViewCollectionMonitorImpl* _tmp20_ = NULL;
						ViewManager* _tmp21_ = NULL;
#line 364 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp20_ = monitor;
#line 364 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp21_ = _tmp20_->manager;
#line 364 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						(factory_target_destroy_notify == NULL) ? NULL : (factory_target_destroy_notify (factory_target), NULL);
#line 364 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						factory = NULL;
#line 364 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						factory_target = NULL;
#line 364 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						factory_target_destroy_notify = NULL;
#line 364 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						factory = _view_manager_create_view_create_view;
#line 364 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						factory_target = view_manager_ref (_tmp21_);
#line 364 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						factory_target_destroy_notify = view_manager_unref;
#line 366 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_view_collection_monitor_unref0 (monitor);
#line 366 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						break;
#line 2229 "ViewCollection.c"
					}
#line 362 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_view_collection_monitor_unref0 (monitor);
#line 2233 "ViewCollection.c"
				}
#line 362 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_g_object_unref0 (_monitor_it);
#line 2237 "ViewCollection.c"
			}
#line 370 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp22_ = factory;
#line 370 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp22__target = factory_target;
#line 370 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (_tmp22_ != NULL) {
#line 2245 "ViewCollection.c"
				DataView* new_view = NULL;
				CreateView _tmp23_ = NULL;
				void* _tmp23__target = NULL;
				DataSource* _tmp24_ = NULL;
				DataView* _tmp25_ = NULL;
				GeeArrayList* _tmp26_ = NULL;
#line 371 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp23_ = factory;
#line 371 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp23__target = factory_target;
#line 371 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp24_ = source;
#line 371 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp25_ = _tmp23_ (_tmp24_, _tmp23__target);
#line 371 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				new_view = _tmp25_;
#line 375 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp26_ = created_views;
#line 375 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				if (_tmp26_ != NULL) {
#line 2266 "ViewCollection.c"
					GeeArrayList* _tmp27_ = NULL;
					DataView* _tmp28_ = NULL;
#line 376 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp27_ = created_views;
#line 376 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp28_ = new_view;
#line 376 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp28_);
#line 2275 "ViewCollection.c"
				} else {
					DataView* _tmp29_ = NULL;
#line 377 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp29_ = created_view;
#line 377 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					if (_tmp29_ == NULL) {
#line 2282 "ViewCollection.c"
						DataView* _tmp30_ = NULL;
						DataView* _tmp31_ = NULL;
#line 378 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp30_ = new_view;
#line 378 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp31_ = _g_object_ref0 (_tmp30_);
#line 378 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_g_object_unref0 (created_view);
#line 378 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						created_view = _tmp31_;
#line 2293 "ViewCollection.c"
					} else {
						GeeArrayList* _tmp32_ = NULL;
						GeeArrayList* _tmp33_ = NULL;
						DataView* _tmp34_ = NULL;
						GeeArrayList* _tmp35_ = NULL;
						DataView* _tmp36_ = NULL;
#line 380 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp32_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 380 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_g_object_unref0 (created_views);
#line 380 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						created_views = _tmp32_;
#line 381 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp33_ = created_views;
#line 381 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp34_ = created_view;
#line 381 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp34_);
#line 382 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_g_object_unref0 (created_view);
#line 382 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						created_view = NULL;
#line 383 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp35_ = created_views;
#line 383 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp36_ = new_view;
#line 383 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp36_);
#line 2322 "ViewCollection.c"
					}
				}
#line 370 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_g_object_unref0 (new_view);
#line 2327 "ViewCollection.c"
			}
#line 360 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			(factory_target_destroy_notify == NULL) ? NULL : (factory_target_destroy_notify (factory_target), NULL);
#line 360 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			factory = NULL;
#line 360 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			factory_target = NULL;
#line 360 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			factory_target_destroy_notify = NULL;
#line 360 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (source);
#line 2339 "ViewCollection.c"
		}
#line 360 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_source_it);
#line 2343 "ViewCollection.c"
	}
#line 388 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp37_ = created_view;
#line 388 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp37_ != NULL) {
#line 2349 "ViewCollection.c"
		DataView* _tmp38_ = NULL;
#line 389 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp38_ = created_view;
#line 389 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		data_collection_add (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, TYPE_DATA_OBJECT, DataObject));
#line 2355 "ViewCollection.c"
	} else {
		gboolean _tmp39_ = FALSE;
		GeeArrayList* _tmp40_ = NULL;
#line 390 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp40_ = created_views;
#line 390 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		if (_tmp40_ != NULL) {
#line 2363 "ViewCollection.c"
			GeeArrayList* _tmp41_ = NULL;
			gint _tmp42_ = 0;
			gint _tmp43_ = 0;
#line 390 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp41_ = created_views;
#line 390 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp42_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 390 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp43_ = _tmp42_;
#line 390 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp39_ = _tmp43_ > 0;
#line 2375 "ViewCollection.c"
		} else {
#line 390 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp39_ = FALSE;
#line 2379 "ViewCollection.c"
		}
#line 390 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		if (_tmp39_) {
#line 2383 "ViewCollection.c"
			GeeArrayList* _tmp44_ = NULL;
			ProgressMonitor _tmp45_ = NULL;
			void* _tmp45__target = NULL;
			GeeCollection* _tmp46_ = NULL;
			GeeCollection* _tmp47_ = NULL;
#line 391 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp44_ = created_views;
#line 391 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp45_ = progress_monitor;
#line 391 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp45__target = progress_monitor_target;
#line 391 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp46_ = data_collection_add_many (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, GEE_TYPE_COLLECTION, GeeCollection), _tmp45_, _tmp45__target);
#line 391 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp47_ = _tmp46_;
#line 391 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (_tmp47_);
#line 2401 "ViewCollection.c"
		}
	}
#line 354 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (created_views);
#line 354 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (created_view);
#line 2408 "ViewCollection.c"
}


static gboolean view_collection_real_add (DataCollection* base, DataObject* object) {
	ViewCollection * self;
	gboolean result = FALSE;
	DataObject* _tmp0_ = NULL;
	DataObject* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	DataObject* _tmp3_ = NULL;
	GeeCollection* _tmp4_ = NULL;
	GeeCollection* _tmp5_ = NULL;
#line 394 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIEW_COLLECTION, ViewCollection);
#line 394 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 395 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = object;
#line 395 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	data_view_internal_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_VIEW, DataView), TRUE);
#line 397 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = object;
#line 397 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = DATA_COLLECTION_CLASS (view_collection_parent_class)->add (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp1_);
#line 397 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (!_tmp2_) {
#line 398 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		result = FALSE;
#line 398 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		return result;
#line 2439 "ViewCollection.c"
	}
#line 400 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3_ = object;
#line 400 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp4_ = data_collection_get_singleton (_tmp3_);
#line 400 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection);
#line 400 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_filter_altered_items (self, _tmp5_);
#line 400 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (_tmp5_);
#line 402 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = TRUE;
#line 402 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 2455 "ViewCollection.c"
}


static GeeCollection* view_collection_real_add_many (DataCollection* base, GeeCollection* objects, ProgressMonitor monitor, void* monitor_target) {
	ViewCollection * self;
	GeeCollection* result = NULL;
	GeeCollection* return_list = NULL;
	GeeCollection* _tmp7_ = NULL;
	ProgressMonitor _tmp8_ = NULL;
	void* _tmp8__target = NULL;
	GeeCollection* _tmp9_ = NULL;
#line 405 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIEW_COLLECTION, ViewCollection);
#line 405 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (objects), NULL);
#line 2471 "ViewCollection.c"
	{
		GeeIterator* _object_it = NULL;
		GeeCollection* _tmp0_ = NULL;
		GeeIterator* _tmp1_ = NULL;
#line 407 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp0_ = objects;
#line 407 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERABLE, GeeIterable));
#line 407 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_object_it = _tmp1_;
#line 407 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		while (TRUE) {
#line 2484 "ViewCollection.c"
			GeeIterator* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
			DataObject* object = NULL;
			GeeIterator* _tmp4_ = NULL;
			gpointer _tmp5_ = NULL;
			DataObject* _tmp6_ = NULL;
#line 407 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp2_ = _object_it;
#line 407 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 407 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (!_tmp3_) {
#line 407 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				break;
#line 2499 "ViewCollection.c"
			}
#line 407 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp4_ = _object_it;
#line 407 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 407 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			object = (DataObject*) _tmp5_;
#line 408 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp6_ = object;
#line 408 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			data_view_internal_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_DATA_VIEW, DataView), TRUE);
#line 407 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (object);
#line 2513 "ViewCollection.c"
		}
#line 407 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_object_it);
#line 2517 "ViewCollection.c"
	}
#line 410 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp7_ = objects;
#line 410 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp8_ = monitor;
#line 410 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp8__target = monitor_target;
#line 410 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp9_ = DATA_COLLECTION_CLASS (view_collection_parent_class)->add_many (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp7_, _tmp8_, _tmp8__target);
#line 410 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return_list = _tmp9_;
#line 412 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_filter_altered_items (self, G_TYPE_CHECK_INSTANCE_CAST (return_list, GEE_TYPE_COLLECTION, GeeCollection));
#line 414 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = return_list;
#line 414 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 2535 "ViewCollection.c"
}


static void view_collection_on_sources_removed (ViewCollection* self, GeeIterable* removed) {
	Marker* marker = NULL;
	gboolean _tmp14_ = FALSE;
	Marker* _tmp15_ = NULL;
#line 417 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 417 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (GEE_IS_ITERABLE (removed));
#line 419 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	marker = NULL;
#line 2549 "ViewCollection.c"
	{
		GeeIterator* _source_it = NULL;
		GeeIterable* _tmp0_ = NULL;
		GeeIterator* _tmp1_ = NULL;
#line 420 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp0_ = removed;
#line 420 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp1_ = gee_iterable_iterator (_tmp0_);
#line 420 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_source_it = _tmp1_;
#line 420 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		while (TRUE) {
#line 2562 "ViewCollection.c"
			GeeIterator* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
			DataSource* source = NULL;
			GeeIterator* _tmp4_ = NULL;
			gpointer _tmp5_ = NULL;
			DataView* view = NULL;
			GeeHashMap* _tmp6_ = NULL;
			DataSource* _tmp7_ = NULL;
			gpointer _tmp8_ = NULL;
			DataView* _tmp9_ = NULL;
#line 420 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp2_ = _source_it;
#line 420 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 420 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (!_tmp3_) {
#line 420 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				break;
#line 2581 "ViewCollection.c"
			}
#line 420 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp4_ = _source_it;
#line 420 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 420 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			source = (DataSource*) _tmp5_;
#line 421 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp6_ = self->priv->source_map;
#line 421 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp7_ = source;
#line 421 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp8_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp7_);
#line 421 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			view = (DataView*) _tmp8_;
#line 424 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp9_ = view;
#line 424 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (_tmp9_ != NULL) {
#line 2601 "ViewCollection.c"
				Marker* _tmp10_ = NULL;
				Marker* _tmp12_ = NULL;
				DataView* _tmp13_ = NULL;
#line 425 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp10_ = marker;
#line 425 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				if (_tmp10_ == NULL) {
#line 2609 "ViewCollection.c"
					Marker* _tmp11_ = NULL;
#line 426 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp11_ = data_collection_start_marking (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 426 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_g_object_unref0 (marker);
#line 426 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					marker = _tmp11_;
#line 2617 "ViewCollection.c"
				}
#line 428 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp12_ = marker;
#line 428 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp13_ = view;
#line 428 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				marker_mark (_tmp12_, G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_DATA_OBJECT, DataObject));
#line 2625 "ViewCollection.c"
			}
#line 420 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (view);
#line 420 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (source);
#line 2631 "ViewCollection.c"
		}
#line 420 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_source_it);
#line 2635 "ViewCollection.c"
	}
#line 432 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp15_ = marker;
#line 432 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp15_ != NULL) {
#line 2641 "ViewCollection.c"
		Marker* _tmp16_ = NULL;
		gint _tmp17_ = 0;
#line 432 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp16_ = marker;
#line 432 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp17_ = marker_get_count (_tmp16_);
#line 432 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp14_ = _tmp17_ != 0;
#line 2650 "ViewCollection.c"
	} else {
#line 432 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp14_ = FALSE;
#line 2654 "ViewCollection.c"
	}
#line 432 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp14_) {
#line 2658 "ViewCollection.c"
		Marker* _tmp18_ = NULL;
#line 433 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp18_ = marker;
#line 433 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		data_collection_remove_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp18_);
#line 2664 "ViewCollection.c"
	}
#line 417 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (marker);
#line 2668 "ViewCollection.c"
}


static void view_collection_on_sources_altered (ViewCollection* self, DataCollection* collection, GeeMap* items) {
	GeeArrayList* to_add = NULL;
	GeeArrayList* to_remove = NULL;
	gboolean ordering_changed = FALSE;
	GeeArrayList* _tmp82_ = NULL;
	GeeArrayList* _tmp86_ = NULL;
	gboolean _tmp90_ = FALSE;
#line 436 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 436 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_DATA_COLLECTION (collection));
#line 436 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (GEE_IS_MAP (items));
#line 439 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	to_add = NULL;
#line 440 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	to_remove = NULL;
#line 441 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	ordering_changed = FALSE;
#line 2691 "ViewCollection.c"
	{
		GeeIterator* _object_it = NULL;
		GeeMap* _tmp0_ = NULL;
		GeeSet* _tmp1_ = NULL;
		GeeSet* _tmp2_ = NULL;
		GeeSet* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 442 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp0_ = items;
#line 442 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp1_ = gee_map_get_keys (_tmp0_);
#line 442 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp2_ = _tmp1_;
#line 442 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp3_ = _tmp2_;
#line 442 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 442 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp5_ = _tmp4_;
#line 442 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_tmp3_);
#line 442 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_object_it = _tmp5_;
#line 442 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		while (TRUE) {
#line 2718 "ViewCollection.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			DataObject* object = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			Alteration* alteration = NULL;
			GeeMap* _tmp10_ = NULL;
			DataObject* _tmp11_ = NULL;
			gpointer _tmp12_ = NULL;
			DataSource* source = NULL;
			DataObject* _tmp13_ = NULL;
			DataSource* _tmp14_ = NULL;
			ViewCollectionMonitorImpl* monitor = NULL;
			gboolean ignored = FALSE;
			gboolean _tmp38_ = FALSE;
			gboolean _tmp40_ = FALSE;
			ViewCollectionMonitorImpl* _tmp41_ = NULL;
#line 442 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp6_ = _object_it;
#line 442 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 442 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (!_tmp7_) {
#line 442 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				break;
#line 2744 "ViewCollection.c"
			}
#line 442 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp8_ = _object_it;
#line 442 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 442 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			object = (DataObject*) _tmp9_;
#line 443 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp10_ = items;
#line 443 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp11_ = object;
#line 443 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp12_ = gee_map_get (_tmp10_, _tmp11_);
#line 443 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			alteration = (Alteration*) _tmp12_;
#line 444 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp13_ = object;
#line 444 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_DATA_SOURCE, DataSource));
#line 444 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			source = _tmp14_;
#line 446 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			monitor = NULL;
#line 447 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			ignored = TRUE;
#line 2770 "ViewCollection.c"
			{
				GeeIterator* _monitor_impl_it = NULL;
				GeeHashMultiMap* _tmp15_ = NULL;
				DataCollection* _tmp16_ = NULL;
				GeeCollection* _tmp17_ = NULL;
				GeeCollection* _tmp18_ = NULL;
				GeeIterator* _tmp19_ = NULL;
				GeeIterator* _tmp20_ = NULL;
#line 448 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp15_ = self->priv->monitors;
#line 448 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp16_ = collection;
#line 448 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp17_ = gee_multi_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_MULTI_MAP, GeeMultiMap), G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_SOURCE_COLLECTION, SourceCollection));
#line 448 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp18_ = _tmp17_;
#line 448 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp19_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ITERABLE, GeeIterable));
#line 448 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp20_ = _tmp19_;
#line 448 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_g_object_unref0 (_tmp18_);
#line 448 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_monitor_impl_it = _tmp20_;
#line 448 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				while (TRUE) {
#line 2797 "ViewCollection.c"
					GeeIterator* _tmp21_ = NULL;
					gboolean _tmp22_ = FALSE;
					ViewCollectionMonitorImpl* monitor_impl = NULL;
					GeeIterator* _tmp23_ = NULL;
					gpointer _tmp24_ = NULL;
					gboolean _tmp25_ = FALSE;
					ViewCollectionMonitorImpl* _tmp26_ = NULL;
					Alteration* _tmp27_ = NULL;
					ViewCollectionMonitorImpl* _tmp32_ = NULL;
					ViewManager* _tmp33_ = NULL;
					DataSource* _tmp34_ = NULL;
					gboolean _tmp35_ = FALSE;
#line 448 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp21_ = _monitor_impl_it;
#line 448 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp22_ = gee_iterator_next (_tmp21_);
#line 448 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					if (!_tmp22_) {
#line 448 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						break;
#line 2818 "ViewCollection.c"
					}
#line 448 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp23_ = _monitor_impl_it;
#line 448 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp24_ = gee_iterator_get (_tmp23_);
#line 448 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					monitor_impl = (ViewCollectionMonitorImpl*) _tmp24_;
#line 449 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp26_ = monitor_impl;
#line 449 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp27_ = _tmp26_->prereq;
#line 449 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					if (_tmp27_ != NULL) {
#line 2832 "ViewCollection.c"
						Alteration* _tmp28_ = NULL;
						ViewCollectionMonitorImpl* _tmp29_ = NULL;
						Alteration* _tmp30_ = NULL;
						gboolean _tmp31_ = FALSE;
#line 449 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp28_ = alteration;
#line 449 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp29_ = monitor_impl;
#line 449 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp30_ = _tmp29_->prereq;
#line 449 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp31_ = alteration_contains_any (_tmp28_, _tmp30_);
#line 449 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp25_ = !_tmp31_;
#line 2847 "ViewCollection.c"
					} else {
#line 449 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp25_ = FALSE;
#line 2851 "ViewCollection.c"
					}
#line 449 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					if (_tmp25_) {
#line 450 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_view_collection_monitor_unref0 (monitor_impl);
#line 450 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						continue;
#line 2859 "ViewCollection.c"
					}
#line 452 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					ignored = FALSE;
#line 454 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp32_ = monitor_impl;
#line 454 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp33_ = _tmp32_->manager;
#line 454 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp34_ = source;
#line 454 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp35_ = view_manager_include_in_view (_tmp33_, _tmp34_);
#line 454 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					if (_tmp35_) {
#line 2873 "ViewCollection.c"
						ViewCollectionMonitorImpl* _tmp36_ = NULL;
						ViewCollectionMonitorImpl* _tmp37_ = NULL;
#line 455 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp36_ = monitor_impl;
#line 455 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp37_ = _view_collection_monitor_ref0 (_tmp36_);
#line 455 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_view_collection_monitor_unref0 (monitor);
#line 455 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						monitor = _tmp37_;
#line 457 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_view_collection_monitor_unref0 (monitor_impl);
#line 457 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						break;
#line 2888 "ViewCollection.c"
					}
#line 448 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_view_collection_monitor_unref0 (monitor_impl);
#line 2892 "ViewCollection.c"
				}
#line 448 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_g_object_unref0 (_monitor_impl_it);
#line 2896 "ViewCollection.c"
			}
#line 461 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp38_ = ignored;
#line 461 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (_tmp38_) {
#line 2902 "ViewCollection.c"
				ViewCollectionMonitorImpl* _tmp39_ = NULL;
#line 462 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp39_ = monitor;
#line 462 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_vala_assert (_tmp39_ == NULL, "monitor == null");
#line 464 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_view_collection_monitor_unref0 (monitor);
#line 464 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_g_object_unref0 (source);
#line 464 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_alteration_unref0 (alteration);
#line 464 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_g_object_unref0 (object);
#line 464 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				continue;
#line 2918 "ViewCollection.c"
			}
#line 467 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp41_ = monitor;
#line 467 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (_tmp41_ != NULL) {
#line 2924 "ViewCollection.c"
				DataSource* _tmp42_ = NULL;
				gboolean _tmp43_ = FALSE;
#line 467 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp42_ = source;
#line 467 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp43_ = view_collection_has_view_for_source (self, _tmp42_);
#line 467 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp40_ = !_tmp43_;
#line 2933 "ViewCollection.c"
			} else {
#line 467 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp40_ = FALSE;
#line 2937 "ViewCollection.c"
			}
#line 467 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (_tmp40_) {
#line 2941 "ViewCollection.c"
				GeeArrayList* _tmp44_ = NULL;
				GeeArrayList* _tmp46_ = NULL;
				ViewCollectionMonitorImpl* _tmp47_ = NULL;
				ViewManager* _tmp48_ = NULL;
				DataSource* _tmp49_ = NULL;
				DataView* _tmp50_ = NULL;
				DataView* _tmp51_ = NULL;
#line 468 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp44_ = to_add;
#line 468 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				if (_tmp44_ == NULL) {
#line 2953 "ViewCollection.c"
					GeeArrayList* _tmp45_ = NULL;
#line 469 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp45_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 469 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_g_object_unref0 (to_add);
#line 469 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					to_add = _tmp45_;
#line 2961 "ViewCollection.c"
				}
#line 471 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp46_ = to_add;
#line 471 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp47_ = monitor;
#line 471 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp48_ = _tmp47_->manager;
#line 471 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp49_ = source;
#line 471 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp50_ = view_manager_create_view (_tmp48_, _tmp49_);
#line 471 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp51_ = _tmp50_;
#line 471 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp51_);
#line 471 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_g_object_unref0 (_tmp51_);
#line 2979 "ViewCollection.c"
			} else {
				gboolean _tmp52_ = FALSE;
				ViewCollectionMonitorImpl* _tmp53_ = NULL;
#line 472 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp53_ = monitor;
#line 472 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				if (_tmp53_ == NULL) {
#line 2987 "ViewCollection.c"
					DataSource* _tmp54_ = NULL;
					gboolean _tmp55_ = FALSE;
#line 472 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp54_ = source;
#line 472 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp55_ = view_collection_has_view_for_source (self, _tmp54_);
#line 472 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp52_ = _tmp55_;
#line 2996 "ViewCollection.c"
				} else {
#line 472 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp52_ = FALSE;
#line 3000 "ViewCollection.c"
				}
#line 472 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				if (_tmp52_) {
#line 3004 "ViewCollection.c"
					GeeArrayList* _tmp56_ = NULL;
					GeeArrayList* _tmp58_ = NULL;
					DataSource* _tmp59_ = NULL;
					DataView* _tmp60_ = NULL;
					DataView* _tmp61_ = NULL;
#line 473 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp56_ = to_remove;
#line 473 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					if (_tmp56_ == NULL) {
#line 3014 "ViewCollection.c"
						GeeArrayList* _tmp57_ = NULL;
#line 474 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp57_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 474 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_g_object_unref0 (to_remove);
#line 474 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						to_remove = _tmp57_;
#line 3022 "ViewCollection.c"
					}
#line 476 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp58_ = to_remove;
#line 476 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp59_ = source;
#line 476 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp60_ = view_collection_get_view_for_source (self, _tmp59_);
#line 476 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp61_ = _tmp60_;
#line 476 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp61_);
#line 476 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_g_object_unref0 (_tmp61_);
#line 3036 "ViewCollection.c"
				} else {
					gboolean _tmp62_ = FALSE;
					ViewCollectionMonitorImpl* _tmp63_ = NULL;
#line 477 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp63_ = monitor;
#line 477 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					if (_tmp63_ != NULL) {
#line 3044 "ViewCollection.c"
						DataSource* _tmp64_ = NULL;
						gboolean _tmp65_ = FALSE;
#line 477 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp64_ = source;
#line 477 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp65_ = view_collection_has_view_for_source (self, _tmp64_);
#line 477 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp62_ = _tmp65_;
#line 3053 "ViewCollection.c"
					} else {
#line 477 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp62_ = FALSE;
#line 3057 "ViewCollection.c"
					}
#line 477 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					if (_tmp62_) {
#line 3061 "ViewCollection.c"
						DataView* view = NULL;
						DataSource* _tmp66_ = NULL;
						DataView* _tmp67_ = NULL;
						DataSet* _tmp68_ = NULL;
						DataView* _tmp69_ = NULL;
						gboolean _tmp70_ = FALSE;
						gboolean _tmp74_ = FALSE;
						DataSet* _tmp75_ = NULL;
#line 478 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp66_ = source;
#line 478 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp67_ = view_collection_get_view_for_source (self, _tmp66_);
#line 478 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						view = _tmp67_;
#line 480 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp68_ = self->priv->selected;
#line 480 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp69_ = view;
#line 480 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp70_ = data_set_contains (_tmp68_, G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, TYPE_DATA_OBJECT, DataObject));
#line 480 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						if (_tmp70_) {
#line 3084 "ViewCollection.c"
							DataSet* _tmp71_ = NULL;
							DataView* _tmp72_ = NULL;
							Alteration* _tmp73_ = NULL;
#line 481 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
							_tmp71_ = self->priv->selected;
#line 481 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
							_tmp72_ = view;
#line 481 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
							_tmp73_ = alteration;
#line 481 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
							data_set_resort_object (_tmp71_, G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, TYPE_DATA_OBJECT, DataObject), _tmp73_);
#line 3096 "ViewCollection.c"
						}
#line 483 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp75_ = self->priv->visible;
#line 483 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						if (_tmp75_ != NULL) {
#line 3102 "ViewCollection.c"
							DataView* _tmp76_ = NULL;
							gboolean _tmp77_ = FALSE;
#line 483 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
							_tmp76_ = view;
#line 483 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
							_tmp77_ = view_collection_is_visible (self, _tmp76_);
#line 483 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
							_tmp74_ = _tmp77_;
#line 3111 "ViewCollection.c"
						} else {
#line 483 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
							_tmp74_ = FALSE;
#line 3115 "ViewCollection.c"
						}
#line 483 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						if (_tmp74_) {
#line 3119 "ViewCollection.c"
							DataSet* _tmp78_ = NULL;
							DataView* _tmp79_ = NULL;
							Alteration* _tmp80_ = NULL;
							gboolean _tmp81_ = FALSE;
#line 484 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
							_tmp78_ = self->priv->visible;
#line 484 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
							_tmp79_ = view;
#line 484 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
							_tmp80_ = alteration;
#line 484 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
							_tmp81_ = data_set_resort_object (_tmp78_, G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, TYPE_DATA_OBJECT, DataObject), _tmp80_);
#line 484 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
							if (_tmp81_) {
#line 485 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
								ordering_changed = TRUE;
#line 3136 "ViewCollection.c"
							}
						}
#line 477 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_g_object_unref0 (view);
#line 3141 "ViewCollection.c"
					}
				}
			}
#line 442 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_view_collection_monitor_unref0 (monitor);
#line 442 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (source);
#line 442 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_alteration_unref0 (alteration);
#line 442 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (object);
#line 3153 "ViewCollection.c"
		}
#line 442 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_object_it);
#line 3157 "ViewCollection.c"
	}
#line 490 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp82_ = to_add;
#line 490 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp82_ != NULL) {
#line 3163 "ViewCollection.c"
		GeeArrayList* _tmp83_ = NULL;
		GeeCollection* _tmp84_ = NULL;
		GeeCollection* _tmp85_ = NULL;
#line 491 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp83_ = to_add;
#line 491 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp84_ = data_collection_add_many (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, GEE_TYPE_COLLECTION, GeeCollection), NULL, NULL);
#line 491 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp85_ = _tmp84_;
#line 491 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_tmp85_);
#line 3175 "ViewCollection.c"
	}
#line 493 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp86_ = to_remove;
#line 493 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp86_ != NULL) {
#line 3181 "ViewCollection.c"
		GeeArrayList* _tmp87_ = NULL;
		Marker* _tmp88_ = NULL;
		Marker* _tmp89_ = NULL;
#line 494 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp87_ = to_remove;
#line 494 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp88_ = data_collection_mark_many (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, GEE_TYPE_COLLECTION, GeeCollection));
#line 494 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp89_ = _tmp88_;
#line 494 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		data_collection_remove_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp89_);
#line 494 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_tmp89_);
#line 3195 "ViewCollection.c"
	}
#line 496 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp90_ = ordering_changed;
#line 496 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp90_) {
#line 497 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		data_collection_notify_ordering_changed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 3203 "ViewCollection.c"
	}
#line 436 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (to_remove);
#line 436 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (to_add);
#line 3209 "ViewCollection.c"
}


static void view_collection_on_mirror_contents_added (ViewCollection* self, GeeIterable* added) {
	GeeArrayList* to_add = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
#line 500 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 500 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (GEE_IS_ITERABLE (added));
#line 501 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 501 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	to_add = _tmp0_;
#line 3227 "ViewCollection.c"
	{
		GeeIterator* _object_it = NULL;
		GeeIterable* _tmp1_ = NULL;
		GeeIterator* _tmp2_ = NULL;
#line 502 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp1_ = added;
#line 502 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp2_ = gee_iterable_iterator (_tmp1_);
#line 502 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_object_it = _tmp2_;
#line 502 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		while (TRUE) {
#line 3240 "ViewCollection.c"
			GeeIterator* _tmp3_ = NULL;
			gboolean _tmp4_ = FALSE;
			DataObject* object = NULL;
			GeeIterator* _tmp5_ = NULL;
			gpointer _tmp6_ = NULL;
			DataSource* source = NULL;
			DataObject* _tmp7_ = NULL;
			DataSource* _tmp8_ = NULL;
			gboolean _tmp9_ = FALSE;
			CreateViewPredicate _tmp10_ = NULL;
			void* _tmp10__target = NULL;
#line 502 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp3_ = _object_it;
#line 502 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp4_ = gee_iterator_next (_tmp3_);
#line 502 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (!_tmp4_) {
#line 502 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				break;
#line 3260 "ViewCollection.c"
			}
#line 502 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp5_ = _object_it;
#line 502 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 502 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			object = (DataObject*) _tmp6_;
#line 503 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp7_ = object;
#line 503 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp8_ = data_view_get_source (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_VIEW, DataView));
#line 503 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			source = _tmp8_;
#line 505 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp10_ = self->priv->should_mirror;
#line 505 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp10__target = self->priv->should_mirror_target;
#line 505 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (_tmp10_ == NULL) {
#line 505 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp9_ = TRUE;
#line 3282 "ViewCollection.c"
			} else {
				CreateViewPredicate _tmp11_ = NULL;
				void* _tmp11__target = NULL;
				DataSource* _tmp12_ = NULL;
				gboolean _tmp13_ = FALSE;
#line 505 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp11_ = self->priv->should_mirror;
#line 505 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp11__target = self->priv->should_mirror_target;
#line 505 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp12_ = source;
#line 505 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp13_ = _tmp11_ (_tmp12_, _tmp11__target);
#line 505 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp9_ = _tmp13_;
#line 3298 "ViewCollection.c"
			}
#line 505 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (_tmp9_) {
#line 3302 "ViewCollection.c"
				GeeArrayList* _tmp14_ = NULL;
				CreateView _tmp15_ = NULL;
				void* _tmp15__target = NULL;
				DataSource* _tmp16_ = NULL;
				DataView* _tmp17_ = NULL;
				DataView* _tmp18_ = NULL;
#line 506 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp14_ = to_add;
#line 506 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp15_ = self->priv->mirroring_ctor;
#line 506 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp15__target = self->priv->mirroring_ctor_target;
#line 506 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp16_ = source;
#line 506 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp17_ = _tmp15_ (_tmp16_, _tmp15__target);
#line 506 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp18_ = _tmp17_;
#line 506 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp18_);
#line 506 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_g_object_unref0 (_tmp18_);
#line 3325 "ViewCollection.c"
			}
#line 502 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (source);
#line 502 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (object);
#line 3331 "ViewCollection.c"
		}
#line 502 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_object_it);
#line 3335 "ViewCollection.c"
	}
#line 509 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp19_ = to_add;
#line 509 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp20_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 509 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp21_ = _tmp20_;
#line 509 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp21_ > 0) {
#line 3345 "ViewCollection.c"
		GeeArrayList* _tmp22_ = NULL;
		GeeCollection* _tmp23_ = NULL;
		GeeCollection* _tmp24_ = NULL;
#line 510 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp22_ = to_add;
#line 510 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp23_ = data_collection_add_many (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_COLLECTION, GeeCollection), NULL, NULL);
#line 510 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp24_ = _tmp23_;
#line 510 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_tmp24_);
#line 3357 "ViewCollection.c"
	}
#line 500 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (to_add);
#line 3361 "ViewCollection.c"
}


static void view_collection_on_mirror_contents_removed (ViewCollection* self, GeeIterable* removed) {
	Marker* marker = NULL;
	Marker* _tmp0_ = NULL;
	Marker* _tmp17_ = NULL;
#line 513 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 513 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (GEE_IS_ITERABLE (removed));
#line 514 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = data_collection_start_marking (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 514 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	marker = _tmp0_;
#line 3377 "ViewCollection.c"
	{
		GeeIterator* _object_it = NULL;
		GeeIterable* _tmp1_ = NULL;
		GeeIterator* _tmp2_ = NULL;
#line 515 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp1_ = removed;
#line 515 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp2_ = gee_iterable_iterator (_tmp1_);
#line 515 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_object_it = _tmp2_;
#line 515 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		while (TRUE) {
#line 3390 "ViewCollection.c"
			GeeIterator* _tmp3_ = NULL;
			gboolean _tmp4_ = FALSE;
			DataObject* object = NULL;
			GeeIterator* _tmp5_ = NULL;
			gpointer _tmp6_ = NULL;
			DataView* view = NULL;
			DataObject* _tmp7_ = NULL;
			DataView* _tmp8_ = NULL;
			DataView* our_view = NULL;
			DataView* _tmp9_ = NULL;
			DataSource* _tmp10_ = NULL;
			DataSource* _tmp11_ = NULL;
			DataView* _tmp12_ = NULL;
			DataView* _tmp13_ = NULL;
			DataView* _tmp14_ = NULL;
			Marker* _tmp15_ = NULL;
			DataView* _tmp16_ = NULL;
#line 515 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp3_ = _object_it;
#line 515 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp4_ = gee_iterator_next (_tmp3_);
#line 515 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (!_tmp4_) {
#line 515 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				break;
#line 3416 "ViewCollection.c"
			}
#line 515 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp5_ = _object_it;
#line 515 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 515 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			object = (DataObject*) _tmp6_;
#line 516 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp7_ = object;
#line 516 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_VIEW, DataView));
#line 516 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			view = _tmp8_;
#line 518 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp9_ = view;
#line 518 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp10_ = data_view_get_source (_tmp9_);
#line 518 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp11_ = _tmp10_;
#line 518 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp12_ = view_collection_get_view_for_source (self, _tmp11_);
#line 518 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp13_ = _tmp12_;
#line 518 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (_tmp11_);
#line 518 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			our_view = _tmp13_;
#line 519 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp14_ = our_view;
#line 519 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_vala_assert (_tmp14_ != NULL, "our_view != null");
#line 521 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp15_ = marker;
#line 521 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp16_ = our_view;
#line 521 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			marker_mark (_tmp15_, G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_DATA_OBJECT, DataObject));
#line 515 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (our_view);
#line 515 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (view);
#line 515 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (object);
#line 3460 "ViewCollection.c"
		}
#line 515 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_object_it);
#line 3464 "ViewCollection.c"
	}
#line 524 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp17_ = marker;
#line 524 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	data_collection_remove_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp17_);
#line 513 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (marker);
#line 3472 "ViewCollection.c"
}


static void view_collection_real_notify_items_added (DataCollection* base, GeeIterable* added) {
	ViewCollection * self;
	GeeArrayList* added_visible = NULL;
	GeeArrayList* added_selected = NULL;
	GeeArrayList* _tmp30_ = NULL;
	GeeArrayList* _tmp34_ = NULL;
	GeeIterable* _tmp37_ = NULL;
#line 528 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIEW_COLLECTION, ViewCollection);
#line 528 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (GEE_IS_ITERABLE (added));
#line 529 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	added_visible = NULL;
#line 530 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	added_selected = NULL;
#line 3491 "ViewCollection.c"
	{
		GeeIterator* _object_it = NULL;
		GeeIterable* _tmp0_ = NULL;
		GeeIterator* _tmp1_ = NULL;
#line 532 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp0_ = added;
#line 532 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp1_ = gee_iterable_iterator (_tmp0_);
#line 532 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_object_it = _tmp1_;
#line 532 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		while (TRUE) {
#line 3504 "ViewCollection.c"
			GeeIterator* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
			DataObject* object = NULL;
			GeeIterator* _tmp4_ = NULL;
			gpointer _tmp5_ = NULL;
			DataView* view = NULL;
			DataObject* _tmp6_ = NULL;
			DataView* _tmp7_ = NULL;
			GeeHashMap* _tmp8_ = NULL;
			DataView* _tmp9_ = NULL;
			DataSource* _tmp10_ = NULL;
			DataSource* _tmp11_ = NULL;
			DataView* _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
			DataView* _tmp14_ = NULL;
			gboolean _tmp15_ = FALSE;
			gboolean _tmp22_ = FALSE;
			DataView* _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
#line 532 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp2_ = _object_it;
#line 532 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 532 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (!_tmp3_) {
#line 532 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				break;
#line 3532 "ViewCollection.c"
			}
#line 532 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp4_ = _object_it;
#line 532 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 532 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			object = (DataObject*) _tmp5_;
#line 533 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp6_ = object;
#line 533 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_DATA_VIEW, DataView));
#line 533 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			view = _tmp7_;
#line 534 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp8_ = self->priv->source_map;
#line 534 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp9_ = view;
#line 534 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp10_ = data_view_get_source (_tmp9_);
#line 534 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp11_ = _tmp10_;
#line 534 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp12_ = view;
#line 534 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp11_, _tmp12_);
#line 534 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (_tmp11_);
#line 536 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp14_ = view;
#line 536 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp15_ = data_view_is_selected (_tmp14_);
#line 536 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (_tmp15_) {
#line 3566 "ViewCollection.c"
				DataView* _tmp16_ = NULL;
				gboolean _tmp17_ = FALSE;
#line 536 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp16_ = view;
#line 536 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp17_ = data_view_is_visible (_tmp16_);
#line 536 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp13_ = _tmp17_;
#line 3575 "ViewCollection.c"
			} else {
#line 536 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp13_ = FALSE;
#line 3579 "ViewCollection.c"
			}
#line 536 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (_tmp13_) {
#line 3583 "ViewCollection.c"
				GeeArrayList* _tmp18_ = NULL;
				GeeArrayList* _tmp20_ = NULL;
				DataView* _tmp21_ = NULL;
#line 537 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp18_ = added_selected;
#line 537 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				if (_tmp18_ == NULL) {
#line 3591 "ViewCollection.c"
					GeeArrayList* _tmp19_ = NULL;
#line 538 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp19_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 538 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_g_object_unref0 (added_selected);
#line 538 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					added_selected = _tmp19_;
#line 3599 "ViewCollection.c"
				}
#line 540 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp20_ = added_selected;
#line 540 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp21_ = view;
#line 540 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp21_);
#line 3607 "ViewCollection.c"
			}
#line 544 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp23_ = view;
#line 544 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp24_ = data_view_is_visible (_tmp23_);
#line 544 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (_tmp24_) {
#line 3615 "ViewCollection.c"
				DataSet* _tmp25_ = NULL;
#line 544 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp25_ = self->priv->visible;
#line 544 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp22_ = _tmp25_ != NULL;
#line 3621 "ViewCollection.c"
			} else {
#line 544 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp22_ = FALSE;
#line 3625 "ViewCollection.c"
			}
#line 544 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (_tmp22_) {
#line 3629 "ViewCollection.c"
				GeeArrayList* _tmp26_ = NULL;
				GeeArrayList* _tmp28_ = NULL;
				DataView* _tmp29_ = NULL;
#line 545 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp26_ = added_visible;
#line 545 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				if (_tmp26_ == NULL) {
#line 3637 "ViewCollection.c"
					GeeArrayList* _tmp27_ = NULL;
#line 546 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp27_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 546 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_g_object_unref0 (added_visible);
#line 546 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					added_visible = _tmp27_;
#line 3645 "ViewCollection.c"
				}
#line 548 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp28_ = added_visible;
#line 548 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp29_ = view;
#line 548 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp29_);
#line 3653 "ViewCollection.c"
			}
#line 532 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (view);
#line 532 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (object);
#line 3659 "ViewCollection.c"
		}
#line 532 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_object_it);
#line 3663 "ViewCollection.c"
	}
#line 552 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp30_ = added_visible;
#line 552 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp30_ != NULL) {
#line 3669 "ViewCollection.c"
		gboolean is_added = FALSE;
		GeeArrayList* _tmp31_ = NULL;
		gboolean _tmp32_ = FALSE;
		gboolean _tmp33_ = FALSE;
#line 553 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp31_ = added_visible;
#line 553 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp32_ = view_collection_add_many_visible (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GEE_TYPE_COLLECTION, GeeCollection));
#line 553 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		is_added = _tmp32_;
#line 554 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp33_ = is_added;
#line 554 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_vala_assert (_tmp33_, "is_added");
#line 3684 "ViewCollection.c"
	}
#line 557 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp34_ = added_selected;
#line 557 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp34_ != NULL) {
#line 3690 "ViewCollection.c"
		GeeArrayList* _tmp35_ = NULL;
		GeeArrayList* _tmp36_ = NULL;
#line 558 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp35_ = added_selected;
#line 558 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_collection_add_many_selected (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, GEE_TYPE_COLLECTION, GeeCollection));
#line 559 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp36_ = added_selected;
#line 559 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_collection_notify_items_selected_unselected (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, GEE_TYPE_COLLECTION, GeeCollection), NULL);
#line 3701 "ViewCollection.c"
	}
#line 562 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp37_ = added;
#line 562 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	DATA_COLLECTION_CLASS (view_collection_parent_class)->notify_items_added (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp37_);
#line 528 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (added_selected);
#line 528 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (added_visible);
#line 3711 "ViewCollection.c"
}


static void view_collection_real_notify_items_removed (DataCollection* base, GeeIterable* removed) {
	ViewCollection * self;
	GeeArrayList* selected_removed = NULL;
	GeeArrayList* _tmp42_ = NULL;
	GeeIterable* _tmp44_ = NULL;
#line 566 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIEW_COLLECTION, ViewCollection);
#line 566 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (GEE_IS_ITERABLE (removed));
#line 567 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	selected_removed = NULL;
#line 3726 "ViewCollection.c"
	{
		GeeIterator* _object_it = NULL;
		GeeIterable* _tmp0_ = NULL;
		GeeIterator* _tmp1_ = NULL;
#line 568 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp0_ = removed;
#line 568 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp1_ = gee_iterable_iterator (_tmp0_);
#line 568 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_object_it = _tmp1_;
#line 568 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		while (TRUE) {
#line 3739 "ViewCollection.c"
			GeeIterator* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
			DataObject* object = NULL;
			GeeIterator* _tmp4_ = NULL;
			gpointer _tmp5_ = NULL;
			DataView* view = NULL;
			DataObject* _tmp6_ = NULL;
			DataView* _tmp7_ = NULL;
			GeeHashMap* _tmp8_ = NULL;
			DataView* _tmp9_ = NULL;
			DataSource* _tmp10_ = NULL;
			DataSource* _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
#line 568 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp2_ = _object_it;
#line 568 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 568 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (!_tmp3_) {
#line 568 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				break;
#line 3762 "ViewCollection.c"
			}
#line 568 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp4_ = _object_it;
#line 568 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 568 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			object = (DataObject*) _tmp5_;
#line 569 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp6_ = object;
#line 569 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_DATA_VIEW, DataView));
#line 569 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			view = _tmp7_;
#line 575 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp8_ = self->priv->source_map;
#line 575 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp9_ = view;
#line 575 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp10_ = data_view_get_source (_tmp9_);
#line 575 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp11_ = _tmp10_;
#line 575 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp12_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp11_);
#line 575 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp13_ = _tmp12_;
#line 575 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (_tmp11_);
#line 575 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (_tmp13_) {
#line 3792 "ViewCollection.c"
				gboolean is_removed = FALSE;
				GeeHashMap* _tmp14_ = NULL;
				DataView* _tmp15_ = NULL;
				DataSource* _tmp16_ = NULL;
				DataSource* _tmp17_ = NULL;
				gboolean _tmp18_ = FALSE;
				gboolean _tmp19_ = FALSE;
				gboolean _tmp20_ = FALSE;
				DataView* _tmp21_ = NULL;
				gboolean _tmp22_ = FALSE;
				gboolean _tmp34_ = FALSE;
				DataView* _tmp35_ = NULL;
				gboolean _tmp36_ = FALSE;
#line 576 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp14_ = self->priv->source_map;
#line 576 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp15_ = view;
#line 576 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp16_ = data_view_get_source (_tmp15_);
#line 576 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp17_ = _tmp16_;
#line 576 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp18_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp17_, NULL);
#line 576 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp19_ = _tmp18_;
#line 576 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_g_object_unref0 (_tmp17_);
#line 576 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				is_removed = _tmp19_;
#line 577 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp20_ = is_removed;
#line 577 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_vala_assert (_tmp20_, "is_removed");
#line 579 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp21_ = view;
#line 579 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp22_ = data_view_is_selected (_tmp21_);
#line 579 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				if (_tmp22_) {
#line 3832 "ViewCollection.c"
					DataSet* _tmp23_ = NULL;
					DataView* _tmp24_ = NULL;
					gboolean _tmp25_ = FALSE;
					DataView* _tmp26_ = NULL;
					gboolean _tmp27_ = FALSE;
					DataView* _tmp28_ = NULL;
					gboolean _tmp29_ = FALSE;
#line 581 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp23_ = self->priv->selected;
#line 581 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp24_ = view;
#line 581 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp25_ = data_set_contains (_tmp23_, G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, TYPE_DATA_OBJECT, DataObject));
#line 581 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp26_ = view;
#line 581 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp27_ = data_view_is_visible (_tmp26_);
#line 581 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_vala_assert (_tmp25_ == _tmp27_, "selected.contains(view) == view.is_visible()");
#line 583 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp28_ = view;
#line 583 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp29_ = data_view_is_visible (_tmp28_);
#line 583 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					if (_tmp29_) {
#line 3858 "ViewCollection.c"
						GeeArrayList* _tmp30_ = NULL;
						GeeArrayList* _tmp32_ = NULL;
						DataView* _tmp33_ = NULL;
#line 584 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp30_ = selected_removed;
#line 584 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						if (_tmp30_ == NULL) {
#line 3866 "ViewCollection.c"
							GeeArrayList* _tmp31_ = NULL;
#line 585 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
							_tmp31_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 585 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
							_g_object_unref0 (selected_removed);
#line 585 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
							selected_removed = _tmp31_;
#line 3874 "ViewCollection.c"
						}
#line 587 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp32_ = selected_removed;
#line 587 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp33_ = view;
#line 587 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp33_);
#line 3882 "ViewCollection.c"
					}
				}
#line 591 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp35_ = view;
#line 591 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp36_ = data_view_is_visible (_tmp35_);
#line 591 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				if (_tmp36_) {
#line 3891 "ViewCollection.c"
					DataSet* _tmp37_ = NULL;
#line 591 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp37_ = self->priv->visible;
#line 591 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp34_ = _tmp37_ != NULL;
#line 3897 "ViewCollection.c"
				} else {
#line 591 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp34_ = FALSE;
#line 3901 "ViewCollection.c"
				}
#line 591 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				if (_tmp34_) {
#line 3905 "ViewCollection.c"
					DataSet* _tmp38_ = NULL;
					DataView* _tmp39_ = NULL;
					gboolean _tmp40_ = FALSE;
					gboolean _tmp41_ = FALSE;
#line 592 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp38_ = self->priv->visible;
#line 592 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp39_ = view;
#line 592 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp40_ = data_set_remove (_tmp38_, G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, TYPE_DATA_OBJECT, DataObject));
#line 592 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					is_removed = _tmp40_;
#line 593 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp41_ = is_removed;
#line 593 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_vala_assert (_tmp41_, "is_removed");
#line 3922 "ViewCollection.c"
				}
			}
#line 568 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (view);
#line 568 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (object);
#line 3929 "ViewCollection.c"
		}
#line 568 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_object_it);
#line 3933 "ViewCollection.c"
	}
#line 598 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp42_ = selected_removed;
#line 598 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp42_ != NULL) {
#line 3939 "ViewCollection.c"
		GeeArrayList* _tmp43_ = NULL;
#line 599 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp43_ = selected_removed;
#line 599 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_collection_remove_many_selected (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, GEE_TYPE_COLLECTION, GeeCollection));
#line 604 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_collection_notify_selection_group_altered (self);
#line 3947 "ViewCollection.c"
	}
#line 607 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp44_ = removed;
#line 607 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	DATA_COLLECTION_CLASS (view_collection_parent_class)->notify_items_removed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp44_);
#line 566 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (selected_removed);
#line 3955 "ViewCollection.c"
}


static void view_collection_filter_altered_items (ViewCollection* self, GeeCollection* views) {
	GeeArrayList* to_show = NULL;
	GeeArrayList* to_hide = NULL;
	GeeArrayList* _tmp20_ = NULL;
	GeeArrayList* _tmp22_ = NULL;
#line 610 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 610 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (views));
#line 613 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	to_show = NULL;
#line 614 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	to_hide = NULL;
#line 3972 "ViewCollection.c"
	{
		GeeIterator* _view_it = NULL;
		GeeCollection* _tmp0_ = NULL;
		GeeIterator* _tmp1_ = NULL;
#line 619 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp0_ = views;
#line 619 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERABLE, GeeIterable));
#line 619 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_view_it = _tmp1_;
#line 619 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		while (TRUE) {
#line 3985 "ViewCollection.c"
			GeeIterator* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
			DataView* view = NULL;
			GeeIterator* _tmp4_ = NULL;
			gpointer _tmp5_ = NULL;
			DataView* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
#line 619 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp2_ = _view_it;
#line 619 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 619 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (!_tmp3_) {
#line 619 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				break;
#line 4001 "ViewCollection.c"
			}
#line 619 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp4_ = _view_it;
#line 619 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 619 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			view = (DataView*) _tmp5_;
#line 620 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp6_ = view;
#line 620 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp7_ = view_collection_is_in_filter (self, _tmp6_);
#line 620 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (_tmp7_) {
#line 4015 "ViewCollection.c"
				DataView* _tmp8_ = NULL;
				gboolean _tmp9_ = FALSE;
#line 621 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp8_ = view;
#line 621 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp9_ = data_view_is_visible (_tmp8_);
#line 621 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				if (!_tmp9_) {
#line 4024 "ViewCollection.c"
					GeeArrayList* _tmp10_ = NULL;
					GeeArrayList* _tmp12_ = NULL;
					DataView* _tmp13_ = NULL;
#line 622 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp10_ = to_show;
#line 622 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					if (_tmp10_ == NULL) {
#line 4032 "ViewCollection.c"
						GeeArrayList* _tmp11_ = NULL;
#line 623 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp11_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 623 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_g_object_unref0 (to_show);
#line 623 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						to_show = _tmp11_;
#line 4040 "ViewCollection.c"
					}
#line 625 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp12_ = to_show;
#line 625 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp13_ = view;
#line 625 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp13_);
#line 4048 "ViewCollection.c"
				}
			} else {
				DataView* _tmp14_ = NULL;
				gboolean _tmp15_ = FALSE;
#line 628 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp14_ = view;
#line 628 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp15_ = data_view_is_visible (_tmp14_);
#line 628 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				if (_tmp15_) {
#line 4059 "ViewCollection.c"
					GeeArrayList* _tmp16_ = NULL;
					GeeArrayList* _tmp18_ = NULL;
					DataView* _tmp19_ = NULL;
#line 629 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp16_ = to_hide;
#line 629 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					if (_tmp16_ == NULL) {
#line 4067 "ViewCollection.c"
						GeeArrayList* _tmp17_ = NULL;
#line 630 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_tmp17_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 630 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						_g_object_unref0 (to_hide);
#line 630 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
						to_hide = _tmp17_;
#line 4075 "ViewCollection.c"
					}
#line 632 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp18_ = to_hide;
#line 632 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp19_ = view;
#line 632 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp19_);
#line 4083 "ViewCollection.c"
				}
			}
#line 619 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (view);
#line 4088 "ViewCollection.c"
		}
#line 619 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_view_it);
#line 4092 "ViewCollection.c"
	}
#line 641 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp20_ = to_show;
#line 641 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp20_ != NULL) {
#line 4098 "ViewCollection.c"
		GeeArrayList* _tmp21_ = NULL;
#line 642 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp21_ = to_show;
#line 642 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_collection_show_items (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_LIST, GeeList));
#line 4104 "ViewCollection.c"
	}
#line 644 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp22_ = to_hide;
#line 644 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp22_ != NULL) {
#line 4110 "ViewCollection.c"
		GeeArrayList* _tmp23_ = NULL;
#line 645 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp23_ = to_hide;
#line 645 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_collection_hide_items (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_LIST, GeeList));
#line 4116 "ViewCollection.c"
	}
#line 610 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (to_hide);
#line 610 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (to_show);
#line 4122 "ViewCollection.c"
}


static void view_collection_real_items_altered (DataCollection* base, GeeMap* map) {
	ViewCollection * self;
	GeeMap* _tmp0_ = NULL;
	GeeSet* _tmp1_ = NULL;
	GeeSet* _tmp2_ = NULL;
	GeeCollection* _tmp3_ = NULL;
	GeeMap* _tmp4_ = NULL;
#line 648 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIEW_COLLECTION, ViewCollection);
#line 648 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (GEE_IS_MAP (map));
#line 650 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = map;
#line 650 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = gee_map_get_keys (_tmp0_);
#line 650 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = _tmp1_;
#line 650 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
#line 650 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_filter_altered_items (self, _tmp3_);
#line 650 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (_tmp3_);
#line 652 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp4_ = map;
#line 652 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	DATA_COLLECTION_CLASS (view_collection_parent_class)->items_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp4_);
#line 4153 "ViewCollection.c"
}


static void view_collection_real_set_comparator (DataCollection* base, Comparator comparator, void* comparator_target, ComparatorPredicate predicate, void* predicate_target) {
	ViewCollection * self;
	DataSet* _tmp0_ = NULL;
	Comparator _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	ComparatorPredicate _tmp2_ = NULL;
	void* _tmp2__target = NULL;
	DataSet* _tmp3_ = NULL;
	Comparator _tmp7_ = NULL;
	void* _tmp7__target = NULL;
	ComparatorPredicate _tmp8_ = NULL;
	void* _tmp8__target = NULL;
#line 655 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIEW_COLLECTION, ViewCollection);
#line 656 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = self->priv->selected;
#line 656 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = comparator;
#line 656 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1__target = comparator_target;
#line 656 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = predicate;
#line 656 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2__target = predicate_target;
#line 656 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	data_set_set_comparator (_tmp0_, _tmp1_, _tmp1__target, _tmp2_, _tmp2__target);
#line 657 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3_ = self->priv->visible;
#line 657 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp3_ != NULL) {
#line 4187 "ViewCollection.c"
		DataSet* _tmp4_ = NULL;
		Comparator _tmp5_ = NULL;
		void* _tmp5__target = NULL;
		ComparatorPredicate _tmp6_ = NULL;
		void* _tmp6__target = NULL;
#line 658 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp4_ = self->priv->visible;
#line 658 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp5_ = comparator;
#line 658 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp5__target = comparator_target;
#line 658 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp6_ = predicate;
#line 658 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp6__target = predicate_target;
#line 658 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		data_set_set_comparator (_tmp4_, _tmp5_, _tmp5__target, _tmp6_, _tmp6__target);
#line 4205 "ViewCollection.c"
	}
#line 660 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp7_ = comparator;
#line 660 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp7__target = comparator_target;
#line 660 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp8_ = predicate;
#line 660 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp8__target = predicate_target;
#line 660 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	DATA_COLLECTION_CLASS (view_collection_parent_class)->set_comparator (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp7_, _tmp7__target, _tmp8_, _tmp8__target);
#line 4217 "ViewCollection.c"
}


static void view_collection_real_reset_comparator (DataCollection* base) {
	ViewCollection * self;
	DataSet* _tmp0_ = NULL;
	DataSet* _tmp1_ = NULL;
#line 663 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIEW_COLLECTION, ViewCollection);
#line 664 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = self->priv->selected;
#line 664 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	data_set_reset_comparator (_tmp0_);
#line 665 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = self->priv->visible;
#line 665 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp1_ != NULL) {
#line 4235 "ViewCollection.c"
		DataSet* _tmp2_ = NULL;
#line 666 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp2_ = self->priv->visible;
#line 666 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		data_set_reset_comparator (_tmp2_);
#line 4241 "ViewCollection.c"
	}
#line 668 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	DATA_COLLECTION_CLASS (view_collection_parent_class)->reset_comparator (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 4245 "ViewCollection.c"
}


static GeeCollection* view_collection_real_get_all (DataCollection* base) {
	ViewCollection * self;
	GeeCollection* result = NULL;
	GeeCollection* _tmp0_ = NULL;
	DataSet* _tmp1_ = NULL;
#line 671 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIEW_COLLECTION, ViewCollection);
#line 672 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = self->priv->visible;
#line 672 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp1_ != NULL) {
#line 4260 "ViewCollection.c"
		DataSet* _tmp2_ = NULL;
		GeeList* _tmp3_ = NULL;
#line 672 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp2_ = self->priv->visible;
#line 672 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp3_ = data_set_get_all (_tmp2_);
#line 672 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_tmp0_);
#line 672 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection);
#line 4271 "ViewCollection.c"
	} else {
		GeeCollection* _tmp4_ = NULL;
#line 672 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp4_ = DATA_COLLECTION_CLASS (view_collection_parent_class)->get_all (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 672 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_tmp0_);
#line 672 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp0_ = _tmp4_;
#line 4280 "ViewCollection.c"
	}
#line 672 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = _tmp0_;
#line 672 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 4286 "ViewCollection.c"
}


GeeCollection* view_collection_get_all_unfiltered (ViewCollection* self) {
	GeeCollection* result = NULL;
	GeeCollection* _tmp0_ = NULL;
#line 675 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
#line 676 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = DATA_COLLECTION_CLASS (view_collection_parent_class)->get_all (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 676 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = _tmp0_;
#line 676 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 4301 "ViewCollection.c"
}


static gint view_collection_real_get_count (DataCollection* base) {
	ViewCollection * self;
	gint result = 0;
	gint _tmp0_ = 0;
	DataSet* _tmp1_ = NULL;
#line 679 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIEW_COLLECTION, ViewCollection);
#line 680 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = self->priv->visible;
#line 680 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp1_ != NULL) {
#line 4316 "ViewCollection.c"
		DataSet* _tmp2_ = NULL;
		gint _tmp3_ = 0;
#line 680 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp2_ = self->priv->visible;
#line 680 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp3_ = data_set_get_count (_tmp2_);
#line 680 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp0_ = _tmp3_;
#line 4325 "ViewCollection.c"
	} else {
		gint _tmp4_ = 0;
#line 680 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp4_ = DATA_COLLECTION_CLASS (view_collection_parent_class)->get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 680 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp0_ = _tmp4_;
#line 4332 "ViewCollection.c"
	}
#line 680 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = _tmp0_;
#line 680 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 4338 "ViewCollection.c"
}


gint view_collection_get_unfiltered_count (ViewCollection* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 683 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), 0);
#line 684 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = DATA_COLLECTION_CLASS (view_collection_parent_class)->get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 684 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = _tmp0_;
#line 684 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 4353 "ViewCollection.c"
}


static DataObject* view_collection_real_get_at (DataCollection* base, gint index) {
	ViewCollection * self;
	DataObject* result = NULL;
	DataObject* _tmp0_ = NULL;
	DataSet* _tmp1_ = NULL;
#line 687 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIEW_COLLECTION, ViewCollection);
#line 688 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = self->priv->visible;
#line 688 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp1_ != NULL) {
#line 4368 "ViewCollection.c"
		DataSet* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		DataObject* _tmp4_ = NULL;
#line 688 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp2_ = self->priv->visible;
#line 688 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp3_ = index;
#line 688 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp4_ = data_set_get_at (_tmp2_, _tmp3_);
#line 688 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_tmp0_);
#line 688 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp0_ = _tmp4_;
#line 4382 "ViewCollection.c"
	} else {
		gint _tmp5_ = 0;
		DataObject* _tmp6_ = NULL;
#line 688 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp5_ = index;
#line 688 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp6_ = DATA_COLLECTION_CLASS (view_collection_parent_class)->get_at (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp5_);
#line 688 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_tmp0_);
#line 688 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp0_ = _tmp6_;
#line 4394 "ViewCollection.c"
	}
#line 688 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = _tmp0_;
#line 688 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 4400 "ViewCollection.c"
}


static gint view_collection_real_index_of (DataCollection* base, DataObject* object) {
	ViewCollection * self;
	gint result = 0;
	gint _tmp0_ = 0;
	DataSet* _tmp1_ = NULL;
#line 691 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIEW_COLLECTION, ViewCollection);
#line 691 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), 0);
#line 692 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = self->priv->visible;
#line 692 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp1_ != NULL) {
#line 4417 "ViewCollection.c"
		DataSet* _tmp2_ = NULL;
		DataObject* _tmp3_ = NULL;
		gint _tmp4_ = 0;
#line 692 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp2_ = self->priv->visible;
#line 692 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp3_ = object;
#line 692 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp4_ = data_set_index_of (_tmp2_, _tmp3_);
#line 692 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp0_ = _tmp4_;
#line 4429 "ViewCollection.c"
	} else {
		DataObject* _tmp5_ = NULL;
		gint _tmp6_ = 0;
#line 692 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp5_ = object;
#line 692 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp6_ = DATA_COLLECTION_CLASS (view_collection_parent_class)->index_of (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp5_);
#line 692 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp0_ = _tmp6_;
#line 4439 "ViewCollection.c"
	}
#line 692 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = _tmp0_;
#line 692 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 4445 "ViewCollection.c"
}


static gboolean view_collection_real_contains (DataCollection* base, DataObject* object) {
	ViewCollection * self;
	gboolean result = FALSE;
	DataObject* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	DataObject* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 695 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIEW_COLLECTION, ViewCollection);
#line 695 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 698 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = object;
#line 698 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = DATA_COLLECTION_CLASS (view_collection_parent_class)->contains (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp0_);
#line 698 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (!_tmp1_) {
#line 699 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		result = FALSE;
#line 699 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		return result;
#line 4470 "ViewCollection.c"
	}
#line 702 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = object;
#line 702 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3_ = view_collection_is_visible (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DATA_VIEW, DataView));
#line 702 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = _tmp3_;
#line 702 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 4480 "ViewCollection.c"
}


static DataView* view_collection_real_get_first (ViewCollection* self) {
	DataView* result = NULL;
	DataView* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 706 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 706 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp1_ > 0) {
#line 4492 "ViewCollection.c"
		DataObject* _tmp2_ = NULL;
#line 706 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp2_ = data_collection_get_at (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), 0);
#line 706 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_tmp0_);
#line 706 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DATA_VIEW, DataView);
#line 4500 "ViewCollection.c"
	} else {
#line 706 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_tmp0_);
#line 706 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp0_ = NULL;
#line 4506 "ViewCollection.c"
	}
#line 706 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = _tmp0_;
#line 706 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 4512 "ViewCollection.c"
}


DataView* view_collection_get_first (ViewCollection* self) {
#line 705 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
#line 705 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return VIEW_COLLECTION_GET_CLASS (self)->get_first (self);
#line 4521 "ViewCollection.c"
}


/**
     * @brief A helper method for places in the app that need a
     *  non-rejected media source (namely Events, when looking to
     *  automatically choose a thumbnail).
     *
     * @note If every view in this collection is rejected, we
     *  return the first view; this is intentional.  This prevents
     *  pathological events that have nothing but rejected images
     *  in them from breaking.
     */
static DataView* view_collection_real_get_first_unrejected (ViewCollection* self) {
	DataView* result = NULL;
	gint _tmp0_ = 0;
	DataView* dv = NULL;
	DataView* _tmp1_ = NULL;
	gint num_views = 0;
	gint _tmp2_ = 0;
	DataView* _tmp17_ = NULL;
#line 721 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 721 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp0_ < 1) {
#line 722 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		result = NULL;
#line 722 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		return result;
#line 4551 "ViewCollection.c"
	}
#line 725 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = view_collection_get_first (self);
#line 725 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	dv = _tmp1_;
#line 726 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 726 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	num_views = _tmp2_;
#line 728 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	while (TRUE) {
#line 4563 "ViewCollection.c"
		gboolean _tmp3_ = FALSE;
		DataView* _tmp4_ = NULL;
		MediaSource* tmp = NULL;
		DataView* _tmp8_ = NULL;
		DataSource* _tmp9_ = NULL;
		MediaSource* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		MediaSource* _tmp12_ = NULL;
#line 728 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp4_ = dv;
#line 728 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		if (_tmp4_ != NULL) {
#line 4576 "ViewCollection.c"
			DataView* _tmp5_ = NULL;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
#line 728 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp5_ = dv;
#line 728 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp6_ = data_collection_index_of (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_DATA_OBJECT, DataObject));
#line 728 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp7_ = num_views;
#line 728 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp3_ = _tmp6_ < (_tmp7_ - 1);
#line 4588 "ViewCollection.c"
		} else {
#line 728 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp3_ = FALSE;
#line 4592 "ViewCollection.c"
		}
#line 728 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		if (!_tmp3_) {
#line 728 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			break;
#line 4598 "ViewCollection.c"
		}
#line 729 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp8_ = dv;
#line 729 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp9_ = data_view_get_source (_tmp8_);
#line 729 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp10_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, TYPE_MEDIA_SOURCE) ? ((MediaSource*) _tmp9_) : NULL;
#line 729 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		if (_tmp10_ == NULL) {
#line 729 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (_tmp9_);
#line 4610 "ViewCollection.c"
		}
#line 729 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		tmp = _tmp10_;
#line 731 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp12_ = tmp;
#line 731 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		if (_tmp12_ != NULL) {
#line 4618 "ViewCollection.c"
			MediaSource* _tmp13_ = NULL;
			Rating _tmp14_ = 0;
#line 731 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp13_ = tmp;
#line 731 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp14_ = media_source_get_rating (_tmp13_);
#line 731 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp11_ = _tmp14_ != RATING_REJECTED;
#line 4627 "ViewCollection.c"
		} else {
#line 731 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp11_ = FALSE;
#line 4631 "ViewCollection.c"
		}
#line 731 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		if (_tmp11_) {
#line 733 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			result = dv;
#line 733 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (tmp);
#line 733 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			return result;
#line 4641 "ViewCollection.c"
		} else {
			DataView* _tmp15_ = NULL;
			DataView* _tmp16_ = NULL;
#line 735 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp15_ = dv;
#line 735 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp16_ = view_collection_get_next (self, _tmp15_);
#line 735 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (dv);
#line 735 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			dv = _tmp16_;
#line 4653 "ViewCollection.c"
		}
#line 728 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (tmp);
#line 4657 "ViewCollection.c"
	}
#line 741 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp17_ = view_collection_get_first (self);
#line 741 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = _tmp17_;
#line 741 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (dv);
#line 741 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 4667 "ViewCollection.c"
}


DataView* view_collection_get_first_unrejected (ViewCollection* self) {
#line 719 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
#line 719 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return VIEW_COLLECTION_GET_CLASS (self)->get_first_unrejected (self);
#line 4676 "ViewCollection.c"
}


static DataView* view_collection_real_get_last (ViewCollection* self) {
	DataView* result = NULL;
	DataView* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 745 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 745 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp1_ > 0) {
#line 4688 "ViewCollection.c"
		gint _tmp2_ = 0;
		DataObject* _tmp3_ = NULL;
#line 745 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp2_ = data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 745 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp3_ = data_collection_get_at (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp2_ - 1);
#line 745 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_tmp0_);
#line 745 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DATA_VIEW, DataView);
#line 4699 "ViewCollection.c"
	} else {
#line 745 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_tmp0_);
#line 745 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp0_ = NULL;
#line 4705 "ViewCollection.c"
	}
#line 745 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = _tmp0_;
#line 745 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 4711 "ViewCollection.c"
}


DataView* view_collection_get_last (ViewCollection* self) {
#line 744 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
#line 744 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return VIEW_COLLECTION_GET_CLASS (self)->get_last (self);
#line 4720 "ViewCollection.c"
}


static DataView* view_collection_real_get_next (ViewCollection* self, DataView* view) {
	DataView* result = NULL;
	gint _tmp0_ = 0;
	gint index = 0;
	DataView* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	DataObject* _tmp8_ = NULL;
#line 748 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_DATA_VIEW (view), NULL);
#line 749 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 749 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp0_ == 0) {
#line 750 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		result = NULL;
#line 750 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		return result;
#line 4746 "ViewCollection.c"
	}
#line 752 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = view;
#line 752 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = data_collection_index_of (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_OBJECT, DataObject));
#line 752 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	index = _tmp2_;
#line 753 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3_ = index;
#line 753 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp3_ < 0) {
#line 754 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		result = NULL;
#line 754 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		return result;
#line 4762 "ViewCollection.c"
	}
#line 756 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp4_ = index;
#line 756 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	index = _tmp4_ + 1;
#line 757 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp5_ = index;
#line 757 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp6_ = data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 757 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp5_ >= _tmp6_) {
#line 758 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		index = 0;
#line 4776 "ViewCollection.c"
	}
#line 760 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp7_ = index;
#line 760 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp8_ = data_collection_get_at (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp7_);
#line 760 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_VIEW, DataView);
#line 760 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 4786 "ViewCollection.c"
}


DataView* view_collection_get_next (ViewCollection* self, DataView* view) {
#line 748 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
#line 748 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return VIEW_COLLECTION_GET_CLASS (self)->get_next (self, view);
#line 4795 "ViewCollection.c"
}


static DataView* view_collection_real_get_previous (ViewCollection* self, DataView* view) {
	DataView* result = NULL;
	gint _tmp0_ = 0;
	gint index = 0;
	DataView* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp7_ = 0;
	DataObject* _tmp8_ = NULL;
#line 763 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_DATA_VIEW (view), NULL);
#line 764 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 764 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp0_ == 0) {
#line 765 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		result = NULL;
#line 765 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		return result;
#line 4820 "ViewCollection.c"
	}
#line 767 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = view;
#line 767 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = data_collection_index_of (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_OBJECT, DataObject));
#line 767 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	index = _tmp2_;
#line 768 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3_ = index;
#line 768 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp3_ < 0) {
#line 769 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		result = NULL;
#line 769 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		return result;
#line 4836 "ViewCollection.c"
	}
#line 771 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp4_ = index;
#line 771 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	index = _tmp4_ - 1;
#line 772 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp5_ = index;
#line 772 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp5_ < 0) {
#line 4846 "ViewCollection.c"
		gint _tmp6_ = 0;
#line 773 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp6_ = data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 773 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		index = _tmp6_ - 1;
#line 4852 "ViewCollection.c"
	}
#line 775 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp7_ = index;
#line 775 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp8_ = data_collection_get_at (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp7_);
#line 775 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_VIEW, DataView);
#line 775 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 4862 "ViewCollection.c"
}


DataView* view_collection_get_previous (ViewCollection* self, DataView* view) {
#line 763 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
#line 763 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return VIEW_COLLECTION_GET_CLASS (self)->get_previous (self, view);
#line 4871 "ViewCollection.c"
}


gboolean view_collection_get_immediate_neighbors (ViewCollection* self, DataSource* home, DataSource** next, DataSource** prev, const gchar* type_selector) {
	DataSource* _vala_next = NULL;
	DataSource* _vala_prev = NULL;
	gboolean result = FALSE;
	DataView* home_view = NULL;
	DataSource* _tmp0_ = NULL;
	DataView* _tmp1_ = NULL;
	DataView* _tmp2_ = NULL;
	DataView* next_view = NULL;
	DataView* _tmp3_ = NULL;
	DataView* _tmp4_ = NULL;
	DataView* prev_view = NULL;
	DataView* _tmp19_ = NULL;
	DataView* _tmp20_ = NULL;
#line 778 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), FALSE);
#line 778 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (home), FALSE);
#line 780 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (_vala_next);
#line 780 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_vala_next = NULL;
#line 781 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (_vala_prev);
#line 781 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_vala_prev = NULL;
#line 783 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = home;
#line 783 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = view_collection_get_view_for_source (self, _tmp0_);
#line 783 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	home_view = _tmp1_;
#line 784 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = home_view;
#line 784 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp2_ == NULL) {
#line 785 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		result = FALSE;
#line 785 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (home_view);
#line 785 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		if (next) {
#line 785 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			*next = _vala_next;
#line 4919 "ViewCollection.c"
		} else {
#line 785 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (_vala_next);
#line 4923 "ViewCollection.c"
		}
#line 785 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		if (prev) {
#line 785 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			*prev = _vala_prev;
#line 4929 "ViewCollection.c"
		} else {
#line 785 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (_vala_prev);
#line 4933 "ViewCollection.c"
		}
#line 785 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		return result;
#line 4937 "ViewCollection.c"
	}
#line 787 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3_ = home_view;
#line 787 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp4_ = view_collection_get_next (self, _tmp3_);
#line 787 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	next_view = _tmp4_;
#line 788 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	while (TRUE) {
#line 4947 "ViewCollection.c"
		DataView* _tmp5_ = NULL;
		DataView* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_ = NULL;
		DataView* _tmp17_ = NULL;
		DataView* _tmp18_ = NULL;
#line 788 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp5_ = next_view;
#line 788 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp6_ = home_view;
#line 788 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		if (!(_tmp5_ != _tmp6_)) {
#line 788 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			break;
#line 4962 "ViewCollection.c"
		}
#line 789 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp8_ = type_selector;
#line 789 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		if (_tmp8_ == NULL) {
#line 789 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp7_ = TRUE;
#line 4970 "ViewCollection.c"
		} else {
			DataView* _tmp9_ = NULL;
			DataSource* _tmp10_ = NULL;
			DataSource* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
#line 789 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp9_ = next_view;
#line 789 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp10_ = data_view_get_source (_tmp9_);
#line 789 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp11_ = _tmp10_;
#line 789 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp12_ = data_source_get_typename (_tmp11_);
#line 789 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp13_ = _tmp12_;
#line 789 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp14_ = type_selector;
#line 789 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp7_ = g_strcmp0 (_tmp13_, _tmp14_) == 0;
#line 789 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_free0 (_tmp13_);
#line 789 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (_tmp11_);
#line 4996 "ViewCollection.c"
		}
#line 789 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		if (_tmp7_) {
#line 5000 "ViewCollection.c"
			DataView* _tmp15_ = NULL;
			DataSource* _tmp16_ = NULL;
#line 790 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp15_ = next_view;
#line 790 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp16_ = data_view_get_source (_tmp15_);
#line 790 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (_vala_next);
#line 790 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_vala_next = _tmp16_;
#line 791 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			break;
#line 5013 "ViewCollection.c"
		}
#line 793 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp17_ = next_view;
#line 793 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp18_ = view_collection_get_next (self, _tmp17_);
#line 793 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (next_view);
#line 793 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		next_view = _tmp18_;
#line 5023 "ViewCollection.c"
	}
#line 796 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp19_ = home_view;
#line 796 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp20_ = view_collection_get_previous (self, _tmp19_);
#line 796 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	prev_view = _tmp20_;
#line 797 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	while (TRUE) {
#line 5033 "ViewCollection.c"
		DataView* _tmp21_ = NULL;
		DataView* _tmp22_ = NULL;
		gboolean _tmp23_ = FALSE;
		const gchar* _tmp24_ = NULL;
		DataView* _tmp33_ = NULL;
		DataView* _tmp34_ = NULL;
#line 797 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp21_ = prev_view;
#line 797 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp22_ = home_view;
#line 797 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		if (!(_tmp21_ != _tmp22_)) {
#line 797 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			break;
#line 5048 "ViewCollection.c"
		}
#line 798 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp24_ = type_selector;
#line 798 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		if (_tmp24_ == NULL) {
#line 798 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp23_ = TRUE;
#line 5056 "ViewCollection.c"
		} else {
			DataView* _tmp25_ = NULL;
			DataSource* _tmp26_ = NULL;
			DataSource* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			gchar* _tmp29_ = NULL;
			const gchar* _tmp30_ = NULL;
#line 798 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp25_ = prev_view;
#line 798 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp26_ = data_view_get_source (_tmp25_);
#line 798 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp27_ = _tmp26_;
#line 798 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp28_ = data_source_get_typename (_tmp27_);
#line 798 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp29_ = _tmp28_;
#line 798 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp30_ = type_selector;
#line 798 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp23_ = g_strcmp0 (_tmp29_, _tmp30_) == 0;
#line 798 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_free0 (_tmp29_);
#line 798 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (_tmp27_);
#line 5082 "ViewCollection.c"
		}
#line 798 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		if (_tmp23_) {
#line 5086 "ViewCollection.c"
			DataView* _tmp31_ = NULL;
			DataSource* _tmp32_ = NULL;
#line 799 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp31_ = prev_view;
#line 799 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp32_ = data_view_get_source (_tmp31_);
#line 799 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (_vala_prev);
#line 799 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_vala_prev = _tmp32_;
#line 800 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			break;
#line 5099 "ViewCollection.c"
		}
#line 802 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp33_ = prev_view;
#line 802 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp34_ = view_collection_get_previous (self, _tmp33_);
#line 802 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (prev_view);
#line 802 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		prev_view = _tmp34_;
#line 5109 "ViewCollection.c"
	}
#line 805 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = TRUE;
#line 805 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (prev_view);
#line 805 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (next_view);
#line 805 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (home_view);
#line 805 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (next) {
#line 805 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		*next = _vala_next;
#line 5123 "ViewCollection.c"
	} else {
#line 805 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_vala_next);
#line 5127 "ViewCollection.c"
	}
#line 805 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (prev) {
#line 805 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		*prev = _vala_prev;
#line 5133 "ViewCollection.c"
	} else {
#line 805 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_vala_prev);
#line 5137 "ViewCollection.c"
	}
#line 805 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 5141 "ViewCollection.c"
}


GeeSet* view_collection_get_extended_neighbors (ViewCollection* self, DataSource* home, const gchar* typename) {
	GeeSet* result = NULL;
	GeeSet* neighbors = NULL;
	GeeHashSet* _tmp0_ = NULL;
	DataSource* next = NULL;
	DataSource* prev = NULL;
	DataSource* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	DataSource* _tmp3_ = NULL;
	DataSource* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	DataSource* _tmp6_ = NULL;
	DataSource* _tmp16_ = NULL;
	GeeSet* _tmp26_ = NULL;
	DataSource* _tmp27_ = NULL;
#line 809 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
#line 809 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (home), NULL);
#line 811 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = gee_hash_set_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 811 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	neighbors = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_SET, GeeSet);
#line 815 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = home;
#line 815 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = typename;
#line 815 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp5_ = view_collection_get_immediate_neighbors (self, _tmp1_, &_tmp3_, &_tmp4_, _tmp2_);
#line 815 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (next);
#line 815 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	next = _tmp3_;
#line 815 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (prev);
#line 815 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	prev = _tmp4_;
#line 815 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (!_tmp5_) {
#line 816 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		result = neighbors;
#line 816 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (prev);
#line 816 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (next);
#line 816 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		return result;
#line 5192 "ViewCollection.c"
	}
#line 819 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp6_ = next;
#line 819 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp6_ != NULL) {
#line 5198 "ViewCollection.c"
		GeeSet* _tmp7_ = NULL;
		DataSource* _tmp8_ = NULL;
		DataSource* next_next = NULL;
		DataSource* next_prev = NULL;
		DataSource* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		DataSource* _tmp11_ = NULL;
		DataSource* _tmp12_ = NULL;
		DataSource* _tmp13_ = NULL;
#line 820 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp7_ = neighbors;
#line 820 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp8_ = next;
#line 820 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection), _tmp8_);
#line 823 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp9_ = next;
#line 823 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp10_ = typename;
#line 823 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_collection_get_immediate_neighbors (self, _tmp9_, &_tmp11_, &_tmp12_, _tmp10_);
#line 823 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (next_next);
#line 823 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		next_next = _tmp11_;
#line 823 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (next_prev);
#line 823 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		next_prev = _tmp12_;
#line 826 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp13_ = next_next;
#line 826 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		if (_tmp13_ != NULL) {
#line 5232 "ViewCollection.c"
			GeeSet* _tmp14_ = NULL;
			DataSource* _tmp15_ = NULL;
#line 827 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp14_ = neighbors;
#line 827 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp15_ = next_next;
#line 827 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_COLLECTION, GeeCollection), _tmp15_);
#line 5241 "ViewCollection.c"
		}
#line 819 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (next_prev);
#line 819 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (next_next);
#line 5247 "ViewCollection.c"
	}
#line 831 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp16_ = prev;
#line 831 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp16_ != NULL) {
#line 5253 "ViewCollection.c"
		GeeSet* _tmp17_ = NULL;
		DataSource* _tmp18_ = NULL;
		DataSource* next_prev = NULL;
		DataSource* prev_prev = NULL;
		DataSource* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		DataSource* _tmp21_ = NULL;
		DataSource* _tmp22_ = NULL;
		DataSource* _tmp23_ = NULL;
#line 832 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp17_ = neighbors;
#line 832 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp18_ = prev;
#line 832 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_COLLECTION, GeeCollection), _tmp18_);
#line 835 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp19_ = prev;
#line 835 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp20_ = typename;
#line 835 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_collection_get_immediate_neighbors (self, _tmp19_, &_tmp21_, &_tmp22_, _tmp20_);
#line 835 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (next_prev);
#line 835 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		next_prev = _tmp21_;
#line 835 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (prev_prev);
#line 835 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		prev_prev = _tmp22_;
#line 838 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp23_ = prev_prev;
#line 838 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		if (_tmp23_ != NULL) {
#line 5287 "ViewCollection.c"
			GeeSet* _tmp24_ = NULL;
			DataSource* _tmp25_ = NULL;
#line 839 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp24_ = neighbors;
#line 839 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp25_ = prev_prev;
#line 839 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_COLLECTION, GeeCollection), _tmp25_);
#line 5296 "ViewCollection.c"
		}
#line 831 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (prev_prev);
#line 831 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (next_prev);
#line 5302 "ViewCollection.c"
	}
#line 843 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp26_ = neighbors;
#line 843 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp27_ = home;
#line 843 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_COLLECTION, GeeCollection), _tmp27_);
#line 845 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = neighbors;
#line 845 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (prev);
#line 845 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (next);
#line 845 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 5318 "ViewCollection.c"
}


static void view_collection_add_many_selected (ViewCollection* self, GeeCollection* views) {
	GeeCollection* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean added = FALSE;
	DataSet* _tmp11_ = NULL;
	GeeCollection* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
#line 850 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 850 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (views));
#line 851 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = views;
#line 851 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 851 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = _tmp1_;
#line 851 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp2_ == 0) {
#line 852 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		return;
#line 5345 "ViewCollection.c"
	}
	{
		GeeIterator* _view_it = NULL;
		GeeCollection* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
#line 854 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp3_ = views;
#line 854 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 854 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_view_it = _tmp4_;
#line 854 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		while (TRUE) {
#line 5359 "ViewCollection.c"
			GeeIterator* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			DataView* view = NULL;
			GeeIterator* _tmp7_ = NULL;
			gpointer _tmp8_ = NULL;
			DataView* _tmp9_ = NULL;
			gboolean _tmp10_ = FALSE;
#line 854 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp5_ = _view_it;
#line 854 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp6_ = gee_iterator_next (_tmp5_);
#line 854 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (!_tmp6_) {
#line 854 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				break;
#line 5375 "ViewCollection.c"
			}
#line 854 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp7_ = _view_it;
#line 854 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp8_ = gee_iterator_get (_tmp7_);
#line 854 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			view = (DataView*) _tmp8_;
#line 855 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp9_ = view;
#line 855 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp10_ = data_view_is_visible (_tmp9_);
#line 855 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_vala_assert (_tmp10_, "view.is_visible()");
#line 854 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (view);
#line 5391 "ViewCollection.c"
		}
#line 854 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_view_it);
#line 5395 "ViewCollection.c"
	}
#line 857 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp11_ = self->priv->selected;
#line 857 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp12_ = views;
#line 857 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp13_ = data_set_add_many (_tmp11_, _tmp12_);
#line 857 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	added = _tmp13_;
#line 858 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp14_ = added;
#line 858 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_vala_assert (_tmp14_, "added");
#line 5409 "ViewCollection.c"
}


static void view_collection_remove_many_selected (ViewCollection* self, GeeCollection* views) {
	GeeCollection* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean removed = FALSE;
	DataSet* _tmp3_ = NULL;
	GeeCollection* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
#line 861 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 861 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (views));
#line 862 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = views;
#line 862 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 862 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = _tmp1_;
#line 862 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp2_ == 0) {
#line 863 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		return;
#line 5436 "ViewCollection.c"
	}
#line 865 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3_ = self->priv->selected;
#line 865 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp4_ = views;
#line 865 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp5_ = data_set_remove_many (_tmp3_, _tmp4_);
#line 865 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	removed = _tmp5_;
#line 866 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp6_ = removed;
#line 866 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_vala_assert (_tmp6_, "removed");
#line 5450 "ViewCollection.c"
}


static gboolean _view_collection_select_item_marked_action (DataObject* object, GObject* user, gpointer self) {
	gboolean result;
	result = view_collection_select_item ((ViewCollection*) self, object, user);
#line 872 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 5459 "ViewCollection.c"
}


void view_collection_select_marked (ViewCollection* self, Marker* marker) {
	GeeArrayList* selected = NULL;
	GeeArrayList* _tmp0_ = NULL;
	Marker* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 870 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 870 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_MARKER (marker));
#line 871 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 871 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	selected = _tmp0_;
#line 872 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = marker;
#line 872 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = selected;
#line 872 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	data_collection_act_on_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp1_, _view_collection_select_item_marked_action, self, NULL, NULL, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, G_TYPE_OBJECT, GObject));
#line 874 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3_ = selected;
#line 874 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp4_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 874 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp5_ = _tmp4_;
#line 874 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp5_ > 0) {
#line 5493 "ViewCollection.c"
		GeeArrayList* _tmp6_ = NULL;
		GeeArrayList* _tmp7_ = NULL;
#line 875 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp6_ = selected;
#line 875 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_collection_add_many_selected (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
#line 876 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp7_ = selected;
#line 876 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_collection_notify_items_selected_unselected (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection), NULL);
#line 5504 "ViewCollection.c"
	}
#line 870 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (selected);
#line 5508 "ViewCollection.c"
}


void view_collection_select_all (ViewCollection* self) {
	Marker* marker = NULL;
	Marker* _tmp0_ = NULL;
#line 881 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 882 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = data_collection_start_marking (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 882 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	marker = _tmp0_;
#line 883 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	marker_mark_all (marker);
#line 884 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_select_marked (self, marker);
#line 881 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (marker);
#line 5527 "ViewCollection.c"
}


static gboolean view_collection_select_item (ViewCollection* self, DataObject* object, GObject* user) {
	gboolean result = FALSE;
	DataView* view = NULL;
	DataObject* _tmp0_ = NULL;
	DataView* _tmp1_ = NULL;
	DataView* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	DataView* _tmp9_ = NULL;
	DataView* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
#line 887 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), FALSE);
#line 887 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 887 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail ((user == NULL) || G_IS_OBJECT (user), FALSE);
#line 888 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = object;
#line 888 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_VIEW, DataView));
#line 888 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view = _tmp1_;
#line 889 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = view;
#line 889 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3_ = data_view_is_selected (_tmp2_);
#line 889 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp3_) {
#line 5559 "ViewCollection.c"
		DataView* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 890 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp4_ = view;
#line 890 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp5_ = data_view_is_visible (_tmp4_);
#line 890 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		if (_tmp5_) {
#line 5568 "ViewCollection.c"
			DataSet* _tmp6_ = NULL;
			DataView* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
#line 891 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp6_ = self->priv->selected;
#line 891 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp7_ = view;
#line 891 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp8_ = data_set_contains (_tmp6_, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_OBJECT, DataObject));
#line 891 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_vala_assert (_tmp8_, "selected.contains(view)");
#line 5580 "ViewCollection.c"
		}
#line 893 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		result = TRUE;
#line 893 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (view);
#line 893 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		return result;
#line 5588 "ViewCollection.c"
	}
#line 896 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp9_ = view;
#line 896 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	data_view_internal_set_selected (_tmp9_, TRUE);
#line 900 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp10_ = view;
#line 900 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp11_ = data_view_is_visible (_tmp10_);
#line 900 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp11_) {
#line 5600 "ViewCollection.c"
		GObject* _tmp12_ = NULL;
		DataView* _tmp13_ = NULL;
#line 901 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp12_ = user;
#line 901 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp13_ = view;
#line 901 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ARRAY_LIST, GeeArrayList), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp13_);
#line 5609 "ViewCollection.c"
	}
#line 903 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = TRUE;
#line 903 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (view);
#line 903 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 5617 "ViewCollection.c"
}


static gboolean _view_collection_unselect_item_marked_action (DataObject* object, GObject* user, gpointer self) {
	gboolean result;
	result = view_collection_unselect_item ((ViewCollection*) self, object, user);
#line 909 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 5626 "ViewCollection.c"
}


void view_collection_unselect_marked (ViewCollection* self, Marker* marker) {
	GeeArrayList* unselected = NULL;
	GeeArrayList* _tmp0_ = NULL;
	Marker* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 907 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 907 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_MARKER (marker));
#line 908 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 908 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	unselected = _tmp0_;
#line 909 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = marker;
#line 909 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = unselected;
#line 909 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	data_collection_act_on_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp1_, _view_collection_unselect_item_marked_action, self, NULL, NULL, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, G_TYPE_OBJECT, GObject));
#line 911 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3_ = unselected;
#line 911 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp4_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 911 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp5_ = _tmp4_;
#line 911 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp5_ > 0) {
#line 5660 "ViewCollection.c"
		GeeArrayList* _tmp6_ = NULL;
		GeeArrayList* _tmp7_ = NULL;
#line 912 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp6_ = unselected;
#line 912 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_collection_remove_many_selected (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
#line 913 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp7_ = unselected;
#line 913 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_collection_notify_items_selected_unselected (self, NULL, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection));
#line 5671 "ViewCollection.c"
	}
#line 907 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (unselected);
#line 5675 "ViewCollection.c"
}


void view_collection_unselect_all (ViewCollection* self) {
	DataSet* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	Marker* marker = NULL;
	Marker* _tmp2_ = NULL;
	Marker* _tmp3_ = NULL;
	GeeList* _tmp4_ = NULL;
	GeeList* _tmp5_ = NULL;
	Marker* _tmp6_ = NULL;
#line 918 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 919 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = self->priv->selected;
#line 919 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = data_set_get_count (_tmp0_);
#line 919 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp1_ == 0) {
#line 920 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		return;
#line 5698 "ViewCollection.c"
	}
#line 922 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = data_collection_start_marking (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 922 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	marker = _tmp2_;
#line 923 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3_ = marker;
#line 923 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp4_ = view_collection_get_selected (self);
#line 923 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp5_ = _tmp4_;
#line 923 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	marker_mark_many (_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
#line 923 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (_tmp5_);
#line 925 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp6_ = marker;
#line 925 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_unselect_marked (self, _tmp6_);
#line 918 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (marker);
#line 5720 "ViewCollection.c"
}


void view_collection_unselect_all_but (ViewCollection* self, DataView* exception) {
	Marker* marker = NULL;
	Marker* _tmp0_ = NULL;
	Marker* _tmp15_ = NULL;
#line 929 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 929 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_DATA_VIEW (exception));
#line 930 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = data_collection_start_marking (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 930 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	marker = _tmp0_;
#line 5736 "ViewCollection.c"
	{
		GeeIterator* _object_it = NULL;
		GeeCollection* _tmp1_ = NULL;
		GeeCollection* _tmp2_ = NULL;
		GeeIterator* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
#line 931 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp1_ = data_collection_get_all (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 931 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp2_ = _tmp1_;
#line 931 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
#line 931 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp4_ = _tmp3_;
#line 931 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_tmp2_);
#line 931 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_object_it = _tmp4_;
#line 931 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		while (TRUE) {
#line 5757 "ViewCollection.c"
			GeeIterator* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			DataObject* object = NULL;
			GeeIterator* _tmp7_ = NULL;
			gpointer _tmp8_ = NULL;
			DataView* view = NULL;
			DataObject* _tmp9_ = NULL;
			DataView* _tmp10_ = NULL;
			DataView* _tmp11_ = NULL;
			DataView* _tmp12_ = NULL;
#line 931 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp5_ = _object_it;
#line 931 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp6_ = gee_iterator_next (_tmp5_);
#line 931 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (!_tmp6_) {
#line 931 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				break;
#line 5776 "ViewCollection.c"
			}
#line 931 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp7_ = _object_it;
#line 931 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp8_ = gee_iterator_get (_tmp7_);
#line 931 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			object = (DataObject*) _tmp8_;
#line 932 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp9_ = object;
#line 932 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_DATA_VIEW, DataView));
#line 932 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			view = _tmp10_;
#line 933 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp11_ = view;
#line 933 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp12_ = exception;
#line 933 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (_tmp11_ != _tmp12_) {
#line 5796 "ViewCollection.c"
				Marker* _tmp13_ = NULL;
				DataView* _tmp14_ = NULL;
#line 934 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp13_ = marker;
#line 934 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp14_ = view;
#line 934 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				marker_mark (_tmp13_, G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_DATA_OBJECT, DataObject));
#line 5805 "ViewCollection.c"
			}
#line 931 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (view);
#line 931 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (object);
#line 5811 "ViewCollection.c"
		}
#line 931 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_object_it);
#line 5815 "ViewCollection.c"
	}
#line 937 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp15_ = marker;
#line 937 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_unselect_marked (self, _tmp15_);
#line 929 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (marker);
#line 5823 "ViewCollection.c"
}


static gboolean view_collection_unselect_item (ViewCollection* self, DataObject* object, GObject* user) {
	gboolean result = FALSE;
	DataView* view = NULL;
	DataObject* _tmp0_ = NULL;
	DataView* _tmp1_ = NULL;
	DataView* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	DataView* _tmp7_ = NULL;
	GObject* _tmp8_ = NULL;
	DataView* _tmp9_ = NULL;
#line 940 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), FALSE);
#line 940 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 940 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail ((user == NULL) || G_IS_OBJECT (user), FALSE);
#line 941 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = object;
#line 941 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_VIEW, DataView));
#line 941 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view = _tmp1_;
#line 942 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = view;
#line 942 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3_ = data_view_is_selected (_tmp2_);
#line 942 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (!_tmp3_) {
#line 5855 "ViewCollection.c"
		DataSet* _tmp4_ = NULL;
		DataView* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 943 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp4_ = self->priv->selected;
#line 943 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp5_ = view;
#line 943 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp6_ = data_set_contains (_tmp4_, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_DATA_OBJECT, DataObject));
#line 943 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_vala_assert (!_tmp6_, "!selected.contains(view)");
#line 945 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		result = TRUE;
#line 945 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (view);
#line 945 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		return result;
#line 5873 "ViewCollection.c"
	}
#line 948 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp7_ = view;
#line 948 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	data_view_internal_set_selected (_tmp7_, FALSE);
#line 949 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp8_ = user;
#line 949 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp9_ = view;
#line 949 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ARRAY_LIST, GeeArrayList), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp9_);
#line 951 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = TRUE;
#line 951 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (view);
#line 951 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 5891 "ViewCollection.c"
}


void view_collection_unselect_and_select_marked (ViewCollection* self, Marker* unselect, Marker* select) {
	GeeArrayList* unselected = NULL;
	GeeArrayList* _tmp0_ = NULL;
	Marker* _tmp1_ = NULL;
	GeeArrayList* selected = NULL;
	GeeArrayList* _tmp2_ = NULL;
	Marker* _tmp3_ = NULL;
#line 955 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 955 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_MARKER (unselect));
#line 955 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_MARKER (select));
#line 956 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 956 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	unselected = _tmp0_;
#line 957 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = unselect;
#line 957 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	data_collection_act_on_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp1_, _view_collection_unselect_item_marked_action, self, NULL, NULL, G_TYPE_CHECK_INSTANCE_CAST (unselected, G_TYPE_OBJECT, GObject));
#line 959 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_remove_many_selected (self, G_TYPE_CHECK_INSTANCE_CAST (unselected, GEE_TYPE_COLLECTION, GeeCollection));
#line 961 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 961 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	selected = _tmp2_;
#line 962 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3_ = select;
#line 962 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	data_collection_act_on_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp3_, _view_collection_select_item_marked_action, self, NULL, NULL, G_TYPE_CHECK_INSTANCE_CAST (selected, G_TYPE_OBJECT, GObject));
#line 964 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_add_many_selected (self, G_TYPE_CHECK_INSTANCE_CAST (selected, GEE_TYPE_COLLECTION, GeeCollection));
#line 966 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_notify_items_selected_unselected (self, G_TYPE_CHECK_INSTANCE_CAST (selected, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (unselected, GEE_TYPE_COLLECTION, GeeCollection));
#line 955 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (selected);
#line 955 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (unselected);
#line 5934 "ViewCollection.c"
}


static gboolean _view_collection_toggle_item_marked_action (DataObject* object, GObject* user, gpointer self) {
	gboolean result;
	result = view_collection_toggle_item ((ViewCollection*) self, object, user);
#line 973 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 5943 "ViewCollection.c"
}


void view_collection_toggle_marked (ViewCollection* self, Marker* marker) {
	ViewCollectionToggleLists* lists = NULL;
	ViewCollectionToggleLists* _tmp0_ = NULL;
	Marker* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
	GeeArrayList* _tmp5_ = NULL;
#line 971 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 971 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_MARKER (marker));
#line 972 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = view_collection_toggle_lists_new ();
#line 972 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	lists = _tmp0_;
#line 973 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = marker;
#line 973 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	data_collection_act_on_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp1_, _view_collection_toggle_item_marked_action, self, NULL, NULL, G_TYPE_CHECK_INSTANCE_CAST (lists, G_TYPE_OBJECT, GObject));
#line 976 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = lists->selected;
#line 976 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_add_many_selected (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
#line 977 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3_ = lists->unselected;
#line 977 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_remove_many_selected (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
#line 979 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp4_ = lists->selected;
#line 979 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp5_ = lists->unselected;
#line 979 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_notify_items_selected_unselected (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
#line 971 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (lists);
#line 5983 "ViewCollection.c"
}


static gboolean view_collection_toggle_item (ViewCollection* self, DataObject* object, GObject* user) {
	gboolean result = FALSE;
	DataView* view = NULL;
	DataObject* _tmp0_ = NULL;
	DataView* _tmp1_ = NULL;
	ViewCollectionToggleLists* lists = NULL;
	GObject* _tmp2_ = NULL;
	ViewCollectionToggleLists* _tmp3_ = NULL;
	DataView* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 982 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), FALSE);
#line 982 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 982 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail ((user == NULL) || G_IS_OBJECT (user), FALSE);
#line 983 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = object;
#line 983 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_VIEW, DataView));
#line 983 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view = _tmp1_;
#line 984 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = user;
#line 984 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, VIEW_COLLECTION_TYPE_TOGGLE_LISTS, ViewCollectionToggleLists));
#line 984 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	lists = _tmp3_;
#line 990 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp4_ = view;
#line 990 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp5_ = data_view_internal_toggle (_tmp4_);
#line 990 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp5_) {
#line 6021 "ViewCollection.c"
		DataView* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
#line 991 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp6_ = view;
#line 991 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp7_ = data_view_is_visible (_tmp6_);
#line 991 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		if (_tmp7_) {
#line 6030 "ViewCollection.c"
			ViewCollectionToggleLists* _tmp8_ = NULL;
			GeeArrayList* _tmp9_ = NULL;
			DataView* _tmp10_ = NULL;
#line 992 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp8_ = lists;
#line 992 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp9_ = _tmp8_->selected;
#line 992 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp10_ = view;
#line 992 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp10_);
#line 6042 "ViewCollection.c"
		}
	} else {
		ViewCollectionToggleLists* _tmp11_ = NULL;
		GeeArrayList* _tmp12_ = NULL;
		DataView* _tmp13_ = NULL;
#line 994 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp11_ = lists;
#line 994 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp12_ = _tmp11_->unselected;
#line 994 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp13_ = view;
#line 994 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp13_);
#line 6056 "ViewCollection.c"
	}
#line 997 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = TRUE;
#line 997 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (lists);
#line 997 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (view);
#line 997 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 6066 "ViewCollection.c"
}


gint view_collection_get_selected_count (ViewCollection* self) {
	gint result = 0;
	DataSet* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 1000 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), 0);
#line 1001 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = self->priv->selected;
#line 1001 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = data_set_get_count (_tmp0_);
#line 1001 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = _tmp1_;
#line 1001 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 6084 "ViewCollection.c"
}


GeeList* view_collection_get_selected (ViewCollection* self) {
	GeeList* result = NULL;
	DataSet* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
#line 1004 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
#line 1005 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = self->priv->selected;
#line 1005 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = data_set_get_all (_tmp0_);
#line 1005 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_LIST, GeeList);
#line 1005 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 6102 "ViewCollection.c"
}


DataView* view_collection_get_selected_at (ViewCollection* self, gint index) {
	DataView* result = NULL;
	DataSet* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	DataObject* _tmp2_ = NULL;
#line 1008 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
#line 1009 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = self->priv->selected;
#line 1009 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = index;
#line 1009 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = data_set_get_at (_tmp0_, _tmp1_);
#line 1009 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DATA_VIEW, DataView);
#line 1009 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 6123 "ViewCollection.c"
}


static gboolean view_collection_is_visible (ViewCollection* self, DataView* view) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	DataSet* _tmp1_ = NULL;
#line 1012 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), FALSE);
#line 1012 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_DATA_VIEW (view), FALSE);
#line 1013 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = self->priv->visible;
#line 1013 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp1_ != NULL) {
#line 6139 "ViewCollection.c"
		DataSet* _tmp2_ = NULL;
		DataView* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
#line 1013 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp2_ = self->priv->visible;
#line 1013 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp3_ = view;
#line 1013 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp4_ = data_set_contains (_tmp2_, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DATA_OBJECT, DataObject));
#line 1013 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp0_ = _tmp4_;
#line 6151 "ViewCollection.c"
	} else {
#line 1013 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp0_ = TRUE;
#line 6155 "ViewCollection.c"
	}
#line 1013 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = _tmp0_;
#line 1013 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 6161 "ViewCollection.c"
}


static gboolean view_collection_add_many_visible (ViewCollection* self, GeeCollection* many) {
	gboolean result = FALSE;
	DataSet* _tmp0_ = NULL;
	DataSet* _tmp1_ = NULL;
	GeeCollection* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	DataSet* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
#line 1016 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), FALSE);
#line 1016 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (many), FALSE);
#line 1017 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = self->priv->visible;
#line 1017 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp0_ == NULL) {
#line 1018 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		result = TRUE;
#line 1018 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		return result;
#line 6186 "ViewCollection.c"
	}
#line 1020 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = self->priv->visible;
#line 1020 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = many;
#line 1020 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3_ = data_set_add_many (_tmp1_, _tmp2_);
#line 1020 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (!_tmp3_) {
#line 1021 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		result = FALSE;
#line 1021 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		return result;
#line 6200 "ViewCollection.c"
	}
#line 1024 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp4_ = self->priv->visible;
#line 1024 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp5_ = data_set_get_count (_tmp4_);
#line 1024 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp6_ = DATA_COLLECTION_CLASS (view_collection_parent_class)->get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 1024 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp5_ == _tmp6_) {
#line 1025 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_data_set_unref0 (self->priv->visible);
#line 1025 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		self->priv->visible = NULL;
#line 6214 "ViewCollection.c"
	}
#line 1027 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = TRUE;
#line 1027 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 6220 "ViewCollection.c"
}


static void view_collection_hide_items (ViewCollection* self, GeeList* to_hide) {
	GeeArrayList* unselected = NULL;
	GeeArrayList* _tmp0_ = NULL;
	gint count = 0;
	GeeList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	DataSet* _tmp22_ = NULL;
	gboolean removed = FALSE;
	DataSet* _tmp24_ = NULL;
	GeeList* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	GeeArrayList* _tmp28_ = NULL;
	GeeArrayList* _tmp29_ = NULL;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	GeeList* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
#line 1031 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 1031 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (GEE_IS_LIST (to_hide));
#line 1032 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 1032 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	unselected = _tmp0_;
#line 1034 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = to_hide;
#line 1034 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1034 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3_ = _tmp2_;
#line 1034 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	count = _tmp3_;
#line 6260 "ViewCollection.c"
	{
		gint ctr = 0;
#line 1035 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		ctr = 0;
#line 6265 "ViewCollection.c"
		{
			gboolean _tmp4_ = FALSE;
#line 1035 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp4_ = TRUE;
#line 1035 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			while (TRUE) {
#line 6272 "ViewCollection.c"
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				DataView* view = NULL;
				GeeList* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				gpointer _tmp10_ = NULL;
				DataView* _tmp11_ = NULL;
				gboolean _tmp12_ = FALSE;
				DataView* _tmp13_ = NULL;
				gboolean _tmp14_ = FALSE;
				DataView* _tmp21_ = NULL;
#line 1035 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				if (!_tmp4_) {
#line 6286 "ViewCollection.c"
					gint _tmp5_ = 0;
#line 1035 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp5_ = ctr;
#line 1035 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					ctr = _tmp5_ + 1;
#line 6292 "ViewCollection.c"
				}
#line 1035 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp4_ = FALSE;
#line 1035 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp6_ = ctr;
#line 1035 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp7_ = count;
#line 1035 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				if (!(_tmp6_ < _tmp7_)) {
#line 1035 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					break;
#line 6304 "ViewCollection.c"
				}
#line 1036 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp8_ = to_hide;
#line 1036 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp9_ = ctr;
#line 1036 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp10_ = gee_list_get (_tmp8_, _tmp9_);
#line 1036 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				view = (DataView*) _tmp10_;
#line 1037 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp11_ = view;
#line 1037 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp12_ = data_view_is_visible (_tmp11_);
#line 1037 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_vala_assert (_tmp12_, "view.is_visible()");
#line 1039 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp13_ = view;
#line 1039 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp14_ = data_view_is_selected (_tmp13_);
#line 1039 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				if (_tmp14_) {
#line 6326 "ViewCollection.c"
					DataView* _tmp15_ = NULL;
					GeeArrayList* _tmp16_ = NULL;
					DataView* _tmp17_ = NULL;
#line 1040 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp15_ = view;
#line 1040 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					data_view_internal_set_selected (_tmp15_, FALSE);
#line 1041 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp16_ = unselected;
#line 1041 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp17_ = view;
#line 1041 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp17_);
#line 6340 "ViewCollection.c"
				} else {
					DataSet* _tmp18_ = NULL;
					DataView* _tmp19_ = NULL;
					gboolean _tmp20_ = FALSE;
#line 1043 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp18_ = self->priv->selected;
#line 1043 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp19_ = view;
#line 1043 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp20_ = data_set_contains (_tmp18_, G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_DATA_OBJECT, DataObject));
#line 1043 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_vala_assert (!_tmp20_, "!selected.contains(view)");
#line 6353 "ViewCollection.c"
				}
#line 1046 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp21_ = view;
#line 1046 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				data_view_internal_set_visible (_tmp21_, FALSE);
#line 1035 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_g_object_unref0 (view);
#line 6361 "ViewCollection.c"
			}
		}
	}
#line 1049 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp22_ = self->priv->visible;
#line 1049 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp22_ == NULL) {
#line 6369 "ViewCollection.c"
		DataSet* _tmp23_ = NULL;
#line 1051 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp23_ = data_collection_get_dataset_copy (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 1051 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_data_set_unref0 (self->priv->visible);
#line 1051 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		self->priv->visible = _tmp23_;
#line 6377 "ViewCollection.c"
	}
#line 1054 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp24_ = self->priv->visible;
#line 1054 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp25_ = to_hide;
#line 1054 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp26_ = data_set_remove_many (_tmp24_, G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1054 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	removed = _tmp26_;
#line 1055 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp27_ = removed;
#line 1055 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_vala_assert (_tmp27_, "removed");
#line 1057 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp28_ = unselected;
#line 1057 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_remove_many_selected (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1059 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp29_ = unselected;
#line 1059 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp30_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 1059 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp31_ = _tmp30_;
#line 1059 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp31_ > 0) {
#line 6403 "ViewCollection.c"
		GeeArrayList* _tmp32_ = NULL;
#line 1060 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp32_ = unselected;
#line 1060 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_collection_notify_items_selected_unselected (self, NULL, G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, GEE_TYPE_COLLECTION, GeeCollection));
#line 6409 "ViewCollection.c"
	}
#line 1062 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp33_ = to_hide;
#line 1062 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp34_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1062 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp35_ = _tmp34_;
#line 1062 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp35_ > 0) {
#line 6419 "ViewCollection.c"
		GeeList* _tmp36_ = NULL;
		GeeList* _tmp37_ = NULL;
#line 1063 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp36_ = to_hide;
#line 1063 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_collection_notify_items_hidden (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1064 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp37_ = to_hide;
#line 1064 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_collection_notify_items_visibility_changed (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, GEE_TYPE_COLLECTION, GeeCollection));
#line 6430 "ViewCollection.c"
	}
#line 1031 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (unselected);
#line 6434 "ViewCollection.c"
}


static void view_collection_show_items (ViewCollection* self, GeeList* to_show) {
	GeeArrayList* added_selected = NULL;
	GeeArrayList* _tmp0_ = NULL;
	gint count = 0;
	GeeList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean added = FALSE;
	GeeList* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	GeeArrayList* _tmp24_ = NULL;
	GeeList* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
#line 1069 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 1069 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (GEE_IS_LIST (to_show));
#line 1070 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 1070 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	added_selected = _tmp0_;
#line 1072 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = to_show;
#line 1072 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1072 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3_ = _tmp2_;
#line 1072 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	count = _tmp3_;
#line 6469 "ViewCollection.c"
	{
		gint ctr = 0;
#line 1073 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		ctr = 0;
#line 6474 "ViewCollection.c"
		{
			gboolean _tmp4_ = FALSE;
#line 1073 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp4_ = TRUE;
#line 1073 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			while (TRUE) {
#line 6481 "ViewCollection.c"
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				DataView* view = NULL;
				GeeList* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				gpointer _tmp10_ = NULL;
				DataView* _tmp11_ = NULL;
				gboolean _tmp12_ = FALSE;
				DataView* _tmp13_ = NULL;
				DataView* _tmp14_ = NULL;
				gboolean _tmp15_ = FALSE;
#line 1073 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				if (!_tmp4_) {
#line 6495 "ViewCollection.c"
					gint _tmp5_ = 0;
#line 1073 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp5_ = ctr;
#line 1073 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					ctr = _tmp5_ + 1;
#line 6501 "ViewCollection.c"
				}
#line 1073 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp4_ = FALSE;
#line 1073 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp6_ = ctr;
#line 1073 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp7_ = count;
#line 1073 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				if (!(_tmp6_ < _tmp7_)) {
#line 1073 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					break;
#line 6513 "ViewCollection.c"
				}
#line 1074 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp8_ = to_show;
#line 1074 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp9_ = ctr;
#line 1074 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp10_ = gee_list_get (_tmp8_, _tmp9_);
#line 1074 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				view = (DataView*) _tmp10_;
#line 1075 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp11_ = view;
#line 1075 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp12_ = data_view_is_visible (_tmp11_);
#line 1075 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_vala_assert (!_tmp12_, "!view.is_visible()");
#line 1077 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp13_ = view;
#line 1077 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				data_view_internal_set_visible (_tmp13_, TRUE);
#line 1080 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp14_ = view;
#line 1080 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp15_ = data_view_is_selected (_tmp14_);
#line 1080 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				if (_tmp15_) {
#line 6539 "ViewCollection.c"
					DataSet* _tmp16_ = NULL;
					DataView* _tmp17_ = NULL;
					gboolean _tmp18_ = FALSE;
					GeeArrayList* _tmp19_ = NULL;
					DataView* _tmp20_ = NULL;
#line 1081 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp16_ = self->priv->selected;
#line 1081 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp17_ = view;
#line 1081 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp18_ = data_set_contains (_tmp16_, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_DATA_OBJECT, DataObject));
#line 1081 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_vala_assert (!_tmp18_, "!selected.contains(view)");
#line 1082 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp19_ = added_selected;
#line 1082 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp20_ = view;
#line 1082 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp20_);
#line 6559 "ViewCollection.c"
				}
#line 1073 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_g_object_unref0 (view);
#line 6563 "ViewCollection.c"
			}
		}
	}
#line 1086 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp21_ = to_show;
#line 1086 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp22_ = view_collection_add_many_visible (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1086 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	added = _tmp22_;
#line 1087 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp23_ = added;
#line 1087 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_vala_assert (_tmp23_, "added");
#line 1089 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp24_ = added_selected;
#line 1089 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_add_many_selected (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1091 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp25_ = to_show;
#line 1091 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp26_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1091 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp27_ = _tmp26_;
#line 1091 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp27_ > 0) {
#line 6589 "ViewCollection.c"
		GeeList* _tmp28_ = NULL;
		GeeList* _tmp29_ = NULL;
#line 1092 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp28_ = to_show;
#line 1092 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_collection_notify_items_shown (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1093 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp29_ = to_show;
#line 1093 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_collection_notify_items_visibility_changed (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_COLLECTION, GeeCollection));
#line 6600 "ViewCollection.c"
	}
#line 1069 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (added_selected);
#line 6604 "ViewCollection.c"
}


gboolean view_collection_has_view_for_source (ViewCollection* self, DataSource* source) {
	gboolean result = FALSE;
	DataSource* _tmp0_ = NULL;
	DataView* _tmp1_ = NULL;
	DataView* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 1098 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), FALSE);
#line 1098 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), FALSE);
#line 1099 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = source;
#line 1099 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = view_collection_get_view_for_source (self, _tmp0_);
#line 1099 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = _tmp1_;
#line 1099 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3_ = _tmp2_ != NULL;
#line 1099 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (_tmp2_);
#line 1099 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = _tmp3_;
#line 1099 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 6632 "ViewCollection.c"
}


DataView* view_collection_get_view_for_source (ViewCollection* self, DataSource* source) {
	DataView* result = NULL;
	GeeHashMap* _tmp0_ = NULL;
	DataSource* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
#line 1103 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
#line 1103 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), NULL);
#line 1104 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = self->priv->source_map;
#line 1104 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = source;
#line 1104 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_);
#line 1104 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = (DataView*) _tmp2_;
#line 1104 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 6655 "ViewCollection.c"
}


gboolean view_collection_has_view_for_source_with_filtered (ViewCollection* self, DataSource* source) {
	gboolean result = FALSE;
	DataSource* _tmp0_ = NULL;
	DataView* _tmp1_ = NULL;
	DataView* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 1108 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), FALSE);
#line 1108 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), FALSE);
#line 1109 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = source;
#line 1109 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = view_collection_get_view_for_source_filtered (self, _tmp0_);
#line 1109 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = _tmp1_;
#line 1109 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3_ = _tmp2_ != NULL;
#line 1109 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (_tmp2_);
#line 1109 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = _tmp3_;
#line 1109 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 6683 "ViewCollection.c"
}


DataView* view_collection_get_view_for_source_filtered (ViewCollection* self, DataSource* source) {
	DataView* result = NULL;
	DataView* view = NULL;
	GeeHashMap* _tmp0_ = NULL;
	DataSource* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	DataView* _tmp4_ = NULL;
#line 1113 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
#line 1113 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), NULL);
#line 1114 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = self->priv->source_map;
#line 1114 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = source;
#line 1114 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_);
#line 1114 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view = (DataView*) _tmp2_;
#line 1116 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp4_ = view;
#line 1116 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp4_ != NULL) {
#line 6711 "ViewCollection.c"
		DataView* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 1116 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp5_ = view;
#line 1116 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp6_ = view_collection_is_in_filter (self, _tmp5_);
#line 1116 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp3_ = !_tmp6_;
#line 6720 "ViewCollection.c"
	} else {
#line 1116 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp3_ = FALSE;
#line 6724 "ViewCollection.c"
	}
#line 1116 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp3_) {
#line 1117 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		result = NULL;
#line 1117 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (view);
#line 1117 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		return result;
#line 6734 "ViewCollection.c"
	}
#line 1118 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = view;
#line 1118 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 6740 "ViewCollection.c"
}


GeeCollection* view_collection_get_sources (ViewCollection* self) {
	GeeCollection* result = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeSet* _tmp1_ = NULL;
	GeeSet* _tmp2_ = NULL;
	GeeSet* _tmp3_ = NULL;
	GeeSet* _tmp4_ = NULL;
	GeeSet* _tmp5_ = NULL;
	GeeCollection* _tmp6_ = NULL;
#line 1122 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
#line 1123 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = self->priv->source_map;
#line 1123 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 1123 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = _tmp1_;
#line 1123 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3_ = _tmp2_;
#line 1123 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp4_ = gee_set_get_read_only_view (_tmp3_);
#line 1123 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp5_ = _tmp4_;
#line 1123 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection);
#line 1123 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (_tmp3_);
#line 1123 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = _tmp6_;
#line 1123 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 6775 "ViewCollection.c"
}


gboolean view_collection_has_source_of_type (ViewCollection* self, GType t) {
	gboolean result = FALSE;
	GType _tmp0_ = 0UL;
	gboolean _tmp1_ = FALSE;
#line 1127 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), FALSE);
#line 1128 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = t;
#line 1128 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = g_type_is_a (_tmp0_, TYPE_DATA_SOURCE);
#line 1128 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_vala_assert (_tmp1_, "t.is_a(typeof(DataSource))");
#line 6791 "ViewCollection.c"
	{
		GeeIterator* _source_it = NULL;
		GeeHashMap* _tmp2_ = NULL;
		GeeSet* _tmp3_ = NULL;
		GeeSet* _tmp4_ = NULL;
		GeeSet* _tmp5_ = NULL;
		GeeIterator* _tmp6_ = NULL;
		GeeIterator* _tmp7_ = NULL;
#line 1130 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp2_ = self->priv->source_map;
#line 1130 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp3_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 1130 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp4_ = _tmp3_;
#line 1130 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp5_ = _tmp4_;
#line 1130 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp6_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1130 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp7_ = _tmp6_;
#line 1130 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_tmp5_);
#line 1130 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_source_it = _tmp7_;
#line 1130 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		while (TRUE) {
#line 6818 "ViewCollection.c"
			GeeIterator* _tmp8_ = NULL;
			gboolean _tmp9_ = FALSE;
			DataSource* source = NULL;
			GeeIterator* _tmp10_ = NULL;
			gpointer _tmp11_ = NULL;
			DataSource* _tmp12_ = NULL;
			GType _tmp13_ = 0UL;
			GType _tmp14_ = 0UL;
			gboolean _tmp15_ = FALSE;
#line 1130 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp8_ = _source_it;
#line 1130 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp9_ = gee_iterator_next (_tmp8_);
#line 1130 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (!_tmp9_) {
#line 1130 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				break;
#line 6836 "ViewCollection.c"
			}
#line 1130 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp10_ = _source_it;
#line 1130 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp11_ = gee_iterator_get (_tmp10_);
#line 1130 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			source = (DataSource*) _tmp11_;
#line 1131 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp12_ = source;
#line 1131 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp13_ = G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, G_TYPE_OBJECT, GObject));
#line 1131 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp14_ = t;
#line 1131 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp15_ = g_type_is_a (_tmp13_, _tmp14_);
#line 1131 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (_tmp15_) {
#line 1132 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				result = TRUE;
#line 1132 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_g_object_unref0 (source);
#line 1132 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_g_object_unref0 (_source_it);
#line 1132 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				return result;
#line 6862 "ViewCollection.c"
			}
#line 1130 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (source);
#line 6866 "ViewCollection.c"
		}
#line 1130 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_source_it);
#line 6870 "ViewCollection.c"
	}
#line 1135 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = FALSE;
#line 1135 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 6876 "ViewCollection.c"
}


gint view_collection_get_sources_of_type_count (ViewCollection* self, GType t) {
	gint result = 0;
	GType _tmp0_ = 0UL;
	gboolean _tmp1_ = FALSE;
	gint count = 0;
#line 1138 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), 0);
#line 1139 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = t;
#line 1139 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = g_type_is_a (_tmp0_, TYPE_DATA_SOURCE);
#line 1139 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_vala_assert (_tmp1_, "t.is_a(typeof(DataSource))");
#line 1141 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	count = 0;
#line 6895 "ViewCollection.c"
	{
		GeeIterator* _object_it = NULL;
		GeeCollection* _tmp2_ = NULL;
		GeeCollection* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 1142 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp2_ = data_collection_get_all (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 1142 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp3_ = _tmp2_;
#line 1142 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1142 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp5_ = _tmp4_;
#line 1142 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_tmp3_);
#line 1142 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_object_it = _tmp5_;
#line 1142 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		while (TRUE) {
#line 6916 "ViewCollection.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			DataObject* object = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			DataObject* _tmp10_ = NULL;
			DataSource* _tmp11_ = NULL;
			DataSource* _tmp12_ = NULL;
			GType _tmp13_ = 0UL;
			GType _tmp14_ = 0UL;
			gboolean _tmp15_ = FALSE;
			gboolean _tmp16_ = FALSE;
#line 1142 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp6_ = _object_it;
#line 1142 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 1142 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (!_tmp7_) {
#line 1142 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				break;
#line 6937 "ViewCollection.c"
			}
#line 1142 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp8_ = _object_it;
#line 1142 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 1142 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			object = (DataObject*) _tmp9_;
#line 1143 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp10_ = object;
#line 1143 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp11_ = data_view_get_source (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_VIEW, DataView));
#line 1143 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp12_ = _tmp11_;
#line 1143 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp13_ = G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, G_TYPE_OBJECT, GObject));
#line 1143 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp14_ = t;
#line 1143 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp15_ = g_type_is_a (_tmp13_, _tmp14_);
#line 1143 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp16_ = _tmp15_;
#line 1143 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (_tmp12_);
#line 1143 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (_tmp16_) {
#line 6963 "ViewCollection.c"
				gint _tmp17_ = 0;
#line 1144 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp17_ = count;
#line 1144 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				count = _tmp17_ + 1;
#line 6969 "ViewCollection.c"
			}
#line 1142 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (object);
#line 6973 "ViewCollection.c"
		}
#line 1142 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_object_it);
#line 6977 "ViewCollection.c"
	}
#line 1147 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = count;
#line 1147 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 6983 "ViewCollection.c"
}


GeeList* view_collection_get_sources_of_type (ViewCollection* self, GType t) {
	GeeList* result = NULL;
	GType _tmp0_ = 0UL;
	gboolean _tmp1_ = FALSE;
	GeeList* sources = NULL;
#line 1150 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
#line 1151 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = t;
#line 1151 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = g_type_is_a (_tmp0_, TYPE_DATA_SOURCE);
#line 1151 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_vala_assert (_tmp1_, "t.is_a(typeof(DataSource))");
#line 1153 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	sources = NULL;
#line 7002 "ViewCollection.c"
	{
		GeeIterator* _object_it = NULL;
		GeeCollection* _tmp2_ = NULL;
		GeeCollection* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 1154 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp2_ = data_collection_get_all (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 1154 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp3_ = _tmp2_;
#line 1154 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1154 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp5_ = _tmp4_;
#line 1154 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_tmp3_);
#line 1154 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_object_it = _tmp5_;
#line 1154 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		while (TRUE) {
#line 7023 "ViewCollection.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			DataObject* object = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			DataSource* source = NULL;
			DataObject* _tmp10_ = NULL;
			DataSource* _tmp11_ = NULL;
			DataSource* _tmp12_ = NULL;
			GType _tmp13_ = 0UL;
			GType _tmp14_ = 0UL;
			gboolean _tmp15_ = FALSE;
#line 1154 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp6_ = _object_it;
#line 1154 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 1154 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (!_tmp7_) {
#line 1154 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				break;
#line 7044 "ViewCollection.c"
			}
#line 1154 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp8_ = _object_it;
#line 1154 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 1154 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			object = (DataObject*) _tmp9_;
#line 1155 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp10_ = object;
#line 1155 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp11_ = data_view_get_source (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_VIEW, DataView));
#line 1155 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			source = _tmp11_;
#line 1156 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp12_ = source;
#line 1156 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp13_ = G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, G_TYPE_OBJECT, GObject));
#line 1156 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp14_ = t;
#line 1156 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp15_ = g_type_is_a (_tmp13_, _tmp14_);
#line 1156 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (_tmp15_) {
#line 7068 "ViewCollection.c"
				GeeList* _tmp16_ = NULL;
				GeeList* _tmp18_ = NULL;
				DataSource* _tmp19_ = NULL;
#line 1157 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp16_ = sources;
#line 1157 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				if (_tmp16_ == NULL) {
#line 7076 "ViewCollection.c"
					GeeArrayList* _tmp17_ = NULL;
#line 1158 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp17_ = gee_array_list_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 1158 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_g_object_unref0 (sources);
#line 1158 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					sources = G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_LIST, GeeList);
#line 7084 "ViewCollection.c"
				}
#line 1160 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp18_ = sources;
#line 1160 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp19_ = source;
#line 1160 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_COLLECTION, GeeCollection), _tmp19_);
#line 7092 "ViewCollection.c"
			}
#line 1154 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (source);
#line 1154 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (object);
#line 7098 "ViewCollection.c"
		}
#line 1154 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_object_it);
#line 7102 "ViewCollection.c"
	}
#line 1164 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = sources;
#line 1164 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 7108 "ViewCollection.c"
}


GeeList* view_collection_get_selected_sources (ViewCollection* self) {
	GeeList* result = NULL;
	GeeList* sources = NULL;
	GeeArrayList* _tmp0_ = NULL;
	gint count = 0;
	DataSet* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 1167 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
#line 1168 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = gee_array_list_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 1168 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	sources = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
#line 1170 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = self->priv->selected;
#line 1170 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = data_set_get_count (_tmp1_);
#line 1170 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	count = _tmp2_;
#line 7131 "ViewCollection.c"
	{
		gint ctr = 0;
#line 1171 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		ctr = 0;
#line 7136 "ViewCollection.c"
		{
			gboolean _tmp3_ = FALSE;
#line 1171 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp3_ = TRUE;
#line 1171 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			while (TRUE) {
#line 7143 "ViewCollection.c"
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				GeeList* _tmp7_ = NULL;
				DataSet* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				DataObject* _tmp10_ = NULL;
				DataView* _tmp11_ = NULL;
				DataSource* _tmp12_ = NULL;
				DataSource* _tmp13_ = NULL;
#line 1171 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				if (!_tmp3_) {
#line 7155 "ViewCollection.c"
					gint _tmp4_ = 0;
#line 1171 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp4_ = ctr;
#line 1171 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					ctr = _tmp4_ + 1;
#line 7161 "ViewCollection.c"
				}
#line 1171 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp3_ = FALSE;
#line 1171 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp5_ = ctr;
#line 1171 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp6_ = count;
#line 1171 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				if (!(_tmp5_ < _tmp6_)) {
#line 1171 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					break;
#line 7173 "ViewCollection.c"
				}
#line 1172 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp7_ = sources;
#line 1172 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp8_ = self->priv->selected;
#line 1172 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp9_ = ctr;
#line 1172 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp10_ = data_set_get_at (_tmp8_, _tmp9_);
#line 1172 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp11_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_VIEW, DataView);
#line 1172 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp12_ = data_view_get_source (_tmp11_);
#line 1172 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp13_ = _tmp12_;
#line 1172 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection), _tmp13_);
#line 1172 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_g_object_unref0 (_tmp13_);
#line 1172 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_g_object_unref0 (_tmp11_);
#line 7195 "ViewCollection.c"
			}
		}
	}
#line 1174 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = sources;
#line 1174 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 7203 "ViewCollection.c"
}


DataSource* view_collection_get_selected_source_at (ViewCollection* self, gint index) {
	DataSource* result = NULL;
	DataObject* object = NULL;
	DataSet* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	DataObject* _tmp2_ = NULL;
	DataSource* _tmp3_ = NULL;
	DataObject* _tmp4_ = NULL;
#line 1177 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
#line 1178 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = self->priv->selected;
#line 1178 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = index;
#line 1178 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = data_set_get_at (_tmp0_, _tmp1_);
#line 1178 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	object = _tmp2_;
#line 1180 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp4_ = object;
#line 1180 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp4_ != NULL) {
#line 7229 "ViewCollection.c"
		DataObject* _tmp5_ = NULL;
		DataSource* _tmp6_ = NULL;
#line 1180 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp5_ = object;
#line 1180 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp6_ = data_view_get_source (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_DATA_VIEW, DataView));
#line 1180 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_tmp3_);
#line 1180 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp3_ = _tmp6_;
#line 7240 "ViewCollection.c"
	} else {
#line 1180 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_tmp3_);
#line 1180 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp3_ = NULL;
#line 7246 "ViewCollection.c"
	}
#line 1180 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = _tmp3_;
#line 1180 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (object);
#line 1180 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 7254 "ViewCollection.c"
}


GeeList* view_collection_get_selected_sources_of_type (ViewCollection* self, GType t) {
	GeeList* result = NULL;
	GeeList* sources = NULL;
#line 1183 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), NULL);
#line 1184 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	sources = NULL;
#line 7265 "ViewCollection.c"
	{
		GeeList* _view_list = NULL;
		GeeList* _tmp0_ = NULL;
		gint _view_size = 0;
		GeeList* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gint _view_index = 0;
#line 1185 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp0_ = view_collection_get_selected (self);
#line 1185 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_view_list = _tmp0_;
#line 1185 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp1_ = _view_list;
#line 1185 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1185 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp3_ = _tmp2_;
#line 1185 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_view_size = _tmp3_;
#line 1185 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_view_index = -1;
#line 1185 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		while (TRUE) {
#line 7290 "ViewCollection.c"
			gint _tmp4_ = 0;
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			DataView* view = NULL;
			GeeList* _tmp7_ = NULL;
			gint _tmp8_ = 0;
			gpointer _tmp9_ = NULL;
			DataSource* source = NULL;
			DataView* _tmp10_ = NULL;
			DataSource* _tmp11_ = NULL;
			DataSource* _tmp12_ = NULL;
			GType _tmp13_ = 0UL;
			GType _tmp14_ = 0UL;
			gboolean _tmp15_ = FALSE;
#line 1185 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp4_ = _view_index;
#line 1185 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_view_index = _tmp4_ + 1;
#line 1185 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp5_ = _view_index;
#line 1185 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp6_ = _view_size;
#line 1185 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (!(_tmp5_ < _tmp6_)) {
#line 1185 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				break;
#line 7317 "ViewCollection.c"
			}
#line 1185 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp7_ = _view_list;
#line 1185 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp8_ = _view_index;
#line 1185 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp9_ = gee_list_get (_tmp7_, _tmp8_);
#line 1185 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			view = (DataView*) _tmp9_;
#line 1186 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp10_ = view;
#line 1186 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp11_ = data_view_get_source (_tmp10_);
#line 1186 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			source = _tmp11_;
#line 1187 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp12_ = source;
#line 1187 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp13_ = G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, G_TYPE_OBJECT, GObject));
#line 1187 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp14_ = t;
#line 1187 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp15_ = g_type_is_a (_tmp13_, _tmp14_);
#line 1187 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			if (_tmp15_) {
#line 7343 "ViewCollection.c"
				GeeList* _tmp16_ = NULL;
				GeeList* _tmp18_ = NULL;
				DataSource* _tmp19_ = NULL;
#line 1188 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp16_ = sources;
#line 1188 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				if (_tmp16_ == NULL) {
#line 7351 "ViewCollection.c"
					GeeArrayList* _tmp17_ = NULL;
#line 1189 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_tmp17_ = gee_array_list_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 1189 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					_g_object_unref0 (sources);
#line 1189 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					sources = G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_LIST, GeeList);
#line 7359 "ViewCollection.c"
				}
#line 1191 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp18_ = sources;
#line 1191 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp19_ = source;
#line 1191 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_COLLECTION, GeeCollection), _tmp19_);
#line 7367 "ViewCollection.c"
			}
#line 1185 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (source);
#line 1185 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (view);
#line 7373 "ViewCollection.c"
		}
#line 1185 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_view_list);
#line 7377 "ViewCollection.c"
	}
#line 1195 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = sources;
#line 1195 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 7383 "ViewCollection.c"
}


gint view_collection_index_of_source (ViewCollection* self, DataSource* source) {
	gint result = 0;
	DataView* view = NULL;
	DataSource* _tmp0_ = NULL;
	DataView* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	DataView* _tmp3_ = NULL;
#line 1199 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), 0);
#line 1199 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), 0);
#line 1200 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = source;
#line 1200 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = view_collection_get_view_for_source (self, _tmp0_);
#line 1200 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view = _tmp1_;
#line 1202 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3_ = view;
#line 1202 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp3_ != NULL) {
#line 7408 "ViewCollection.c"
		DataView* _tmp4_ = NULL;
		gint _tmp5_ = 0;
#line 1202 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp4_ = view;
#line 1202 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp5_ = data_collection_index_of (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_OBJECT, DataObject));
#line 1202 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp2_ = _tmp5_;
#line 7417 "ViewCollection.c"
	} else {
#line 1202 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp2_ = -1;
#line 7421 "ViewCollection.c"
	}
#line 1202 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = _tmp2_;
#line 1202 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (view);
#line 1202 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 7429 "ViewCollection.c"
}


void view_collection_internal_notify_view_altered (ViewCollection* self, DataView* view) {
	gboolean _tmp0_ = FALSE;
#line 1206 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 1206 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_DATA_VIEW (view));
#line 1207 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = data_collection_are_notifications_frozen (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 1207 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (!_tmp0_) {
#line 7443 "ViewCollection.c"
		DataView* _tmp1_ = NULL;
		DataView* _tmp2_ = NULL;
		GeeCollection* _tmp3_ = NULL;
		GeeCollection* _tmp4_ = NULL;
#line 1208 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp1_ = view;
#line 1208 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_collection_notify_item_view_altered (self, _tmp1_);
#line 1209 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp2_ = view;
#line 1209 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp3_ = data_collection_get_singleton (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DATA_OBJECT, DataObject));
#line 1209 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection);
#line 1209 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_collection_notify_views_altered (self, _tmp4_);
#line 1209 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_tmp4_);
#line 7462 "ViewCollection.c"
	} else {
		GeeHashSet* _tmp5_ = NULL;
		GeeHashSet* _tmp7_ = NULL;
		DataView* _tmp8_ = NULL;
#line 1211 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp5_ = self->priv->frozen_views_altered;
#line 1211 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		if (_tmp5_ == NULL) {
#line 7471 "ViewCollection.c"
			GeeHashSet* _tmp6_ = NULL;
#line 1212 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp6_ = gee_hash_set_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 1212 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (self->priv->frozen_views_altered);
#line 1212 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			self->priv->frozen_views_altered = _tmp6_;
#line 7479 "ViewCollection.c"
		}
#line 1213 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp7_ = self->priv->frozen_views_altered;
#line 1213 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp8_ = view;
#line 1213 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp8_);
#line 7487 "ViewCollection.c"
	}
}


void view_collection_internal_notify_geometry_altered (ViewCollection* self, DataView* view) {
	gboolean _tmp0_ = FALSE;
#line 1218 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_COLLECTION (self));
#line 1218 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_DATA_VIEW (view));
#line 1219 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = data_collection_are_notifications_frozen (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 1219 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (!_tmp0_) {
#line 7502 "ViewCollection.c"
		DataView* _tmp1_ = NULL;
		DataView* _tmp2_ = NULL;
		GeeCollection* _tmp3_ = NULL;
		GeeCollection* _tmp4_ = NULL;
#line 1220 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp1_ = view;
#line 1220 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_collection_notify_item_geometry_altered (self, _tmp1_);
#line 1221 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp2_ = view;
#line 1221 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp3_ = data_collection_get_singleton (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DATA_OBJECT, DataObject));
#line 1221 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection);
#line 1221 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_collection_notify_geometries_altered (self, _tmp4_);
#line 1221 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (_tmp4_);
#line 7521 "ViewCollection.c"
	} else {
		GeeHashSet* _tmp5_ = NULL;
		GeeHashSet* _tmp7_ = NULL;
		DataView* _tmp8_ = NULL;
#line 1223 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp5_ = self->priv->frozen_geometries_altered;
#line 1223 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		if (_tmp5_ == NULL) {
#line 7530 "ViewCollection.c"
			GeeHashSet* _tmp6_ = NULL;
#line 1224 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp6_ = gee_hash_set_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 1224 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (self->priv->frozen_geometries_altered);
#line 1224 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			self->priv->frozen_geometries_altered = _tmp6_;
#line 7538 "ViewCollection.c"
		}
#line 1225 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp7_ = self->priv->frozen_geometries_altered;
#line 1225 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp8_ = view;
#line 1225 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp8_);
#line 7546 "ViewCollection.c"
	}
}


static void view_collection_real_notify_thawed (DataCollection* base) {
	ViewCollection * self;
	GeeHashSet* _tmp0_ = NULL;
	GeeHashSet* _tmp9_ = NULL;
#line 1229 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIEW_COLLECTION, ViewCollection);
#line 1230 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = self->priv->frozen_views_altered;
#line 1230 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp0_ != NULL) {
#line 7561 "ViewCollection.c"
		GeeHashSet* _tmp8_ = NULL;
		{
			GeeIterator* _view_it = NULL;
			GeeHashSet* _tmp1_ = NULL;
			GeeIterator* _tmp2_ = NULL;
#line 1231 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp1_ = self->priv->frozen_views_altered;
#line 1231 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp2_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 1231 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_view_it = _tmp2_;
#line 1231 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			while (TRUE) {
#line 7575 "ViewCollection.c"
				GeeIterator* _tmp3_ = NULL;
				gboolean _tmp4_ = FALSE;
				DataView* view = NULL;
				GeeIterator* _tmp5_ = NULL;
				gpointer _tmp6_ = NULL;
				DataView* _tmp7_ = NULL;
#line 1231 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp3_ = _view_it;
#line 1231 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp4_ = gee_iterator_next (_tmp3_);
#line 1231 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				if (!_tmp4_) {
#line 1231 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					break;
#line 7590 "ViewCollection.c"
				}
#line 1231 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp5_ = _view_it;
#line 1231 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp6_ = gee_iterator_get (_tmp5_);
#line 1231 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				view = (DataView*) _tmp6_;
#line 1232 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp7_ = view;
#line 1232 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				view_collection_notify_item_view_altered (self, _tmp7_);
#line 1231 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_g_object_unref0 (view);
#line 7604 "ViewCollection.c"
			}
#line 1231 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (_view_it);
#line 7608 "ViewCollection.c"
		}
#line 1233 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp8_ = self->priv->frozen_views_altered;
#line 1233 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_collection_notify_views_altered (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1234 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (self->priv->frozen_views_altered);
#line 1234 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		self->priv->frozen_views_altered = NULL;
#line 7618 "ViewCollection.c"
	}
#line 1237 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp9_ = self->priv->frozen_geometries_altered;
#line 1237 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (_tmp9_ != NULL) {
#line 7624 "ViewCollection.c"
		GeeHashSet* _tmp17_ = NULL;
		{
			GeeIterator* _view_it = NULL;
			GeeHashSet* _tmp10_ = NULL;
			GeeIterator* _tmp11_ = NULL;
#line 1238 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp10_ = self->priv->frozen_geometries_altered;
#line 1238 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_tmp11_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 1238 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_view_it = _tmp11_;
#line 1238 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			while (TRUE) {
#line 7638 "ViewCollection.c"
				GeeIterator* _tmp12_ = NULL;
				gboolean _tmp13_ = FALSE;
				DataView* view = NULL;
				GeeIterator* _tmp14_ = NULL;
				gpointer _tmp15_ = NULL;
				DataView* _tmp16_ = NULL;
#line 1238 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp12_ = _view_it;
#line 1238 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp13_ = gee_iterator_next (_tmp12_);
#line 1238 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				if (!_tmp13_) {
#line 1238 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
					break;
#line 7653 "ViewCollection.c"
				}
#line 1238 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp14_ = _view_it;
#line 1238 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp15_ = gee_iterator_get (_tmp14_);
#line 1238 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				view = (DataView*) _tmp15_;
#line 1239 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_tmp16_ = view;
#line 1239 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				view_collection_notify_item_geometry_altered (self, _tmp16_);
#line 1238 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
				_g_object_unref0 (view);
#line 7667 "ViewCollection.c"
			}
#line 1238 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			_g_object_unref0 (_view_it);
#line 7671 "ViewCollection.c"
		}
#line 1240 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_tmp17_ = self->priv->frozen_geometries_altered;
#line 1240 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_collection_notify_geometries_altered (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1241 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		_g_object_unref0 (self->priv->frozen_geometries_altered);
#line 1241 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		self->priv->frozen_geometries_altered = NULL;
#line 7681 "ViewCollection.c"
	}
#line 1244 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	DATA_COLLECTION_CLASS (view_collection_parent_class)->notify_thawed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 7685 "ViewCollection.c"
}


gboolean view_collection_are_items_filtered_out (ViewCollection* self) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 1247 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (self), FALSE);
#line 1248 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = DATA_COLLECTION_CLASS (view_collection_parent_class)->get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 1248 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 1248 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = _tmp0_ != _tmp1_;
#line 1248 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 7703 "ViewCollection.c"
}


static void view_collection_real_items_selected (ViewCollection* self, GeeIterable* selected) {
#line 75 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (GEE_IS_ITERABLE (selected));
#line 7710 "ViewCollection.c"
}


static void view_collection_real_items_unselected (ViewCollection* self, GeeIterable* unselected) {
#line 79 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (GEE_IS_ITERABLE (unselected));
#line 7717 "ViewCollection.c"
}


static void view_collection_real_items_state_changed (ViewCollection* self, GeeIterable* changed) {
#line 83 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (GEE_IS_ITERABLE (changed));
#line 7724 "ViewCollection.c"
}


static void view_collection_real_selection_group_altered (ViewCollection* self) {
}


static void view_collection_real_items_shown (ViewCollection* self, GeeCollection* visible) {
#line 94 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (visible));
#line 7735 "ViewCollection.c"
}


static void view_collection_real_items_hidden (ViewCollection* self, GeeCollection* hidden) {
#line 98 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (hidden));
#line 7742 "ViewCollection.c"
}


static void view_collection_real_items_visibility_changed (ViewCollection* self, GeeCollection* changed) {
#line 102 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (changed));
#line 7749 "ViewCollection.c"
}


static void view_collection_real_item_view_altered (ViewCollection* self, DataView* view) {
#line 106 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_DATA_VIEW (view));
#line 7756 "ViewCollection.c"
}


static void view_collection_real_item_geometry_altered (ViewCollection* self, DataView* view) {
#line 110 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_DATA_VIEW (view));
#line 7763 "ViewCollection.c"
}


static void view_collection_real_views_altered (ViewCollection* self, GeeCollection* views) {
#line 113 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (views));
#line 7770 "ViewCollection.c"
}


static void view_collection_real_geometries_altered (ViewCollection* self, GeeCollection* views) {
#line 116 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (views));
#line 7777 "ViewCollection.c"
}


static void view_collection_real_view_filter_installed (ViewCollection* self, ViewFilter* filer) {
#line 119 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_FILTER (filer));
#line 7784 "ViewCollection.c"
}


static void g_cclosure_user_marshal_VOID__VIEW_FILTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__VIEW_FILTER) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__VIEW_FILTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (n_param_values == 2);
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		data1 = closure->data;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		data2 = param_values->data[0].v_pointer;
#line 7803 "ViewCollection.c"
	} else {
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		data1 = param_values->data[0].v_pointer;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		data2 = closure->data;
#line 7809 "ViewCollection.c"
	}
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	callback = (GMarshalFunc_VOID__VIEW_FILTER) (marshal_data ? marshal_data : cc->callback);
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	callback (data1, value_get_view_filter (param_values + 1), data2);
#line 7815 "ViewCollection.c"
}


static void view_collection_real_view_filter_removed (ViewCollection* self, ViewFilter* filer) {
#line 122 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (IS_VIEW_FILTER (filer));
#line 7822 "ViewCollection.c"
}


ViewCollectionMonitor* view_collection_monitor_construct (GType object_type) {
	ViewCollectionMonitor* self = NULL;
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self = (ViewCollectionMonitor*) g_type_create_instance (object_type);
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return self;
#line 7832 "ViewCollection.c"
}


ViewCollectionMonitor* view_collection_monitor_new (void) {
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return view_collection_monitor_construct (VIEW_COLLECTION_TYPE_MONITOR);
#line 7839 "ViewCollection.c"
}


static void view_collection_value_monitor_init (GValue* value) {
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	value->data[0].v_pointer = NULL;
#line 7846 "ViewCollection.c"
}


static void view_collection_value_monitor_free_value (GValue* value) {
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (value->data[0].v_pointer) {
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_collection_monitor_unref (value->data[0].v_pointer);
#line 7855 "ViewCollection.c"
	}
}


static void view_collection_value_monitor_copy_value (const GValue* src_value, GValue* dest_value) {
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (src_value->data[0].v_pointer) {
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		dest_value->data[0].v_pointer = view_collection_monitor_ref (src_value->data[0].v_pointer);
#line 7865 "ViewCollection.c"
	} else {
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		dest_value->data[0].v_pointer = NULL;
#line 7869 "ViewCollection.c"
	}
}


static gpointer view_collection_value_monitor_peek_pointer (const GValue* value) {
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return value->data[0].v_pointer;
#line 7877 "ViewCollection.c"
}


static gchar* view_collection_value_monitor_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (collect_values[0].v_pointer) {
#line 7884 "ViewCollection.c"
		ViewCollectionMonitor* object;
		object = collect_values[0].v_pointer;
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		if (object->parent_instance.g_class == NULL) {
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 7891 "ViewCollection.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 7895 "ViewCollection.c"
		}
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		value->data[0].v_pointer = view_collection_monitor_ref (object);
#line 7899 "ViewCollection.c"
	} else {
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		value->data[0].v_pointer = NULL;
#line 7903 "ViewCollection.c"
	}
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return NULL;
#line 7907 "ViewCollection.c"
}


static gchar* view_collection_value_monitor_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ViewCollectionMonitor** object_p;
	object_p = collect_values[0].v_pointer;
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (!object_p) {
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 7918 "ViewCollection.c"
	}
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (!value->data[0].v_pointer) {
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		*object_p = NULL;
#line 7924 "ViewCollection.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		*object_p = value->data[0].v_pointer;
#line 7928 "ViewCollection.c"
	} else {
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		*object_p = view_collection_monitor_ref (value->data[0].v_pointer);
#line 7932 "ViewCollection.c"
	}
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return NULL;
#line 7936 "ViewCollection.c"
}


GParamSpec* view_collection_param_spec_monitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ViewCollectionParamSpecMonitor* spec;
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (g_type_is_a (object_type, VIEW_COLLECTION_TYPE_MONITOR), NULL);
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return G_PARAM_SPEC (spec);
#line 7950 "ViewCollection.c"
}


gpointer view_collection_value_get_monitor (const GValue* value) {
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VIEW_COLLECTION_TYPE_MONITOR), NULL);
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return value->data[0].v_pointer;
#line 7959 "ViewCollection.c"
}


void view_collection_value_set_monitor (GValue* value, gpointer v_object) {
	ViewCollectionMonitor* old;
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VIEW_COLLECTION_TYPE_MONITOR));
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	old = value->data[0].v_pointer;
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (v_object) {
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VIEW_COLLECTION_TYPE_MONITOR));
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		value->data[0].v_pointer = v_object;
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_collection_monitor_ref (value->data[0].v_pointer);
#line 7979 "ViewCollection.c"
	} else {
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		value->data[0].v_pointer = NULL;
#line 7983 "ViewCollection.c"
	}
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (old) {
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_collection_monitor_unref (old);
#line 7989 "ViewCollection.c"
	}
}


void view_collection_value_take_monitor (GValue* value, gpointer v_object) {
	ViewCollectionMonitor* old;
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VIEW_COLLECTION_TYPE_MONITOR));
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	old = value->data[0].v_pointer;
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (v_object) {
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VIEW_COLLECTION_TYPE_MONITOR));
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		value->data[0].v_pointer = v_object;
#line 8008 "ViewCollection.c"
	} else {
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		value->data[0].v_pointer = NULL;
#line 8012 "ViewCollection.c"
	}
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (old) {
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_collection_monitor_unref (old);
#line 8018 "ViewCollection.c"
	}
}


static void view_collection_monitor_class_init (ViewCollectionMonitorClass * klass) {
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_monitor_parent_class = g_type_class_peek_parent (klass);
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewCollectionMonitorClass *) klass)->finalize = view_collection_monitor_finalize;
#line 8028 "ViewCollection.c"
}


static void view_collection_monitor_instance_init (ViewCollectionMonitor * self) {
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self->ref_count = 1;
#line 8035 "ViewCollection.c"
}


static void view_collection_monitor_finalize (ViewCollectionMonitor* obj) {
	ViewCollectionMonitor * self;
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VIEW_COLLECTION_TYPE_MONITOR, ViewCollectionMonitor);
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_handlers_destroy (self);
#line 8045 "ViewCollection.c"
}


GType view_collection_monitor_get_type (void) {
	static volatile gsize view_collection_monitor_type_id__volatile = 0;
	if (g_once_init_enter (&view_collection_monitor_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { view_collection_value_monitor_init, view_collection_value_monitor_free_value, view_collection_value_monitor_copy_value, view_collection_value_monitor_peek_pointer, "p", view_collection_value_monitor_collect_value, "p", view_collection_value_monitor_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ViewCollectionMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) view_collection_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ViewCollectionMonitor), 0, (GInstanceInitFunc) view_collection_monitor_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType view_collection_monitor_type_id;
		view_collection_monitor_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ViewCollectionMonitor", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&view_collection_monitor_type_id__volatile, view_collection_monitor_type_id);
	}
	return view_collection_monitor_type_id__volatile;
}


gpointer view_collection_monitor_ref (gpointer instance) {
	ViewCollectionMonitor* self;
	self = instance;
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_atomic_int_inc (&self->ref_count);
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return instance;
#line 8070 "ViewCollection.c"
}


void view_collection_monitor_unref (gpointer instance) {
	ViewCollectionMonitor* self;
	self = instance;
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		VIEW_COLLECTION_MONITOR_GET_CLASS (self)->finalize (self);
#line 22 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 8083 "ViewCollection.c"
	}
}


static void _view_collection_on_sources_added_data_collection_items_added (DataCollection* _sender, GeeIterable* added, gpointer self) {
#line 44 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_on_sources_added ((ViewCollection*) self, _sender, added);
#line 8091 "ViewCollection.c"
}


static void _view_collection_on_sources_removed_data_collection_items_removed (DataCollection* _sender, GeeIterable* removed, gpointer self) {
#line 45 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_on_sources_removed ((ViewCollection*) self, removed);
#line 8098 "ViewCollection.c"
}


static void _view_collection_on_sources_altered_data_collection_items_altered (DataCollection* _sender, GeeMap* items, gpointer self) {
#line 46 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_on_sources_altered ((ViewCollection*) self, _sender, items);
#line 8105 "ViewCollection.c"
}


static gpointer _view_manager_ref0 (gpointer self) {
#line 35 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return self ? view_manager_ref (self) : NULL;
#line 8112 "ViewCollection.c"
}


static gpointer _alteration_ref0 (gpointer self) {
#line 36 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return self ? alteration_ref (self) : NULL;
#line 8119 "ViewCollection.c"
}


static ViewCollectionMonitorImpl* view_collection_monitor_impl_construct (GType object_type, ViewCollection* owner, SourceCollection* sources, ViewManager* manager, Alteration* prereq) {
	ViewCollectionMonitorImpl* self = NULL;
	ViewCollection* _tmp0_ = NULL;
	ViewCollection* _tmp1_ = NULL;
	SourceCollection* _tmp2_ = NULL;
	SourceCollection* _tmp3_ = NULL;
	ViewManager* _tmp4_ = NULL;
	ViewManager* _tmp5_ = NULL;
	Alteration* _tmp6_ = NULL;
	Alteration* _tmp7_ = NULL;
	SourceCollection* _tmp8_ = NULL;
	ViewCollection* _tmp9_ = NULL;
	SourceCollection* _tmp10_ = NULL;
	ViewCollection* _tmp11_ = NULL;
	SourceCollection* _tmp12_ = NULL;
	ViewCollection* _tmp13_ = NULL;
#line 31 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (owner), NULL);
#line 31 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_SOURCE_COLLECTION (sources), NULL);
#line 31 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_MANAGER (manager), NULL);
#line 31 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail ((prereq == NULL) || IS_ALTERATION (prereq), NULL);
#line 31 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self = (ViewCollectionMonitorImpl*) view_collection_monitor_construct (object_type);
#line 33 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = owner;
#line 33 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = _data_collection_ref0 (_tmp0_);
#line 33 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_data_collection_unref0 (self->owner);
#line 33 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self->owner = _tmp1_;
#line 34 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = sources;
#line 34 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3_ = _data_collection_ref0 (_tmp2_);
#line 34 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_data_collection_unref0 (self->sources);
#line 34 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self->sources = _tmp3_;
#line 35 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp4_ = manager;
#line 35 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp5_ = _view_manager_ref0 (_tmp4_);
#line 35 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_view_manager_unref0 (self->manager);
#line 35 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self->manager = _tmp5_;
#line 36 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp6_ = prereq;
#line 36 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp7_ = _alteration_ref0 (_tmp6_);
#line 36 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_alteration_unref0 (self->prereq);
#line 36 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self->prereq = _tmp7_;
#line 38 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp8_ = sources;
#line 38 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp9_ = owner;
#line 38 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_COLLECTION, DataCollection), "items-added", (GCallback) _view_collection_on_sources_added_data_collection_items_added, _tmp9_);
#line 39 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp10_ = sources;
#line 39 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp11_ = owner;
#line 39 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_COLLECTION, DataCollection), "items-removed", (GCallback) _view_collection_on_sources_removed_data_collection_items_removed, _tmp11_);
#line 40 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp12_ = sources;
#line 40 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp13_ = owner;
#line 40 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_DATA_COLLECTION, DataCollection), "items-altered", (GCallback) _view_collection_on_sources_altered_data_collection_items_altered, _tmp13_);
#line 31 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return self;
#line 8201 "ViewCollection.c"
}


static ViewCollectionMonitorImpl* view_collection_monitor_impl_new (ViewCollection* owner, SourceCollection* sources, ViewManager* manager, Alteration* prereq) {
#line 31 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return view_collection_monitor_impl_construct (VIEW_COLLECTION_TYPE_MONITOR_IMPL, owner, sources, manager, prereq);
#line 8208 "ViewCollection.c"
}


static void view_collection_monitor_impl_class_init (ViewCollectionMonitorImplClass * klass) {
#line 25 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_monitor_impl_parent_class = g_type_class_peek_parent (klass);
#line 25 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewCollectionMonitorClass *) klass)->finalize = view_collection_monitor_impl_finalize;
#line 8217 "ViewCollection.c"
}


static void view_collection_monitor_impl_instance_init (ViewCollectionMonitorImpl * self) {
}


static void view_collection_monitor_impl_finalize (ViewCollectionMonitor* obj) {
	ViewCollectionMonitorImpl * self;
	SourceCollection* _tmp0_ = NULL;
	ViewCollection* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	SourceCollection* _tmp3_ = NULL;
	ViewCollection* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	SourceCollection* _tmp6_ = NULL;
	ViewCollection* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
#line 25 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VIEW_COLLECTION_TYPE_MONITOR_IMPL, ViewCollectionMonitorImpl);
#line 44 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = self->sources;
#line 44 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = self->owner;
#line 44 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_parse_name ("items-added", TYPE_DATA_COLLECTION, &_tmp2_, NULL, FALSE);
#line 44 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _view_collection_on_sources_added_data_collection_items_added, _tmp1_);
#line 45 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3_ = self->sources;
#line 45 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp4_ = self->owner;
#line 45 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_parse_name ("items-removed", TYPE_DATA_COLLECTION, &_tmp5_, NULL, FALSE);
#line 45 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _view_collection_on_sources_removed_data_collection_items_removed, _tmp4_);
#line 46 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp6_ = self->sources;
#line 46 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp7_ = self->owner;
#line 46 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp8_, NULL, FALSE);
#line 46 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _view_collection_on_sources_altered_data_collection_items_altered, _tmp7_);
#line 26 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_data_collection_unref0 (self->owner);
#line 27 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_data_collection_unref0 (self->sources);
#line 28 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_view_manager_unref0 (self->manager);
#line 29 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_alteration_unref0 (self->prereq);
#line 25 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	VIEW_COLLECTION_MONITOR_CLASS (view_collection_monitor_impl_parent_class)->finalize (obj);
#line 8272 "ViewCollection.c"
}


static GType view_collection_monitor_impl_get_type (void) {
	static volatile gsize view_collection_monitor_impl_type_id__volatile = 0;
	if (g_once_init_enter (&view_collection_monitor_impl_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ViewCollectionMonitorImplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) view_collection_monitor_impl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ViewCollectionMonitorImpl), 0, (GInstanceInitFunc) view_collection_monitor_impl_instance_init, NULL };
		GType view_collection_monitor_impl_type_id;
		view_collection_monitor_impl_type_id = g_type_register_static (VIEW_COLLECTION_TYPE_MONITOR, "ViewCollectionMonitorImpl", &g_define_type_info, 0);
		g_once_init_leave (&view_collection_monitor_impl_type_id__volatile, view_collection_monitor_impl_type_id);
	}
	return view_collection_monitor_impl_type_id__volatile;
}


static ViewCollectionToggleLists* view_collection_toggle_lists_construct (GType object_type) {
	ViewCollectionToggleLists * self = NULL;
#line 50 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self = (ViewCollectionToggleLists*) g_object_new (object_type, NULL);
#line 50 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return self;
#line 8294 "ViewCollection.c"
}


static ViewCollectionToggleLists* view_collection_toggle_lists_new (void) {
#line 50 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return view_collection_toggle_lists_construct (VIEW_COLLECTION_TYPE_TOGGLE_LISTS);
#line 8301 "ViewCollection.c"
}


static void view_collection_toggle_lists_class_init (ViewCollectionToggleListsClass * klass) {
#line 50 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_toggle_lists_parent_class = g_type_class_peek_parent (klass);
#line 50 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	G_OBJECT_CLASS (klass)->finalize = view_collection_toggle_lists_finalize;
#line 8310 "ViewCollection.c"
}


static void view_collection_toggle_lists_instance_init (ViewCollectionToggleLists * self) {
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
#line 51 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 51 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self->selected = _tmp0_;
#line 52 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 52 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self->unselected = _tmp1_;
#line 8325 "ViewCollection.c"
}


static void view_collection_toggle_lists_finalize (GObject* obj) {
	ViewCollectionToggleLists * self;
#line 50 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VIEW_COLLECTION_TYPE_TOGGLE_LISTS, ViewCollectionToggleLists);
#line 51 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (self->selected);
#line 52 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (self->unselected);
#line 50 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	G_OBJECT_CLASS (view_collection_toggle_lists_parent_class)->finalize (obj);
#line 8339 "ViewCollection.c"
}


static GType view_collection_toggle_lists_get_type (void) {
	static volatile gsize view_collection_toggle_lists_type_id__volatile = 0;
	if (g_once_init_enter (&view_collection_toggle_lists_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ViewCollectionToggleListsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) view_collection_toggle_lists_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ViewCollectionToggleLists), 0, (GInstanceInitFunc) view_collection_toggle_lists_instance_init, NULL };
		GType view_collection_toggle_lists_type_id;
		view_collection_toggle_lists_type_id = g_type_register_static (G_TYPE_OBJECT, "ViewCollectionToggleLists", &g_define_type_info, 0);
		g_once_init_leave (&view_collection_toggle_lists_type_id__volatile, view_collection_toggle_lists_type_id);
	}
	return view_collection_toggle_lists_type_id__volatile;
}


static void view_collection_class_init (ViewCollectionClass * klass) {
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_collection_parent_class = g_type_class_peek_parent (klass);
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((DataCollectionClass *) klass)->finalize = view_collection_finalize;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_type_class_add_private (klass, sizeof (ViewCollectionPrivate));
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewCollectionClass *) klass)->notify_items_selected_unselected = (void (*)(ViewCollection*, GeeCollection*, GeeCollection*)) view_collection_real_notify_items_selected_unselected;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewCollectionClass *) klass)->notify_selection_group_altered = (void (*)(ViewCollection*)) view_collection_real_notify_selection_group_altered;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewCollectionClass *) klass)->notify_item_view_altered = (void (*)(ViewCollection*, DataView*)) view_collection_real_notify_item_view_altered;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewCollectionClass *) klass)->notify_views_altered = (void (*)(ViewCollection*, GeeCollection*)) view_collection_real_notify_views_altered;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewCollectionClass *) klass)->notify_item_geometry_altered = (void (*)(ViewCollection*, DataView*)) view_collection_real_notify_item_geometry_altered;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewCollectionClass *) klass)->notify_geometries_altered = (void (*)(ViewCollection*, GeeCollection*)) view_collection_real_notify_geometries_altered;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewCollectionClass *) klass)->notify_items_shown = (void (*)(ViewCollection*, GeeCollection*)) view_collection_real_notify_items_shown;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewCollectionClass *) klass)->notify_items_hidden = (void (*)(ViewCollection*, GeeCollection*)) view_collection_real_notify_items_hidden;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewCollectionClass *) klass)->notify_items_visibility_changed = (void (*)(ViewCollection*, GeeCollection*)) view_collection_real_notify_items_visibility_changed;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewCollectionClass *) klass)->notify_view_filter_installed = (void (*)(ViewCollection*, ViewFilter*)) view_collection_real_notify_view_filter_installed;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewCollectionClass *) klass)->notify_view_filter_removed = (void (*)(ViewCollection*, ViewFilter*)) view_collection_real_notify_view_filter_removed;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((DataCollectionClass *) klass)->clear = (void (*)(DataCollection*)) view_collection_real_clear;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((DataCollectionClass *) klass)->close = (void (*)(DataCollection*)) view_collection_real_close;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((DataCollectionClass *) klass)->valid_type = (gboolean (*)(DataCollection*, DataObject*)) view_collection_real_valid_type;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((DataCollectionClass *) klass)->add = (gboolean (*)(DataCollection*, DataObject*)) view_collection_real_add;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((DataCollectionClass *) klass)->add_many = (GeeCollection* (*)(DataCollection*, GeeCollection*, ProgressMonitor, void*)) view_collection_real_add_many;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((DataCollectionClass *) klass)->notify_items_added = (void (*)(DataCollection*, GeeIterable*)) view_collection_real_notify_items_added;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((DataCollectionClass *) klass)->notify_items_removed = (void (*)(DataCollection*, GeeIterable*)) view_collection_real_notify_items_removed;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((DataCollectionClass *) klass)->items_altered = (void (*)(DataCollection*, GeeMap*)) view_collection_real_items_altered;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((DataCollectionClass *) klass)->set_comparator = (void (*)(DataCollection*, Comparator, void*, ComparatorPredicate, void*)) view_collection_real_set_comparator;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((DataCollectionClass *) klass)->reset_comparator = (void (*)(DataCollection*)) view_collection_real_reset_comparator;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((DataCollectionClass *) klass)->get_all = (GeeCollection* (*)(DataCollection*)) view_collection_real_get_all;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((DataCollectionClass *) klass)->get_count = (gint (*)(DataCollection*)) view_collection_real_get_count;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((DataCollectionClass *) klass)->get_at = (DataObject* (*)(DataCollection*, gint)) view_collection_real_get_at;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((DataCollectionClass *) klass)->index_of = (gint (*)(DataCollection*, DataObject*)) view_collection_real_index_of;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((DataCollectionClass *) klass)->contains = (gboolean (*)(DataCollection*, DataObject*)) view_collection_real_contains;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewCollectionClass *) klass)->get_first = (DataView* (*)(ViewCollection*)) view_collection_real_get_first;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewCollectionClass *) klass)->get_first_unrejected = (DataView* (*)(ViewCollection*)) view_collection_real_get_first_unrejected;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewCollectionClass *) klass)->get_last = (DataView* (*)(ViewCollection*)) view_collection_real_get_last;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewCollectionClass *) klass)->get_next = (DataView* (*)(ViewCollection*, DataView*)) view_collection_real_get_next;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewCollectionClass *) klass)->get_previous = (DataView* (*)(ViewCollection*, DataView*)) view_collection_real_get_previous;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((DataCollectionClass *) klass)->notify_thawed = (void (*)(DataCollection*)) view_collection_real_notify_thawed;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewCollectionClass *) klass)->items_selected = view_collection_real_items_selected;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewCollectionClass *) klass)->items_unselected = view_collection_real_items_unselected;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewCollectionClass *) klass)->items_state_changed = view_collection_real_items_state_changed;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewCollectionClass *) klass)->selection_group_altered = view_collection_real_selection_group_altered;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewCollectionClass *) klass)->items_shown = view_collection_real_items_shown;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewCollectionClass *) klass)->items_hidden = view_collection_real_items_hidden;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewCollectionClass *) klass)->items_visibility_changed = view_collection_real_items_visibility_changed;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewCollectionClass *) klass)->item_view_altered = view_collection_real_item_view_altered;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewCollectionClass *) klass)->item_geometry_altered = view_collection_real_item_geometry_altered;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewCollectionClass *) klass)->views_altered = view_collection_real_views_altered;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewCollectionClass *) klass)->geometries_altered = view_collection_real_geometries_altered;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewCollectionClass *) klass)->view_filter_installed = view_collection_real_view_filter_installed;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewCollectionClass *) klass)->view_filter_removed = view_collection_real_view_filter_removed;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_new ("items_selected", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, items_selected), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_ITERABLE);
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_new ("items_unselected", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, items_unselected), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_ITERABLE);
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_new ("items_state_changed", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, items_state_changed), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_ITERABLE);
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_new ("selection_group_altered", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, selection_group_altered), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_new ("items_shown", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, items_shown), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_new ("items_hidden", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, items_hidden), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_new ("items_visibility_changed", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, items_visibility_changed), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_new ("item_view_altered", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, item_view_altered), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_DATA_VIEW);
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_new ("item_geometry_altered", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, item_geometry_altered), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_DATA_VIEW);
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_new ("views_altered", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, views_altered), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_new ("geometries_altered", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, geometries_altered), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_new ("view_filter_installed", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, view_filter_installed), NULL, NULL, g_cclosure_user_marshal_VOID__VIEW_FILTER, G_TYPE_NONE, 1, TYPE_VIEW_FILTER);
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_new ("view_filter_removed", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, view_filter_removed), NULL, NULL, g_cclosure_user_marshal_VOID__VIEW_FILTER, G_TYPE_NONE, 1, TYPE_VIEW_FILTER);
#line 8478 "ViewCollection.c"
}


static void view_collection_instance_init (ViewCollection * self) {
	GeeHashMultiMap* _tmp0_ = NULL;
	GeeHashSet* _tmp1_ = NULL;
	DataSet* _tmp2_ = NULL;
	GeeHashMap* _tmp3_ = NULL;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self->priv = VIEW_COLLECTION_GET_PRIVATE (self);
#line 59 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp0_ = gee_hash_multi_map_new (TYPE_SOURCE_COLLECTION, (GBoxedCopyFunc) data_collection_ref, (GDestroyNotify) data_collection_unref, VIEW_COLLECTION_TYPE_MONITOR_IMPL, (GBoxedCopyFunc) view_collection_monitor_ref, (GDestroyNotify) view_collection_monitor_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 59 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self->priv->monitors = _tmp0_;
#line 61 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self->priv->mirroring = NULL;
#line 62 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self->priv->mirroring_ctor = NULL;
#line 63 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self->priv->should_mirror = NULL;
#line 64 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp1_ = gee_hash_set_new (TYPE_VIEW_FILTER, (GBoxedCopyFunc) view_filter_ref, (GDestroyNotify) view_filter_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 64 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self->priv->filters = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_SET, GeeSet);
#line 65 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp2_ = data_set_new ();
#line 65 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self->priv->selected = _tmp2_;
#line 66 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self->priv->visible = NULL;
#line 67 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self->priv->frozen_views_altered = NULL;
#line 68 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self->priv->frozen_geometries_altered = NULL;
#line 72 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_tmp3_ = gee_hash_map_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 72 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self->priv->source_map = _tmp3_;
#line 8517 "ViewCollection.c"
}


static void view_collection_finalize (DataCollection* obj) {
	ViewCollection * self;
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIEW_COLLECTION, ViewCollection);
#line 59 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (self->priv->monitors);
#line 61 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_data_collection_unref0 (self->priv->mirroring);
#line 64 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (self->priv->filters);
#line 65 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_data_set_unref0 (self->priv->selected);
#line 66 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_data_set_unref0 (self->priv->visible);
#line 67 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (self->priv->frozen_views_altered);
#line 68 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (self->priv->frozen_geometries_altered);
#line 72 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	_g_object_unref0 (self->priv->source_map);
#line 21 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	DATA_COLLECTION_CLASS (view_collection_parent_class)->finalize (obj);
#line 8543 "ViewCollection.c"
}


GType view_collection_get_type (void) {
	static volatile gsize view_collection_type_id__volatile = 0;
	if (g_once_init_enter (&view_collection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ViewCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) view_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ViewCollection), 0, (GInstanceInitFunc) view_collection_instance_init, NULL };
		GType view_collection_type_id;
		view_collection_type_id = g_type_register_static (TYPE_DATA_COLLECTION, "ViewCollection", &g_define_type_info, 0);
		g_once_init_leave (&view_collection_type_id__volatile, view_collection_type_id);
	}
	return view_collection_type_id__volatile;
}


static gboolean view_manager_real_include_in_view (ViewManager* self, DataSource* source) {
	gboolean result = FALSE;
#line 1258 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), FALSE);
#line 1259 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	result = TRUE;
#line 1259 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return result;
#line 8567 "ViewCollection.c"
}


gboolean view_manager_include_in_view (ViewManager* self, DataSource* source) {
#line 1258 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_MANAGER (self), FALSE);
#line 1258 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return VIEW_MANAGER_GET_CLASS (self)->include_in_view (self, source);
#line 8576 "ViewCollection.c"
}


static DataView* view_manager_real_create_view (ViewManager* self, DataSource* source) {
#line 1264 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_critical ("Type `%s' does not implement abstract method `view_manager_create_view'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 1264 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return NULL;
#line 8585 "ViewCollection.c"
}


DataView* view_manager_create_view (ViewManager* self, DataSource* source) {
#line 1264 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_MANAGER (self), NULL);
#line 1264 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return VIEW_MANAGER_GET_CLASS (self)->create_view (self, source);
#line 8594 "ViewCollection.c"
}


ViewManager* view_manager_construct (GType object_type) {
	ViewManager* self = NULL;
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self = (ViewManager*) g_type_create_instance (object_type);
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return self;
#line 8604 "ViewCollection.c"
}


static void value_view_manager_init (GValue* value) {
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	value->data[0].v_pointer = NULL;
#line 8611 "ViewCollection.c"
}


static void value_view_manager_free_value (GValue* value) {
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (value->data[0].v_pointer) {
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_manager_unref (value->data[0].v_pointer);
#line 8620 "ViewCollection.c"
	}
}


static void value_view_manager_copy_value (const GValue* src_value, GValue* dest_value) {
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (src_value->data[0].v_pointer) {
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		dest_value->data[0].v_pointer = view_manager_ref (src_value->data[0].v_pointer);
#line 8630 "ViewCollection.c"
	} else {
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		dest_value->data[0].v_pointer = NULL;
#line 8634 "ViewCollection.c"
	}
}


static gpointer value_view_manager_peek_pointer (const GValue* value) {
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return value->data[0].v_pointer;
#line 8642 "ViewCollection.c"
}


static gchar* value_view_manager_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (collect_values[0].v_pointer) {
#line 8649 "ViewCollection.c"
		ViewManager* object;
		object = collect_values[0].v_pointer;
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		if (object->parent_instance.g_class == NULL) {
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 8656 "ViewCollection.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 8660 "ViewCollection.c"
		}
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		value->data[0].v_pointer = view_manager_ref (object);
#line 8664 "ViewCollection.c"
	} else {
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		value->data[0].v_pointer = NULL;
#line 8668 "ViewCollection.c"
	}
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return NULL;
#line 8672 "ViewCollection.c"
}


static gchar* value_view_manager_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ViewManager** object_p;
	object_p = collect_values[0].v_pointer;
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (!object_p) {
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 8683 "ViewCollection.c"
	}
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (!value->data[0].v_pointer) {
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		*object_p = NULL;
#line 8689 "ViewCollection.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		*object_p = value->data[0].v_pointer;
#line 8693 "ViewCollection.c"
	} else {
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		*object_p = view_manager_ref (value->data[0].v_pointer);
#line 8697 "ViewCollection.c"
	}
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return NULL;
#line 8701 "ViewCollection.c"
}


GParamSpec* param_spec_view_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecViewManager* spec;
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_VIEW_MANAGER), NULL);
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return G_PARAM_SPEC (spec);
#line 8715 "ViewCollection.c"
}


gpointer value_get_view_manager (const GValue* value) {
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIEW_MANAGER), NULL);
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return value->data[0].v_pointer;
#line 8724 "ViewCollection.c"
}


void value_set_view_manager (GValue* value, gpointer v_object) {
	ViewManager* old;
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIEW_MANAGER));
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	old = value->data[0].v_pointer;
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (v_object) {
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIEW_MANAGER));
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		value->data[0].v_pointer = v_object;
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_manager_ref (value->data[0].v_pointer);
#line 8744 "ViewCollection.c"
	} else {
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		value->data[0].v_pointer = NULL;
#line 8748 "ViewCollection.c"
	}
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (old) {
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_manager_unref (old);
#line 8754 "ViewCollection.c"
	}
}


void value_take_view_manager (GValue* value, gpointer v_object) {
	ViewManager* old;
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIEW_MANAGER));
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	old = value->data[0].v_pointer;
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (v_object) {
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIEW_MANAGER));
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		value->data[0].v_pointer = v_object;
#line 8773 "ViewCollection.c"
	} else {
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		value->data[0].v_pointer = NULL;
#line 8777 "ViewCollection.c"
	}
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (old) {
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_manager_unref (old);
#line 8783 "ViewCollection.c"
	}
}


static void view_manager_class_init (ViewManagerClass * klass) {
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_manager_parent_class = g_type_class_peek_parent (klass);
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewManagerClass *) klass)->finalize = view_manager_finalize;
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewManagerClass *) klass)->include_in_view = (gboolean (*)(ViewManager*, DataSource*)) view_manager_real_include_in_view;
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewManagerClass *) klass)->create_view = (DataView* (*)(ViewManager*, DataSource*)) view_manager_real_create_view;
#line 8797 "ViewCollection.c"
}


static void view_manager_instance_init (ViewManager * self) {
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self->ref_count = 1;
#line 8804 "ViewCollection.c"
}


static void view_manager_finalize (ViewManager* obj) {
	ViewManager * self;
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIEW_MANAGER, ViewManager);
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_handlers_destroy (self);
#line 8814 "ViewCollection.c"
}


GType view_manager_get_type (void) {
	static volatile gsize view_manager_type_id__volatile = 0;
	if (g_once_init_enter (&view_manager_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_view_manager_init, value_view_manager_free_value, value_view_manager_copy_value, value_view_manager_peek_pointer, "p", value_view_manager_collect_value, "p", value_view_manager_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ViewManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) view_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ViewManager), 0, (GInstanceInitFunc) view_manager_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType view_manager_type_id;
		view_manager_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ViewManager", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&view_manager_type_id__volatile, view_manager_type_id);
	}
	return view_manager_type_id__volatile;
}


gpointer view_manager_ref (gpointer instance) {
	ViewManager* self;
	self = instance;
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_atomic_int_inc (&self->ref_count);
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return instance;
#line 8839 "ViewCollection.c"
}


void view_manager_unref (gpointer instance) {
	ViewManager* self;
	self = instance;
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		VIEW_MANAGER_GET_CLASS (self)->finalize (self);
#line 1254 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 8852 "ViewCollection.c"
	}
}


static gboolean view_filter_real_predicate (ViewFilter* self, DataView* view) {
	gboolean _tmp0_ = FALSE;
#line 1286 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_critical ("Type `%s' does not implement abstract method `view_filter_predicate'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 1286 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return _tmp0_;
#line 8863 "ViewCollection.c"
}


gboolean view_filter_predicate (ViewFilter* self, DataView* view) {
#line 1286 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (IS_VIEW_FILTER (self), FALSE);
#line 1286 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return VIEW_FILTER_GET_CLASS (self)->predicate (self, view);
#line 8872 "ViewCollection.c"
}


ViewFilter* view_filter_construct (GType object_type) {
	ViewFilter* self = NULL;
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self = (ViewFilter*) g_type_create_instance (object_type);
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return self;
#line 8882 "ViewCollection.c"
}


static void view_filter_real_refresh (ViewFilter* self) {
}


static void value_view_filter_init (GValue* value) {
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	value->data[0].v_pointer = NULL;
#line 8893 "ViewCollection.c"
}


static void value_view_filter_free_value (GValue* value) {
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (value->data[0].v_pointer) {
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_filter_unref (value->data[0].v_pointer);
#line 8902 "ViewCollection.c"
	}
}


static void value_view_filter_copy_value (const GValue* src_value, GValue* dest_value) {
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (src_value->data[0].v_pointer) {
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		dest_value->data[0].v_pointer = view_filter_ref (src_value->data[0].v_pointer);
#line 8912 "ViewCollection.c"
	} else {
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		dest_value->data[0].v_pointer = NULL;
#line 8916 "ViewCollection.c"
	}
}


static gpointer value_view_filter_peek_pointer (const GValue* value) {
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return value->data[0].v_pointer;
#line 8924 "ViewCollection.c"
}


static gchar* value_view_filter_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (collect_values[0].v_pointer) {
#line 8931 "ViewCollection.c"
		ViewFilter* object;
		object = collect_values[0].v_pointer;
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		if (object->parent_instance.g_class == NULL) {
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 8938 "ViewCollection.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 8942 "ViewCollection.c"
		}
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		value->data[0].v_pointer = view_filter_ref (object);
#line 8946 "ViewCollection.c"
	} else {
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		value->data[0].v_pointer = NULL;
#line 8950 "ViewCollection.c"
	}
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return NULL;
#line 8954 "ViewCollection.c"
}


static gchar* value_view_filter_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ViewFilter** object_p;
	object_p = collect_values[0].v_pointer;
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (!object_p) {
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 8965 "ViewCollection.c"
	}
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (!value->data[0].v_pointer) {
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		*object_p = NULL;
#line 8971 "ViewCollection.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		*object_p = value->data[0].v_pointer;
#line 8975 "ViewCollection.c"
	} else {
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		*object_p = view_filter_ref (value->data[0].v_pointer);
#line 8979 "ViewCollection.c"
	}
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return NULL;
#line 8983 "ViewCollection.c"
}


GParamSpec* param_spec_view_filter (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecViewFilter* spec;
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_VIEW_FILTER), NULL);
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return G_PARAM_SPEC (spec);
#line 8997 "ViewCollection.c"
}


gpointer value_get_view_filter (const GValue* value) {
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIEW_FILTER), NULL);
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return value->data[0].v_pointer;
#line 9006 "ViewCollection.c"
}


void value_set_view_filter (GValue* value, gpointer v_object) {
	ViewFilter* old;
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIEW_FILTER));
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	old = value->data[0].v_pointer;
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (v_object) {
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIEW_FILTER));
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		value->data[0].v_pointer = v_object;
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_filter_ref (value->data[0].v_pointer);
#line 9026 "ViewCollection.c"
	} else {
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		value->data[0].v_pointer = NULL;
#line 9030 "ViewCollection.c"
	}
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (old) {
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_filter_unref (old);
#line 9036 "ViewCollection.c"
	}
}


void value_take_view_filter (GValue* value, gpointer v_object) {
	ViewFilter* old;
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIEW_FILTER));
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	old = value->data[0].v_pointer;
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (v_object) {
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIEW_FILTER));
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		value->data[0].v_pointer = v_object;
#line 9055 "ViewCollection.c"
	} else {
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		value->data[0].v_pointer = NULL;
#line 9059 "ViewCollection.c"
	}
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (old) {
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		view_filter_unref (old);
#line 9065 "ViewCollection.c"
	}
}


static void view_filter_class_init (ViewFilterClass * klass) {
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	view_filter_parent_class = g_type_class_peek_parent (klass);
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewFilterClass *) klass)->finalize = view_filter_finalize;
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewFilterClass *) klass)->predicate = (gboolean (*)(ViewFilter*, DataView*)) view_filter_real_predicate;
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	((ViewFilterClass *) klass)->refresh = view_filter_real_refresh;
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_new ("refresh", TYPE_VIEW_FILTER, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewFilterClass, refresh), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 9081 "ViewCollection.c"
}


static void view_filter_instance_init (ViewFilter * self) {
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self->ref_count = 1;
#line 9088 "ViewCollection.c"
}


static void view_filter_finalize (ViewFilter* obj) {
	ViewFilter * self;
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIEW_FILTER, ViewFilter);
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_signal_handlers_destroy (self);
#line 9098 "ViewCollection.c"
}


GType view_filter_get_type (void) {
	static volatile gsize view_filter_type_id__volatile = 0;
	if (g_once_init_enter (&view_filter_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_view_filter_init, value_view_filter_free_value, value_view_filter_copy_value, value_view_filter_peek_pointer, "p", value_view_filter_collect_value, "p", value_view_filter_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ViewFilterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) view_filter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ViewFilter), 0, (GInstanceInitFunc) view_filter_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType view_filter_type_id;
		view_filter_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ViewFilter", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&view_filter_type_id__volatile, view_filter_type_id);
	}
	return view_filter_type_id__volatile;
}


gpointer view_filter_ref (gpointer instance) {
	ViewFilter* self;
	self = instance;
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	g_atomic_int_inc (&self->ref_count);
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	return instance;
#line 9123 "ViewCollection.c"
}


void view_filter_unref (gpointer instance) {
	ViewFilter* self;
	self = instance;
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		VIEW_FILTER_GET_CLASS (self)->finalize (self);
#line 1279 "/home/jens/Source/shotwell/src/core/ViewCollection.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 9136 "ViewCollection.c"
	}
}



