#ifndef SCREEM_PLUGIN_MANAGER_H
#define SCREEM_PLUGIN_MANAGER_H

#include <glib-object.h>

#include "screem-plugin.h"

#define SCREEM_TYPE_PLUGIN_MANAGER            (screem_plugin_manager_get_type ())
#define SCREEM_PLUGIN_MANAGER(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCREEM_TYPE_PLUGIN_MANAGER, ScreemPluginManager))
#define SCREEM_PLUGIN_MANAGER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), SCREEM_TYPE_PLUGIN_MANAGER, ScreemPluginManagerClass))
#define SCREEM_IS_PLUGIN_MANAGER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCREEM_TYPE_PLUGIN_MANAGER))

#ifndef SCREEM_WINDOW_DEFINED
#define SCREEM_WINDOW_DEFINED
typedef struct ScreemWindow ScreemWindow;
#endif

typedef struct ScreemPluginManagerPrivate ScreemPluginManagerPrivate;

typedef struct ScreemPluginManager ScreemPluginManager;

struct ScreemPluginManager {
	GObject parent;

	ScreemPluginManagerPrivate *priv;
};

typedef struct {
	GObjectClass parent_class;

} ScreemPluginManagerClass;

GType screem_plugin_manager_get_type( void );
ScreemPluginManager* screem_plugin_manager_new( void );

void screem_plugin_manager_scan_plugins( ScreemPluginManager *manager );

ScreemPluginDetails *screem_plugin_manager_get_plugin_by_name( ScreemPluginManager *manager,
		const gchar *name );

void screem_plugin_manager_add_window( ScreemPluginManager *manager,
		ScreemWindow *window );
void screem_plugin_manager_remove_window( ScreemPluginManager *manager,
		ScreemWindow *window );
#endif


