#ifndef SCREEM_HELPER_MANAGER_H
#define SCREEM_HELPER_MANAGER_H

#include <glib-object.h>

#include "screem-helper.h"
#include "screem-page.h"

#define SCREEM_TYPE_HELPER_MANAGER            (screem_helper_manager_get_type ())
#define SCREEM_HELPER_MANAGER(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCREEM_TYPE_HELPER_MANAGER, ScreemHelperManager))
#define SCREEM_HELPER_MANAGER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), SCREEM_TYPE_HELPER_MANAGER, ScreemHelperManagerClass))
#define SCREEM_IS_HELPER_MANAGER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCREEM_TYPE_HELPER_MANAGER))

#ifndef SCREEM_WINDOW_DEFINED
#define SCREEM_WINDOW_DEFINED
typedef struct ScreemWindow ScreemWindow;
#endif


typedef struct ScreemHelperManagerPrivate ScreemHelperManagerPrivate;

typedef struct ScreemHelperManager ScreemHelperManager;

typedef void (*ScreemHelperManagerForeach)( ScreemHelperManager *manager,
		ScreemHelper *helper, gpointer data );

struct ScreemHelperManager {
	GObject parent;

	ScreemHelperManagerPrivate *priv;
};

typedef struct {
	GObjectClass parent_class;

	void (*added)( ScreemHelperManager *manager,
			ScreemHelper *helper );
	void (*removed)( ScreemHelperManager *manager,
			ScreemHelper *helper );

} ScreemHelperManagerClass;

GType screem_helper_manager_get_type( void );
ScreemHelperManager* screem_helper_manager_new( void );

void screem_helper_manager_load_helpers( ScreemHelperManager *manager );

void screem_helper_manager_add_helper( ScreemHelperManager *manager,
		ScreemHelper *helper );
void screem_helper_manager_remove_helper( ScreemHelperManager *manager,
		ScreemHelper *helper );

void screem_helper_manager_exec_all_helpers( ScreemHelperManager *manager,
		ScreemPage *page, ScreemWindow *window );

void screem_helper_manager_edit_helpers( ScreemHelperManager *manager );

void screem_helper_manager_foreach( ScreemHelperManager *manager,
		ScreemHelperManagerForeach func,
		gpointer data );

GSList *screem_helper_manager_get_browsers( ScreemHelperManager *manager );

#endif

