#ifndef SUPPORT_H
#define SUPPORT_H

#include <gtk/gtk.h>

void change_state( GtkWidget *widget, gpointer data );
void change_visible( GtkWidget *widget, gpointer data );

gchar *screem_support_ctags( const gchar *dirname, const gchar *word,
			     gchar **pattern );
gchar *screem_support_escape_regexp( const gchar *pattern );

gboolean screem_gtk_list_store_find( GtkListStore *store,
		GtkTreeIter *iter, guint col, GValue *value,
		GCompareFunc compare );
gboolean screem_gtk_list_store_find_string( GtkListStore *store,
		GtkTreeIter *iter, guint col, const gchar *value );
gboolean screem_gtk_list_store_find_pattern( GtkListStore *store,
		GtkTreeIter *iter, guint col, const gchar *value );
gboolean screem_gtk_list_store_find_mime_type( GtkListStore *store,
		GtkTreeIter *iter, guint col, const gchar *value );

gchar *screem_support_charset_convert( const gchar *data, guint len,
										gchar **data_charset );
gchar *screem_support_charset_convert_to( const gchar *data, 
					const gchar *charset,
					const gchar *from );

gchar *screem_get_mime_type( const gchar *filename, gboolean fast );
gchar *screem_get_mime_type_override( const gchar *filename,
					const gchar *type ); 

const gchar *screem_utf8_skip_space( const gchar *txt );
const gchar *screem_utf8_skip_to_space( const gchar *txt );
	
gchar* screem_escape_underlines( const gchar* text );

gboolean screem_execute_default_app( const gchar *uri );

void g_string_append_utf8_len( GString *str, const gchar *utf8,
				guint len );
GtkPositionType screem_get_tab_position( void );

void screem_set_cursor( GtkWidget *widget, GdkCursorType type );

void screem_popup_menu_do_popup_modal( GtkWidget *popup, 
		GtkMenuPositionFunc pos_func, gpointer pos_data,
		GdkEventButton *event, gpointer user_data, 
		GtkWidget *for_widget );

GtkFileFilter *screem_get_file_filter( const gchar *name );

gboolean screem_find_accel( GtkAccelGroup *group, GdkEventKey *event );

gint screem_mime_type_compare( gconstpointer a, gconstpointer b );

void screem_hig_alert( GtkMessageType type, GtkButtonsType buttons,
		const gchar *primary, const gchar *secondary,
		GtkWidget *parent );

GtkListStore *screem_support_get_mime_types_store( void );

gchar *screem_gdk_color_to_string( const GdkColor *colour,
		gboolean eightbit );

gchar* screem_escape_char( const gchar* text, gchar c );

void screem_gtk_add_history( GtkWidget *widget );

gchar *screem_lookup_icon( GtkIconTheme *icon_theme, const gchar *icon, 
		gint desired_size, gint flags );

gchar *screem_strip_extra_space( const gchar *str );

#endif
