#ifndef SCREEM_TAGFILE_H
#define SCREEM_TAGFILE_H

#include <glib-object.h>

#include <gtk/gtktreemodel.h>

#define SCREEM_TYPE_TAGFILE            (screem_tag_file_get_type ())
#define SCREEM_TAGFILE(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCREEM_TYPE_TAGFILE, ScreemTagFile))
#define SCREEM_TAGFILE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), SCREEM_TYPE_TAGFILE, ScreemTagFileClass))
#define SCREEM_IS_TAGFILE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCREEM_TYPE_TAGFILE))

typedef struct ScreemTagFilePrivate ScreemTagFilePrivate;

#ifndef _SCREEM_TAG_FILE_FORMAT
#define _SCREEM_TAG_FILE_FORMAT
typedef enum {
	SCREEM_TAG_UNKNOWN_FORMAT,
	SCREEM_TAG_TREE_FORMAT,
	SCREEM_TAG_WEML_FORMAT
} ScreemTagFileFormat;
#endif

enum {
	TAG_FILE_NAME_COL = 0,
	TAG_FILE_URI_COL,
	TAG_FILE_DESC_COL,
	TAG_FILE_ACTIVE_COL,
	TAG_FILE_OBJ_COL,
	MAX_TAG_FILE_COLS
};

typedef struct {
	GObject parent;

	ScreemTagFilePrivate *priv;
} ScreemTagFile;

typedef struct {
	GObjectClass parent_class;

} ScreemTagFileClass;

typedef struct {
	gchar *name;
	gboolean required;
	gboolean vallist;
	gchar *type;
	gchar *defvalue;
	gchar *description;
} NodeAttribute;

typedef struct {
	gchar *name;
	
	gchar *open;
	gchar *close;
	
	gchar *file;
	gchar *text;
	
	gchar *description;
	gchar *tip;

	gboolean isfunc;

	/* list of Attribute structs */
	GSList *attributes;

	ScreemTagFile *tfile;
} NodeInfo;



GType screem_tag_file_get_type( void );
ScreemTagFile* screem_tag_file_new( void );

gboolean screem_tag_file_load( ScreemTagFile *tagfile,
		ScreemTagFileFormat format );
gboolean screem_tag_file_load_with_uri( ScreemTagFile *tagfile,
					const gchar *uri,
					ScreemTagFileFormat format );

gboolean screem_tag_file_set_from_string( ScreemTagFile *tagfile,
					const gchar *str,
					guint length );

GtkTreeModel *screem_tag_file_get_model( ScreemTagFile *tagfile );

const gchar *screem_tag_file_get_name( const ScreemTagFile *tagfile );
const gchar *screem_tag_file_get_desc( const ScreemTagFile *tagfile );
const gchar *screem_tag_file_get_uri( const ScreemTagFile *tagfile );
const gchar *screem_tag_file_for_type( const ScreemTagFile *tagfile );
ScreemTagFileFormat screem_tag_file_get_format( const ScreemTagFile *tagfile );

void screem_tag_file_set_name( ScreemTagFile *tagfile, 
				const gchar *name );
void screem_tag_file_set_desc( ScreemTagFile *tagfile,
				const gchar *desc );
void screem_tag_file_set_uri( ScreemTagFile *tagfile,
				const gchar *uri );
void screem_tag_file_set_format( ScreemTagFile *tagfile,
		ScreemTagFileFormat format );
GSList *screem_tag_file_autocomplete( ScreemTagFile *tagfile,
		const gchar *prefix, gboolean fortip );

#endif
