#ifndef SCREEM_WINDOW_PRIVATE_H
#define SCREEM_WINDOW_PRIVATE_H

#include "screem-window.h"

#include "screem-page.h"
#include "screem-site.h"

#include "screem-spell.h"
#include "screem-cvs.h"

#include "gedit-recent.h"

#include "screem-mdi.h"

#include "screem-ctags-model.h"
#include "screem-ctags-view.h"

typedef struct {
	ScreemSite *site;
	ScreemWindow *window;
} SwitchSiteData;

struct ScreemWindowDetails
{
	ScreemMDI *mdi;

	GtkWidget *box;
	GtkWidget *bar;
	GtkWidget *sitebar;
	GSList *sitebargroup;

	GtkWidget *notebook;

	GtkWidget *tagtree;
	GtkWidget *structure;
	GtkWidget *messages;
	GtkWidget *errors;
	
	GtkWidget *online_status;

	/* the views */
	GtkWidget *preview;
	GtkWidget *editor;
	GtkWidget *link_view;
	GtkWidget *tree_view;
	GtkWidget *design;

	/* current view */
	GtkWidget *current;

	/* Screem stuff */
	ScreemSite *current_site;
	ScreemSpell *spell;
	ScreemCVS *cvs;

	gchar *name;

	/* external browser gconf notifications,
	   icon handle, path handle, ... */
	GSList *browser_notify_handles;

	GeditRecent *recent_pages;
	GeditRecent *recent_sites;

	gboolean offline;

	guint status_timeout;

	ScreemCtagsModel *ctagsmodel;
	ScreemCtagsView *ctagsview;
};

void screem_window_recent_page_cb( GeditRecent *recent, const gchar *uri,
				   gpointer data );
void screem_window_recent_site_cb( GeditRecent *recent, const gchar *uri,
				   gpointer data );


void screem_window_initialise_menus( ScreemWindow *window );

void screem_window_change_view( ScreemWindow *window, GtkWidget *view );

void screem_window_add_site( ScreemWindow *window, ScreemSite *site );


#endif
