#ifndef SCREEM_TREE_VIEW_H
#define SCREEM_TREE_VIEW_H

#include "screem-view.h"

#define SCREEM_TYPE_TREE_VIEW (screem_tree_view_get_type())
#define SCREEM_TREE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST( (obj), SCREEM_TYPE_TREE_VIEW, ScreemTreeView ) )
#define SCREEM_IS_TREE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE( (obj), SCREEM_TYPE_TREE_VIEW ) )

#ifndef SCREEM_WINDOW_DEFINED
#define SCREEM_WINDOW_DEFINED
typedef struct ScreemWindow ScreemWindow;
#endif

typedef struct ScreemTreeView ScreemTreeView;
typedef struct ScreemTreeViewPrivate ScreemTreeViewPrivate;

struct ScreemTreeView {
	ScreemView parent;

	ScreemTreeViewPrivate *private;
};

typedef struct {
	ScreemViewClass parent_class;

	void (*select_context) ( ScreemTreeView *view, 
				 guint start, guint end );
} ScreemTreeViewClass;

GType screem_tree_view_get_type( void );
ScreemTreeView *screem_tree_view_new( ScreemWindow *window );

gchar *screem_tree_view_query_element_context( ScreemTreeView *view,
					       guint pos,
					       gboolean query_text,
					       gboolean build,
					       guint *depth,
					       guint *start,
					       guint *end );
#endif
