#ifndef SCREEM_SESSION_H
#define SCREEM_SESSION_H

#include <glib-object.h>

#include "screem-application.h"

#define SCREEM_TYPE_SESSION            (screem_session_get_type ())
#define SCREEM_SESSION(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCREEM_TYPE_SESSION, ScreemSession))
#define SCREEM_SESSION_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), SCREEM_TYPE_SESSION, ScreemSessionClass))
#define SCREEM_IS_SESSION(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCREEM_TYPE_SESSION))

typedef struct ScreemSessionPrivate ScreemSessionPrivate;

#define SESSION_GNOME "type:session_gnome"
#define SESSION_LAST "type:session_last"

typedef struct {
	GObject parent;

	ScreemSessionPrivate *priv;
} ScreemSession;

typedef struct {
	GObjectClass parent_class;

} ScreemSessionClass;

GType screem_session_get_type( void );
ScreemSession* screem_session_new( ScreemApplication *app );

void screem_session_load( ScreemSession *session,
			  const gchar *filename );
gboolean screem_session_save( ScreemSession *session, const gchar *filename );

#endif
