#ifndef SCREEM_CVS_H
#define SCREEM_CVS_H

#include <glib-object.h>

#define SCREEM_TYPE_CVS            (screem_cvs_get_type ())
#define SCREEM_CVS(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCREEM_TYPE_CVS, ScreemCvs))
#define SCREEM_CVS_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), SCREEM_TYPE_CVS, ScreemCvsClass))
#define SCREEM_IS_CVS(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCREEM_TYPE_CVS))

typedef struct ScreemCvsPrivate ScreemCvsPrivate;

typedef struct {
	GObject parent;

	ScreemCvsPrivate *priv;
} ScreemCvs;

typedef struct {
	GObjectClass parent_class;

} ScreemCvsClass;

GType screem_cvs_get_type( void );

ScreemCvs *screem_cvs_new();
ScreemCvs *screem_cvs_new_with_root( const gchar *root );

void screem_cvs_login( ScreemCvs *cvs );

void screem_cvs_checkout( ScreemCvs *cvs, 
			const gchar *pathname,
			const gchar *module );
void screem_cvs_update( ScreemCvs *cvs,
			const gchar *pathname );
					    
void screem_cvs_import( ScreemCvs *cvs, const gchar *pathname,
			const gchar *module,
			const gchar *message );
void screem_cvs_commit( ScreemCvs *cvs, const gchar *pathname,
			const gchar *message );

void screem_cvs_add( ScreemCvs *cvs, const gchar *pathname );
void screem_cvs_remove( ScreemCvs *cvs, const gchar *pathname );


void screem_cvs_set_root( ScreemCvs *cvs, const gchar *root );
gchar *screem_cvs_get_root( ScreemCvs *cvs );
					    
#endif
