#
# SchoolTool - common information systems platform for school administration
# Copyright (c) 2005 Shuttleworth Foundation
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
"""
Browser view for sample batch implementation

$Id: browser.py 4701 2005-08-15 10:01:25Z tvon $
"""

from zope.app.publisher.browser import BrowserView

from schoolbell.batching import Batch

class BatchView(BrowserView):
    """A sample view that implements batching."""

    def __init__(self, context, request):
        BrowserView.__init__(self, context, request)
        self.data = context

    def update(self):
        start = int(self.request.get('batch_start', 0))
        size = int(self.request.get('batch_size', 10))
        self.batch = Batch(self.data, start, size)
