/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This source file is part of SableVM.                            *
 *                                                                 *
 * See the file "LICENSE" for the copyright information and for    *
 * the terms and conditions for copying, distribution and          *
 * modification of this source file.                               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
----------------------------------------------------------------------
Java_java_lang_VMSecurityManager_currentClassLoader
----------------------------------------------------------------------
*/

/*
 * Class:     java_lang_SecurityManager
 * Method:    getClassContext
 * Signature: ()[Ljava/lang/Class;
 */

JNIEXPORT static jobjectArray JNICALL
Java_java_lang_SecurityManager_getClassContext (JNIEnv *_env, jobject this)
{
  _svmt_JNIEnv *env = _svmf_cast_svmt_JNIEnv (_env);
  jobjectArray classes = NULL;

  _svmf_resuming_java (env);

  {
    _svmt_JavaVM *vm = env->vm;
    _svmt_stack_frame *frame = env->stack.current_frame;
    _svmt_method_info *method = frame->method;
    jint class_count = 0;

    _svmt_array_info *array;

    /* skip current frame */
    frame = (_svmt_stack_frame *) (((char *) frame) - frame->previous_offset);
    method = frame->method;

    while (method != &vm->stack_bottom_method &&
	   method != &vm->vm_initiated_call_method)
      {
	if (!_svmf_is_set_flag (method->access_flags, SVM_ACC_INTERNAL))
	  {
	    class_count++;
	  }

	frame = (_svmt_stack_frame *)
	  (((char *) frame) - frame->previous_offset);
	method = frame->method;
      }

    if (_svmm_create_array
	(env, vm->class_loading.boot_loader.class_loader_info,
	 "[Ljava/lang/Class;", array) != JNI_OK)
      {
	goto end;
      }

    if (_svmf_link_array (env, array) != JNI_OK)
      {
	goto end;
      }

    classes = _svmf_get_jni_frame_native_local_array (env);
    if (_svmm_new_array_instance (env, array, class_count, *classes) !=
	JNI_OK)
      {
	goto end;
      }

    class_count = 0;
    frame = env->stack.current_frame;

    /* skip current frame */
    frame = (_svmt_stack_frame *) (((char *) frame) - frame->previous_offset);
    method = frame->method;

    while (method != &vm->stack_bottom_method &&
	   method != &vm->vm_initiated_call_method)
      {
	if (!_svmf_is_set_flag (method->access_flags, SVM_ACC_INTERNAL))
	  {
	    /* we ignore the cast result, as it will always succeed */
	    _svmf_set_reference_array_element_no_exception (env, *classes,
							    class_count++,
							    *(method->
							      class_info->
							      class_instance));
	  }

	frame = (_svmt_stack_frame *)
	  (((char *) frame) - frame->previous_offset);
	method = frame->method;
      }
  }

end:
  _svmf_stopping_java (env);

  return classes;
}
