/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This source file is part of SableVM.                            *
 *                                                                 *
 * See the file "LICENSE" for the copyright information and for    *
 * the terms and conditions for copying, distribution and          *
 * modification of this source file.                               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
----------------------------------------------------------------------
Java_java_lang_Object_getClass
----------------------------------------------------------------------
*/

/*
 * Class:     java_lang_Object
 * Method:    getClass
 * Signature: ()Ljava/lang/Class;
 */

JNIEXPORT static jclass JNICALL
Java_java_lang_Object_getClass (JNIEnv *_env, jobject this)
{
  _svmt_JNIEnv *env = _svmf_cast_svmt_JNIEnv (_env);
  jclass class;

  _svmf_resuming_java (env);

  {
    class = _svmf_get_jni_frame_native_local (env);
    *class = *((*this)->vtable->type->class_instance);
  }

  _svmf_stopping_java (env);

  return class;
}
