/* org.sablevm.vm.StringCreator
   Copyright (C) 2002 Free Software Foundation
 
Modifications Copyright (C) 2004 by Etienne Gagnon.
Modifications Copyright (C) 2004 by David Belanger.
Modifications Copyright (C) 2004 by Grzegorz prokopski.

This file is part of the SableVM class library.
 
The SableVM class library is free software; you can redistribute it
and/or modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2, or (at
your option) any later version.
 
The SableVM class library is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.
 
You should have received a copy of the GNU General Public License
along with the SableVM class library; see the file COPYING.  If not,
write to the Free Software Foundation, Inc., 59 Temple Place, Suite
330, Boston, MA 02111-1307 USA.
 
Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.
 
As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package java.lang;

/**
 * @author Etienne M. Gagnon <etienne.gagnon@uqam,ca>
 */
class StringCreator
{
  private static String createString (byte[] data)
  {
    int size = data.length;
    char[] value = new char[size];
    int count = 0;

    for (int i = 0; i < size; i++)
    {
      int x = ((int) data[i]) & 0x0ff;

      if ((x >>> 7) == 0)
      {
        value[count++] = (char) x;
      }
      else if ((x >>> 5) == 6)
      {
        int y = ((int) data[++i]) & 0x0ff;

        value[count++] = (char) (((x & 0x01f) << 6) + (y & 0x03f));
      }
      else
      {
        int y = ((int) data[++i]) & 0x0ff;
        int z = ((int) data[++i]) & 0x0ff;

        value[count++] = (char) (((x & 0x0f) << 12) + ((y & 0x03f) << 6) + (z & 0x03f));
      }
    }

    return new String(value, 0, count);
  }

  private static int getUTFLength (String s)
  {
    return getUTFLength (s, 0, s.length());
  }

  private static int getUTFLength (String s, int start, int len)
  {
    int result = 0;
    char[] chars = s.toCharArray();

    for (int i = 0; i < len; i++)
    {
      char c = chars[i + start];

      if (c >= 0x0001 && c <= 0x007F)
        result++;
      else if (c >= 0x0800)
        result += 3;
      else
        result += 2;
    }

    return result;
  }

  private static String createInternedString (byte[] data)
  {
    return createString(data).intern();
  }

  private static byte[] getUTFChars (String s)
  {
    byte[] result = new byte[getUTFLength (s) + 1];
    char[] chars = s.toCharArray();
    int len = chars.length;
    int current = 0;

    for (int i = 0; i < len; i++)
    {
      char c = chars[i];

      if (c >= 0x0001 && c <= 0x007F)
      {
        result[current++] = (byte) c;
      }
      else if (c >= 0x0800)
      {
        result[current++] = (byte) (0xE0 | ((c >> 12) & 0x0F));
        result[current++] = (byte) (0x80 | ((c >> 6) & 0x2F));
        result[current++] = (byte) (0x80 | (c & 0x2F));
      }
      else
      {
        result[current++] = (byte) (0xC0 | ((c >> 6) & 0x1F));
        result[current++] = (byte) (0x80 | (c & 0x2F));
      }
    }

    return result;
  }
}
