/*
 * Copyright (C) 2008 Instituto Nokia de Tecnologia. All rights reserved.
 *
 * This file is part of QZion.
 *
 * QZion is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QZion is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QZion.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __QZIONTEXT_H__
#define __QZIONTEXT_H__

#include "qzionobject.h"

class QZionTextPrivate;

/*!
    \brief QZionText.

    A QZionText is a text that can be put in the canvas.
*/
class QZionText : public QZionObject
{
    Q_OBJECT

public:
    QZionText(QZionAbstractCanvas* canvas = NULL);

    QZionText(QZionAbstractCanvas* canvas, const QString &text,
              const QFont &font, const QColor &color=Qt::white);

    virtual ~QZionText();

    enum TextStyle { NoStyle, OutLine, Shadow };

    virtual void setStyle(TextStyle style);
    virtual TextStyle style() const;

    virtual QSize size() const;
    virtual void setSize(const QSize &size);

    QString text() const;
    void setText(const QString &text);

    virtual QColor color() const;
    virtual void setColor(const QColor &color);

    virtual QColor textColor() const;
    virtual void setTextColor(const QColor &color);

    virtual QColor outlineColor() const;
    virtual void setOutlineColor(const QColor &color);

    virtual QColor shadowColor() const;
    virtual void setShadowColor(const QColor &color);

    QFont font() const;
    void setFont(const QFont &font);

    QPointF alignment() const;
    void setAlignment(const QPointF &alignment);

    qreal ellipsisAlignment() const;
    void setEllipsisAlignment(const qreal alignment);

    virtual QRect rect() const;

    /*!
      Paint text on canvas.
    */
    virtual void paint(QPainter* p);

    virtual void changed();

protected:
    QZionTextPrivate *_QZionText_data;

    friend class QZionTextPrivate;
};

#endif
