/*
 * Copyright (C) 2008 Instituto Nokia de Tecnologia. All rights reserved.
 *
 * This file is part of QZion.
 *
 * QZion is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QZion is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QZion.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __QZIONCANVAS_H__
#define __QZIONCANVAS_H__

#include <QtGui/QWidget>

#include "qzionobject.h"
#include "qzionabstractcanvas.h"

class QZionCanvasPrivate;

/*!
    \class QZionCanvas

    A QZionCanvas can contain many QZionObjects (images, rectangles,
    lines, etc.).  It also can provides access to a QWidget that can be
    shown in the screen with the canvas contents.

    Portions of the widget are automatically redrawn to update the
    changes made to the items.

*/
class QZionCanvas : public QObject, public QZionAbstractCanvas
{
    Q_OBJECT

public:
    QZionCanvas(QWidget *parent = NULL);
    virtual ~QZionCanvas();

    virtual void ensurePendingUpdate();
    virtual void invalidate(const QRect &r, bool translate = true);
    virtual void invalidate(const QRegion &r, bool translate = true);

    inline virtual int canvasWidth() const;
    inline virtual int canvasHeight() const;
    virtual QSize sizeHint() const { return size(); }

    virtual QSize size() const;
    virtual void setSize(const QSize &size);

    inline virtual void resize(const QSize &size);
    inline virtual void resize(int width, int height);

    QWidget *widget();
    void show() { widget()->show(); }
    void hide() { widget()->show(); }

public Q_SLOTS:
    virtual void updateChanges();

protected:
    QZionCanvasPrivate *_QZionCanvas_data;

    virtual void paintEvent(QPaintEvent *event);
    virtual void keyPressEvent(QKeyEvent *event);
    virtual void keyReleaseEvent(QKeyEvent *event);

private:
    friend class QZionCanvasPrivate;
};

inline int QZionCanvas::canvasWidth() const
{
    return size().width();
}

inline int QZionCanvas::canvasHeight() const
{
    return size().height();
}

inline void QZionCanvas::resize(const QSize &size)
{
    setSize(size);
}

inline void QZionCanvas::resize(int width, int height)
{
    setSize(QSize(width, height));
}

#endif
