/*
 * Copyright (C) 2008 Instituto Nokia de Tecnologia. All rights reserved.
 *
 * This file is part of QEdje.
 *
 * QEdje is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QEdje is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QEdje.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _VIEWER_H_
#define _VIEWER_H_

#include <QtGui>

#include <qzion.h>
#include <qedje.h>


class Viewer : public QWidget
{
    Q_OBJECT

public:
    Viewer(QWidget *parent = NULL);

    bool load(const QString &filename);
    bool loadGroup(const QString &group);
    bool setGroup(const QString &group);

private:
    QZionCanvas _canvas;
    QLineEdit _entry_emission;
    QLineEdit _entry_source;
    QComboBox _combo_groups;
    QLabel _label_emission;
    QLabel _label_source;
    QLabel _label_groups;
    QEdje *_current;

    QString _filename;

private Q_SLOTS:
    void debugSignal(const QString &emission, const QString &source);
    void emitSignal();
    void groupChanged(int index);
};

#endif
