/*
 * ObjectFileWriter.java
 *
 * Created on 15. Mai 2003, 09:46
 */
package com.sun.star.wizards.tutorial.executer.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

/**
 * Writes the specified object to the file and reads the information from file. Returns
 * an object.
 *
 * @author $author$
 * @version $Revision: 1.2 $
 */
public class ObjectFileWriter {
	/**
	 * Write the specified object to the File.
	 *
	 * @param file
	 * @param obj object
	 *
	 * @return Write status
	 */
	public static boolean writeObjekt(File file, Object obj) {
		boolean status = true;

		if ((file != null) && (obj != null)) {
			try {
				FileOutputStream fos = new FileOutputStream(file);
				ObjectOutputStream oos = new ObjectOutputStream(fos);
				oos.writeObject(obj);
				oos.close();
			} catch (FileNotFoundException fex) {
				status = false;
			} catch (IOException fex) {
				status = false;
			}
		}

		return status;
	}

	/**
	 * Read the specified File.
	 *
	 * @param file
	 *
	 * @return Read object
	 */
	public static Object readObjekt(File file) {
		Object obj = null;

		if ((file != null) && (file != null)) {
			try {
				FileInputStream fis = new FileInputStream(file);
				ObjectInputStream ois = new ObjectInputStream(fis);
				obj = ois.readObject();
				ois.close();
			} catch (FileNotFoundException fex) {
			} catch (IOException fex) {
			} catch (ClassNotFoundException fex) {
			}
		}

		return obj;
	}
}
