/*
 * XComboBoxItemSelection.java
 *
 * Created on 7. Mai 2003, 13:17
 */
package com.sun.star.wizards.tutorial.executer.officeHelper;

import java.util.Hashtable;

/**
 * Combo box item selection interface.
 *
 * @author $author$
 * @version $Revision: 1.2 $
 */
public interface XItemSelection {
	/**
	 * Select item in list, combobox or tree
	 *
	 * @param Accessibility object path
	 * @param Select item index
	 */
	public void selectItem_Index(String[] path, int index);

	/**
	 * Select item in list, combobox or tree
	 *
	 * @param Accessibility object path
	 * @param Select item name
	 */
	public void selectItem_Name(String[] path, String name);

	/**
	 * This class returns the methods of this interface. This class is very important for
	 * the TutorialCreator class.
	 *
	 * @author $author$
	 * @version $Revision: 1.2 $
	 */
	public class XItemSelectionMethods {
		private static final Hashtable m_xhash;

		static {
			m_xhash = getXItemSelection();
		}

		/**
		 * Get methods
		 *
		 * @return hashtable
		 */
		public static Hashtable getMethods() {
			return m_xhash;
		}

		/**
		 * Creates the hashtable with all methods of this interface.
		 *
		 * @return hashtable
		 */
		private static Hashtable getXItemSelection() {
			String[][] selectionItemWithIndex = new String[][] { { "typ", "" }, {
					"method", "selectItem_Index" }, {
					"path", "" }, {
					"index", "" }
			};
			String[][] selectionItemWithName = new String[][] { { "typ", "" }, {
					"method", "selectItem_Name" }, {
					"path", "" }, {
					"name", "" }
			};

			Hashtable xTabList = new Hashtable();
			xTabList.put("selectItem with Index", selectionItemWithIndex);
			xTabList.put("selectItem with Name", selectionItemWithName);

			return xTabList;
		}
	}
}
