/*
 * MethodDialog.java
 *
 * Created on 7. M?rz 2003, 11:50
 */
package com.sun.star.wizards.tutorial.creator.frame.objectFinder;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

import com.sun.star.wizards.tutorial.executer.officeHelper.DesktopDialog;
import com.sun.star.wizards.tutorial.executer.officeHelper.DesktopMenu;
import com.sun.star.wizards.tutorial.executer.officeHelper.Presentation_Drawing;
import com.sun.star.wizards.tutorial.executer.officeHelper.Spreadsheet;
import com.sun.star.wizards.tutorial.executer.officeHelper.TextDocument;

/**
 * The purpose consists in the setting of possible actions for the given staroffice
 * object.
 *
 * @author $author$
 * @version $Revision: 1.2 $
 */
public class MethodDialog extends javax.swing.JDialog {
	private JTable m_table;
	private JList m_list;
	private String m_classTyp;
	private String m_path;
	private Hashtable m_methods;
	private static final Hashtable m_docsMethods;
	private static final Object[] m_columnIdentifiers;
	private ActionFrame m_actionFrame;

	/**
	 * The statical class initializer.
	 */
	static {
		m_columnIdentifiers = new Object[] { "Name", "Value" };

		Hashtable menuBar = DesktopMenu.getInterfaces();
		Hashtable text = TextDocument.getInterfaces();
		Hashtable draw_pres = Presentation_Drawing.getInterfaces();
		Hashtable dialog = DesktopDialog.getInterfaces();
		Hashtable spreadsheet = Spreadsheet.getInterfaces();

		m_docsMethods = new Hashtable();
		m_docsMethods.put("DesktopMenu", menuBar);
		m_docsMethods.put("TextDocument", text);
		m_docsMethods.put("Pres_Draw", draw_pres);
		m_docsMethods.put("DesktopDialog", dialog);
		m_docsMethods.put("SpreadsheetDocument", spreadsheet);
	}

	/**
	 * Creates a new MethodDialog object.
	 *
	 * @param frame ActionFrame
	 */
	public MethodDialog(ActionFrame frame) {
		super(frame);
		m_actionFrame = frame;
		init();
	}

	/**
	 * Initializes the dialog.
	 */
	private void init() {
		setBounds(200, 70, 470, 500);
		setTitle("Methods");
		setModal(true);

		m_list = new JList();
		m_list.setModel(new DefaultComboBoxModel());
		m_list.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		m_list.setBackground(new Color(255, 250, 240));

		JScrollPane listScrollPane = new JScrollPane(m_list);
		listScrollPane.setPreferredSize(new java.awt.Dimension(200, 40));

		TitledBorder listBorder = BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(EtchedBorder.LOWERED), "Methods");
		listScrollPane.setBorder(listBorder);

		m_table = new JTable(new TableModel());
		m_table.setBackground(new Color(255, 250, 240));
		m_table.setColumnModel(new TableColumModel(1));
		m_table.setAutoResizeMode(m_table.AUTO_RESIZE_OFF);

		JScrollPane tableScrollPane = new JScrollPane();
		TitledBorder actionBorder = BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED), "Method and Params");
		tableScrollPane.setBorder(actionBorder);
		tableScrollPane.getViewport().add(m_table, null);

		JComponent bottomButtonPanel = new JPanel(new BorderLayout());
		bottomButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 6, 5));

		JButton action = new JButton("Ok");
		bottomButtonPanel.add(action, BorderLayout.EAST);

		JSplitPane sp = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
		sp.setTopComponent(listScrollPane);
		sp.setBottomComponent(tableScrollPane);
		sp.setOneTouchExpandable(true);
		sp.setDividerSize(15);
		sp.setDividerLocation(150);

		JComponent contentPane = (JPanel) this.getContentPane();
		contentPane.setLayout(new BorderLayout());
		contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
		contentPane.add(sp, BorderLayout.CENTER);
		contentPane.add(bottomButtonPanel, BorderLayout.SOUTH);

		//setVisible(true);
		//********************************
		m_list.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
			public void valueChanged(javax.swing.event.ListSelectionEvent e) {
				if ((m_list.getSelectedIndex() > -1) && !e.getValueIsAdjusting()) {
					updateTable();
				}
			}
		});

		action.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				Vector dataVector = getDataVector();

				if ((dataVector != null) && !dataVector.isEmpty()) {
					for (int i = 0; i < dataVector.size(); i++) {
						Vector dataV = (Vector) dataVector.get(i);

						if (((String) dataV.get(1)).equals("")) {
							JOptionPane.showMessageDialog(m_actionFrame, "Please insert all values!", "Insert Error", JOptionPane.ERROR_MESSAGE);

							return;
						}
					}

					m_actionFrame.addAction();
					dispose();
				}
			}
		});
	}

	/**
	 * Main purpose consists in the window closing clean up.
	 *
	 * @param e WindowEvent
	 */
	protected void processWindowEvent(WindowEvent e) {
		super.processWindowEvent(e);

		if (e.getID() == WindowEvent.WINDOW_CLOSING) {
			dispose();
		}
	}

	/**
	 * Initializes the methode dialog.
	 *
	 * @param path of the found staroffice object
	 * @param classTyp of the staroffice document type
	 */
	public void initMethodDialog(String path, String classTyp) {
		m_path = path;

		if ((m_path.length() > 0) && (m_path.lastIndexOf(";") == (m_path.length() - 1))) {
			m_path = m_path.substring(0, m_path.length() - 1);
		}

		m_classTyp = classTyp;
		initListData();
		removeAllTableData();
	}

	/**
	 * Initializes the list data.
	 */
	private void initListData() {
		DefaultComboBoxModel dModel = (DefaultComboBoxModel) m_list.getModel();

		if (dModel.getSize() > 0) {
			dModel.removeAllElements();
		}

		String typ = m_classTyp;

		if (m_classTyp.equals("PresentationDocument") || m_classTyp.equals("DrawingDocument")) {
			typ = "Pres_Draw";
		}

		m_methods = (Hashtable) m_docsMethods.get(typ);

		if (m_methods != null) {
			for (Enumeration e0 = m_methods.elements(); e0.hasMoreElements();) {
				Hashtable elem0 = (Hashtable) (e0.nextElement());

				for (Enumeration e1 = elem0.keys(); e1.hasMoreElements();) {
					String key = (String) (e1.nextElement());
					dModel.addElement(key);
				}
			}
		}
	}

	/**
	 * Remove all table data.
	 */
	private void removeAllTableData() {
		TableModel tModel = (TableModel) m_table.getModel();

		for (int i = tModel.getRowCount() - 1; i > -1; i--) {
			tModel.removeRow(i);
		}
	}

	/**
	 * Update the table.
	 */
	private void updateTable() {
		m_list.getSelectedIndex();

		String key = (String) m_list.getSelectedValue();
		Object[][] dataVector = null;

		if (m_methods != null) {
			for (Enumeration e0 = m_methods.elements(); e0.hasMoreElements();) {
				Hashtable elem0 = (Hashtable) (e0.nextElement());

				if (elem0.containsKey(key)) {
					dataVector = (Object[][]) elem0.get(key);
				}
			}

			TableModel tModel = (TableModel) m_table.getModel();

			for (int i = tModel.getRowCount() - 1; i > -1; i--) {
				tModel.removeRow(i);
			}

			if (dataVector != null) {
				dataVector[0][1] = m_classTyp;

				if ((dataVector.length > 2) && dataVector[2][0].equals("path")) {
					dataVector[2][1] = "Path=" + m_path;
				}

				tModel.setDataVector(dataVector, m_columnIdentifiers);
			}
		}
	}

	/**
	 * Get data vector.
	 *
	 * @return vector with data
	 */
	public Vector getDataVector() {
		TableModel tModel = (TableModel) m_table.getModel();

		return (Vector) (tModel.getDataVector().clone());
	}
}
