/*
 * DocumentDialog.java
 *
 * Created on 1. M?rz 2003, 14:58
 */
package com.sun.star.wizards.tutorial.creator.frame;

import com.sun.star.wizards.tutorial.creator.frame.objectFinder.XFramework;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;

import java.io.File;

import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;

import com.sun.star.wizards.tutorial.executer.util.FileChooser;
import com.sun.star.wizards.tutorial.executer.util.ObjectFileWriter;

/**
 * The first main frame for tutorial steps definitions. The steps can be managed and
 * handled here. It's possible to define some actions for each step. The whole data can
 * be send to the MacroCreater class, who creates the tutorial macro, or saved and
 * loaded for futher processing.
 *
 * @author $author$
 * @version $Revision: 1.2 $
 */
public class StepFrame extends JFrame {
	private XFramework m_parent;
	private JTextArea m_stepTextArea;
	private JTextArea m_descreptionTextArea;
	private JList m_list;
	private JTable m_table;
	private String m_typDialogTitel = "Tutorial - Creator v1.2";
	private String m_descreptionTitledBorder = "Comment:";
	private String m_stepTitledBorder = "Step :";
	private String m_nextButtonDescreption = "Next >";
	private String m_cancelButtonDescreption = "Close";
	private String m_backButtonDescreption = "< Previous";
	private String m_createButtonDescreption = "Create Macro";
	private String m_saveButton = "Save";
	private String m_loadButton = "Load";
	private String m_errorDescreption = "Please insert step text.";
	private String m_errorName = "Step Error";
	private int m_stepIndex;
	private TitledBorder m_message;
	private StepModel m_model;
	private JPanel m_contentPane;
	private static Vector m_cAction;
	private JButton create;
	private JButton back;
	private JButton next;
	private JButton add;
	private JButton remove;
	private JButton upList;
	private JButton downList;
	private JButton action;
	private JButton removeAction;
	private JButton upTable;
	private JButton downTable;
	private JButton save;

	/**
	 * Creates a new StepFrame object.
	 *
	 * @param xframe DOCUMENT ME!
	 * @param model DOCUMENT ME!
	 */
	public StepFrame(XFramework xframe, StepModel model) {
		m_parent = xframe;
		m_model = model;
		m_stepIndex = 0;
		m_cAction = new Vector();
		m_cAction.add("Typ");
		m_cAction.add("Name");
		m_cAction.add("Params");
		init();
	}

	/**
	 * Initializes the step frame.
	 */
	private void init() {
		m_contentPane = (JPanel) this.getContentPane();
		m_contentPane.setLayout(new BorderLayout());
		m_contentPane.setBorder(BorderFactory.createEmptyBorder(15, 15, 1, 15));
		setBounds(200, 70, 750, 600);
		setTitle(m_typDialogTitel);

		JPanel headerPanel = new JPanel();
		headerPanel.setLayout(new BorderLayout());

		JPanel propertiesPanel = new JPanel();
		propertiesPanel.setPreferredSize(new Dimension(0, 50));
		propertiesPanel.setLayout(new BorderLayout());

		JPanel listJListPanel = new JPanel();
		listJListPanel.setLayout(new BorderLayout());
		m_list = new JList();
		m_list.setBackground(new Color(255, 250, 240));
		m_list.setModel(new DefaultComboBoxModel());
		m_list.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

		JScrollPane listScrollPane = new JScrollPane(m_list);
		listScrollPane.setPreferredSize(new java.awt.Dimension(200, 40));

		TitledBorder listBorder = BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(EtchedBorder.LOWERED), "Steps");
		listScrollPane.setBorder(listBorder);

		JPanel adButtonPanel = new JPanel(new GridLayout(2, 1));
		adButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));

		add = new JButton("Add");
		remove = new JButton("Del");
		remove.setEnabled(false);
		adButtonPanel.add(add);
		adButtonPanel.add(remove);

		JPanel upButtonPanel = new JPanel(new GridLayout(2, 1));
		upButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));

		upList = new JButton("Up");
		downList = new JButton("Down");
		upList.setEnabled(false);
		downList.setEnabled(false);
		upButtonPanel.add(upList);
		upButtonPanel.add(downList);

		JPanel upadButtonPanels = new JPanel(new GridLayout(2, 1));
		upadButtonPanels.setPreferredSize(new Dimension(83, 110));
		upadButtonPanels.setBorder(BorderFactory.createEmptyBorder(20, 10, 0, 5));
		upadButtonPanels.add(adButtonPanel);
		upadButtonPanels.add(upButtonPanel);

		JPanel upadButtonPanels2 = new JPanel(new BorderLayout());
		upadButtonPanels2.add(upadButtonPanels, BorderLayout.NORTH);

		listJListPanel.add(upadButtonPanels2, BorderLayout.EAST);
		listJListPanel.add(listScrollPane, BorderLayout.CENTER);

		JButton cancel = new JButton(m_cancelButtonDescreption);

		create = new JButton(m_createButtonDescreption);
		create.setEnabled(false);
		save = new JButton(m_saveButton);
		save.setEnabled(false);

		JButton load = new JButton(m_loadButton);
		JPanel createPanel = new JPanel();
		createPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
		createPanel.add(save);
		createPanel.add(load);
		createPanel.add(create);
		createPanel.add(cancel);

		propertiesPanel.add(createPanel, BorderLayout.EAST);

		JPanel descreptionPanel = new JPanel();
		descreptionPanel.setPreferredSize(new Dimension(0, 70));
		descreptionPanel.setLayout(new BorderLayout());
		m_descreptionTextArea = new JTextArea();
		m_descreptionTextArea.setBackground(new Color(255, 250, 240));

		JScrollPane descreptionScrollPane = new JScrollPane(m_descreptionTextArea);
		TitledBorder descreption = BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED), m_descreptionTitledBorder);
		descreptionScrollPane.setBorder(descreption);
		descreptionPanel.add(descreptionScrollPane, BorderLayout.CENTER);

		JPanel stepPanel = new JPanel();

		stepPanel.setPreferredSize(new Dimension(0, 220));
		stepPanel.setLayout(new BorderLayout());
		m_stepTextArea = new JTextArea();
		m_stepTextArea.setLineWrap(true);

		m_stepTextArea.setBackground(new Color(255, 250, 240));

		JScrollPane messageScrollPane = new JScrollPane(m_stepTextArea);
		m_message = BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED), m_stepTitledBorder + m_stepIndex);
		messageScrollPane.setBorder(m_message);
		stepPanel.add(messageScrollPane, BorderLayout.CENTER);
		stepPanel.add(listJListPanel, BorderLayout.WEST);

		headerPanel.add(stepPanel, BorderLayout.SOUTH);

		back = new JButton(m_backButtonDescreption);
		next = new JButton(m_nextButtonDescreption);
		back.setEnabled(false);
		next.setEnabled(false);

		JPanel topButtonPanel = new JPanel(new FlowLayout(FlowLayout.RIGHT));

		topButtonPanel.add(back);
		topButtonPanel.add(next);

		JPanel upPanel = new JPanel();
		upPanel.setLayout(new BorderLayout());
		upPanel.setPreferredSize(new Dimension(350, 350));
		upPanel.add(headerPanel, BorderLayout.NORTH);
		upPanel.add(topButtonPanel, BorderLayout.SOUTH);

		DefaultTableColumnModel tCoumModel = new DefaultTableColumnModel() {
			public void moveColumn(int columnIndex, int newIndex) {
			}
		};

		DefaultTableModel tModel = new DefaultTableModel() {
			public boolean isCellEditable(int row, int col) {
				return false;
			}
		};

		tModel.setColumnIdentifiers(new Object[] { "Typ", "Method Name", "Params" });

		m_table = new JTable();
		m_table.setColumnModel(tCoumModel);
		m_table.setModel(tModel);
		m_table.setBackground(new Color(255, 250, 240));
		m_table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
		setTableColumsMinWidth();

		JScrollPane tableScrollPane = new JScrollPane();
		TitledBorder actionBorder = BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED), "Actions");
		tableScrollPane.setBorder(actionBorder);
		tableScrollPane.setPreferredSize(new Dimension(100, 40));
		tableScrollPane.getViewport().add(m_table);

		JPanel bottomButtonPanel = new JPanel(new GridLayout(2, 1));
		bottomButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));

		action = new JButton("Add");
		removeAction = new JButton("Del");
		action.setEnabled(false);
		removeAction.setEnabled(false);
		bottomButtonPanel.add(action);
		bottomButtonPanel.add(removeAction);

		JPanel tableButtonPanel = new JPanel(new GridLayout(2, 1));
		tableButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));

		upTable = new JButton("Up");
		downTable = new JButton("Down");
		upTable.setEnabled(false);
		downTable.setEnabled(false);
		tableButtonPanel.add(upTable);
		tableButtonPanel.add(downTable);

		JPanel tableButtonPanels = new JPanel(new GridLayout(2, 1));
		tableButtonPanels.setPreferredSize(new Dimension(83, 110));
		tableButtonPanels.setBorder(BorderFactory.createEmptyBorder(20, 10, 0, 5));
		tableButtonPanels.add(bottomButtonPanel);
		tableButtonPanels.add(tableButtonPanel);

		JPanel tableButtonPanels2 = new JPanel(new BorderLayout());
		tableButtonPanels2.add(tableButtonPanels, BorderLayout.NORTH);

		JPanel buttomPanel = new JPanel();
		buttomPanel.setLayout(new BorderLayout());
		buttomPanel.add(tableButtonPanels2, BorderLayout.EAST);
		buttomPanel.add(tableScrollPane, BorderLayout.CENTER);

		JSplitPane sp = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
		sp.setTopComponent(upPanel);
		sp.setBottomComponent(buttomPanel);
		sp.setOneTouchExpandable(true);
		sp.setDividerSize(15);
		sp.setDividerLocation(280);

		m_contentPane.add(sp, BorderLayout.CENTER);
		m_contentPane.add(propertiesPanel, BorderLayout.SOUTH);

		//setVisible( true );
		//************************************************************************************
		m_list.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
			public void valueChanged(javax.swing.event.ListSelectionEvent e) {
				if ((m_list.getSelectedIndex() > -1) && (m_list.getSelectedIndex() != m_stepIndex)) {
					selectStep(m_stepIndex, m_list.getSelectedIndex());
				}
			}
		});

		upList.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				DefaultComboBoxModel dModel = (DefaultComboBoxModel) m_list.getModel();
				int index = m_list.getSelectedIndex();

				if (index > 0) {
					getModel().changeStepsIndexes(index - 1, index);
					openStepDialog(index - 1);
				}
			}
		});
		downList.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				DefaultComboBoxModel dModel = (DefaultComboBoxModel) m_list.getModel();
				int index = m_list.getSelectedIndex();

				if ((index > -1) && ((index + 1) < dModel.getSize())) {
					getModel().changeStepsIndexes(index, index + 1);
					openStepDialog(index + 1);
				}
			}
		});

		create.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				createTutorial();
			}
		});
		save.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				save();
			}
		});
		load.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				load();
			}
		});
		add.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (getModel().isStepsEmpty()) {
					m_stepIndex = 0;
				} else if ((m_stepIndex + 1) <= getModel().getStepsSize()) {
					m_stepIndex += 1;
				}

				getModel().addNewStep(m_stepIndex);
				initData(m_stepIndex);
				setProperties("new desc", "new step", m_stepIndex);
			}
		});

		remove.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (!getModel().isStepsEmpty()) {
					removeStep(m_stepIndex);
				}
			}
		});

		cancel.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				cancel();
			}
		});

		back.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				backStep(m_stepIndex);
			}
		});
		next.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				nextStep(m_stepIndex);
			}
		});

		action.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				m_parent.showActionsFrame(getBounds());
				dispose();
			}
		});

		removeAction.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				removeAction();
			}
		});

		upTable.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				int rows = m_table.getSelectedRow();

				if (rows > 0) {
					DefaultTableModel tModel = (DefaultTableModel) m_table.getModel();
					tModel.moveRow(rows, rows, rows - 1);
					m_table.setRowSelectionInterval(rows - 1, rows - 1);
				}
			}
		});

		downTable.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				int rows = m_table.getSelectedRow();
				DefaultTableModel tModel = (DefaultTableModel) m_table.getModel();

				if ((rows > -1) && ((rows + 1) < tModel.getRowCount())) {
					tModel.moveRow(rows, rows, rows + 1);
					m_table.setRowSelectionInterval(rows + 1, rows + 1);
				}
			}
		});
		m_stepTextArea.addCaretListener(new javax.swing.event.CaretListener() {
			public void caretUpdate(javax.swing.event.CaretEvent e) {
				Vector step = createStep(getDescreptionText(), getStepText());

				if (step != null) {
					if (getModel().isStepsEmpty()) {
						m_stepIndex = 0;
					}

					try {
						getModel().removeStep(m_stepIndex);
					} catch (ArrayIndexOutOfBoundsException ex) {
					}

					getModel().addStep(m_stepIndex, step);
					initData(m_stepIndex);
					setButtonsProperties();
				}
			}
		});
	}

	/**
	 * Save the tutorial data
	 */
	public void save() {
		FileChooser fileChooser = new FileChooser();
		File f = fileChooser.saveDialog(this);
		Vector vec = getModel().getDataVector();

		if (!vec.isEmpty()) {
			if (f.exists() && f.isFile()) {
				String message = f.getName() + " already exists.\n Do you want to replace it?";
				int result = JOptionPane.showConfirmDialog(this, message, "Save", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);

				if (result == 0) {
					f.delete();
				} else {

					return;
				}
			} else if (f.exists() && f.isDirectory()) {
				String message = f.getName() + " already exists.\n This is a directory name!.";
				JOptionPane.showMessageDialog(this, message, "Save Error", JOptionPane.ERROR_MESSAGE);

				return;
			}

			boolean result = ObjectFileWriter.writeObjekt(f, vec);

			if (result) {
				JOptionPane.showMessageDialog(this, "Save successfull", "Save Info", JOptionPane.INFORMATION_MESSAGE);
			} else {
				JOptionPane.showMessageDialog(this, "Save failed", "Save Info", JOptionPane.ERROR_MESSAGE);
			}
		}
	}

	/**
	 * Load the tutorial data
	 */
	public void load() {
		FileChooser fileChooser = new FileChooser();
		File f = fileChooser.openDialog(this);
		Object obj = ObjectFileWriter.readObjekt(f);

		if ((obj != null) && obj instanceof Vector) {
			Vector data = (Vector) obj;

			getModel().setDataVector(data);

			openStepDialog(0);
			JOptionPane.showMessageDialog(this, "Load successfull", "Load Info", JOptionPane.INFORMATION_MESSAGE);

			return;
		}

		JOptionPane.showMessageDialog(this, "Load failed", "Load Info", JOptionPane.ERROR_MESSAGE);
	}

	/**
	 * Remove one specified step from the tutorial
	 *
	 * @param stepIndex
	 */
	public void removeStep(int stepIndex) {
		if (stepIndex == 0) {
			try {
				getModel().removeStep(stepIndex);
			} catch (ArrayIndexOutOfBoundsException ex) {
			}

			if (0 < getModel().getStepsSize()) {
				openStepDialog(stepIndex);
			} else {
				initData(stepIndex);
				setProperties("", "", stepIndex);
			}
		} else if (stepIndex > 0) {
			try {
				getModel().removeStep(stepIndex);
			} catch (ArrayIndexOutOfBoundsException ex) {
			}

			if (!getModel().isStepsEmpty()) {
				openStepDialog(--stepIndex);
			}
		}
	}

	/**
	 * Open step dialog for the specified step. The data for this step will be refreshed.
	 *
	 * @param stepIndex
	 */
	public void openStepDialog(int stepIndex) {
		if (stepIndex < getModel().getStepsSize()) {
			Vector step = getModel().getStep(stepIndex);

			if (step != null) {
				String descrption = (String) step.get(0);
				String text = (String) step.get(1);
				initData(stepIndex);
				setProperties(descrption, text, stepIndex);
			}
		}
	}

	/**
	 * Add actions for a step.
	 *
	 * @param dataVector with actions
	 */
	public void addAction(Vector dataVector) {
		if ((dataVector != null) && !dataVector.isEmpty()) {
			DefaultTableModel tModel = (DefaultTableModel) m_table.getModel();

			for (int i = 0; i < dataVector.size(); i++) {
				Vector data = (Vector) dataVector.get(i);
				tModel.addRow(data);
			}
		}
	}

	/**
	 * Remove all selected actions.
	 */
	public void removeAction() {
		int[] rows = m_table.getSelectedRows();

		if (rows.length > 0) {
			DefaultTableModel tModel = (DefaultTableModel) m_table.getModel();

			for (int i = rows.length - 1; i > -1; i--) {
				tModel.removeRow(rows[i]);
			}

			setButtonsProperties();
		}
	}

	/**
	 * Initialize data for the given step.
	 *
	 * @param stepIndex
	 */
	public void initData(int stepIndex) {
		initListData();
		initTableData(stepIndex);
	}

	/**
	 * Initialize table data for the given step.
	 *
	 * @param stepIndex
	 */
	public void initTableData(int stepIndex) {
		DefaultTableModel tModel = (DefaultTableModel) m_table.getModel();
		Vector step = getModel().getStep(stepIndex);

		if (step != null) {
			Vector vAction = (Vector) step.get(2);
			tModel.setDataVector(vAction, m_cAction);
		} else {
			tModel.setDataVector(new Vector(), m_cAction);
		}

		setTableColumsMinWidth();
	}

	/**
	 * Set table columns minimal width.
	 */
	private void setTableColumsMinWidth() {
		m_table.getColumnModel().getColumn(0).setMinWidth(50);
		m_table.getColumnModel().getColumn(1).setMinWidth(100);
		m_table.getColumnModel().getColumn(2).setPreferredWidth(400);
	}

	/**
	 * Initialize list data.
	 */
	public void initListData() {
		String[] data = null;
		int stepSize = getModel().getStepsSize();

		if (stepSize > 0) {
			data = new String[stepSize];

			for (int i = 0; i < stepSize; i++) {
				data[i] = "Step :" + i;
			}
		}

		DefaultComboBoxModel dModel = (DefaultComboBoxModel) m_list.getModel();

		if (dModel.getSize() > 0) {
			dModel.removeAllElements();
		}

		if (data != null) {
			for (int i = 0; i < data.length; i++) {
				dModel.addElement(data[i]);
			}
		}
	}

	/**
	 * Get step actions.
	 *
	 * @return step action in a vector
	 */
	public Vector getStepActions() {
		DefaultTableModel tModel = (DefaultTableModel) m_table.getModel();

		return tModel.getDataVector();
	}

	/**
	 * Processing closing event.
	 *
	 * @param e WindowEvent
	 */
	protected void processWindowEvent(WindowEvent e) {
		if (e.getID() == WindowEvent.WINDOW_CLOSING) {
			int result = JOptionPane.showConfirmDialog(this, "Do you want to close?.", "Close", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);

			if (result == 0) {
				dispose();
				super.processWindowEvent(e);
			}
		}
	}

	/**
	 * Create a tutorial (all the tutorial data will be send to macro creater). If a
	 * macro with the specified name exists, the user can either replace the old macro
	 * or save it with another name.
	 */
	private void createTutorial() {
		if ((getStepText() == null) || getStepText().equals("")) {
			JOptionPane.showMessageDialog(this, m_errorDescreption, m_errorName, JOptionPane.ERROR_MESSAGE);

			return;
		}

		String name = JOptionPane.showInputDialog(this, "Please insert tutorial name:");

		if ((name != null) && name.equals("")) {
			JOptionPane.showMessageDialog(this, "Please insert tutorial name.", "Name Error", JOptionPane.ERROR_MESSAGE);

			return;
		} else if (name == null) {
			return;
		}

		dispose();
		m_parent.showTutorialCreator(getBounds(), name);
	}

	/**
	 * This methode is meant for the closing of the tutorial frame.
	 */
	private void cancel() {
		int result = JOptionPane.showConfirmDialog(this, "Do you want to close?.", "Close", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);

		if (result == 0) {
			dispose();
		}
	}

	/**
	 * Set properties for the current step. Refresh the whole step frame as well.
	 *
	 * @param description
	 * @param text
	 * @param stepIndex
	 */
	public void setProperties(String description, String text, int stepIndex) {
		m_descreptionTextArea.setText(description);
		m_stepIndex = stepIndex;
		setButtonsProperties();
		m_stepTextArea.setText(text);
		m_message.setTitle(m_stepTitledBorder + m_stepIndex);
		m_contentPane.updateUI();
	}

	/**
	 * Set the enabled property of various buttons.
	 */
	public void setButtonsProperties() {
		if (getModel().getStepsSize() > 0) {
			back.setEnabled(true);
			next.setEnabled(true);

			if (m_stepIndex == 0) {
				back.setEnabled(false);
			}

			if ((m_stepIndex == (getModel().getStepsSize() - 1)) || (getModel().getStepsSize() == 0)) {
				next.setEnabled(false);
			}

			create.setEnabled(true);
			save.setEnabled(true);

			remove.setEnabled(true);

			if (getModel().getStepsSize() > 1) {
				upList.setEnabled(true);
				downList.setEnabled(true);
			} else {
				upList.setEnabled(false);
				downList.setEnabled(false);
			}

			action.setEnabled(true);

			if (getStepActions().size() > 0) {
				removeAction.setEnabled(true);

				if (getStepActions().size() > 1) {
					upTable.setEnabled(true);
					downTable.setEnabled(true);
				} else {
					upTable.setEnabled(false);
					downTable.setEnabled(false);
				}
			} else {
				removeAction.setEnabled(false);
				upTable.setEnabled(false);
				downTable.setEnabled(false);
			}
		} else {
			back.setEnabled(false);
			next.setEnabled(false);
			create.setEnabled(false);
			save.setEnabled(false);

			remove.setEnabled(false);
			upList.setEnabled(false);
			downList.setEnabled(false);

			action.setEnabled(false);
			removeAction.setEnabled(false);
			upTable.setEnabled(false);
			downTable.setEnabled(false);
		}
	}

	/**
	 * Get step description.
	 *
	 * @return step description
	 */
	public String getStepText() {
		return m_stepTextArea.getText();
	}

	/**
	 * deprecated
	 *
	 * @return
	 */
	public String getDescreptionText() {
		return "";
	}

	/**
	 * Get the step's model. The whole tutorial data are placed in this model.
	 *
	 * @return step's model
	 */
	public StepModel getModel() {
		return m_model;
	}

	/**
	 * Create a step.
	 *
	 * @param description (deprecated)
	 * @param text (-> step description)
	 *
	 * @return step as a vector
	 */
	private Vector createStep(String description, String text) {
		Vector step = null;

		if (!description.equals("") || !text.equals("")) {
			Vector vStep = getStepActions();
			step = new Vector();
			step.add(0, description);
			step.add(1, text);
			step.add(2, vStep);
		}

		return step;
	}

	/**
	 * Select a step for the given step index. The step frame will be refreshed with the
	 * selected step data. stepIndex is the index of a step in a step list.
	 *
	 * @param stepIndex
	 * @param selectIndex
	 */
	public void selectStep(int stepIndex, int selectIndex) {
		Vector step = createStep(getDescreptionText(), getStepText());

		try {
			getModel().removeStep(stepIndex);
		} catch (ArrayIndexOutOfBoundsException ex) {
		}

		if ((step != null) && !getStepText().equals("")) {
			getModel().addStep(stepIndex, step);
		}

		openStepDialog(selectIndex);
	}

	/**
	 * Get the next step data and refresh the step frame.
	 *
	 * @param stepIndex
	 */
	public void nextStep(int stepIndex) {
		if ((getStepText() == null) || getStepText().equals("")) {
			JOptionPane.showMessageDialog(this, m_errorDescreption, m_errorName, JOptionPane.ERROR_MESSAGE);

			return;
		}

		openStepDialog(++stepIndex);
	}

	/**
	 * Get the previous step data and refesh the step frame.
	 *
	 * @param stepIndex
	 */
	public void backStep(int stepIndex) {
		if ((getStepText() == null) || getStepText().equals("")) {
			JOptionPane.showMessageDialog(this, m_errorDescreption, m_errorName, JOptionPane.ERROR_MESSAGE);

			return;
		}

		openStepDialog(--stepIndex);
	}
}
