/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: Finalizer.java,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 09:37:07 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/package com.sun.star.wizards.report;
import com.sun.star.ucb.CommandAbortedException;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.*;
import com.sun.star.wizards.ui.*;
import com.sun.star.awt.VclWindowPeerAttribute;
import com.sun.star.awt.XTextComponent;
import com.sun.star.container.XHierarchicalNameAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.wizards.db.RecordParser;
import com.sun.star.wizards.document.OfficeDocument;

public class Finalizer {
	WizardDialog CurUnoDialog;

	XTextComponent xTitleTextBox;
	XTextComponent[] xSaveTextBox = new XTextComponent[2];
	Object chkTemplate;

	static String sSaveAsTemplate;
	static String sSaveAsDocument;
	static String sSaveAs;
	static String sUseTemplate;
	static String sEditTemplate;
	static String sReportTitle;
	String CHANGEREPORTTITLE = "changeReportTitle";
	String TOGGLESUBTEMPLATECONTROLS = "toggleSubTemplateControls";
	String slblHowProceed;
	String slblChooseReportKind;
	String TemplatePath;
	String StoreName;
	boolean bfinalaskbeforeOverwrite;
	String DefaultName;
	String OldDefaultName;
	ReportDocument CurReportDocument;
	Desktop.OfficePathRetriever curofficepath;
	short curtabindex;
	String sMsgReportDocumentNameDuplicate;
	
	public static final int SOCREATEDOCUMENT = 1;
	public static final int SOCREATETEMPLATE = 2;
	public static final int SOUSETEMPLATE = 3;		
		

	public Finalizer(ReportDocument _CurReportDocument, WizardDialog _CurUnoDialog) {
		this.CurUnoDialog = _CurUnoDialog;
		this.CurReportDocument = _CurReportDocument;
		curtabindex = (short) (ReportWizard.SOSTOREPAGE * 100);
		Desktop odesktop = new Desktop();
		curofficepath = odesktop.new OfficePathRetriever(CurReportDocument.xMSF);
		sSaveAsTemplate = CurUnoDialog.oResource.getResText(UIConsts.RID_REPORT + 40);
		sUseTemplate = CurUnoDialog.oResource.getResText(UIConsts.RID_REPORT + 41);
		sEditTemplate = CurUnoDialog.oResource.getResText(UIConsts.RID_REPORT + 42);
		sSaveAsDocument = CurUnoDialog.oResource.getResText(UIConsts.RID_REPORT + 43);
		sSaveAs = CurUnoDialog.oResource.getResText(UIConsts.RID_REPORT + 44);
		sReportTitle = CurUnoDialog.oResource.getResText(UIConsts.RID_REPORT + 33);
		sMsgReportDocumentNameDuplicate = CurUnoDialog.oResource.getResText(UIConsts.RID_REPORT + 76);
		slblHowProceed = CurUnoDialog.oResource.getResText(UIConsts.RID_REPORT + 78);
		slblChooseReportKind = CurUnoDialog.oResource.getResText(UIConsts.RID_REPORT + 79);
		CurUnoDialog.insertControlModel("com.sun.star.awt.UnoControlFixedTextModel", "lblTitle", 
										new String[] { "Height", "Label", "PositionX", "PositionY", "Step", "TabIndex", "Width" }, 
										new Object[] { new Integer(8), sReportTitle, new Integer(95), new Integer(27), new Integer(ReportWizard.SOSTOREPAGE), new Short(curtabindex++), new Integer(68)});

		xTitleTextBox = CurUnoDialog.insertTextField("txtTitle", CHANGEREPORTTITLE, this, 
										new String[] { "Height", "HelpURL", "PositionX", "PositionY", "Step", "TabIndex", "Width" }, 
										new Object[] { new Integer(12), "HID:34362", new Integer(95), new Integer(37), new Integer(ReportWizard.SOSTOREPAGE), new Short(curtabindex++), new Integer(209)});

		CurUnoDialog.insertControlModel("com.sun.star.awt.UnoControlFixedTextModel", "lblChooseReportKind", 
										new String[] { "Height", "Label", "PositionX", "PositionY", "Step", "TabIndex", "Width" }, 
										new Object[] { new Integer(8), slblChooseReportKind, new Integer(95), new Integer(57), new Integer(ReportWizard.SOSTOREPAGE), new Short(curtabindex++), new Integer(209)});

		CurUnoDialog.insertRadioButton("optCreateDocument", TOGGLESUBTEMPLATECONTROLS, this,
										new String[] { "Height", "HelpURL", "Label", "PositionX", "PositionY", "State", "Step", "TabIndex", "Width" }, 
										new Object[] { new Integer(10), "HID:34371", sSaveAsDocument, new Integer(95), new Integer(69), new Short((short) 0), new Integer(ReportWizard.SOSTOREPAGE), new Short(curtabindex++), new Integer(138)});

		CurUnoDialog.insertRadioButton("optCreateReportTemplate",TOGGLESUBTEMPLATECONTROLS, this, 
										new String[] { "Height", "HelpURL", "Label", "PositionX", "PositionY", "State", "Step", "TabIndex", "Width" }, 
										new Object[] { new Integer(8), "HID:34370", sSaveAsTemplate, new Integer(95), new Integer(81), new Short((short) 1), new Integer(ReportWizard.SOSTOREPAGE), new Short(curtabindex++), new Integer(209)});


		CurUnoDialog.insertControlModel("com.sun.star.awt.UnoControlFixedTextModel", "lblHowProceed", 
										new String[] { "Height", "Label", "PositionX", "PositionY", "Step", "TabIndex", "Width" }, 
										new Object[] { new Integer(8), slblHowProceed, new Integer(105), new Integer(93), new Integer(ReportWizard.SOSTOREPAGE), new Short(curtabindex++), new Integer(209)});


		CurUnoDialog.insertRadioButton("optEditTemplate", TOGGLESUBTEMPLATECONTROLS, this, 
										new String[] { "Height", "HelpURL", "Label", "PositionX", "PositionY", "Step", "TabIndex", "Width" }, 
										new Object[] { new Integer(10), "HID:34374", sEditTemplate, new Integer(111), new Integer(105), new Integer(6), new Short(curtabindex++), new Integer(138)});

		CurUnoDialog.insertRadioButton("optUseTemplate", TOGGLESUBTEMPLATECONTROLS, this, 
										new String[] { "Height", "HelpURL", "Label", "PositionX", "PositionY", "State", "Step", "TabIndex", "Width" }, 
										new Object[] { new Integer(10), "HID:34375", sUseTemplate, new Integer(111), new Integer(115), new Short((short) 1), new Integer(ReportWizard.SOSTOREPAGE), new Short(curtabindex++), new Integer(138)});
	}
	

	public void toggleSubTemplateControls() {
		String sStorePath = "";
		Short iState = (Short) CurUnoDialog.getControlProperty("optCreateReportTemplate", "State");
		boolean bDoTemplateEnable = iState.shortValue() == 1;
		CurUnoDialog.setControlProperty("optEditTemplate", "Enabled", new Boolean(bDoTemplateEnable));
		CurUnoDialog.setControlProperty("optUseTemplate", "Enabled", new Boolean(bDoTemplateEnable));
		CurUnoDialog.setControlProperty("lblHowProceed", "Enabled", new Boolean(bDoTemplateEnable));
		boolean bDoEnable = xTitleTextBox.getText() != "";
		CurUnoDialog.enableFinishButton(bDoEnable);
	}


//	private boolean fileexists(XMultiServiceFactory _xMSF, String _spath){
//	try {
//		XInterface xUcbInterface = (XInterface) _xMSF.createInstance("com.sun.star.ucb.SimpleFileAccess");
//		XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess) com.sun.star.uno.UnoRuntime.queryInterface(XSimpleFileAccess.class, xUcbInterface);
//		return xSimpleFileAccess.exists(_spath);
//	} catch (Exception exception) {
//		exception.printStackTrace(System.out);
//		return false;
//	}}


	public void initialize(RecordParser _CurDBMetaData) {
		String FirstCommandName = (_CurDBMetaData.getIncludedCommandNames())[0];
		DefaultName = Desktop.getUniqueName(_CurDBMetaData.getReportDocuments(), FirstCommandName);
		if (DefaultName.equals(OldDefaultName) == false)
			OldDefaultName = DefaultName;
		xTitleTextBox.setText(DefaultName);
	}


	public String getStoreName() {
		if (CurUnoDialog != null){
			String LocStoreName = xTitleTextBox.getText();
			if (!LocStoreName.equals(""))
				StoreName = LocStoreName;
		}
		return (StoreName);
	}
	
	
	public String getStorePath(){
	try {
		StoreName = getStoreName();			
		String StorePath;
		XInterface xInterface = (XInterface) CurReportDocument.xMSF.createInstance("com.sun.star.ucb.SimpleFileAccess");
		XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess) UnoRuntime.queryInterface(XSimpleFileAccess.class, xInterface);
		StorePath = FileAccess.getOfficePath(CurReportDocument.xMSF, "Temp", xSimpleFileAccess) + "/" + StoreName;				
		return StorePath;
	} catch (Exception e) {
		e.printStackTrace(System.out);
		return "";
	}}
	
	
	public void changeReportTitle() {
		String TitleName = xTitleTextBox.getText();
		CurReportDocument.updateReportTitle(xTitleTextBox);
	}


	public int getReportOpenMode(){
		int ReportMode = SOCREATEDOCUMENT;
		boolean bcreateTemplate = ((Short) CurUnoDialog.getControlProperty("optCreateReportTemplate", "State")).shortValue() == (short) 1;
		if (bcreateTemplate)
			ReportMode = SOCREATETEMPLATE;
		boolean buseTemplate = ((Short) CurUnoDialog.getControlProperty("optUseTemplate", "State")).shortValue() == (short) 1;
		if (buseTemplate)
			ReportMode = SOUSETEMPLATE;
		boolean buseDocument = ((Short) CurUnoDialog.getControlProperty("optCreateDocument", "State")).shortValue() == (short) 1;
		if (buseDocument)
			ReportMode = SOCREATEDOCUMENT;
		return ReportMode;			
	}
	
	

	public boolean finish() {
		String sShowMsgReportNameisDuplicate;
		StoreName = getStoreName();
		if (CurReportDocument.CurDBMetaData.getReportDocuments().hasByHierarchicalName(StoreName)){
			sShowMsgReportNameisDuplicate = JavaTools.replaceSubString(sMsgReportDocumentNameDuplicate, StoreName, "%REPORTNAME");
			int iMsg = CurUnoDialog.showMessageBox("ErrorBox", VclWindowPeerAttribute.OK, sShowMsgReportNameisDuplicate);
			return false;
		}
		else{
			CurReportDocument.createReportForm(ReportWizard.SOREPORTFORMNAME);
			if ((getReportOpenMode() == SOCREATETEMPLATE || getReportOpenMode() == SOUSETEMPLATE)) {
				CurReportDocument.oTextSectionHandler.breakLinkofTextSections();
				CurReportDocument.CurDBMetaData.storeDatabaseDocumentToTempPath(CurReportDocument.xComponent, StoreName);
			}
			ReportWizard.bCloseDocument = false;
			return true;
		}
	}
}