/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svunzip.h,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 10:09:39 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

/*CSet needs extended language */
#ifdef ICC
#pragma langlvl(extended)
#endif

#ifdef __cplusplus
extern "C"
{
#define DEFAULTNULL = 0
#else
#define DEFAULTNULL
#endif

typedef void		UnzipCallBack( long nBytesWritten );
typedef void		UnzipEnumFilesCallBack( char* pFilename, unsigned long nSize, void* pExtraData );
unsigned long		getCRC32( const char* pZipFilePath );
int					SVUnzip( const char* pZipFilePath, const char* pDestPath,
			 				 const char* pFlags, UnzipCallBack *pCallBackFunc DEFAULTNULL );
int					SVUnzipEnumFiles( const char* pZipFilePath, const char* pPattern,
							 UnzipEnumFilesCallBack*, void* pExtraData );

#ifdef __cplusplus
#undef DEFAULTNULL
}
#endif

