#*************************************************************************
#
#   OpenOffice.org - a multi-platform office productivity suite
#
#   $RCSfile: makefile.mk,v $
#
#   $Revision: 1.5 $
#
#   last change: $Author: rt $ $Date: 2005/09/07 20:21:12 $
#
#   The Contents of this file are made available subject to
#   the terms of GNU Lesser General Public License Version 2.1.
#
#
#     GNU Lesser General Public License Version 2.1
#     =============================================
#     Copyright 2005 by Sun Microsystems, Inc.
#     901 San Antonio Road, Palo Alto, CA 94303, USA
#
#     This library is free software; you can redistribute it and/or
#     modify it under the terms of the GNU Lesser General Public
#     License version 2.1, as published by the Free Software Foundation.
#
#     This library is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#     Lesser General Public License for more details.
#
#     You should have received a copy of the GNU Lesser General Public
#     License along with this library; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#     MA  02111-1307  USA
#
#*************************************************************************

PRJ=..$/..

PRJNAME=slideshow
TARGET=api
ENABLE_EXCEPTIONS=TRUE


# --- Settings -----------------------------------------------------------

.INCLUDE :	settings.mk
.INCLUDE : $(PRJ)$/util$/makefile.pmk

# --- Common ----------------------------------------------------------

SLOFILES =	$(SLO)$/slideshow.obj

.IF "$(debug)"!="" || "$(DEBUG)"!=""
SLOFILES+= $(SLO)$/sp_debug.obj
.ENDIF

# --- Private UNO ----------------------------------------------------------

PRIVATERDB = localtypes.rdb
UNOUCRRDB = $(BIN)$/slideshow.rdb
UNOUCRDEP = $(UNOUCRRDB)
UNOUCROUT = $(OUT)$/inc

CPPUMAKERFLAGS += -C -X$(SOLARBINDIR)$/types.rdb

UNOTYPES = \
	com.sun.star.presentation.XSlideShow \
	com.sun.star.presentation.XSlideShowView \
	com.sun.star.presentation.XSlideShowListener \
	com.sun.star.presentation.XShapeEventListener

ALLIDLFILES = $(foreach,i,$(UNOTYPES) $(subst,.,$/ $i).idl)

# ==========================================================================

.INCLUDE :	target.mk

# --- Private UNO ----------------------------------------------------------

ALLTAR : $(UNOUCRRDB)

$(BIN)$/$(PRIVATERDB) : $(ALLIDLFILES)
	+$(IDLC) -I. -I$(SOLARIDLDIR) -O$(UCR) $(ALLIDLFILES)
	+$(REGMERGE) $@ /UCR $(UCR)$/{$(?:f:s/.idl/.urd/)}

$(UNOUCRRDB) : $(BIN)$/$(PRIVATERDB)
	+$(COPY) $< $@ 