/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: maillistener.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 18:23:14 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef INCLUDED_SFX_MAILLISTENER_HXX
#define INCLUDED_SFX_MAILLISTENER_HXX

#ifndef _COM_SUN_STAR_UNO_EXCEPTION_HPP_
#include <com/sun/star/uno/Exception.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif
#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTIESCHANGELISTENER_HPP_
#include <com/sun/star/beans/XPropertiesChangeListener.hpp>
#endif
#ifndef _LINK_HXX
#include <tools/link.hxx>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _SVTOOLS_INETOPTIONS_HXX_
#include <svtools/inetoptions.hxx>
#endif

// class MailListener_Impl -----------------------------------------------

class MailListener_Impl :
	public ::cppu::WeakImplHelper1< ::com::sun::star::beans::XPropertiesChangeListener >
{
private:
	SvtInetOptions  maInetOptions;
	Link			maChangeLink;
	UniString		maPropertyName;
	UniString		maOutboxServer;

public:
	MailListener_Impl();

	virtual void SAL_CALL	propertiesChange( const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyChangeEvent >& evt )
								throw( ::com::sun::star::uno::RuntimeException );
	virtual void SAL_CALL	disposing( const ::com::sun::star::lang::EventObject& obj )
								throw( ::com::sun::star::uno::RuntimeException );

	void					Initialize();
	void					Deinitialize();
	void					SetChangeHdl( const Link& rLink ) { maChangeLink = rLink; }
	const UniString&		GetOutboxServer() const { return maOutboxServer; }
};

#endif // INCLUDED_SFX_MAILLISTENER_HXX

