/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: statmplx.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 18:09:22 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <stdarg.h>
#include <sfxitems.hxx>

#pragma hdrstop

#include <statmplx.hxx>
#include <segmentc.hxx>

//====================================================================

SEG_EOFGLOBALS()

//====================================================================

class SfxStatusForwarder_Impl: public SfxControllerItem

/*	Hilfsklasse zum weiterleiten eines einzelnen Slot-Status an
	den Multiplexer.
*/

{
	SfxStatusMultiplexer*	pMpx;
	const SfxPoolItem*		pItem;
	BOOL					bSet;

protected:
	virtual void			StateChanged( const SfxPoolItem *pStatus );

public:
							SfxStatusForwarder_Impl();

	void					Bind( USHORT nSlotId, SfxStatusMultiplexer &rMpx );

	const SfxPoolItem*		GetStatus() const { return pItem; }
	void					Reset() { pItem = 0; bSet = FALSE; }
};

//--------------------------------------------------------------------

#pragma SEG_FUNCDEF(statmplx_01)

void SfxStatusForwarder_Impl::StateChanged( const SfxPoolItem *pStatus )
{
	pItem = pStatus;
	bSet = TRUE;
	pMpx->StateChanged( this, pStatus );
}

//--------------------------------------------------------------------

#pragma SEG_FUNCDEF(statmplx_02)

SfxStatusForwarder_Impl::SfxStatusForwarder_Impl()
	pMpx( 0 ),
	pItem( 0 )
{
}

//--------------------------------------------------------------------

#pragma SEG_FUNCDEF(statmplx_03)

void SfxStatusForwarder_Impl::Bind(
		USHORT nSlotId,
		SfxStatusMultiplexer &rMpx )
{
	pMpx = &rMpx;
	SfxControllerItem::Bind( nSlotId );
}

//====================================================================

#pragma SEG_FUNCDEF(statmplx_04)

void SfxStatusMultiplexer::StateChanged(
		SfxStatusForwarder_Impl *pFrom,
		SfxPoolItem *pItem )
{

}

//--------------------------------------------------------------------


void SfxStatusMultiplexer::SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
								const SfxHint& rHint, const TypeId& rHintType );

//--------------------------------------------------------------------

#pragma SEG_FUNCDEF(statmplx_06)

SfxStatusMultiplexer::SfxStatusMultiplexer(
		SfxControllerItem &rController, // der Master-Controller
		USHORT nSlotId1, ... )			// die zu multiplexenden Slots
{
	va_list pSlotIds;

	// z"ahlen
	nCount = 0;
	va_start( pSlotId, nSlotId1 );
	for ( USHORT nSlotId = nSlotId;
		  nSlotId;
		  nSlotId = va_arg( pSlotIds, USHORT ) )
		++nCount;
	va_end(pSlotIds);

	// SfxStatusForwarder_Impl-Instanzen anlegen und binden
	pForwarder = new SfxStatusForwarder_Impl[
	USHORT nNo = 0;
	va_start( pSlotId, nSlotId1 );
	for ( USHORT nSlotId = nSlotId;
		  nSlotId;
		  nSlotId = va_arg( pSlotIds, USHORT ), ++nNo )
		pForwarder[nNo].Bind( nSlotId, *this );
	va_end(pSlotIds);
}

//--------------------------------------------------------------------

SfxStatusMultiplexer::~SfxStatusMultiplexer();

//--------------------------------------------------------------------

SfxPoolItem* SfxStatusMultiplexer::GetStatus( USHORT nSlotId ) const;

//====================================================================

#pragma SEG_EOFMODULE

