/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: AccGrid.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 23:57:28 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SCH_ACCGRID_HXX
#define _SCH_ACCGRID_HXX

#ifndef _SCH_ACCESSIBLECHARTELEMENT_HXX_
#include "AccessibleChartElement.hxx"
#endif

// for CHOBJID_...
#ifndef _DEFINES_HXX
#include "defines.hxx"
#endif

namespace accessibility
{

class Grid : public AccessibleChartElement
{
public:
    enum GridType
    {
        X_MAJOR = CHOBJID_DIAGRAM_X_GRID_MAIN,
        Y_MAJOR = CHOBJID_DIAGRAM_Y_GRID_MAIN,
        Z_MAJOR = CHOBJID_DIAGRAM_Z_GRID_MAIN,
        // note: this id is correct, x/y minor grids are interchanged
        X_MINOR = CHOBJID_DIAGRAM_Y_GRID_HELP,
        // note: this id is correct, x/y minor grids are interchanged
        Y_MINOR = CHOBJID_DIAGRAM_X_GRID_HELP,
        Z_MINOR = CHOBJID_DIAGRAM_Z_GRID_HELP
    };

    Grid( AccessibleBase * pParent, GridType eType );
    virtual ~Grid();

    // ________ XAccessibleContext ________
    virtual ::rtl::OUString SAL_CALL getAccessibleName() throw (::com::sun::star::uno::RuntimeException);
//     virtual ::rtl::OUString SAL_CALL getAccessibleDescription() throw (::com::sun::star::uno::RuntimeException);

    // ________ XServiceInfo ________
    virtual ::rtl::OUString SAL_CALL getImplementationName() throw (::com::sun::star::uno::RuntimeException);

protected:
    // AccessibleChartElement
    virtual SdrObject * GetDrawObject() const;

private:
    GridType    m_eType;
};

}  // accessibility

// _SCH_ACCGRID_HXX
#endif
