/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: osxlocale.c,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 16:08:32 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <sal/types.h>

#include <premac.h>
#include <CoreServices/CoreServices.h>
#include <CoreFoundation/CoreFoundation.h>
#include <postmac.h>

/*
 * macxp_getOSXLocale
 *
 * Grab current locale from system.
 */
int macxp_getOSXLocale( char *locale, sal_uInt32 bufferLen )
{	
	CFStringRef sref = (CFStringRef)CFPreferencesCopyAppValue(CFSTR("AppleLocale"), kCFPreferencesCurrentApplication);
		
	if ((sref != NULL) && (CFGetTypeID(sref) == CFStringGetTypeID()))
	{
		// split the string into substrings; the first two (if there are two) substrings 
		// are language and country
		CFArrayRef subs = CFStringCreateArrayBySeparatingStrings(NULL, sref, CFSTR("_"));
		
		CFStringRef lang = (CFStringRef)CFArrayGetValueAtIndex(subs, 0);
		CFStringGetCString(lang, locale, bufferLen, kCFStringEncodingASCII);
		
		// country also available? Assumption: if the array contains more than one
		// value the second value is always the country!
		if (CFArrayGetCount(subs) > 1)
		{
			strlcat(locale, "_", bufferLen - strlen(locale));
			
			CFStringRef country = (CFStringRef)CFArrayGetValueAtIndex(subs, 1);
			CFStringGetCString(country, locale + strlen(locale), bufferLen - strlen(locale), kCFStringEncodingASCII);			
		}
	    
        // Append 'UTF-8' to the locale because the Mac OS X file
        // system interface is UTF-8 based and sal tries to determine
        // the file system locale from the locale information 
		strlcat(locale, ".UTF-8", bufferLen - strlen(locale));							
		
		CFRelease(subs);
	}
	else
		fprintf( stderr, "Could not get Canonical Locale Identifier from AppleLanguages value!\n" );

    CFRelease(sref);
	
	return noErr;
}


/*
 * macxp_OSXConvertCFEncodingToIANACharSetName
 *
 * Convert a CoreFoundation text encoding to an IANA charset name.
 */
int macxp_OSXConvertCFEncodingToIANACharSetName( char *buffer, unsigned int bufferLen, CFStringEncoding cfEncoding )
{
	CFStringRef	sCFEncodingName;

	sCFEncodingName = CFStringConvertEncodingToIANACharSetName( cfEncoding );
	CFStringGetCString( sCFEncodingName, buffer, bufferLen, cfEncoding );

	return( noErr );
}

