
package org.netbeans.modules.openoffice;

import org.openide.actions.OpenAction;
import org.openide.compiler.CompilerType;
import org.openide.execution.Executor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.*;
import org.openide.nodes.*;
import org.openide.text.EditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;


public class OOIDLDataObject extends MultiDataObject {
    /** generated Serialized Version UID */
    
    /** Create a new makefile object.
     * @param obj the makefile
     * @param loader the makefile loader
     * @throws DataObjectExistsException standard exception
     */
    public OOIDLDataObject (final FileObject obj, final UniFileLoader loader)
    throws DataObjectExistsException {
        super (obj, loader);
        EditorSupport ed = new EditorSupport (getPrimaryEntry ());
        ed.setMIMEType ("text/x-java");
        getCookieSet().add (ed);
        getCookieSet ().add (new CompilerSupport.Compile (getPrimaryEntry ()) {
                                 protected CompilerType defaultCompilerType () {
                                     return CompilerType.find (OOIDLCompilerType.class);
                                 }
                             });
    }

    /** Create a makefile node.
     * @return the node
     */
    protected Node createNodeDelegate () {
        return new OOIDLNode (this);
    }

    /** Get context help for the object/node.
     * @return general help
     */
    public HelpCtx getHelpCtx () {
        return HelpCtx.DEFAULT_HELP;
    }

    /** OOIDL Node implementation.
    * Leaf node, default action opens editor or instantiates template.
    * Icons redefined.
    */
    public static class OOIDLNode extends DataNode {
        /** Icon base for the OOIDLNode node */
        private static final String OOIDL_ICON_BASE =
            "org/netbeans/modules/openoffice/idl";

        /** Create the node.
         * @param dob a data object
         */
        public OOIDLNode (DataObject dob) {
            this (dob, Children.LEAF);
        }

        /** Create the node with special children.
         * @param dataObject the data object
         * @param ch children to use
         */
        public OOIDLNode (DataObject dataObject, Children ch) {
            super (dataObject, ch);
            setIconBase (OOIDL_ICON_BASE);
            setDefaultAction (SystemAction.get (OpenAction.class));
        }

    }

}
