#*************************************************************************
#
#   OpenOffice.org - a multi-platform office productivity suite
#
#   $RCSfile: makefile.mk,v $
#
#   $Revision: 1.10 $
#
#   last change: $Author: rt $ $Date: 2005/09/07 18:24:44 $
#
#   The Contents of this file are made available subject to
#   the terms of GNU Lesser General Public License Version 2.1.
#
#
#     GNU Lesser General Public License Version 2.1
#     =============================================
#     Copyright 2005 by Sun Microsystems, Inc.
#     901 San Antonio Road, Palo Alto, CA 94303, USA
#
#     This library is free software; you can redistribute it and/or
#     modify it under the terms of the GNU Lesser General Public
#     License version 2.1, as published by the Free Software Foundation.
#
#     This library is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#     Lesser General Public License for more details.
#
#     You should have received a copy of the GNU Lesser General Public
#     License along with this library; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#     MA  02111-1307  USA
#
#*************************************************************************
PRJ=..
PRJNAME=instsetoo_native
TARGET=packimages

.INCLUDE:  settings.mk
# point to an existing directory as default that poses no threat
# to a "find" that looks for "*.png"
RSCCUSTOMIMG*=$(PRJ)$/util
.INCLUDE: target.mk

IMAGES := $(COMMONBIN)$/images.zip
# Custom sets, at 24x24 & 16x16 fall-back to industrial preferentially
CUSTOM_PREFERRED_FALLBACK=$(SOLARSRC)$/ooo_custom_images$/industrial
CUSTOM_IMAGES=$(foreach,i,$(CUSTOM_IMAGE_SETS) images_$i)

ALLTAR : $(IMAGES) $(CUSTOM_IMAGES)

$(RES)$/img$/commandimagelist.ilst .PHONY :
    +-$(MKDIR) $(RES)$/img
#+-$(RM) $@ $@.$(INPATH)
.IF "$(use_shell)"!="4nt"
	$(FIND) $(SOLARSRC)$/$(RSCDEFIMG)/res/commandimagelist -name "*.png" | sed "s#$(SOLARSRC)$/$(RSCDEFIMG)/res#%GLOBALRES%#" > $@.$(INPATH)
.ELSE			# "$(use_shell)"!="4nt"
	$(FIND) $(SOLARSRC)$/$(RSCDEFIMG)/res/commandimagelist -name "*.png" | sed "s/$(SOLARSRC:s/\/./).$(RSCDEFIMG)\/res/%%GLOBALRES%%/" > $@.$(INPATH)
.ENDIF			# "$(use_shell)"!="4nt"
	+$(PERL) $(SOLARENV)$/bin$/diffmv.pl $@.$(INPATH) $@

$(COMMONBIN)$/images.zip .PHONY: $(RES)$/img$/commandimagelist.ilst
    +$(PERL) $(SOLARENV)$/bin$/packimages.pl -g $(SOLARSRC)$/$(RSCDEFIMG) -m $(SOLARSRC)$/$(RSCDEFIMG) -c $(RSCCUSTOMIMG) -l $(SOLARCOMMONRESDIR)$/img -l $(RES)$/img -o $@

images_% : 
    +$(PERL) $(SOLARENV)$/bin$/packimages.pl -g $(SOLARSRC)$/$(RSCDEFIMG) -m $(SOLARSRC)$/$(RSCDEFIMG) -c $(RSCCUSTOMIMG) -c $(SOLARSRC)$/ooo_custom_images/$(@:s/images_//) -c $(CUSTOM_PREFERRED_FALLBACK) -l $(SOLARCOMMONRESDIR)$/img -l $(RES)$/img -o $(COMMONBIN)$/$@.zip
