/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: propbrowserui.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 20:22:54 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef EXTENSIONS_SOURCE_PROPCTRLR_PROPBROWSERUI_HXX
#define EXTENSIONS_SOURCE_PROPCTRLR_PROPBROWSERUI_HXX

/** === begin UNO includes === **/
/** === end UNO includes === **/

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

//........................................................................
namespace pcr
{
//........................................................................

	//====================================================================
	//= EPropertyCategory
	//====================================================================
    enum EPropertyCategory
    {
        eGeneral,
        eData,
        eEvents
    };

	//====================================================================
	//= IPropertyBrowserUI
	//====================================================================
    /** a callback for <type>IPropertyHandler</type>
    */
    class IPropertyBrowserUI
    {
    public:
        /// enables or disables all components belonging to the UI representation of a property
        virtual void    enablePropertyUI( const ::rtl::OUString& _rPropertyName, bool _bEnable ) = 0;

        /** enables or disables the up to two buttons which can be part of the UI representation of a property

            Note that the complete UI for the property must be enabled in order for these settings to
            be evaluated. That is, enablePropertyButtons does not have any effect until you enabled
            the UI for this property with enablePropertyUI.
        */
        virtual void    enablePropertyButtons( const ::rtl::OUString& _rPropertyName, bool _bEnablePrimary, bool _bEnableSecondary ) = 0;

        /// rebuilds the UI for the given property.
        virtual void    rebuildPropertyUI( const ::rtl::OUString& _rPropertyName ) = 0;

        /// shows the ui for a given property
        virtual void    showPropertyUI( const ::rtl::OUString& _rPropertyName, bool _bRefreshIfExistent ) = 0;

        /// hides the ui for a given property
        virtual void    hidePropertyUI( const ::rtl::OUString& _rPropertyName ) = 0;

        /// shows or hides all properties belonging to a given category
        virtual void    showCategory( EPropertyCategory _eCategory, bool _bShow ) = 0;
    };

//........................................................................
} // namespace pcr
//........................................................................

#endif // EXTENSIONS_SOURCE_PROPCTRLR_PROPBROWSERUI_HXX

