/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dx_impltools.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 23:28:42 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _DXCANVAS_IMPLTOOLS_HXX
#define _DXCANVAS_IMPLTOOLS_HXX

#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif

#ifndef BOOST_SHARED_PTR_HPP_INCLUDED
#include <boost/shared_ptr.hpp>
#endif

#include <dx_canvasfont.hxx>
#include <dx_winstuff.hxx>


namespace basegfx
{
    class B2DHomMatrix;
    class B2IRange;
	class B2DPolyPolygon;
};

namespace com { namespace sun { namespace star { namespace geometry
{
    struct IntegerRectangle2D;
    struct RealPoint2D;
} } } }

namespace com { namespace sun { namespace star { namespace rendering 
{
    class  XCanvas;
    class  XGraphicDevice;
    class  XBitmap;
    class  XPolyPolygon2D;
    class  XCanvasFont;
} } } }


namespace dxcanvas
{
    namespace tools
    {
        ::basegfx::B2DPolyPolygon
        polyPolygonFromXPolyPolygon2D( const ::com::sun::star::uno::Reference< 
                                       ::com::sun::star::rendering::XPolyPolygon2D >& );

        void setupGraphics( Gdiplus::Graphics& rGraphics );

        void gdiPlusMatrixFromB2DHomMatrix( Gdiplus::Matrix& 				rGdiplusMatrix, 
                                            const ::basegfx::B2DHomMatrix&	rMatrix );
        void gdiPlusMatrixFromAffineMatrix2D( Gdiplus::Matrix& 											rGdiplusMatrix, 
                                              const ::com::sun::star::geometry::AffineMatrix2D& rMatrix );

        Gdiplus::PointF gdiPlusPointFromRealPoint2D( const ::com::sun::star::geometry::RealPoint2D& );
        Gdiplus::Rect 	gdiPlusRectFromIntegerRectangle2D( const ::com::sun::star::geometry::IntegerRectangle2D& );
        RECT 			gdiRectFromB2IRect( const ::basegfx::B2IRange& );

        ::com::sun::star::uno::Sequence< double > argbToDoubleSequence( 
            const ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XGraphicDevice >& 	xDevice,
            const Gdiplus::ARGB&																			rColor		 );
        ::com::sun::star::uno::Sequence< sal_Int8 > argbToIntSequence( 
            const ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XGraphicDevice >& 	xDevice,
            const Gdiplus::ARGB&																			rColor		 );
        Gdiplus::ARGB sequenceToArgb( const ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XGraphicDevice >& xDevice,
                                      const ::com::sun::star::uno::Sequence< sal_Int8 >&											 rColor	 );
        Gdiplus::ARGB sequenceToArgb( const ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XGraphicDevice >& xDevice,
                                      const ::com::sun::star::uno::Sequence< double >&												 rColor	 );

        GraphicsPathSharedPtr graphicsPathFromRealPoint2DSequence( const ::com::sun::star::uno::Sequence< 
                                                                 ::com::sun::star::uno::Sequence< ::com::sun::star::geometry::RealPoint2D > >& );

        GraphicsPathSharedPtr graphicsPathFromXPolyPolygon2D( const ::com::sun::star::uno::Reference< 
                                                              ::com::sun::star::rendering::XPolyPolygon2D >& );

        BitmapSharedPtr bitmapFromXBitmap( const ::com::sun::star::uno::Reference< 
                                           ::com::sun::star::rendering::XBitmap >& );

        CanvasFont::ImplRef	canvasFontFromXFont( const ::com::sun::star::uno::Reference< 
                                                 	::com::sun::star::rendering::XCanvasFont >& xFont );

        void setModulateImageAttributes( Gdiplus::ImageAttributes& o_rAttr,
                                         double					   nRedModulation,
                                         double					   nGreenModulation,
                                         double					   nBlueModulation,
                                         double					   nAlphaModulation );
    }
}

#endif /* _DXCANVAS_IMPLTOOLS_HXX */
