/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dx_canvashelper.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 23:26:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _DXCANVAS_CANVASHELPER_HXX_
#define _DXCANVAS_CANVASHELPER_HXX_

#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif

#ifndef _COM_SUN_STAR_RENDERING_XCANVAS_HPP_
#include <com/sun/star/rendering/XCanvas.hpp>
#endif
#ifndef _COM_SUN_STAR_RENDERING_XINTEGERBITMAP_HPP_
#include <com/sun/star/rendering/XIntegerBitmap.hpp>
#endif

#ifndef _BGFX_VECTOR_B2ISIZE_HXX
#include <basegfx/vector/b2isize.hxx>
#endif
#ifndef _BGFX_VECTOR_B2DSIZE_HXX
#include <basegfx/vector/b2dsize.hxx>
#endif

#include <dx_gdiplususer.hxx>
#include <dx_windowgraphicdevice.hxx>
#include <dx_impltools.hxx>
#include <dx_surface.hxx>
#include <dx_winstuff.hxx>


namespace dxcanvas
{
    /** Helper class for basic canvas functionality. Also offers
        optional backbuffer painting, when providing it with a second
        HDC to render into.
     */
    class CanvasHelper
    {
    public:
        CanvasHelper();

        /// Release all references
        void disposing();

        /** Set the associated graphic device

        	@param rDevice
            Device this helper is to be used on.
         */
        void setGraphicDevice( const WindowGraphicDevice::ImplRef& rDevice );

        /** Set a bitmap as the render target

        	This is mutually exclusive to setSurface().
         */
        void setBitmap( const BitmapSharedPtr& rBitmap );
        
        /** Set a bitmap as the render target

        	This is mutually exclusive to setSurface().

            @param rBitmap
            Bitmap to render into

            @param rOutputOffset
            Output offset in pixel. Every draw operation is offset by
            the given amount, regardless of the effective
            transformation matrix.
         */
        void setBitmap( const BitmapSharedPtr& 		rBitmap,
                        const ::basegfx::B2ISize& 	rOutputOffset );

        /** Set a surface as the render target

        	This is mutually exclusive to setBitmap(). One of them
        	must be called to get any output at all from CanvasHelper.

            @param rSurface
            Render target

            @param rSize
            Output size in pixel
            
            @param rOutputOffset
            Output offset in pixel
         */
        void setSurface( const SurfaceSharedPtr& 	rSurface,
                         const ::basegfx::B2ISize& 	rSize,
                         const ::basegfx::B2ISize& 	rOutputOffset );


        // CanvasHelper functionality
        // ==========================

        // XCanvas (only providing, not implementing the
        // interface. Also note subtle method parameter differences)
        void SAL_CALL drawPoint( const ::com::sun::star::geometry::RealPoint2D& 	aPoint, 
                                 const ::com::sun::star::rendering::ViewState& 		viewState, 
                                 const ::com::sun::star::rendering::RenderState& 	renderState );
        void SAL_CALL drawLine( const ::com::sun::star::geometry::RealPoint2D& 	aStartPoint, 
                                const ::com::sun::star::geometry::RealPoint2D& 	aEndPoint, 
                                const ::com::sun::star::rendering::ViewState& 	viewState, 
                                const ::com::sun::star::rendering::RenderState& renderState	);
        void SAL_CALL drawBezier( const ::com::sun::star::geometry::RealBezierSegment2D&	aBezierSegment, 
                                  const ::com::sun::star::geometry::RealPoint2D& 			aEndPoint,
                                  const ::com::sun::star::rendering::ViewState& 			viewState, 
                                  const ::com::sun::star::rendering::RenderState& 			renderState );
        ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XCachedPrimitive > SAL_CALL 	
        	drawPolyPolygon( const ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XPolyPolygon2D >& xPolyPolygon, 
                             const ::com::sun::star::rendering::ViewState& 											viewState, 
                             const ::com::sun::star::rendering::RenderState& 										renderState );
        ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XCachedPrimitive > SAL_CALL 	
        	strokePolyPolygon( const ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XPolyPolygon2D >& 	xPolyPolygon, 
                               const ::com::sun::star::rendering::ViewState& 											viewState, 
                               const ::com::sun::star::rendering::RenderState& 											renderState, 
                               const ::com::sun::star::rendering::StrokeAttributes& 									strokeAttributes );
        ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XCachedPrimitive > SAL_CALL 	
        	strokeTexturedPolyPolygon( const ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XPolyPolygon2D >& 	xPolyPolygon, 
                                       const ::com::sun::star::rendering::ViewState& 											viewState, 
                                       const ::com::sun::star::rendering::RenderState& 											renderState, 
                                       const ::com::sun::star::uno::Sequence< ::com::sun::star::rendering::Texture >& 			textures, 
                                       const ::com::sun::star::rendering::StrokeAttributes& 									strokeAttributes );
        ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XCachedPrimitive > SAL_CALL 	
        	strokeTextureMappedPolyPolygon( const ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XPolyPolygon2D >& 	xPolyPolygon, 
                                            const ::com::sun::star::rendering::ViewState& 											viewState, 
                                            const ::com::sun::star::rendering::RenderState& 										renderState, 
                                            const ::com::sun::star::uno::Sequence< ::com::sun::star::rendering::Texture >& 			textures, 
                                            const ::com::sun::star::uno::Reference< ::com::sun::star::geometry::XMapping2D >& 		xMapping, 
                                            const ::com::sun::star::rendering::StrokeAttributes& 									strokeAttributes );
        ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XPolyPolygon2D >   SAL_CALL 	
        	queryStrokeShapes( const ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XPolyPolygon2D >& 	xPolyPolygon, 
                               const ::com::sun::star::rendering::ViewState& 											viewState, 
                               const ::com::sun::star::rendering::RenderState& 											renderState, 
                               const ::com::sun::star::rendering::StrokeAttributes& 									strokeAttributes );
        ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XCachedPrimitive > SAL_CALL 	
        	fillPolyPolygon( const ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XPolyPolygon2D >& xPolyPolygon, 
                             const ::com::sun::star::rendering::ViewState& 											viewState, 
                             const ::com::sun::star::rendering::RenderState& 										renderState );
        ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XCachedPrimitive > SAL_CALL 	
        	fillTexturedPolyPolygon( const ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XPolyPolygon2D >& xPolyPolygon, 
                                     const ::com::sun::star::rendering::ViewState& 											viewState, 
                                     const ::com::sun::star::rendering::RenderState& 										renderState, 
                                     const ::com::sun::star::uno::Sequence< ::com::sun::star::rendering::Texture >& 		textures );
        ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XCachedPrimitive > SAL_CALL 	
        	fillTextureMappedPolyPolygon( const ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XPolyPolygon2D >& 	xPolyPolygon, 
                                          const ::com::sun::star::rendering::ViewState& 											viewState, 
                                          const ::com::sun::star::rendering::RenderState& 											renderState, 
                                          const ::com::sun::star::uno::Sequence< ::com::sun::star::rendering::Texture >& 			textures, 
                                          const ::com::sun::star::uno::Reference< ::com::sun::star::geometry::XMapping2D >& 		xMapping );

        ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XCanvasFont > SAL_CALL
        	createFont( const ::com::sun::star::rendering::FontRequest& 								fontRequest, 
                        const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& 		extraFontProperties, 
                        const ::com::sun::star::geometry::Matrix2D& 									fontMatrix );

        ::com::sun::star::uno::Sequence< ::com::sun::star::rendering::FontInfo > SAL_CALL 
        	queryAvailableFonts( const ::com::sun::star::rendering::FontInfo& 								aFilter, 
                                 const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& 	aFontProperties );

        ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XCachedPrimitive > SAL_CALL 
        	drawText( const ::com::sun::star::rendering::StringContext& 									text, 
                      const ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XCanvasFont >& 	xFont, 
                      const ::com::sun::star::rendering::ViewState& 										viewState, 
                      const ::com::sun::star::rendering::RenderState& 										renderState, 
                      sal_Int8 																						textDirection );

        ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XCachedPrimitive > SAL_CALL 
        	drawTextLayout( const ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XTextLayout >& layoutetText, 
                            const ::com::sun::star::rendering::ViewState& 										viewState, 
                            const ::com::sun::star::rendering::RenderState& 									renderState );

        ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XCachedPrimitive > SAL_CALL 	
        	drawBitmap( const ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XBitmap >& xBitmap, 
                        const ::com::sun::star::rendering::ViewState& 									viewState, 
                        const ::com::sun::star::rendering::RenderState& 								renderState );
        ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XCachedPrimitive > SAL_CALL 	
        	drawBitmapModulated( const ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XBitmap >&	xBitmap, 
                                 const ::com::sun::star::rendering::ViewState& 										viewState, 
                                 const ::com::sun::star::rendering::RenderState& 									renderState );
        ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XGraphicDevice > SAL_CALL 
        	getDevice();

        // BitmapCanvasHelper functionality
        // ================================

        void SAL_CALL copyRect( const ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XBitmapCanvas >& 	sourceCanvas, 
                                const ::com::sun::star::geometry::RealRectangle2D& 										sourceRect, 
                                const ::com::sun::star::rendering::ViewState& 											sourceViewState, 
                                const ::com::sun::star::rendering::RenderState& 										sourceRenderState, 
                                const ::com::sun::star::geometry::RealRectangle2D& 										destRect, 
                                const ::com::sun::star::rendering::ViewState& 											destViewState, 
                                const ::com::sun::star::rendering::RenderState& 										destRenderState );
            
        ::com::sun::star::geometry::IntegerSize2D SAL_CALL getSize();

        ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XBitmap > SAL_CALL 
        	getScaledBitmap( const ::com::sun::star::geometry::RealSize2D& 	newSize, 
                             sal_Bool 												beFast );

        ::com::sun::star::uno::Sequence< sal_Int8 > SAL_CALL 
	        getData( const ::com::sun::star::geometry::IntegerRectangle2D& rect );

        void SAL_CALL setData( const ::com::sun::star::uno::Sequence< sal_Int8 >& 				data, 
                               const ::com::sun::star::geometry::IntegerRectangle2D& 	rect );

        void SAL_CALL setPixel( const ::com::sun::star::uno::Sequence< sal_Int8 >& 			color, 
                                const ::com::sun::star::geometry::IntegerPoint2D& 	pos );

        ::com::sun::star::uno::Sequence< sal_Int8 > SAL_CALL 
	        getPixel( const ::com::sun::star::geometry::IntegerPoint2D& pos );

        ::com::sun::star::uno::Reference< ::com::sun::star::rendering::XBitmapPalette > SAL_CALL getPalette();

        ::com::sun::star::rendering::IntegerBitmapLayout SAL_CALL getMemoryLayout();
        
        // Flush drawing queue to screen
        void					flush() const;

        /** Access surface externally.

        	@attention if you change content, make sure mbSurfaceDirty
        	is correctly updated.
         */
        SurfaceSharedPtr		getSurface() const;
        
    private:
        // default: disabled copy/assignment
        CanvasHelper(const CanvasHelper&);
        CanvasHelper& operator=( const CanvasHelper& );
        
        // returns transparency of color
        void setupGraphicsState( SurfaceGraphicsSharedPtr&									rGraphics,
                                 const ::com::sun::star::rendering::ViewState& 		viewState, 
                                 const ::com::sun::star::rendering::RenderState& 	renderState );
        
        Gdiplus::CompositingMode 	calcCompositingMode( sal_Int8 nMode );

        bool needOutput() const;

        GDIPlusUserSharedPtr			mpGdiPlusUser;

        /// Phyical output device
        WindowGraphicDevice::ImplRef	mxDevice;

        /// Render target
        SurfaceSharedPtr				mpSurface;
        /// Optional bitmap (mpSurface renders to mpBitmap, then)
        BitmapSharedPtr					mpBitmap;

        /// Creation-time size
        ::basegfx::B2ISize				maSize;

        /// Creation-time output offset (used for sprites)
        ::basegfx::B2ISize				maOutputOffset;
    };
}

#endif /* _DXCANVAS_CANVASHELPER_HXX_ */
