/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: Configuration.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:45:09 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package com.sun.xmlsearch.util;

import java.io.File;
import java.io.ByteArrayInputStream;
import java.util.Vector;
import java.net.URL;
import org.w3c.dom.*;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.parser.Resolver;
import org.xml.sax.InputSource;

public final class Configuration {
    public static Element configElementFromArgs(String[] args) throws Exception {
	URL configURL = null;
	for (int i = 0; i < args.length ; i++)
	    if (args[i].equals("-configFile") || args[i].equals("-cf")) {
		File config = new File(args[++i]);
		if (config.exists())
		    configURL = config.toURL();
		else
		    throw new Exception("config file doesn't exist");
	    }
	    else if (args[i].equals("-configURL") || args[i].equals("-cu"))
		configURL = new URL(args[++i]);
      
	if (configURL == null) {
	    System.err.println("No configuration specified!");
	    System.err.println("use: -configFile file | -configURL url");
	    return null;
	}
	else
	    return parse(configURL);
    }

    public static Element parse(URL location) throws Exception {
	InputSource input = Resolver.createInputSource(location, true);
	XmlDocument document = XmlDocument.createXmlDocument(input, false);
	return document.getDocumentElement();
    }

    public static Element parse(byte[] xmlBytes) throws Exception {
	ByteArrayInputStream input = new ByteArrayInputStream(xmlBytes);
	XmlDocument document = XmlDocument.createXmlDocument(input, false);
	return document.getDocumentElement();
    }

    /** arg: Element that can be direct parent of PrefixTranslation-s
	either in indexing or search engine configurations
    */
    public static String[] processPrefixTranslations(Element el) {
	NodeList list = el.getElementsByTagName("PrefixTranslation");
	if (list.getLength() > 0) {
	    Vector translations = new Vector();
	    for (int i = 0; i < list.getLength(); i++) {
		final Element ptEl = (Element)list.item(i);
		translations.addElement(ptEl.getAttribute("prefix"));
		translations.addElement(ptEl.getAttribute("replacement"));
	    }
	    String[] prefixTranslations = new String[translations.size()];
	    return (String[])translations.toArray(prefixTranslations);
	}
	else
	return null;
    }
}
