/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: accframebase.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 08:03:15 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _ACCFRAMEBASE_HXX
#define _ACCFRAMEBASE_HXX

#ifndef _ACCCONTEXT_HXX
#include "acccontext.hxx"
#endif

#ifndef _COM_SUN_STAR_UNO_RUNTIMEEXCEPTION_HPP_
#include <com/sun/star/uno/RuntimeException.hpp>
#endif
namespace binfilter {

class SwFlyFrm;
class SwNoTxtNode;

class SwAccessibleFrameBase : public SwAccessibleContext, public SwClient
{
	sal_Bool	bIsSelected;	// protected by base class mutex

	sal_Bool	IsSelected();

protected:

	// Set states for getAccessibleStateSet.
	// This drived class additionaly sets SELECTABLE(1), SELECTED(+),
	// FOCUSABLE(1) and FOCUSED(+)
	virtual void GetStates( ::utl::AccessibleStateSetHelper& rStateSet );

	virtual void _InvalidateCursorPos();
	virtual void _InvalidateFocus();

	virtual ~SwAccessibleFrameBase();

public:

	SwAccessibleFrameBase( SwAccessibleMap *pMap, sal_Int16 nRole,
						     const SwFlyFrm *pFlyFrm );

	virtual sal_Bool HasCursor();	// required by map to remember that object

	virtual void Modify( SfxPoolItem *pOld, SfxPoolItem *pNew);

	static sal_uInt8 GetNodeType( const SwFlyFrm *pFlyFrm );

	// The object is not visible an longer and should be destroyed
	virtual void Dispose( sal_Bool bRecursive = sal_False );
};


} //namespace binfilter
#endif
