/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_scfobj.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 18:09:41 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#include "filt_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

#include <svtools/moduleoptions.hxx>
#include <bf_svx/svdoole2.hxx>
#include <bf_svx/svdpage.hxx>
#include <bf_sfx2/objsh.hxx>
#include <so3/ipobj.hxx>
#include <so3/svstor.hxx>
#include <bf_sch/schdll.hxx>
#include <bf_sch/schdll0.hxx>
#include <bf_sch/memchrt.hxx>
#include <bf_sfx2/app.hxx>

#include "scfobj.hxx"
#include "document.hxx"
#include "drwlayer.hxx"
#include "chartarr.hxx"
namespace binfilter {


// STATIC DATA -----------------------------------------------------------


//==================================================================

void Sc10InsertObject::InsertChart( ScDocument* pDoc, USHORT nDestTab, const Rectangle& rRect,
								USHORT nSrcTab, USHORT nX1, USHORT nY1, USHORT nX2, USHORT nY2 )
{
	//	wenn Chart nicht installiert ist, darf nicht auf SCH_MOD zugegriffen werden!
	if ( !SvtModuleOptions().IsChart() )
		return;

	SvStorageRef aStor = new SvStorage(String());
	SvInPlaceObjectRef aNewIPObj = &(( SvFactory *)
			SvInPlaceObject::ClassFactory()) ->CreateAndInit(
										*SCH_MOD()->pSchChartDocShellFactory, aStor );

	if ( aNewIPObj.Is() )
	{
		String aName = pDoc->GetDocumentShell()->InsertObject( aNewIPObj, String() )->GetObjName();
		SdrOle2Obj* pSdrOle2Obj = new SdrOle2Obj( aNewIPObj, aName, rRect );

		ScDrawLayer* pModel = pDoc->GetDrawLayer();
		if (!pModel)
		{
			pDoc->InitDrawLayer();
			pModel = pDoc->GetDrawLayer();
			DBG_ASSERT(pModel,"DrawLayer ?");
		}

		SdrPage* pPage = pModel->GetPage(nDestTab);
		DBG_ASSERT(pPage,"Page ?");
		pPage->InsertObject(pSdrOle2Obj);

		pSdrOle2Obj->SetLogicRect(rRect);				// erst nach InsertObject !!!
		aNewIPObj->SetVisAreaSize(rRect.GetSize());

			// hier kann das Chart noch nicht mit Daten gefuettert werden,
			// weil die Formeln noch nicht berechnet sind.
			// Deshalb in die ChartCollection, die Daten werden dann im
			// Sc10Import dtor geholt.

		ScChartCollection* pColl = pDoc->GetChartCollection();
		pColl->Insert( new ScChartArray( pDoc, nSrcTab, nX1, nY1, nX2, nY2, aName ) );
	}
}



}
