/* Openoffice.org-voikko: Finnish linguistic extension for OpenOffice.org
 * Copyright (C) 2007 - 2008 Harri Pitkänen <hatapitk@iki.fi>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ***************************************************************************/

#ifndef _COMMON_HXX_
#define _COMMON_HXX_

#include <osl/mutex.hxx>
#include "PropertyManager.hxx"

namespace voikko {

osl::Mutex & getVoikkoMutex();

OUString getInstallationPath(uno::Reference<uno::XComponentContext> & compContext);

/** Get property set for given group from registry */
uno::Reference<uno::XInterface> getRegistryProperties(const OUString & group,
	uno::Reference<uno::XComponentContext> compContext);

extern sal_Bool voikko_initialized;

extern int voikko_handle;

}

#endif
