/*************************************************************************
 *
 *  $RCSfile: salgdi.h,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:32 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_SALGDI_H
#define _SV_SALGDI_H

#ifndef _SV_SVMAC_H
#include <svmac.h>
#endif

#ifndef _SV_SV_H
#include <sv.h>
#endif

#define CHANGED_CLIP 0x01

enum DrawMode {
	DRAW_NONE,
	DRAW_LINE,
	DRAW_FILL,
	DRAW_TEXT,
	DRAW_BITS,
	DRAW_INVERT,
	DRAW_SETPORT,
	DRAW_ENDE
};

class BitmapPalette;

// -------------------
// - SalGraphicsData -
// -------------------

class SalGraphicsData
{							// Achtung ! Daten werden mit memset initialisiert
public:
    CGrafPtr				mpGrafPort;			// our Macintosh output-device
	GDHandle				mhDevice;			// fuer SetGWorld
    RgnHandle				mhClipRgn;			// Region Handle
    RgnHandle				mhGrowRgn;			// Region Handle

	PixPatHandle			mhDefBrush;			// Fill Brush
    MacColor                maPenColor;         // PenColor
    MacColor                maBrushColor;       // BrushColor
    MacColor                maTextColor;        // TextColor

    BOOL                    mbPrinter : 1;      // is Printer
    BOOL                    mbVirDev : 1;       // is VirDev
    BOOL                    mbWindow : 1;       // is Window
    BOOL                    mbScreen : 1;       // is Screen compatible
	BOOL					mbTransparentPen : 1;	// keine Rahmen malen
	BOOL					mbTransparentBrush : 1;	// nur die Rahmen malen

    USHORT					mnStatus;			// Was hat sich alles geaendert
	DrawMode				meLastDrawMode;		// 
    CharSet         	    meCharSet;          // CharSet vom log. Font
    INT16					mnWidth;			// Breite vom log. Font in Pixeln
    INT16					mnHeight;			// Hoehe vom log. Font in Pixeln
    short                   mnFontNum;          // Mac FontFamilyId
    short                   mnFontSize;         // Mac Font Size
	short					mnFontMode;			// Mac Font transfer mode
    Style                   mnFontFace;         // Mac Font Style
	short					mnPenMode;			// Transfer mode fuer Pen,...
	Fixed					mnXRes;				// Aufloesung in X-Richtung
	Fixed					mnYRes;				// Aufloesung in Y-Richtung
    
	                        SalGraphicsData();
                            ~SalGraphicsData();

	void			ReplaceFillBrush( PixPatHandle hPPat );
	BOOL			CombineClipRgn( RgnHandle hRegion );
	BOOL			CheckDrawMode( DrawMode eNewMode );
	PixMapHandle	GetPixmapHandle();
	void			ReleasePixmapHandle( PixMapHandle hPixmap );
	void			CreatePalette( BitmapPalette& rPalette, const PixMapHandle hPixmap );
};

// Init/Deinit Graphics
void ImplSalInitGraphics( SalGraphicsData* mpData );
void ImplSalDeInitGraphics( SalGraphicsData* mpData );

#endif // _SV_SALGDI_H
