/*************************************************************************
 *
 *  $RCSfile: bcst.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 17:03:43 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#define ENABLE_BYTESTRING_STREAM_OPERATORS
#include "defport.h"
#include "bcst.hxx"

struct NamedCategory
{
	char* aName;
	BroadcastCategory nCategory;
	char* aDescription;
};

// Die Namen der Categories
static NamedCategory __READONLY_DATA aNamedCategories[] =
{
	{ "ALL", BCST_CAT_ALL, "" },
	{ "MISC", BCST_CAT_MISC, "" },
	{ "PL2X", BCST_CAT_PL2X, "Version;Environment;Minor" },
	{ "MINORCOPY", BCST_CAT_MINORCOPY, "" },
	{ "DELIVER", BCST_CAT_DELIVER, "" },
	{ "CHAT", BCST_CAT_CHAT, "" },
	{ "BSTRIGGER", BCST_CAT_BSTRIGGER, "Version;Environment;Project" },
	{ "BSCHAT", BCST_CAT_BSCHAT, "" },
	{ "SOURCEACCEPTANCE", BCST_CAT_SOURCEACCEPTANCE, "" },
	{ "ZIPSTATUS", BCST_CAT_ZIPSTATUS, "" },
	{ "ZIPCONFIG", BCST_CAT_ZIPCONFIG, "" },
	{ "ZIPPRJ", BCST_CAT_ZIPPRJ, "" },
	{ "BSBUILD", BCST_CAT_BSBUILD, "Version;Environment;Project;Mode" },
	{ "BUILDMINOR", BCST_CAT_BUILDMINOR, "Version;Minor" },
	{ "PREMINOR", BCST_CAT_PREMINOR, "Version;Minor" },
	{ "", BCST_CAT_INVALID, "" }
};

ByteString GetBroadcastHost()
{
	ByteString aIServer;
	if ( getenv( "ISERVER" ))
		aIServer = ByteString(getenv("ISERVER"));
	if(!aIServer.Len())
		return CByteString( ISERVER );
	return aIServer;
}

ULONG GetBroadcastPort()
{
	return BROADCAST_DEFAULT_PORT;
}

InformationBroadcaster::InformationBroadcaster( CommunicationManager *pManager )
: aThisClientID( BCST_CLIENT_UNKNOWN )
{
	if ( pManager )
	{
		mpManager = pManager;
	}
	else
	{
		mpManager = new SingleCommunicationManagerClientViaSocket( TRUE );
	}

//	mpManager->SetConnectionOpenedHdl( LINK( this, InformationBroadcaster, ManagerOpen ) );
	mpManager->SetConnectionClosedHdl( LINK( this, InformationBroadcaster, ManagerClose ) );
	mpManager->SetDataReceivedHdl( LINK( this, InformationBroadcaster, ManagerData ) );

	DBG_ASSERT( mpManager->IsMultiChannel(), "Manager ist nicht MultiChannel!!!" );
}

InformationBroadcaster::~InformationBroadcaster()
{
	ULONG i;
	for ( i = 0; i < aMessageArrivedLnkList.Count(); i++ ) {
		delete aMessageArrivedLnkList.GetObject( i );
		aMessageArrivedLnkList.Remove( i );
	}
	for ( i = 0; i < aConnectionTerminatedLnkList.Count(); i++ ) {
		delete aConnectionTerminatedLnkList.GetObject( i );
		aConnectionTerminatedLnkList.Remove( i );
	}
	mpManager->StopCommunication();
	delete mpManager;
}

BOOL InformationBroadcaster::StartCommunicationIfNecessary()
{
	if ( !mpManager->IsCommunicationRunning() || !mpManager->GetLastNewLink() )
	{
		ByteString aHost( GetBroadcastHost()); 
		ULONG nPort = GetBroadcastPort();
		return mpManager->StartCommunication( aHost, nPort );
	}
	return TRUE;
}


IMPL_LINK( InformationBroadcaster, ManagerClose, CommunicationLink*, pCL )
{
	ConnectionTerminated();
	return 0;
}

void InformationBroadcaster::ConnectionTerminated()
{
	for ( ULONG i = 0; i < aConnectionTerminatedLnkList.Count(); i++ )
		aConnectionTerminatedLnkList.GetObject( i )->Call( NULL );
}


BroadcastCategory InformationBroadcaster::Name2Id( const ByteString &aType )
{
	if ( aType.IsNumericAscii() )
		return (BroadcastCategory)(aType.ToInt32());

	USHORT i = 0;
	while ( aNamedCategories[i].nCategory != BCST_CAT_INVALID &&
		aType.CompareIgnoreCaseToAscii( aNamedCategories[i].aName ) != COMPARE_EQUAL )
		i++;

	return aNamedCategories[i].nCategory;
}


ByteString InformationBroadcaster::Id2Name( BroadcastCategory aType )
{
	USHORT i = 0;
	while ( aNamedCategories[i].nCategory != BCST_CAT_INVALID &&
		aNamedCategories[i].nCategory != aType )
		i++;

	if ( aNamedCategories[i].nCategory != BCST_CAT_INVALID )
		return aNamedCategories[i].aName;
	else
		return ByteString::CreateFromInt32( aType );
}

ByteString InformationBroadcaster::Description( BroadcastCategory aType )
{
	USHORT i = 0;
	while ( aNamedCategories[i].nCategory != BCST_CAT_INVALID &&
		aNamedCategories[i].nCategory != aType )
		i++;

	if ( aNamedCategories[i].nCategory != BCST_CAT_INVALID )
		return aNamedCategories[i].aDescription;
	else
		return ByteString();
}


/// Client Functions

IMPL_LINK( InformationBroadcaster, ManagerData, CommunicationLink*, pCL )
{
	DBG_ASSERT( pCL->GetProtocol() == CM_PROTOCOL_BROADCASTER, "Protocol is not CM_PROTOCOL_BROADCASTER" )

	BroadcastCommand aCmd;
	SvStream *pData = pCL->GetServiceData();
	*pData >> aCmd;
	switch ( aCmd )
	{
		case BCST_CMD_BROADCAST:
			{
				BroadcastCategory nType;
				ClientID aClientID;
				*pData >> nType;
				ByteString aMsg;
				*pData >> aMsg;
				if ( !pData->IsEof() )	// Wegen nachtrglicher Erweiterung der Message
					*pData >> aClientID;
				else
					aClientID = BCST_CLIENT_UNKNOWN;
				BroadcastMessage aBCMsg( aMsg, nType, aClientID );
				IMessageArrived( aBCMsg );	// Die ist fr Wissende ONLY!
				MessageArrived( aBCMsg );		// Die ist fr den Pbel zum berladen und Links setzen
			}
			break;
		case BCST_CMD_CLIENT_ID:
			{
				*pData >> aThisClientID;
			}
			break;
	}
	return 0;
}

BOOL InformationBroadcaster::AddCategory( const ByteString &aType )
{
	BroadcastCategory nType = Name2Id( aType );
	if ( BCST_CAT_INVALID != nType )
		return AddCategory( nType );
	else
		return FALSE;
}

BOOL InformationBroadcaster::AddCategory( BroadcastCategory nType )
{
	if ( !StartCommunicationIfNecessary() )
		return FALSE;
	CommunicationLinkRef xCL = mpManager->GetLastNewLink();
	DBG_ASSERT( xCL, "Kein CommunicationLink vorhanden" );
	if ( xCL.Is() )
	{
		SvStream *pData = xCL->GetBestCommunicationStream();

		*pData << BCST_CMD_ADD_CATEGORY;
		*pData << nType;

		BOOL bOK = xCL->TransferDataStream( pData, CM_PROTOCOL_BROADCASTER );
		delete pData;
		return bOK;
	}
	else
		return FALSE;
}

BOOL InformationBroadcaster::RemoveCategory( const ByteString &aType )
{
	BroadcastCategory nType = Name2Id( aType );
	if ( BCST_CAT_INVALID != nType )
		return RemoveCategory( nType );
	else
		return FALSE;
}

BOOL InformationBroadcaster::RemoveCategory( BroadcastCategory nType )
{
	if ( !StartCommunicationIfNecessary() )
		return FALSE;
	CommunicationLinkRef xCL = mpManager->GetLastNewLink();
	DBG_ASSERT( xCL, "Kein CommunicationLink vorhanden" );
	if ( xCL )
	{
		SvStream *pData = xCL->GetBestCommunicationStream();

		*pData << BCST_CMD_REMOVE_CATEGORY;
		*pData << nType;

		BOOL bOK = xCL->TransferDataStream( pData, CM_PROTOCOL_BROADCASTER );
		delete pData;
		return bOK;
	}
	else
		return FALSE;
}

void InformationBroadcaster::IMessageArrived( const BroadcastMessage &aMsg )
{
}

void InformationBroadcaster::MessageArrived( const BroadcastMessage &aMsg )
{
	for ( ULONG i = 0; i < aMessageArrivedLnkList.Count(); i++ )
		aMessageArrivedLnkList.GetObject( i )->Call( (void*)&aMsg );
}

BOOL InformationBroadcaster::WaitForData()
{
	if ( mpManager->IsCommunicationRunning() && mpManager->GetLastNewLink() )
	{
		return mpManager->GetLastNewLink()->ReceiveDataStream();
	}
	else
		return FALSE;
}


/// Sender Functions

BOOL InformationBroadcaster::Broadcast( const ByteString &aType, const ByteString &aMsg, BroadcastFilterFlag nFlags )
{
	BroadcastCategory nType = Name2Id( aType );
	if ( BCST_CAT_INVALID != nType )
		return Broadcast( nType, aMsg, nFlags );
	else
		return FALSE;
}

BOOL InformationBroadcaster::Broadcast( BroadcastCategory nType, const ByteString &aMsg, BroadcastFilterFlag nFlags )
{
	if ( !StartCommunicationIfNecessary() )
		return FALSE;
	CommunicationLinkRef xCL = mpManager->GetLastNewLink();
	DBG_ASSERT( xCL, "Kein CommunicationLink vorhanden" );
	if ( xCL )
	{
		SvStream *pData = xCL->GetBestCommunicationStream();

		*pData << BCST_CMD_BROADCAST;
		*pData << nType;
		*pData << aMsg;
		*pData << nFlags;

		BOOL bOK = xCL->TransferDataStream( pData, CM_PROTOCOL_BROADCASTER );
		delete pData;

		if ( bOK )
		{	// Insert to local database
			BroadcastMessage aBCMsg( aMsg, nType, GetClientID() );
			IMessageArrived( aBCMsg );
		}
		return bOK;
	}
	else
		return FALSE;
}

void InformationBroadcaster::RemoveMessageArrivedHdl( Link aLink )
{
	for ( ULONG i = 0; i < aMessageArrivedLnkList.Count(); i++ )
		if ( *aMessageArrivedLnkList.GetObject( i ) == aLink ) {
			delete aMessageArrivedLnkList.GetObject( i );
			aMessageArrivedLnkList.Remove( i );
			return;
		}
}

void InformationBroadcaster::RemoveConnectionTerminatedHdl( Link aLink )
{
	for ( ULONG i = 0; i < aConnectionTerminatedLnkList.Count(); i++ )
		if ( *aConnectionTerminatedLnkList.GetObject( i ) == aLink ) {
			delete aConnectionTerminatedLnkList.GetObject( i );
			aConnectionTerminatedLnkList.Remove( i );
			return;
		}
}
