/*************************************************************************
 *
 *  $RCSfile: appdef.hxx,v $
 *
 *  $Revision: 1.13 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 17:02:55 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _MHAPPDEF_HXX
#define _MHAPPDEF_HXX


#ifdef UNX
#define DEFAULT_INI_ROOT	"/develop6/update/dev" 
#define PATH_SEPARATOR		'/'
#define S_PATH_SEPARATOR 	"/"
#else
#ifdef MAC
#define DEFAULT_INI_ROOT 	"dev4.data1:s"
#define PATH_SEPARATOR		':'
#define S_PATH_SEPARATOR 	":"
#else
#define DEFAULT_INI_ROOT 	"r:"
#define PATH_SEPARATOR		'\\'
#define S_PATH_SEPARATOR	"\\"
#endif
#endif

#define _INI_DRV				DEFAULT_INI_ROOT
#define DEFAULT_INI_FILE 		DEFAULT_INI_ROOT S_PATH_SEPARATOR "b_server" S_PATH_SEPARATOR "config" S_PATH_SEPARATOR "b_server.ini"
#define B_SERVER_ROOT			DEFAULT_INI_ROOT S_PATH_SEPARATOR "b_server"
#define BINARYROOT				DEFAULT_INI_ROOT S_PATH_SEPARATOR "b_server" S_PATH_SEPARATOR "bin"
#define _JOB_DIR 				DEFAULT_INI_ROOT S_PATH_SEPARATOR "b_server" S_PATH_SEPARATOR "server" S_PATH_SEPARATOR "db"
#define _INJOB_DIR 				DEFAULT_INI_ROOT S_PATH_SEPARATOR "b_server" S_PATH_SEPARATOR "server" S_PATH_SEPARATOR "dbin"
#define _OUTJOB_DIR 			DEFAULT_INI_ROOT S_PATH_SEPARATOR "b_server" S_PATH_SEPARATOR "server" S_PATH_SEPARATOR "dbout"
#define _ERRJOB_DIR				DEFAULT_INI_ROOT S_PATH_SEPARATOR "b_server" S_PATH_SEPARATOR "server" S_PATH_SEPARATOR "dberr"
#define _BUILDPATTERN_DIR 		DEFAULT_INI_ROOT S_PATH_SEPARATOR "b_server" S_PATH_SEPARATOR "pattern"
#define _COMMENT_DIR   			DEFAULT_INI_ROOT S_PATH_SEPARATOR "b_server" S_PATH_SEPARATOR "comment"
#define _SOLARLIST				DEFAULT_INI_ROOT S_PATH_SEPARATOR "b_server" S_PATH_SEPARATOR "config" S_PATH_SEPARATOR "solar.lst"
#define _DEF_STAND_LIST 		DEFAULT_INI_ROOT S_PATH_SEPARATOR "b_server" S_PATH_SEPARATOR "config" S_PATH_SEPARATOR "stand.lst"
#define _DEF_DEFAULT_LIST 		DEFAULT_INI_ROOT S_PATH_SEPARATOR "b_server" S_PATH_SEPARATOR "config" S_PATH_SEPARATOR "default.lst"
#define _DEF_SSOLARINI	 		DEFAULT_INI_ROOT S_PATH_SEPARATOR "b_server" S_PATH_SEPARATOR "config" S_PATH_SEPARATOR "ssolar.ini"
#define _DEF_SSCOMMON			DEFAULT_INI_ROOT S_PATH_SEPARATOR "b_server" S_PATH_SEPARATOR "config" S_PATH_SEPARATOR "ssolar.cmn"
#define _SERVER_IDENT_FLAG 		DEFAULT_INI_ROOT S_PATH_SEPARATOR "b_server" S_PATH_SEPARATOR "config" S_PATH_SEPARATOR "server.id"
#define _CUSTOMJOBINI	 		DEFAULT_INI_ROOT S_PATH_SEPARATOR "b_server" S_PATH_SEPARATOR "config" S_PATH_SEPARATOR "custom.ini"
#define _DATABASEINI	 		DEFAULT_INI_ROOT S_PATH_SEPARATOR "b_server" S_PATH_SEPARATOR "config" S_PATH_SEPARATOR "database.ini"
#define _ZNINI			 		DEFAULT_INI_ROOT S_PATH_SEPARATOR "b_server" S_PATH_SEPARATOR "config" S_PATH_SEPARATOR "bszn.ini"
#define _ERRORINFOFILE			DEFAULT_INI_ROOT S_PATH_SEPARATOR "b_server" S_PATH_SEPARATOR "config" S_PATH_SEPARATOR "errinf.lst"
#define _REGEXPINFOFILE			DEFAULT_INI_ROOT S_PATH_SEPARATOR "b_server" S_PATH_SEPARATOR "config" S_PATH_SEPARATOR "regexp.lst"
#define _POSITIVERRORINFOFILE	DEFAULT_INI_ROOT S_PATH_SEPARATOR "b_server" S_PATH_SEPARATOR "config" S_PATH_SEPARATOR "perrinf.lst"
#define _POSITIVREGEXPINFOFILE	DEFAULT_INI_ROOT S_PATH_SEPARATOR "b_server" S_PATH_SEPARATOR "config" S_PATH_SEPARATOR "pregexp.lst"
#define	_INIROOT				DEFAULT_INI_ROOT S_PATH_SEPARATOR "b_server" S_PATH_SEPARATOR "config"
#define	_INIROOT_OLD			DEFAULT_INI_ROOT S_PATH_SEPARATOR "b_server" S_PATH_SEPARATOR "config"
#define	_ENV_DIR				DEFAULT_INI_ROOT S_PATH_SEPARATOR "b_server" S_PATH_SEPARATOR "config"
#define ISERVER_DEF_STAND_LIST 	DEFAULT_INI_ROOT S_PATH_SEPARATOR "b_server" S_PATH_SEPARATOR "config" S_PATH_SEPARATOR "stand.lst"
#define ISERVER_DEF_DEPEND_LIST	DEFAULT_INI_ROOT S_PATH_SEPARATOR "b_server" S_PATH_SEPARATOR "config" S_PATH_SEPARATOR "depend.lst"
#define _REDIRECTIONPATH		DEFAULT_INI_ROOT S_PATH_SEPARATOR "b_server" S_PATH_SEPARATOR "redir"
#define _ZLOGSPATH				DEFAULT_INI_ROOT S_PATH_SEPARATOR "b_server" S_PATH_SEPARATOR "zlogs"
#define DEFAULT_PROTPATH		DEFAULT_INI_ROOT S_PATH_SEPARATOR "b_server" S_PATH_SEPARATOR "filesize"
#define _INI_UNC				"\\\\grande-11050.germany.sun.com\\R-Laufwerk"
#define _INI_UNC_OLD	    	"\\\\grande-11050.germany.sun.com\\R-Laufwerk\\s"

#define _REDIRECTIONSIZE		"10000"
#define _EISPATH				"W:\\EIS"

#define _WRITE_LOGFILES 		"1"
#define _WRITE_JOBFILES 		"1"

#define _VERSION_WINDOW			"0"
#define _JOB_WINDOW 			"0"
#define _APPWIN_MAXIMIZED		"0"
#define _CONTEXT_TBOX			"0"

#define _COLOR_DROPED			COL_GRAY
#define _COLOR_WAIT				COL_BLUE
#define _COLOR_BUILD			COL_GREEN
#define _COLOR_ERROR			COL_RED
#define _COLOR_BUILDERROR		COL_MAGENTA
#define _COLOR_OK				COL_BLACK
#define _COLOR_DELIVERED		COL_CYAN

#define _ASYNCHRON				"1"

// folowing defines are used to write filesize information for binaries
#define OH_GOTT "*"
#define UNX_DEFAULT_FILESIZES		"bin/" OH_GOTT ".bin;bin/" OH_GOTT ".res;bin/" OH_GOTT ".tlb;lib/" OH_GOTT ".so"
#define DOS_DEFAULT_FILESIZES		"bin\\*.exe;bin\\*.res;bin\\*.dll;bin\\*.tlb"

#ifdef UNX
#define DEFAULT_FILESIZES UNX_DEFAULT_FILESIZES
#else	
#define DEFAULT_FILESIZES DOS_DEFAULT_FILESIZES
#endif

/** States for BuildServer projects and directories
*/
enum BuildStatus {
	BS_DROPED, 					/// project is waiting for dispatching
	BS_BUILD,                   /// project/directory is building
	BS_WAIT,                    /// project/directory is waiting for building
	BS_OK,                      /// project/directory builded whithout errors
	BS_BUILDANDERROR,           /// project is in build, any errors accured
	BS_ERROR,                   /// project/directory builded with errors
	BS_NON,                     /// no state is set
	BS_DELIVERED,               /// project was delivered without errors
	BS_DELIVEREDANDERROR,       /// project was delivered with errors
	BS_FIXED,                   /// errors are fixed
	BS_NOTDELIVERED,            /// project is ready to deliver
	BS_BUILD_PRIO,              /// build projects with prio
	BS_BUILD_ORDER,             /// build project in correct order
	BS_BUILD_DEPEND,            /// build projects using dependencies
	BS_BUILD_DELIVER,           /// build projects using dependencies and deliver builded projects
	BS_BUILD_NORMAL,            /// build projects without using dependencies
	BS_BUILD_DELIVER_NO_DEPEND  /// build projects without using dependencies and deliver builded projects
};

#define LF_STARDIV	"StarDivision"
#define LF_UNIX		"UNIX"
#define LF_MAC		"Macintosh"
#define LF_OS2		"OS/2"

// path conversion
const char* GetDefStandList();
const char* GetIniRoot();
const char* GetIniRootOld();
const char* GetSSolarIni();
const char* GetSSCommon();
const char* GetBServerRoot();

const char* GetEnv( const char *pVar );
const char* GetEnv( const char *pVar, const char *pDefault );

#define CONVERT_R_TO_HOSTFSYS( sPath )	{ sPath.ToLowerAscii().SearchAndReplace( "r:", GetEnv("ISERVERBASE", DEFAULT_INI_ROOT ) ); sPath.SearchAndReplaceAll( "\\", S_PATH_SEPARATOR ); }

#endif
