/*************************************************************************
 *
 *  $RCSfile: ccoll.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: os $ $Date: 2001/06/29 06:06:23 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _CCOLL_HXX
#define _CCOLL_HXX

#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif

#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif

#ifndef _SFXTABDLG_HXX //autogen
#include <sfx2/tabdlg.hxx>
#endif

#ifndef _FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif

#ifndef _BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif

#ifndef _SVTABBX_HXX //autogen
#include <svtools/svtabbx.hxx>
#endif

#ifndef _LSTBOX_HXX //autogen
#include <vcl/lstbox.hxx>
#endif

#ifndef _TOOLS_RESARY_HXX
#include <tools/resary.hxx>
#endif

#include "cmdid.h"

class SwWrtShell;
class SwFmt;
class SwCollCondition;


//***********************************************************

struct CollName {
//		const char* pStr;
		ULONG nCnd;
		ULONG nSubCond;
	};

//***********************************************************

#define COND_COMMAND_COUNT 28

struct CommandStruct
{
	ULONG nCnd;
	ULONG nSubCond;
};


//***********************************************************

class SwCondCollItem : public SfxPoolItem
{
	static CommandStruct		aCmds[COND_COMMAND_COUNT];

	String 						sStyles[COND_COMMAND_COUNT];

public:
	SwCondCollItem(USHORT nWhich = FN_COND_COLL);
	~SwCondCollItem();

								TYPEINFO();

	virtual SfxPoolItem*    	Clone( SfxItemPool *pPool = 0 ) const;
	virtual int             	operator==( const SfxPoolItem& ) const;

	static const CommandStruct*	GetCmds();

	const String&				GetStyle(USHORT nPos) const;
	void						SetStyle( const String* pStyle, USHORT nPos);

};

//***********************************************************

class SwCondCollPage : public SfxTabPage
{
    FixedLine           aConditionFL;
	CheckBox			aConditionCB;

	FixedText			aContextFT;
	FixedText			aUsedFT;
	SvTabListBox 		aTbLinks;

	FixedText			aStyleFT;
	ListBox				aStyleLB;
	ListBox				aFilterLB;

	PushButton			aRemovePB;
	PushButton			aAssignPB;

	String				sNoTmpl;
	ResStringArray 		aStrArr;

	SwWrtShell 			&rSh;
	const CommandStruct*pCmds;
	SwFmt* 				pFmt;

	CollName* 			pNms;

	BOOL 				bNewTemplate;


			SwCondCollPage(Window *pParent, const SfxItemSet &rSet);
	virtual ~SwCondCollPage();

	virtual int     DeactivatePage(SfxItemSet *pSet);

	DECL_LINK( OnOffHdl, CheckBox* );
	DECL_LINK( AssignRemoveHdl, PushButton*);
	DECL_LINK( SelectHdl, ListBox* );

public:

	static SfxTabPage *Create(Window *pParent, const SfxItemSet &rSet);
	static USHORT* GetRanges();

	virtual BOOL FillItemSet(      SfxItemSet &rSet);
	virtual void Reset      (const SfxItemSet &rSet);

	void SetCollection( SwFmt* pFormat, BOOL bNew );
};



#endif

