/*************************************************************************
 *
 *  $RCSfile: sw3page.cxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/17 14:20:31 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#pragma hdrstop

#include "swerror.h"
#include "doc.hxx"

#ifndef _SVSTOR_HXX //autogen
#include <so3/svstor.hxx>
#endif
#ifndef _TOOLS_TENCCVT_HXX //autogen
#include <tools/tenccvt.hxx>
#endif

#ifndef _FMTCOL_HXX //autogen
#include <fmtcol.hxx>
#endif

#ifndef _FMTHDFT_HXX //autogen
#include <fmthdft.hxx>
#endif
#ifndef _FMTPDSC_HXX //autogen
#include <fmtpdsc.hxx>
#endif
#ifndef _HINTS_HXX
#include <hints.hxx>
#endif
#include "sw3imp.hxx"
#include "pagedesc.hxx"
#include "poolfmt.hxx"


////////////////////////////////////////////////////////////////////////////

// Fussnoten-Info einlesen

void Sw3IoImp::InPageFtnInfo( SwPageFtnInfo& rFtn )
{
	INT32 nHeight, nTopDist, nBottomDist, nNum, nDenom;
	INT16 nAdjust, nPenWidth;
	Color aPenColor;
	BYTE cType = Peek();
	if( cType == SWG_FOOTINFO || cType == SWG_PAGEFOOTINFO )
	{
		OpenRec( cType );
		*pStrm >> nHeight
			   >> nTopDist
			   >> nBottomDist
			   >> nAdjust
			   >> nNum >> nDenom
			   >> nPenWidth
			   >> aPenColor;
		CloseRec( cType );
		rFtn.SetHeight( (SwTwips) nHeight );
		rFtn.SetTopDist( (SwTwips) nTopDist );
		rFtn.SetBottomDist( (SwTwips) nBottomDist );
		rFtn.SetAdj( (SwFtnAdj) nAdjust );
		Fraction f( nNum, nDenom );
		rFtn.SetWidth( f );
		rFtn.SetLineColor( aPenColor );
		rFtn.SetLineWidth( nPenWidth );
	}
	else
		Error();
}

// Fussnoten-Info ausgeben

void Sw3IoImp::OutPageFtnInfo( const SwPageFtnInfo& rFtn )
{
	OpenRec( SWG_PAGEFOOTINFO );
	*pStrm << (INT32) rFtn.GetHeight()
		   << (INT32) rFtn.GetTopDist()
		   << (INT32) rFtn.GetBottomDist()
		   << (INT16) rFtn.GetAdj()
		   << (INT32) rFtn.GetWidth().GetNumerator()
		   << (INT32) rFtn.GetWidth().GetDenominator()
		   << (INT16) rFtn.GetLineWidth()
		   << rFtn.GetLineColor();
	CloseRec( SWG_PAGEFOOTINFO );
}

void Sw3IoImp::InPageDescs()
{
	if( Peek() != SWG_STRINGPOOL )
	{
		InHeader( TRUE );
		if( !Good() )
			return;
	}
	else
		nVersion = SWG_FRSTVERSION;
	// Der Stream koennte auch leer sein, falls eine leere Textbaustein-
	// datei eingelesen wird.
	if( Peek() == SWG_STRINGPOOL )
	{
		InStringPool( SWG_STRINGPOOL, aStringPool );

		while( SWG_FIELDTYPE == Peek() )
			InFieldType();

		if( SWG_BOOKMARKS == Peek() )
			InBookmarks();

		if( SWG_REDLINES == Peek() )
			InRedlines();

		// ggfs. dem Numberformatter lesen
		if( SWG_NUMBERFORMATTER == Peek() )
			InNumberFormatter();

		OpenRec( SWG_PAGEDESCS );
		OpenFlagRec();
		USHORT nDesc;
		*pStrm >> nDesc;
		CloseFlagRec();
		if( nDesc > 0 )
		{
			USHORT* pFollows = new USHORT[ nDesc ];
			SwPageDesc** pDescs = new SwPageDesc*[ nDesc ];
			for( USHORT i = 0; i < nDesc; i++ )
				pDescs[ i ] = InPageDesc( pFollows[ i ] );
			// Follows aufloesen
			for( i = 0; i < nDesc; i++ )
			{
				USHORT nFollow = pFollows[ i ];
				SwPageDesc* pDesc = pDescs[ i ];
				if( pDesc && nFollow < IDX_SPEC_VALUE )
					pDesc->SetFollow( FindPageDesc( nFollow ) );
			}
            delete []pDescs;
            delete []pFollows;
		}
		else if( nDesc )
			Error();

#ifdef TEST_HUGE_DOCS
		if( SWG_TESTHUGEDOCS == Peek() )
			InHugeRecord();
#endif

		CloseRec( SWG_PAGEDESCS );

		// Aufraeumen, wenn Seitenvorlagen geladen wurden
		if( bPageDescs )
		{
			SwDBData aOldData(pDoc->_GetDBDesc());

			// fuer Versionen ohne mehrfache Datenbanken wird jetzt der
			// Datenbankname gelesen.
			// if( !nRes && nVersion < SWG_MULTIDB )
			if( !nRes &&
				!IsVersion( SWG_MULTIDB, SWG_EXPORT31, SWG_DESKTOP40 ) )
				SetDBName();
			Cleanup();

			pDoc->ChgDBData( aOldData );
		}
		else if( bOrganizer )
		{
			//JP 18.08.98: Bug 55115 - PageDescAttribute mit ihren Vorlagen
			//				verbinden
			ConnectPageDescAttrs();
			if( gsl_getSystemTextEncoding() != eSrcSet )
				ChangeFontItemCharSet();

			// Temporaere Namenserweiterungen entfernen
			aStringPool.RemoveExtensions( *pDoc );
			ConvertFmtsToStarSymbol();
		}
		// TODO: unicode: is this required really?
		eSrcSet = GetSOLoadTextEncoding( gsl_getSystemTextEncoding(),
										 pStrm->GetVersion() );
	}
}

void Sw3IoImp::SetDBName()
{
	SvStream* pOld = pStrm;
	pContents->Seek( 0L );
	pContents->SetBufferSize( SW3_BSR_CONTENTS );
	pStrm = pContents;

	// Erstmal den Header lesen
	BYTE cLen, cSet;
	INT8 nLCompatVer, nDummy8;
	USHORT nLVersion, nLFileFlags;
	INT32 nDummy32;
	sal_Char cHdrSign[ 8 ];

	Reset2();
	OutputMode( FALSE );

	if( pStrm->Read( cHdrSign, 7 ) != 7 || !CheckHeader(cHdrSign) )
	{
		Error( ERR_SW6_NOWRITER_FILE );
		return;
	}
	*pStrm >> cLen;

	// nRecSizesPos braucht hier nicht gelesen zu werden, da die Methode
	// nicht fuer eine 5.0 ff aufgerufen wird.
	ULONG nOld = pStrm->Tell();
	*pStrm >> nLVersion >> nLFileFlags >> nDummy32 >> nDummy32 >> nDummy32
		   >> nDummy8 >> nDummy8 >> nDummy8 >> nLCompatVer;
	if( nLCompatVer > SWG_CVERSION )
	{
		Error( ERR_SWG_NEW_VERSION );
		return;
	}
	if( nLFileFlags & SWGF_BAD_FILE )
	{
		Error( ERR_SWG_READ_ERROR );
		return;
	}

	pStrm->Read( cPasswd, 16L );
	*pStrm >> cSet >> nDummy8 >> nDummy32 >> nDummy32;
	if( nLFileFlags & SWGF_BLOCKNAME )
	{
		BYTE cBuf[ 64 ];
		if( pStrm->Read( cBuf, 64 ) != 64 )
			pStrm->SetError( SVSTREAM_FILEFORMAT_ERROR );
	}

	ULONG nNew = pStrm->Tell();
	nOld += cLen;
	if( nOld != nNew )
		pStrm->Seek( nOld );

	BOOL bDone = FALSE;

	// Normales Lesen?
	while( !bDone )
	{
		BYTE cType = Peek();
		if( !Good() || pStrm->IsEof() )
			bDone = TRUE;
		else switch( cType )
		{
			case SWG_EOF:
				bDone = TRUE;
				break;

			case SWG_DBNAME:
			{
				String sDBName;
				ByteString s8;
				OpenRec( SWG_DBNAME );

				pStrm->ReadByteString( s8 );
				rtl_TextEncoding eEnc = GetSOLoadTextEncoding(
								(rtl_TextEncoding)cSet, pStrm->GetVersion() );
				sDBName = ConvertStringNoDbDelim( s8, eEnc );
				SwDBData aData;
				aData.sDataSource = sDBName.GetToken(0, DB_DELIM);
				aData.sCommand = sDBName.GetToken(1, DB_DELIM);
				pDoc->ChgDBData( aData );

				ULONG nSaveWarn = nWarn;
				CloseRec( SWG_DBNAME );
				nWarn = nSaveWarn;
			}
			break;

			default:
				SkipRec();
		}
	}

	pStrm = pOld;
	CheckIoError( pContents );
	pContents->SetBufferSize( 0 );
}

void Sw3IoImp::OutPageDescs( BOOL bUsed )
{
	OutHeader();
	CollectFlyFrms( NULL );
	// Stringpool fuellen, Namen im Doc erweitern
	aStringPool.Setup( *pDoc, pStrm->GetVersion(), pExportInfo );
	OutStringPool( SWG_STRINGPOOL, aStringPool );

	// Nicht-Systemfeldtypen
	if( !nRes ) OutFieldTypes();

	// Bookmarks (nicht, wenn ein SW2-TextBlockDoc konvertiert wird)
	// Wenn nicht nach 3.1 exportiert wird, werden nur die Bookmarks
	// der Seitenvorlagen geschrieben
	if( !nRes && !( nGblFlags & SW3F_CONVBLOCK ) )
		OutBookmarks( TRUE );

	if( !nRes && !IsSw31Or40Export() )
		OutRedlines( TRUE );

	// Numberformatter schreiben bei normalen Dokumenten. Bei Textbausteinen
	// erfolgt es im SaveDocContents
	if( !nRes && !IsSw31Export() && !bBlock )
		OutNumberFormatter();

	USHORT nArrLen = pDoc->GetPageDescCnt();
	USHORT nCnt = 0;
	if( bUsed )
	{
		for( USHORT n = 0; n < nArrLen; n++ )
		{
			const SwPageDesc& rDesc = pDoc->GetPageDesc( n );
			if( pDoc->IsUsed( rDesc ) )
				nCnt++;
		}
	}
	else
		nCnt = nArrLen;

	OpenRec( SWG_PAGEDESCS );
	*pStrm << (BYTE)  0x02
		   << (INT16) nCnt;
	if( bUsed )
	{
		for( USHORT n = 0; n < nArrLen; n++ )
		{
			const SwPageDesc& rDesc = pDoc->GetPageDesc( n );
			if( pDoc->IsUsed( rDesc ) )
				OutPageDesc( rDesc );
		}
	}
	else for( USHORT n = 0; n < nArrLen; n++ )
	  OutPageDesc( pDoc->GetPageDesc( n ) );

#ifdef TEST_HUGE_DOCS
	BOOL b = FALSE;
	if( b )
		OutHugeRecord( 1024, 32*1024 );
#endif

	CloseRec( SWG_PAGEDESCS );

	// Temporaere Namenserweiterungen entfernen
	aStringPool.RemoveExtensions( *pDoc );

	// Die Redlines der Seiten-Vorlagen werden jetzt nicht mehr gebraucht
	// und muessen sogar geloescht werden, weil die Indizierung im
	// Content-Bereich wieder mit 0 anfaengt.
	if( pRedlines && nCntntRedlineStart )
	{
		pRedlines->Remove( 0, nCntntRedlineStart );
		nCntntRedlineStart = 0;
	}
}

// Seitenvorlage einlesen

SwPageDesc* Sw3IoImp::InPageDesc( USHORT& nFollow )
{
	OpenRec( SWG_PAGEDESC );
	short nUsedOn;
	// 0x10 - Landscape mode
	BYTE cFlags = OpenFlagRec();
	USHORT nIdx = 0, nPoolId = 0;
	USHORT nRegCollIdx = IDX_NO_VALUE;
	BYTE nNumType;
	*pStrm >> nIdx >> nFollow >> nPoolId >> nNumType >> nUsedOn;
	if( IsVersion( SWG_REGISTER, SWG_EXPORT31, SWG_DESKTOP40 ) )
		*pStrm >> nRegCollIdx;
	CloseFlagRec();
	if( nRes )
		return NULL;

	const String& rName = aStringPool.Find( nIdx );
	SwPageDesc* pDesc = NULL;
	// Gibt es diese Vorlage bereits?
	BOOL bPresent = FALSE;
	USHORT nPos=0;
	if( bInsert )
	{
		USHORT nArrLen = pDoc->GetPageDescCnt();
		for( nPos = 0; nPos < nArrLen; nPos++ )
		{
			pDesc = &pDoc->_GetPageDesc( nPos );
			if( pDesc->GetName() == rName )
			{
				bPresent = TRUE; break;
			}
		}
		if( bPresent && bAdditive )
		{
			// Nur hinzufuegen: lass die Vorlage in Ruhe!
			// Dabei geht nichts verloren, also nWarn retten
			ULONG nWarnSave = nWarn;
			CloseRec( SWG_PAGEDESC );
			nWarn = nWarnSave;
			return NULL;
		}
	}
	if( bPresent )
		// Ueberplaetten im Insert Mode: wir brauchen eine Kopie
		pDesc = new SwPageDesc( *pDesc );
	else
	{
		// Sonst bauen wir uns eine
		if( nPoolId != IDX_NO_VALUE )
		{
			// Fehlerfall: unbekannte Poolvorlage -> neu anlegen
			if( RES_POOLPAGE_BEGIN > nPoolId ||  nPoolId >= RES_POOLPAGE_END )
			{
				ASSERT( !this, "ungueltige Id" );
				nPoolId = IDX_NO_VALUE;
			}
		}

		if( nPoolId != IDX_NO_VALUE )
			pDesc = pDoc->GetPageDescFromPool( nPoolId );
		else
			pDesc = &pDoc->_GetPageDesc( pDoc->MakePageDesc( rName ) );
	}

	SvxNumberType aType;
	aType.SetNumberingType(nNumType);
	pDesc->SetNumType( aType );
	pDesc->WriteUseOn( UseOnPage( nUsedOn ) );
	pDesc->SetLandscape( BOOL( ( cFlags & 0x10 ) != 0 ) );
	if( nPoolId != IDX_NO_VALUE )
		pDesc->SetPoolFmtId( nPoolId );

	if( nRegCollIdx != IDX_NO_VALUE )
		pDesc->SetRegisterFmtColl( FindTxtColl( nRegCollIdx ) );

	pDesc->ResetAllMasterAttr();
	pDesc->ResetAllLeftAttr();
	// Header und Footer sind Shared-Formate
	nGblFlags |= SW3F_SHAREDFMT;
	short nAttrSet = 0;
	while( BytesLeft() )
	{
		BYTE cType = Peek();
		switch( cType )
		{
			case SWG_FOOTINFO:
			case SWG_PAGEFOOTINFO:
				InPageFtnInfo( pDesc->GetFtnInfo() ); break;
			case SWG_ATTRSET:
				switch( ++nAttrSet )
				{
					case 1:	InAttrSet( (SwAttrSet&) pDesc->GetMaster().GetAttrSet() );
							break;
					case 2: InAttrSet( (SwAttrSet&) pDesc->GetLeft().GetAttrSet() );
							break;
					default: Error(); OpenRec( cType ); CloseRec( cType );
				} break;
			default:
				SkipRec();
		}
	}
	CloseRec( SWG_PAGEDESC );
	// Hdr/Ftr-Formate umsetzen:
	if( pDesc->IsHeaderShared() )
	{
		const SwFmtHeader& rFmtM = pDesc->GetMaster().GetHeader();
		pDesc->GetLeft().SetAttr( rFmtM );
	}
	if( pDesc->IsFooterShared() )
	{
		const SwFmtFooter& rFmtM = pDesc->GetMaster().GetFooter();
		pDesc->GetLeft().SetAttr( rFmtM );
	}
	nGblFlags &= ~SW3F_SHAREDFMT;

	if( bPresent )
	{
		// Kopie uebernehmen
		pDoc->ChgPageDesc( nPos, *pDesc );
		delete pDesc;
		pDesc = &pDoc->_GetPageDesc( nPos );
	}

	return pDesc;
}

void Sw3IoImp::OutPageDesc( const SwPageDesc& rPg )
{
	const SwPageDesc* p;
	// 0x10 - Landscape mode
	BYTE cFlags = IsSw31Export() ? 0x09: 0x0b; 	// diverse Daten
	if( rPg.GetLandscape() )
		cFlags |= 0x10;
	USHORT nIdx, nFollow = IDX_NO_VALUE, nPoolId = rPg.GetPoolFmtId();
	USHORT nRegCollIdx = IDX_NO_VALUE;
	nIdx = aStringPool.Add( rPg.GetName(), nPoolId );
	p = rPg.GetFollow();
	if( p )
		nFollow = aStringPool.Add( p->GetName(), p->GetPoolFmtId() );

	const SwTxtFmtColl *pRegFmtColl = rPg.GetRegisterFmtColl();
	if( pRegFmtColl )
		nRegCollIdx = aStringPool.Add( pRegFmtColl->GetName(),
									   pRegFmtColl->GetPoolFmtId() );


	OpenRec( SWG_PAGEDESC );
	*pStrm << (BYTE)   cFlags
		   << (UINT16) nIdx
		   << (UINT16) nFollow
		   << (UINT16) nPoolId
		   << (BYTE)   rPg.GetNumType().GetNumberingType()
		   << (UINT16) rPg.ReadUseOn();
	if( !IsSw31Export() )
		*pStrm << (UINT16) nRegCollIdx;

	OutPageFtnInfo( rPg.GetFtnInfo() );
	// Formate (evtl. mit Unterdrueckung von Hdr/Ftr-Formaten)
	// Diese Unterdrueckung wird auch in den Attr-Schreiberoutinen
	// verwendet!
	OutAttrSet( rPg.GetMaster().GetAttrSet() );
	USHORT nOldFlags = nGblFlags;
	if( rPg.IsHeaderShared() ) nGblFlags |= SW3F_NOHDRFMT;
	if( rPg.IsFooterShared() ) nGblFlags |= SW3F_NOFTRFMT;
	OutAttrSet( rPg.GetLeft().GetAttrSet() );
	nGblFlags = nOldFlags;
	CloseRec( SWG_PAGEDESC );
}

// PageDesc-Attribute koennen in einer Absatzvorlage vorkommen; diese
// werden vor den Seitenvorlagen eingelesen, so dass eine Vorwaerts-
// Referenz entsteht. Die Einleseroutine legt den Stringpool-Index
// des Vorlagennamens im Attribut ab. Nach dem Einlesen muss die Vorlage
// dann noch verbunden werden.

// Aufloesen aller Seitenbeschreibungs-Attribute
// Die Attribute werden aus dem Pool entnommen und die
// korrekten Seitenvorlagen werden eingetragen.

void Sw3IoImp::ConnectPageDescAttrs()
{
	SfxItemPool& rPool = pDoc->GetAttrPool();
	USHORT nArrLen = rPool.GetItemCount( RES_PAGEDESC );
	for( USHORT n = 0; n < nArrLen; n++ )
	{
		SwFmtPageDesc* pAttr =
			(SwFmtPageDesc*) rPool.GetItem( RES_PAGEDESC, n );
		if( pAttr && pAttr->GetDescNameIdx() != IDX_NO_VALUE )
		{
			SwPageDesc* pDesc = FindPageDesc( pAttr->GetDescNameIdx() );
			pAttr->SetDescNameIdx( IDX_NO_VALUE );
			ASSERT( pDesc, "Unbekannte Seitenvorlage fuer PageDesc-Attribut" );
			if( pDesc )
			{
				pDesc->Add( pAttr );
				if( bInsert && pAttr->GetDefinedIn() )
				{
					// dann sollte das Layout auch etwas davon mitbekommen.
					if( pAttr->GetDefinedIn()->ISA( SwTxtFmtColl ) )
					{
						const SwTxtFmtColl *pColl =
							static_cast< const SwTxtFmtColl * >( pAttr->GetDefinedIn() );
						SwAttrSet aChgSet( *pColl->GetAttrSet().GetPool(), RES_PAGEDESC, RES_PAGEDESC );
						aChgSet.Put( *pAttr );
						SwAttrSetChg aOld( pColl->GetAttrSet(), aChgSet );
						SwAttrSetChg aNew( pColl->GetAttrSet(), aChgSet );

						const_cast < SwTxtFmtColl *>( pColl )->Modify( &aOld, &aNew );

					}
					else
					{
						((SwModify*)pAttr->GetDefinedIn())->SwModify::Modify( pAttr, pAttr );
					}
				}
			}
		}
	}
}


