/*************************************************************************
 *
 *  $RCSfile: multipro.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 15:02:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _MULTIPRO_HXX
#include "multipro.hxx"
#endif
#ifndef _SVDOGRP_HXX
#include <svdogrp.hxx>
#endif
#ifndef _SVDPAGE_HXX
#include <svdpage.hxx>
#endif
#ifndef _SVX_FMOBJ_HXX
#include "fmobj.hxx"
#endif
#ifndef _SVX_FMTOOLS_HXX
#include "fmtools.hxx"
#endif
#ifndef _SVX_FMPROP_HXX
#include "fmprop.hxx"
#endif
#ifndef _SVDITER_HXX
#include "svditer.hxx"
#endif

//.........................................................................
namespace svxform
{
//.........................................................................

	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::beans;
	using namespace ::com::sun::star::lang;
	using namespace ::com::sun::star::form;
	using namespace ::com::sun::star::container;
	using namespace ::comphelper;

	//==============================================================================
	//= OPropertySetComposerCallback
	//==============================================================================
	class OPropertySetComposerCallback : public IPropertySetComposerCallback
	{
	public:
		virtual sal_Bool isComposeable(const ::rtl::OUString& _rPropertyName) const;
	};

	//------------------------------------------------------------------------------
	sal_Bool OPropertySetComposerCallback::isComposeable(const ::rtl::OUString& _rPropertyName) const
	{
		return FmPropertyInfoService::getPropertyMultiFlag( _rPropertyName );
	}

	static OPropertySetComposerCallback s_aFormPropertyInfo;

	//==============================================================================
	//= FmXMultiSet
	//==============================================================================
	//------------------------------------------------------------------------------
	Any SAL_CALL FmXMultiSet::queryInterface( const Type& _rType ) throw(RuntimeException)
	{
		Any aReturn = FmXMultiSet_Base::queryInterface(_rType);
		if (!aReturn.hasValue())
			aReturn = ::cppu::queryInterface(_rType,
				static_cast< XFormComponent* >(this),
				static_cast< XChild* >(this)
			);
		return aReturn;
	}

	//------------------------------------------------------------------------------
	FmXMultiSet* FmXMultiSet::Create(const SdrMarkList& _rMarkList)
	{
		PropertySetArray aSets;

		sal_uInt32 nMarkCount = _rMarkList.GetMarkCount();

		for(sal_uInt32 i=0;i<nMarkCount;i++)
		{
			SdrObject* pCurrent = _rMarkList.GetMark(i)->GetObj();

			SdrObjListIter* pGroupIterator = NULL;
			if (pCurrent->IsGroupObject())
			{
				pGroupIterator = new SdrObjListIter(*pCurrent->GetSubList());
				pCurrent = pGroupIterator->IsMore() ? pGroupIterator->Next() : NULL;
			}

			while (pCurrent)
			{
				FmFormObj* pAsFormObject = PTR_CAST(FmFormObj, pCurrent);
				if (pAsFormObject)
				{
					Reference< XPropertySet > xControlModel(pAsFormObject->GetUnoControlModel(), UNO_QUERY);
					if (xControlModel.is())
						aSets.push_back(xControlModel);
				}

				// next element
				pCurrent = pGroupIterator && pGroupIterator->IsMore() ? pGroupIterator->Next() : NULL;
			}
			if (pGroupIterator)
				delete pGroupIterator;
		}
		return new FmXMultiSet(Sequence< Reference< XPropertySet > >(aSets.begin(), aSets.size()));
	}

	//------------------------------------------------------------------------------
	void SAL_CALL FmXMultiSet::acquire(  ) throw()
	{
		FmXMultiSet_Base::acquire();
	}

	//------------------------------------------------------------------------------
	void SAL_CALL FmXMultiSet::release(  ) throw()
	{
		FmXMultiSet_Base::release();
	}

	//------------------------------------------------------------------------------
	FmXMultiSet::FmXMultiSet(const Sequence< Reference< XPropertySet > >& _rPropertySets)
		:FmXMultiSet_Base(_rPropertySets, &s_aFormPropertyInfo)
	{
		// initially set our parent, if all sets have one and have the same one
		m_xParent = NULL;
		for (sal_Int32 i=0; i<m_aSingleSets.size(); ++i)
		{
			Reference< XChild > xChild(m_aSingleSets[i], UNO_QUERY);
			if (xChild.is())
			{
				if (0 == i)
					m_xParent = Reference< XInterface >(xChild->getParent(), UNO_QUERY);
				else
					if (Reference< XInterface >(xChild->getParent(), UNO_QUERY).get() != m_xParent.get())
						m_xParent = NULL;
			}
			else
				m_xParent = NULL;
		}
	}

	//------------------------------------------------------------------------------
	Reference< XInterface > SAL_CALL FmXMultiSet::getParent(  ) throw(RuntimeException)
	{
		return m_xParent;
	}

	//------------------------------------------------------------------------------
	void SAL_CALL FmXMultiSet::setParent( const Reference< XInterface >& _rxParent ) throw(NoSupportException, RuntimeException)
	{
		m_xParent = _rxParent;
	}

//.........................................................................
}	// namespace svxform
//.........................................................................

