/*************************************************************************
 *
 *  $RCSfile: mnumgr.hxx,v $
 *
 *  $Revision: 1.15 $
 *
 *  last change: $Author: vg $ $Date: 2003/05/28 13:23:35 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SFXMNUMGR_HXX
#define _SFXMNUMGR_HXX

#include <stdarg.h>

#ifndef _MENU_HXX //autogen //wg. MENU_APPEND !!!!
#include <vcl/menu.hxx>
#endif
#ifndef _SV_WINTYPES_HXX
#include <vcl/wintypes.hxx>
#endif
#ifndef _LINK_HXX //autogen
#include <tools/link.hxx>
#endif

#include <tools/stream.hxx>
#include "cfgitem.hxx"
#include "sfx.hrc"

class SfxMenuCfgItemArr;
class SfxMenuCfgItemArrStack;
class SfxVirtualMenu;
class SfxPoolItem;
class SfxBindings;
class SfxMenuIter_Impl;
class ResMgr;
class Menu;
class MenuBar;
class PopupMenu;
class SfxBindings;
class ResId;
class SvVerbList;
class Point;
class SfxObjectShell;
class SfxModule;
class SfxViewFrame;

class SfxMenuManager : public SfxConfigItem
{
friend class SfxPopupMenuManager;
friend class SfxMenuBarManager;

	SfxVirtualMenu* 		pMenu;			// das eigentliche Menu
	SfxVirtualMenu* 		pOldMenu;		// only while reconfiguring
	BOOL					bMenuBar;		// Popup oder MenuBar
	SfxMenuIter_Impl*		pIterator;		// Iterator zum Auslesen
	SfxMenuCfgItemArr*		pCfg;
	SfxMenuCfgItemArrStack* pCfgStack;
	SfxBindings*			pBindings;
	ResMgr* 				pResMgr;
	BOOL                    bOLE : 1;
	BOOL					bAddClipboardFuncs : 1;

	void					Construct( SfxVirtualMenu& rMenu );
	void					ConstructSvMenu ( Menu*, SfxMenuCfgItemArr& );
    static void             ConstructSvMenu ( Menu*, SvStream&, BOOL, BOOL );

    int                     Load( SvStream& rStream );
    BOOL                    Store( SvStream& rStream );

protected:
                            SfxMenuManager( Menu*, SfxBindings& );
                            SfxMenuManager( const ResId&, SfxBindings&, SfxConfigManager*, BOOL );
							~SfxMenuManager();
    USHORT                  GetItemPos( USHORT nId );
public:

    static Menu*            LoadMenu( SvStream& rStream );
    static BOOL             StoreMenu( SvStream& rStream, Menu* pMenu, SfxModule* pMod );
    virtual int             Load( SotStorage& );
    virtual BOOL            Store( SotStorage& );
	virtual void			UseDefault();
    virtual String          GetStreamName() const;

	static void				EraseItemCmds( Menu* ); // Used for 6.0/src641 compatibility
	static void				RestoreMacroIDs( Menu* pMenu );

	DECL_LINK( Select, Menu* );

	SfxVirtualMenu* 		GetMenu() const
							{ return pMenu; }

	SfxBindings&			GetBindings() { return *pBindings; }
	const SfxBindings&		GetBindings() const { return *pBindings; }
	void					SetResMgr(ResMgr* pMgr)  {pResMgr = pMgr; }
    ResMgr*                 GetResMgr() const { return pResMgr; }
	void					SetPopupMenu( USHORT nId, PopupMenu *pMenu );

	// reading out the menu
	BOOL    FirstItem();         // resets the item iterator, FALSE if none
	BOOL    NextItem();          // skips to the next item, FALSE if no more
	BOOL    IsBinding() const;   // TRUE if current item is a binding
	BOOL    IsSeparator() const; // TRUE if current item is a separator
	BOOL    IsPopup() const;     // TRUE if current item is a popup
	USHORT  GetLevel() const;    // returns sub-menu-level
	USHORT	GetItemId() const;	 // id of binding if IsBinding()
	String  GetTitle() const;    // text
	String  GetHelpText() const; // HilfeText
	String	GetCommand() const;

	// reconfiguring the menu
	void SetForceCtrlCreateMode( BOOL bCreate = TRUE );
	void Clear();                           // call this before reconfiguring
	void Reconfigure();                     // call this after reconfiguring
	void AppendItem(const String &rText, const String &rHelpText, USHORT nId, const String& rCommand );	// append a binding by function-id
	void AppendSeparator();                 // append a separator
	void EnterPopup(const String& rTitle,  // append a popup (sub)-menu
					const String &rHelpText,
					USHORT nId = 0 );      //      with MDI/Pick etc.
	void LeavePopup();                      // end a sub-menu
	void InvalidateKeyCodes();				// called from SfxAcceleratorManager

	static BOOL 	IsPopupFunction( USHORT nId );
	void            InsertVerbs(const SvVerbList *pVerblist);

#if _SOLAR__PRIVATE
	void			Construct_Impl( Menu* pMenu, BOOL bWithHelp );
#endif
};

//--------------------------------------------------------------------

class SfxPopupMenuManager : public SfxMenuManager
{
private:
	DECL_LINK( SelectHdl, void * );
	Menu*				pSVMenu;

public:
                        SfxPopupMenuManager( const ResId&, SfxBindings& );
                        SfxPopupMenuManager( PopupMenu*, SfxBindings& );
    static void         ExecutePopup( const ResId&, SfxViewFrame* pViewFrame, const Point& rPoint, Window* pWindow );

	USHORT				Execute( const Point& rPos, Window *pWindow );
    USHORT              Execute( const Point& rPoint, Window* pWindow, va_list pArgs, const SfxPoolItem *pArg1 );
    USHORT              Execute( const Point& rPoint, Window* pWindow, const SfxPoolItem *pArg1 ... );

	void				StartInsert();
	void				EndInsert();
	void				CheckItem( USHORT, BOOL );
	void				RemoveItem( USHORT );
	void 				InsertItem( USHORT, const String&, MenuItemBits,
								USHORT nPos = MENU_APPEND );
	void 				InsertSeparator( USHORT nPos = MENU_APPEND );
	void				RemoveDisabledEntries();
	void				AddClipboardFunctions();
};

//--------------------------------------------------------------------

class SfxMenuBarManager : public SfxMenuManager
{
private:
	struct SfxObjectMenu_Impl
	{
		USHORT					nId;
		ResMgr* 				pResMgr;
		SfxPopupMenuManager*	pPMMgr;
	};

	SfxObjectMenu_Impl			aObjMenus[4];
    SystemWindow*               pWindow;
    BOOL                        bDowning;

public:
//    SfxMenuBarManager( SfxBindings& rBindings, BOOL bPlugin = FALSE );
    SfxMenuBarManager( const ResId&, SfxBindings& rBindings, SfxConfigManager*, BOOL bOLE );
    SfxMenuBarManager( const SfxMenuBarManager& rOther, SfxConfigManager* );
	~SfxMenuBarManager();

	static MenuBar*	LoadMenuBar( SvStream& rStream );
	static BOOL		StoreMenuBar( SvStream& rStream, MenuBar* pMenuBar );

    virtual BOOL        	ReInitialize();
    virtual int             Load( SotStorage& );
    virtual BOOL            Store( SotStorage& );
//    BOOL            Load( SvStream& rStream, BOOL bOLEServer=FALSE );
//    static SvStream* GetDefaultStream( StreamMode );
	void			ResetObjectMenus();
	void			SetObjectMenu( USHORT nPos, const ResId& rResId );
	PopupMenu*		GetObjectMenu( USHORT nPos, USHORT& rConfigId );
	void            UpdateObjectMenus();
	MenuBar*		GetMenuBar() const;
	void			ReconfigureObjectMenus();
    SystemWindow*   GetWindow() const { return pWindow; }
};

#endif // #ifndef _SFXMNUMGR_HXX


